#include "colors.inc"

#global_settings { assumed_gamma 2.3 }

union
{

#declare N=5;

#declare X=-N;
#while (X<N)
  #declare Y=-N;
  #while (Y<N)
    cylinder { -10000*z+x*X+y*Y, 10000*z+x*X+y*Y, .05 }
    #declare Y=Y+1;
  #end
  #declare X=X+1;
#end

#declare X=-N;
#while (X<N)
  #declare Z=-N;
  #while (Z<N)
    cylinder { -10000*y+x*X+z*Z, 10000*y+x*X+z*Z, .05 }
    #declare Z=Z+1;
  #end
  #declare X=X+1;
#end


#declare Z=-N;
#while (Z<N)
  #declare Y=-N;
  #while (Y<N)
    cylinder { -10000*x+y*Y+z*Z, 10000*x+y*Y+z*Z, .05 }
    #declare Y=Y+1;
  #end
  #declare Z=Z+1;
#end

#declare X=-N;
#while (X<N)
  #declare Y=-N;
  #while (Y<N)
    #declare Z=-N;
    #while (Z<N)
      sphere { <X,Y,Z>,0.15 }
      #declare Z=Z+1;
    #end
    #declare Y=Y+1;
  #end
  #declare X=X+1;
#end
      
texture
{
  pigment 
  { 
    spherical 
    poly_wave 0.33
    color_map 
    { 
      [0 Black]
      [0.6 Black]
      [0.85 White]
      [1 White]
    }
    scale 8
    translate <2,0.1,2.3>
  }
  finish { ambient 1 }
}

no_shadow

}

camera 
{
  location <0.6,2.7,-1.9>
  angle 150
  look_at <2,0.1,2.3>
  ultra_wide_angle
}  



