#include "colors.inc"

#global_settings { assumed_gamma 2.3 }

union
{

#declare N=5;

#declare X=-N;
#while (X<N)
  #declare Y=-N;
  #while (Y<N)
    cylinder { -10000*z+x*X+y*Y, 10000*z+x*X+y*Y, .05 }
    #declare Y=Y+1;
  #end
  #declare X=X+1;
#end

#declare X=-N;
#while (X<N)
  #declare Z=-N;
  #while (Z<N)
    cylinder { -10000*y+x*X+z*Z, 10000*y+x*X+z*Z, .05 }
    #declare Z=Z+1;
  #end
  #declare X=X+1;
#end


#declare Z=-N;
#while (Z<N)
  #declare Y=-N;
  #while (Y<N)
    cylinder { -10000*x+y*Y+z*Z, 10000*x+y*Y+z*Z, .05 }
    #declare Y=Y+1;
  #end
  #declare Z=Z+1;
#end

#declare X=-N;
#while (X<N)
  #declare Y=-N;
  #while (Y<N)
    #declare Z=-N;
    #while (Z<N)
      sphere { <X,Y,Z>,0.15 }
      #declare Z=Z+1;
    #end
    #declare Y=Y+1;
  #end
  #declare X=X+1;
#end
      
texture
{
  pigment { Gray90 } 
  finish 
  { 
    diffuse 0.9 brilliance 2.25
    ambient 0.1 
    specular 0.5 roughness 0.005
    phong 0.125 phong_size 15 
    reflection 0.5 
    metallic on
  }
}

no_shadow

}

sphere 
{ 0, 1 
  hollow
  pigment { Clear }
  interior
  {
    media
    {
      emission 3
      intervals 10
      samples 1, 10
      confidence 0.99999
      variance 0.0001
      density 
      { 
        spherical 
        color_map 
        {
          [0 Black]
          [1 White]
        }
      }
      density
      {
        bozo
        sine_wave
        phase 0.25
        color_map 
        {
          [0 Black]
          [0.25 Cyan]
          [0.5 Blue]
          [1 White]
        }

        scale 0.1
        warp { black_hole 0, 1 strength 1 }
      }
    }
  }
  scale 7
  translate <2,0.1,2.3>
}

camera 
{ 
  location <0.6,2.7,-1.9>
  angle 150
  look_at <2,0.1,2.3>
  ultra_wide_angle
}

fog { color Black distance 5 }