//LEGO include file -- decorative
//by David Fontaine
//
// head                         minifig head
// torso                        minifig torso
// shirt                        minifig torso shirt paint
// right_arm                    minifig arm right
// left_arm.....................minifig arm left
// hand                         minifig hand
// right_leg                    minifig leg right
// left_leg                     minifig leg left
// figconnect                   minifig leg connector
// sword....................... 4-long dark gray sword
// axe                          6-long axe
// axe2                         9-long axe*
// crossbow                     crossbow
// bow                          bow
// quiver.......................quiver
// torch                        torch
// lantern                      lantern shaft piece
// goblet                       goblet
// shield                       shield
// joust........................jousting stick
// flagpole                     5-long flagpole
// flag                         flat square flag (small)
// banner                       wavy pennant flag
// horse                        horse*
// horsesheet...................cloth for horse*
// barrel                       barrel
// spout                        barrel tap
// chest                        treasure chest
// chestlid                     treasure chest lid
// helmet_bars                  helmet w/ bars*
// helmet_shield................hinged mask*
// helmet_ball                  goes inside hinged mask*
// helmet_can                   cylindrical helmet w/ rectangle slit
// helmet_archer                flared helmet
// armor                        armor body plate*
// foresthat....................forest-man hat
// feather_big                  large hat feather*
// feather_small                small hat feather
// feather_three                triple hat feather*
// dragon_right                 right wing dragon-hat deco.*
// dragon_left..................left wing dragon hat deco.*
// dragon_top                   dragon hat deco.*
// goldpiece                    gold coin*
// spear                        spear*
// shoulderpads                 shoulder fringe thing*
// cape.........................cape*
// doorwood                     wooden arch door (do not texture)
// palmtrunk                    palm-tree trunk segment
// palmbase                     palm-tree trunk base
// bigbranch                    large green branch
// smallbranch..................small green branch
// treesphere                   spherical tree*
// treecone                     conical tree*
// treeconesmall                small conical tree*
// 
// *--incomplete

#declare head = difference {
        merge {
                cylinder { <0,0,0>,<0,1.1,0>,.407 }
                cylinder { <0,.5,0>,<0,1.2,0>,.457 }
                torus { .457,.193 translate <0,.343,0> }
                cylinder { <0,.343,0>,<0,1.007,0>,.65 }
                torus { .457,.193 translate <0,1.007,0 > }
                object { bump translate <0,1.2,0> }
                }
        cylinder { <0,-1,0>,<0,1,0>,.3 }
        bounded_by { cylinder { <0,0,0>,<0,1.4,0>,.65 } }
}
#declare T_BeardHead = texture {
        LegoYellow
        
}        
#declare plainhead = object { head texture { LegoYellow }  
        texture { pigment { image_map { gif "smilehead.gif" map_type 2 filter 215,1 once } } rotate -90*y scale <1,.66,1> translate <0,.343,0> } }
#declare beardhead = object { head texture { LegoYellow }
        texture { pigment { image_map { gif "beardface.gif" once filter 3,1 } rotate 2*z scale <1.3,1,1> translate <-.61,.15,0> } }
        texture { pigment { image_map { gif "headmask.gif" map_type 2 filter 215,1 once } } rotate 90*y scale <1,3,1> finish { reflection .07 reflection_exponent 0.8 specular .9 roughness .005 ambient .2 diffuse .7 } } }
#declare piratehead = object { head texture { LegoYellow }
        texture { pigment { image_map { gif "piratehead.gif" once filter 215,1 } rotate -2*z scale <1.3,1.05,1> translate <-.65,.15,0> } }
        texture { pigment { image_map { gif "headmask.gif" map_type 2 filter 215,1 once } } rotate 90*y scale <1,1.2,1> finish { reflection .07 reflection_exponent 0.8 specular .9 roughness .005 ambient .2 diffuse .7 } } }
#declare torsoqqq = difference {
        union {
                cylinder { <-.882,.098,.15>,<.882,.098,.15>,.1 }
                cylinder { <.882,.098,.15>,<.618,1.502,.15>,.1 }
                cylinder { <.618,1.502,.15>,<-.618,1.502,.15>,.1 }
                cylinder { <-.618,1.502,.15>,<-.882,.098,.15>,.1 }
                cylinder { <-.882,.098,.85>,<.882,.098,.85>,.1 }
                cylinder { <.882,.098,.85>,<.618,1.502,.85>,.1 }
                cylinder { <.618,1.502,.85>,<-.618,1.502,.85>,.1 }
                cylinder { <-.618,1.502,.85>,<-.882,.098,.85>,.1 }
                cylinder { <-.882,.098,.15>,<-.882,.098,.85>,.1 }
                cylinder { <.882,.098,.15>,<.882,.098,.85>,.1 }
                cylinder { <.618,1.502,.15>,<.618,1.502,.85>,.1 }
                cylinder { <-.618,1.502,.15>,<-.618,1.502,.85>,.1 }
                sphere { <-.882,.098,.15>,.1 }
                sphere { <.882,.098,.15>,.1 }
                sphere { <.618,1.502,.15>,.1 }
                sphere { <-.618,1.502,.15>,.1 }
                sphere { <-.882,.098,.85>,.1 }
                sphere { <.882,.098,.85>,.1 }
                sphere { <.618,1.502,.85>,.1 }
                sphere { <-.618,1.502,.85>,.1 }
                prism { -.05,-.95,5 <-.882,.098>,<.882,.098>,<.618,1.502>,<-.618,1.502>,<-.882,.098> rotate -90*x }
                prism { -.15,-.85,5 <-.982,.098>,<.982,.098>,<.718,1.502>,<-.718,1.502>,<-.982,.098> rotate -90*x }
                prism { -.15,-.85,5 <-.9,0>,<.9,0>,<.6,1.6>,<-.6,1.6>,<-.9,0> rotate -90*x }
                cylinder { <0,1.5,.5>,<0,2.4,.5>,.3 }
                box { <-.882,-.002,.05>,<.882,.098,.95> }
                box { <-.982,-.002,.15>,<.982,.098,.85> }
                cylinder { <-.882,-.002,.15>,<-.882,.098,.15>,.1 }
                cylinder { <.882,-.002,.15>,<.882,.098,.15>,.1 }
                cylinder { <-.882,-.002,.85>,<-.882,.098,.85>,.1 }
                cylinder { <.882,-.002,.85>,<.882,.098,.85>,.1 }
                }
        difference {
                prism { -.1,1.5,6 <-2,.2>,<-.3,.2>,<0,.5>,<-.3,.8>,<-2,.8>,<-2,.2> }
                box { <-2,-1,-1>,<-.8,3,2> rotate -11*z }
                }
        difference {
                prism { -.1,1.5,6 <2,.2>,<.3,.2>,<0,.5>,<.3,.8>,<2,.8>,<2,.2> }
                box { <2,-1,-1>,<.8,3,2> rotate 11*z }
                }
        box { <-.2,-1,.2>,<.2,1.5,.8> }
        cylinder { <-2,1.2,.5>,<2,1.2,.5>,.25 }
        bounded_by { box { <-1,0,0>,<1,2.5,1> } }
}
#declare torso = difference {
        object { torsoqqq }
        box { <-3,-3,.08>,<3,5,-5> }
        bounded_by { box { <-1,0,0>,<1,2.5,1> } }
}
#declare shirt = difference {
        object { torsoqqq }
        box { <-3,-3,.085>,<3,5,5> }
        bounded_by { box { <-1,0,0>,<1,2.5,1> } }
}
#declare left_arm = difference {
        merge {
                sphere { <.7,0,.5>,.3 }
                cylinder { <.7,0,.5>,<1,-.4,.8>,.3 }
                cylinder { <1.05,-.4,.8>,<1.25,-1.15,.63>,.25 }
                sphere { <0,-.4,.8>,.3 translate 1*x }
                }
        cylinder { <1.05,-.4,.8>,<1.39,-1.7,.5>,.15 }                
        prism { -2,1,5 <-1,0>,<1,0>,<.7,1.6>,<-.7,1.6>,<-1,0> rotate -90*x translate -1.2*y }
        bounded_by { cylinder { <1,1,.5>,<1,-1.6,.5>,.7 } }
}
#declare right_arm = difference {
        merge {
                sphere { <-.7,0,.5>,.3 }
                cylinder { <-.7,0,.5>,<-1,-.4,.8>,.3 }
                cylinder { <-1.05,-.4,.8>,<-1.25,-1.15,.63>,.25 }
                sphere { <0,-.4,.8>,.3 translate -1*x }
                }
        cylinder { <-1.05,-.4,.8>,<-1.39,-1.7,.5>,.15 }                
        prism { -2,1,5 <-1,0>,<1,0>,<.7,1.6>,<-.7,1.6>,<-1,0> rotate -90*x translate -1.2*y }
        bounded_by { cylinder { <-1,1,.5>,<-1,-1.6,.5>,.7 } }
}
#declare hand = difference {
        merge {
                cylinder { <0,0,.25>,<0,0,.75>,.3 }
                difference {
                        cylinder { <.25,1.2,.8>,<-.09,-.1,.5>,.15 }
                        box { <-1,1.5,-1>,<1,3,2> }
                        }
                rotate 10.6*z               
                }
        cylinder { <0,0,-1>,<0,0,2>,.2 }
        box { <-.15,-1,-1>,<.15,0,2> }
        intersection {
                cylinder { <-1,0,.45>,<1,0,.45>,.3 inverse }
                box { <-1,0,.5>,<1,-1,1> }
                }
        rotate -12.4*x
        bounded_by { box { <-1,-1,-1>,<1,2,1> } }
}
#declare piratehook = difference {
        merge {
                cylinder { <0,0,-.1>,<0,0,.1>,.3 }
                cylinder { <0,0,-.05>,<0,0,.05>,.35 }
                torus { .3,.05 rotate 90*x translate <0,0,-.05> }
                torus { .3,.05 rotate 90*x translate <0,0,.05> }
                cylinder { <0,0,0>,<0,.5,0>,.15 }
                cylinder { <0,.5,0>,<0,1.3,0>,.15 }
                cylinder { <0,.4,0>,<0,.5,0>,.22 }
                cylinder { <0,.43,0>,<0,.6,0>,.25 }
                torus { .22,.03 translate <0,.43,0> }
                }
        cylinder { <0,0,-1>,<0,0,1>,.2 }
        box { <-1,.2,-1>,<0,-.12,1> }
        intersection {
                cylinder { <0,0,0>,<0,.5,0>,.151 inverse }
                box { <-1,0,-.5>,<0,.39,.5> }
        }
        bounded_by { box { <-1,-1,-.4>,<1,1.3,.4> } }
}
#declare leg_joiner = merge {
        difference {
                merge {
                        superellipsoid { <.05,.05> scale <.9,.1,.45> translate <0,1.9,.5> }
                        prism { 2,2.6,9 <-.375,.2>,<-.625,.2>,<-.8,.375>,<-.8,.625>,<-.625,.8>,<-.375,.8>,<-.2,.625>,<-.2,.375>,<-.375,.2> }
                        prism { 2,2.6,9 <.375,.2>,<.625,.2>,<.8,.375>,<.8,.625>,<.625,.8>,<.375,.8>,<.2,.625>,<.2,.375>,<.375,.2> }                                        
                        }
                box { <-2,0,-1>,<-1,2,2> rotate -10.6*z translate 2*y }
                box { <2,0,-1>,<1,2,2> rotate 10.6*z translate 2*y }
                cylinder { <-1,1.35,.55>,<1,1.35,.55>,.47 }
                }
        object { roundcylinder (.2,.45,.05) rotate 90*z translate <.1,1.45,.55> }
        box { <-.06,1.35,.2>,<.06,1.95,.9> }
        cylinder { <-.5,1.35,.55>,<.5,1.35,.55>,.1 }
        bounded_by { box { <-1,1,0>,<1,3,1> } }
}
#declare left_leg = difference {
        union {
                superellipsoid { <.03,.03> scale <.45,.2,.5> translate <.5,.2,.5> }
                superellipsoid { <.03,.03> scale <.45,.725,.375> translate <.5,.725,.625> }
                cylinder { <.05,1.45,.55>,<.95,1.45,.55>,.45 }
                }
        cylinder { <-.1,1.45,.55>,<.7,1.45,.55>,.1 }
        cylinder { <-.7,1.45,.55>,<.1,1.45,.55>,.46 }
        box { <.2,-1,.2>,<.8,.2,.8> }
        box { <.201,-1,.35>,<.799,.9,.799> }
        cylinder { <.5,.5,.8>,<.5,.5,1.5>,.3 }
        cylinder { <.5,1.5,.5>,<.5,1.5,1.5>,.3 }
        box { <.95,-1,-1>,<2,3,2> rotate 1.5*z }
        bounded_by { box { <0,0,0>,<1,2,1> } }
        translate -1.45*y
}
#declare right_leg = difference {
        union {
                superellipsoid { <.03,.03> scale <.45,.2,.5> translate <-.5,.2,.5> }
                superellipsoid { <.03,.03> scale <.45,.725,.375> translate <-.5,.725,.625> }
                cylinder { <-.05,1.45,.55>,<-.95,1.45,.55>,.45 }
                }
        cylinder { <.1,1.45,.55>,<-.7,1.45,.55>,.1 }
        cylinder { <-.1,1.45,.55>,<.7,1.45,.55>,.46 }
        box { <-.2,-1,.2>,<-.8,.2,.8> }
        box { <-.201,-1,.35>,<-.799,.9,.799> }
        cylinder { <-.5,.5,.8>,<-.5,.5,1.5>,.3 }
        cylinder { <-.5,1.5,.5>,<-.5,1.5,1.5>,.3 }
        box { <-.95,-1,-1>,<-2,3,2> rotate -1.5*z }
        bounded_by { box { <0,0,0>,<-1,2,1> } }
        translate -1.45*y
}
#declare pegleg = difference {
        union {
                cylinder { <-.5,0,.5>,<-.5,.35,.5>,.407 }
                cylinder { <-.5,.2,.5>,<-.5,.4,.5>,.357 }
                torus { .35,.05 translate <-.5,.35,.5> }
                cone { <-.5,.35,.5>,.2 <-.5,1.45,.5>,.3 }
                difference {
                        cylinder { <-.05,1.45,.55>,<-.95,1.45,.55>,.45 }
                        box { <-1,1.45,0>,<0,2,2> }
                        intersection {
                                cylinder { <-.5,1.45,0>,<-.5,1.45,2>,.45 inverse }
                                box { <-1,1.45,0>,<-.5,.5,2> }
                                }
                        }
                intersection {
                        cylinder { <-.05,1.55,.55>,<-.95,1.55,.55>,.35 }
                        box { <-1,1.54,0>,<0,2,2> }
                        }
                box { <-.05,1.44,.1>,<-.95,1.55,1> }
                }
        cylinder { <0,-.1,0>,<0,.2,0>,.3 }
        box { <-.85,1.25,.3>,<-.45,2,.7> }
        cylinder { <.1,1.45,.55>,<-.7,1.45,.55>,.1 }
        cylinder { <-.1,1.45,.55>,<.7,1.45,.55>,.46 }
        bounded_by { box { <-1,-.1,-.1>,<0,2,1.1> } }
        translate -1.45*y
}
#declare sword = union {
        intersection {
                cone { <0,3.5,-.1>,0 <0,3.5,.1>,.6 }
                cone { <0,3.5,.1,>0 <0,3.5,-.1>,.6 }
                }
        prism { .9,3.5,5 <-.3,0>,<0,-.1>,<.3,0>,<0,.1>,<-.3,0> }
        cylinder { <-.5,.9,0>,<.5,.9,0>,.2 }
        cylinder { <0,.15,0>,<0,.9,0>,.2 }
        sphere { <0,0,0>,.2 scale <.7,1,1> translate <-.6,.9,0> }
        sphere { <0,0,0>,.2 scale <.7,1,1> translate <.6,.9,0> }
        sphere { <0,0,0>,.2 }
        translate -.3*y
}
#declare axe = union {
        difference {
                intersection {
                        cone { <.1,4.6,.1>,0 <.1,4.6,-.1>,2.4 }
                        cone { <.1,4.6,.1>,2.4 <.1,4.6,-.1>,0 }
                        box { <0,1,-.1>,<3,9,.1> }
                        }
                cylinder { <.5,4.05,-1>,<.5,4.05,1>,.3 }
                cylinder { <.5,5.15,-1>,<.5,5.15,1>,.3 }
                box { <-1,4.05,-1>,<.8,1,1> }
                box { <-1,5.15,-1>,<.8,9,1> }
                box { <-1,4.35,-1>,<.5,1,1> }
                box { <-1,4.85,-1>,<.5,9,1> }
                }
        cylinder { <0,-.5,0>,<0,5,0>,.2 }
        cone { <0,4.999,0>,.2 <0,5.5,0>,.1 }
        sphere { <0,5.5,0>,.1 }
        bounded_by { box { <-.3,-.5,-.2>,<2,5.7,.2> } }
}
#declare crossbow = union {
        cylinder { <0,-.3,0>,<0,.4,0>,.2 }
        prism { -.2,.2,6 <-1.2,.7>,<-1.2,.1>,<0,.3>,<1.7,.3>,<1.7,.7>,<-1.2,.7> rotate <-90,-90,0> }
        difference {
                torus { 1.6,.13 }
                box { <0,2,0>,<-3,-1,-5> rotate 20*y }
                box { <0,2,0>,<3,-1,-5> rotate -20*y }
                box { <-5,-1,0>,<5,2,-3> }
                translate <0,.5,-.25> 
                }
        sphere { <-1.6,.5,0>,.13 rotate 20*y translate -.25*z }
        sphere { <1.6,.5,0>,.13 rotate -20*y translate -.25*z }
        cylinder { <0,.5,0>,<-1.6,.5,0>,.1 rotate 25*y scale <1,1,.63> }
        cylinder { <0,.5,0>,<1.6,.5,0>,.1 rotate -25*y scale <1,1,.63> }
        prism { .5,.8,5 <0,1.45>,<.2,1.55>,<0,1.85>,<-.2,1.55>,<0,1.45> }
        cylinder { <0,.8,.15>,<0,.8,1.55>,.1 }
        box { <-.1,.5,.15>,<.1,.8,1.55> }
        cone { <0,.8,1.549>,.1 <0,.8,1.7>,0 }
        difference {
                cylinder { <-.1,.7,.3>,<.1,.7,.3>,.3 }
                box { <-.3,0,.2>,<.3,2,2> }
                }
        difference {
                torus { .25,.1 }
                box { <0,-1,-1>,<1,1,1> }
                translate <-.2,.5,1.85>
                }
        difference {
                torus { .25,.1 }
                box { <-1,-1,-1>,<0,1,1> }
                translate <.2,.5,1.85>
                }
        cylinder { <-.201,.5,2.1>,<.201,.5,2.1>,.1 }
}
#declare torch = difference {
        merge {
                cylinder { <0,-1.4,0>,<0,.3,0>,.2 }
                cylinder { <0,0,0>,<.8,0,0>,.2 }
                cone { <0,.4,0>,.5 <0,.6,0>,.4 }
                cylinder { <0,.5,0>,<0,1.2,0>,.407 }
                cylinder { <0,.600,0>,<0,.673,0>,.44 }
                cylinder { <0,.709,0>,<0,.782,0>,.44 }
                cylinder { <0,.818,0>,<0,.891,0>,.44 }
                cylinder { <0,.927,0>,<0,.964,0>,.44 }
                }
        cylinder { <0,.9,0>,<0,2,0>,.324 }
        box { <-.3,.5,-.12>,<.3,2,.12> }
        box { <-.12,.5,-.3>,<.12,2,.3> }
        difference {
                merge {
                        cylinder { <0,-01,0>,<0,-.95,0>,.3 }
                        cylinder { <0,-.9,0>,<0,-.85,0>,.3 }
                        cylinder { <0,-.8,0>,<0,-.75,0>,.3 }
                        cylinder { <0,-.7,0>,<0,-.65,0>,.3 }
                        }
                cylinder { <0,-2,0>,<0,2,0>,.16 }
                }
        bounded_by { box { <-.5,-1.4,-.5>,<.9,1.2,.5> } }
}
#declare lantern = difference { union {
        cylinder { <0,0,0>,<0,1.3,0>,.2 }
        difference {
                merge {
                        cylinder { <0,1.2,0>,<0,2.2,0>,.45 }
                        cylinder { <0,2.1,0>,<0,2.4,0>,.3 }
                        }
                cylinder { <-.5,0,-.5>,<-.5,3,-.5>,.3 }
                cylinder { <-.5,0,.5>,<-.5,3,.5>,.3 }
                cylinder { <.5,0,-.5>,<.5,3,-.5>,.3 }
                cylinder { <.5,0,.5>,<.5,3,.5>,.3 }
                }
        cylinder { <-.495,2,-.495>,<-.495,3.2,-.495>,.2 }
        cylinder { <.495,2,-.495>,<.495,3.2,-.495>,.2 }
        cylinder { <-.495,2,.495>,<-.495,3.2,.495>,.2 }
        cylinder { <.495,2,.495>,<.495,3.2,.495>,.2 }
        cylinder { <-.495,2,-.495>,<.495,2,.495>,.2 }
        cylinder { <-.495,2,.495>,<.495,2,-.495>,.2 }
        box { <-.7,2,-.2>,<.7,2.2,.2> rotate 45*y }
        box { <-.7,2,-.2>,<.7,2.2,.2> rotate -45*y }
        sphere { <-.495,2,-.495>,.2 }
        sphere { <.495,2,-.495>,.2 }
        sphere { <-.495,2,.495>,.2 }
        sphere { <.495,2,.495>,.2 }
} cylinder { <0,1.4,0>,<0,3,0>,.2 } bounded_by { cylinder { <0,0,0>,<0,3.2,0>,1 } } }
#declare bow = union {
        cylinder { <0,-.8,0>,<0,.8,0>,.18 }
        cylinder { <0,-.700,0>,<0,-.633,0>,.2 }
        cylinder { <0,-.567,0>,<0,-.500,0>,.2 }
        cylinder { <0,-.433,0>,<0,-.367,0>,.2 }
        cylinder { <0,-.300,0>,<0,-.233,0>,.2 }
        cylinder { <0,-.167,0>,<0,-.100,0>,.2 }
        cylinder { <0,-.033,0>,<0,0.033,0>,.2 }
        cylinder { <0,0.100,0>,<0,0.167,0>,.2 }
        cylinder { <0,0.233,0>,<0,0.300,0>,.2 }
        cylinder { <0,0.367,0>,<0,0.433,0>,.2 }
        cylinder { <0,0.500,0>,<0,0.567,0>,.2 }
        cylinder { <0,0.633,0>,<0,0.700,0>,.2 }
        difference {
                intersection {
                        torus { 1.8,.16 rotate 90*x translate <-1.78,.8,0> }
                        box { <-1.76,0,-1>,<1,3,1> }
                        }
                box { <-4,-.799,-1>,<4,.799,1> }
                box { <-4,0,-1>,<0,4,1> rotate -30*z translate <-1.78,.8,0> }
                }
        difference {
                intersection {
                        torus { 1.8,.16 rotate 90*x translate <-1.78,-.8,0> }
                        box { <-1.76,0,-1>,<1,-3,1> }
                        }
                box { <-4,-.799,-1>,<4,.799,1> }
                box { <-4,0,-1>,<0,-4,1> rotate 30*z translate <-1.78,-.8,0> }
                }
        sphere { <0,1.8,0>,.16 rotate -30*z translate <-1.78,.8,0> }
        sphere { <0,-1.8,0>,.16 rotate 30*z translate <-1.78,-.8,0> }
        cylinder { <-1.5,0,0>,<-.8,2.4,0>,.08 }
        cylinder { <-1.5,0,0>,<-.8,-2.4,0>,.08 }
        cone { <0,.799,0>,.18 <0,1.1,0>,0 }
        cone { <0,-.799,0>,.18 <0,-1.1,0>,0 }
        cylinder { <-2,0,0>,<.65,0,0>,.1 }
        sphere { <-2,0,0>,.1 }
        cone { <.645,0,0>,.1 <1,0,0>,0 }
        intersection {
                prism { quadratic_spline conic_sweep 0,1,5 <0,-.52>,<0,.52>,<.95,0>,<0,-.52>,<0,.52> scale <1,.2,1> translate <.65,-.1,0> rotate -90*x }
                prism { quadratic_spline conic_sweep 0,1,5 <0,-.52>,<0,.52>,<.95,0>,<0,-.52>,<0,.52> rotate 180*x scale <1,.2,1> translate <.65,.1,0> rotate -90*x }
                box { <0,-1,-.05>,<2,1,.05> }
                }
        difference {
                prism { -.05,.05,6 <-.5,0>,<-.8,.3>,<-1.43,.3>,<-1.43,-.3>,<-.8,-.3>,<-.5,0> rotate -90*x }
                sphere { <-0.767,0.133,-.05>,.034 }
                sphere { <-0.967,0.133,-.05>,.034 }
                sphere { <-1.167,0.133,-.05>,.034 }
                sphere { <-1.367,0.133,-.05>,.034 }
                sphere { <-0.767,0.133,0.05>,.034 }
                sphere { <-0.967,0.133,0.05>,.034 }
                sphere { <-1.167,0.133,0.05>,.034 }
                sphere { <-1.367,0.133,0.05>,.034 }
                sphere { <-0.767,-.133,-.05>,.034 }
                sphere { <-0.967,-.133,-.05>,.034 }
                sphere { <-1.167,-.133,-.05>,.034 }
                sphere { <-1.367,-.133,-.05>,.034 }
                sphere { <-0.767,-.133,0.05>,.034 }
                sphere { <-0.967,-.133,0.05>,.034 }
                sphere { <-1.167,-.133,0.05>,.034 }
                sphere { <-1.367,-.133,0.05>,.034 }
                cylinder { <-0.767,0.133,0.05>,<-1.267,0.633,0.05>,.034 }
                cylinder { <-0.967,0.133,0.05>,<-1.467,0.633,0.05>,.034 }
                cylinder { <-1.167,0.133,0.05>,<-1.667,0.633,0.05>,.034 }
                cylinder { <-1.367,0.133,0.05>,<-1.867,0.633,0.05>,.034 }
                cylinder { <-0.767,-.133,0.05>,<-1.267,-.633,0.05>,.034 }
                cylinder { <-0.967,-.133,0.05>,<-1.467,-.633,0.05>,.034 }
                cylinder { <-1.167,-.133,0.05>,<-1.667,-.633,0.05>,.034 }
                cylinder { <-1.367,-.133,0.05>,<-1.867,-.633,0.05>,.034 }
                cylinder { <-0.767,0.133,-.05>,<-1.267,0.633,-.05>,.034 }
                cylinder { <-0.967,0.133,-.05>,<-1.467,0.633,-.05>,.034 }
                cylinder { <-1.167,0.133,-.05>,<-1.667,0.633,-.05>,.034 }
                cylinder { <-1.367,0.133,-.05>,<-1.867,0.633,-.05>,.034 }
                cylinder { <-0.767,-.133,-.05>,<-1.267,-.633,-.05>,.034 }
                cylinder { <-0.967,-.133,-.05>,<-1.467,-.633,-.05>,.034 }
                cylinder { <-1.167,-.133,-.05>,<-1.667,-.633,-.05>,.034 }
                cylinder { <-1.367,-.133,-.05>,<-1.867,-.633,-.05>,.034 }
                }
}
#declare quiver = union {
        union {
                cylinder { <0,-.1,-.8>,<-2.4,-.1,-.8>,.1 }
                cylinder { <0,-.6,-.8>,<-2.4,-.6,-.8>,.1 }
                cylinder { <-2.4,-.1,-.8>,<-2.4,-.6,-.8>,.1 }
                cylinder { <-2.4,-.1,-.8>,<-2.4,-.1,-.5>,.1 }
                cylinder { <-2.4,-.6,-.8>,<-2.4,-.6,-.5>,.1 }
                sphere { <-2.4,-.6,-.8>,.1 }
                sphere { <-2.4,-.1,-.8>,.1 }
                box { <-2.5,-.1,-.5>,<-.1,-.6,-.8> }
                box { <-2.4,0,-.5>,<0,-.7,-.8> }
                box { <-2.4,-.1,-.5>,<0,-.6,-.9> }
                cylinder { <-.1,-.25,-.7>,<.8,-.25,-.7>,.1 }
                cylinder { <-.1,-.45,-.7>,<.8,-.45,-.7>,.1 }
                cylinder { <.1,-.25,-.7>,<.35,0,-.7>,.05 }
                cylinder { <.24,-.25,-.7>,<.49,0,-.7>,.05 }
                cylinder { <.38,-.25,-.7>,<.63,0,-.7>,.05 }
                cylinder { <.52,-.25,-.7>,<.67,-.1,-.7>,.05 }
                cylinder { <.1,-.45,-.7>,<.35,-.7,-.7>,.05 }
                cylinder { <.24,-.45,-.7>,<.49,-.7,-.7>,.05 }
                cylinder { <.38,-.45,-.7>,<.63,-.7,-.7>,.05 }
                cylinder { <.52,-.45,-.7>,<.67,-.6,-.7>,.05 }
                sphere { <.8,-.25,-.7>,.1 }
                sphere { <.8,-.45,-.7>,.1 }
                sphere { <.35,0,-.7>,.05 }
                sphere { <.49,0,-.7>,.05 }
                sphere { <.63,0,-.7>,.05 }
                sphere { <.67,-.1,-.7>,.05 }
                sphere { <.35,-.7,-.7>,.05 }
                sphere { <.49,-.7,-.7>,.05 }
                sphere { <.63,-.7,-.7>,.05 }
                sphere { <.67,-.6,-.7>,.05 }
                difference {
                        union {
                                box { <-.22,-1,0>,<-.28,1,-1> }
                                box { <-1.22,-1,0>,<-1.28,1,-1> }
                                box { <-2.22,-1,0>,<-2.28,1,-1> }
                                box { <-.03,-1,0>,<.03,1,-1> rotate 45*z translate <-1.75,-.35,0> }
                                box { <-.03,-1,0>,<.03,1,-1> rotate -45*z translate <-1.75,-.35,0> }
                                box { <-.03,-1,0>,<.03,1,-1> rotate 45*z translate <-.75,-.35,0> }
                                box { <-.03,-1,0>,<.03,1,-1> rotate -45*z translate <-.75,-.35,0> }
                                }
                        box { <-5,-1,-.92>,<5,1,-5> }
                        box { <-5,.02,-5>,<5,5,5> }
                        box { <-5,-.72,-5>,<5,-5,5> }
                        box { <-5,-5,5>,<5,5,-.5> }
                        difference {
                                box { <-5,-.1,-.8>,<5,5,-5> }
                                cylinder { <0,-.1,-.8>,<-2.5,-.1,-.8>,.12 }
                                }
                        difference {
                                box { <-5,-.6,-.8>,<5,-5,-5> }
                                cylinder { <0,-.6,-.8>,<-2.5,-.6,-.8>,.12 }
                                }
                        }
                rotate 45*z translate <.9,.15,0>
                }
        difference {
                union {
                        cylinder { <0,0,0>,<0,.1,0>,.5 }
                        box { <-.5,0,0>,<.5,.15,-.6> }
                        box { <-.5,.15,-.5>,<.5,-.9,-.6> }
                        }
                box { <-4,-4,-2>,<0,0,2> rotate 35*z translate <-.5,0,0,> }
                cylinder { <0,-1,0>,<0,1,0>,.3 }
                }
}
#declare goblet = difference {
        union {
                cylinder { <0,0,0>,<0,.15,0>,.5 }
                torus { .35,.15 translate .15*y }
                cylinder { <0,.1,0>,<0,.3,0>,.35 }
                cylinder { <0,.2,0>,<0,.37,0>,.25 }
                cylinder { <0,.3,0>,<0,1.2,0>,.2 }
                cone { <0,1.1,0>,.3 <0,2,0>,.5 }
                }
        cylinder { <0,-1,0>,<0,.2,0>,.3 }
        cylinder { <0,1.6,0>,<0,3,0>,.407 }
        cone { <0,1.7,0>,.407 <0,1.3,0>,.3 }
        bounded_by { cylinder { <0,0,0>,<0,2,0>,.5 } }
}
#declare joust = merge {
        cylinder { <-1.4,0,0>,<7.5,0,0>,.2 }
        sphere { <7.5,0,0>,.2 }
        cylinder { <0,0,0>,<0,-.85,0>,.2 }
        cone { <.4,0,0>,.5 <.9,0,0>,0 }
}
#declare flagpole = difference {
        merge {
                cylinder { <0,0,0>,<0,.4,0>,.407 }
                cylinder { <0,.3,0>,<0,.6,0>,.3 }
                cylinder { <0,.5,0>,<0,4.7,0>,.2 }
                sphere { <0,4.7,0>,.2 }
                }
        cylinder { <0,-1,0>,<0,.2,0>,.3 }
        cylinder { <0,-1,0>,<0,.4,0>,.2 }
        bounded_by { cylinder { <0,0,0>,<0,4.9,0>,.5 } }
}
#declare shield = union {
        intersection {
                cylinder { <-2.414,.3,0>,<-2.414,.3,-1>,3.414 scale <1,.828,1> }
                cylinder { <2.414,.3,0>,<2.414,.3,-1>,3.414 scale <1,.828,1> }
                box { <-2,.4,-.4>,<2,-3,-.59> }
                }
        box { <-1,.7,-.4>,<1,.3,-.59> }
        cylinder { <0,0,-.5>,<0,0,.7>,.2 }
        cylinder { <0,0,0>,<0,-.8,0>,.2 }
}

#declare shieldveneer = union { intersection {
        cylinder { <-2.414,.3,0>,<-2.414,.3,-1>,3.414 scale <1,.828,1> }
        cylinder { <2.414,.3,0>,<2.414,.3,-1>,3.414 scale <1,.828,1> }
        box { <-2,.4,-.58>,<2,-3,-.6> }
        }
        box { <-1,.7,-.58>,<1,.3,-.6> }
}

#declare shieldbluedragon = union {
        object { shield texture { LegoGray } }
        object { shieldveneer texture { pigment { image_map { sys "sd_bluedragon.bmp" once } scale <2,2.45,2> translate <-1,-1.74,0> } finish { diffuse 1 ambient .17 } } }
}

#declare shieldyellowlion = union {
        object { shield texture { LegoGray } }
        object { shieldveneer texture { pigment { image_map { sys "sd_yellowlion.bmp" once } scale <2,2.45,2> translate <-1,-1.74,0> } finish { diffuse 1 ambient .17 } } }
}

#declare shieldblueeagle = union {
        object { shield texture { LegoGray } }
        object { shieldveneer texture { pigment { image_map { sys "sd_blueeagle.bmp" once } scale <2,2.45,2> translate <-1,-1.74,0> } finish { diffuse 1 ambient .17 } } }
}

#declare barrel = difference {
        union {
                difference {
                        cylinder { <0,0,0>,<0,.4,0>,1 }
                        box { <-.8,-1,-.8>,<.8,.2,.8> }
                        }
                intersection { 
                        sphere { <0,0,0>,.94 scale <1,4,1> translate <0,1.2,0> }
                        box { <-1,.3,-1>,<1,2,1> }
                        }
                difference {
                        sphere { <0,0,0>,.96 scale <1,4,1> translate <0,1.2,0> }
                        cylinder { <0,-10,0>,<0,.3,0>,2 }
                        cylinder { <0,2,0>,<0,10,0>,2 }
                        box { <-.02,-1,-2>,<.02,3,2> }
                        box { <-.02,-1,-2>,<.02,3,2> rotate 30*y }
                        box { <-.02,-1,-2>,<.02,3,2> rotate 60*y }
                        box { <-.02,-1,-2>,<.02,3,2> rotate 90*y }
                        box { <-.02,-1,-2>,<.02,3,2> rotate 120*y }
                        box { <-.02,-1,-2>,<.02,3,2> rotate 150*y }
                        }
                cylinder { <0,1,0>,<0,2.2,0>,.8 }
                cylinder { <0,0,0>,<0,.3,0>,.407 }
                cylinder { <0,1.1,0>,<0,1.3,0>,1 }
                }
        cylinder { <0,-1,0>,<0,.2,0>,.31 }
        cylinder { <0,.4,0>,<0,3,0>,.65 }
        box { <-.28,-1,-.12>,<.28,1,.12> }
        box { <-.12,-1,-.28>,<.12,1,.28> }
        bounded_by { cylinder { <0,0,0>,<0,2.4,0>,1 } }
}

#declare spout = difference {
        union {
                cylinder { <0,0,0>,<0,.25,0>,.407 }
                cylinder { <0,.2,0>,<0,.4,0>,.257 }
                torus { .257,.15 translate <0,.25,0> }
                cylinder { <0,.2,0>,<0,1.3,0>,.2 }
                cylinder { <0,1.2,0>,<0,1.4,0>,.3 }
                cylinder { <0,1,0>,<0,1,-.5>,.2 }
                cone { <0,1,-.499>,.2 <0,1,-.9>,.17 }
                cylinder { <0,1,-.8>,<0,1,-1>,.2 }
                }
        cylinder { <0,-1,0>,<0,.2,0>,.3 }
        cylinder { <0,1,-.5>,<0,1,-2>,.08 }
        bounded_by { box { <-.5,0,-1>,<.5,1.4,.5> } }
}

#declare doorwood = difference {
        union {
                difference {
                        union {
                                box { <0,.2,-.08>,<2.5,4.4,.08> }
                                cylinder { <2.5,4.4,-.08>,<2.5,4.4,.08>,2.5 }
                                }
                        box { <2.45,0,-1>,<6,8,1> }
                        box { <.375,0,-2>,<.475,8,-.06> }
                        box { <.675,0,-2>,<.775,8,-.06> }
                        box { <.975,0,-2>,<1.075,8,-.06> }
                        box { <1.275,0,-2>,<1.375,8,-.06> }
                        box { <1.575,0,-2>,<1.675,8,-.06> }
                        box { <1.875,0,-2>,<1.975,8,-.06> }
                        box { <.375,0,2>,<.475,8,.06> }
                        box { <.675,0,2>,<.775,8,.06> }
                        box { <.975,0,2>,<1.075,8,.06> }
                        box { <1.275,0,2>,<1.375,8,.06> }
                        box { <1.575,0,2>,<1.675,8,.06> }
                        box { <1.875,0,2>,<1.975,8,.06> }
                        texture { LegoBrown } finish { BumpFinish } normal { BumpNormal }
                        }
                box { <0,.3,-.1>,<.1,4.3,.1> texture { LegoBrown } }
                box { <0,.2,-.1>,<2.35,.4,.1> texture { LegoBrown } }
                box { <2.25,.2,-.1>,<2.45,6.9,.1> texture { LegoBrown } }
                difference {
                        cylinder { <2.5,4.4,-.1>,<2.5,4.4,.1>,2.5 texture { LegoBrown } }
                        cylinder { <2.5,4.4,-1>,<2.5,4.4,1>,2.4 texture { LegoBrown } }
                        box { <-1,0,-1>,<10,4.4,1> texture { LegoBrown } }
                        box { <2.45,0,-1>,<10,8,1> texture { LegoBrown } }
                        }
                difference {
                        torus { 2.5,.1 rotate 90*x translate <2.5,4.4,0> texture { LegoBrown } }
                        box { <-1,0,-1>,<10,4.4,1> texture { LegoBrown } }
                        box { <2.45,0,-1>,<10,8,1> texture { LegoBrown } }
                        }
                cylinder { <0,.2,0>,<0,4.4,0>,.1 texture { LegoBrown } }
                box { <1.675,2.9,-.1>,<2.4,4.1,.1> texture { LegoBrown } }
                box { <0,3.4,-.1>,<1.7,3.6,.1> texture { LegoBrown } }
                box { <.4,5.6,-.1>,<1.975,5.8,.2> texture { LegoBrown } }
                box { <0,1.2,-.1>,<1.975,1.4,.1> texture { LegoBrown } }
                cylinder { <1.975,1.3,-.1>,<1.975,1.3,.1>,.1 texture { LegoBrown } }
                cylinder { <1.975,5.7,-.1>,<1.975,5.7,.1>,.1 texture { LegoBrown } }
                sphere { <.575,1.3,-.1>,.05 texture { LegoBrown } }
                sphere { <.575,1.3,.1>,.05 texture { LegoBrown } }
                sphere { <1.175,1.3,-.1>,.05 texture { LegoBrown } }
                sphere { <1.175,1.3,.1>,.05 texture { LegoBrown } }
                sphere { <1.775,1.3,-.1>,.05 texture { LegoBrown } }
                sphere { <1.775,1.3,.1>,.05 texture { LegoBrown } }
                sphere { <.575,3.5,-.1>,.05 texture { LegoBrown } }
                sphere { <.575,3.5,.1>,.05 texture { LegoBrown } }
                sphere { <1.175,3.5,-.1>,.05 texture { LegoBrown } }
                sphere { <1.175,3.5,.1>,.05 texture { LegoBrown } }
                sphere { <1.175,5.7,-.1>,.05 texture { LegoBrown } }
                sphere { <1.175,5.7,.1>,.05 texture { LegoBrown } }
                sphere { <1.775,5.7,-.1>,.05 texture { LegoBrown } }
                sphere { <1.775,5.7,.1>,.05 texture { LegoBrown } }
                box { <0,1.15,-.1>,<.325,1.45,.1> texture { LegoBrown } }           
                box { <0,3.35,-.1>,<.325,3.65,.1> texture { LegoBrown } }
                cylinder { <2,3.5,-.3>,<2,3.5,.3>,.3 texture { LegoBrown } }
                }
        box { <-1,1.2,-1>,<.25,1.4,1> texture { LegoBrown } }
        box { <-1,3.4,-1>,<.25,3.6,1> texture { LegoBrown } }
        cylinder { <2,3.5,-1>,<2,3.5,-.1>,.2 texture { LegoBrown } }
        cylinder { <2,3.5,.1>,<2,3.5,1>,.2 texture { LegoBrown } }
        bounded_by { box { <-.1,0,-.2>,<2.5,7.2,.2> } }
}
#declare banner = difference {
        union {
                difference {
                        cylinder { <.4,.25,.4875>,<.4,1.15,.4875>,.5375 }
                        cylinder { <.4,0,.4875>,<.4,2,.4875>,.4375 }
                        box { <0,0,10>,<-10,2,-10> translate <.4,0,0> }
                        box { <0,0,10>,<10,2,-10> rotate -49*y translate <.4,0,.4875> }
                        }
                difference {
                        cylinder { <1.1,.25,-.1875>,<1.1,1.15,-.1875>,.5375 }
                        cylinder { <1.1,0,-.1875>,<1.1,2,-.1875>,.4375 }
                        box { <0,0,10>,<-10,2,-10> rotate -49*y translate <1.1,0,-.1875> }
                        box { <0,0,10>,<10,2,-10> rotate 68*y translate <1.1,0,-.1875> }
                        }
                difference {
                        cylinder { <2,.25,.1875>,<2,1.15,.1875>,.5375 }
                        cylinder { <2,0,.1875>,<2,2,.1875>,.4375 }
                        box { <0,0,10>,<-10,2,-10> rotate 68*y translate <2,0,.1875> }
                        box { <0,0,10>,<10,2,-10> rotate -68*y translate <2,0,.1875> }
                        }
                difference {
                        cylinder { <2.9,.25,-.1875>,<2.9,1.15,-.1875>,.5375 }
                        cylinder { <2.9,0,-.1875>,<2.9,2,-.1875>,.4375 }
                        box { <0,0,10>,<-10,2,-10> rotate -68*y translate <2.9,0,-.1875> }
                        box { <0,0,10>,<10,2,-10> rotate 49*y translate <2.9,0,-.1875> }
                        }
                difference {
                        cylinder { <3.6,.25,.4875>,<3.6,1.15,.4875>,.5375 }
                        cylinder { <3.6,0,.4875>,<3.6,2,.4875>,.4375 }
                        box { <0,0,10>,<-10,2,-10> rotate 49*y translate <3.6,0,.4875> }
                        box { <0,0,10>,<10,2,-10> translate <3.6,0,.4875> }
                        }
                difference {
                        torus { .4,.05 translate <.4,.25,.4875> }
                        box { <0,0,10>,<-10,2,-10> translate <.4,0,0> }
                        box { <0,0,10>,<10,2,-10> rotate -49*y translate <.4,0,.4875> }
                        }
                difference {
                        torus { .4875,.05 translate <1.1,.25,-.1875> }
                        box { <0,0,10>,<-10,2,-10> rotate -49*y translate <1.1,0,-.1875> }
                        box { <0,0,10>,<10,2,-10> rotate 68*y translate <1.1,0,-.1875> }
                        }
                difference {
                        torus { .4875,.05 translate <2,.25,.1875> }
                        box { <0,0,10>,<-10,2,-10> rotate 68*y translate <2,0,.1875> }
                        box { <0,0,10>,<10,2,-10> rotate -68*y translate <2,0,.1875> }
                        }
                difference {
                        torus { .4875,.05 translate <2.9,.25,-.1875> }
                        box { <0,0,10>,<-10,2,-10> rotate -68*y translate <2.9,0,-.1875> }
                        box { <0,0,10>,<10,2,-10> rotate 49*y translate <2.9,0,-.1875> }
                        }
                difference {
                        torus { .4875,.05 translate <3.6,.25,.4875> }
                        box { <0,0,10>,<-10,2,-10> rotate 49*y translate <3.6,0,.4875> }
                        box { <0,0,10>,<10,2,-10> translate <3.5748,0,.4875> }
                        }
                difference {
                        torus { .4875,.05 translate <.4,1.15,.4875> }
                        box { <0,0,10>,<-10,2,-10> translate <.4,0,0> }
                        box { <0,0,10>,<10,2,-10> rotate -49*y translate <.4,0,.4875> }
                        }
                difference {
                        torus { .4875,.05 translate <1.1,1.15,-.1875> }
                        box { <0,0,10>,<-10,2,-10> rotate -49*y translate <1.1,0,-.1875> }
                        box { <0,0,10>,<10,2,-10> rotate 68*y translate <1.1,0,-.1875> }
                        }
                difference {
                        torus { .4875,.05 translate <2,1.15,.1875> }
                        box { <0,0,10>,<-10,2,-10> rotate 68*y translate <2,0,.1875> }
                        box { <0,0,10>,<10,2,-10> rotate -68*y translate <2,0,.1875> }
                        }
                difference {
                        torus { .4875,.05 translate <2.9,1.15,-.1875> }
                        box { <0,0,10>,<-10,2,-10> rotate -68*y translate <2.9,0,-.1875> }
                        box { <0,0,10>,<10,2,-10> rotate 49*y translate <2.9,0,-.1875> }
                        }
                difference {
                        torus { .4875,.05 translate <3.6,1.15,.4875> }
                        box { <0,0,10>,<-10,2,-10> rotate 49*y translate <3.6,0,.4875> }
                        box { <0,0,10>,<10,2,-10> translate <3.6,0,.4875> }
                        }
                cylinder { <0,0,0>,<0,.4,0>,.407 }
                cylinder { <0,.3,0>,<0,1.4,0>,.3 }
                box { <0,.25,-.05>,<.402,1.15,.05> }
                cylinder { <0,.25,0>,<.43,.25,0>,.05 }
                cylinder { <0,1.15,0>,<.43,1.15,0>,.05 }
                cylinder { <3.6,.25,0>,<3.6,1.15,0>,.05 }
                sphere { <3.6,.25,0>,.05 }
                sphere { <3.6,1.15,0>,.05 }
                }
        cylinder { <0,-1,0>,<0,.2,0>,.3 }
        cylinder { <0,-1,0>,<0,2,0>,.2 }
        prism { -3,3,4 <2,.7>,<5,0>,<5,1.4>,<2,.7> rotate -90*x }
        bounded_by { box { <-.5,0,-1>,<4,1.4,1> } }
}
#declare flag = difference {
        union {
                box { <.5,0,-.1>,<2.5,2,.1> }
                cylinder { <0,0,0>,<0,2,0>,.3 }
                prism { 0,2,4 <.1417,.2644>,<.1417,-.2644>,<.718,0>,<.1417,.2644> }
                }
        cylinder { <0,-1,0>,<0,3,0>,.2 }
        box { <-1,-1,-.16>,<0,3,.16> }
        superellipsoid { <.2,.2> scale <.6,.6,.6> translate <-.1,1,0> }
        bounded_by { box { <-.3,0,-.3>,<2.5,2,.3> } }
}
#declare chest = difference {
        union {
                difference {
                        union {
                                box { <.05,0,.05>,<3.95,1.6,1.95> }
                                box { <0,.05,0>,<4,1.55,2> }
                                }
                        box { <.2,-1,.2>,<3.8,.2,1.8> }
                        box { <.2,.4,.2>,<3.8,3,1.8> }
                        box { <.2,.2,1.75>,<.25,3,3> }
                        box { <3.75,.2,1.75>,<3.8,3,3> }
                        box { <.2,1.2,1.75>,<3.8,3,3> }
                        cylinder { <-1,1.4,1.8>,<5,1.4,1.8>,.1 }
                        }
                prism { 1.4,1.6,11 <.1,1.5>,<-.2,1.47>,<-.3,1.38>,<-.3,.62>,<-.2,.53>,
                        <.1,.5>,<.1,.7>,<-.3,.7>,<-.3,1.3>,<.1,1.3>,<.1,1.5> }
                prism { 1.4,1.6,11 <3.9,1.5>,<4.2,1.47>,<4.3,1.38>,<4.3,.62>,<4.2,.53>,
                        <3.9,.5>,<3.9,.7>,<4.3,.7>,<4.3,1.3>,<3.9,1.3>,<3.9,1.5> }
                cylinder { <-.4,1.5,.6>,<-.4,1.5,1.4>,.2 }
                cylinder { <4.4,1.5,.6>,<4.4,1.5,1.4>,.2 }
                cylinder { <1,0,1>,<1,.3,1>,.407 }
                cylinder { <2,0,1>,<2,.3,1>,.407 }
                cylinder { <3,0,1>,<3,.3,1>,.407 }
                }
        cylinder { <1,-1,1>,<1,.2,1>,.3 }
        cylinder { <2,-1,1>,<2,.2,1>,.3 }
        cylinder { <3,-1,1>,<3,.2,1>,.3 }
        box { <.25,.35,-1>,<1.25,1.4,.05> }
        box { <2.75,.35,-1>,<3.75,1.4,.05> }
        box { <.25,.35,3>,<1.25,1.4,1.95> }
        box { <1.5,.35,3>,<2.5,1.4,1.95> }
        box { <2.75,.35,3>,<3.75,1.4,1.95> }
        prism { -.05,1,11 <1.5,.35>,<2.5,.35>,<2.5,1.4>,<2.25,1.4>,<2.25,1.05>,
                          <2.15,.95>,<1.85,.95>,<1.75,1.05>,<1.75,1.4>,<1.5,1.4>,<1.5,.35> rotate -90*x }
        cylinder { <2,1.3,-1>,<2,1.3,.05>,.1 }
        box { <1.95,1.3,-1>,<2.05,1.05,.05> }
        bounded_by { box { <-1,0,0>,<5,1.8,2> } }
}
#declare chestlid = union {
        difference {
                union {
                        intersection {
                                union {
                                        box { <0,.2,0>,<4,.4,2> }
                                        box { <0,.2,0>,<.25,1,2> }
                                        box { <1.25,.2,0>,<1.5,1,2> }
                                        box { <2.5,.2,0>,<2.75,1,2> }
                                        box { <3.75,.2,0>,<4,1,2> }
                                        box { <0,.3,.3>,<4,1,.5> }
                                        box { <0,.3,1.5>,<4,1,1.7> }
                                        }
                                union {
                                        cylinder { <-1,.2,.8>,<5,.2,.8>,.8 }
                                        cylinder { <-1,.2,1.2>,<5,.2,1.2>,.8 }
                                        box { <-1,.2,.8>,<5,1,1.2> }
                                        }
                                }
                        cylinder { <.1,.2,.8>,<3.9,.2,.8>,.75 }
                        cylinder { <.1,.2,1.2>,<3.9,.2,1.2>,.75 }
                        box { <.1,.201,.8>,<3.9,.949,1.2> }
                        object { bump translate <.5,1,1> }
                        object { bump translate <1.5,1,1> }
                        object { bump translate <2.5,1,1> }
                        object { bump translate <3.5,1,1> }
                        }
                box { <-1,-10,-1>,<5,.2,3> }
                cylinder { <.201,.2,.8>,<3.799,.2,.8>,.6 }
                cylinder { <.201,.2,1.2>,<3.799,.2,1.2>,.6 }
                box { <.2,0,.8>,<3.8,.8,1.2> }
                box { <.2,-1,1.5>,<3.8,.2,1.8> }
                difference {
                        merge {
                                cylinder { <-1,.2,.8>,<5,.2,.8>,.55 }
                                cylinder { <-1,.2,1.2>,<5,.2,1.2>,.55 }
                                box { <-1,-1,.8>,<5,.75,1.2> }
                                }
                        box { <-1,-1,-1>,<5,.4,3> }
                        box { <.05,-1,-1>,<3.95,5,3> }
                        }
                cylinder { <.5,0,1>,<.5,1,1>,.15 }
                cylinder { <1.5,0,1>,<1.5,1,1>,.15 }
                cylinder { <2.5,0,1>,<2.5,1,1>,.15 }
                cylinder { <3.5,0,1>,<3.5,1,1>,.15 }
                }
        prism { -.1,.1,6 <-.2,-.3>,<-.3,-.5>,<-.6,-.5>,<-.6,.8>,<-.2,.5>,<-.2,-.3> rotate 90*z rotate -90*x translate 2*x }
        difference {
                union {
                        cylinder { <.2,0,1.8>,<3.8,0,1.8>,.2 }
                        cylinder { <.15,0,1.8>,<3.85,0,1.8>,.1 }
                        box { <.2,0,1.6>,<3.8,1,2> }
                        box { <.2,-.2,1.6>,<3.8,0.03,1.8> }
                        }
                difference {
                        cylinder { <-1,.2,1.2>,<5,.2,1.2>,2 }
                        cylinder { <-1,.2,1.2>,<5,.2,1.2>,.6 }
                        box { <-1,.2,-1>,<5,-2,3> }
                        }
                box { <.4,-1,0>,<3.6,3,1.8> }
                }
        translate <0,0,-1.8>
}
#declare helmet_can = union { difference {
        union {
                difference { sphere { <0,0,0>,.75 scale <1,1.362,1> translate <0,1,0> }
                        box { <-10,-10,-10>,<10,0,10> translate <0,1,0> } }
                cone { <0,.8737,0>,.3888 <0,1.2,0>,0 translate <0,1,0> }
                intersection {
                        merge {
                                difference { sphere { <0,0,0>,.75 scale <1,1.362,1> }
                                        box { <-10,-10,-10>,<10,0,10> } }
                                cone { <0,.8737,0>,.3888 <0,1.17,0>,.025 }
                                scale <1.066,1.041,1.066> translate <0,1,0>
                                }
                        prism { 0,3,13 <-.1,-.8>,<.1,-.8>,<.05,-.05>,<.8,-.1>,<.8,.1>,<.05,.05>,<.1,.8>,
                                <-.1,.8>,<-.05,.05>,<-.8,.1>,<-.8,-.1>,<-.05,0.05>,<-.1,-.8> }
                        }
                cylinder { <0,0,0>,<0,1.02,0>,.75 }
                cylinder { <0,.9,0>,<0,1,0>,.8 }
                }
        cylinder { <0,-1,0>,<0,1.02,0>,.704 }
        sphere { <0,1,0>,.704 }
        superellipsoid { <.2,.2> scale <1,.3,.5> translate <0,.6,-1> }
        }
        difference {
                cylinder { <0,1.2,0>,<0,1.5,0>,.4 }
                cylinder { <0,0,0>,<0,2,0>,.3 }
                }
        scale <.923,1,.923>
}
#declare helmet_archer = union {
difference {
        union {
                difference { sphere { <0,0,0>,.75 scale <1,1.362,1> translate <0,1,0> }
                        box { <-10,-10,-10>,<10,0,10> translate <0,1,0> } }
                cone { <0,.8737,0>,.3888 <0,1.2,0>,0 translate <0,1,0> }
                intersection {
                        merge {
                                difference { sphere { <0,0,0>,.75 scale <1,1.362,1> }
                                        box { <-10,-10,-10>,<10,0,10> } }
                                cone { <0,.8737,0>,.3888 <0,1.17,0>,.025 }
                                scale <1.066,1.041,1.066> translate <0,1,0>
                                }
                        prism { 0,3,13 <-.1,-.8>,<.1,-.8>,<.05,-.05>,<.8,-.1>,<.8,.1>,<.05,.05>,<.1,.8>,
                                <-.1,.8>,<-.05,.05>,<-.8,.1>,<-.8,-.1>,<-.05,-.05>,<-.1,-.8> }
                        }
                cylinder { <0,.9,0>,<0,1,0>,.8 }
                difference {
                        torus { 2.015,1.325 scale <1,1.1,1> translate <0,1,0> }
                        torus { 2.125,1.325 scale <1,1.4,1> translate <0,1.3,0> }
                        box { <-4,-1,-4>,<4,0,4> }
                        box { <-4,.91,-4>,<4,4,4> }
                        box { <0,-1,0>,<5,2,-5> rotate 45*y }
                        }
                box { <-.1,.6,-.8>,<.1,1,-.69> }
                }
        sphere { <0,1,0>,.69 }
        cylinder { <0,0,0>,<0,1,0>,.69 }
        }
difference {
        cylinder { <0,1.2,0>,<0,1.5,0>,.4 }
        cylinder { <0,1,0>,<0,2,0>,.3 }
        }
scale <.923,1,.923>
}
#declare palmtrunk = union {
        difference {
                union {
                        cylinder { <0,0,0>,<0,1.6,0>,.7 }
                        torus { .25,.25 translate -.2*y }
                        }
                cylinder { <.5,-1,.5>,<.5,-.2,.5>,.3 }
                cylinder { <-.5,-1,.5>,<-.5,-.2,.5>,.3 }
                cylinder { <.5,-1,-.5>,<.5,-.2,-.5>,.3 }
                cylinder { <-.5,-1,-.5>,<-.5,-.2,-.5>,.3 }
                torus { 9.55,9 }
                cylinder { <0,-1,0>,<0,.7,0>,.3 }
                box { <-1,-1,-1>,<1,-.4,1> }
                cylinder { <0,.8,0>,<0,2,0>,.5 }
                cylinder { <0,-1,0>,<0,2,0>,.2 }
                }
        difference {
                cylinder { <0,.75,0>,<0,1,0>,.3 }
                cylinder { <0,0,0>,<0,2,0>,.2 }
                }
}
#declare palmbase = union {
        difference {
                object { palmtrunk translate <0,.4,0> }
                box { <-1,-1,-1>,<1,.2,1> }
                }
        difference {
                box { <-1,0,-1>,<1,.4,1> }
                box { <-.8,-1,-.8>,<.8,.2,.8> }
                cylinder { <0,-1,0>,<0,1,0>,.3 }
                }
        difference {
                cylinder { <0,0,0>,<0,.25,0>,.407 }
                cylinder { <0,-1,0>,<0,1,0>,.3 }
                }
}
#declare bigbranch = difference {
        union {
                cylinder { <0,0,0>,<0,.4,0>,.407 }
                cylinder { <0,0,3>,<0,.4,3>,.407 }
                cylinder { <-2,0,3>,<-2,.4,3>,.407 }
                cylinder { <2,0,3>,<2,.4,3>,.407 }
                cylinder { <-2,0,5>,<-2,.4,5>,.407 }
                cylinder { <2,0,5>,<2,.4,5>,.407 }
                cylinder { <0,.25,0>,<0,.6,0>,.3 }
                cylinder { <-1,.25,1>,<-1,.6,1>,.3 }
                cylinder { <1,.25,1>,<1,.6,1>,.3 }
                cylinder { <-1,.25,2>,<-1,.6,2>,.3 }
                cylinder { <1,.25,2>,<1,.6,2>,.3 }
                cylinder { <-2,.25,3>,<-2,.6,3>,.3 }
                cylinder { <0,.25,3>,<0,.6,3>,.3 }
                cylinder { <2,.25,3>,<2,.6,3>,.3 }
                cylinder { <-2,.25,4>,<-2,.6,4>,.3 }
                cylinder { <2,.25,4>,<2,.6,4>,.3 }
                cylinder { <-2,.25,5>,<-2,.6,5>,.3 }
                cylinder { <-1,.25,5>,<-1,.6,5>,.3 }
                cylinder { <1,.25,5>,<1,.6,5>,.3 }
                cylinder { <2,.25,5>,<2,.6,5>,.3 }
                box { <-.2,.25,0>,<.2,.4,3> }
                box { <-2,.25,2.8>,<2,.4,3.2> }
                box { <-2,.25,3.8>,<-1,.4,4.2> }
                box { <1,.25,3.8>,<2,.4,4.2> }
                box { <-1.2,.25,4>,<-.8,.4,5> }
                box { <.8,.25,4>,<1.2,.4,5> }
                box { <-.2,.25,0>,<.2,.4,1.414> rotate 135*y translate <0,0,2> }
                box { <-.2,.25,0>,<.2,.4,1.414> rotate 225*y translate <0,0,2> }
                box { <-.2,.25,0>,<.2,.4,1.414> rotate 135*y translate <0,0,3> }
                box { <-.2,.25,0>,<.2,.4,1.414> rotate 225*y translate <0,0,3> }
                box { <-.2,.25,0>,<.2,.4,2.828> rotate 45*y translate <0,0,3> }
                box { <-.2,.25,0>,<.2,.4,2.828> rotate -45*y translate <0,0,3> }
                cylinder { <0,.25,3>,<0,.4,3>,.5 }
                }
        cylinder { <0,-1,0>,<0,1,0>,.2 }
        cylinder { <-1,-1,1>,<-1,1,1>,.2 }
        cylinder { <-1,-1,2>,<-1,1,2>,.2 }
        cylinder { <1,-1,1>,<1,1,1>,.2 }
        cylinder { <1,-1,2>,<1,1,2>,.2 }
        cylinder { <-2,-1,3>,<-2,1,3>,.2 }
        cylinder { <0,-1,3>,<0,1,3>,.2 }
        cylinder { <2,-1,3>,<2,1,3>,.2 }
        cylinder { <-2,-1,4>,<-2,1,4>,.2 }
        cylinder { <2,-1,4>,<2,1,4>,.2 }
        cylinder { <-2,-1,5>,<-2,1,5>,.2 }
        cylinder { <-1,-1,5>,<-1,1,5>,.2 }
        cylinder { <1,-1,5>,<1,1,5>,.2 }
        cylinder { <2,-1,5>,<2,1,5>,.2 }
        cylinder { <0,-1,0>,<0,.2,0>,.3 }
        cylinder { <-2,-1,3>,<-2,.2,3>,.3 }
        cylinder { <0,-1,3>,<0,.2,3>,.3 }
        cylinder { <2,-1,3>,<2,.2,3>,.3 }
        cylinder { <-2,-1,5>,<-2,.2,5>,.3 }
        cylinder { <2,-1,5>,<2,.2,5>,.3 }
        bounded_by { box { <-3,0,-1>,<3,.6,6> } }
}
#declare smallbranch = difference {
        union {
                cylinder { <0,0,0>,<0,.4,0>,.407 }
                cylinder { <0,0,3>,<0,.4,3>,.407 }
                cylinder { <0,.25,0>,<0,.6,0>,.3 }
                cylinder { <-1,.25,1>,<-1,.6,1>,.3 }
                cylinder { <1,.25,1>,<1,.6,1>,.3 }
                cylinder { <-1,.25,2>,<-1,.6,2>,.3 }
                cylinder { <1,.25,2>,<1,.6,2>,.3 }
                cylinder { <0,.25,3>,<0,.6,3>,.3 }
                box { <-.2,.25,0>,<.2,.4,3> }
                box { <-.2,.25,0>,<.2,.4,1.414> rotate 135*y translate <0,0,2> }
                box { <-.2,.25,0>,<.2,.4,1.414> rotate 225*y translate <0,0,2> }
                box { <-.2,.25,0>,<.2,.4,1.414> rotate 135*y translate <0,0,3> }
                box { <-.2,.25,0>,<.2,.4,1.414> rotate 225*y translate <0,0,3> }
                cylinder { <0,.25,3>,<0,.4,3>,.5 }
                }
        cylinder { <0,-1,0>,<0,1,0>,.2 }
        cylinder { <-1,-1,1>,<-1,1,1>,.2 }
        cylinder { <-1,-1,2>,<-1,1,2>,.2 }
        cylinder { <1,-1,1>,<1,1,1>,.2 }
        cylinder { <1,-1,2>,<1,1,2>,.2 }
        cylinder { <0,-1,3>,<0,1,3>,.2 }
        cylinder { <0,-1,0>,<0,.2,0>,.3 }
        cylinder { <0,-1,3>,<0,.2,3>,.3 }
        bounded_by { box { <-2,0,-1>,<2,.6,4> } }
        rotate 180*y translate 3*z
}
#macro SpiralTree (T,B,M,C,A,D)
#declare ctr = 1;
#declare H = 2;
union {
object { palmbase }
#while (ctr < T)
object { palmtrunk translate H*y }
#declare H=H+1.6;
#declare ctr=ctr+1;
#end
cylinder { <0,H-.8,0>,<0,H+.4,0>,.5 }
cylinder { <0,H+.2,0>,<0,H+.6,0>,.3 }
texture { LegoBrown } }
union {
#declare ctr = 0;
#declare H=H+.4;
#while (ctr < B)
object { smallbranch rotate A*y translate H*y }
#declare H=H+.4;
#declare A=A+D*53.1;
#declare ctr=ctr+1;
#end
#declare ctr=0;
#while (ctr < M)
object { bigbranch rotate A*y translate H*y }
#declare H=H+.4;
#declare A=A+D*67.4;
#declare ctr=ctr+1;
#end
#declare ctr=0;
#declare A=A-D*14.3;
#while (ctr < C)
object { smallbranch rotate A*y translate H*y }
#declare H=H+.4;
#declare A=A+D*53.1;
#declare ctr=ctr+1;
#end
texture { LegoGreen } }
#end

#declare fhatminus = union {
            intersection {
               object { supercone (10,25,22,0,0,44,47,32,6,0) }
               prism { -1,20,8 <30,0>,<19,-23.5>,<31,-80>,<-1,-80>,<-1,80>,<31,80>,<19,23.5>,<30,0> }
            }
            intersection {
               object { supercone (20,9,37,0,-20,29,13,32,6,-32) }
               prism { -1,20,6 <30,0>,<18.5,-23.5>,<31,-81>,<47,-66.3>,<48,-28>,<30,0> }
            }
            intersection {
               object { supercone (135,135,13,0,103,205,204.2,-9,6,153) }
               prism { -1,20,6 <30,0>,<47,-27.8>,<47,-67.3>,<162.83,-1.33>,<98.67,-.5>,<30,0> }
            }
            intersection {
               object { supercone (20,9,37,0,20,29,13,32,6,32) }
               prism { -1,20,6 <30,0>,<18.5,23.5>,<31,81>,<47,66.3>,<48,28>,<30,0> }
            }
            intersection {
               object { supercone (135,135,13,0,-103,205,204.2,-9,6,-153) }
               prism { -1,20,6 <30,0>,<47,27.8>,<47,67.3>,<162.83,1.33>,<98.67,.5>,<30,0> }
            }
            intersection {
               object { supercone (2,1,98,0,0,2,1,124,6,0) }
               prism { -1,20,6 <30,0>,<99.67,-.5>,<163.83,-1.33>,<163.83,1.33>,<99.67,.5>,<30,0> }
            }
            box { <18,0,-20>,<50,10,20> }
            box { <20,0,-.9>,<99,10,.9> matrix <1,0,0,4.333,1,0,0,0,1,0,0,0> }
            box { <20,0,-.4>,<100,10,.4> matrix <1,0,0,4.333,1,0,0,0,1,0,0,0> }
            scale <1,2,1>
}
#declare foresthat = difference  {
   union {
      difference {
         union {
            intersection {
               object { supercone(10,25,22,9,0,3,5,23,45,0) }
               prism { -1,60,6 <30,0>,<21.3,4.2>,<7.3,100.7>,<7.3,-100.7>,<21.3,-4.2>,<30,0> }
            }
            intersection {
               object { supercone(20,9,37,9,-20,9.5,2.5,30.5,45,-3.5) }
               prism { -1,60,6 <30,0>,<21.3,-4.2>,<7.3,-100.7>,<99,-115.8>,<34,-5.8>,<30,0> }
            }
            intersection {
               object { supercone(20,9,37,9,20,9.5,2.5,30.5,45,3.5) }
               prism { -1,60,6 <30,0>,<21.3,4.2>,<7.3,100.7>,<99,115.8>,<34,5.8>,<30,0> }
            }
            intersection {
               object { supercone(135,135,13,9,103,46,46,26.5,45,39.5) }
               prism { -1,60,6 <30,0>,<34,-5.8>,<99,-115.8>,<304.333,-.8>,<48.5,-.8>,<30,0> }
            }
            intersection {
               object { supercone(135,135,13,9,-103,46,46,26.5,45,-39.5) }
               prism { -1,60,6 <30,0>,<34,5.8>,<99,115.8>,<304.333,.8>,<48.5,.8>,<30,0> }
            }
            object { supercone(2,1,98.3,9,0,1,1,48.6,45,0) }
            object { supercone(11,5,32,45,0,33,25,48,9,0) }
            difference {
               box { <25,9,-1>,<98,45,1> }
               box { <0,-20,-2>,<100,200,2> rotate 54.3*z translate <98,9,0> }
            }
            matrix <1,-.09,0,0,1,0,0,0,1,0,9,0>
         }
         box { <-10,0,-100>,<100,30,100> rotate -7.8*z translate <20,45,0> }
         cylinder { <28,0,0>,<100,0,0>,12 scale <1,1,1> translate 51.5*y }
         sphere { <0,0,0>,12 scale <.85,1,1> translate <28,51.5,0> }
         bounded_by { box { <-1,0,-50>,<101,46,50> } }
      }
      difference {
         union {
            intersection {
               cylinder { <0,0,0>,<0,18,0>,1 scale <27,1,36> translate <27,0,0> }
               prism { -1,30,4 <30,0>,<-15,-175>,<-15,175>,<30,0> }
            }
            intersection {
               cylinder { <0,0,0>,<0,18,0>,1 scale <24.5,1,11> translate <34.5,0,-26> }
               prism { -1,30,4 <30,0>,<88,-177.5>,<-15,-175>,<30,0> }
            }
            intersection {
               cylinder { <0,0,0>,<0,18,0>,1 scale <170,1,169.6> translate <2,0,-128> }
               prism { -1,30,4 <30,0>,<88,177.5>,<415.5,3.333>,<30,0> }
            }
            intersection {
               cylinder { <0,0,0>,<0,18,0>,1 scale <24.5,1,11> translate <34.5,0,26> }
               prism { -1,30,4 <30,0>,<88,177.5>,<-15,175>,<30,0> }
            }
            intersection {
               cylinder { <0,0,0>,<0,18,0>,1 scale <170,1,169.6> translate <2,0,128> }
               prism { -1,30,4 <30,0>,<88,-177.5>,<415.5,-3.333>,<30,0> }
            }
            intersection {
               cylinder { <0,0,0>,<0,18,0>,1 scale <2,1,1> translate <111,0,0> }
               prism { -1,30,4 <30,0>,<415.5,-3.333>,<415.5,3.333>,<30,0> }
            }
            prism { 0,18,7 <21,-35>,<47,-35.5>,<112.5,-2/3>,<112.5,2/3>,<47,35.5>,<21,35>,<21,-35> }
         }
         intersection {
            cylinder { <45,-39.4,-80>,<45,-39.4,80>,57.4 inverse }
            box { <0,0,-80>,<100,100,80> translate <45,-39.4,0> }
            box { <0,0,-80>,<-100,100,80> rotate -20*z translate <45,-39.4,0> }
         }
         cylinder { <85,68.4,-80>,<85,68.4,80>,57.4 }
         box { <91,11,-80>,<200,50,80> }
         intersection {
            object { fhatminus }
            box { <-10,-10,-80>,<50.1,20,80> }
            translate <0,13,0>
         }
         intersection {
            object { fhatminus }
            box { <50,-10,-80>,<70,20,80> }
            translate -50*x
            matrix <1.4,-.2,0,0,1,0,0,0,1,0,0,0>
            translate <50,13,0>
         }
         intersection {
            object { fhatminus }
            box { <69.9,-10,-80>,<200,20,80> }
            translate <7,9,0>
         }
        bounded_by { box { <-1,-1,-70>,<114,19,70> } }
      }
      polygon { 5,<10,-5>,<50,-5>,<50,5>,<10,5>,<10,-5> rotate 90*x translate 13*y }
      polygon { 5,<70,-5>,<108,-5>,<108,5>,<70,5>,<70,-5> rotate 90*x translate 9*y }
      cylinder { <37,1,-29>,<37,18,-29>,5.85 }
   }
   box { <-10,0,-80>,<100,-10,80> rotate 3.75*z translate <45,0,0> }
   cylinder { <45,-1,0>,<45,9,0>,29.38 }
   cylinder { <45,-1,0>,<45,18,0>,13.56 }
   cylinder { <37,17.99,-29>,<37,50,-29>,9.04 }
   cylinder { <37,8.99,-29>,<37,50,-29>,3.4 }
   intersection {
      torus { 43,16 scale <1,1,1.371> translate <32,0,0> }
      box { <32,-1,-80>,<-10,20,80> }
   }
   bounded_by { box { <-1,-1,-80>,<114,50,80> } }
   translate -45*x
   scale (1/45.2)
   translate -.2*y
   rotate 90*y
}

#declare feather_small = union {
   intersection {
      torus { 24.42,.08 rotate 90*x translate <17,-6.5,0> }
      box { <-5,5.99,-1>,<17,20,1> }
   }
   intersection {
      torus { 4.92,.08 rotate 90*x scale <1.2,1,1> translate <17,13,0> }
      box { <16.99,13,-1>,<30,20,1> }
   }
   torus { 2.92,.08 rotate 90*x translate <20,13,0> }
   cylinder { <3,5.462>,<18,13.538>,.05 translate -.1055*x }
   intersection {
      cylinder { <17,-6.5,-.08>,<17,-6.5,.08>,24.45 }
      prism { -.1,.1,6 <3.8945,5.99>,<17,13>,<17,20>,<-5,20>,<-5,5.99>,<3.8945,5.99> rotate -90*x }
   }
   intersection {
      cylinder { <0,0,-.08>,<0,0,.08>,4.95 scale <1.2,1,1> translate <17,13,0> }
      box { <17,13,-.1>,<30,30,.1> }
   }
   cylinder { <20,13,-.08>,<20,13,.08>,2.95 }
   difference {
      torus { 1.65,.1 scale <10,1.6,10> rotate 90*x translate <14.5,-1.5,0> }
      box { <-10,-20,-1>,<30,5.99,1> }
      box { <-30,-20,-1>,<30,0,1> rotate 81.285*z translate <14.5,-1.5,0> }
      bounded_by { box { <-5,4,-1>,<25,20,1> } }
   }
   intersection {
      cone { <0,0,0>,.1 <10,0,0>,0 scale <1.6,10,1.6> rotate -8.7147*z translate <16.99,14.81,0> }
      plane { <1,0,0>,22.5 }
   }
   cylinder { <0,0,0>,<0,6,0>,4 }
   cylinder { <0,-4.5,0>,<0,1,0>,1.5 }
   sphere { <0,-4.5,0>,1.5 }
   scale .05
}

#declare shoulderpads = difference {
   union {
      cylinder { <-.75,0,0>,<-.75,.07,0>,.375 }
      cylinder { <-.75,0,0>,<-.75,.1,0>,.345 }
      torus { .345,.03 translate <-.75,.07,0> }
      cylinder { <.75,0,0>,<.75,.07,0>,.375 }
      cylinder { <.75,0,0>,<.75,.1,0>,.345 }
      torus { .345,.03 translate <.75,.07,0> }
      box { <-.75,0,-.375>,<.75,.07,.375> }
      box { <-.75,0,-.345>,<.75,.1,.345> }
      cylinder { <-.75,.07,-.345>,<.75,.07,-.345>,.03 }
      cylinder { <-.75,.07,.345>,<.75,.07,.345>,.03 }
      cylinder { <0,0,0>,<0,.07,0>,.5 }
      cylinder { <0,0,0>,<0,.1,0>,.48 }
      torus { .47,.03 translate <0,.07,0> }
      intersection {
         torus { .68,.12 translate .345*x rotate <90,-11.25,0> translate <-.75,-.3,0> }
         merge {
            cylinder { <0,0,0>,<-2,0,0>,.121 rotate -11.25*y scale <1,.5,1> translate <-.75,-.238,0> }
            box { <-2,-.238,-.12>,<0,.01,.12> rotate -11.25*y translate <-.75,0,0> }
         }
      }
      intersection {
         torus { .68,.12 translate .345*x rotate <90,-33.75,0> translate <-.75,-.3,0> }
         merge {
            cylinder { <0,0,0>,<-2,0,0>,.121 rotate -33.75*y scale <1,.5,1> translate <-.75,-.223,0> }
            box { <-2,-.223,-.12>,<0,.01,.12> rotate -33.75*y translate <-.75,0,0> }
         }
      }
      intersection {
         torus { .68,.12 translate .345*x rotate <90,-56.25,0> translate <-.75,-.3,0> }
         merge {
            cylinder { <0,0,0>,<-2,0,0>,.121 rotate -56.25*y scale <1,.5,1> translate <-.75,-.196,0> }
            box { <-2,-.196,-.12>,<0,.01,.12> rotate -56.25*y translate <-.75,0,0> }
         }
      }
      intersection {
         torus { .68,.12 translate .345*x rotate <90,-78.75,0> translate <-.75,-.3,0> }
         merge {
            cylinder { <0,0,0>,<-2,0,0>,.121 rotate -78.75*y scale <1,.5,1> translate <-.75,-.16,0> }
            box { <-2,-.16,-.12>,<0,.01,.12> rotate -78.75*y translate <-.75,0,0> }
         }
      }
      intersection {
         torus { .68,.12 translate .345*x rotate <90,-101.25,0> translate <-.75,-.3,0> }
         merge {
            cylinder { <0,0,0>,<-2,0,0>,.121 rotate -101.25*y scale <1,.5,1> translate <-.75,-.124,0> }
            box { <-2,-.124,-.12>,<0,.01,.12> rotate -101.25*y translate <-.75,0,0> }
         }
      }
      intersection {
         torus { .68,.12 translate .345*x rotate <90,11.25,0> translate <-.75,-.3,0> }
         merge {
            cylinder { <0,0,0>,<-2,0,0>,.121 rotate 11.25*y scale <1,.5,1> translate <-.75,-.238,0> }
            box { <-2,-.238,-.12>,<0,.01,.12> rotate 11.25*y translate <-.75,0,0> }
         }
      }
      intersection {
         torus { .68,.12 translate .345*x rotate <90,33.75,0> translate <-.75,-.3,0> }
         merge {
            cylinder { <0,0,0>,<-2,0,0>,.121 rotate 33.75*y scale <1,.5,1> translate <-.75,-.223,0> }
            box { <-2,-.223,-.12>,<0,.01,.12> rotate 33.75*y translate <-.75,0,0> }
         }
      }
      intersection {
         torus { .68,.12 translate .345*x rotate <90,56.25,0> translate <-.75,-.3,0> }
         merge {
            cylinder { <0,0,0>,<-2,0,0>,.121 rotate 56.25*y scale <1,.5,1> translate <-.75,-.196,0> }
            box { <-2,-.196,-.12>,<0,.01,.12> rotate 56.25*y translate <-.75,0,0> }
         }
      }
      intersection {
         torus { .68,.12 translate .345*x rotate <90,78.75,0> translate <-.75,-.3,0> }
         merge {
            cylinder { <0,0,0>,<-2,0,0>,.121 rotate 78.75*y scale <1,.5,1> translate <-.75,-.16,0> }
            box { <-2,-.16,-.12>,<0,.01,.12> rotate 78.75*y translate <-.75,0,0> }
         }
      }
      intersection {
         torus { .68,.12 translate .345*x rotate <90,101.25,0> translate <-.75,-.3,0> }
         merge {
            cylinder { <0,0,0>,<-2,0,0>,.121 rotate 101.25*y scale <1,.5,1> translate <-.75,-.124,0> }
            box { <-2,-.124,-.12>,<0,.01,.12> rotate 101.25*y translate <-.75,0,0> }
         }
      }
      intersection {
         torus { .68,.12 translate .345*x rotate <90,168.75,0> translate <.75,-.3,0> }
         merge {
            cylinder { <0,0,0>,<-2,0,0>,.121 rotate 168.75*y scale <1,.5,1> translate <.75,-.238,0> }
            box { <-2,-.238,-.12>,<0,.01,.12> rotate 168.75*y translate <.75,0,0> }
         }
      }
      intersection {
         torus { .68,.12 translate .345*x rotate <90,146.25,0> translate <.75,-.3,0> }
         merge {
            cylinder { <0,0,0>,<-2,0,0>,.121 rotate 146.25*y scale <1,.5,1> translate <.75,-.223,0> }
            box { <-2,-.223,-.12>,<0,.01,.12> rotate 146.25*y translate <.75,0,0> }
         }
      }
      intersection {
         torus { .68,.12 translate .345*x rotate <90,123.75,0> translate <.75,-.3,0> }
         merge {
            cylinder { <0,0,0>,<-2,0,0>,.121 rotate 123.75*y scale <1,.5,1> translate <.75,-.196,0> }
            box { <-2,-.196,-.12>,<0,.01,.12> rotate 123.75*y translate <.75,0,0> }
         }
      }
      intersection {
         torus { .68,.12 translate .345*x rotate <90,101.25,0> translate <.7,-.3,0> }
         merge {
            cylinder { <0,0,0>,<-2,0,0>,.121 rotate 101.25*y scale <1,.5,1> translate <.75,-.16,0> }
            box { <-2,-.16,-.12>,<0,.01,.12> rotate 101.25*y translate <.75,0,0> }
         }
      }
      intersection {
         torus { .68,.12 translate .345*x rotate <90,78.75,0> translate <.75,-.3,0> }
         merge {
            cylinder { <0,0,0>,<-2,0,0>,.121 rotate 78.75*y scale <1,.5,1> translate <.75,-.124,0> }
            box { <-2,-.124,-.12>,<0,.01,.12> rotate 78.75*y translate <.75,0,0> }
         }
      }
      intersection {
         torus { .68,.12 translate .345*x rotate <90,-168.75,0> translate <.75,-.3,0> }
         merge {
            cylinder { <0,0,0>,<-2,0,0>,.121 rotate -168.75*y scale <1,.5,1> translate <.75,-.238,0> }
            box { <-2,-.238,-.12>,<0,.01,.12> rotate -168.75*y translate <.75,0,0> }
         }
      }
      intersection {
         torus { .68,.12 translate .345*x rotate <90,-146.25,0> translate <.75,-.3,0> }
         merge {
            cylinder { <0,0,0>,<-2,0,0>,.121 rotate -146.25*y scale <1,.5,1> translate <.75,-.223,0> }
            box { <-2,-.223,-.12>,<0,.01,.12> rotate -146.25*y translate <.75,0,0> }
         }
      }
      intersection {
         torus { .68,.12 translate .345*x rotate <90,-123.75,0> translate <.75,-.3,0> }
         merge {
            cylinder { <0,0,0>,<-2,0,0>,.121 rotate -123.75*y scale <1,.5,1> translate <.75,-.196,0> }
            box { <-2,-.196,-.12>,<0,.01,.12> rotate -123.75*y translate <.75,0,0> }
         }
      }
      intersection {
         torus { .68,.12 translate .345*x rotate <90,-101.25,0> translate <.75,-.3,0> }
         merge {
            cylinder { <0,0,0>,<-2,0,0>,.121 rotate -101.25*y scale <1,.5,1> translate <.75,-.16,0> }
            box { <-2,-.16,-.12>,<0,.01,.12> rotate -101.25*y translate <.75,0,0> }
         }
      }
      intersection {
         torus { .68,.12 translate .345*x rotate <90,-78.75,0> translate <.75,-.3,0> }
         merge {
            cylinder { <0,0,0>,<-2,0,0>,.121 rotate -78.75*y scale <1,.5,1> translate <.75,-.124,0> }
            box { <-2,-.124,-.12>,<0,.01,.12> rotate -78.75*y translate <.75,0,0> }
         }
      }
      difference {
         cylinder { <-.75,.09,0>,<-.75,.125,0>,.3 }
         cylinder { <-.75,0,0>,<-.75,.2,0>,.25 }
      }
      cylinder { <-.75,.09,0>,<-.75,.125,0>,.15 }
      difference {
         cylinder { <.75,.09,0>,<.75,.125,0>,.3 }
         cylinder { <.75,0,0>,<.75,.2,0>,.25 }
      }
      cylinder { <.75,.09,0>,<.75,.125,0>,.15 }
   }
   cylinder { <0,-1,0>,<0,1,0>,.3 }
   sphere { <-.75,.3,0>,.2 }
   sphere { <.75,.3,0>,.2 }
   cone { <-.75,-.01,0>,.325 <-.75,-.6,0>,.425 }
   cone { <.75,-.01,0>,.325 <.75,-.6,0>,.425 }
   prism { -1,1,5 <-.7,.01>,<.7,.01>,<.8,.3>,<-.8,.3>,<-.7,.01> rotate 90*x }
   bounded_by { box { <-1.5,-.4,-.55>,<1.5,.2,.55> } }
}

/*#declare helmet_bars = union {
   difference {
      union {
         cylinder { <0,0,0>,<0,24,0>,15 }
         sphere { <0,0,0>,15 scale <1,.666,1> translate 24*y }
         difference {
            union {
               prism { -3,3,4 <-14.7,3>,<-18.7,16>,<-14,17>,<-15,3> rotate -90*x }
               cylinder { <-16.5,0,-3>,<-16.5,0,3>,2.5 scale <1,2,1> translate 18.5*y }
               box { <-19,18.5,-3>,<-14,29,3> }
               cylinder { <-11,29,-3>,<-11,29,3>,8 }
               box { <-11,29,-3>,<0,37,3> }
               cylinder { <0,21.5,-3>,<0,21.5,3>,15.5 }
            }
            box { <-20,0,-2.1>,<30,40,-10> rotate -3*y translate -5*x }
            box { <-20,0,2.1>,<30,40,10> rotate 3*y translate -5*x }
         }
         cylinder { <-5,30,0>,<-5,37,0>,3.8 }
         intersection {
            sphere { <0,0,0>,1 scale <16,20,15.5> translate <2.5,12.5,0> }
            prism { -20,20,4 <0,12>,<24,37>,<23,-7>,<0,12> rotate -90*x }
         }
      }
      prism { -20,20,4 <0,12>,<35,34>,<35,-4>,<0,12> translate 4*x rotate -90*x }
      cone { <5,0,0>,15 <30,0,0>,17 scale <1,.5,1> translate 12*y }
      cone { <5.01,0,0>,15 <-4,0,0>,0 scale <1,.5,1> translate 12*y }
      cylinder { <0,-1,0>,<0,22,0>,12 }
      cylinder { <0,0,0>,<0,26,0>,6 }
      cylinder { <0,-55,-30>,<0,-55,30>,56.9 }
   }
      difference {
      intersection {
         sphere { <0,0,0>,1 scale <9,10,12> translate <10.4,12.8,0> }
         union {
            box { <0,0,-1.1>,<30,30,1.1> }
            box { <0,0,-7>,<30,30,-9.2> }
            box { <0,0,7>,<30,30,9.2> }
         }
      }
      cylinder { <0,-10,0>,<0,40,0>,13 }
   }
   cylinder { <-2,12,-15.5>,<-2,12,-14>,4 }
   cylinder { <-2,12,-16>,<-2,12,-14>,3 }
   cylinder { <-2,12,15.5>,<-2,12,14>,4 }
   cylinder { <-2,12,16>,<-2,12,14>,3 }
   texture { LegoDkGray }
   rotate 90*y
}*/