//LEGO include file -- castle
// by David Fontaine
//
// castlewall                           1x2x6 window piece
// castlecorner                         3x3x6 octagonal tower piece
// castlewallgrayarch                   gray window w/ stone arch
// castlewallblackarch                  black window w/ stone arch
// castlewallgraystone                  gray window w/ stone wall pattern
// castlewallblackstone                 black window w/ stone wall pattern
// castlewallyellowwood                 yellow window w/ black lines
// castlecornergraystone                oct. tower piece gray w/ stones
// castlecornerblackstone               oct. tower piece black w/ stones

#declare castlewall = object {
        difference {
                merge {
                        difference {
                                union {
                                        object { roundbox (0,1.2,0,5,6,1) }
                                        object { roundbox (1,0,0,4,7.2,1) }
                                        object { roundbox (1,6.4,.5,4,6.8,2) }
                                        }
                                //box { <1.2,.4,.2>,<3.8,6.6,3> }
                                //box { <.2,1.6,.2>,<4.8,5.8,3> }
                                prism { -3,-.2,13 <1.2,.4>,<3.8,.4>,<3.8,1.6>,<4.8,1.6>,<4.8,5.8>,<3.8,5.8>,<3.8,6.6>,<1.2,6.6>,
                                                  <1.2,5.8>,<.2,5.8>,<.2,1.6>,<1.2,1.6>,<1.2,.4> rotate -90*x }
                                box { <1.1,6.8,.1>,<3.9,8,.9> }
                                box { <1.95,3.55,-1>,<3.05,5.1,3> }
                                cylinder { <2.5,5.1,-1>,<2.5,5.1,3>,.55 }
                                box { <.2,-1,.2>,<.8,1.4,.8> }
                                box { <1.2,-1,.2>,<3.8,.2,.8> }
                                box { <4.2,-1,.2>,<4.8,1.4,.8> }
                                }
                        cylinder { <.5,5.9,.5>,<.5,6.2,.5>,.3 }
                        cylinder { <1.5,6.7,.5>,<1.5,7.4,.5>,.3 }
                        cylinder { <2.5,6.7,.5>,<2.5,7.4,.5>,.3 }
                        cylinder { <3.5,6.7,.5>,<3.5,7.4,.5>,.3 }
                        cylinder { <4.5,5.9,.5>,<4.5,6.2,.5>,.3 }
                        cylinder { <1.5,6.7,1.5>,<1.5,7,1.5>,.3 }
                        cylinder { <2.5,6.7,1.5>,<2.5,7,1.5>,.3 }
                        cylinder { <3.5,6.7,1.5>,<3.5,7,1.5>,.3 }
                        cylinder { <2,0,.5>,<2,.3,.5>,.2 }
                        cylinder { <3,0,.5>,<3,.3,.5>,.2 }
                        }
                cylinder { <.5,6,.5>,<.5,7,.5>,.2 }
                cylinder { <1.5,6.8,.5>,<1.5,8,.5>,.2 }
                cylinder { <2.5,6.8,.5>,<2.5,8,.5>,.2 }
                cylinder { <3.5,6.8,.5>,<3.5,8,.5>,.2 }
                cylinder { <4.5,6,.5>,<4.5,7,.5>,.2 }
                cylinder { <1.5,6.8,1.5>,<1.5,8,1.5>,.2 }
                cylinder { <2.5,6.8,1.5>,<2.5,8,1.5>,.2 }
                cylinder { <3.5,6.8,1.5>,<3.5,8,1.5>,.2 }
                }
        bounded_by { box { <-.1,-.1,-.1>,<5.1,8,2.1> } }
}
#declare castlewallveneer = object {
        intersection {
                object { castlewall }
                box { <-1,-1,-1>,<6,9,.02> }
                }
        bounded_by { box { <-.1,-.1,-.1>,<5.1,8,.1> } }
}
#declare castlewallback = object {
        intersection {
                object { castlewall }
                box { <-1,-1,.019>,<6,9,5> }
                }
        bounded_by { box { <-.1,-.1,0>,<5.1,8,2.1> } }
}
#declare castlewallgrayarch = merge {
object { castlewallveneer
         texture { LegoGray }
         texture { pigment { image_map {
                gif "cw_agray.gif" transmit 255,1
                once } }
                scale <5.3,7.6,1> translate <-.01,-.44,0> }
}
object { castlewallback texture { LegoGray } }
}
#declare castlewallgraystone = merge {
object { castlewallveneer
         texture { LegoGray }
         texture { pigment { image_map {
                gif "cw_sgray.gif" transmit 255,1 
                once } }
                scale <5.3,7.7,1> translate <-.01,-.45,0> }
}
object { castlewallback texture { LegoGray } }
}
#declare castlewallblackarch = merge {
object { castlewallveneer
         texture { LegoBlack }
         texture { pigment { image_map {
                gif "cw_ablck.gif" transmit 255,1
                once } }
                scale <5.3,7.6,1> translate <-.01,-.44,0> }
}
object { castlewallback texture { LegoBlack } }
}
#declare castlewallblackstone = merge {
object { castlewallveneer
         texture { LegoBlack }
         texture { pigment { image_map {
                gif "cw_sblck.gif" transmit 255,1 
                once } }
                scale <5.3,7.7,1> translate <-.01,-.45,0> }
}
object { castlewallback texture { LegoBlack } }
}
#declare castlewallyellowwood = merge {
object { castlewallveneer
         texture { LegoYellow }
         texture { pigment { image_map {
                gif "cw_wdylw.gif" transmit 255,1 
                once } }
                scale <5.3,7.6,1> translate <-.01,-.44,0> }
}
object { castlewallback texture { LegoYellow } }
}
#declare castlecorner = object {
        difference {
                union {
                        difference {
                                object { roundbox (0,0,0,3,7.2,3) }
                                prism { -1,8,4 <-1,-1>,<-1,3>,<3,-1>,<-1,-1> }
                                box { <2,-1,-1>,<4,1.2,1> }
                                box { <-1,-1,2>,<1,1.2,4> }
                                box { <1.2,-1,1.2>,<2.8,.2,2.8> }
                                box { <2.2,-1,.2>,<2.8,1.4,.8> }
                                box { <.2,-1,2.2>,<.8,1.4,2.8> }
                                prism { -1,1,4 <1.3,1>,<1.8,1>,<1.8,.5>,<1.3,1> }
                                prism { -1,1,4 <1,1.3>,<1,1.8>,<.5,1.8>,<1,1.3> }
                                cylinder { <1.5,-1,.5>,<1.5,.2,.5>,.31 }
                                cylinder { <.5,-1,1.5>,<.5,.2,1.5>,.31 }
                                box { <1.2,.4,1.2>,<4,2,4> }
                                prism { 1.6,5.8,6 <2.2,.2>,<4,.2>,<4,4>,<.2,4>,<.2,2.2>,<2.2,.2> }
                                prism { 6,8,4 <3,-.8>,<3,3>,<-.8,3>,<3,-.8> }
                                box { <2,6,-1>,<4,8,4> }
                                box { <-1,6,2>,<4,8,4> }
                        }
                        prism { 5.6,5.9,5 <2.6,2.4>,<2.4,2.6>,<1,1.1>,<1.1,1>,<2.6,2.4> }
                        cylinder { <2,0,2>,<2,.3,2>,.407 }
                        cylinder { <.5,5.9,2.5>,<.5,6.2,2.5>,.3 }
                        cylinder { <1.5,5.9,2.5>,<1.5,6.2,2.5>,.3 }
                        cylinder { <2.5,5.9,2.5>,<2.5,6.2,2.5>,.3 }
                        cylinder { <2.5,5.9,1.5>,<2.5,6.2,1.5>,.3 }
                        cylinder { <2.5,5.9,.5>,<2.5,6.2,.5>,.3 }
                }
                cylinder { <2,-1,2>,<2,.2,2>,.3 }
                cylinder { <.5,6,2.5>,<.5,8,2.5>,.2 }
                cylinder { <1.5,6,2.5>,<1.5,8,2.5>,.2 }
                cylinder { <2.5,6,2.5>,<2.5,8,2.5>,.2 }
                cylinder { <2.5,6,1.5>,<2.5,8,1.5>,.2 }
                cylinder { <2.5,6,.5>,<2.5,8,.5>,.2 }
        }
        bounded_by { box { <-1,-1,-1>,<4,8,4> } }
}
#declare castlecornerveneer = intersection {
        object { castlecorner }
        prism { -1,7,8 <-1,-1>,<4,-1>,<4,.1>,<2,.1>,<.1,2>,<.1,4>,<-1,4>,<-1,-1> }
}
#declare castlecornerback = intersection {
        object { castlecorner }
        prism { -1,7,6 <4,.08>,<2,.08>,<.08,2>,<.08,4>,<4,4>,<4,.08> }
}
#declare castlecornergraystone = union {
        object { castlecornerback texture { LegoGray } }
        object { castlecornerveneer texture { LegoGray } 
                texture { pigment { image_map { gif "ct_sgray.gif" transmit 255,1 once } } 
                scale <5.5,7.55,5.5> rotate <0,45,0> translate <-1.8,-.4,2> } }
}
#declare castlecornerblackstone = union {
        object { castlecornerback texture { LegoBlack } }
        object { castlecornerveneer texture { LegoBlack } 
                texture { pigment { image_map { gif "ct_sblck.gif" transmit 255,1 once } } 
                scale <5.5,7.55,5.5> rotate <0,45,0> translate <-1.8,-.4,2> } } 
}
               
                                                               