//LEGO include file -- plates
// by David Fontaine
//
// name          | description
// -----------------------------------------------
// plate1x1      | 1x1 plate
// plate1x2      | 1x2 plate
// plate1x3      | 1x3 plate
// plate1x4      | 1x4 plate
// plate1x6      | 1x6 plate
// plate1x8      | 1x8 plate
// plate1x10     | 1x10 plate
// plate1x12     | 1x12 plate
// plate2x2      | 2x2 plate
// plate2x3      | 2x3 plate
// plate2x4      | 2x4 plate
// plate2x6      | 2x6 plate
// plate2x8      | 2x8 plate
// plate2x10     | 2x10 plate
// plate2x12     | 2x12 plate
// plate2x16     | 2x16 plate
// plate4x4      | 4x4 plate
// plate4x6      | 4x6 plate
// plate4x8      | 4x8 plate
// plate4x10     | 4x10 plate
// plate4x12     | 4x12 plate
// plate6x6      | 6x6 plate
// plate6x8      | 6x8 plate
// plate6x10     | 6x10 plate
// plate6x16     | 6x16 plate
// plate1x1r     | 1x1 round plate
// tplate4       | 1x4 technic plate
// tplate5       | 1x5 technic plate
// tplate6       | 1x6 technic plate
// tplate8       | 1x8 technic plate
// tplate10      | 1x10 technic plate
// tplate2x4     | 2x4 technic plate
// tplate2x6     | 2x6 technic plate
// tplate2x8     | 2x8 technic plate
// plate1x2h1    | 1x2 hinge piece (3 prong)
// plate1x2h2    |  "    "     "   (2 prong)
// plate1x2h3    |  "    "     "   (2 prong tile)
// tile1x1       | 1x1 tile
// tile1x2       | 1x2  "
// tile1x4       | 1x4  "
// tile1x8       | 1x8  "
// tile2x2       | 2x2  "
// tile2x2r      | 2x2 round tile
// plate2x2r     | 2x2 round plate
// plate2x2c     | 2x2 corner plate
// plate3x6o     | 3x6 half-octagon plate
// plate3x3o     | 3x3 quarter-octagon plate
// hook1         | 1x1 with hook on side
// plate4x4h     | 4x4 hinge plate
// plate1x4h     | 1x4 hinge plate
// plate1x2o     | 1x2 plate with 1 offset bump
// -----------------------------------------------

#declare platecorner = union {
         difference {
                    union {
                          superellipsoid { <.05,.05> translate <1,1,1> scale <.6,.2,.6> }
                          cylinder { <.5,.3,.5>,<.5,.6,.5>,.3 }
                          }
                    box { <.2,-1,.2>,<2,.2,2> }
                    }
         difference {
                    cylinder { <1,0,1>,<1,.3,1>,.407 }
                    cylinder { <1,-1,1>,<1,1,1>,.3 }
                    }
}

#declare plateedge = union {
         difference {
                    union {
                          superellipsoid { <.05,.05> translate <.9,1,1> scale <.6,.2,.6> }
                          cylinder { <.5,.3,.5>,<.5,.6,.5>,.3 }
                          }
                    box { <-1,-1,.2>,<2,.2,2> }
                    }
         difference {
                    cylinder { <1,0,1>,<1,.3,1>,.407 }
                    cylinder { <1,-1,1>,<1,1,1>,.3 }
                    }
         difference {
                    cylinder { <0,0,1>,<0,.3,1>,.407 }
                    cylinder { <0,-1,1>,<0,1,1>,.3 }
                    }
}

#declare platecenter = union {
         difference {
                    union {
                          superellipsoid { <.05,.05> translate <.9,1,.9> scale <.6,.2,.6> }
                          cylinder { <.5,.3,.5>,<.5,.6,.5>,.3 }
                          }
                    box { <-1,-1,-1>,<2,.2,2> }
                    }
         difference {
                    cylinder { <1,0,1>,<1,.3,1>,.407 }
                    cylinder { <1,-1,1>,<1,1,1>,.3 }
                    }
         difference {
                    cylinder { <0,0,1>,<0,.3,1>,.407 }
                    cylinder { <0,-1,1>,<0,1,1>,.3 }
                    }
         difference {
                    cylinder { <1,0,0>,<1,.3,0>,.407 }
                    cylinder { <1,-1,0>,<1,1,0>,.3 }
                    }
         difference {
                    cylinder { <0,0,0>,<0,.3,0>,.407 }
                    cylinder { <0,-1,0>,<0,1,0>,.3 }
                    }
}

#declare pplatend = object {
union {
      difference {
                 superellipsoid { <.05, .05> scale <.5,.2,.5> translate <.5,.2,.5> scale <1.2,1,1> }
                 box { <0.2,-.1,0.2>, <2,0.2,0.8> }
                 }
      cylinder { <1,0,.5>,<1,.3,.5>,.2 }
      cylinder { <.5,.3,.5>,<.5,.6,.5>,.3 }
      }
}

#declare pplatesec = union
               { difference
                  {
                  superellipsoid { <.05, .05> scale <.7,.2,.5> translate <.6,.2,.5> }
                  box { <-1,-.1,0.2>, <2,0.2,0.8> }
                  }
               cylinder { <0,0,.5>,<0,.3,.5>,.2 }
               cylinder { <1,0,.5>,<1,.3,.5>,.2 }
               cylinder { <.5,.3,.5>,<.5,.6,.5>,.3 }
               }

#declare tilecorner = union {
         difference {
                    superellipsoid { <.05,.05> translate <1,1,1> scale <.6,.2,.6> }
                    box { <.2,-1,.2>,<2,.2,2> }
                    }
         difference {
                    cylinder { <1,0,1>,<1,.3,1>,.407 }
                    cylinder { <1,-1,1>,<1,1,1>,.3 }
                    }
}

#declare ptileend = object {
union {
      difference {
                 superellipsoid { <.05, .05> scale <.5,.2,.5> translate <.5,.2,.5> scale <1.2,1,1> }
                 box { <0.2,-.1,0.2>, <1.3,0.2,0.8> }
                 }
      cylinder { <1,0,.5>,<1,.3,.5>,.2 }
      }
}

#declare ptilesec = union
               { difference
                  {
                  superellipsoid { <.05, .05> scale <.7,.2,.5> translate <.6,.2,.5> }
                  box { <-.1,-.1,0.2>, <1.1,0.2,0.8> }
                  }
               cylinder { <0,0,.5>,<0,.3,.5>,.2 }
               cylinder { <1,0,.5>,<1,.3,.5>,.2 }
               }

/**************/

#declare plate1x1 = object { makelego (0,0,0,1,.4,1) }

#declare plate1x2 = object { makelego (0,0,0,2,.4,1) }

#declare plate1x3 = object { makelego (0,0,0,3,.4,1) }

#declare plate1x4 = object { makelego (0,0,0,4,.4,1) }

#declare plate1x6 = object { makelego (0,0,0,6,.4,1) }

#declare plate1x8 = object { makelego (0,0,0,8,.4,1) }

#declare plate1x10 = object { makelego (0,0,0,10,.4,1) }

#declare plate1x12 = object { makelego (0,0,0,12,.4,1) }

#declare plate2x2 = object { makelego (0,0,0,2,.4,2) }

#declare plate2x3 = object { makelego (0,0,0,3,.4,2) }

#declare plate2x4 = object { makelego (0,0,0,4,.4,2) }

#declare plate2x6 = object { makelego (0,0,0,6,.4,2) }

#declare plate2x8 = object { makelego (0,0,0,8,.4,2) }

#declare plate2x10 = object { makelego (0,0,0,10,.4,2) }

#declare plate2x12 = object { makelego (0,0,0,12,.4,2) }

#declare plate2x16 = object { makelego (0,0,0,16,.4,2) }

#declare plate4x4 = object { makelego (0,0,0,4,.4,4) }

#declare plate4x6 = object { makelego (0,0,0,6,.4,4) }

#declare plate4x8 = object { makelego (0,0,0,8,.4,4) }

#declare plate4x10 = object { makelego (0,0,0,10,.4,4) }

#declare plate4x12 = object { makelego (0,0,0,12,.4,4) }

#declare plate6x6 = object { makelego (0,0,0,6,.4,6) }

#declare plate6x8 = object { makelego (0,0,0,8,.4,6) }

#declare plate6x10 = object { makelego (0,0,0,10,.4,6) }

 #declare plate6x16 = object { makelego (0,0,0,16,.4,6) }

#declare tile1x1 = difference {
         object { roundbox (0,0,0,1,.4,1) }
         box { <.2,-1,.2>,<.8,.2,.8> }
}

#declare tile1x2 = difference {
         object { roundbox (0,0,0,2,.4,1) }
         box { <.2,-1,.2>,<1.8,.2,.8> }
         bounded_by { box { <0,0,0>,<2,.4,1> } }
}

#declare tile1x4 = union {
         object { ptileend }
         object { ptilesec translate 1*x }
         object { ptilesec translate 2*x }
         object { ptileend rotate 180*y translate <4,0,1> }
}

#declare tile1x8 = union {
         object { ptileend }
         object { ptilesec translate 1*x }
         object { ptilesec translate 2*x }
         object { ptilesec translate 3*x }
         object { ptilesec translate 4*x }
         object { ptilesec translate 5*x }
         object { ptilesec translate 6*x }
         object { ptileend rotate 180*y translate <8,0,1> }
}

#declare tile2x2 = union {
         object { tilecorner }
         object { tilecorner rotate 90*y translate <0,0,2> }
         object { tilecorner rotate 180*y translate <2,0,2> }
         object { tilecorner rotate 270*y translate <2,0,0> }
}

#declare tile2x2r = union {
         difference {
                    cylinder { <1,0,1>,<1,.4,1>,1 }
                    cylinder { <1,-1,1>,<1,.2,1>,.8 }
                    cylinder { <.5,-1,.5>,<.5,.2,.5>,.325 }
                    cylinder { <1.5,-1,.5>,<1.5,.2,.5>,.325 }
                    cylinder { <.5,-1,1.5>,<.5,.2,1.5>,.325 }
                    cylinder { <1.5,-1,1.5>,<1.5,.2,1.5>,.325 }
                    }
         box { <-.407,0,-.05>,<.407,.3,.05> rotate 45*y translate <1,0,1> }
         box { <-.05,0,-.407>,<.05,.3,.407> rotate 45*y translate <1,0,1> }
}

#declare tplate4 = union {
         difference {
                    object { plate1x2 translate 1*x}
                    box { <1.1,-1,-1>,<-1,.2,2> }
                    box { <2.9,-1,-1>,<4,.2,2> }
                    cylinder { <1.5,.4,.5>,<1.5,1,.5>,.2 }
                    cylinder { <2.5,.4,.5>,<2.5,1,.5>,.2 }
                    }
         difference {
                    union {
                          box { <.5,.05,0>,<1.5,.4,.2> }
                          box { <.5,.05,.8>,<1.5,.4,1> }
                          box { <.5,.2,0>,<1.5,.4,1> }
                          cylinder { <.5,0,.5>,<.5,.4,.5>,.5 }
                          }
                    cylinder { <.5,-1,.5>,<.5,1,.5>,.3 }
                    cylinder { <.5,-1,.5>,<.5,.1,.5>,1 }
                    }
         difference {
                    difference {
                               cylinder { <.5,0,.5>,<.5,.1,.5>,.5 }
                               cylinder { <.5,-1,.5>,<.5,1,.5>,.3 }
                    }
                    object { lockminus rotate 11.25*y translate <.5,0,.5> }
                    }
         difference {
                    union {
                          box { <2.5,.05,0>,<3.5,.4,.2> }
                          box { <2.5,.05,.8>,<3.5,.2,1> }
                          box { <2.5,.2,0>,<3.5,.4,1> }
                          cylinder { <3.5,0,.5>,<3.5,.4,.5>,.5 }
                          }
                    cylinder { <3.5,-1,.5>,<3.5,1,.5>,.3 }
                    cylinder { <3.5,-1,.5>,<3.5,.1,.5>,1 }
                    }
         difference {
                    difference {
                               cylinder { <3.5,0,.5>,<3.5,.1,.5>,.5 }
                               cylinder { <3.5,-1,.5>,<3.5,1,.5>,.3 }
                    }
                    object { lockminus rotate 11.25*y translate <3.5,0,.5> }
                    }
}

#declare tplate6 = union {
         difference {
                    object { plate1x4 translate 1*x}
                    box { <1.1,-1,-1>,<-1,.2,2> }
                    box { <4.9,-1,-1>,<6,.2,2> }
                    cylinder { <1.5,.4,.5>,<1.5,1,.5>,.2 }
                    cylinder { <2.5,.4,.5>,<2.5,1,.5>,.2 }
                    cylinder { <3.5,.4,.5>,<3.5,1,.5>,.2 }
                    cylinder { <4.5,.4,.5>,<4.5,1,.5>,.2 }
                    }
         difference {
                    union {
                          box { <.5,.05,0>,<1.5,.4,.2> }
                          box { <.5,.05,.8>,<1.5,.4,1> }
                          box { <.5,.2,0>,<1.5,.4,1> }
                          cylinder { <.5,0,.5>,<.5,.4,.5>,.5 }
                          }
                    cylinder { <.5,-1,.5>,<.5,1,.5>,.3 }
                    cylinder { <.5,-1,.5>,<.5,.1,.5>,1 }
                    }
         difference {
                    difference {
                               cylinder { <.5,0,.5>,<.5,.1,.5>,.5 }
                               cylinder { <.5,-1,.5>,<.5,1,.5>,.3 }
                    }
                    object { lockminus rotate 11.25*y translate <.5,0,.5> }
                    }
         difference {
                    union {
                          box { <4.5,.05,0>,<5.5,.4,.2> }
                          box { <4.5,.05,.8>,<5.5,.2,1> }
                          box { <4.5,.2,0>,<5.5,.4,1> }
                          cylinder { <5.5,0,.5>,<5.5,.4,.5>,.5 }
                          }
                    cylinder { <5.5,-1,.5>,<5.5,1,.5>,.3 }
                    cylinder { <5.5,-1,.5>,<5.5,.1,.5>,1 }
                    }
         difference {
                    difference {
                               cylinder { <5.5,0,.5>,<5.5,.1,.5>,.5 }
                               cylinder { <5.5,-1,.5>,<5.5,1,.5>,.3 }
                    }
                    object { lockminus rotate 11.25*y translate <5.5,0,.5> }
                    }
}

#declare tplate8 = union {
         difference {
                    object { plate1x6 translate 1*x}
                    box { <1.1,-1,-1>,<-1,.2,2> }
                    box { <6.9,-1,-1>,<8,.2,2> }
                    cylinder { <1.5,.4,.5>,<1.5,1,.5>,.2 }
                    cylinder { <2.5,.4,.5>,<2.5,1,.5>,.2 }
                    cylinder { <3.5,.4,.5>,<3.5,1,.5>,.2 }
                    cylinder { <4.5,.4,.5>,<4.5,1,.5>,.2 }
                    cylinder { <5.5,.4,.5>,<5.5,1,.5>,.2 }
                    cylinder { <6.5,.4,.5>,<6.5,1,.5>,.2 }
                    }
         difference {
                    union {
                          box { <.5,.05,0>,<1.5,.4,.2> }
                          box { <.5,.05,.8>,<1.5,.4,1> }
                          box { <.5,.2,0>,<1.5,.4,1> }
                          cylinder { <.5,0,.5>,<.5,.4,.5>,.5 }
                          }
                    cylinder { <.5,-1,.5>,<.5,1,.5>,.3 }
                    cylinder { <.5,-1,.5>,<.5,.1,.5>,1 }
                    }
         difference {
                    difference {
                               cylinder { <.5,0,.5>,<.5,.1,.5>,.5 }
                               cylinder { <.5,-1,.5>,<.5,1,.5>,.3 }
                    }
                    object { lockminus rotate 11.25*y translate <.5,0,.5> }
                    }
         difference {
                    union {
                          box { <6.5,.05,0>,<7.5,.4,.2> }
                          box { <6.5,.05,.8>,<7.5,.2,1> }
                          box { <6.5,.2,0>,<7.5,.4,1> }
                          cylinder { <7.5,0,.5>,<7.5,.4,.5>,.5 }
                          }
                    cylinder { <7.5,-1,.5>,<7.5,1,.5>,.3 }
                    cylinder { <7.5,-1,.5>,<7.5,.1,.5>,1 }
                    }
         difference {
                    difference {
                               cylinder { <7.5,0,.5>,<7.5,.1,.5>,.5 }
                               cylinder { <7.5,-1,.5>,<7.5,1,.5>,.3 }
                    }
                    object { lockminus rotate 11.25*y translate <7.5,0,.5> }
                    }
}

#declare tplate10 = union {
         difference {
                    object { plate1x8 translate 1*x}
                    box { <1.1,-1,-1>,<-1,.2,2> }
                    box { <8.9,-1,-1>,<10,.2,2> }
                    cylinder { <1.5,.4,.5>,<1.5,1,.5>,.2 }
                    cylinder { <2.5,.4,.5>,<2.5,1,.5>,.2 }
                    cylinder { <3.5,.4,.5>,<3.5,1,.5>,.2 }
                    cylinder { <4.5,.4,.5>,<4.5,1,.5>,.2 }
                    cylinder { <5.5,.4,.5>,<5.5,1,.5>,.2 }
                    cylinder { <6.5,.4,.5>,<6.5,1,.5>,.2 }
                    cylinder { <7.5,.4,.5>,<7.5,1,.5>,.2 }
                    cylinder { <8.5,.4,.5>,<8.5,1,.5>,.2 }
                    }
         difference {
                    union {
                          box { <.5,.05,0>,<1.5,.4,.2> }
                          box { <.5,.05,.8>,<1.5,.4,1> }
                          box { <.5,.2,0>,<1.5,.4,1> }
                          cylinder { <.5,0,.5>,<.5,.4,.5>,.5 }
                          }
                    cylinder { <.5,-1,.5>,<.5,1,.5>,.3 }
                    cylinder { <.5,-1,.5>,<.5,.1,.5>,1 }
                    }
         difference {
                    difference {
                               cylinder { <.5,0,.5>,<.5,.1,.5>,.5 }
                               cylinder { <.5,-1,.5>,<.5,1,.5>,.3 }
                    }
                    object { lockminus rotate 11.25*y translate <.5,0,.5> }
                    }
         difference {
                    union {
                          box { <8.5,.05,0>,<9.5,.4,.2> }
                          box { <8.5,.05,.8>,<9.5,.2,1> }
                          box { <8.5,.2,0>,<9.5,.4,1> }
                          cylinder { <9.5,0,.5>,<9.5,.4,.5>,.5 }
                          }
                    cylinder { <9.5,-1,.5>,<9.5,1,.5>,.3 }
                    cylinder { <9.5,-1,.5>,<9.5,.1,.5>,1 }
                    }
         difference {
                    difference {
                               cylinder { <9.5,0,.5>,<9.5,.1,.5>,.5 }
                               cylinder { <9.5,-1,.5>,<9.5,1,.5>,.3 }
                    }
                    object { lockminus rotate 11.25*y translate <9.5,0,.5> }
                    }
}

#declare tplate2x4 = difference {
         object { plate2x4 }
         cylinder { <1,-1,1>,<1,2,1>,.3 }
         cylinder { <2,-1,1>,<2,2,1>,.3 }
         cylinder { <3,-1,1>,<3,2,1>,.3 }
         bounded_by { box { <0,0,0>,<4,.6,2> } }
}

#declare tplate2x6 = difference {
         object { plate2x6 }
         cylinder { <1,-1,1>,<1,2,1>,.3 }
         cylinder { <2,-1,1>,<2,2,1>,.3 }
         cylinder { <3,-1,1>,<3,2,1>,.3 }
         cylinder { <4,-1,1>,<4,2,1>,.3 }
         cylinder { <5,-1,1>,<5,2,1>,.3 }
         bounded_by { box { <0,0,0>,<6,.6,2> } }
}

#declare tplate2x8 = difference {
         object { plate2x8 }
         cylinder { <1,-1,1>,<1,2,1>,.3 }
         cylinder { <2,-1,1>,<2,2,1>,.3 }
         cylinder { <3,-1,1>,<3,2,1>,.3 }
         cylinder { <4,-1,1>,<4,2,1>,.3 }
         cylinder { <5,-1,1>,<5,2,1>,.3 }
         cylinder { <6,-1,1>,<6,2,1>,.3 }
         cylinder { <7,-1,1>,<7,2,1>,.3 }
         bounded_by { box { <0,0,0>,<8,.6,2> } }
}

#declare tplate5 = union {
          difference {
                     superellipsoid { <.05,.05> scale <2.5,.2,.5> translate <2.5,.2,.5> }
                     box { <-1,-1,-1>,<.5,2,2> }
                     box { <4.5,-1,-1>,<6,2,2> }
                     box { <-1,-1,-1>,<1.1,.05,2> }
                     box { <3.9,-1,-1>,<6,.05,2> }
                     box { <-1,-1,.2>,<1.1,.2,.8> }
                     box { <3.9,-1,.2>,<6,.2,.8> }
                     box { <1.2,-1,.2>,<1.8,.2,.8> }
                     box { <1.9,-1,.2>,<3.1,.2,.8> }
                     box { <3.2,-1,.2>,<3.8,.2,.8> }
                     cylinder { <.5,-1,.5>,<.5,2,.5>,.5 }
                     cylinder { <4.5,-1,.5>,<4.5,2,.5>,.5 }
                     box { <2.2,-1,.38>,<2.8,2,.62> }
                     box { <2.38,-1,.2>,<2.62,2,.8> }
                     }
          difference {
                     cylinder { <.5,0,.5>,<.5,.4,.5>,.5 }
                     cylinder { <.5,-1,.5>,<.5,2,.5>,.3 }
                     object { lockminus rotate 11.25*y scale <1,.05,1> translate <.5,0,.5> }
                     }
          difference {
                     cylinder { <4.5,0,.5>,<4.5,.4,.5>,.5 }
                     cylinder { <4.5,-1,.5>,<4.5,2,.5>,.3 }
                     object { lockminus rotate 11.25*y scale <1,.05,1> translate <4.5,0,.5> }
                     }
          difference {
                     cylinder { <1.5,.3,.5>,<1.5,.6,.5>,.3 }
                     cylinder { <1.5,-1,.5>,<1.5,2,.5>,.2 }
                     }
          difference {
                     cylinder { <3.5,.3,.5>,<3.5,.6,.5>,.3 }
                     cylinder { <3.5,-1,.5>,<3.5,2,.5>,.2 }
                     }
          difference {
                     cylinder { <2.5,0,.5>,<2.5,.4,.5>,.4 }
                     box { <2.2,-1,.38>,<2.8,2,.62> }
                     box { <2.38,-1,.2>,<2.62,2,.8> }
                     }
}

#declare plate1x2h1 = object {
         difference {
                    union {
                          object { plate1x2 }
                          cylinder { <2,.2,0>,<2,.2,1>,.2 }
                          box { <2,0,0>,<2.5,.4,.2> }
                          box { <2,0,.4>,<2.5,.4,.6> }
                          box { <2,0,.8>,<2.5,.4,1> }
                          cylinder { <2.5,.2,0>,<2.5,.2,.2>,.2 }
                          cylinder { <2.5,.2,.4>,<2.5,.2,.6>,.2 }
                          cylinder { <2.5,.2,.8>,<2.5,.2,1>,.2 }
                          }
                    box { <1.5,-1,.2>,<2,.2,.4> }
                    box { <1.5,-1,.6>,<2,.2,.8> }
                    cylinder { <.5,.4,.5>,<.5,1,.5>,.2 }
                    cylinder { <1.5,.4,.5>,<1.5,1,.5>,.2 }
                    }
}

#declare plate1x2h2 = object {
         union {
               difference {
                          object { plate1x2 }
                          cylinder { <.5,.4,.5>,<.5,1,.5>,.2 }
                          cylinder { <1.5,.4,.5>,<1.5,1,.5>,.2 }
                          }
               cylinder { <2,.2,0>,<2,.2,1>,.2 }
               box { <2,0,.2>,<2.5,.4,.4> }
               box { <2,0,.6>,<2.5,.4,.8> }
               cylinder { <2.5,.2,.2>,<2.5,.2,.4>,.2 }
               cylinder { <2.5,.2,.6>,<2.5,.2,.8>,.2 }
               }
}

#declare plate1x2h3 = object {
         union {
               difference {
                          object { roundbox (0,0,0,2.7,.4,1) }
                          box { <.2,-1,.2>,<10,.2,.8> }
                          }
               cylinder { <1,0,.5>,<1,.3,.5>,.2 }
               cylinder { <2,0,.5>,<2,.3,.5>,.2 }
               box { <2.3,.3,.2>,<2.7,.6,.4> }
               box { <2.3,.3,.6>,<2.7,.6,.8> }
               cylinder { <2.5,.6,.2>,<2.5,.6,.4>,.2 }
               cylinder { <2.5,.6,.6>,<2.5,.6,.8>,.2 }
               }
}

#declare plate1x1r = union {
         difference {
                    cylinder { <.5,0,.5>,<.5,.3,.5>,.407 }
                    cylinder { <.5,-1,.5>,<.5,1,.5>,.3 }
                    }
         cylinder { <.5,.2,.5>,<.5,.4,.5>,.5 }
         cylinder { <.5,.3,.5>,<.5,.6,.5>,.3 }
}

#declare plate2x2c = union {
         difference {
                    union {
                          object { roundbox (0,0,0,2,.4,1) }
                          object { roundbox (0,0,0,1,.4,2) }
                          object { bump translate <.5,.4,.5> }
                          object { bump translate <1.5,.4,.5> }
                          object { bump translate <.5,.4,1.5> }
                          }
                    box { <.2,-1,.2>,<1.8,.2,.8> }
                    box { <.2,-1,.2>,<.8,.2,1.8> }
                    }
         cylinder { <1,0,.5>,<1,.3,.5>,.2 }
         cylinder { <.5,0,1>,<.5,.3,1>,.2 }
}

#declare plate2x2r = difference {
        union {
                cylinder { <0,.2,0>,<0,.4,0>,1 }
                intersection {
                        union {
                                cylinder { <-.5,.3,-.5>,<-.5,.6,-.5>,.3 }
                                cylinder { <.5,.3,-.5>,<.5,.6,-.5>,.3 }
                                cylinder { <-.5,.3,.5>,<-.5,.6,.5>,.3 }
                                cylinder { <.5,.3,.5>,<.5,.6,.5>,.3 }
                                }
                        cylinder { <0,-1,0>,<0,1,0>,1 }
                        }
                intersection {
                        box { <-1,-1,-1>,<1,1,1> }
                        box { <-.8,-1,-.8>,<.8,1,.8> inverse }
                        cylinder { <0,0,0>,<0,.3,0>,1 }
                        }
                cylinder { <0,0,0>,<0,.3,0>,.407 }
                }
        cylinder { <0,-1,0>,<0,.2,0>,.3 }
        box { <-.3,.199,-.12>,<.3,1,.12> }
        box { <-.12,.199,-.3>,<.12,1,.3> }
}

#declare plate3x6o = difference {
        union {
                difference {
                        union {
                                object { roundbox (0,0,0,1,.4,1) }
                                object { roundbox (0,0,5,1,.4,6) }
                                object { roundbox (0,0,.5,1,.4,5.5) }
                                object { roundbox (2,0,2,3,.4,4) }
                                object { roundbox (-.5,-.2,-1.43,.5,.2,1.43) translate -.5*x rotate 45*y translate <2,.2,1> }
                                object { roundbox (-.5,-.2,-1.43,.5,.2,1.43) translate -.5*x rotate -45*y translate <2,.2,5> }
                                prism { 0,.4,5 <.5,.5>,<.5,5.5>,<2.5,3.5>,<2.5,2.5>,<.5,.5> }
                                }
                        prism { -1,.2,7 <.2,.2>,<.9,.2>,<2.8,2.1>,<2.8,3.9>,<.9,5.8>,<.2,5.8>,<.2,.2> }
                        box { <-.3,-1,-.3>,<.3,.1999,.3> rotate 45*y translate <1.5,0,.5> }
                        box { <-.3,-1,-.3>,<.3,.1999,.3> rotate 45*y translate <2.5,0,1.5> }
                        box { <-.3,-1,-.3>,<.3,.1999,.3> rotate 45*y translate <2.5,0,4.5> }
                        box { <-.3,-1,-.3>,<.3,.1999,.3> rotate 45*y translate <1.5,0,5.5> }
                        }
                box { <.1,0,-.1>,<.407,.3,.1> rotate -135*y translate <2,0,1> }
                box { <.1,0,-.1>,<.407,.3,.1> rotate 135*y translate <2,0,5> }
                cylinder { <1,0,1>,<1,.3,1>,.407 }
                cylinder { <1,0,2>,<1,.3,2>,.407 }
                cylinder { <1,0,3>,<1,.3,3>,.407 }
                cylinder { <1,0,4>,<1,.3,4>,.407 }
                cylinder { <1,0,5>,<1,.3,5>,.407 }
                cylinder { <2,0,2>,<2,.3,2>,.407 }
                cylinder { <2,0,3>,<2,.3,3>,.407 }
                cylinder { <2,0,4>,<2,.3,4>,.407 }
                cylinder { <.5,.3,.5>,<.5,.6,.5>,.3 }
                cylinder { <.5,.3,1.5>,<.5,.6,1.5>,.3 }
                cylinder { <.5,.3,2.5>,<.5,.6,2.5>,.3 }
                cylinder { <.5,.3,3.5>,<.5,.6,3.5>,.3 }
                cylinder { <.5,.3,4.5>,<.5,.6,4.5>,.3 }
                cylinder { <.5,.3,5.5>,<.5,.6,5.5>,.3 }
                cylinder { <1.5,.3,1.5>,<1.5,.6,1.5>,.3 }
                cylinder { <1.5,.3,2.5>,<1.5,.6,2.5>,.3 }
                cylinder { <1.5,.3,3.5>,<1.5,.6,3.5>,.3 }
                cylinder { <1.5,.3,4.5>,<1.5,.6,4.5>,.3 }
                cylinder { <2.5,.3,2.5>,<2.5,.6,2.5>,.3 }
                cylinder { <2.5,.3,3.5>,<2.5,.6,3.5>,.3 }
                }
        cylinder { <1,-1,1>,<1,.3,1>,.3 }
        cylinder { <1,-1,2>,<1,.3,2>,.3 }
        cylinder { <1,-1,3>,<1,.3,3>,.3 }
        cylinder { <1,-1,4>,<1,.3,4>,.3 }
        cylinder { <1,-1,5>,<1,.3,5>,.3 }
        cylinder { <2,-1,2>,<2,.3,2>,.3 }
        cylinder { <2,-1,3>,<2,.3,3>,.3 }
        cylinder { <2,-1,4>,<2,.3,4>,.3 }
        bounded_by { box { <0,0,0>,<3,.6,6> } }
}

#declare plate3x3o = difference {
        union {
                difference {
                        union {
                                object { roundbox (0,0,0,1,.4,1) }
                                object { roundbox (0,0,2,1,.4,3) }
                                object { roundbox (.5,0,2,2.5,.4,3) }
                                object { roundbox (0,0,.5,1,.4,2.5) }
                                object { roundbox (2,0,2,3,.4,3) }
                                object { roundbox (-.5,-.2,-1.43,.5,.2,1.43) translate -.5*x rotate 45*y translate <2,.2,1> }
                                prism { 0,.4,4 <.5,.5>,<.5,2.5>,<2.5,2.5>,<.5,.5> }
                                }
                        prism { -1,.2,6 <.2,.2>,<.9,.2>,<2.8,2.1>,<2.8,2.8>,<.2,2.8>,<.2,.2> }
                        box { <-.3,-1,-.3>,<.3,.1999,.3> rotate 45*y translate <1.5,0,.5> }
                        box { <-.3,-1,-.3>,<.3,.1999,.3> rotate 45*y translate <2.5,0,1.5> }
                        }
                box { <.1,0,-.1>,<.407,.3,.1> rotate -135*y translate <2,0,1> }
                cylinder { <1,0,1>,<1,.3,1>,.407 }
                cylinder { <1,0,2>,<1,.3,2>,.407 }
                cylinder { <2,0,2>,<2,.3,2>,.407 }
                cylinder { <.5,.3,.5>,<.5,.6,.5>,.3 }
                cylinder { <.5,.3,1.5>,<.5,.6,1.5>,.3 }
                cylinder { <.5,.3,2.5>,<.5,.6,2.5>,.3 }
                cylinder { <1.5,.3,1.5>,<1.5,.6,1.5>,.3 }
                cylinder { <1.5,.3,2.5>,<1.5,.6,2.5>,.3 }
                cylinder { <2.5,.3,2.5>,<2.5,.6,2.5>,.3 }
                }
        cylinder { <1,-1,1>,<1,.3,1>,.3 }
        cylinder { <1,-1,2>,<1,.3,2>,.3 }
        cylinder { <2,-1,2>,<2,.3,2>,.3 }
        bounded_by { box { <0,0,0>,<3,.6,3> } }
}

#declare hook1 = difference {
        union {
                object { plate1x1 }
                cylinder { <1.5,0,.5>,<1.5,.4,.5>,.4 }
                box { <.9,0,.3>,<1.5,.4,.7> }
                box { <1.5,0,.1>,<1.9,.4,.9> }
                }
        cylinder { <1.5,-1,.5>,<1.5,1,.5>,.2 }
        box { <1.7,-1,0>,<3,1,1> }
        box { <1.5,-1,.35>,<3,1,.65> }
        bounded_by { box { <0,0,0>,<1.9,.6,1> } }
}

#declare plate4x4h = union {
        difference {
                union {
                        object { roundbox (0,0,0,3.81,.4,4) }
                        cylinder { <3.8,.2,0>,<3.8,.2,4>,.2 }
                        cylinder { <.5,.3,.5>,<.5,.6,.5>,.3 }
                        cylinder { <1.5,.3,.5>,<1.5,.6,.5>,.3 }
                        cylinder { <2.5,.3,.5>,<2.5,.6,.5>,.3 }
                        cylinder { <.5,.3,1.5>,<.5,.6,1.5>,.3 }
                        cylinder { <1.5,.3,1.5>,<1.5,.6,1.5>,.3 }
                        cylinder { <2.5,.3,1.5>,<2.5,.6,1.5>,.3 }
                        cylinder { <.5,.3,2.5>,<.5,.6,2.5>,.3 }
                        cylinder { <1.5,.3,2.5>,<1.5,.6,2.5>,.3 }
                        cylinder { <2.5,.3,2.5>,<2.5,.6,2.5>,.3 }
                        cylinder { <.5,.3,3.5>,<.5,.6,3.5>,.3 }
                        cylinder { <1.5,.3,3.5>,<1.5,.6,3.5>,.3 }
                        cylinder { <2.5,.3,3.5>,<2.5,.6,3.5>,.3 }
                        }
                box { <3.6,-1,-1>,<5,1,.2> }
                box { <3.6,-1,.9>,<5,1,1.1> }
                box { <3.6,-1,1.9>,<5,1,2.1> }
                box { <3.6,-1,2.9>,<5,1,3.1> }
                box { <3.6,-1,3.8>,<5,1,5> }
                prism { -1,.2,21 <.2,.2>,<3.4,.2>,<3.4,.4>,<3.8,.4>,<3.8,.7>,<3.4,.7>,
                                 <3.4,1.3>,<3.8,1.3>,<3.8,1.7>,<3.4,1.7>,<3.4,2.3>,<3.8,2.3>,<3.8,2.7>,<3.4,2.7>,
                                 <3.4,3.3>,<3.8,3.3>,<3.8,3.6>,<3.4,3.6>,<3.4,3.8>,<.2,3.8>,<.2,.2> }
                }
        difference {
                cylinder { <1,0,1>,<1,.3,1>,.407 }
                cylinder { <1,-1,1>,<1,1,1>,.3 }
                }
        difference {
                cylinder { <1,0,2>,<1,.3,2>,.407 }
                cylinder { <1,-1,2>,<1,1,2>,.3 }
                box { <.8,-1,1>,<3,1,3> }
                }
        difference {
                cylinder { <1,0,3>,<1,.3,3>,.407 }
                cylinder { <1,-1,3>,<1,1,3>,.3 }
                }
}

#declare plate1x4h = union {
        difference {
                union {
                        cylinder { <.5,.3,.5>,<.5,.6,.5>,.3 }
                        cylinder { <.5,.3,1.5>,<.5,.6,1.5>,.3 }
                        cylinder { <.5,.3,2.5>,<.5,.6,2.5>,.3 }
                        cylinder { <.5,.3,3.5>,<.5,.6,3.5>,.3 }
                        object { roundbox (0,0,0,1.2,.4,4) }
                        cylinder { <1.2,.2,0>,<1.2,.2,4>,.2 }
                        }
                box { <.2,-1,.2>,<.8,.2,3.8> }
                box { <1,-1,.2>,<2,1,.9> }
                box { <1,-1,1.1>,<2,1,1.9> }
                box { <1,-1,2.1>,<2,1,2.9> }
                box { <1,-1,3.1>,<2,1,3.8> }
                }
        cylinder { <.5,0,1>,<.5,.3,1>,.2 }
        cylinder { <.5,0,2>,<.5,.3,2>,.2 }
        cylinder { <.5,0,3>,<.5,.3,3>,.2 }
}

#declare plate1x2o = union {
        difference {
                union {
                        object { roundbox (0,0,0,2,.4,1) }
                        cylinder { <1,.3,.5>,<1,.6,.5>,.3 }
                        }
                box { <.2,-1,.2>,<1.8,.2,.8> }
                cylinder { <1,.4,.5>,<1,1,.5>,.2 }
                }
        cylinder { <1,0,.5>,<1,.3,.5>,.2 }
}