//LEGO include file -- gears
// by David Fontaine
//
// name          | description
// -----------------------------------------------
// gear8         | 8-tooth gear
// gear12b       | 12-tooth bevel gear (new) *
// gear14b       | 14-tooth bevel gear (old)
// gear16        | 16-tooth gear
// gear16c       | 16-tooth conical gear *
// gear24        | 24-tooth gear (old)
// gear24n       | 24-tooth gear (new / no offset axle holes) *
// gear24b       | 24-tooth bevel gear (old) *
// gear24bn      | 24-tooth bevel gear (new) *
// gear24c       | 24-tooth clutch gear *
// gear40        | 40-tooth gear *
// geartt        | 24/56-tooth turntable *
// gear5w        | 5-tooth worm gear *
// gear28d       | 28-tooth differential (old)
// gear1624d     | 16/24-tooth differential (new) *
// gear10r       | 10-tooth gear rack
// gear8b        | 8-tooth ball *
// gear8rb       | 8-tooth gear rack w/ ball joints *
// gear14r       | 14-tooth rack w/ end holes *
// gear20r       | 20-tooth rack w/ end holes *
// gear50r       | 50-tooth gear rack *
// -----------------------------------------------
// *not yet implemented


#declare tooth1 = prism {
        linear_sweep
        linear_spline
        .25,.75,7
        <-.1,-.062>,<.1,-.08>,<.19,-.04>,<.19,.04>,<.1,.08>,<-.1,.062>,<-.1,-.062>
}

#declare tooth2 = prism {
        linear_sweep
        linear_spline
        .25,.75,7
        <-.1,-.099>,<.1,-.099>,<.19,-.05>,<.19,.05>,<.1,.099>,<-.1,.099>,<-.1,-.099>
}

#declare tooth3 = mesh {
         triangle { <-.2,.3,-.075>,<-.2,.3,.075>,<-.05,.3,-.075> }
         triangle { <-.2,.3,.075>,<-.05,.3,-.075>,<-.05,.3,.075> }
         triangle { <-.05,.3,-.075>,<-.05,.3,.075>,<.1,.3,-.0375> }
         triangle { <.1,.3,-.0375>,<.1,.3,.0375>,<-.05,.3,.075> }
         triangle { <-.2,.3,-.075>,<-.05,.3,-.075>,<0,.1,-.075> }
         triangle { <-.05,.3,-.075>,<0,.1,-.075>,<.2,.1,-.075> }
         triangle { <-.2,.3,.075>,<-.05,.3,.075>,<0,.1,.075> }
         triangle { <-.05,.3,.075>,<0,.1,.075>,<.2,.1,.075> }
         triangle { <-.05,.3,-.075>,<.1,.3,-.0375>,<.2,.2,-.0375> }
         triangle { <-.05,.3,-.075>,<.2,.2,-.0375>,<.2,.1,-.075> }
         triangle { <-.05,.3,.075>,<.1,.3,.0375>,<.2,.2,.0375> }
         triangle { <-.05,.3,.075>,<.2,.2,.0375>,<.2,.1,.075> }
         triangle { <.1,.3,-.0375>,<.1,.3,.0375>,<.2,.2,-.0375> }
         triangle { <.1,.3.0375>,<.2,.2,-.0375>,<.2,.2,.0375> }
         triangle { <.2,.2,-.0375>,<.2,.2,.0375>,<.2,.1,-.075> }
         triangle { <.2,.2,.0375>,<.2,.1,-.075>,<.2,.1,.075> }
         triangle { <0,.1,-.075>,<0,.1,.075>,<.2,.1,-.075> }
         triangle { <0,.1,.075>,<.2,.1,-.075>,<.2,.1,.075> }
}

#declare tooth4 = merge {
         object { tooth2 }
         cone { <.13,.74,0>,.061 <.13,1,0>,0 }
}

#declare tooth5 = prism {
         0,1,5
         <.068,0>,<.132,.19>,<.268,.19>,<.332,0>,<.068,0>
}

/************************/

#declare gear8 = difference {
        merge {
              object { tooth1 translate .4*x rotate 0*y }
              object { tooth1 translate .4*x rotate 45*y }
              object { tooth1 translate .4*x rotate 90*y }
              object { tooth1 translate .4*x rotate 135*y }
              object { tooth1 translate .4*x rotate 180*y }
              object { tooth1 translate .4*x rotate 225*y }
              object { tooth1 translate .4*x rotate 270*y }
              object { tooth1 translate .4*x rotate 315*y }
              cylinder { <0,.03,0>,<0,.97,0>,.4 }
              }
        box { <-.3,-.1,-.12>,<.3,1.1,.12> }
        box { <-.12,-.1,-.3>,<.12,1.1,.3> }
}

#declare gear16 = difference {
         merge {
               difference {
                         merge {
                               object { tooth2 translate .9*x rotate 0*y }
                               object { tooth2 translate .9*x rotate 22.5*y }
                               object { tooth2 translate .9*x rotate 45*y }
                               object { tooth2 translate .9*x rotate 67.5*y }
                               object { tooth2 translate .9*x rotate 90*y }
                               object { tooth2 translate .9*x rotate 112.5*y }
                               object { tooth2 translate .9*x rotate 135*y }
                               object { tooth2 translate .9*x rotate 157.5*y }
                               object { tooth2 translate .9*x rotate 180*y }
                               object { tooth2 translate .9*x rotate 202.5*y }
                               object { tooth2 translate .9*x rotate 225*y }
                               object { tooth2 translate .9*x rotate 247.5*y }
                               object { tooth2 translate .9*x rotate 270*y }
                               object { tooth2 translate .9*x rotate 292.5*y }
                               object { tooth2 translate .9*x rotate 315*y }
                               object { tooth2 translate .9*x rotate 337.5*y }
                               cylinder { <0,.25,0>,<0,.75,0>,.9 }
                               }
                         cylinder { <0,0,0>,<0,1,0>,.72 }
                         }
               cylinder { <0,.25,.53>,<0,.75,.53>,.333 }
               cylinder { <.53,.25,0>,<.53,.75,0>,.333 }
               cylinder { <0,.25,-.53>,<0,.75,-.53>,.333 }
               cylinder { <-.53,.25,0>,<-.53,.75,0>,.333 }
               cylinder { <0,.375,0>,<0,.625,0>,.9 }
               cylinder { <0,.03,0>,<0,.97,0>,.5 }
               }
         cylinder { <0,0,.53>,<0,1,.53>,.2 }
         cylinder { <.53,0,0>,<.53,1,0>,.2 }
         cylinder { <0,0,-.53>,<0,1,-.53>,.2 }
         cylinder { <-.53,0,0>,<-.53,1,0>,.2 }
         box { <-.5,0,-.12>,<.5,1,.12> }
         box { <-.12,0,-.5>,<.12,1,.5> }
}

#declare gear24 = difference {
         merge {
               difference {
                          merge {
                                object { tooth2 translate 1.4*x rotate 0*y }
                                object { tooth2 translate 1.4*x rotate 15*y }
                                object { tooth2 translate 1.4*x rotate 30*y }
                                object { tooth2 translate 1.4*x rotate 45*y }
                                object { tooth2 translate 1.4*x rotate 60*y }
                                object { tooth2 translate 1.4*x rotate 75*y }
                                object { tooth2 translate 1.4*x rotate 90*y }
                                object { tooth2 translate 1.4*x rotate 105*y }
                                object { tooth2 translate 1.4*x rotate 120*y }
                                object { tooth2 translate 1.4*x rotate 135*y }
                                object { tooth2 translate 1.4*x rotate 150*y }
                                object { tooth2 translate 1.4*x rotate 165*y }
                                object { tooth2 translate 1.4*x rotate 180*y }
                                object { tooth2 translate 1.4*x rotate 195*y }
                                object { tooth2 translate 1.4*x rotate 210*y }
                                object { tooth2 translate 1.4*x rotate 225*y }
                                object { tooth2 translate 1.4*x rotate 240*y }
                                object { tooth2 translate 1.4*x rotate 255*y }
                                object { tooth2 translate 1.4*x rotate 270*y }
                                object { tooth2 translate 1.4*x rotate 285*y }
                                object { tooth2 translate 1.4*x rotate 300*y }
                                object { tooth2 translate 1.4*x rotate 315*y }
                                object { tooth2 translate 1.4*x rotate 330*y }
                                object { tooth2 translate 1.4*x rotate 345*y }
                                cylinder { <0,.25,0>,<0,.75,.0>,1.4 }
                                }
                          cylinder { <0,0,0>,<0,1,0>,1.22 }
                          }
               cylinder { <0,.375,0>,<0,.625,0>,1.3 }
               difference {
                          cylinder { <0,.02,0>,<0,.98,0>,.6 }
                          cylinder { <-.5,0,-.5>,<-.5,1,-.5>,.4 }
                          cylinder { <.5,0,-.5>,<.5,1,-.5>,.4 }
                          cylinder { <-.5,0,.5>,<-.5,1,.5>,.4 }
                          cylinder { <.5,0,.5>,<.5,1,.5>,.4 }
                          }
               cylinder { <-.5,.1,-.5>,<-.5,.9,-.5>,.4 }
               cylinder { <.5,.1,-.5>,<.5,.9,-.5>,.4 }
               cylinder { <-.5,.1,.5>,<-.5,.9,.5>,.4 }
               cylinder { <.5,.1,.5>,<.5,.9,.5>,.4 }
               }
         box { <-.8,0,-.12>,<.8,1,.12> }
         box { <-.12,0,-.3>,<.12,1,.3> }
         box { <-.12,0,-.3>,<.12,1,.5> rotate 45*y translate -.82*x }
         box { <-.3,0,-.12>,<.5,1,.12> rotate 45*y translate -.82*x }
         box { <-.12,0,-.5>,<.12,1,.3> rotate 45*y translate .82*x }
         box { <-.5,0,-.12>,<.3,1,.12> rotate 45*y translate .82*x }
         cylinder { <-.5,0,-.5>,<-.5,1,-.5>,.3 }
         cylinder { <.5,0,-.5>,<.5,1,-.5>,.3 }
         cylinder { <-.5,0,.5>,<-.5,1,.5>,.3 }
         cylinder { <.5,0,.5>,<.5,1,.5>,.3 }
}

#declare gear14b = difference {
         merge {
               object { tooth3 translate .7*x rotate 0*y }
               object { tooth3 translate .7*x rotate 25.714*y }
               object { tooth3 translate .7*x rotate 51.429*y }
               object { tooth3 translate .7*x rotate 77.143*y }
               object { tooth3 translate .7*x rotate 102.857*y }
               object { tooth3 translate .7*x rotate 128.571*y }
               object { tooth3 translate .7*x rotate 154.286*y }
               object { tooth3 translate .7*x rotate 180*y }
               object { tooth3 translate .7*x rotate 205.714*y }
               object { tooth3 translate .7*x rotate 231.429*y }
               object { tooth3 translate .7*x rotate 257.143*y }
               object { tooth3 translate .7*x rotate 282.857*y }
               object { tooth3 translate .7*x rotate 308.571*y }
               object { tooth3 translate .7*x rotate 334.286*y }
               cone { <0,.1,0>,.71 <0,.3,0>,.51 }
               cylinder { <0,0,0>,<0,.11,0>,.6 }
               }
         cylinder { <0,-1,0>,<0,.1,0>,.45 }
         box { <-.3,-1,-.12>,<.3,1,.12> }
         box { <-.12,-1,-.3>,<.12,1,.3> }
}

#declare gear28d = difference { merge {
         difference {
                    merge {
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 0*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 12.857*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 25.714*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 38.571*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 51.429*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 64.286*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 77.143*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 90*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 102.857*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 115.714*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 128.571*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 141.429*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 154.286*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 167.143*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 180*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 192.857*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 205.714*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 218.571*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 231.429*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 244.286*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 257.143*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 270*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 282.857*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 295.714*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 308.571*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 321.429*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 334.826*y }
                          object { tooth4 scale <1,.8,1> translate <1.65,.5,0> rotate 347.143*y }
                          cylinder { <0,.7,0>,<0,1.1,0>,1.65 }
                          }
                    cylinder { <0,.98,0>,<0,1.2,0>,1.2 }
                    }
                    difference {
                               merge {
                                     cylinder { <0,.9,0>,<0,3.3,0>,1.3 }
                                     cylinder { <0,.02,0>,<0,3.98,0>,.45 }
                                     }
                               box { <-2,0,-.45>,<2,4,-2> }
                               box { <-2,0,.45>,<2,4,2> }
                               box { <-1.02,.98,-2>,<1.02,3.02,2> }
                               }
                    cylinder { <1.1,2,0>,<.6,2,0>,.168 }
                    }
                    cylinder { <0,0,0>,<0,4,0>,.3 }
}

#declare gear10r = merge {
         object { tooth5 rotate <-90,0,0> translate <0,.4,1> }
         object { tooth5 rotate <-90,0,0> translate <.4.4,1> }
         object { tooth5 rotate <-90,0,0> translate <.8,.4,1> }
         object { tooth5 rotate <-90,0,0> translate <1.2,.4,1> }
         object { tooth5 rotate <-90,0,0> translate <1.6,.4,1> }
         object { tooth5 rotate <-90,0,0> translate <2,.4,1> }
         object { tooth5 rotate <-90,0,0> translate <2.4,.4,1> }
         object { tooth5 rotate <-90,0,0> translate <2.8,.4,1> }
         object { tooth5 rotate <-90,0,0> translate <3.2,.4,1> }
         object { tooth5 rotate <-90,0,0> translate <3.6,.4,1> }
         difference {
                    box { <0,0,0>,<4,.41,1> }
                    box { <.2,-1,.2>,<3.8,.2,.8> }
                    }
         difference {
                    cylinder { <1,0,.5>,<1,.3,.5>,.2 }
                    cylinder { <1,-1,.5>,<1,.3,.5>,.08 }
                    }
         difference {
                    cylinder { <2,0,.5>,<2,.3,.5>,.2 }
                    cylinder { <2,-1,.5>,<2,.3,.5>,.08 }
                    }
         difference {
                    cylinder { <3,0,.5>,<3,.3,.5>,.2 }
                    cylinder { <3,-1,.5>,<3,.3,.5>,.08 }
                    }
}
