//LEGO include file -- beams
// by David Fontaine
//
// name          | description
// -----------------------------------------------
// beam1x1       | 1x1 brick
// beam1x2       | 1x2 brick
// beam1x3       | 1x3 brick
// beam1x4       | 1x4 brick
// beam1x6       | 1x6 brick
// beam1x8       | 1x8 brick
// beam1x10      | 1x10 brick
// beam1x12      | 1x12 brick
// beam1x16      | 1x16 brick
// beam1x2c      | 1x2 slant brick (overhang)
// beam1x2f      | 1x2 slant brick
// pillar1_5     | 1x1x5 pillar
// pillar2_5     | 1x2x5 pillar
// beam3f        | 1x1x3 slant brick*
// beam3c        | 1x1x3 slant brick (overhang)*
// beam1x3c      | 1x3x1 slant brick (overhang)*
// beam1x3f      | 1x3x1 slant brick*
// -----------------------------------------------


#declare beam1x1 = object { makelego (0,0,0,1,1.2,1) }

#declare beam1x2 = object { makelego (0,0,0,2,1.2,1) }

#declare beam1x3 = object { makelego (0,0,0,3,1.2,1) }

#declare beam1x4 = object { makelego (0,0,0,4,1.2,1) }

#declare beam1x6 = object { makelego (0,0,0,6,1.2,1) }

#declare beam1x8 = object { makelego (0,0,0,8,1.2,1) }

#declare beam1x10 = object { makelego (0,0,0,10,1.2,1) }

#declare beam1x12 = object { makelego (0,0,0,12,1.2,1) }

#declare beam1x16 = object { makelego (0,0,0,16,1.2,1) }

#declare beam1x2c = union {
         difference {
                union {
                        object { roundbox (0,0,0,2,1.2,1) }
                        cylinder { <.5,1.1,.5>,<.5,1.4,.5>,.3 }
                        }
                box { <.2,-1,.2>,<.8,1,.8> }
                prism { -.2,-.8,4 <1,2>,<1,.4>,<2.6,2>,<1,2> rotate -90*x }
                }
        difference {
                        cylinder { <1.5,.2,.5>,<1.5,1.4,.5>,.3 }
                        cylinder { <1.5,.1,.5>,<1.5,1.5,.5>,.2 }
                        }
        }
#declare beam1x2cd = prism { -2,1,4 <0,-1>,<3,-1>,<3,2>,<0,-1> rotate -90*x }

#declare beam1x2f = union {
        difference {
                object { roundbox (0,0,0,2,1.2,1) }
                prism { -.2,-.8,6 <.2,-1>,<.2,1>,<1,1>,<1.8,.2>,<1.8,-1>,<.2,-1> rotate -90*x }
                }
        cylinder { <1,0,.5>,<1,1.01,.5>,.2 }
        cylinder { <.5,1.1,.5>,<.5,1.4,.5>,.3 }
        }
#declare beam1x2fd = prism { -2,1,4 <0,2.2>,<2.2,0>,<2.2,2.2>,<0,2.2> rotate -90*x }

#declare pillar1_5 = difference {
        union {
                object { roundbox (0,0,0,1,6,1) }
                cylinder { <.5,5.9,.5>,<.5,6.2,.5>,.3 }
                }
        box { <.2,-1,.2>,<.2,5.8,.2> }
        }
#declare pillar2_5 = difference {
        union {
                object { roundbox (0,0,0,2,6,1) }
                cylinder { <.5,5.9,.5>,<.5,6.2,.5>,.3 }
                cylinder { <1.5,5.9,.5>,<1.5,6.2,.5>,.3 }
                }
        box { <.2,-1,.2>,<.8,5.8,.8> }
        }