//LEGO include file -- Technic beams
// by David Fontaine
// must come after "lego_beams.inc"
//
// name          | description
// -----------------------------------------------
// tbeam1x1      | technic 1x1x1 beam
// tbeam1x2      | technic 1x2x1 beam
// tbeam1x2dbl   | technic 1x2x1 beam 2 holes
// tbeam1x4      | technic 1x4x1 beam
// tbeam1x6      | technic 1x6x1 beam
// tbeam1x8      | technic 1x8x1 beam
// tbeam1x10     | technic 1x10x1 beam
// tbeam1x12     | technic 1x12x1 beam
// tbeam1x14     | technic 1x14x1 beam
// tbeam1x16     | technic 1x16x1 beam 
// thbeam5       | technic .5x5x1 beam *
// thbeam6       | technic .5x6x1 beam *  
// thbeam7       | technic .5x7x1 beam *  
// tabeam6x4     | technic beam 1 angle * 
// tabeam7x3.5x3 | technic beam 2 angles *
// ttriangle     | technic 5x3 triangle * 
// tlift3        | technic liftarm 1x3 * 
// tlift3x3      | technic liftarm 3x3 * 
// tlift4        | technic liftarm 1x4 *
// -----------------------------------------------
// *not yet implemented 


#declare ptbeamend = object {
         difference {
           union {
           intersection {
           object { roundbox (0,0,0,1.2,1.2,1) }
           box { <.2,-.1,.2>,<1.3,1,.8> inverse }
           }
           cylinder { <.5,1.1,.5>,<.5,1.4,.5>,.3 }
           cylinder { <1,.7,0>,<1,.7,1>,.408 }
           }
         cylinder { <1,.7,-.1>,<1,.7,1.1>,.3 }
         cylinder { <1,.7,-.1>,<1,.7,.1>,.407 }
         cylinder { <1,.7,.9>,<1,.7,1.1>,.407 }
         cylinder { <.5,1.2,.5>,<.5,1.5,.5>,.2 }
         }
}

#declare ptbeamsec = difference
         { union
            {
           intersection {
           object { roundbox (-.2,0,0,1.2,1.2,1) }
           box { <-.3,-.1,.2>,<1.3,1,.8> inverse }
           }
            cylinder { <.5,1.1,.5>,<.5,1.4,.5>,.3 }
            cylinder { <1,.7,0>,<1,.7,1>,.408 }
            cylinder { <0,.7,0>,<0,.7,1>,.408 }
            }
         cylinder { <0,.7,-.1>,<0,.7,1.1>,.3 }
         cylinder { <0,.7,-.1>,<0,.7,.1>,.407 }
         cylinder { <0,.7,.9>,<0,.7,1.1>,.407 }
         cylinder { <1,.7,-.1>,<1,.7,1.1>,.3 }
         cylinder { <1,.7,-.1>,<1,.7,.1>,.407 }
         cylinder { <1,.7,.9>,<1,.7,1.1>,.407 }
         cylinder { <.5,1.2,.5>,<.5,1.5,.5>,.2 }
         }

#declare ptbeamenddbl = difference
         { union
            {
           intersection {
           object { roundbox (0,0,0,1.2,1.2,1) }
           box { <.2,-.1,.2>,<1.3,1,.8> inverse }
           }
           cylinder { <.5,1.1,.5>,<.5,1.4,.5>,.3 }
            cylinder { <.5,.7,0>,<.5,.7,1>,.408 }
            }
         cylinder { <.5,.7,-.1>,<.5,.7,1.1>,.3 }
         cylinder { <.5,.7,-.1>,<.5,.7,.1>,.407 }
         cylinder { <.5,.7,.9>,<.5,.7,1.1>,.407 }
         cylinder { <.5,1.2,.5>,<.5,1.5,.5>,.2 }
         box { <1.01,-.1,-.1>,<2,2,1.1> }
         }

//#declare ptbeamsecdbl = difference
//         { union
//            {
//            object { pbeamsec }
//            cylinder { <.5,.7,0>,<.5,.7,1>,.407 }
//            }
//         cylinder { <.5,.7,-.1>,<.5,.7,1.1>,.3 }
//         cylinder { <.5,.7,-.1>,<.5,.7,.1>,.407 }
//         cylinder { <.5,.7,.9>,<.5,.7,1.1>,.407 }
//         cylinder { <.5,1.2,.5>,<.5,1.5,.5>,.2 }
//         }

#declare tbeam1x1 = difference
         { union
            {
            object { beam1x1 }
            cylinder { <.5,.7,0>,<.5,.7,1>,.407 }
            }
         cylinder { <.5,.7,-.1>,<.5,.7,1.1>,.3 }
         cylinder { <.5,.7,-.1>,<.5,.7,.1>,.407 }
         cylinder { <.5,.7,.9>,<.5,.7,1.1>,.407 }
         cylinder { <.5,1.2,.5>,<.5,1.5,.5>,.2 }
}

#declare tbeam1x2 = union {
         object { ptbeamend }
         object { ptbeamend rotate 180*y translate <2,0,1> }
}

#declare tbeam1x2dbl = union {
         object { ptbeamenddbl }
         object { ptbeamenddbl rotate 180*y translate <2,0,1> }
}

#declare tbeam1x4 = union {
         object { ptbeamend }
         object { ptbeamsec translate <1,0,0> }
         object { ptbeamsec translate <2,0,0> }
         object { ptbeamend rotate 180*y translate <4,0,1> }
}

#declare tbeam1x6 = union {
         object { ptbeamend }
         object { ptbeamsec translate <1,0,0> }
         object { ptbeamsec translate <2,0,0> }
         object { ptbeamsec translate <3,0,0> }
         object { ptbeamsec translate <4,0,0> }
         object { ptbeamend rotate 180*y translate <6,0,1> }
}

#declare tbeam1x8 = union {
         object { ptbeamend }
         object { ptbeamsec translate <1,0,0> }
         object { ptbeamsec translate <2,0,0> }
         object { ptbeamsec translate <3,0,0> }
         object { ptbeamsec translate <4,0,0> }
         object { ptbeamsec translate <5,0,0> }
         object { ptbeamsec translate <6,0,0> }
         object { ptbeamend rotate 180*y translate <8,0,1> }
}

#declare tbeam1x10 = union {
         object { ptbeamend }
         object { ptbeamsec translate <1,0,0> }
         object { ptbeamsec translate <2,0,0> }
         object { ptbeamsec translate <3,0,0> }
         object { ptbeamsec translate <4,0,0> }
         object { ptbeamsec translate <5,0,0> }
         object { ptbeamsec translate <6,0,0> }
         object { ptbeamsec translate <7,0,0> }
         object { ptbeamsec translate <8,0,0> }
         object { ptbeamend rotate 180*y translate <10,0,1> }
}

#declare tbeam1x12 = union {
         object { ptbeamend }
         object { ptbeamsec translate <1,0,0> }
         object { ptbeamsec translate <2,0,0> }
         object { ptbeamsec translate <3,0,0> }
         object { ptbeamsec translate <4,0,0> }
         object { ptbeamsec translate <5,0,0> }
         object { ptbeamsec translate <6,0,0> }
         object { ptbeamsec translate <7,0,0> }
         object { ptbeamsec translate <8,0,0> }
         object { ptbeamsec translate <9,0,0> }
         object { ptbeamsec translate <10,0,0> }
         object { ptbeamend rotate 180*y translate <12,0,1> }
}

#declare tbeam1x14 = union {
         object { ptbeamend }
         object { ptbeamsec translate <1,0,0> }
         object { ptbeamsec translate <2,0,0> }
         object { ptbeamsec translate <3,0,0> }
         object { ptbeamsec translate <4,0,0> }
         object { ptbeamsec translate <5,0,0> }
         object { ptbeamsec translate <6,0,0> }
         object { ptbeamsec translate <7,0,0> }
         object { ptbeamsec translate <8,0,0> }
         object { ptbeamsec translate <9,0,0> }
         object { ptbeamsec translate <10,0,0> }
         object { ptbeamsec translate <11,0,0> }
         object { ptbeamsec translate <12,0,0> }
         object { ptbeamend rotate 180*y translate <14,0,1> }
}

#declare tbeam1x16 = union {
         object { ptbeamend }
         object { ptbeamsec translate <1,0,0> }
         object { ptbeamsec translate <2,0,0> }
         object { ptbeamsec translate <3,0,0> }
         object { ptbeamsec translate <4,0,0> }
         object { ptbeamsec translate <5,0,0> }
         object { ptbeamsec translate <6,0,0> }
         object { ptbeamsec translate <7,0,0> }
         object { ptbeamsec translate <8,0,0> }
         object { ptbeamsec translate <9,0,0> }
         object { ptbeamsec translate <10,0,0> }
         object { ptbeamsec translate <11,0,0> }
         object { ptbeamsec translate <12,0,0> }
         object { ptbeamsec translate <13,0,0> }
         object { ptbeamsec translate <14,0,0> }
         object { ptbeamend rotate 180*y translate <16,0,1> }
}
