//LEGO include file -- miscellaneous
//by David Fontaine

#macro baseplate (startx, startz, widex, deepz)
#declare xvar=0;
#declare zvar=0;
#declare ctr=0;
#declare numbumps=widex*deepz;
cylinder { <.3+startx,-.1,.3+startz>,<.3+startx,0,.3+startz>,.3 texture { LegoGreen } }
cylinder { <widex-.3+startx,-.1,.3+startz>,<widex-.3+startx,0,.3+startz>,.3 texture { LegoGreen } }
cylinder { <.3+startx,-.1,deepz-.3+startz>,<.3+startx,0,deepz-.3+startz>,.3 texture { LegoGreen } }
cylinder { <widex-.3+startx,-.1,deepz-.3+startz>,<widex-.3+startx,0,deepz-.3+startz>,.3 texture { LegoGreen } }
box { <.3,-.1,0>,<widex-.3,0,deepz> texture { LegoGreen } }
box { <0,-.1,.3>,<widex,0,deepz-.3> texture { LegoGreen } }
#while (ctr<numbumps)
#declare xvar=mod(ctr,widex);
#declare zvar=ctr/widex-mod(ctr/widex,1);
cylinder { <xvar+.5,-.05,zvar+.5>,<xvar+.5,.2,zvar+.5>,.3 texture { LegoGreen } }
#declare ctr=ctr+1;
#end
#end

#declare beam1x2clr = difference {
         merge {
               superellipsoid { <.04,.04> translate <1,1,1> scale <1,.6,.5> }
               cylinder { <.5,1.1,.5>,<.5,1.4,.5>,.3 }
               cylinder { <1.5,1.1,.5>,<1.5,1.4,.5>,.3 }
               }
         box { <.2,-1,.2>,<1.8,1,.8> }
}

#declare brick1x1sb = difference {
         merge {
               superellipsoid { <.05,.05> translate <1,1,1> scale <.5,.105,.5> }
               superellipsoid { <.05,.05> translate <1,1,1.5> scale <.5,.6,.4> }
               cylinder { <.5,.7,0>,<.5,.7,.3>,.3 }
               cylinder { <.5,1.1,.5>,<.5,1.4,.5>,.3 }
               }
         box { <.2,-1,.2>,<.8,.2,.8> }
         box { <.2,-1,.3>,<.8,1,.7> }
         box { <.2,.4,.7>,<.8,1,2> }
         cylinder { <.5,.7,-1>,<.5,.7,1>,.2 }
}

#declare cone2x2 = difference { merge {
         difference {
                    merge {
                          intersection {
                                       cone { <0,0,0>,1.045 <0,2.4,0>,.5 }
                                       cylinder { <0,-1,0>,<0,3,0>,1 }
                                       }
                          cylinder { <0,2.3,0>,<0,2.6,0>,.3 }
                          }
                    cone { <0,.2,0>,.8 <0,2.3,0>,.3 }
                    box { <-.8,-1,-.8>,<.8,.21,.8> }
                    //cylinder { <0,1.95,0>,<0,3,0>,.3 }
                    }
               cylinder { <0,0,0>,<0,2.3,0>,.407 }
               }
         cylinder { <0,-1,0>,<0,3,0>,.2 }
         cylinder { <0,-1,0>,<0,1.8,0>,.3 }
         box { <-.12,-1,-.29>,<.12,2.2,.29> }
         box { <-.29,-1,-.12>,<.29,2.2,.12> }
}
