//LEGO include file -- technic connector pegs, bushings and axle connectors
// by David Fontaine
//
// name          | description
// -----------------------------------------------
// tp_axle       | axle peg
// ballpeg       | ball joint axle peg
// tp_2l         | normal gray peg
// tp_2lf        | 2l friction peg new *
// tp_2lfo       | 2l friction peg old
// tp_3lf        | 3l friction peg *
// tp_1l         | 1l gray peg *
// tp_1.5l       | 1.5l dark gray peg *
// tp_3lax       | 3l friction peg w/ axle-hole end *
// tb_h1         | .5l axle bushing w/ lock old
// tb_h2         | .5l axle bushing w/ lock new *
// tb_h3         | .5l axle bushing smooth *
// tb_1          | 1l axle bushing
// tt_2l         | axle end hole on y and circular hole on x
//               |      (also old piston rod)
// tt_2lh        | above w/ half width locking circ. hole (toggle joint)
// tt_uni_je     | universal joint (flex axle connector) end
// tt_uni_jd     | universal joint (flex axle connector) center disk
// tt_sarm       | steering arm 3l *
// tc_3l         | catch   axle on y w/ axle hole on x *
// tc_2lc        | axle end hole (y) & axle hole (x) *
// tc_2l         | axle hole on x and circ. hole on z (cross block) *
// tc_3lsg       | new steering gear *
// ta_extend     | axle extender *
// ta_1          | angle brick #1, end terminates *
// ta_2          | angle brick #2, 180 *
// ta_3          | angle brick #3, 157.5 *
// ta_5          | angle brick #5, 112.5 *
// ta_6          | angle brick #6, 90 *
// tm_2las       | 2l axle sleeve *
// -----------------------------------------------
// *not yet implemented

#declare tb_h1 = object { difference {
         cylinder { <0,0,0>,<0,.50,0>,.48 }
         cylinder { <0,.4,0>,<0,1,0>,.3 }
         object { lockminus translate 1.40*y }
         torus { .46,.1 translate .25*y }
         box { <-.3,-1,-.12>,<.3,1,.12> }
         box { <-.12,-1,-.3>,<.12,1,.3> }
} }

#declare tb_1 = object { difference {
         merge {
               cylinder { <0,.02,0>,<0,.98,0>,.39 }
               cylinder { <0,.02,0>,<0,.15,0>,.48 }
               cylinder { <0,.88,0>,<0,.98,0>,.48 }
               }
         cylinder { <-.5,-1,-.5>,<-.5,.2,-.5>,.3 }
         cylinder { <.5,-1,-.5>,<.5,.2,-.5>,.3 }
         cylinder { <-.5,-1,.5>,<-.5,.2,.5>,.3 }
         cylinder { <.5,-1,.5>,<.5,.2,.5>,.3 }
         box { <-.3,-1,-.12>,<.3,2,.12> }
         box { <-.12,-1,-.3>,<.12,2,.3> }
         box { <-1,.15,-.06>,<1,.88,.06> }
} }

#declare tt_2l = merge {
         difference {
                    merge {
                          difference {
                                     cylinder { <0,1.5,-.48>,<0,1.5,.48>,.58 }
                                     box { <-1,1.8,-1>,<1,3,1> }
                                     box { <-1,0,-1>,<-.48,2,1> }
                                     box { <.48,0,-1>,<1,2,1> }
                                     }
                          cylinder { <0,1.5,-.48>,<0,1.5,.48>,.48 }
                          cylinder { <-.7,1.5,0>,<0,1.5,0>,.3 }
                          cylinder { <0,1.5,0>,<.7,1.5,0>,.3 }
                          cylinder { <0,.9,0>,<0,1.5,0>,.48 }
                          }
                    cylinder { <0,1.5,-1>,<0,1.5,-.4>,.407 }
                    cylinder { <0,1.5,.4>,<0,1.5,1>,.407 }
                    cylinder { <0,1.5,-1>,<0,1.5,1>,.3 }
                    }
         object { tb_1 rotate 90*y }
}

#declare tt_2lh = merge {
         difference {
                    cylinder { <0,.85,0>,<0,1.5,0>,.48 }
                    box { <0,-1,-1>,<2,2,1> }
                    cylinder { <-1,1.5,0>,<1,1.5,0>,.479 }
                    }
         difference {
                    cylinder { <-.48,1.5,0>,<.05,1.5,0>,.48 }
                    object { lockminus scale <1,.1,1> rotate -90*z translate 1.5*y }
                    cylinder { <-1,1.5,0>,<-.4,1.5,0>,.407 }
                    cylinder { <-.1,1.5,0>,<1,1.5,0>,.407 }
                    cylinder { <-1,1.5,0>,<1,1.5,0>,.3 }
                    }
         difference {
                    merge {
                          cylinder { <0,0,0>,<0,1,0>,.4 }
                          cylinder { <0,0,0>,<0,.1,0>,.48 }
                          cylinder { <0,.85,0>,<0,1,0>,.48 }
                          }
                    cylinder { <-.5,-1,-.5>,<-.5,.2,-.5>,.3 }
                    cylinder { <.5,-1,-.5>,<.5,1.1,-.5>,.3 }
                    cylinder { <-.5,-1,.5>,<-.5,.2,.5>,.3 }
                    cylinder { <.5,-1,.5>,<.5,1.1,.5>,.3 }
                    cylinder { <0,-1,0>,<0,.1,0>,.3 }
                    box { <-.3,-1,-.12>,<.3,2,.12> }
                    box { <-.12,-1,-.3>,<.12,2,.3> }
                    object { lockminus scale <1,.05,1> }
                    }
}

#declare tp_2l = object { difference {
         merge {
               cylinder { <0,0,-1>,<0,0,1>,.3 }
               cylinder { <0,0,-.1>,<0,0,.1>,.407 }
               torus { .3,.04 rotate 90*x translate -.96*z }
               torus { .3,.04 rotate 90*x translate .96*z }
               }
         cylinder { <0,0,-2>,<0,0,2>,.2 }
         cylinder { <0,-1,-.7>,<0,1,-.7>,.06 }
         cylinder { <0,-1,.7>,<0,1,.7>,.06 }
         box { <-.06,-1,-2>,<.06,1,-.7> }
         box { <-.06,-1,.7>,<.06,1,2> }
} }

#declare tp_2lfo = object { tp_2l }

#declare tp_2lf = object { difference {
         object { tp_2l }
         cylinder { <-1,0,-.3>,<1,0,-.3>,.06 }
         cylinder { <-1,0,.3>,<1,0,.3>,.06 }
         box { <-1,-.06,-.3>,<1,.06,.3> }
} }

#declare tt_uni_je = difference {
         merge {
               object { tb_1 }
               cylinder { <0,.9,0>,<0,2,0>,.48 }
               intersection {
               cylinder { <-1,2,0>,<1,2,0>,.2 }
               cylinder { <0,-1,0>,<0,5,0>,.48 }
               }
               }
         cylinder { <0,1.65,-1>,<0,1.65,1>,.3 }
         box { <-.3,1.65,-1>,<.3,3,1> }
         box { <-1,1.8,-1>,<1,3,-.2> }
         box { <-1,1.8,.2>,<1,3,1> }
         box { <-1,0,0>,<1,2,2> rotate -135*x translate <0,1.8,-.2> }
         box { <-1,0,0>,<1,2,2> rotate 45*x translate <0,1.8,.2> }
}

#declare tt_uni_jd = cylinder { <0,-.2,0>,<0,.2,0>,.3 }

#declare ballpeg = merge {
         object { axleend scale <1,.8333,1> }
         cylinder { <0,.9,0>,<0,1,0>,.407 }
         cylinder { <0,.95,0>,<0,1.5,0>,.2 }
         sphere { <0,1.5,0>,.4 }
}

#declare tp_axle = merge {
         object { difference { object { tp_2lfo }
                      box { <-1,-1,0>,<1,2,1> }
                } rotate -90*x }
         cylinder { <0,-.01,0>,<0,.01,0>,.407 }
         object { axleend scale <1,1.05,1> rotate 180*x translate .95*y }
}
