//LEGO include file -- wheels, suspensions, car parts
// by David Fontaine
//
// name          | description
// -----------------------------------------------
// hub24x43      | 24x43 hub
// tire24x43     | 24x43 tire
// shock1        | small shock absorber (assembled shortcut)
// shock1cyl     | shock absorber cylinder
// shock1pis     | shock absorber piston
// spring        | shock absorber spring
// piston1       | old 2x2 (square) piston
// swheell       | steering wheel
// sarm6l        | 6l suspension arm (fork w/ ball socket)
// sgear1        | steering gear 2737
// -----------------------------------------------
// *not yet implemented

#include "metals.inc"

#declare section = difference {
         torus { .35,.03 scale <1.0209,1,1> }
         box { <-5,-2,0>,<5,2,5> }
}
#declare segment = merge {
         object { section rotate 11.6047*z translate <0,.08214,0> }
         object { section rotate 180*y rotate -11.6047*z translate <0,.24643,0> }
}
#declare spring = object { merge {
         object { segment }
         object { segment translate .32857*y }
         object { segment translate .65714*y }
         object { segment translate .98571*y }
         object { segment translate 1.31429*y }
         object { segment translate 1.64286*y }
         object { segment translate 1.97143*y }
         torus { .4,.03 }
         torus { .4,.03 translate 2.3*y }
         }
         scale <1,.97457,1>
         translate <.5,3.23,.5>
}

/***************/

#declare shock1cyl = object {
         difference {
                    merge {
                          difference {
                                     cylinder { <.5,.5,.5>,<.5,3.2,.5>,.47 }
                                     cylinder { <.5,0,.5>,<.5,4,.5>,.3 }
                                     box { <-1,0,.4>,<2,2.3,.6> }
                                     }
                          cylinder { <0,.5,.5>,<1,.5,.5>,.5 }
                          }
                    cylinder { <-1,.5,.5>,<2,.5,.5>,.3 }
                    cylinder { <-1,.5,.5>,<.1,.5,.5>,.407 }
                    cylinder { <.9,.5,.5>,<2,.5,.5>,.407 }
                    }
}
#declare shock1pis = object {
         difference {
                    merge {
                          cylinder { <0,6,.5>,<1,6,.5>,.47 }
                          object { axleseg scale <1,3,1> translate <.5,3,.5> }
                          intersection {
                                       difference {
                                                  box { <.03,1.8,.4>,<.97,4,.6> }
                                                  box { <-1,2.2,-1>,<.2,7,2> }
                                                  box { <.8,2.2,-1>,<2,7,2> }
                                                  box { <.4,0,-1>,<.6,7,2> }
                                                  }
                                       cone { <.5,1.8,.5>,.25 <.5,5,.5>,3.25 }
                                       }
                          cylinder { <.5,5.5,.5>,<.5,6,.5>,.47 }
                          }
                    cylinder { <-1,6,.5>,<2,6,.5>,.3 }
                    cylinder { <-1,6,.5>,<.1,6,.5>,.407 }
                    cylinder { <.9,6,.5>,<2,6,.5>,.407 }
                    }
                    translate .086739*y
}
#declare shock1 = object {
         merge {
               object { shock1cyl
                      texture { LegoGray }
                      }
               object { shock1pis
                      texture { LegoBlackDull }
                      }
               object { spring
                      texture { T_Silver_5C }
                      }
               }
}
#declare shock1b = object {
         merge {
               object { shock1cyl
                      texture { LegoGray }
                      }
               object { shock1pis
                      texture { LegoBlackDull }
                      translate -.170603*y
                      }
               object { spring
                      texture { T_Silver_5C }
                      scale <1,.925825,1>
                      translate .239586*y
                      }
               }
}

#declare piston1 = difference {
         merge {
               difference {
                          merge {
                                superellipsoid { <.05,.15> rotate 90*x scale <1,.7,1> translate <1,.7,1> }
                                cylinder { <.5,1.3,.5>,<.5,1.6,.5>,.3 }
                                cylinder { <1.5,1.3,.5>,<1.5,1.6,.5>,.3 }
                                cylinder { <.5,1.3,1.5>,<.5,1.6,1.5>,.3 }
                                cylinder { <1.5,1.3,1.5>,<1.5,1.6,1.5>,.3 }
                                }
                          cylinder { <.5,1.4,.5>,<.5,2,.5>,.2 }
                          cylinder { <1.5,1.4,.5>,<1.5,2,.5>,.2 }
                          cylinder { <.5,1.4,1.5>,<.5,2,1.5>,.2 }
                          cylinder { <1.5,1.4,1.5>,<1.5,2,1.5>,.2 }
                          box { <.16,-1,.16>,<1.84,1.2,1.84> }
                          }
               box { <.1,.5,.3>,<1.9,1.3,.5> }
               box { <.1,.5,1.5>,<1.9,1.3,1.7> }
               cylinder { <1,.5,.3>,<1,.5,.5>,.5 }
               cylinder { <1,.5,1.5>,<1,.5,1.7>,.5 }
               }
         box { <.9,-1,.25>,<1.1,1.2,1.75> }
         cylinder { <-1,.35,1>,<3,.35,1>,.45 }
         box { <-1,-1,.55>,<3,.35,1.45> }
         cylinder { <1,.3,.25>,<1,.3,1.75>,.32 }
}

#declare sgear1 = difference {
         merge {
               intersection {
                            merge {
                                  box { <-.1,.5,-1>,<.1,4.5,1> }
                                  box { <-1,.5,-.1>,<1,4.5,.1> }
                            }
                            cone { <0,.5,0>,0 <0,4.5,0>,1.333 }
                            cone { <0,.4,0>,1.333 <0,4.5,0>,0 }
                            cylinder { <0,0,0>,<0,5,0>,.5 }
                            }
               cylinder { <0,.5,0>,<0,4.5,0>,.15 }
               cylinder { <-.5,2.5,0>,<.5,2.5,0>,.5 }
               cylinder { <0,2,0>,<0,3,0>,.5 }
               sphere { <0,4.5,0>,.4 }
               sphere { <0,.5,0>,.4 }
               difference {
                          prism { 2.3,2.7,9 <-.5,0>,<-.5,.5>,<-1.5,1.5>,<-1.5,3>,<-.5,3>,<-.5,1.883>,<.5,.883>,<.5,0>,<-.5,0> }
                          prism { 2.2,2.4,8 <-.3,.577>,<-1.3,1.577>,<-1.3,2.8>,<-.7,2.8>,<-.7,1.806>,<.3,.806>,<.3,.577>,<-.3,.577> }
                          prism { 2.6,2.8,8 <-.3,.577>,<-1.3,1.577>,<-1.3,2.8>,<-.7,2.8>,<-.7,1.806>,<.3,.806>,<.3,.577>,<-.3,.577> }
                          }
               cylinder { <-1,2.3,3>,<-1,2.7,3>,.5 }
               }
         cylinder { <-2,2.5,0>,<2,2.5,0>,.3 }
         cylinder { <-2,2.5,0>,<-.4,2.5,0>,.407 }
         cylinder { <.4,2.5,0>,<2,2.5,0>,.407 }
         box { <-1.12,2,2.7>,<-.88,3,3.3> }
         box { <-1.3,2,2.88>,<-.7,3,3.12> }
}

#declare swheel1 = difference {
         merge {
               cylinder { <0,-1,0>,<0,-.2,0>,.5 }
               intersection {
                            prism { .5,1,11 <-.5,-1.5>,<-.5,-1>,<-1,-.5>,<-1.5,-.5>,<-1.5,.5>,<1.5,.5>,<1.5,-.5>,<1,-.5>,<.5,-1>,<.5,-1.5>,<-.5,-1.5> }
                            cone { <0,.5,0>,1.5 <0,1.5,0>,2.5 }
                            }
               difference {
                          cone { <0,.5,0>,1.5 <0,1.3,0>,2.3 }
                          cone { <0,0,0>,.5 <0,2,0>,2.5 }
                          box { <-4,0,.5>,<4,2,4> }
                          box { <-4,0,-.5>,<-.5,2,-4> }
                          box { <4,0,.5>,<.5,0,4> }
                          }
               torus { 2.2,.3 translate 1.3*y }
               cylinder { <0,.9,0>,<0,1.2,0>,.3 }
               }
         cylinder { <0,1,0>,<0,2,0>,.2 }
         cylinder { <-1,0,0>,<-1,2,0>,.3 }
         cylinder { <1,0,0>,<1,2,0>,.3 }
         cylinder { <0,0,-1>,<0,2,-1>,.3 }
         box { <-.3,-1,-.12>,<.3,.9,.12> }
         box { <-.12,-1,-.3>,<.12,.9,.3> }
}

#declare tiretreadseg = prism { 0,1.5,5 <-.32,2>,<-.32,5>,<.32,5>,<.32,2>,<-.32,2> }
#declare tiretreadhalf = object { merge {
         object { tiretreadseg rotate 0*y }
         object { tiretreadseg rotate 12.857*y }
         object { tiretreadseg rotate 25.714*y }
         object { tiretreadseg rotate 38.571*y }
         object { tiretreadseg rotate 51.429*y }
         object { tiretreadseg rotate 64.286*y }
         object { tiretreadseg rotate 77.143*y }
         object { tiretreadseg rotate 90*y }
         object { tiretreadseg rotate 102.857*y }
         object { tiretreadseg rotate 115.714*y }
         object { tiretreadseg rotate 128.571*y }
         object { tiretreadseg rotate 141.429*y }
         object { tiretreadseg rotate 154.286*y }
         object { tiretreadseg rotate 167.143*y }
         object { tiretreadseg rotate 180*y }
         object { tiretreadseg rotate 192.857*y }
         object { tiretreadseg rotate 205.714*y }
         object { tiretreadseg rotate 218.571*y }
         object { tiretreadseg rotate 231.429*y }
         object { tiretreadseg rotate 244.286*y }
         object { tiretreadseg rotate 257.143*y }
         object { tiretreadseg rotate 270*y }
         object { tiretreadseg rotate 282.857*y }
         object { tiretreadseg rotate 295.714*y }
         object { tiretreadseg rotate 308.571*y }
         object { tiretreadseg rotate 321.429*y }
         object { tiretreadseg rotate 334.286*y }
         object { tiretreadseg rotate 347.143*y }
         }
         rotate 90*x
}
#declare tire24x43 = difference {
         merge {
               cylinder { <0,0,0>,<0,0,3>,4 }
               object { tiretreadhalf }
               object { tiretreadhalf translate 1.5*z rotate 6.429*z }
               }
         cylinder { <0,0,-1>,<0,0,4>,2.75 }
}

#declare hub24x43 = difference {
         merge {
               difference {
                          cylinder { <0,0,0>,<0,0,3>,2.75 }
                          cylinder { <0,0,-1>,<0,0,4>,2.6 }
                          }
               difference {
                          cylinder { <0,0,.8>,<0,0,2>,2.7 }
                          cone { <0,0,0>,3.4 <0,0,3>,.4 }
                          cone { <0,0,0>,.6 <0,0,3>,3.6 }
                          cylinder { <0,0,0>,<0,0,3>,2.45 }
                          }
               difference {
                          merge {
                                box { <-.075,-2.65,.6>,<.075,2.65,1.6> rotate 18*z }
                                box { <-.075,-2.65,.6>,<.075,2.65,1.6> rotate 42*z }
                                box { <-.075,-2.65,.6>,<.075,2.65,1.6> rotate 78*z }
                                box { <-.075,-2.65,.6>,<.075,2.65,1.6> rotate 102*z }
                                box { <-.075,-2.65,.6>,<.075,2.65,1.6> rotate 138*z }
                                box { <-.075,-2.65,.6>,<.075,2.65,1.6> rotate 162*z }
                                cylinder { <0,0,.5>,<0,0,2.5>,1.25 }
                                cylinder { <0,0,.7>,<0,0,.85>,1.5 }
                                prism { 0,.15,5 <-.2079,.9781>,<-.5614,2.6410>,<.5614,2.6410>,<.2079,.9781>,<-.2079,.9781>
                                      rotate 90*x translate .7*z rotate 30*z }
                                prism { 0,.15,5 <-.2079,.9781>,<-.5614,2.6410>,<.5614,2.6410>,<.2079,.9781>,<-.2079,.9781>
                                      rotate 90*x translate .7*z rotate 90*z }
                                prism { 0,.15,5 <-.2079,.9781>,<-.5614,2.6410>,<.5614,2.6410>,<.2079,.9781>,<-.2079,.9781>
                                      rotate 90*x translate .7*z rotate 150*z }
                                prism { 0,.15,5 <-.2079,.9781>,<-.5614,2.6410>,<.5614,2.6410>,<.2079,.9781>,<-.2079,.9781>
                                      rotate 90*x translate .7*z rotate 210*z }
                                prism { 0,.15,5 <-.2079,.9781>,<-.5614,2.6410>,<.5614,2.6410>,<.2079,.9781>,<-.2079,.9781>
                                      rotate 90*x translate .7*z rotate 270*z }
                                prism { 0,.15,5 <-.2079,.9781>,<-.5614,2.6410>,<.5614,2.6410>,<.2079,.9781>,<-.2079,.9781>
                                      rotate 90*x translate .7*z rotate 330*z }
                                }
                          cylinder { <0,0,-1>,<0,0,4>,1.05 }
                          }
               cylinder { <0,2,.1>,<0,2,.9>,.407 rotate 30*z }
               cylinder { <0,2,.1>,<0,2,.9>,.407 rotate 90*z }
               cylinder { <0,2,.1>,<0,2,.9>,.407 rotate 150*z }
               cylinder { <0,2,.1>,<0,2,.9>,.407 rotate 210*z }
               cylinder { <0,2,.1>,<0,2,.9>,.407 rotate 270*z }
               cylinder { <0,2,.1>,<0,2,.9>,.407 rotate 330*z }
               box { <-1.1,-.3,.5>,<1.1,.3,2.5> }
               cylinder { <0,0,.5>,<0,0,2.5>,.5 }
               }
         cylinder { <0,2,-1>,<0,2,4>,.3 rotate 30*z }
         cylinder { <0,2,-1>,<0,2,4>,.3 rotate 90*z }
         cylinder { <0,2,-1>,<0,2,4>,.3 rotate 150*z }
         cylinder { <0,2,-1>,<0,2,4>,.3 rotate 210*z }
         cylinder { <0,2,-1>,<0,2,4>,.3 rotate 270*z }
         cylinder { <0,2,-1>,<0,2,4>,.3 rotate 330*z }
         box { <-1.05,-.04,-1>,<1.05,.04,4> }
         box { <-.3,-.12,-1>,<.3,.12,4> }
         box { <-.12,-.3,-1>,<.12,.3,4> }
}

#declare sarm6l = object { difference {
         merge {
               difference {
                          merge {
                                box { <0,-.5,-1>,<4.5,.5,-.5> }
                                box { <0,-.5,.5>,<4.5,.5,1> }
                                prism { -.5,.5,8 <4,-1>,<4.5,-1>,<5,-.5>,<5,-.2>,<4.8,-.2>,<4.5,-.5>,<4,-.5>,<4,-1> }
                                prism { -.5,.5,8 <4,1>,<4.5,1>,<5,.5>,<5,.2>,<4.8,.2>,<4.5,.5>,<4,.5>,<4,1> }
                                box { <4.9,-.5,-.5>,<5.5,.5,.5> }
                                }
                          box { <-1,-.3,-2>,<7,.3,-.8> }
                          box { <-1,-.3,2>,<7,.3,.8> }
                          box { <4,-1,-.3>,<7,1,.3> }
                          }
               cylinder { <0,0,-1>,<0,0,-.5>,.5 }
               cylinder { <0,0,.5>,<0,0,1>,.5 }
               cylinder { <5.5,-.5,0>,<5.5,.5,0>,.5 }
               box { <4.5,.4,-.5>,<5.5,.5,.5> }
               triangle { <4.4,.5,-.5>,<4.5,.5,-.5>,<4.5,.5,-.4> }
               triangle { <4.4,.5,.5>,<4.5,.5,.5>,<4.5,.5,.4> }
               triangle { <4.4,.5,-.5>,<4.5,.4,-.5>,<4.5,.5,-.4> }
               triangle { <4.4,.5,.5>,<4.5,.4,.5>,<4.5,.5,.4> }
               box { <1.3,-.5,-.6>,<1.4,.5,.6> }
               box { <1.3,.4,-.6>,<1.6,.5,.6> }
               cylinder { <2,0,-1>,<2,0,-.6>,.407 }
               cylinder { <3,0,-1>,<3,0,-.6>,.407 }
               cylinder { <4,0,-1>,<4,0,-.6>,.407 }
               cylinder { <2,0,1>,<2,0,.6>,.407 }
               cylinder { <3,0,1>,<3,0,.6>,.407 }
               cylinder { <4,0,1>,<4,0,.6>,.407 }
               }
         cylinder { <0,0,-2>,<0,0,2>,.3 }
         cylinder { <0,0,-.6>,<0,0,.6>,.407 }
         box { <-.407,0,-.6>,<.407,-2,.6> }
         box { <-1,-.1,-.6>,<-.4,-2,.6> }
         cylinder { <2,0,-2>,<2,0,2>,.3 }
         cylinder { <2,0,-.6>,<2,0,.6>,.407 }
         box { <1.593,0,-.6>,<2.407,-2,.6> }
         cylinder { <3,0,-2>,<3,0,2>,.3 }
         cylinder { <3,0,-.6>,<3,0,.6>,.407 }
         box { <2.593,0,-.6>,<3.407,-2,.6> }
         cylinder { <4,0,-2>,<4,0,2>,.3 }
         cylinder { <4,0,-.6>,<4,0,.6>,.407 }
         box { <3.593,0,-.6>,<4.407,-2,.6> }
         sphere { <5.5,0,0>,.4 }
         cylinder { <5.5,-1,0>,<5.5,0,0>,.38 }
         cylinder { <5.5,0,-2>,<5.5,0,2>,.15 }
         box { <0,0,-2>,<2,2,2> rotate -45*z translate <5.75,.5,0> }
         box { <0,0,-2>,<2,-2,2> rotate 11.31*z translate <5,-.5,0> }
} }
