//LEGO include file -- bricks
// by David Fontaine
// -----------------------------------------------------------------------
// brick2x2             2x2x1 brick
// brick2x3             2x3x1 brick
// brick2x4             2x4x1 brick
// brick2x6             2x6x1 brick
// brick2x8             2x8x1 brick
// brick2x10            2x10x1 brick
// brick2x2r            2x2x1 round brick
// brick2x2c            2x2x1 slant brick (overhang)
// brick2x2f            2x2x1 slant brick
// brick2x2cc           2x2x1 slant brick outside corner (overhang)
// brick2x2x3f          2x2x3 slant brick
// brick2x2x3c          2x2x3 slant brick (overhang)*
// brick2x4f            2x4x1 slant brick
// brick2x2x3fc         2x2x3 slant brick outside corner
// brick2x3f            2x3x1 slant brick*
// brick2x3c            2x3x1 slant brick (overhang)*
// brick2x2p            2x2x2 pyramid brick
// arch2_6              1x6x2 arch*
// arch1_6              1x6x1 arch*
// arch2_8              1x8x2 arch*
// arch1_4              1x4x1 arch*
// arch1_3              1x3x1 arch
// arch4_5              1x5x4 half arch
// tower_half           14x8x~2 half-octagon battlement
// brick2x2l            2x2x1 corner brick
// brick1x1x2h          1x1x2 door hinge
//
// *--not complete

/**************/

#declare brick2x2 = object { makelego (0,0,0,2,1.2,2) } 

#declare brick2x3 = object { makelego (0,0,0,3,1.2,2) }

#declare brick2x4 = object { makelego (0,0,0,4,1.2,2) }

#declare brick2x6 = object { makelego (0,0,0,6,1.2,2) }

#declare brick2x8 = object { makelego (0,0,0,8,1.2,2) }

#declare brick2x10 = object { makelego (0,0,0,10,1.2,2) }

#declare brick2x2r = difference { union {
         difference {
                    merge {
                          object { bump translate <.5,1.2,.5> }
                          object { bump translate <1.5,1.2,.5> }
                          object { bump translate <.5,1.2,1.5> }
                          object { bump translate <1.5,1.2,1.5> }
                          object { roundcylinder (1.2,1,.05) translate <1,0,1> }
                          }
                    cylinder { <1,-1,1>,<1,1,1>,.8 }
                    box { <.2,-1,.2>,<1.8,.2,1.8> }
                    cylinder { <1,-1,1>,<1,2,1>,1.0001 inverse }
                    }
         cylinder { <1,0,1>,<1,1.2,1>,.407 }
         }
         box { <.7,-1,.88>,<1.3,2,1.12> }
         box { <.88,-1,.7>,<1.12,2,1.3> }
         cylinder { <1,-1,1>,<1,.2,1>,.3 }
}

#declare brick2x2c = union {
        difference {
                union {
                        object { roundbox (0,0,0,2,1.2,2) }
                        cylinder { <.5,1.1,.5>,<.5,1.4,.5>,.3 }
                        cylinder { <.5,1.1,1.5>,<.5,1.4,1.5>,.3 }
                        }
                box { <.2,-1,.2>,<.8,1,1.8> }
                prism { -.2,-1.8,5 <1,.2>,<1.8,1>,<1.8,2>,<1,2>,<1,.2> rotate -90*x }
                }
        difference {
                cylinder { <1.5,.2,1.5>,<1.5,1.4,1.5>,.3 }
                cylinder { <1.5,0,1.5>,<1.5,1.6,1.5>,.2 }
                }
        difference {
                cylinder { <1.5,.2,.5>,<1.5,1.4,.5>,.3 }
                cylinder { <1.5,0,.5>,<1.5,1.6,.5>,.2 }
                }
        box { <.45,0,.8>,<.55,1.1,1.2> }
}
#declare brick2x2cd = prism { -3,1,4 <0,-1>,<3,-1>,<3,2>,<0,-1> rotate -90*x }

#declare brick2x2f = union {
        difference {
                union {
                        object { roundbox (0,0,0,2,1.2,2) }
                        cylinder { <.5,1.1,.5>,<.5,1.4,.5>,.3 }
                        cylinder { <.5,1.1,1.5>,<.5,1.4,1.5>,.3 }
                        }
                prism { -1.8,-.2,6 <.2,-1>,<.2,1>,<1,1>,<1.8,.2>,<1.8,-1>,<.2,-1> rotate -90*x }
                }
        difference {
                cylinder { <1,0,1>,<1,1.1,1>,.407 }
                cylinder { <1,-1,1>,<1,2,1>,.3 }
                }
}
#declare brick2x2fd = prism { -3,1,4 <2.2,0>,<2.2,2.2>,<0,2.2>,<2.2,0> rotate -90*x }

#declare brick2x2cc = union {
        difference {
                union {
                        object { roundbox (0,0,0,2,1.2,2) }
                        cylinder { <.5,1.1,.5>,<.5,1.4,.5>,.3 }
                        }
                box { <.2,-1,.2>,<.8,1,.8> }
                difference {
                        box { <.2,0,.2>,<3,3,3> }
                        box { <-1,-1,-1>,<1,4,1> }
                        box { <-1,-1,0>,<4,4,4> rotate 45*x translate <0,.4,1> }
                        box { <0,-1,-1>,<4,4,4> rotate -45*z translate <1,.4,0> }
                        }
                }
        difference {
                cylinder { <1.5,.2,1.5>,<1.5,1.4,1.5>,.3 }
                cylinder { <1.5,.2,1.5>,<1.5,1.4,1.5>,.2 }
                }
        difference {
                cylinder { <1.5,.2,.5>,<1.5,1.4,.5>,.3 }
                cylinder { <1.5,.2,.5>,<1.5,1.4,.5>,.2 }
                }
        difference {
                cylinder { <.5,.2,1.5>,<.5,1.4,1.5>,.3 }
                cylinder { <.5,.2,1.5>,<.5,1.4,1.5>,.2 }
                }
}
#declare brick2x2ccd = union {
        prism { -3,3,4 <0,-1>,<3,-1>,<3,2>,<0,-1> rotate -90*x }
        prism { -3,3,4 <0,-1>,<3,-1>,<3,2>,<0,-1> rotate <-90,-90,0> }
}

#declare brick2x2x3f = union {
        difference {
                union {
                        object { roundbox (0,0,0,2,3.6,2) }
                        cylinder { <.5,3.5,.5>,<.5,3.8,.5>,.3 }
                        cylinder { <.5,3.5,1.5>,<.5,3.8,1.5>,.3 }
                        }
                prism { -1.8,-.2,6 <.2,-1>,<1.8,-1>,<1.8,.2>,<1,3.3>,<.2,3.3>,<.2,-1> rotate -90*x }
                }
        difference {
                union {
                        cylinder { <1,0,1>,<1,3.5,1>,.407 }
                        box { <.1,.2,.975>,<1.9,3.5,1.025> }
                        }
                cylinder { <1,-1,1>,<1,4,1>,.3 }
                }
}
#declare brick2x2x3fd = prism { -3,1,6 <2,.2>,<1,3.6>,<1,4>,<3,4>,<3,0>,<2,.2> rotate -90*x }

#declare brick2x4f = union {
        difference {
                union {
                        object { roundbox (0,0,0,2,1.2,4) }
                        cylinder { <.5,1.1,.5>,<.5,1.4,.5>,.3 }
                        cylinder { <.5,1.1,1.5>,<.5,1.4,1.5>,.3 }
                        cylinder { <.5,1.1,2.5>,<.5,1.4,2.5>,.3 }
                        cylinder { <.5,1.1,3.5>,<.5,1.4,3.5>,.3 }
                        }
                prism { -3.8,-.2,6 <.2,-1>,<1.8,-1>,<1.8,.2>,<1,1>,<.2,1>,<.2,-1> }
                }
        difference {
                cylinder { <1,0,1>,<1,1.1,1>,.407 }
                cylinder { <1,-1,1>,<1,2,1>,.3 }
                }
        difference {
                cylinder { <1,0,2>,<1,1.1,2>,.407 }
                cylinder { <1,-1,2>,<1,2,2>,.3 }
                }
        difference {
                cylinder { <1,0,3>,<1,1.1,3>,.407 }
                cylinder { <1,-1,3>,<1,2,3>,.3 }
                }
}
#declare brick2x4fd = prism { -5,1,4 <2.2,0>,<2.2,2.2>,<0,2.2>,<2.2,0> rotate -90*x }

#declare brick2x2x3fc = union {
        difference {
                union {
                        object { roundbox (0,0,0,2,3.6,2) }
                        cylinder { <.5,3.5,.5>,<.5,3.8,.5>,.3 }
                        }
                intersection {
                        box { <.2,-1,.2>,<1.8,3.3,1.8> }
                        box { <-4,-1,-1>,<0,5,3> rotate 16.4*z translate <1.8,.2,0> }
                        box { <-1,-1,-4>,<3,5,0> rotate -16.4*x translate <0,.2,1.8> }
                        }
                }
        difference {
                cylinder { <1,0,1>,<1,3.5,1>,.407 }
                cylinder { <1,-1,1>,<1,3.6,1>,.3 }
                }
}
#declare brick2x2x3fcd = union {
        prism { -3,3,6 <2,.2>,<1,3.6>,<1,4>,<3,4>,<3,0>,<2,.2> rotate -90*x }
        prism { -3,3,6 <2,.2>,<1,3.6>,<1,4>,<3,4>,<3,0>,<2,.2> rotate <-90,-90,0> }
}

#declare brick2x2p = union {
        difference {
                union {
                        object { roundbox (0,0,0,2,2.4,2) }
                        cylinder { <1,2.3,1>,<1,2.6,1>,.3 }
                        }
                cylinder { <1,2.4,1>,<1,3,1>,.2 }
                intersection {
                        prism { conic_sweep 0,1,5 <-1,-1>,<1,-1>,<1,1>,<-1,1>,<-1,-1> rotate 180*x translate 1*y scale <1,3.69,1> translate <1,-.05,1> }
                        box { <.2,-1,.2>,<1.8,1.8,1.8> }
                        }
                }
        difference {
                union {
                        cylinder { <1,0,1>,<1,2,1>,.407 }
                        box { <.1,.2,.975>,<1.9,2,1.025> }
                        }
                cylinder { <1,-1,1>,<1,3,1>,.3 }
                }
}
#declare brick2x2pd = union {
        prism { -2,2,6 <1,.2>,<.35,2.4>,<.35,3>,<2,3>,<2,0>,<1,.2> rotate <-90,0,0> }
        prism { -2,2,6 <1,.2>,<.35,2.4>,<.35,3>,<2,3>,<2,0>,<1,.2> rotate <-90,90,0> }
        prism { -2,2,6 <1,.2>,<.35,2.4>,<.35,3>,<2,3>,<2,0>,<1,.2> rotate <-90,180,0> }
        prism { -2,2,6 <1,.2>,<.35,2.4>,<.35,3>,<2,3>,<2,0>,<1,.2> rotate <-90,270,0> }
        translate <1,0,1>
}

#declare arch1_3 = difference {
        union {
                object { roundbox (0,0,0,3,1.2,1) }
                cylinder { <.5,1.1,.5>,<.5,1.4,.5>,.3 }
                cylinder { <1.5,1.1,.5>,<1.5,1.4,.5>,.3 }
                cylinder { <2.5,1.1,.5>,<2.5,1.4,.5>,.3 }
                }
        box { <.2,-1,.2>,<.8,1,.8> }
        box { <1,-1,.2>,<2,1,.8> }
        box { <2.2,-1,.2>,<2.8,1,.8> }
        cylinder { <1.5,.3,-1>,<1.5,.3,2>,.5 }
        box { <1,-1,-1>,<2,.3,2> }
}

#declare arch4_5 = union {
        difference {
                union {
                        object { roundbox (0,0,0,5,2.4,1) }
                        object { roundbox (1,0,0,5,3.6,1) }
                        object { roundbox (2,0,0,3,4.8,1) }
                        object { roundbox (2.5,0,0,5,4.4,1) }
                        }
                cylinder { <5,0,-1>,<5,0,2>,4 }
                box { <.2,-1,.2>,<.8,2.2,.8> }
                difference {
                        box { <1,-1,.2>,<4.8,4.6,.8> }
                        box { <0,2.3,0>,<1.2,6,1> }
                        box { <0,3.4,0>,<2.2,6,1> }
                        box { <2.8,4.2,0>,<6,6,1> }
                        }
                }
        object { bump translate <.5,2.4,.5> }
        object { bump translate <1.5,3.6,.5> }
        object { bump translate <2.5,4.8,.5> }
        object { bump translate <3.5,4.4,.5> }
        object { bump translate <4.5,4.4,.5> }
        box { <1.8,3,.1>,<2,3.5,.9> }
        box { <3,3.7,.1>,<3.2,4.2,.9> }
}

#declare tower_half = object { difference {
        union {
                difference {
                        box { <0,0,0>,<4,2.8,8> }
                        box { <-1,-1,2>,<2,3,6> }
                        box { <-1,.4,1>,<2,3,7> }
                        box { <-1,.4,2>,<3,3,6> }
                        prism { -1,3,4 <0,-2>,<6,-2>,<6,4>,<0,-2> }
                        prism { -1,3,4 <0,10>,<6,10>,<6,4>,<0,10> }
                        prism { 1.6,3,4 <1,6>,<1,9>,<4,9>,<1,6> }
                        prism { 1.6,3,4 <1,2>,<1,-1>,<4,-1>,<1,2> }
                        prism { 1.6,3,4 <2,5>,<5,5>,<5,8>,<2,5> }
                        prism { 1.6,3,4 <2,3>,<5,3>,<5,0>,<2,3> }
                        prism { -1,.2,25 <2,.2>,<2.1,.35>,<3.65,1.9>,<3.8,2>,<3.8,3.94>,<3.8,4.06>,
                                         <3.8,6>,<3.65,6.1>,<2.1,7.65>,<2,7.8>,<1.5,7.5>,<2,7.15>,<2.1,7.15>,<2.1,6.1>,<3.15,6.1>,
                                         <3.15,6>,<3.15,4.06>,<3.15,3.94>,<3.15,2.1>,<3.15,2>,<2.1,1.9>,<2.1,.85>,
                                         <2,.85>,<1.5,.5>,<2,.2> }
                        box { <.2,-1,.2>,<2,1.4,.8> }
                        box { <.2,-1,7.2>,<2,1.4,7.8> }
                        box { <3.2,.19999,2>,<3.8,1.4,3.95> }
                        box { <3.2,.19999,4.05>,<3.8,1.4,6> }
                        prism { .19999,1.4,4 <2.1,.35>,<3.65,1.9>,<2.1,1.9>,<2.1,.35> }
                        prism { .19999,1.4,4 <2.1,7.65>,<3.65,6.1>,<2.1,6.1>,<2.1,7.65> }
                        box { <.2,-1,.79>,<2.2,.2,1.8> }
                        box { <.2,-1,7.21>,<2.2,.2,6.2> }
                        box { <2.2,-1,1.8>,<3.21,.2,6.2> }
                        }
                cylinder { <0.5,2.7,0.5>,<0.5,3.0,0.5>,.3 }
                cylinder { <1.5,1.5,0.5>,<1.5,1.8,0.5>,.3 }
                cylinder { <0.5,0.3,1.5>,<0.5,0.6,1.5>,.3 }
                cylinder { <1.5,0.3,1.5>,<1.5,0.6,1.5>,.3 }
                cylinder { <2.5,2.7,1.5>,<2.5,3.0,1.5>,.3 }
                cylinder { <2.5,0.3,2.5>,<2.5,0.6,2.5>,.3 }
                cylinder { <3.5,1.5,2.5>,<3.5,1.8,2.5>,.3 }
                cylinder { <2.5,0.3,3.5>,<2.5,0.6,3.5>,.3 }
                cylinder { <3.5,2.7,3.5>,<3.5,3.0,3.5>,.3 }
                cylinder { <2.5,0.3,4.5>,<2.5,0.6,4.5>,.3 }
                cylinder { <3.5,2.7,4.5>,<3.5,3.0,4.5>,.3 }
                cylinder { <2.5,0.3,5.5>,<2.5,0.6,5.5>,.3 }
                cylinder { <3.5,1.5,5.5>,<3.5,1.8,5.5>,.3 }
                cylinder { <0.5,0.3,6.5>,<0.5,0.6,6.5>,.3 }
                cylinder { <1.5,0.3,6.5>,<1.5,0.6,6.5>,.3 }
                cylinder { <2.5,2.7,6.5>,<2.5,3.0,6.5>,.3 }
                cylinder { <0.5,2.7,7.5>,<0.5,3.0,7.5>,.3 }
                cylinder { <1.5,1.5,7.5>,<1.5,1.8,7.5>,.3 }
                prism { 0,.3,73 <0.2,1.0>,
                                <0.4,1.0>,<0.4,0.8>,<0.6,0.8>,<0.6,1.0>,
                                <1.4,1.0>,<1.4,0.8>,<1.6,0.8>,<1.6,1.0>,
                                <2.0,1.0>,         
                                <2.0,1.4>,<2.2,1.4>,<2.2,1.6>,<2.0,1.6>,
                                <2.0,1.8>,<2.2,1.8>,<2.2,2.0>,
                                <2.4,2.0>,<2.4,1.8>,<2.6,1.8>,<2.6,2.0>,
                                <3.0,2.0>,
                                <3.0,2.4>,<3.2,2.4>,<3.2,2.6>,<3.0,2.6>,
                                <3.0,3.4>,<3.2,3.4>,<3.2,3.6>,<3.0,3.6>,
                                <3.0,4.4>,<3.2,4.4>,<3.2,4.6>,<3.0,4.6>,
                                <3.0,5.4>,<3.2,5.4>,<3.2,5.6>,<3.0,5.6>,
                                <3.0,6.0>,
                                <2.6,6.0>,<2.6,6.2>,<2.4,6.2>,<2.4,6.0>,
                                <2.2,6.0>,<2.2,6.2>,<2.0,6.2>,
                                <2.0,6.4>,<2.2,6.4>,<2.2,6.6>,<2.0,6.6>,
                                <2.0,7.0>,
                                <1.6,7.0>,<1.6,7.2>,<1.4,7.2>,<1.4,7.0>,
                                <0.6,7.0>,<0.6,7.2>,<0.4,7.2>,<0.4,7.0>,
                                <0.2,7.0>,
                                <0.2,6.8>,<1.8,6.8>,<1.8,6.05>,<2.05,6.05>,<2.05,5.8>,<2.8,5.8>,
                                <2.8,2.2>,<2.05,2.2>,<2.05,1.95>,<1.8,1.95>,<1.8,1.2>,<0.1,1.2>,
                                <0.2,1.0> }
                prism { 0,1.5,5 <.3,-.1>,<.3,.1>,<.6,.1>,<.6,-.1>,<.3,-.1> rotate 45*y translate <2.5,0,1.5> }
                prism { 0,1.5,5 <.3,-.1>,<.3,.1>,<.6,.1>,<.6,-.1>,<.3,-.1> rotate -45*y translate <2.5,0,6.5> }
                prism { .2,1.5,7 <2.05,0.8>,<2.05,1.95>,<3.2,1.95>,<3.2,1.8>,<2.2,1.8>,<2.2,0.8>,<2.05,0.8> }
                prism { .2,1.5,7 <2.05,7.2>,<2.05,6.05>,<3.2,6.05>,<3.2,6.2>,<2.2,6.2>,<2.2,7.2>,<2.05,7.2> }
                cylinder { <1,0,1.5>,<1,.3,1.5>,.2 }
                cylinder { <2.5,0,3>,<2.5,.3,3>,.2 }
                cylinder { <2.5,0,4>,<2.5,.3,4>,.2 }
                cylinder { <2.5,0,5>,<2.5,.3,5>,.2 }
                cylinder { <1,0,6.5>,<1,.3,6.5>,.2 }
                }
        cylinder { <1,-1,1.5>,<1,.2,1.5>,.1 }
        cylinder { <2.5,-1,3>,<2.5,.2,3>,.1 }
        cylinder { <2.5,-1,4>,<2.5,.2,4>,.1 }
        cylinder { <2.5,-1,5>,<2.5,.2,5>,.1 }
        cylinder { <1,-1,6.5>,<1,.2,6.5>,.1 }
        box { <-.3,-1,-.3>,<.3,.2,.3> rotate 45*y translate <2.5,0,0.5> }
        box { <-.3,-1,-.3>,<.3,.2,.3> rotate 45*y translate <3.5,0,1.5> }
        box { <-.3,-1,-.3>,<.3,.2,.3> rotate 45*y translate <3.5,0,6.5> }
        box { <-.3,-1,-.3>,<.3,.2,.3> rotate 45*y translate <2.5,0,7.5> }
        bounded_by { box { <-.1,-.1,-.1>,<4.1,3.1,8.1> } }
        translate <0,0,-4>
} }

#declare brick2x2l = union {
         difference {
                    union {
                          object { roundbox (0,0,0,2,1.2,1) }
                          object { roundbox (0,0,0,1,1.2,2) }
                          cylinder { <.5,1.1,.5>,<.5,1.4,.5>,.3 }
                          cylinder { <1.5,1.1,.5>,<1.5,1.4,.5>,.3 }
                          cylinder { <.5,1.1,1.5>,<.5,1.4,1.5>,.3 }
                          }
                    box { <.2,-1,.2>,<1.8,1,.8> }
                    box { <.2,-1,.2>,<.8,1,1.8> }
                    }
         cylinder { <1,0,.5>,<1,1.1,.5>,.2 }
         cylinder { <.5,0,1>,<.5,1.1,1>,.2 }
}

#declare brick1x1x2h = difference {
        union {
                object { roundbox (0,0,0,1,2.4,1) }
                cylinder { <.5,2.3,.5>,<.5,2.6,.5>,.3 }
                cylinder { <1.2,0,.5>,<1.2,.15,.5>,.2 }
                cylinder { <1.2,2.25,.5>,<1.2,2.4,.5>,.2  }
                box { <.9,0,.3>,<1.2,.15,.7> }
                box { <.9,2.25,.3>,<1.2,2.4,.7> }
                }
        box { <.2,-1,.2>,<.8,2.2,.8> }
        bounded_by { box { <0,0,0>,<1.5,2.6,1> } }
}

#declare arch1_6 = difference { 
        union {
                object { roundbox (0,0,0,6,1.2,1) }
                cylinder { <.5,1.1,.5>,<.5,1.4,.5>,.3 }
                cylinder { <1.5,1.1,.5>,<1.5,1.4,.5>,.3 }
                cylinder { <2.5,1.1,.5>,<2.5,1.4,.5>,.3 }
                cylinder { <3.5,1.1,.5>,<3.5,1.4,.5>,.3 }
                cylinder { <4.5,1.1,.5>,<4.5,1.4,.5>,.3 }
                cylinder { <5.5,1.1,.5>,<5.5,1.4,.5>,.3 }
                }
        box { <.2,-1,.2>,<.8,1,.8> }
        box { <5.2,-1,.2>,<5.8,1,.8> }
        box { <1,-1,.2>,<5,1,.8> }
        cylinder { <3,-2.09,-1>,<3,-2.09,2>,2.89 }
        bounded_by { box { <0,0,0>,<6,1.4,1> } }
}