//LEGO include file -- textures, etc
//must be included before other files
// by David Fontaine

/* found this on pov-ray advanced users newsgroup :)
Larry Fontaine <lfontean@isd.net> wrote:
: I'm
: thinking a quadric will do the trick, but I need help making one.

  You need a quartic for that. Here you are:*/

//------------------------------------------------------------------------
#macro SuperCone(a,b,c,d)
  intersection
  { quartic
    { <0, 0,  0,  0, 0,   0,   0,  b*b-2*b*d+d*d, 2*(b*d-b*b), b*b,
       0,  0,   0,  0,   0,  0, 0,  0,  0, 0,
       0, 0,  0, a*a-2*a*c+c*c, 2*(a*c-a*a), a*a, 0,  0,  0, 0,
       -(a*a-2*a*c+c*c)*(b*b-2*b*d+d*d),
       -(2*((b*d-b*b)*(a*a-2*a*c+c*c)+(a*c-a*a)*(b*b-2*b*d+d*d))),
       -(b*b*(a*a-2*a*c+c*c)+4*(a*c-a*a)*(b*d-b*b)+a*a*(b*b-2*b*d+d*d)),
       -(2*(b*b*(a*c-a*a)+a*a*(b*d-b*b))), -a*a*b*b>
      sturm
    }
    cylinder { 0, z, max(max(a,b),max(c,d)) }
    bounded_by { cone { 0, max(a,b), z, max(c,d) } }
  }
#end
//------------------------------------------------------------------------


/*  It creates a cone from <0,0,0> to <0,0,1> with the ends being ellipses,
one with radiuses 'a' and 'b' and the other with radiuses 'c' and 'd'.
  Example:

camera { location -z*10 look_at 0 angle 35 }
light_source { -z*1000,1 }
light_source { y*1000,1 }

object
{ SuperCone(2, .5, .5, 2)
  pigment { rgb x } finish { specular .5 }
  translate -z*.5 scale <1,1,2>
  rotate z*90 rotate -x*45
}

  If someone is interested in the mathematics behind those quartic parameters,
I can explain (although I think nobody will ask... :) ). */

#macro supercone (a,b,x1,y1,z1,c,d,x2,y2,z2)
#local s=min(a,b);
#local s=min(s,c);
#local s=min(s,d);
#local s=s/10;
object {
   SuperCone (a/s,b/s,c/s,d/s)
   rotate -90*x
   scale <s,1,s>
   matrix <1,0,0,x2-x1,1,z2-z1,0,0,1,0,0,0>
   scale <1,y2-y1,1>
   translate <x1,y1,z1>
} #end

#macro ellipsetorus (Xr,Zr,R,Sa,Ea,N)
#local C = 0;
#declare N=N-1;
#if (mod(Sa,360)=mod(Ea,360)) #declare Ea=(Sa+(Ea-Sa)*(N/(N+1))); #end
merge {
#while (C <= N)
sphere { <Xr*sin((Sa+(Ea-Sa)*(C/N))/180*pi),0,Zr*cos((Sa+(Ea-Sa)*(C/N))/180*pi)>,R }
#declare C=C+1;
#end
bounded_by { box { <-Xr-R,-R,-Zr-R>,<Xr+R,R,Zr+R> } } } #end

#macro roundbox (X1,Y1,Z1,X2,Y2,Z2)
#local T=0;
#local R=.05;
#if (X1>X2) #declare T=X2; #declare X2=X1; #declare X1=T; #end
#if (Y1>Y2) #declare T=Y2; #declare Y2=Y1; #declare Y1=T; #end
#if (Z1>Z2) #declare T=Z2; #declare Z2=Z1; #declare Z1=T; #end
merge {
   cylinder { <X1+R,Y1+R,Z1+R>,<X1+R,Y1+R,Z2-R>,R }
   cylinder { <X1+R,Y1+R,Z1+R>,<X1+R,Y2-R,Z1+R>,R }
   cylinder { <X1+R,Y1+R,Z1+R>,<X2-R,Y1+R,Z1+R>,R }
   cylinder { <X2-R,Y1+R,Z1+R>,<X2-R,Y1+R,Z2-R>,R }
   cylinder { <X1+R,Y1+R,Z2-R>,<X2-R,Y1+R,Z2-R>,R }
   cylinder { <X2-R,Y1+R,Z1+R>,<X2-R,Y2-R,Z1+R>,R }
   cylinder { <X1+R,Y1+R,Z2-R>,<X1+R,Y2-R,Z2-R>,R }
   cylinder { <X2-R,Y1+R,Z2-R>,<X2-R,Y2-R,Z2-R>,R }
   cylinder { <X1+R,Y2-R,Z1+R>,<X1+R,Y2-R,Z2-R>,R }
   cylinder { <X1+R,Y2-R,Z1+R>,<X2-R,Y2-R,Z1+R>,R }
   cylinder { <X2-R,Y2-R,Z1+R>,<X2-R,Y2-R,Z2-R>,R }
   cylinder { <X1+R,Y2-R,Z2-R>,<X2-R,Y2-R,Z2-R>,R }
   sphere { <X1+R,Y1+R,Z1+R>,R }
   sphere { <X1+R,Y1+R,Z2-R>,R }
   sphere { <X1+R,Y2-R,Z1+R>,R }
   sphere { <X1+R,Y2-R,Z2-R>,R }
   sphere { <X2-R,Y1+R,Z1+R>,R }
   sphere { <X2-R,Y1+R,Z2-R>,R }
   sphere { <X2-R,Y2-R,Z1+R>,R }
   sphere { <X2-R,Y2-R,Z2-R>,R }
   box { <X1,Y1+R,Z1+R>,<X2,Y2-R,Z2-R> }
   box { <X1+R,Y1,Z1+R>,<X2-R,Y2,Z2-R> }
   box { <X1+R,Y1+R,Z1>,<X2-R,Y2-R,Z2> }
   bounded_by { box { <X1,Y1,Z1>,<X2,Y2,Z2> } }
} #end

#macro roundcylinder (H,R1,R2)
merge {
   cylinder { <0,0,0>,<0,H,0>,R1-R2 }
   cylinder { <0,R2,0>,<0,H-R2,0>,R1 }
   torus { R1-R2,R2 translate <0,R2,0> }
   torus { R1-R2,R2 translate <0,H-R2,0> }
   bounded_by { cylinder { <0,0,0>,<0,H,0>,R1 } }
} #end

#declare bump=merge {
        cylinder { <0,0,0>,<0,.2,0>,.27 }
        cylinder { <0,-.06,0>,<0,.17,0>,.3 }
        torus { .27,.03 translate <0,.17,0> }
        bounded_by { cylinder { <0,-.06,0>,<0,.25,0>,.3 } }
}

#macro makelego (X1,Y1,Z1,X2,Y2,Z2)
#if (X1>X2) #declare T=X2; #declare X2=X1; #declare X1=T; #end
#if (Y1>Y2) #declare T=Y2; #declare Y2=Y1; #declare Y1=T; #end
#if (Z1>Z2) #declare T=Z2; #declare Z2=Z1; #declare Z1=T; #end
#local XC = 1; #local ZC = 1;
merge {
   difference {
      object { roundbox (X1,Y1,Z1,X2,Y2,Z2) }
      box { <X1+.2,Y1-1,Z1+.2>,<X2-.2,Y2-.2,Z2-.2> }
      #declare XC = 0;
      #while (XC < (X2-X1))
      #declare ZC = 0;
      #while (ZC < (Z2-Z1))
      cylinder { <X1+XC+.5,Y1,Z1+ZC+.5>,<X1+XC+.5,Y2+.1,Z1+ZC+.5>,.2 }
      #declare ZC=ZC+1;
      #end
      #declare XC=XC+1;
      #end      
      bounded_by { box { <X1,Y1,Z1>,<X2,Y2,Z2> } }
      }
   #declare XC=1; #declare ZC=1;
   #if ((X2-X1)>1)
   #if ((Z2-Z1)>1)
   #while (XC < (X2-X1))
   #declare ZC = 1;
   #while (ZC < (Z2-Z1))
   difference {
      cylinder { <X1+XC,Y1,Z1+ZC>,<X1+XC,Y2-.19,Z1+ZC>,.407 }
      cylinder { <X1+XC,Y1-.19,Z1+ZC>,<X1+XC,Y2,Z1+ZC>,.3 }
      bounded_by { cylinder { <X1+XC,Y1,Z1+ZC>,<X1+XC,Y2-.19,Z1+ZC>,.407 } }
   }
   #declare ZC=ZC+1;
   #end
   #declare XC=XC+1;
   #end
   #else
   #while (XC < (X2-X1))
   cylinder { <X1+XC,Y1,Z1+.5>,<X1+XC,Y2-.19,Z1+.5>,.2 }
   #declare XC=XC+1;
   #end #end #end
   #if ((Z2-Z1)>1)
   #while (ZC < (Z2-Z1))
   cylinder { <X1+.5,Y1,Z1+ZC>,<X1+.5,Y2-.19,Z1+ZC>,.2 }
   #declare ZC=ZC+1;
   #end #end
   #declare XC = 0;
   #while (XC < (X2-X1))
   #declare ZC = 0;
   #while (ZC < (Z2-Z1))
   object { bump translate <X1+XC+.5,Y2,Z1+ZC+.5> }
   #declare ZC=ZC+1;
   #end
   #declare XC=XC+1;
   #end
   bounded_by { box { <X1,Y1,Z1>,<X2,Y2+.2,Z2> } }
} #end

#declare lockseg = prism {
         -1,2,4
         <0,0>,<0,2>,<.390,1.962>,<0,0>
}

#declare lockminus = merge {
         object { lockseg rotate 0*y }
         object { lockseg rotate 22.5*y }
         object { lockseg rotate 45*y }
         object { lockseg rotate 67.5*y }
         object { lockseg rotate 90*y }
         object { lockseg rotate 112.5*y }
         object { lockseg rotate 135*y }
         object { lockseg rotate 157.5*y }
         object { lockseg rotate 180*y }
         object { lockseg rotate 202.5*y }
         object { lockseg rotate 225*y }
         object { lockseg rotate 247.5*y }
         object { lockseg rotate 270*y }
         object { lockseg rotate 292.5*y }
         object { lockseg rotate 315*y }
         object { lockseg rotate 337.5*y }
}

#declare WeaponFinish = finish { reflection 0 specular .3 roughness .008 }
#declare WeaponNormal = normal { bumps .08 scale .005 }
#declare BumpFinish = finish { reflection 0 specular .07 roughness .01 }
#declare BumpNormal = normal { bumps .2 scale .008 }
#declare LegoBlue      = texture {
         pigment { color rgb<.00, .35,.70> }
         finish { reflection .09 reflection_exponent 0.8 specular .9 roughness .005 ambient .2 diffuse .7 }
}
#declare LegoRed       = texture {
         pigment { color rgb<  .9, .05,.10> }
         finish { reflection .07 reflection_exponent 0.8 specular .9 roughness .005 ambient .2 diffuse .7 }
}
#declare LegoGreen     = texture {
         pigment { color rgb< .0, .50,.20> }
         finish { reflection .07 reflection_exponent 0.8 specular .9 roughness .005 ambient .2 diffuse .7 }
}
#declare LegoYellow    = texture {
         pigment { color rgb<.97, .75,.09> }
         finish { reflection .07  reflection_exponent 0.8 specular .9 roughness .005 ambient .2 diffuse .7 }
}
#declare LegoClearYellow = texture {
         pigment { color rgbt<.96, .79,.09,.8> }
         finish { reflection .07  reflection_exponent 0.8 specular .9 roughness .005 ambient .2 diffuse .7 }
}
#declare LegoGray      = texture {
         pigment { color rgb<.75, .73,.72> }
         finish { reflection .07 reflection_exponent 0.8 specular .9 roughness .005 ambient .14 diffuse .7 }
}
#declare LegoGrayDull  = texture {
         pigment { color rgb<.75,.73,.72> }
         finish { reflection .02 reflection_exponent 0.8 specular .9 roughness .02 crand .03 }
}
#declare LegoDkGray    = texture {
         pigment { color rgb<.40,.40,.37> }
         finish { reflection .07 reflection_exponent 0.8 specular .9 roughness .005 ambient .2 diffuse .7 }
}
#declare LegoWhite     = texture {
         pigment { color rgb<  1,  1,.97> }
         finish { reflection .07 reflection_exponent 0.8 specular .9 roughness .005 ambient .2 diffuse .7 }
}
#declare LegoBlack     = texture {
         pigment { color rgb<.1 ,.1 ,.1 > }
         finish { reflection .10 reflection_exponent 0.8 specular .9 roughness .005 ambient .2 diffuse .7 }
}
#declare LegoBlackDull = texture {
         pigment { color rgb<.05,.05,.05> }
         finish { reflection .02 reflection_exponent 0.8 specular .9 roughness .005 crand .03 }
}
#declare LegoClearRed  = texture {
         pigment { color rgbt< .7, 0,  0, .6> }
         finish { reflection .03 reflection_exponent 0.8 specular .9 roughness .005 ambient .2 diffuse .7 }
}
#declare LegoTireBlack = texture {
         pigment { color rgb< .05, .05, .05> }
         finish { reflection .01 specular .4 roughness .2 crand .4 }
}
#declare LegoBrown      = texture {
         pigment { color rgb<.4 , .2,.00> }
         finish { reflection .07 reflection_exponent 0.8 specular .9 roughness .005 ambient .2 diffuse .7 }
}

#declare cone1x1 = difference {
         merge {
               cylinder { <0,.9,0>,<0,1.2,0>,.3 }
               cylinder { <0,0,0>,<0,.3,0>,.42  }
               cone { <0,.2,0>,.5 <0,1,0>,.3 }
               }
         cylinder { <0,-1,0>,<0,.2,0>,.3 }
         cylinder { <0,.4,0>,<0,2,0>,.2 }
         box { <-.3,-1,-.12>,<.3,.5,.12> }
         box { <-.12,-1,-.3>,<.12,.5,.3> }
}

#declare axleend = intersection {
         merge {
               box { <-4,0,-.12>,<4,1.2,.12> }
               box { <-.12,0,-4>,<.12,1.2,4> }
         }
         cylinder { <0,-1,0>,<0,2,0>,.29 }
         merge {
               superellipsoid { <1,.3> rotate 90*x translate 1*y scale <.3,.3,.3> }
               box { <-4,.2,-4>,<4,10,4> }
         }
}

#declare axleseg = intersection {
         merge {
               box { <-4,0,-.12>,<4,1,.12> }
               box { <-.12,0,-4>,<.12,1,4> }
         }
         cylinder { <0,-1,0>,<0,2,0>,.29 }
}

