/* soft_prism
   Macro to make prisms with soft edges  
   Remco de Korte 1999 
   e-mail: remcodek@xs4all.nl
   Only supports linear sweeps and splines 
   but a conic sweep shouldn't be heart to add. 
   Perhaps later...
   It may give weird results for enclosing (concave?) prisms.
   Comments are welcome.
*/   

#macro soft_prism(bottom,top,num_points,pts,rad)

/* parameters:
     bottom, top - obvious
     num_points - the number of points (the prism doesn't have to be closed)
     pts - an array of 2D-vectors
     rad - the radius of the rounding of the edges 
     
   You can make it a merged prism by defining a variable "mergemode" and giving it any value.
   In the same way you can draw a wireframe by defining a variable "wireframe" with some value.
*/     
  

  #macro segment(h1,h2) // a 3-point-prism segment
  
// calculate 2D-vectors for the centers of the corner-spheres
    #local d1=vlength(h1-cent);
    #local d2=vlength(h2-cent);
    #local p1=cent+(h1-cent)*(d1-rad)/d1;
    #local p2=cent+(h2-cent)*(d2-rad)/d2;
    
//calculate 3D-vectors for the top and bottom-corners  
    #local tcent=<cent.u,top-rad,cent.v>;       
    #local tp1=<p1.u,top-rad,p1.v>;       
    #local tp2=<p2.u,top-rad,p2.v>;       
    #local bp1=<p1.u,bottom+rad,p1.v>;       
    #local bp2=<p2.u,bottom+rad,p2.v>;       
  
// calculate normal of the outside necessary to find start/end of the rounded edge
    #if (mod(num_points,2)=0)
      #local nn=<tp2.z-tp1.z,0,tp1.x-tp2.x>; 
    #else
      #local nn=-<tp2.z-tp1.z,0,tp1.x-tp2.x>; 
    #end
    #local nn=vnormalize(nn)*rad;
    #local n=<nn.x,nn.z>;
  
    #ifndef (wireframe)

// a short thick prism for the flat outside parts
      prism {
        linear_sweep
        linear_spline
        bottom+rad,top-rad,6,
        cent,p1,p1+n,p2+n,p2,cent
       }
// a long narrow prism for the top and bottom
      prism {
        linear_sweep
        linear_spline
        bottom,top,4,
        cent,p1,p2,cent   
       }
     #end  

// a sphere at the first top- and bottom-corner
    sphere{tp1,rad}
    sphere{bp1,rad}
     
// a cylinder connection the two outside corners and the first top- and bottom-corner     
    cylinder{tp1,tp2,rad}
    cylinder{bp1,bp2,rad}
    cylinder{tp1,bp1,rad}
    
  #end

#ifdef (csgmode)
  merge{
#else
  union{
#end        
  //calculate the center
  #local cent=<0,0>;
  #local tt=0;
  #while (tt<num_points)
    #local cent=cent+pts[tt];
    #local tt=tt+1;
  #end
  #local cent=cent/num_points;
          
  // create the segments        
  #local tt=0;
  #while (tt<num_points-1)
    segment(pts[tt],pts[tt+1])
    #local tt=tt+1;
  #end 
  segment(pts[num_points-1],pts[0])

   
  }
#end

//eof  