//  example-scene for Softtext 
//  Remco de Korte - remcodek@xs4all.nl

camera {location <0,0,-180> look_at <0,0,0>}

light_source{<-400,400,-400> rgb<1,.9,.5>}
light_source{<800,800,-400> rgb<.2,.4,.8> shadowless}
light_source{<-400,400,-400> rgb<1,1,1>*.7 shadowless}
light_source{<200,100,-300> color rgb .5 shadowless}
light_source{<200,-100,-300> color rgb .3 shadowless}
light_source{<-200,-100,-300> color rgb .1 shadowless}

#include "text.inc"


#debug "checking \n"
#declare minx=0;
#declare maxx=0;
#declare tt=0;
#while (tt<pcount)   
  #if (px[tt]<minx)
    #declare minx=px[tt];
  #end
  #if (px[tt]>maxx)
    #declare maxx=px[tt];
  #end
  #declare tt=tt+1;
#end            

#debug "correcting \n"
#declare midx=(minx+maxx)/2;
#declare tt=0;
#while (tt<pcount)   
  #declare px[tt]=px[tt]-midx+cent_hor;
  #declare tt=tt+1;
#end            
                     
#debug "constructing \n"                     
#declare ss=3;
#declare rr=seed(77);
union{
#declare tt=0;
#while (tt<pcount)   
  #if (rand(rr)>.7)
    #declare xx=px[tt]-cent_hor-1+rand(rr)*2;
    #declare yy=py[tt]-cent_ver-1+rand(rr)*2;
    #declare pp=<xx,yy+cent_ver/3,(sin(px[tt]*pi/size_hor)+sin(py[tt]*pi/size_hor))*-5>;
    #declare uu=0;
    #while (uu<10)
      #declare qq=<pp.x*1.01,pp.y*1.025-uu/5,pp.z*1.051>;
      cone{pp,1-uu*.1,qq,.95-uu*.1 pigment{rgb <uu*.075,uu*.125,uu*.025>}}
      #declare uu=uu+1;
      #declare pp=qq;
    #end           
  #end
  #declare tt=tt+1;
#end
pigment{rgb<1,.7,.1>}  
finish{phong .7 phong_size 200} 
translate -y*cent_ver/4       
}      

// eof