// Persistence of Vision Ray Tracer Scene Description File
// File: mediatmo.pov
// Vers: 3.0 and 3.1
// Desc: atmosphere and media compared
// Date: 99.55
// Auth: Bob Hughes  mailto://inversez@aol.com?Subject=Pov-Scene
// Note: renders in about an hour with AA on and at 320x240 res on a 233MHz Pentium
// Warning: rename output of render for second test (+oc:\images\atmosphr.bmp and +oc:\images\media.bmp)

#declare Volumetrics = 1

#switch (Volumetrics)
#case (1)
atmosphere {
 type 4
    distance 2000
    scattering 0.002
    //eccentricity 1
    samples 150
    jitter 0.5
    aa_threshold 0.1
    aa_level 5
    colour rgbf<1,1,1,1>*.8
}
#break
#case (2)
media {intervals 90 samples 4,40
 //emission <.2,.2,.2>*.004 absorption <.1,.1,.1>*.008
 scattering {4,.001 extinction .125 //eccentricity .1
 }
  density {rgb <.5,.5,.5>*1.25}}
#break
#end

box {-1500,1500 pigment {rgbf 1} inverse}

//#include "colors.inc"

//light_source {<0, 572, -93> color 0.7843*9}

light_source { <0,572,-93> color rgb 0.7843*9
 spotlight point_at <0,0,0> radius 45 falloff 45 tightness 1
#switch (Volumetrics)
#case (1)
atmosphere on atmospheric_attenuation on
#break
#case (2)
media_interaction on media_attenuation on
#break
#end
fade_distance 600 fade_power 1
}
light_source {<0,-250,-450> color rgb 0.4863*2.25
#switch (Volumetrics)
#case (1)
atmosphere off atmospheric_attenuation off
#break
#case (2)
media_interaction off media_attenuation off
#break
#end
fade_distance 300 fade_power 1
 shadowless
}

camera {location <-17, -168, -1139> look_at 0}

#declare Attribute0 =
//material {
  texture {
    pigment { color rgbf <0.396078, 0.443137, 0.560784, 0> }
    finish {
     ambient 0.2
     phong 0.57
     phong_size 0.82
     brilliance 1
     reflection 0
    }
  }
//  interior { ior 1 }
//}

sphere {<0, 25, 0>, 25*3
//material {Attribute0}
texture {Attribute0}
//pigment {color White}
translate <106, -262, 38>
}

union {
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-360.702,600,1200>, <-360.702,600,1200>, <-360.702,600,1200>, <-360.702,600,1200>,
<-360.702,416.667,1200>, <-360.702,477.778,1066.67>, <-360.702,538.889,933.333>, <-360.702,600,800>,
<-360.702,-316.667,1200>, <-360.702,-194.444,933.333>, <-360.702,477.778,-533.333>, <-360.702,600,-800>,
<-360.702,-500,1200>, <-360.702,-316.667,800>, <-360.702,416.667,-800>, <-360.702,600,-1200>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-360.702,-500,1200>, <-360.702,-500,1200>, <-360.702,-500,1200>, <-360.702,-500,1200>,
<-360.702,-500,800>, <-360.702,-438.889,800>, <-360.702,-377.778,800>, <-360.702,-316.667,800>,
<-360.702,-500,-800>, <-360.702,-377.778,-800>, <-360.702,294.444,-800>, <-360.702,416.667,-800>,
<-360.702,-500,-1200>, <-360.702,-316.667,-1200>, <-360.702,416.667,-1200>, <-360.702,600,-1200>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<356.953,600,-1200>, <356.953,600,-1200>, <356.953,600,-1200>, <356.953,600,-1200>,
<356.953,416.667,-1200>, <356.953,416.667,-1066.67>, <356.953,416.667,-933.333>, <356.953,416.667,-800>,
<356.953,-316.667,-1200>, <356.953,-316.667,-933.333>, <356.953,-316.667,533.333>, <356.953,-316.667,800>,
<356.953,-500,-1200>, <356.953,-500,-800>, <356.953,-500,800>, <356.953,-500,1200>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<356.953,600,-1200>, <356.953,600,-1200>, <356.953,600,-1200>, <356.953,600,-1200>,
<356.953,416.667,-800>, <356.953,477.778,-800>, <356.953,538.889,-800>, <356.953,600,-800>,
<356.953,-316.667,800>, <356.953,-194.444,800>, <356.953,477.778,800>, <356.953,600,800>,
<356.953,-500,1200>, <356.953,-316.667,1200>, <356.953,416.667,1200>, <356.953,600,1200>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,5,-1105.97>, <-81.5,5,-1105.97>, <-81.5,5,-1105.97>, <-81.5,5,-1105.97>,
<-54.3333,5,-1120.97>, <-63.3889,5,-1120.97>, <-72.4444,5,-1120.97>, <-81.5,5,-1120.97>,
<54.3333,5,-1180.97>, <36.2222,5,-1180.97>, <-63.3889,5,-1180.97>, <-81.5,5,-1180.97>,
<81.5,5,-1195.97>, <54.3333,5,-1195.97>, <-54.3333,5,-1195.97>, <-81.5,5,-1195.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,5,-1105.97>, <-81.5,5,-1105.97>, <-81.5,5,-1105.97>, <-81.5,5,-1105.97>,
<-54.3333,5,-1105.97>, <-54.3333,5,-1110.97>, <-54.3333,5,-1115.97>, <-54.3333,5,-1120.97>,
<54.3333,5,-1105.97>, <54.3333,5,-1115.97>, <54.3333,5,-1170.97>, <54.3333,5,-1180.97>,
<81.5,5,-1105.97>, <81.5,5,-1120.97>, <81.5,5,-1180.97>, <81.5,5,-1195.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,-5,-1105.97>, <-81.5,-5,-1105.97>, <-81.5,-5,-1105.97>, <-81.5,-5,-1105.97>,
<-54.3333,-5,-1120.97>, <-54.3333,-5,-1115.97>, <-54.3333,-5,-1110.97>, <-54.3333,-5,-1105.97>,
<54.3333,-5,-1180.97>, <54.3333,-5,-1170.97>, <54.3333,-5,-1115.97>, <54.3333,-5,-1105.97>,
<81.5,-5,-1195.97>, <81.5,-5,-1180.97>, <81.5,-5,-1120.97>, <81.5,-5,-1105.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,-5,-1105.97>, <-81.5,-5,-1105.97>, <-81.5,-5,-1105.97>, <-81.5,-5,-1105.97>,
<-81.5,-5,-1120.97>, <-72.4444,-5,-1120.97>, <-63.3889,-5,-1120.97>, <-54.3333,-5,-1120.97>,
<-81.5,-5,-1180.97>, <-63.3889,-5,-1180.97>, <36.2222,-5,-1180.97>, <54.3333,-5,-1180.97>,
<-81.5,-5,-1195.97>, <-54.3333,-5,-1195.97>, <54.3333,-5,-1195.97>, <81.5,-5,-1195.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,-5,-397.967>, <-81.5,-5,-397.967>, <-81.5,-5,-397.967>, <-81.5,-5,-397.967>,
<-54.3333,-5,-412.967>, <-63.3889,-5,-412.967>, <-72.4444,-5,-412.967>, <-81.5,-5,-412.967>,
<54.3333,-5,-472.967>, <36.2222,-5,-472.967>, <-63.3889,-5,-472.967>, <-81.5,-5,-472.967>,
<81.5,-5,-487.967>, <54.3333,-5,-487.967>, <-54.3333,-5,-487.967>, <-81.5,-5,-487.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,-5,-397.967>, <-81.5,-5,-397.967>, <-81.5,-5,-397.967>, <-81.5,-5,-397.967>,
<-54.3333,-5,-397.967>, <-54.3333,-5,-402.967>, <-54.3333,-5,-407.967>, <-54.3333,-5,-412.967>,
<54.3333,-5,-397.967>, <54.3333,-5,-407.967>, <54.3333,-5,-462.967>, <54.3333,-5,-472.967>,
<81.5,-5,-397.967>, <81.5,-5,-412.967>, <81.5,-5,-472.967>, <81.5,-5,-487.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<81.5,5,-487.967>, <81.5,5,-487.967>, <81.5,5,-487.967>, <81.5,5,-487.967>,
<81.5,5,-472.967>, <72.4444,5,-472.967>, <63.3889,5,-472.967>, <54.3333,5,-472.967>,
<81.5,5,-412.967>, <63.3889,5,-412.967>, <-36.2222,5,-412.967>, <-54.3333,5,-412.967>,
<81.5,5,-397.967>, <54.3333,5,-397.967>, <-54.3333,5,-397.967>, <-81.5,5,-397.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,5,-487.967>, <-81.5,5,-487.967>, <-81.5,5,-487.967>, <-81.5,5,-487.967>,
<-54.3333,5,-487.967>, <-63.3889,5,-482.967>, <-72.4444,5,-477.967>, <-81.5,5,-472.967>,
<54.3333,5,-487.967>, <36.2222,5,-477.967>, <-63.3889,5,-422.967>, <-81.5,5,-412.967>,
<81.5,5,-487.967>, <54.3333,5,-472.967>, <-54.3333,5,-412.967>, <-81.5,5,-397.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,5,-484.934>, <158.5,5,-484.934>, <158.5,5,-484.934>, <158.5,5,-484.934>,
<158.5,5,-469.934>, <167.556,5,-474.934>, <176.611,5,-479.934>, <185.667,5,-484.934>,
<158.5,5,-409.934>, <176.611,5,-419.934>, <276.222,5,-474.934>, <294.333,5,-484.934>,
<158.5,5,-394.934>, <185.667,5,-409.934>, <294.333,5,-469.934>, <321.5,5,-484.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<321.5,5,-484.934>, <321.5,5,-484.934>, <321.5,5,-484.934>, <321.5,5,-484.934>,
<294.333,5,-469.934>, <303.389,5,-469.934>, <312.444,5,-469.934>, <321.5,5,-469.934>,
<185.667,5,-409.934>, <203.778,5,-409.934>, <303.389,5,-409.934>, <321.5,5,-409.934>,
<158.5,5,-394.934>, <185.667,5,-394.934>, <294.333,5,-394.934>, <321.5,5,-394.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<321.5,5,-1192.93>, <321.5,5,-1192.93>, <321.5,5,-1192.93>, <321.5,5,-1192.93>,
<294.333,5,-1177.93>, <303.389,5,-1177.93>, <312.444,5,-1177.93>, <321.5,5,-1177.93>,
<185.667,5,-1117.93>, <203.778,5,-1117.93>, <303.389,5,-1117.93>, <321.5,5,-1117.93>,
<158.5,5,-1102.93>, <185.667,5,-1102.93>, <294.333,5,-1102.93>, <321.5,5,-1102.93>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,5,-1192.93>, <158.5,5,-1192.93>, <158.5,5,-1192.93>, <158.5,5,-1192.93>,
<158.5,5,-1177.93>, <167.556,5,-1182.93>, <176.611,5,-1187.93>, <185.667,5,-1192.93>,
<158.5,5,-1117.93>, <176.611,5,-1127.93>, <276.222,5,-1182.93>, <294.333,5,-1192.93>,
<158.5,5,-1102.93>, <185.667,5,-1117.93>, <294.333,5,-1177.93>, <321.5,5,-1192.93>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,-5,-484.934>, <158.5,-5,-484.934>, <158.5,-5,-484.934>, <158.5,-5,-484.934>,
<185.667,-5,-484.934>, <176.611,-5,-479.934>, <167.556,-5,-474.934>, <158.5,-5,-469.934>,
<294.333,-5,-484.934>, <276.222,-5,-474.934>, <176.611,-5,-419.934>, <158.5,-5,-409.934>,
<321.5,-5,-484.934>, <294.333,-5,-469.934>, <185.667,-5,-409.934>, <158.5,-5,-394.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<321.5,-5,-484.934>, <321.5,-5,-484.934>, <321.5,-5,-484.934>, <321.5,-5,-484.934>,
<321.5,-5,-469.934>, <312.444,-5,-469.934>, <303.389,-5,-469.934>, <294.333,-5,-469.934>,
<321.5,-5,-409.934>, <303.389,-5,-409.934>, <203.778,-5,-409.934>, <185.667,-5,-409.934>,
<321.5,-5,-394.934>, <294.333,-5,-394.934>, <185.667,-5,-394.934>, <158.5,-5,-394.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,-5,-1102.93>, <158.5,-5,-1102.93>, <158.5,-5,-1102.93>, <158.5,-5,-1102.93>,
<185.667,-5,-1117.93>, <185.667,-5,-1112.93>, <185.667,-5,-1107.93>, <185.667,-5,-1102.93>,
<294.333,-5,-1177.93>, <294.333,-5,-1167.93>, <294.333,-5,-1112.93>, <294.333,-5,-1102.93>,
<321.5,-5,-1192.93>, <321.5,-5,-1177.93>, <321.5,-5,-1117.93>, <321.5,-5,-1102.93>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,-5,-1102.93>, <158.5,-5,-1102.93>, <158.5,-5,-1102.93>, <158.5,-5,-1102.93>,
<158.5,-5,-1117.93>, <167.556,-5,-1117.93>, <176.611,-5,-1117.93>, <185.667,-5,-1117.93>,
<158.5,-5,-1177.93>, <176.611,-5,-1177.93>, <276.222,-5,-1177.93>, <294.333,-5,-1177.93>,
<158.5,-5,-1192.93>, <185.667,-5,-1192.93>, <294.333,-5,-1192.93>, <321.5,-5,-1192.93>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,4.52488,-487.967>, <-321.5,4.52488,-487.967>, <-321.5,4.52488,-487.967>, <-321.5,4.52488,-487.967>,
<-321.5,4.52488,-472.967>, <-312.444,4.52488,-477.967>, <-303.389,4.52488,-482.967>, <-294.333,4.52488,-487.967>,
<-321.5,4.52488,-412.967>, <-303.389,4.52488,-422.967>, <-203.778,4.52488,-477.967>, <-185.667,4.52488,-487.967>,
<-321.5,4.52488,-397.967>, <-294.333,4.52488,-412.967>, <-185.667,4.52488,-472.967>, <-158.5,4.52488,-487.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-158.5,4.52488,-487.967>, <-158.5,4.52488,-487.967>, <-158.5,4.52488,-487.967>, <-158.5,4.52488,-487.967>,
<-185.667,4.52488,-472.967>, <-176.611,4.52488,-472.967>, <-167.556,4.52488,-472.967>, <-158.5,4.52488,-472.967>,
<-294.333,4.52488,-412.967>, <-276.222,4.52488,-412.967>, <-176.611,4.52488,-412.967>, <-158.5,4.52488,-412.967>,
<-321.5,4.52488,-397.967>, <-294.333,4.52488,-397.967>, <-185.667,4.52488,-397.967>, <-158.5,4.52488,-397.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-158.5,4.52488,-1195.97>, <-158.5,4.52488,-1195.97>, <-158.5,4.52488,-1195.97>, <-158.5,4.52488,-1195.97>,
<-185.667,4.52488,-1180.97>, <-176.611,4.52488,-1180.97>, <-167.556,4.52488,-1180.97>, <-158.5,4.52488,-1180.97>,
<-294.333,4.52488,-1120.97>, <-276.222,4.52488,-1120.97>, <-176.611,4.52488,-1120.97>, <-158.5,4.52488,-1120.97>,
<-321.5,4.52488,-1105.97>, <-294.333,4.52488,-1105.97>, <-185.667,4.52488,-1105.97>, <-158.5,4.52488,-1105.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,4.52488,-1195.97>, <-321.5,4.52488,-1195.97>, <-321.5,4.52488,-1195.97>, <-321.5,4.52488,-1195.97>,
<-321.5,4.52488,-1180.97>, <-312.444,4.52488,-1185.97>, <-303.389,4.52488,-1190.97>, <-294.333,4.52488,-1195.97>,
<-321.5,4.52488,-1120.97>, <-303.389,4.52488,-1130.97>, <-203.778,4.52488,-1185.97>, <-185.667,4.52488,-1195.97>,
<-321.5,4.52488,-1105.97>, <-294.333,4.52488,-1120.97>, <-185.667,4.52488,-1180.97>, <-158.5,4.52488,-1195.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,-5.47512,-487.967>, <-321.5,-5.47512,-487.967>, <-321.5,-5.47512,-487.967>, <-321.5,-5.47512,-487.967>,
<-294.333,-5.47512,-487.967>, <-303.389,-5.47512,-482.967>, <-312.444,-5.47512,-477.967>, <-321.5,-5.47512,-472.967>,
<-185.667,-5.47512,-487.967>, <-203.778,-5.47512,-477.967>, <-303.389,-5.47512,-422.967>, <-321.5,-5.47512,-412.967>,
<-158.5,-5.47512,-487.967>, <-185.667,-5.47512,-472.967>, <-294.333,-5.47512,-412.967>, <-321.5,-5.47512,-397.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-158.5,-5.47512,-487.967>, <-158.5,-5.47512,-487.967>, <-158.5,-5.47512,-487.967>, <-158.5,-5.47512,-487.967>,
<-158.5,-5.47512,-472.967>, <-167.556,-5.47512,-472.967>, <-176.611,-5.47512,-472.967>, <-185.667,-5.47512,-472.967>,
<-158.5,-5.47512,-412.967>, <-176.611,-5.47512,-412.967>, <-276.222,-5.47512,-412.967>, <-294.333,-5.47512,-412.967>,
<-158.5,-5.47512,-397.967>, <-185.667,-5.47512,-397.967>, <-294.333,-5.47512,-397.967>, <-321.5,-5.47512,-397.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,-5.47512,-1105.97>, <-321.5,-5.47512,-1105.97>, <-321.5,-5.47512,-1105.97>, <-321.5,-5.47512,-1105.97>,
<-294.333,-5.47512,-1120.97>, <-294.333,-5.47512,-1115.97>, <-294.333,-5.47512,-1110.97>, <-294.333,-5.47512,-1105.97>,
<-185.667,-5.47512,-1180.97>, <-185.667,-5.47512,-1170.97>, <-185.667,-5.47512,-1115.97>, <-185.667,-5.47512,-1105.97>,
<-158.5,-5.47512,-1195.97>, <-158.5,-5.47512,-1180.97>, <-158.5,-5.47512,-1120.97>, <-158.5,-5.47512,-1105.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,-5.47512,-1105.97>, <-321.5,-5.47512,-1105.97>, <-321.5,-5.47512,-1105.97>, <-321.5,-5.47512,-1105.97>,
<-321.5,-5.47512,-1120.97>, <-312.444,-5.47512,-1120.97>, <-303.389,-5.47512,-1120.97>, <-294.333,-5.47512,-1120.97>,
<-321.5,-5.47512,-1180.97>, <-303.389,-5.47512,-1180.97>, <-203.778,-5.47512,-1180.97>, <-185.667,-5.47512,-1180.97>,
<-321.5,-5.47512,-1195.97>, <-294.333,-5.47512,-1195.97>, <-185.667,-5.47512,-1195.97>, <-158.5,-5.47512,-1195.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,5,494.033>, <-81.5,5,494.033>, <-81.5,5,494.033>, <-81.5,5,494.033>,
<-54.3333,5,479.033>, <-63.3889,5,479.033>, <-72.4444,5,479.033>, <-81.5,5,479.033>,
<54.3333,5,419.033>, <36.2222,5,419.033>, <-63.3889,5,419.033>, <-81.5,5,419.033>,
<81.5,5,404.033>, <54.3333,5,404.033>, <-54.3333,5,404.033>, <-81.5,5,404.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,5,494.033>, <-81.5,5,494.033>, <-81.5,5,494.033>, <-81.5,5,494.033>,
<-54.3333,5,494.033>, <-54.3333,5,489.033>, <-54.3333,5,484.033>, <-54.3333,5,479.033>,
<54.3333,5,494.033>, <54.3333,5,484.033>, <54.3333,5,429.033>, <54.3333,5,419.033>,
<81.5,5,494.033>, <81.5,5,479.033>, <81.5,5,419.033>, <81.5,5,404.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,-5,494.033>, <-81.5,-5,494.033>, <-81.5,-5,494.033>, <-81.5,-5,494.033>,
<-54.3333,-5,479.033>, <-54.3333,-5,484.033>, <-54.3333,-5,489.033>, <-54.3333,-5,494.033>,
<54.3333,-5,419.033>, <54.3333,-5,429.033>, <54.3333,-5,484.033>, <54.3333,-5,494.033>,
<81.5,-5,404.033>, <81.5,-5,419.033>, <81.5,-5,479.033>, <81.5,-5,494.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,-5,494.033>, <-81.5,-5,494.033>, <-81.5,-5,494.033>, <-81.5,-5,494.033>,
<-81.5,-5,479.033>, <-72.4444,-5,479.033>, <-63.3889,-5,479.033>, <-54.3333,-5,479.033>,
<-81.5,-5,419.033>, <-63.3889,-5,419.033>, <36.2222,-5,419.033>, <54.3333,-5,419.033>,
<-81.5,-5,404.033>, <-54.3333,-5,404.033>, <54.3333,-5,404.033>, <81.5,-5,404.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,-5,1202.03>, <-81.5,-5,1202.03>, <-81.5,-5,1202.03>, <-81.5,-5,1202.03>,
<-54.3333,-5,1187.03>, <-63.3889,-5,1187.03>, <-72.4444,-5,1187.03>, <-81.5,-5,1187.03>,
<54.3333,-5,1127.03>, <36.2222,-5,1127.03>, <-63.3889,-5,1127.03>, <-81.5,-5,1127.03>,
<81.5,-5,1112.03>, <54.3333,-5,1112.03>, <-54.3333,-5,1112.03>, <-81.5,-5,1112.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,-5,1202.03>, <-81.5,-5,1202.03>, <-81.5,-5,1202.03>, <-81.5,-5,1202.03>,
<-54.3333,-5,1202.03>, <-54.3333,-5,1197.03>, <-54.3333,-5,1192.03>, <-54.3333,-5,1187.03>,
<54.3333,-5,1202.03>, <54.3333,-5,1192.03>, <54.3333,-5,1137.03>, <54.3333,-5,1127.03>,
<81.5,-5,1202.03>, <81.5,-5,1187.03>, <81.5,-5,1127.03>, <81.5,-5,1112.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<81.5,5,1112.03>, <81.5,5,1112.03>, <81.5,5,1112.03>, <81.5,5,1112.03>,
<81.5,5,1127.03>, <72.4444,5,1127.03>, <63.3889,5,1127.03>, <54.3333,5,1127.03>,
<81.5,5,1187.03>, <63.3889,5,1187.03>, <-36.2222,5,1187.03>, <-54.3333,5,1187.03>,
<81.5,5,1202.03>, <54.3333,5,1202.03>, <-54.3333,5,1202.03>, <-81.5,5,1202.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,5,1112.03>, <-81.5,5,1112.03>, <-81.5,5,1112.03>, <-81.5,5,1112.03>,
<-54.3333,5,1112.03>, <-63.3889,5,1117.03>, <-72.4444,5,1122.03>, <-81.5,5,1127.03>,
<54.3333,5,1112.03>, <36.2222,5,1122.03>, <-63.3889,5,1177.03>, <-81.5,5,1187.03>,
<81.5,5,1112.03>, <54.3333,5,1127.03>, <-54.3333,5,1187.03>, <-81.5,5,1202.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,5,1115.07>, <158.5,5,1115.07>, <158.5,5,1115.07>, <158.5,5,1115.07>,
<158.5,5,1130.07>, <167.556,5,1125.07>, <176.611,5,1120.07>, <185.667,5,1115.07>,
<158.5,5,1190.07>, <176.611,5,1180.07>, <276.222,5,1125.07>, <294.333,5,1115.07>,
<158.5,5,1205.07>, <185.667,5,1190.07>, <294.333,5,1130.07>, <321.5,5,1115.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<321.5,5,1115.07>, <321.5,5,1115.07>, <321.5,5,1115.07>, <321.5,5,1115.07>,
<294.333,5,1130.07>, <303.389,5,1130.07>, <312.444,5,1130.07>, <321.5,5,1130.07>,
<185.667,5,1190.07>, <203.778,5,1190.07>, <303.389,5,1190.07>, <321.5,5,1190.07>,
<158.5,5,1205.07>, <185.667,5,1205.07>, <294.333,5,1205.07>, <321.5,5,1205.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<321.5,5,407.066>, <321.5,5,407.066>, <321.5,5,407.066>, <321.5,5,407.066>,
<294.333,5,422.066>, <303.389,5,422.066>, <312.444,5,422.066>, <321.5,5,422.066>,
<185.667,5,482.066>, <203.778,5,482.066>, <303.389,5,482.066>, <321.5,5,482.066>,
<158.5,5,497.066>, <185.667,5,497.066>, <294.333,5,497.066>, <321.5,5,497.066>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,5,407.066>, <158.5,5,407.066>, <158.5,5,407.066>, <158.5,5,407.066>,
<158.5,5,422.066>, <167.556,5,417.066>, <176.611,5,412.066>, <185.667,5,407.066>,
<158.5,5,482.066>, <176.611,5,472.066>, <276.222,5,417.066>, <294.333,5,407.066>,
<158.5,5,497.066>, <185.667,5,482.066>, <294.333,5,422.066>, <321.5,5,407.066>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,-5,1115.07>, <158.5,-5,1115.07>, <158.5,-5,1115.07>, <158.5,-5,1115.07>,
<185.667,-5,1115.07>, <176.611,-5,1120.07>, <167.556,-5,1125.07>, <158.5,-5,1130.07>,
<294.333,-5,1115.07>, <276.222,-5,1125.07>, <176.611,-5,1180.07>, <158.5,-5,1190.07>,
<321.5,-5,1115.07>, <294.333,-5,1130.07>, <185.667,-5,1190.07>, <158.5,-5,1205.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<321.5,-5,1115.07>, <321.5,-5,1115.07>, <321.5,-5,1115.07>, <321.5,-5,1115.07>,
<321.5,-5,1130.07>, <312.444,-5,1130.07>, <303.389,-5,1130.07>, <294.333,-5,1130.07>,
<321.5,-5,1190.07>, <303.389,-5,1190.07>, <203.778,-5,1190.07>, <185.667,-5,1190.07>,
<321.5,-5,1205.07>, <294.333,-5,1205.07>, <185.667,-5,1205.07>, <158.5,-5,1205.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,-5,497.066>, <158.5,-5,497.066>, <158.5,-5,497.066>, <158.5,-5,497.066>,
<185.667,-5,482.066>, <185.667,-5,487.066>, <185.667,-5,492.066>, <185.667,-5,497.066>,
<294.333,-5,422.066>, <294.333,-5,432.066>, <294.333,-5,487.066>, <294.333,-5,497.066>,
<321.5,-5,407.066>, <321.5,-5,422.066>, <321.5,-5,482.066>, <321.5,-5,497.066>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,-5,497.066>, <158.5,-5,497.066>, <158.5,-5,497.066>, <158.5,-5,497.066>,
<158.5,-5,482.066>, <167.556,-5,482.066>, <176.611,-5,482.066>, <185.667,-5,482.066>,
<158.5,-5,422.066>, <176.611,-5,422.066>, <276.222,-5,422.066>, <294.333,-5,422.066>,
<158.5,-5,407.066>, <185.667,-5,407.066>, <294.333,-5,407.066>, <321.5,-5,407.066>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,4.52488,1112.03>, <-321.5,4.52488,1112.03>, <-321.5,4.52488,1112.03>, <-321.5,4.52488,1112.03>,
<-321.5,4.52488,1127.03>, <-312.444,4.52488,1122.03>, <-303.389,4.52488,1117.03>, <-294.333,4.52488,1112.03>,
<-321.5,4.52488,1187.03>, <-303.389,4.52488,1177.03>, <-203.778,4.52488,1122.03>, <-185.667,4.52488,1112.03>,
<-321.5,4.52488,1202.03>, <-294.333,4.52488,1187.03>, <-185.667,4.52488,1127.03>, <-158.5,4.52488,1112.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-158.5,4.52488,1112.03>, <-158.5,4.52488,1112.03>, <-158.5,4.52488,1112.03>, <-158.5,4.52488,1112.03>,
<-185.667,4.52488,1127.03>, <-176.611,4.52488,1127.03>, <-167.556,4.52488,1127.03>, <-158.5,4.52488,1127.03>,
<-294.333,4.52488,1187.03>, <-276.222,4.52488,1187.03>, <-176.611,4.52488,1187.03>, <-158.5,4.52488,1187.03>,
<-321.5,4.52488,1202.03>, <-294.333,4.52488,1202.03>, <-185.667,4.52488,1202.03>, <-158.5,4.52488,1202.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-158.5,4.52488,404.033>, <-158.5,4.52488,404.033>, <-158.5,4.52488,404.033>, <-158.5,4.52488,404.033>,
<-185.667,4.52488,419.033>, <-176.611,4.52488,419.033>, <-167.556,4.52488,419.033>, <-158.5,4.52488,419.033>,
<-294.333,4.52488,479.033>, <-276.222,4.52488,479.033>, <-176.611,4.52488,479.033>, <-158.5,4.52488,479.033>,
<-321.5,4.52488,494.033>, <-294.333,4.52488,494.033>, <-185.667,4.52488,494.033>, <-158.5,4.52488,494.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,4.52488,404.033>, <-321.5,4.52488,404.033>, <-321.5,4.52488,404.033>, <-321.5,4.52488,404.033>,
<-321.5,4.52488,419.033>, <-312.444,4.52488,414.033>, <-303.389,4.52488,409.033>, <-294.333,4.52488,404.033>,
<-321.5,4.52488,479.033>, <-303.389,4.52488,469.033>, <-203.778,4.52488,414.033>, <-185.667,4.52488,404.033>,
<-321.5,4.52488,494.033>, <-294.333,4.52488,479.033>, <-185.667,4.52488,419.033>, <-158.5,4.52488,404.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,-5.47512,1112.03>, <-321.5,-5.47512,1112.03>, <-321.5,-5.47512,1112.03>, <-321.5,-5.47512,1112.03>,
<-294.333,-5.47512,1112.03>, <-303.389,-5.47512,1117.03>, <-312.444,-5.47512,1122.03>, <-321.5,-5.47512,1127.03>,
<-185.667,-5.47512,1112.03>, <-203.778,-5.47512,1122.03>, <-303.389,-5.47512,1177.03>, <-321.5,-5.47512,1187.03>,
<-158.5,-5.47512,1112.03>, <-185.667,-5.47512,1127.03>, <-294.333,-5.47512,1187.03>, <-321.5,-5.47512,1202.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-158.5,-5.47512,1112.03>, <-158.5,-5.47512,1112.03>, <-158.5,-5.47512,1112.03>, <-158.5,-5.47512,1112.03>,
<-158.5,-5.47512,1127.03>, <-167.556,-5.47512,1127.03>, <-176.611,-5.47512,1127.03>, <-185.667,-5.47512,1127.03>,
<-158.5,-5.47512,1187.03>, <-176.611,-5.47512,1187.03>, <-276.222,-5.47512,1187.03>, <-294.333,-5.47512,1187.03>,
<-158.5,-5.47512,1202.03>, <-185.667,-5.47512,1202.03>, <-294.333,-5.47512,1202.03>, <-321.5,-5.47512,1202.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,-5.47512,494.033>, <-321.5,-5.47512,494.033>, <-321.5,-5.47512,494.033>, <-321.5,-5.47512,494.033>,
<-294.333,-5.47512,479.033>, <-294.333,-5.47512,484.033>, <-294.333,-5.47512,489.033>, <-294.333,-5.47512,494.033>,
<-185.667,-5.47512,419.033>, <-185.667,-5.47512,429.033>, <-185.667,-5.47512,484.033>, <-185.667,-5.47512,494.033>,
<-158.5,-5.47512,404.033>, <-158.5,-5.47512,419.033>, <-158.5,-5.47512,479.033>, <-158.5,-5.47512,494.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,-5.47512,494.033>, <-321.5,-5.47512,494.033>, <-321.5,-5.47512,494.033>, <-321.5,-5.47512,494.033>,
<-321.5,-5.47512,479.033>, <-312.444,-5.47512,479.033>, <-303.389,-5.47512,479.033>, <-294.333,-5.47512,479.033>,
<-321.5,-5.47512,419.033>, <-303.389,-5.47512,419.033>, <-203.778,-5.47512,419.033>, <-185.667,-5.47512,419.033>,
<-321.5,-5.47512,404.033>, <-294.333,-5.47512,404.033>, <-185.667,-5.47512,404.033>, <-158.5,-5.47512,404.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,4.52488,-309>, <-321.5,4.52488,-309>, <-321.5,4.52488,-309>, <-321.5,4.52488,-309>,
<-294.333,4.52488,-324>, <-303.389,4.52488,-324>, <-312.444,4.52488,-324>, <-321.5,4.52488,-324>,
<-185.667,4.52488,-384>, <-203.778,4.52488,-384>, <-303.389,4.52488,-384>, <-321.5,4.52488,-384>,
<-158.5,4.52488,-399>, <-185.667,4.52488,-399>, <-294.333,4.52488,-399>, <-321.5,4.52488,-399>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,4.52488,-309>, <-321.5,4.52488,-309>, <-321.5,4.52488,-309>, <-321.5,4.52488,-309>,
<-294.333,4.52488,-309>, <-294.333,4.52488,-314>, <-294.333,4.52488,-319>, <-294.333,4.52488,-324>,
<-185.667,4.52488,-309>, <-185.667,4.52488,-319>, <-185.667,4.52488,-374>, <-185.667,4.52488,-384>,
<-158.5,4.52488,-309>, <-158.5,4.52488,-324>, <-158.5,4.52488,-384>, <-158.5,4.52488,-399>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,-5.47512,-309>, <-321.5,-5.47512,-309>, <-321.5,-5.47512,-309>, <-321.5,-5.47512,-309>,
<-294.333,-5.47512,-324>, <-294.333,-5.47512,-319>, <-294.333,-5.47512,-314>, <-294.333,-5.47512,-309>,
<-185.667,-5.47512,-384>, <-185.667,-5.47512,-374>, <-185.667,-5.47512,-319>, <-185.667,-5.47512,-309>,
<-158.5,-5.47512,-399>, <-158.5,-5.47512,-384>, <-158.5,-5.47512,-324>, <-158.5,-5.47512,-309>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,-5.47512,-309>, <-321.5,-5.47512,-309>, <-321.5,-5.47512,-309>, <-321.5,-5.47512,-309>,
<-321.5,-5.47512,-324>, <-312.444,-5.47512,-324>, <-303.389,-5.47512,-324>, <-294.333,-5.47512,-324>,
<-321.5,-5.47512,-384>, <-303.389,-5.47512,-384>, <-203.778,-5.47512,-384>, <-185.667,-5.47512,-384>,
<-321.5,-5.47512,-399>, <-294.333,-5.47512,-399>, <-185.667,-5.47512,-399>, <-158.5,-5.47512,-399>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,-5.47512,399>, <-321.5,-5.47512,399>, <-321.5,-5.47512,399>, <-321.5,-5.47512,399>,
<-294.333,-5.47512,384>, <-303.389,-5.47512,384>, <-312.444,-5.47512,384>, <-321.5,-5.47512,384>,
<-185.667,-5.47512,324>, <-203.778,-5.47512,324>, <-303.389,-5.47512,324>, <-321.5,-5.47512,324>,
<-158.5,-5.47512,309>, <-185.667,-5.47512,309>, <-294.333,-5.47512,309>, <-321.5,-5.47512,309>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,-5.47512,399>, <-321.5,-5.47512,399>, <-321.5,-5.47512,399>, <-321.5,-5.47512,399>,
<-294.333,-5.47512,399>, <-294.333,-5.47512,394>, <-294.333,-5.47512,389>, <-294.333,-5.47512,384>,
<-185.667,-5.47512,399>, <-185.667,-5.47512,389>, <-185.667,-5.47512,334>, <-185.667,-5.47512,324>,
<-158.5,-5.47512,399>, <-158.5,-5.47512,384>, <-158.5,-5.47512,324>, <-158.5,-5.47512,309>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-158.5,4.52488,309>, <-158.5,4.52488,309>, <-158.5,4.52488,309>, <-158.5,4.52488,309>,
<-158.5,4.52488,324>, <-167.556,4.52488,324>, <-176.611,4.52488,324>, <-185.667,4.52488,324>,
<-158.5,4.52488,384>, <-176.611,4.52488,384>, <-276.222,4.52488,384>, <-294.333,4.52488,384>,
<-158.5,4.52488,399>, <-185.667,4.52488,399>, <-294.333,4.52488,399>, <-321.5,4.52488,399>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,4.52488,309>, <-321.5,4.52488,309>, <-321.5,4.52488,309>, <-321.5,4.52488,309>,
<-294.333,4.52488,309>, <-303.389,4.52488,314>, <-312.444,4.52488,319>, <-321.5,4.52488,324>,
<-185.667,4.52488,309>, <-203.778,4.52488,319>, <-303.389,4.52488,374>, <-321.5,4.52488,384>,
<-158.5,4.52488,309>, <-185.667,4.52488,324>, <-294.333,4.52488,384>, <-321.5,4.52488,399>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,5,-305.967>, <158.5,5,-305.967>, <158.5,5,-305.967>, <158.5,5,-305.967>,
<185.667,5,-320.967>, <176.611,5,-320.967>, <167.556,5,-320.967>, <158.5,5,-320.967>,
<294.333,5,-380.967>, <276.222,5,-380.967>, <176.611,5,-380.967>, <158.5,5,-380.967>,
<321.5,5,-395.967>, <294.333,5,-395.967>, <185.667,5,-395.967>, <158.5,5,-395.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,5,-305.967>, <158.5,5,-305.967>, <158.5,5,-305.967>, <158.5,5,-305.967>,
<185.667,5,-305.967>, <185.667,5,-310.967>, <185.667,5,-315.967>, <185.667,5,-320.967>,
<294.333,5,-305.967>, <294.333,5,-315.967>, <294.333,5,-370.967>, <294.333,5,-380.967>,
<321.5,5,-305.967>, <321.5,5,-320.967>, <321.5,5,-380.967>, <321.5,5,-395.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,-5,-305.967>, <158.5,-5,-305.967>, <158.5,-5,-305.967>, <158.5,-5,-305.967>,
<185.667,-5,-320.967>, <185.667,-5,-315.967>, <185.667,-5,-310.967>, <185.667,-5,-305.967>,
<294.333,-5,-380.967>, <294.333,-5,-370.967>, <294.333,-5,-315.967>, <294.333,-5,-305.967>,
<321.5,-5,-395.967>, <321.5,-5,-380.967>, <321.5,-5,-320.967>, <321.5,-5,-305.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,-5,-305.967>, <158.5,-5,-305.967>, <158.5,-5,-305.967>, <158.5,-5,-305.967>,
<158.5,-5,-320.967>, <167.556,-5,-320.967>, <176.611,-5,-320.967>, <185.667,-5,-320.967>,
<158.5,-5,-380.967>, <176.611,-5,-380.967>, <276.222,-5,-380.967>, <294.333,-5,-380.967>,
<158.5,-5,-395.967>, <185.667,-5,-395.967>, <294.333,-5,-395.967>, <321.5,-5,-395.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,-5,402.033>, <158.5,-5,402.033>, <158.5,-5,402.033>, <158.5,-5,402.033>,
<185.667,-5,387.033>, <176.611,-5,387.033>, <167.556,-5,387.033>, <158.5,-5,387.033>,
<294.333,-5,327.033>, <276.222,-5,327.033>, <176.611,-5,327.033>, <158.5,-5,327.033>,
<321.5,-5,312.033>, <294.333,-5,312.033>, <185.667,-5,312.033>, <158.5,-5,312.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,-5,402.033>, <158.5,-5,402.033>, <158.5,-5,402.033>, <158.5,-5,402.033>,
<185.667,-5,402.033>, <185.667,-5,397.033>, <185.667,-5,392.033>, <185.667,-5,387.033>,
<294.333,-5,402.033>, <294.333,-5,392.033>, <294.333,-5,337.033>, <294.333,-5,327.033>,
<321.5,-5,402.033>, <321.5,-5,387.033>, <321.5,-5,327.033>, <321.5,-5,312.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<321.5,5,312.033>, <321.5,5,312.033>, <321.5,5,312.033>, <321.5,5,312.033>,
<321.5,5,327.033>, <312.444,5,327.033>, <303.389,5,327.033>, <294.333,5,327.033>,
<321.5,5,387.033>, <303.389,5,387.033>, <203.778,5,387.033>, <185.667,5,387.033>,
<321.5,5,402.033>, <294.333,5,402.033>, <185.667,5,402.033>, <158.5,5,402.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,5,312.033>, <158.5,5,312.033>, <158.5,5,312.033>, <158.5,5,312.033>,
<185.667,5,312.033>, <176.611,5,317.033>, <167.556,5,322.033>, <158.5,5,327.033>,
<294.333,5,312.033>, <276.222,5,322.033>, <176.611,5,377.033>, <158.5,5,387.033>,
<321.5,5,312.033>, <294.333,5,327.033>, <185.667,5,387.033>, <158.5,5,402.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,5,309>, <-81.5,5,309>, <-81.5,5,309>, <-81.5,5,309>,
<-54.3333,5,309>, <-63.3889,5,314>, <-72.4444,5,319>, <-81.5,5,324>,
<54.3333,5,309>, <36.2222,5,319>, <-63.3889,5,374>, <-81.5,5,384>,
<81.5,5,309>, <54.3333,5,324>, <-54.3333,5,384>, <-81.5,5,399>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<81.5,5,309>, <81.5,5,309>, <81.5,5,309>, <81.5,5,309>,
<81.5,5,324>, <72.4444,5,324>, <63.3889,5,324>, <54.3333,5,324>,
<81.5,5,384>, <63.3889,5,384>, <-36.2222,5,384>, <-54.3333,5,384>,
<81.5,5,399>, <54.3333,5,399>, <-54.3333,5,399>, <-81.5,5,399>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<81.5,5,-399>, <81.5,5,-399>, <81.5,5,-399>, <81.5,5,-399>,
<54.3333,5,-384>, <63.3889,5,-384>, <72.4444,5,-384>, <81.5,5,-384>,
<-54.3333,5,-324>, <-36.2222,5,-324>, <63.3889,5,-324>, <81.5,5,-324>,
<-81.5,5,-309>, <-54.3333,5,-309>, <54.3333,5,-309>, <81.5,5,-309>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,5,-399>, <-81.5,5,-399>, <-81.5,5,-399>, <-81.5,5,-399>,
<-81.5,5,-384>, <-72.4444,5,-389>, <-63.3889,5,-394>, <-54.3333,5,-399>,
<-81.5,5,-324>, <-63.3889,5,-334>, <36.2222,5,-389>, <54.3333,5,-399>,
<-81.5,5,-309>, <-54.3333,5,-324>, <54.3333,5,-384>, <81.5,5,-399>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,-5,309>, <-81.5,-5,309>, <-81.5,-5,309>, <-81.5,-5,309>,
<-81.5,-5,324>, <-72.4444,-5,319>, <-63.3889,-5,314>, <-54.3333,-5,309>,
<-81.5,-5,384>, <-63.3889,-5,374>, <36.2222,-5,319>, <54.3333,-5,309>,
<-81.5,-5,399>, <-54.3333,-5,384>, <54.3333,-5,324>, <81.5,-5,309>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<81.5,-5,309>, <81.5,-5,309>, <81.5,-5,309>, <81.5,-5,309>,
<54.3333,-5,324>, <63.3889,-5,324>, <72.4444,-5,324>, <81.5,-5,324>,
<-54.3333,-5,384>, <-36.2222,-5,384>, <63.3889,-5,384>, <81.5,-5,384>,
<-81.5,-5,399>, <-54.3333,-5,399>, <54.3333,-5,399>, <81.5,-5,399>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,-5,-309>, <-81.5,-5,-309>, <-81.5,-5,-309>, <-81.5,-5,-309>,
<-54.3333,-5,-324>, <-54.3333,-5,-319>, <-54.3333,-5,-314>, <-54.3333,-5,-309>,
<54.3333,-5,-384>, <54.3333,-5,-374>, <54.3333,-5,-319>, <54.3333,-5,-309>,
<81.5,-5,-399>, <81.5,-5,-384>, <81.5,-5,-324>, <81.5,-5,-309>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,-5,-309>, <-81.5,-5,-309>, <-81.5,-5,-309>, <-81.5,-5,-309>,
<-81.5,-5,-324>, <-72.4444,-5,-324>, <-63.3889,-5,-324>, <-54.3333,-5,-324>,
<-81.5,-5,-384>, <-63.3889,-5,-384>, <36.2222,-5,-384>, <54.3333,-5,-384>,
<-81.5,-5,-399>, <-54.3333,-5,-399>, <54.3333,-5,-399>, <81.5,-5,-399>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<356.953,600,-1200>, <356.953,416.667,-1200>, <356.953,-316.667,-1200>, <356.953,-500,-1200>,
<237.344,600,-1200>, <237.344,416.667,-1200>, <237.344,-316.667,-1200>, <237.344,-500,-1200>,
<-241.093,600,-1200>, <-241.093,416.667,-1200>, <-241.093,-316.667,-1200>, <-241.093,-500,-1200>,
<-360.702,600,-1200>, <-360.702,416.667,-1200>, <-360.702,-316.667,-1200>, <-360.702,-500,-1200>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<356.953,600,-1200>, <237.344,600,-1200>, <-241.093,600,-1200>, <-360.702,600,-1200>,
<356.953,600,-800>, <237.344,600,-800>, <-241.093,600,-800>, <-360.702,600,-800>,
<356.953,600,800>, <237.344,600,800>, <-241.093,600,800>, <-360.702,600,800>,
<356.953,600,1200>, <237.344,600,1200>, <-241.093,600,1200>, <-360.702,600,1200>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<356.953,600,1200>, <237.344,600,1200>, <-241.093,600,1200>, <-360.702,600,1200>,
<356.953,416.667,1200>, <237.344,416.667,1200>, <-241.093,416.667,1200>, <-360.702,416.667,1200>,
<356.953,-316.667,1200>, <237.344,-316.667,1200>, <-241.093,-316.667,1200>, <-360.702,-316.667,1200>,
<356.953,-500,1200>, <237.344,-500,1200>, <-241.093,-500,1200>, <-360.702,-500,1200>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<356.953,-500,1200>, <237.344,-500,1200>, <-241.093,-500,1200>, <-360.702,-500,1200>,
<356.953,-500,800>, <237.344,-500,800>, <-241.093,-500,800>, <-360.702,-500,800>,
<356.953,-500,-800>, <237.344,-500,-800>, <-241.093,-500,-800>, <-360.702,-500,-800>,
<356.953,-500,-1200>, <237.344,-500,-1200>, <-241.093,-500,-1200>, <-360.702,-500,-1200>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-90,15,-396.967>, <-90,15,-530.301>, <-90,15,-1063.64>, <-90,15,-1196.97>,
<-93.3333,15,-396.967>, <-93.3333,15,-530.301>, <-93.3333,15,-1063.64>, <-93.3333,15,-1196.97>,
<-106.667,15,-396.967>, <-106.667,15,-530.301>, <-106.667,15,-1063.64>, <-106.667,15,-1196.97>,
<-110,15,-396.967>, <-110,15,-530.301>, <-110,15,-1063.64>, <-110,15,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-90,15,-396.967>, <-89.1667,14.1667,-396.967>, <-85.8333,10.8333,-396.967>, <-85,10,-396.967>,
<-90,15,-530.301>, <-89.1667,14.1667,-530.301>, <-85.8333,10.8333,-530.301>, <-85,10,-530.301>,
<-90,15,-1063.64>, <-89.1667,14.1667,-1063.64>, <-85.8333,10.8333,-1063.64>, <-85,10,-1063.64>,
<-90,15,-1196.97>, <-89.1667,14.1667,-1196.97>, <-85.8333,10.8333,-1196.97>, <-85,10,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-90,15,-396.967>, <-90,10,-396.967>, <-90,-10,-396.967>, <-90,-15,-396.967>,
<-89.1667,14.1667,-396.967>, <-89.1667,9.72222,-396.967>, <-89.1667,-9.72222,-396.967>, <-89.1667,-14.1667,-396.967>,
<-85.8333,10.8333,-396.967>, <-85.8333,6.94444,-396.967>, <-85.8333,-6.94444,-396.967>, <-85.8333,-10.8333,-396.967>,
<-85,10,-396.967>, <-85,6.66667,-396.967>, <-85,-6.66667,-396.967>, <-85,-10,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-90,15,-396.967>, <-93.3333,15,-396.967>, <-106.667,15,-396.967>, <-110,15,-396.967>,
<-90,10,-396.967>, <-93.3333,10,-396.967>, <-106.667,10,-396.967>, <-110,10,-396.967>,
<-90,-10,-396.967>, <-93.3333,-10,-396.967>, <-106.667,-10,-396.967>, <-110,-10,-396.967>,
<-90,-15,-396.967>, <-93.3333,-15,-396.967>, <-106.667,-15,-396.967>, <-110,-15,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-85,-10,-396.967>, <-85.8333,-10.8333,-396.967>, <-89.1667,-14.1667,-396.967>, <-90,-15,-396.967>,
<-85,-10,-530.301>, <-85.8333,-10.8333,-530.301>, <-89.1667,-14.1667,-530.301>, <-90,-15,-530.301>,
<-85,-10,-1063.64>, <-85.8333,-10.8333,-1063.64>, <-89.1667,-14.1667,-1063.64>, <-90,-15,-1063.64>,
<-85,-10,-1196.97>, <-85.8333,-10.8333,-1196.97>, <-89.1667,-14.1667,-1196.97>, <-90,-15,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-90,-15,-396.967>, <-93.3333,-15,-396.967>, <-106.667,-15,-396.967>, <-110,-15,-396.967>,
<-90,-15,-530.301>, <-93.3333,-15,-530.301>, <-106.667,-15,-530.301>, <-110,-15,-530.301>,
<-90,-15,-1063.64>, <-93.3333,-15,-1063.64>, <-106.667,-15,-1063.64>, <-110,-15,-1063.64>,
<-90,-15,-1196.97>, <-93.3333,-15,-1196.97>, <-106.667,-15,-1196.97>, <-110,-15,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-110,15,-1196.97>, <-106.667,15,-1196.97>, <-93.3333,15,-1196.97>, <-90,15,-1196.97>,
<-110,10,-1196.97>, <-106.667,10,-1196.97>, <-93.3333,10,-1196.97>, <-90,10,-1196.97>,
<-110,-10,-1196.97>, <-106.667,-10,-1196.97>, <-93.3333,-10,-1196.97>, <-90,-10,-1196.97>,
<-110,-15,-1196.97>, <-106.667,-15,-1196.97>, <-93.3333,-15,-1196.97>, <-90,-15,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-90,15,-1196.97>, <-89.1667,14.1667,-1196.97>, <-85.8333,10.8333,-1196.97>, <-85,10,-1196.97>,
<-90,10,-1196.97>, <-89.1667,9.72222,-1196.97>, <-85.8333,6.94444,-1196.97>, <-85,6.66667,-1196.97>,
<-90,-10,-1196.97>, <-89.1667,-9.72222,-1196.97>, <-85.8333,-6.94444,-1196.97>, <-85,-6.66667,-1196.97>,
<-90,-15,-1196.97>, <-89.1667,-14.1667,-1196.97>, <-85.8333,-10.8333,-1196.97>, <-85,-10,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-110,15,-396.967>, <-110,15,-530.301>, <-110,15,-1063.64>, <-110,15,-1196.97>,
<-110.833,14.1667,-396.967>, <-110.833,14.1667,-530.301>, <-110.833,14.1667,-1063.64>, <-110.833,14.1667,-1196.97>,
<-114.167,10.8333,-396.967>, <-114.167,10.8333,-530.301>, <-114.167,10.8333,-1063.64>, <-114.167,10.8333,-1196.97>,
<-115,10,-396.967>, <-115,10,-530.301>, <-115,10,-1063.64>, <-115,10,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-110,15,-396.967>, <-110.833,14.1667,-396.967>, <-114.167,10.8333,-396.967>, <-115,10,-396.967>,
<-110,10,-396.967>, <-110.833,9.72222,-396.967>, <-114.167,6.94444,-396.967>, <-115,6.66667,-396.967>,
<-110,-10,-396.967>, <-110.833,-9.72222,-396.967>, <-114.167,-6.94444,-396.967>, <-115,-6.66667,-396.967>,
<-110,-15,-396.967>, <-110.833,-14.1667,-396.967>, <-114.167,-10.8333,-396.967>, <-115,-10,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-110,-15,-396.967>, <-110.833,-14.1667,-396.967>, <-114.167,-10.8333,-396.967>, <-115,-10,-396.967>,
<-110,-15,-530.301>, <-110.833,-14.1667,-530.301>, <-114.167,-10.8333,-530.301>, <-115,-10,-530.301>,
<-110,-15,-1063.64>, <-110.833,-14.1667,-1063.64>, <-114.167,-10.8333,-1063.64>, <-115,-10,-1063.64>,
<-110,-15,-1196.97>, <-110.833,-14.1667,-1196.97>, <-114.167,-10.8333,-1196.97>, <-115,-10,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-110,15,-1196.97>, <-110,10,-1196.97>, <-110,-10,-1196.97>, <-110,-15,-1196.97>,
<-110.833,14.1667,-1196.97>, <-110.833,9.72222,-1196.97>, <-110.833,-9.72222,-1196.97>, <-110.833,-14.1667,-1196.97>,
<-114.167,10.8333,-1196.97>, <-114.167,6.94444,-1196.97>, <-114.167,-6.94444,-1196.97>, <-114.167,-10.8333,-1196.97>,
<-115,10,-1196.97>, <-115,6.66667,-1196.97>, <-115,-6.66667,-1196.97>, <-115,-10,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<110,15,-396.967>, <110,15,-530.301>, <110,15,-1063.64>, <110,15,-1196.97>,
<106.667,15,-396.967>, <106.667,15,-530.301>, <106.667,15,-1063.64>, <106.667,15,-1196.97>,
<93.3333,15,-396.967>, <93.3333,15,-530.301>, <93.3333,15,-1063.64>, <93.3333,15,-1196.97>,
<90,15,-396.967>, <90,15,-530.301>, <90,15,-1063.64>, <90,15,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<110,15,-396.967>, <110.833,14.1667,-396.967>, <114.167,10.8333,-396.967>, <115,10,-396.967>,
<110,15,-530.301>, <110.833,14.1667,-530.301>, <114.167,10.8333,-530.301>, <115,10,-530.301>,
<110,15,-1063.64>, <110.833,14.1667,-1063.64>, <114.167,10.8333,-1063.64>, <115,10,-1063.64>,
<110,15,-1196.97>, <110.833,14.1667,-1196.97>, <114.167,10.8333,-1196.97>, <115,10,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<110,15,-396.967>, <110,10,-396.967>, <110,-10,-396.967>, <110,-15,-396.967>,
<110.833,14.1667,-396.967>, <110.833,9.72222,-396.967>, <110.833,-9.72222,-396.967>, <110.833,-14.1667,-396.967>,
<114.167,10.8333,-396.967>, <114.167,6.94444,-396.967>, <114.167,-6.94444,-396.967>, <114.167,-10.8333,-396.967>,
<115,10,-396.967>, <115,6.66667,-396.967>, <115,-6.66667,-396.967>, <115,-10,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<110,15,-396.967>, <106.667,15,-396.967>, <93.3333,15,-396.967>, <90,15,-396.967>,
<110,10,-396.967>, <106.667,10,-396.967>, <93.3333,10,-396.967>, <90,10,-396.967>,
<110,-10,-396.967>, <106.667,-10,-396.967>, <93.3333,-10,-396.967>, <90,-10,-396.967>,
<110,-15,-396.967>, <106.667,-15,-396.967>, <93.3333,-15,-396.967>, <90,-15,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<115,-10,-396.967>, <114.167,-10.8333,-396.967>, <110.833,-14.1667,-396.967>, <110,-15,-396.967>,
<115,-10,-530.301>, <114.167,-10.8333,-530.301>, <110.833,-14.1667,-530.301>, <110,-15,-530.301>,
<115,-10,-1063.64>, <114.167,-10.8333,-1063.64>, <110.833,-14.1667,-1063.64>, <110,-15,-1063.64>,
<115,-10,-1196.97>, <114.167,-10.8333,-1196.97>, <110.833,-14.1667,-1196.97>, <110,-15,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<110,-15,-396.967>, <106.667,-15,-396.967>, <93.3333,-15,-396.967>, <90,-15,-396.967>,
<110,-15,-530.301>, <106.667,-15,-530.301>, <93.3333,-15,-530.301>, <90,-15,-530.301>,
<110,-15,-1063.64>, <106.667,-15,-1063.64>, <93.3333,-15,-1063.64>, <90,-15,-1063.64>,
<110,-15,-1196.97>, <106.667,-15,-1196.97>, <93.3333,-15,-1196.97>, <90,-15,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<90,15,-1196.97>, <93.3333,15,-1196.97>, <106.667,15,-1196.97>, <110,15,-1196.97>,
<90,10,-1196.97>, <93.3333,10,-1196.97>, <106.667,10,-1196.97>, <110,10,-1196.97>,
<90,-10,-1196.97>, <93.3333,-10,-1196.97>, <106.667,-10,-1196.97>, <110,-10,-1196.97>,
<90,-15,-1196.97>, <93.3333,-15,-1196.97>, <106.667,-15,-1196.97>, <110,-15,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<110,15,-1196.97>, <110.833,14.1667,-1196.97>, <114.167,10.8333,-1196.97>, <115,10,-1196.97>,
<110,10,-1196.97>, <110.833,9.72222,-1196.97>, <114.167,6.94444,-1196.97>, <115,6.66667,-1196.97>,
<110,-10,-1196.97>, <110.833,-9.72222,-1196.97>, <114.167,-6.94444,-1196.97>, <115,-6.66667,-1196.97>,
<110,-15,-1196.97>, <110.833,-14.1667,-1196.97>, <114.167,-10.8333,-1196.97>, <115,-10,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<90,15,-396.967>, <90,15,-530.301>, <90,15,-1063.64>, <90,15,-1196.97>,
<89.1667,14.1667,-396.967>, <89.1667,14.1667,-530.301>, <89.1667,14.1667,-1063.64>, <89.1667,14.1667,-1196.97>,
<85.8333,10.8333,-396.967>, <85.8333,10.8333,-530.301>, <85.8333,10.8333,-1063.64>, <85.8333,10.8333,-1196.97>,
<85,10,-396.967>, <85,10,-530.301>, <85,10,-1063.64>, <85,10,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<90,15,-396.967>, <89.1667,14.1667,-396.967>, <85.8333,10.8333,-396.967>, <85,10,-396.967>,
<90,10,-396.967>, <89.1667,9.72222,-396.967>, <85.8333,6.94444,-396.967>, <85,6.66667,-396.967>,
<90,-10,-396.967>, <89.1667,-9.72222,-396.967>, <85.8333,-6.94444,-396.967>, <85,-6.66667,-396.967>,
<90,-15,-396.967>, <89.1667,-14.1667,-396.967>, <85.8333,-10.8333,-396.967>, <85,-10,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<90,-15,-396.967>, <89.1667,-14.1667,-396.967>, <85.8333,-10.8333,-396.967>, <85,-10,-396.967>,
<90,-15,-530.301>, <89.1667,-14.1667,-530.301>, <85.8333,-10.8333,-530.301>, <85,-10,-530.301>,
<90,-15,-1063.64>, <89.1667,-14.1667,-1063.64>, <85.8333,-10.8333,-1063.64>, <85,-10,-1063.64>,
<90,-15,-1196.97>, <89.1667,-14.1667,-1196.97>, <85.8333,-10.8333,-1196.97>, <85,-10,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<85,10,-1196.97>, <85.8333,10.8333,-1196.97>, <89.1667,14.1667,-1196.97>, <90,15,-1196.97>,
<85,6.66667,-1196.97>, <85.8333,6.94444,-1196.97>, <89.1667,9.72222,-1196.97>, <90,10,-1196.97>,
<85,-6.66667,-1196.97>, <85.8333,-6.94444,-1196.97>, <89.1667,-9.72222,-1196.97>, <90,-10,-1196.97>,
<85,-10,-1196.97>, <85.8333,-10.8333,-1196.97>, <89.1667,-14.1667,-1196.97>, <90,-15,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<85,10,-396.967>, <85,10,-530.301>, <85,10,-1063.64>, <85,10,-1196.97>,
<85,6.66667,-396.967>, <85,6.66667,-530.301>, <85,6.66667,-1063.64>, <85,6.66667,-1196.97>,
<85,-6.66667,-396.967>, <85,-6.66667,-530.301>, <85,-6.66667,-1063.64>, <85,-6.66667,-1196.97>,
<85,-10,-396.967>, <85,-10,-530.301>, <85,-10,-1063.64>, <85,-10,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<115,10,-396.967>, <115,6.66667,-396.967>, <115,-6.66667,-396.967>, <115,-10,-396.967>,
<115,10,-530.301>, <115,6.66667,-530.301>, <115,-6.66667,-530.301>, <115,-10,-530.301>,
<115,10,-1063.64>, <115,6.66667,-1063.64>, <115,-6.66667,-1063.64>, <115,-10,-1063.64>,
<115,10,-1196.97>, <115,6.66667,-1196.97>, <115,-6.66667,-1196.97>, <115,-10,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-115,-10,-396.967>, <-115,-6.66667,-396.967>, <-115,6.66667,-396.967>, <-115,10,-396.967>,
<-115,-10,-530.301>, <-115,-6.66667,-530.301>, <-115,6.66667,-530.301>, <-115,10,-530.301>,
<-115,-10,-1063.64>, <-115,-6.66667,-1063.64>, <-115,6.66667,-1063.64>, <-115,10,-1063.64>,
<-115,-10,-1196.97>, <-115,-6.66667,-1196.97>, <-115,6.66667,-1196.97>, <-115,10,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-85,10,-396.967>, <-85,6.66667,-396.967>, <-85,-6.66667,-396.967>, <-85,-10,-396.967>,
<-85,10,-530.301>, <-85,6.66667,-530.301>, <-85,-6.66667,-530.301>, <-85,-10,-530.301>,
<-85,10,-1063.64>, <-85,6.66667,-1063.64>, <-85,-6.66667,-1063.64>, <-85,-10,-1063.64>,
<-85,10,-1196.97>, <-85,6.66667,-1196.97>, <-85,-6.66667,-1196.97>, <-85,-10,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,5,-1105.97>, <-54.3333,5,-1105.97>, <54.3333,5,-1105.97>, <81.5,5,-1105.97>,
<-81.5,3.33333,-1105.97>, <-54.3333,3.33333,-1105.97>, <54.3333,3.33333,-1105.97>, <81.5,3.33333,-1105.97>,
<-81.5,-3.33333,-1105.97>, <-54.3333,-3.33333,-1105.97>, <54.3333,-3.33333,-1105.97>, <81.5,-3.33333,-1105.97>,
<-81.5,-5,-1105.97>, <-54.3333,-5,-1105.97>, <54.3333,-5,-1105.97>, <81.5,-5,-1105.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,5,-1105.97>, <-81.5,3.33333,-1105.97>, <-81.5,-3.33333,-1105.97>, <-81.5,-5,-1105.97>,
<-81.5,5,-1120.97>, <-81.5,3.33333,-1120.97>, <-81.5,-3.33333,-1120.97>, <-81.5,-5,-1120.97>,
<-81.5,5,-1180.97>, <-81.5,3.33333,-1180.97>, <-81.5,-3.33333,-1180.97>, <-81.5,-5,-1180.97>,
<-81.5,5,-1195.97>, <-81.5,3.33333,-1195.97>, <-81.5,-3.33333,-1195.97>, <-81.5,-5,-1195.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,-5,-1195.97>, <-54.3333,-5,-1195.97>, <54.3333,-5,-1195.97>, <81.5,-5,-1195.97>,
<-81.5,-3.33333,-1195.97>, <-54.3333,-3.33333,-1195.97>, <54.3333,-3.33333,-1195.97>, <81.5,-3.33333,-1195.97>,
<-81.5,3.33333,-1195.97>, <-54.3333,3.33333,-1195.97>, <54.3333,3.33333,-1195.97>, <81.5,3.33333,-1195.97>,
<-81.5,5,-1195.97>, <-54.3333,5,-1195.97>, <54.3333,5,-1195.97>, <81.5,5,-1195.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<81.5,-5,-1195.97>, <81.5,-5,-1180.97>, <81.5,-5,-1120.97>, <81.5,-5,-1105.97>,
<81.5,-3.33333,-1195.97>, <81.5,-3.33333,-1180.97>, <81.5,-3.33333,-1120.97>, <81.5,-3.33333,-1105.97>,
<81.5,3.33333,-1195.97>, <81.5,3.33333,-1180.97>, <81.5,3.33333,-1120.97>, <81.5,3.33333,-1105.97>,
<81.5,5,-1195.97>, <81.5,5,-1180.97>, <81.5,5,-1120.97>, <81.5,5,-1105.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,-5,-397.967>, <-54.3333,-5,-397.967>, <54.3333,-5,-397.967>, <81.5,-5,-397.967>,
<-81.5,-3.33333,-397.967>, <-54.3333,-3.33333,-397.967>, <54.3333,-3.33333,-397.967>, <81.5,-3.33333,-397.967>,
<-81.5,3.33333,-397.967>, <-54.3333,3.33333,-397.967>, <54.3333,3.33333,-397.967>, <81.5,3.33333,-397.967>,
<-81.5,5,-397.967>, <-54.3333,5,-397.967>, <54.3333,5,-397.967>, <81.5,5,-397.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,-5,-397.967>, <-81.5,-3.33333,-397.967>, <-81.5,3.33333,-397.967>, <-81.5,5,-397.967>,
<-81.5,-5,-412.967>, <-81.5,-3.33333,-412.967>, <-81.5,3.33333,-412.967>, <-81.5,5,-412.967>,
<-81.5,-5,-472.967>, <-81.5,-3.33333,-472.967>, <-81.5,3.33333,-472.967>, <-81.5,5,-472.967>,
<-81.5,-5,-487.967>, <-81.5,-3.33333,-487.967>, <-81.5,3.33333,-487.967>, <-81.5,5,-487.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,-5,-487.967>, <-81.5,-3.33333,-487.967>, <-81.5,3.33333,-487.967>, <-81.5,5,-487.967>,
<-54.3333,-5,-487.967>, <-54.3333,-3.33333,-487.967>, <-54.3333,3.33333,-487.967>, <-54.3333,5,-487.967>,
<54.3333,-5,-487.967>, <54.3333,-3.33333,-487.967>, <54.3333,3.33333,-487.967>, <54.3333,5,-487.967>,
<81.5,-5,-487.967>, <81.5,-3.33333,-487.967>, <81.5,3.33333,-487.967>, <81.5,5,-487.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<81.5,-5,-487.967>, <81.5,-3.33333,-487.967>, <81.5,3.33333,-487.967>, <81.5,5,-487.967>,
<81.5,-5,-472.967>, <81.5,-3.33333,-472.967>, <81.5,3.33333,-472.967>, <81.5,5,-472.967>,
<81.5,-5,-412.967>, <81.5,-3.33333,-412.967>, <81.5,3.33333,-412.967>, <81.5,5,-412.967>,
<81.5,-5,-397.967>, <81.5,-3.33333,-397.967>, <81.5,3.33333,-397.967>, <81.5,5,-397.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-28,-4,-486.967>, <-28.3333,-3.66667,-486.967>, <-29.6667,-2.33333,-486.967>, <-30,-2,-486.967>,
<-28,-4,-590.301>, <-28.3333,-3.66667,-590.301>, <-29.6667,-2.33333,-590.301>, <-30,-2,-590.301>,
<-28,-4,-1003.64>, <-28.3333,-3.66667,-1003.64>, <-29.6667,-2.33333,-1003.64>, <-30,-2,-1003.64>,
<-28,-4,-1106.97>, <-28.3333,-3.66667,-1106.97>, <-29.6667,-2.33333,-1106.97>, <-30,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-30,2,-486.967>, <-30,2,-590.301>, <-30,2,-1003.64>, <-30,2,-1106.97>,
<-30,1.33333,-486.967>, <-30,1.33333,-590.301>, <-30,1.33333,-1003.64>, <-30,1.33333,-1106.97>,
<-30,-1.33333,-486.967>, <-30,-1.33333,-590.301>, <-30,-1.33333,-1003.64>, <-30,-1.33333,-1106.97>,
<-30,-2,-486.967>, <-30,-2,-590.301>, <-30,-2,-1003.64>, <-30,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-20,-4,-486.967>, <-21.3333,-4,-486.967>, <-26.6667,-4,-486.967>, <-28,-4,-486.967>,
<-20,-4,-590.301>, <-21.3333,-4,-590.301>, <-26.6667,-4,-590.301>, <-28,-4,-590.301>,
<-20,-4,-1003.64>, <-21.3333,-4,-1003.64>, <-26.6667,-4,-1003.64>, <-28,-4,-1003.64>,
<-20,-4,-1106.97>, <-21.3333,-4,-1106.97>, <-26.6667,-4,-1106.97>, <-28,-4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-18,-2,-486.967>, <-18.3333,-2.33333,-486.967>, <-19.6667,-3.66667,-486.967>, <-20,-4,-486.967>,
<-18,-2,-590.301>, <-18.3333,-2.33333,-590.301>, <-19.6667,-3.66667,-590.301>, <-20,-4,-590.301>,
<-18,-2,-1003.64>, <-18.3333,-2.33333,-1003.64>, <-19.6667,-3.66667,-1003.64>, <-20,-4,-1003.64>,
<-18,-2,-1106.97>, <-18.3333,-2.33333,-1106.97>, <-19.6667,-3.66667,-1106.97>, <-20,-4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-18,2,-486.967>, <-18,1.33333,-486.967>, <-18,-1.33333,-486.967>, <-18,-2,-486.967>,
<-18,2,-590.301>, <-18,1.33333,-590.301>, <-18,-1.33333,-590.301>, <-18,-2,-590.301>,
<-18,2,-1003.64>, <-18,1.33333,-1003.64>, <-18,-1.33333,-1003.64>, <-18,-2,-1003.64>,
<-18,2,-1106.97>, <-18,1.33333,-1106.97>, <-18,-1.33333,-1106.97>, <-18,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-20,4,-486.967>, <-19.6667,3.66667,-486.967>, <-18.3333,2.33333,-486.967>, <-18,2,-486.967>,
<-20,4,-590.301>, <-19.6667,3.66667,-590.301>, <-18.3333,2.33333,-590.301>, <-18,2,-590.301>,
<-20,4,-1003.64>, <-19.6667,3.66667,-1003.64>, <-18.3333,2.33333,-1003.64>, <-18,2,-1003.64>,
<-20,4,-1106.97>, <-19.6667,3.66667,-1106.97>, <-18.3333,2.33333,-1106.97>, <-18,2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-28,4,-486.967>, <-26.6667,4,-486.967>, <-21.3333,4,-486.967>, <-20,4,-486.967>,
<-28,4,-590.301>, <-26.6667,4,-590.301>, <-21.3333,4,-590.301>, <-20,4,-590.301>,
<-28,4,-1003.64>, <-26.6667,4,-1003.64>, <-21.3333,4,-1003.64>, <-20,4,-1003.64>,
<-28,4,-1106.97>, <-26.6667,4,-1106.97>, <-21.3333,4,-1106.97>, <-20,4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-30,2,-486.967>, <-29.6667,2.33333,-486.967>, <-28.3333,3.66667,-486.967>, <-28,4,-486.967>,
<-30,2,-590.301>, <-29.6667,2.33333,-590.301>, <-28.3333,3.66667,-590.301>, <-28,4,-590.301>,
<-30,2,-1003.64>, <-29.6667,2.33333,-1003.64>, <-28.3333,3.66667,-1003.64>, <-28,4,-1003.64>,
<-30,2,-1106.97>, <-29.6667,2.33333,-1106.97>, <-28.3333,3.66667,-1106.97>, <-28,4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-60,-4,-486.967>, <-60.3333,-3.66667,-486.967>, <-61.6667,-2.33333,-486.967>, <-62,-2,-486.967>,
<-60,-4,-590.301>, <-60.3333,-3.66667,-590.301>, <-61.6667,-2.33333,-590.301>, <-62,-2,-590.301>,
<-60,-4,-1003.64>, <-60.3333,-3.66667,-1003.64>, <-61.6667,-2.33333,-1003.64>, <-62,-2,-1003.64>,
<-60,-4,-1106.97>, <-60.3333,-3.66667,-1106.97>, <-61.6667,-2.33333,-1106.97>, <-62,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-62,2,-486.967>, <-62,2,-590.301>, <-62,2,-1003.64>, <-62,2,-1106.97>,
<-62,1.33333,-486.967>, <-62,1.33333,-590.301>, <-62,1.33333,-1003.64>, <-62,1.33333,-1106.97>,
<-62,-1.33333,-486.967>, <-62,-1.33333,-590.301>, <-62,-1.33333,-1003.64>, <-62,-1.33333,-1106.97>,
<-62,-2,-486.967>, <-62,-2,-590.301>, <-62,-2,-1003.64>, <-62,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-52,-4,-486.967>, <-53.3333,-4,-486.967>, <-58.6667,-4,-486.967>, <-60,-4,-486.967>,
<-52,-4,-590.301>, <-53.3333,-4,-590.301>, <-58.6667,-4,-590.301>, <-60,-4,-590.301>,
<-52,-4,-1003.64>, <-53.3333,-4,-1003.64>, <-58.6667,-4,-1003.64>, <-60,-4,-1003.64>,
<-52,-4,-1106.97>, <-53.3333,-4,-1106.97>, <-58.6667,-4,-1106.97>, <-60,-4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-50,-2,-486.967>, <-50.3333,-2.33333,-486.967>, <-51.6667,-3.66667,-486.967>, <-52,-4,-486.967>,
<-50,-2,-590.301>, <-50.3333,-2.33333,-590.301>, <-51.6667,-3.66667,-590.301>, <-52,-4,-590.301>,
<-50,-2,-1003.64>, <-50.3333,-2.33333,-1003.64>, <-51.6667,-3.66667,-1003.64>, <-52,-4,-1003.64>,
<-50,-2,-1106.97>, <-50.3333,-2.33333,-1106.97>, <-51.6667,-3.66667,-1106.97>, <-52,-4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-50,2,-486.967>, <-50,1.33333,-486.967>, <-50,-1.33333,-486.967>, <-50,-2,-486.967>,
<-50,2,-590.301>, <-50,1.33333,-590.301>, <-50,-1.33333,-590.301>, <-50,-2,-590.301>,
<-50,2,-1003.64>, <-50,1.33333,-1003.64>, <-50,-1.33333,-1003.64>, <-50,-2,-1003.64>,
<-50,2,-1106.97>, <-50,1.33333,-1106.97>, <-50,-1.33333,-1106.97>, <-50,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-52,4,-486.967>, <-51.6667,3.66667,-486.967>, <-50.3333,2.33333,-486.967>, <-50,2,-486.967>,
<-52,4,-590.301>, <-51.6667,3.66667,-590.301>, <-50.3333,2.33333,-590.301>, <-50,2,-590.301>,
<-52,4,-1003.64>, <-51.6667,3.66667,-1003.64>, <-50.3333,2.33333,-1003.64>, <-50,2,-1003.64>,
<-52,4,-1106.97>, <-51.6667,3.66667,-1106.97>, <-50.3333,2.33333,-1106.97>, <-50,2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-60,4,-486.967>, <-58.6667,4,-486.967>, <-53.3333,4,-486.967>, <-52,4,-486.967>,
<-60,4,-590.301>, <-58.6667,4,-590.301>, <-53.3333,4,-590.301>, <-52,4,-590.301>,
<-60,4,-1003.64>, <-58.6667,4,-1003.64>, <-53.3333,4,-1003.64>, <-52,4,-1003.64>,
<-60,4,-1106.97>, <-58.6667,4,-1106.97>, <-53.3333,4,-1106.97>, <-52,4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-62,2,-486.967>, <-61.6667,2.33333,-486.967>, <-60.3333,3.66667,-486.967>, <-60,4,-486.967>,
<-62,2,-590.301>, <-61.6667,2.33333,-590.301>, <-60.3333,3.66667,-590.301>, <-60,4,-590.301>,
<-62,2,-1003.64>, <-61.6667,2.33333,-1003.64>, <-60.3333,3.66667,-1003.64>, <-60,4,-1003.64>,
<-62,2,-1106.97>, <-61.6667,2.33333,-1106.97>, <-60.3333,3.66667,-1106.97>, <-60,4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-12,-4,-486.967>, <-12.3333,-3.66667,-486.967>, <-13.6667,-2.33333,-486.967>, <-14,-2,-486.967>,
<-12,-4,-590.301>, <-12.3333,-3.66667,-590.301>, <-13.6667,-2.33333,-590.301>, <-14,-2,-590.301>,
<-12,-4,-1003.64>, <-12.3333,-3.66667,-1003.64>, <-13.6667,-2.33333,-1003.64>, <-14,-2,-1003.64>,
<-12,-4,-1106.97>, <-12.3333,-3.66667,-1106.97>, <-13.6667,-2.33333,-1106.97>, <-14,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-14,2,-486.967>, <-14,2,-590.301>, <-14,2,-1003.64>, <-14,2,-1106.97>,
<-14,1.33333,-486.967>, <-14,1.33333,-590.301>, <-14,1.33333,-1003.64>, <-14,1.33333,-1106.97>,
<-14,-1.33333,-486.967>, <-14,-1.33333,-590.301>, <-14,-1.33333,-1003.64>, <-14,-1.33333,-1106.97>,
<-14,-2,-486.967>, <-14,-2,-590.301>, <-14,-2,-1003.64>, <-14,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-4,-4,-486.967>, <-5.33333,-4,-486.967>, <-10.6667,-4,-486.967>, <-12,-4,-486.967>,
<-4,-4,-590.301>, <-5.33333,-4,-590.301>, <-10.6667,-4,-590.301>, <-12,-4,-590.301>,
<-4,-4,-1003.64>, <-5.33333,-4,-1003.64>, <-10.6667,-4,-1003.64>, <-12,-4,-1003.64>,
<-4,-4,-1106.97>, <-5.33333,-4,-1106.97>, <-10.6667,-4,-1106.97>, <-12,-4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-2,-2,-486.967>, <-2.33333,-2.33333,-486.967>, <-3.66667,-3.66667,-486.967>, <-4,-4,-486.967>,
<-2,-2,-590.301>, <-2.33333,-2.33333,-590.301>, <-3.66667,-3.66667,-590.301>, <-4,-4,-590.301>,
<-2,-2,-1003.64>, <-2.33333,-2.33333,-1003.64>, <-3.66667,-3.66667,-1003.64>, <-4,-4,-1003.64>,
<-2,-2,-1106.97>, <-2.33333,-2.33333,-1106.97>, <-3.66667,-3.66667,-1106.97>, <-4,-4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-2,2,-486.967>, <-2,1.33333,-486.967>, <-2,-1.33333,-486.967>, <-2,-2,-486.967>,
<-2,2,-590.301>, <-2,1.33333,-590.301>, <-2,-1.33333,-590.301>, <-2,-2,-590.301>,
<-2,2,-1003.64>, <-2,1.33333,-1003.64>, <-2,-1.33333,-1003.64>, <-2,-2,-1003.64>,
<-2,2,-1106.97>, <-2,1.33333,-1106.97>, <-2,-1.33333,-1106.97>, <-2,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-4,4,-486.967>, <-3.66667,3.66667,-486.967>, <-2.33333,2.33333,-486.967>, <-2,2,-486.967>,
<-4,4,-590.301>, <-3.66667,3.66667,-590.301>, <-2.33333,2.33333,-590.301>, <-2,2,-590.301>,
<-4,4,-1003.64>, <-3.66667,3.66667,-1003.64>, <-2.33333,2.33333,-1003.64>, <-2,2,-1003.64>,
<-4,4,-1106.97>, <-3.66667,3.66667,-1106.97>, <-2.33333,2.33333,-1106.97>, <-2,2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-12,4,-486.967>, <-10.6667,4,-486.967>, <-5.33333,4,-486.967>, <-4,4,-486.967>,
<-12,4,-590.301>, <-10.6667,4,-590.301>, <-5.33333,4,-590.301>, <-4,4,-590.301>,
<-12,4,-1003.64>, <-10.6667,4,-1003.64>, <-5.33333,4,-1003.64>, <-4,4,-1003.64>,
<-12,4,-1106.97>, <-10.6667,4,-1106.97>, <-5.33333,4,-1106.97>, <-4,4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-14,2,-486.967>, <-13.6667,2.33333,-486.967>, <-12.3333,3.66667,-486.967>, <-12,4,-486.967>,
<-14,2,-590.301>, <-13.6667,2.33333,-590.301>, <-12.3333,3.66667,-590.301>, <-12,4,-590.301>,
<-14,2,-1003.64>, <-13.6667,2.33333,-1003.64>, <-12.3333,3.66667,-1003.64>, <-12,4,-1003.64>,
<-14,2,-1106.97>, <-13.6667,2.33333,-1106.97>, <-12.3333,3.66667,-1106.97>, <-12,4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-76,-4,-486.967>, <-76.3333,-3.66667,-486.967>, <-77.6667,-2.33333,-486.967>, <-78,-2,-486.967>,
<-76,-4,-590.301>, <-76.3333,-3.66667,-590.301>, <-77.6667,-2.33333,-590.301>, <-78,-2,-590.301>,
<-76,-4,-1003.64>, <-76.3333,-3.66667,-1003.64>, <-77.6667,-2.33333,-1003.64>, <-78,-2,-1003.64>,
<-76,-4,-1106.97>, <-76.3333,-3.66667,-1106.97>, <-77.6667,-2.33333,-1106.97>, <-78,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-78,2,-486.967>, <-78,2,-590.301>, <-78,2,-1003.64>, <-78,2,-1106.97>,
<-78,1.33333,-486.967>, <-78,1.33333,-590.301>, <-78,1.33333,-1003.64>, <-78,1.33333,-1106.97>,
<-78,-1.33333,-486.967>, <-78,-1.33333,-590.301>, <-78,-1.33333,-1003.64>, <-78,-1.33333,-1106.97>,
<-78,-2,-486.967>, <-78,-2,-590.301>, <-78,-2,-1003.64>, <-78,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-68,-4,-486.967>, <-69.3333,-4,-486.967>, <-74.6667,-4,-486.967>, <-76,-4,-486.967>,
<-68,-4,-590.301>, <-69.3333,-4,-590.301>, <-74.6667,-4,-590.301>, <-76,-4,-590.301>,
<-68,-4,-1003.64>, <-69.3333,-4,-1003.64>, <-74.6667,-4,-1003.64>, <-76,-4,-1003.64>,
<-68,-4,-1106.97>, <-69.3333,-4,-1106.97>, <-74.6667,-4,-1106.97>, <-76,-4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-66,-2,-486.967>, <-66.3333,-2.33333,-486.967>, <-67.6667,-3.66667,-486.967>, <-68,-4,-486.967>,
<-66,-2,-590.301>, <-66.3333,-2.33333,-590.301>, <-67.6667,-3.66667,-590.301>, <-68,-4,-590.301>,
<-66,-2,-1003.64>, <-66.3333,-2.33333,-1003.64>, <-67.6667,-3.66667,-1003.64>, <-68,-4,-1003.64>,
<-66,-2,-1106.97>, <-66.3333,-2.33333,-1106.97>, <-67.6667,-3.66667,-1106.97>, <-68,-4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-66,2,-486.967>, <-66,1.33333,-486.967>, <-66,-1.33333,-486.967>, <-66,-2,-486.967>,
<-66,2,-590.301>, <-66,1.33333,-590.301>, <-66,-1.33333,-590.301>, <-66,-2,-590.301>,
<-66,2,-1003.64>, <-66,1.33333,-1003.64>, <-66,-1.33333,-1003.64>, <-66,-2,-1003.64>,
<-66,2,-1106.97>, <-66,1.33333,-1106.97>, <-66,-1.33333,-1106.97>, <-66,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-68,4,-486.967>, <-67.6667,3.66667,-486.967>, <-66.3333,2.33333,-486.967>, <-66,2,-486.967>,
<-68,4,-590.301>, <-67.6667,3.66667,-590.301>, <-66.3333,2.33333,-590.301>, <-66,2,-590.301>,
<-68,4,-1003.64>, <-67.6667,3.66667,-1003.64>, <-66.3333,2.33333,-1003.64>, <-66,2,-1003.64>,
<-68,4,-1106.97>, <-67.6667,3.66667,-1106.97>, <-66.3333,2.33333,-1106.97>, <-66,2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-76,4,-486.967>, <-74.6667,4,-486.967>, <-69.3333,4,-486.967>, <-68,4,-486.967>,
<-76,4,-590.301>, <-74.6667,4,-590.301>, <-69.3333,4,-590.301>, <-68,4,-590.301>,
<-76,4,-1003.64>, <-74.6667,4,-1003.64>, <-69.3333,4,-1003.64>, <-68,4,-1003.64>,
<-76,4,-1106.97>, <-74.6667,4,-1106.97>, <-69.3333,4,-1106.97>, <-68,4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-78,2,-486.967>, <-77.6667,2.33333,-486.967>, <-76.3333,3.66667,-486.967>, <-76,4,-486.967>,
<-78,2,-590.301>, <-77.6667,2.33333,-590.301>, <-76.3333,3.66667,-590.301>, <-76,4,-590.301>,
<-78,2,-1003.64>, <-77.6667,2.33333,-1003.64>, <-76.3333,3.66667,-1003.64>, <-76,4,-1003.64>,
<-78,2,-1106.97>, <-77.6667,2.33333,-1106.97>, <-76.3333,3.66667,-1106.97>, <-76,4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-44,-4,-486.967>, <-44.3333,-3.66667,-486.967>, <-45.6667,-2.33333,-486.967>, <-46,-2,-486.967>,
<-44,-4,-590.301>, <-44.3333,-3.66667,-590.301>, <-45.6667,-2.33333,-590.301>, <-46,-2,-590.301>,
<-44,-4,-1003.64>, <-44.3333,-3.66667,-1003.64>, <-45.6667,-2.33333,-1003.64>, <-46,-2,-1003.64>,
<-44,-4,-1106.97>, <-44.3333,-3.66667,-1106.97>, <-45.6667,-2.33333,-1106.97>, <-46,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-46,2,-486.967>, <-46,2,-590.301>, <-46,2,-1003.64>, <-46,2,-1106.97>,
<-46,1.33333,-486.967>, <-46,1.33333,-590.301>, <-46,1.33333,-1003.64>, <-46,1.33333,-1106.97>,
<-46,-1.33333,-486.967>, <-46,-1.33333,-590.301>, <-46,-1.33333,-1003.64>, <-46,-1.33333,-1106.97>,
<-46,-2,-486.967>, <-46,-2,-590.301>, <-46,-2,-1003.64>, <-46,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-36,-4,-486.967>, <-37.3333,-4,-486.967>, <-42.6667,-4,-486.967>, <-44,-4,-486.967>,
<-36,-4,-590.301>, <-37.3333,-4,-590.301>, <-42.6667,-4,-590.301>, <-44,-4,-590.301>,
<-36,-4,-1003.64>, <-37.3333,-4,-1003.64>, <-42.6667,-4,-1003.64>, <-44,-4,-1003.64>,
<-36,-4,-1106.97>, <-37.3333,-4,-1106.97>, <-42.6667,-4,-1106.97>, <-44,-4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-34,-2,-486.967>, <-34.3333,-2.33333,-486.967>, <-35.6667,-3.66667,-486.967>, <-36,-4,-486.967>,
<-34,-2,-590.301>, <-34.3333,-2.33333,-590.301>, <-35.6667,-3.66667,-590.301>, <-36,-4,-590.301>,
<-34,-2,-1003.64>, <-34.3333,-2.33333,-1003.64>, <-35.6667,-3.66667,-1003.64>, <-36,-4,-1003.64>,
<-34,-2,-1106.97>, <-34.3333,-2.33333,-1106.97>, <-35.6667,-3.66667,-1106.97>, <-36,-4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-34,2,-486.967>, <-34,1.33333,-486.967>, <-34,-1.33333,-486.967>, <-34,-2,-486.967>,
<-34,2,-590.301>, <-34,1.33333,-590.301>, <-34,-1.33333,-590.301>, <-34,-2,-590.301>,
<-34,2,-1003.64>, <-34,1.33333,-1003.64>, <-34,-1.33333,-1003.64>, <-34,-2,-1003.64>,
<-34,2,-1106.97>, <-34,1.33333,-1106.97>, <-34,-1.33333,-1106.97>, <-34,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-36,4,-486.967>, <-35.6667,3.66667,-486.967>, <-34.3333,2.33333,-486.967>, <-34,2,-486.967>,
<-36,4,-590.301>, <-35.6667,3.66667,-590.301>, <-34.3333,2.33333,-590.301>, <-34,2,-590.301>,
<-36,4,-1003.64>, <-35.6667,3.66667,-1003.64>, <-34.3333,2.33333,-1003.64>, <-34,2,-1003.64>,
<-36,4,-1106.97>, <-35.6667,3.66667,-1106.97>, <-34.3333,2.33333,-1106.97>, <-34,2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-44,4,-486.967>, <-42.6667,4,-486.967>, <-37.3333,4,-486.967>, <-36,4,-486.967>,
<-44,4,-590.301>, <-42.6667,4,-590.301>, <-37.3333,4,-590.301>, <-36,4,-590.301>,
<-44,4,-1003.64>, <-42.6667,4,-1003.64>, <-37.3333,4,-1003.64>, <-36,4,-1003.64>,
<-44,4,-1106.97>, <-42.6667,4,-1106.97>, <-37.3333,4,-1106.97>, <-36,4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-46,2,-486.967>, <-45.6667,2.33333,-486.967>, <-44.3333,3.66667,-486.967>, <-44,4,-486.967>,
<-46,2,-590.301>, <-45.6667,2.33333,-590.301>, <-44.3333,3.66667,-590.301>, <-44,4,-590.301>,
<-46,2,-1003.64>, <-45.6667,2.33333,-1003.64>, <-44.3333,3.66667,-1003.64>, <-44,4,-1003.64>,
<-46,2,-1106.97>, <-45.6667,2.33333,-1106.97>, <-44.3333,3.66667,-1106.97>, <-44,4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<36,-4,-486.967>, <36,-4,-590.301>, <36,-4,-1003.64>, <36,-4,-1106.97>,
<35.6667,-3.66667,-486.967>, <35.6667,-3.66667,-590.301>, <35.6667,-3.66667,-1003.64>, <35.6667,-3.66667,-1106.97>,
<34.3333,-2.33333,-486.967>, <34.3333,-2.33333,-590.301>, <34.3333,-2.33333,-1003.64>, <34.3333,-2.33333,-1106.97>,
<34,-2,-486.967>, <34,-2,-590.301>, <34,-2,-1003.64>, <34,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<34,2,-486.967>, <34,1.33333,-486.967>, <34,-1.33333,-486.967>, <34,-2,-486.967>,
<34,2,-590.301>, <34,1.33333,-590.301>, <34,-1.33333,-590.301>, <34,-2,-590.301>,
<34,2,-1003.64>, <34,1.33333,-1003.64>, <34,-1.33333,-1003.64>, <34,-2,-1003.64>,
<34,2,-1106.97>, <34,1.33333,-1106.97>, <34,-1.33333,-1106.97>, <34,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<44,-4,-486.967>, <44,-4,-590.301>, <44,-4,-1003.64>, <44,-4,-1106.97>,
<42.6667,-4,-486.967>, <42.6667,-4,-590.301>, <42.6667,-4,-1003.64>, <42.6667,-4,-1106.97>,
<37.3333,-4,-486.967>, <37.3333,-4,-590.301>, <37.3333,-4,-1003.64>, <37.3333,-4,-1106.97>,
<36,-4,-486.967>, <36,-4,-590.301>, <36,-4,-1003.64>, <36,-4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<46,-2,-486.967>, <46,-2,-590.301>, <46,-2,-1003.64>, <46,-2,-1106.97>,
<45.6667,-2.33333,-486.967>, <45.6667,-2.33333,-590.301>, <45.6667,-2.33333,-1003.64>, <45.6667,-2.33333,-1106.97>,
<44.3333,-3.66667,-486.967>, <44.3333,-3.66667,-590.301>, <44.3333,-3.66667,-1003.64>, <44.3333,-3.66667,-1106.97>,
<44,-4,-486.967>, <44,-4,-590.301>, <44,-4,-1003.64>, <44,-4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<46,2,-486.967>, <46,2,-590.301>, <46,2,-1003.64>, <46,2,-1106.97>,
<46,1.33333,-486.967>, <46,1.33333,-590.301>, <46,1.33333,-1003.64>, <46,1.33333,-1106.97>,
<46,-1.33333,-486.967>, <46,-1.33333,-590.301>, <46,-1.33333,-1003.64>, <46,-1.33333,-1106.97>,
<46,-2,-486.967>, <46,-2,-590.301>, <46,-2,-1003.64>, <46,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<44,4,-486.967>, <44,4,-590.301>, <44,4,-1003.64>, <44,4,-1106.97>,
<44.3333,3.66667,-486.967>, <44.3333,3.66667,-590.301>, <44.3333,3.66667,-1003.64>, <44.3333,3.66667,-1106.97>,
<45.6667,2.33333,-486.967>, <45.6667,2.33333,-590.301>, <45.6667,2.33333,-1003.64>, <45.6667,2.33333,-1106.97>,
<46,2,-486.967>, <46,2,-590.301>, <46,2,-1003.64>, <46,2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<36,4,-486.967>, <36,4,-590.301>, <36,4,-1003.64>, <36,4,-1106.97>,
<37.3333,4,-486.967>, <37.3333,4,-590.301>, <37.3333,4,-1003.64>, <37.3333,4,-1106.97>,
<42.6667,4,-486.967>, <42.6667,4,-590.301>, <42.6667,4,-1003.64>, <42.6667,4,-1106.97>,
<44,4,-486.967>, <44,4,-590.301>, <44,4,-1003.64>, <44,4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<34,2,-486.967>, <34,2,-590.301>, <34,2,-1003.64>, <34,2,-1106.97>,
<34.3333,2.33333,-486.967>, <34.3333,2.33333,-590.301>, <34.3333,2.33333,-1003.64>, <34.3333,2.33333,-1106.97>,
<35.6667,3.66667,-486.967>, <35.6667,3.66667,-590.301>, <35.6667,3.66667,-1003.64>, <35.6667,3.66667,-1106.97>,
<36,4,-486.967>, <36,4,-590.301>, <36,4,-1003.64>, <36,4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<4,-4,-486.967>, <3.66667,-3.66667,-486.967>, <2.33333,-2.33333,-486.967>, <2,-2,-486.967>,
<4,-4,-590.301>, <3.66667,-3.66667,-590.301>, <2.33333,-2.33333,-590.301>, <2,-2,-590.301>,
<4,-4,-1003.64>, <3.66667,-3.66667,-1003.64>, <2.33333,-2.33333,-1003.64>, <2,-2,-1003.64>,
<4,-4,-1106.97>, <3.66667,-3.66667,-1106.97>, <2.33333,-2.33333,-1106.97>, <2,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<2,2,-486.967>, <2,2,-590.301>, <2,2,-1003.64>, <2,2,-1106.97>,
<2,1.33333,-486.967>, <2,1.33333,-590.301>, <2,1.33333,-1003.64>, <2,1.33333,-1106.97>,
<2,-1.33333,-486.967>, <2,-1.33333,-590.301>, <2,-1.33333,-1003.64>, <2,-1.33333,-1106.97>,
<2,-2,-486.967>, <2,-2,-590.301>, <2,-2,-1003.64>, <2,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<12,-4,-486.967>, <10.6667,-4,-486.967>, <5.33333,-4,-486.967>, <4,-4,-486.967>,
<12,-4,-590.301>, <10.6667,-4,-590.301>, <5.33333,-4,-590.301>, <4,-4,-590.301>,
<12,-4,-1003.64>, <10.6667,-4,-1003.64>, <5.33333,-4,-1003.64>, <4,-4,-1003.64>,
<12,-4,-1106.97>, <10.6667,-4,-1106.97>, <5.33333,-4,-1106.97>, <4,-4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<14,-2,-486.967>, <13.6667,-2.33333,-486.967>, <12.3333,-3.66667,-486.967>, <12,-4,-486.967>,
<14,-2,-590.301>, <13.6667,-2.33333,-590.301>, <12.3333,-3.66667,-590.301>, <12,-4,-590.301>,
<14,-2,-1003.64>, <13.6667,-2.33333,-1003.64>, <12.3333,-3.66667,-1003.64>, <12,-4,-1003.64>,
<14,-2,-1106.97>, <13.6667,-2.33333,-1106.97>, <12.3333,-3.66667,-1106.97>, <12,-4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<14,2,-486.967>, <14,1.33333,-486.967>, <14,-1.33333,-486.967>, <14,-2,-486.967>,
<14,2,-590.301>, <14,1.33333,-590.301>, <14,-1.33333,-590.301>, <14,-2,-590.301>,
<14,2,-1003.64>, <14,1.33333,-1003.64>, <14,-1.33333,-1003.64>, <14,-2,-1003.64>,
<14,2,-1106.97>, <14,1.33333,-1106.97>, <14,-1.33333,-1106.97>, <14,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<12,4,-486.967>, <12.3333,3.66667,-486.967>, <13.6667,2.33333,-486.967>, <14,2,-486.967>,
<12,4,-590.301>, <12.3333,3.66667,-590.301>, <13.6667,2.33333,-590.301>, <14,2,-590.301>,
<12,4,-1003.64>, <12.3333,3.66667,-1003.64>, <13.6667,2.33333,-1003.64>, <14,2,-1003.64>,
<12,4,-1106.97>, <12.3333,3.66667,-1106.97>, <13.6667,2.33333,-1106.97>, <14,2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<4,4,-486.967>, <5.33333,4,-486.967>, <10.6667,4,-486.967>, <12,4,-486.967>,
<4,4,-590.301>, <5.33333,4,-590.301>, <10.6667,4,-590.301>, <12,4,-590.301>,
<4,4,-1003.64>, <5.33333,4,-1003.64>, <10.6667,4,-1003.64>, <12,4,-1003.64>,
<4,4,-1106.97>, <5.33333,4,-1106.97>, <10.6667,4,-1106.97>, <12,4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<2,2,-486.967>, <2.33333,2.33333,-486.967>, <3.66667,3.66667,-486.967>, <4,4,-486.967>,
<2,2,-590.301>, <2.33333,2.33333,-590.301>, <3.66667,3.66667,-590.301>, <4,4,-590.301>,
<2,2,-1003.64>, <2.33333,2.33333,-1003.64>, <3.66667,3.66667,-1003.64>, <4,4,-1003.64>,
<2,2,-1106.97>, <2.33333,2.33333,-1106.97>, <3.66667,3.66667,-1106.97>, <4,4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<68,-4,-486.967>, <68,-4,-590.301>, <68,-4,-1003.64>, <68,-4,-1106.97>,
<67.6667,-3.66667,-486.967>, <67.6667,-3.66667,-590.301>, <67.6667,-3.66667,-1003.64>, <67.6667,-3.66667,-1106.97>,
<66.3333,-2.33333,-486.967>, <66.3333,-2.33333,-590.301>, <66.3333,-2.33333,-1003.64>, <66.3333,-2.33333,-1106.97>,
<66,-2,-486.967>, <66,-2,-590.301>, <66,-2,-1003.64>, <66,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<66,2,-486.967>, <66,1.33333,-486.967>, <66,-1.33333,-486.967>, <66,-2,-486.967>,
<66,2,-590.301>, <66,1.33333,-590.301>, <66,-1.33333,-590.301>, <66,-2,-590.301>,
<66,2,-1003.64>, <66,1.33333,-1003.64>, <66,-1.33333,-1003.64>, <66,-2,-1003.64>,
<66,2,-1106.97>, <66,1.33333,-1106.97>, <66,-1.33333,-1106.97>, <66,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<76,-4,-486.967>, <76,-4,-590.301>, <76,-4,-1003.64>, <76,-4,-1106.97>,
<74.6667,-4,-486.967>, <74.6667,-4,-590.301>, <74.6667,-4,-1003.64>, <74.6667,-4,-1106.97>,
<69.3333,-4,-486.967>, <69.3333,-4,-590.301>, <69.3333,-4,-1003.64>, <69.3333,-4,-1106.97>,
<68,-4,-486.967>, <68,-4,-590.301>, <68,-4,-1003.64>, <68,-4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<78,-2,-486.967>, <78,-2,-590.301>, <78,-2,-1003.64>, <78,-2,-1106.97>,
<77.6667,-2.33333,-486.967>, <77.6667,-2.33333,-590.301>, <77.6667,-2.33333,-1003.64>, <77.6667,-2.33333,-1106.97>,
<76.3333,-3.66667,-486.967>, <76.3333,-3.66667,-590.301>, <76.3333,-3.66667,-1003.64>, <76.3333,-3.66667,-1106.97>,
<76,-4,-486.967>, <76,-4,-590.301>, <76,-4,-1003.64>, <76,-4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<78,2,-486.967>, <78,2,-590.301>, <78,2,-1003.64>, <78,2,-1106.97>,
<78,1.33333,-486.967>, <78,1.33333,-590.301>, <78,1.33333,-1003.64>, <78,1.33333,-1106.97>,
<78,-1.33333,-486.967>, <78,-1.33333,-590.301>, <78,-1.33333,-1003.64>, <78,-1.33333,-1106.97>,
<78,-2,-486.967>, <78,-2,-590.301>, <78,-2,-1003.64>, <78,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<76,4,-486.967>, <76,4,-590.301>, <76,4,-1003.64>, <76,4,-1106.97>,
<76.3333,3.66667,-486.967>, <76.3333,3.66667,-590.301>, <76.3333,3.66667,-1003.64>, <76.3333,3.66667,-1106.97>,
<77.6667,2.33333,-486.967>, <77.6667,2.33333,-590.301>, <77.6667,2.33333,-1003.64>, <77.6667,2.33333,-1106.97>,
<78,2,-486.967>, <78,2,-590.301>, <78,2,-1003.64>, <78,2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<68,4,-486.967>, <68,4,-590.301>, <68,4,-1003.64>, <68,4,-1106.97>,
<69.3333,4,-486.967>, <69.3333,4,-590.301>, <69.3333,4,-1003.64>, <69.3333,4,-1106.97>,
<74.6667,4,-486.967>, <74.6667,4,-590.301>, <74.6667,4,-1003.64>, <74.6667,4,-1106.97>,
<76,4,-486.967>, <76,4,-590.301>, <76,4,-1003.64>, <76,4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<66,2,-486.967>, <66,2,-590.301>, <66,2,-1003.64>, <66,2,-1106.97>,
<66.3333,2.33333,-486.967>, <66.3333,2.33333,-590.301>, <66.3333,2.33333,-1003.64>, <66.3333,2.33333,-1106.97>,
<67.6667,3.66667,-486.967>, <67.6667,3.66667,-590.301>, <67.6667,3.66667,-1003.64>, <67.6667,3.66667,-1106.97>,
<68,4,-486.967>, <68,4,-590.301>, <68,4,-1003.64>, <68,4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<20,-4,-486.967>, <20,-4,-590.301>, <20,-4,-1003.64>, <20,-4,-1106.97>,
<19.6667,-3.66667,-486.967>, <19.6667,-3.66667,-590.301>, <19.6667,-3.66667,-1003.64>, <19.6667,-3.66667,-1106.97>,
<18.3333,-2.33333,-486.967>, <18.3333,-2.33333,-590.301>, <18.3333,-2.33333,-1003.64>, <18.3333,-2.33333,-1106.97>,
<18,-2,-486.967>, <18,-2,-590.301>, <18,-2,-1003.64>, <18,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<18,2,-486.967>, <18,1.33333,-486.967>, <18,-1.33333,-486.967>, <18,-2,-486.967>,
<18,2,-590.301>, <18,1.33333,-590.301>, <18,-1.33333,-590.301>, <18,-2,-590.301>,
<18,2,-1003.64>, <18,1.33333,-1003.64>, <18,-1.33333,-1003.64>, <18,-2,-1003.64>,
<18,2,-1106.97>, <18,1.33333,-1106.97>, <18,-1.33333,-1106.97>, <18,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<28,-4,-486.967>, <28,-4,-590.301>, <28,-4,-1003.64>, <28,-4,-1106.97>,
<26.6667,-4,-486.967>, <26.6667,-4,-590.301>, <26.6667,-4,-1003.64>, <26.6667,-4,-1106.97>,
<21.3333,-4,-486.967>, <21.3333,-4,-590.301>, <21.3333,-4,-1003.64>, <21.3333,-4,-1106.97>,
<20,-4,-486.967>, <20,-4,-590.301>, <20,-4,-1003.64>, <20,-4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<30,-2,-486.967>, <30,-2,-590.301>, <30,-2,-1003.64>, <30,-2,-1106.97>,
<29.6667,-2.33333,-486.967>, <29.6667,-2.33333,-590.301>, <29.6667,-2.33333,-1003.64>, <29.6667,-2.33333,-1106.97>,
<28.3333,-3.66667,-486.967>, <28.3333,-3.66667,-590.301>, <28.3333,-3.66667,-1003.64>, <28.3333,-3.66667,-1106.97>,
<28,-4,-486.967>, <28,-4,-590.301>, <28,-4,-1003.64>, <28,-4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<30,2,-486.967>, <30,2,-590.301>, <30,2,-1003.64>, <30,2,-1106.97>,
<30,1.33333,-486.967>, <30,1.33333,-590.301>, <30,1.33333,-1003.64>, <30,1.33333,-1106.97>,
<30,-1.33333,-486.967>, <30,-1.33333,-590.301>, <30,-1.33333,-1003.64>, <30,-1.33333,-1106.97>,
<30,-2,-486.967>, <30,-2,-590.301>, <30,-2,-1003.64>, <30,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<28,4,-486.967>, <28,4,-590.301>, <28,4,-1003.64>, <28,4,-1106.97>,
<28.3333,3.66667,-486.967>, <28.3333,3.66667,-590.301>, <28.3333,3.66667,-1003.64>, <28.3333,3.66667,-1106.97>,
<29.6667,2.33333,-486.967>, <29.6667,2.33333,-590.301>, <29.6667,2.33333,-1003.64>, <29.6667,2.33333,-1106.97>,
<30,2,-486.967>, <30,2,-590.301>, <30,2,-1003.64>, <30,2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<20,4,-486.967>, <20,4,-590.301>, <20,4,-1003.64>, <20,4,-1106.97>,
<21.3333,4,-486.967>, <21.3333,4,-590.301>, <21.3333,4,-1003.64>, <21.3333,4,-1106.97>,
<26.6667,4,-486.967>, <26.6667,4,-590.301>, <26.6667,4,-1003.64>, <26.6667,4,-1106.97>,
<28,4,-486.967>, <28,4,-590.301>, <28,4,-1003.64>, <28,4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<18,2,-486.967>, <18,2,-590.301>, <18,2,-1003.64>, <18,2,-1106.97>,
<18.3333,2.33333,-486.967>, <18.3333,2.33333,-590.301>, <18.3333,2.33333,-1003.64>, <18.3333,2.33333,-1106.97>,
<19.6667,3.66667,-486.967>, <19.6667,3.66667,-590.301>, <19.6667,3.66667,-1003.64>, <19.6667,3.66667,-1106.97>,
<20,4,-486.967>, <20,4,-590.301>, <20,4,-1003.64>, <20,4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<52,-4,-486.967>, <52,-4,-590.301>, <52,-4,-1003.64>, <52,-4,-1106.97>,
<51.6667,-3.66667,-486.967>, <51.6667,-3.66667,-590.301>, <51.6667,-3.66667,-1003.64>, <51.6667,-3.66667,-1106.97>,
<50.3333,-2.33333,-486.967>, <50.3333,-2.33333,-590.301>, <50.3333,-2.33333,-1003.64>, <50.3333,-2.33333,-1106.97>,
<50,-2,-486.967>, <50,-2,-590.301>, <50,-2,-1003.64>, <50,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<50,2,-486.967>, <50,1.33333,-486.967>, <50,-1.33333,-486.967>, <50,-2,-486.967>,
<50,2,-590.301>, <50,1.33333,-590.301>, <50,-1.33333,-590.301>, <50,-2,-590.301>,
<50,2,-1003.64>, <50,1.33333,-1003.64>, <50,-1.33333,-1003.64>, <50,-2,-1003.64>,
<50,2,-1106.97>, <50,1.33333,-1106.97>, <50,-1.33333,-1106.97>, <50,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<60,-4,-486.967>, <60,-4,-590.301>, <60,-4,-1003.64>, <60,-4,-1106.97>,
<58.6667,-4,-486.967>, <58.6667,-4,-590.301>, <58.6667,-4,-1003.64>, <58.6667,-4,-1106.97>,
<53.3333,-4,-486.967>, <53.3333,-4,-590.301>, <53.3333,-4,-1003.64>, <53.3333,-4,-1106.97>,
<52,-4,-486.967>, <52,-4,-590.301>, <52,-4,-1003.64>, <52,-4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<62,-2,-486.967>, <62,-2,-590.301>, <62,-2,-1003.64>, <62,-2,-1106.97>,
<61.6667,-2.33333,-486.967>, <61.6667,-2.33333,-590.301>, <61.6667,-2.33333,-1003.64>, <61.6667,-2.33333,-1106.97>,
<60.3333,-3.66667,-486.967>, <60.3333,-3.66667,-590.301>, <60.3333,-3.66667,-1003.64>, <60.3333,-3.66667,-1106.97>,
<60,-4,-486.967>, <60,-4,-590.301>, <60,-4,-1003.64>, <60,-4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<62,2,-486.967>, <62,2,-590.301>, <62,2,-1003.64>, <62,2,-1106.97>,
<62,1.33333,-486.967>, <62,1.33333,-590.301>, <62,1.33333,-1003.64>, <62,1.33333,-1106.97>,
<62,-1.33333,-486.967>, <62,-1.33333,-590.301>, <62,-1.33333,-1003.64>, <62,-1.33333,-1106.97>,
<62,-2,-486.967>, <62,-2,-590.301>, <62,-2,-1003.64>, <62,-2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<60,4,-486.967>, <60,4,-590.301>, <60,4,-1003.64>, <60,4,-1106.97>,
<60.3333,3.66667,-486.967>, <60.3333,3.66667,-590.301>, <60.3333,3.66667,-1003.64>, <60.3333,3.66667,-1106.97>,
<61.6667,2.33333,-486.967>, <61.6667,2.33333,-590.301>, <61.6667,2.33333,-1003.64>, <61.6667,2.33333,-1106.97>,
<62,2,-486.967>, <62,2,-590.301>, <62,2,-1003.64>, <62,2,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<52,4,-486.967>, <52,4,-590.301>, <52,4,-1003.64>, <52,4,-1106.97>,
<53.3333,4,-486.967>, <53.3333,4,-590.301>, <53.3333,4,-1003.64>, <53.3333,4,-1106.97>,
<58.6667,4,-486.967>, <58.6667,4,-590.301>, <58.6667,4,-1003.64>, <58.6667,4,-1106.97>,
<60,4,-486.967>, <60,4,-590.301>, <60,4,-1003.64>, <60,4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<50,2,-486.967>, <50,2,-590.301>, <50,2,-1003.64>, <50,2,-1106.97>,
<50.3333,2.33333,-486.967>, <50.3333,2.33333,-590.301>, <50.3333,2.33333,-1003.64>, <50.3333,2.33333,-1106.97>,
<51.6667,3.66667,-486.967>, <51.6667,3.66667,-590.301>, <51.6667,3.66667,-1003.64>, <51.6667,3.66667,-1106.97>,
<52,4,-486.967>, <52,4,-590.301>, <52,4,-1003.64>, <52,4,-1106.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<130,15,-1193.93>, <130,10,-1193.93>, <130,-10,-1193.93>, <130,-15,-1193.93>,
<129.167,14.1667,-1193.93>, <129.167,9.72222,-1193.93>, <129.167,-9.72222,-1193.93>, <129.167,-14.1667,-1193.93>,
<125.833,10.8333,-1193.93>, <125.833,6.94444,-1193.93>, <125.833,-6.94444,-1193.93>, <125.833,-10.8333,-1193.93>,
<125,10,-1193.93>, <125,6.66667,-1193.93>, <125,-6.66667,-1193.93>, <125,-10,-1193.93>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<130,15,-1193.93>, <129.167,14.1667,-1193.93>, <125.833,10.8333,-1193.93>, <125,10,-1193.93>,
<130,15,-1060.6>, <129.167,14.1667,-1060.6>, <125.833,10.8333,-1060.6>, <125,10,-1060.6>,
<130,15,-527.267>, <129.167,14.1667,-527.267>, <125.833,10.8333,-527.267>, <125,10,-527.267>,
<130,15,-393.934>, <129.167,14.1667,-393.934>, <125.833,10.8333,-393.934>, <125,10,-393.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<130,15,-1193.93>, <133.333,15,-1193.93>, <146.667,15,-1193.93>, <150,15,-1193.93>,
<130,10,-1193.93>, <133.333,10,-1193.93>, <146.667,10,-1193.93>, <150,10,-1193.93>,
<130,-10,-1193.93>, <133.333,-10,-1193.93>, <146.667,-10,-1193.93>, <150,-10,-1193.93>,
<130,-15,-1193.93>, <133.333,-15,-1193.93>, <146.667,-15,-1193.93>, <150,-15,-1193.93>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<130,15,-1193.93>, <130,15,-1060.6>, <130,15,-527.267>, <130,15,-393.934>,
<133.333,15,-1193.93>, <133.333,15,-1060.6>, <133.333,15,-527.267>, <133.333,15,-393.934>,
<146.667,15,-1193.93>, <146.667,15,-1060.6>, <146.667,15,-527.267>, <146.667,15,-393.934>,
<150,15,-1193.93>, <150,15,-1060.6>, <150,15,-527.267>, <150,15,-393.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<150,15,-1193.93>, <150.833,14.1667,-1193.93>, <154.167,10.8333,-1193.93>, <155,10,-1193.93>,
<150,10,-1193.93>, <150.833,9.72222,-1193.93>, <154.167,6.94444,-1193.93>, <155,6.66667,-1193.93>,
<150,-10,-1193.93>, <150.833,-9.72222,-1193.93>, <154.167,-6.94444,-1193.93>, <155,-6.66667,-1193.93>,
<150,-15,-1193.93>, <150.833,-14.1667,-1193.93>, <154.167,-10.8333,-1193.93>, <155,-10,-1193.93>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<150,15,-1193.93>, <150,15,-1060.6>, <150,15,-527.267>, <150,15,-393.934>,
<150.833,14.1667,-1193.93>, <150.833,14.1667,-1060.6>, <150.833,14.1667,-527.267>, <150.833,14.1667,-393.934>,
<154.167,10.8333,-1193.93>, <154.167,10.8333,-1060.6>, <154.167,10.8333,-527.267>, <154.167,10.8333,-393.934>,
<155,10,-1193.93>, <155,10,-1060.6>, <155,10,-527.267>, <155,10,-393.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<155,10,-1193.93>, <155,10,-1060.6>, <155,10,-527.267>, <155,10,-393.934>,
<155,6.66667,-1193.93>, <155,6.66667,-1060.6>, <155,6.66667,-527.267>, <155,6.66667,-393.934>,
<155,-6.66667,-1193.93>, <155,-6.66667,-1060.6>, <155,-6.66667,-527.267>, <155,-6.66667,-393.934>,
<155,-10,-1193.93>, <155,-10,-1060.6>, <155,-10,-527.267>, <155,-10,-393.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<155,-10,-1193.93>, <155,-10,-1060.6>, <155,-10,-527.267>, <155,-10,-393.934>,
<154.167,-10.8333,-1193.93>, <154.167,-10.8333,-1060.6>, <154.167,-10.8333,-527.267>, <154.167,-10.8333,-393.934>,
<150.833,-14.1667,-1193.93>, <150.833,-14.1667,-1060.6>, <150.833,-14.1667,-527.267>, <150.833,-14.1667,-393.934>,
<150,-15,-1193.93>, <150,-15,-1060.6>, <150,-15,-527.267>, <150,-15,-393.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<150,-15,-1193.93>, <150,-15,-1060.6>, <150,-15,-527.267>, <150,-15,-393.934>,
<146.667,-15,-1193.93>, <146.667,-15,-1060.6>, <146.667,-15,-527.267>, <146.667,-15,-393.934>,
<133.333,-15,-1193.93>, <133.333,-15,-1060.6>, <133.333,-15,-527.267>, <133.333,-15,-393.934>,
<130,-15,-1193.93>, <130,-15,-1060.6>, <130,-15,-527.267>, <130,-15,-393.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<130,-15,-1193.93>, <130,-15,-1060.6>, <130,-15,-527.267>, <130,-15,-393.934>,
<129.167,-14.1667,-1193.93>, <129.167,-14.1667,-1060.6>, <129.167,-14.1667,-527.267>, <129.167,-14.1667,-393.934>,
<125.833,-10.8333,-1193.93>, <125.833,-10.8333,-1060.6>, <125.833,-10.8333,-527.267>, <125.833,-10.8333,-393.934>,
<125,-10,-1193.93>, <125,-10,-1060.6>, <125,-10,-527.267>, <125,-10,-393.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<125,-10,-1193.93>, <125,-10,-1060.6>, <125,-10,-527.267>, <125,-10,-393.934>,
<125,-6.66667,-1193.93>, <125,-6.66667,-1060.6>, <125,-6.66667,-527.267>, <125,-6.66667,-393.934>,
<125,6.66667,-1193.93>, <125,6.66667,-1060.6>, <125,6.66667,-527.267>, <125,6.66667,-393.934>,
<125,10,-1193.93>, <125,10,-1060.6>, <125,10,-527.267>, <125,10,-393.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,5,-484.934>, <158.5,5,-469.934>, <158.5,5,-409.934>, <158.5,5,-394.934>,
<158.5,3.33333,-484.934>, <158.5,3.33333,-469.934>, <158.5,3.33333,-409.934>, <158.5,3.33333,-394.934>,
<158.5,-3.33333,-484.934>, <158.5,-3.33333,-469.934>, <158.5,-3.33333,-409.934>, <158.5,-3.33333,-394.934>,
<158.5,-5,-484.934>, <158.5,-5,-469.934>, <158.5,-5,-409.934>, <158.5,-5,-394.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,5,-484.934>, <158.5,3.33333,-484.934>, <158.5,-3.33333,-484.934>, <158.5,-5,-484.934>,
<185.667,5,-484.934>, <185.667,3.33333,-484.934>, <185.667,-3.33333,-484.934>, <185.667,-5,-484.934>,
<294.333,5,-484.934>, <294.333,3.33333,-484.934>, <294.333,-3.33333,-484.934>, <294.333,-5,-484.934>,
<321.5,5,-484.934>, <321.5,3.33333,-484.934>, <321.5,-3.33333,-484.934>, <321.5,-5,-484.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<321.5,5,-484.934>, <321.5,3.33333,-484.934>, <321.5,-3.33333,-484.934>, <321.5,-5,-484.934>,
<321.5,5,-469.934>, <321.5,3.33333,-469.934>, <321.5,-3.33333,-469.934>, <321.5,-5,-469.934>,
<321.5,5,-409.934>, <321.5,3.33333,-409.934>, <321.5,-3.33333,-409.934>, <321.5,-5,-409.934>,
<321.5,5,-394.934>, <321.5,3.33333,-394.934>, <321.5,-3.33333,-394.934>, <321.5,-5,-394.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<321.5,5,-394.934>, <321.5,3.33333,-394.934>, <321.5,-3.33333,-394.934>, <321.5,-5,-394.934>,
<294.333,5,-394.934>, <294.333,3.33333,-394.934>, <294.333,-3.33333,-394.934>, <294.333,-5,-394.934>,
<185.667,5,-394.934>, <185.667,3.33333,-394.934>, <185.667,-3.33333,-394.934>, <185.667,-5,-394.934>,
<158.5,5,-394.934>, <158.5,3.33333,-394.934>, <158.5,-3.33333,-394.934>, <158.5,-5,-394.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<290,2,-1103.93>, <290,2,-1000.6>, <290,2,-587.267>, <290,2,-483.934>,
<290,1.33333,-1103.93>, <290,1.33333,-1000.6>, <290,1.33333,-587.267>, <290,1.33333,-483.934>,
<290,-1.33333,-1103.93>, <290,-1.33333,-1000.6>, <290,-1.33333,-587.267>, <290,-1.33333,-483.934>,
<290,-2,-1103.93>, <290,-2,-1000.6>, <290,-2,-587.267>, <290,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<290,2,-1103.93>, <290.333,2.33333,-1103.93>, <291.667,3.66667,-1103.93>, <292,4,-1103.93>,
<290,2,-1000.6>, <290.333,2.33333,-1000.6>, <291.667,3.66667,-1000.6>, <292,4,-1000.6>,
<290,2,-587.267>, <290.333,2.33333,-587.267>, <291.667,3.66667,-587.267>, <292,4,-587.267>,
<290,2,-483.934>, <290.333,2.33333,-483.934>, <291.667,3.66667,-483.934>, <292,4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<292,4,-1103.93>, <293.333,4,-1103.93>, <298.667,4,-1103.93>, <300,4,-1103.93>,
<292,4,-1000.6>, <293.333,4,-1000.6>, <298.667,4,-1000.6>, <300,4,-1000.6>,
<292,4,-587.267>, <293.333,4,-587.267>, <298.667,4,-587.267>, <300,4,-587.267>,
<292,4,-483.934>, <293.333,4,-483.934>, <298.667,4,-483.934>, <300,4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<300,4,-1103.93>, <300.333,3.66667,-1103.93>, <301.667,2.33333,-1103.93>, <302,2,-1103.93>,
<300,4,-1000.6>, <300.333,3.66667,-1000.6>, <301.667,2.33333,-1000.6>, <302,2,-1000.6>,
<300,4,-587.267>, <300.333,3.66667,-587.267>, <301.667,2.33333,-587.267>, <302,2,-587.267>,
<300,4,-483.934>, <300.333,3.66667,-483.934>, <301.667,2.33333,-483.934>, <302,2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<302,2,-1103.93>, <302,1.33333,-1103.93>, <302,-1.33333,-1103.93>, <302,-2,-1103.93>,
<302,2,-1000.6>, <302,1.33333,-1000.6>, <302,-1.33333,-1000.6>, <302,-2,-1000.6>,
<302,2,-587.267>, <302,1.33333,-587.267>, <302,-1.33333,-587.267>, <302,-2,-587.267>,
<302,2,-483.934>, <302,1.33333,-483.934>, <302,-1.33333,-483.934>, <302,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<302,-2,-1103.93>, <301.667,-2.33333,-1103.93>, <300.333,-3.66667,-1103.93>, <300,-4,-1103.93>,
<302,-2,-1000.6>, <301.667,-2.33333,-1000.6>, <300.333,-3.66667,-1000.6>, <300,-4,-1000.6>,
<302,-2,-587.267>, <301.667,-2.33333,-587.267>, <300.333,-3.66667,-587.267>, <300,-4,-587.267>,
<302,-2,-483.934>, <301.667,-2.33333,-483.934>, <300.333,-3.66667,-483.934>, <300,-4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<300,-4,-1103.93>, <298.667,-4,-1103.93>, <293.333,-4,-1103.93>, <292,-4,-1103.93>,
<300,-4,-1000.6>, <298.667,-4,-1000.6>, <293.333,-4,-1000.6>, <292,-4,-1000.6>,
<300,-4,-587.267>, <298.667,-4,-587.267>, <293.333,-4,-587.267>, <292,-4,-587.267>,
<300,-4,-483.934>, <298.667,-4,-483.934>, <293.333,-4,-483.934>, <292,-4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<292,-4,-1103.93>, <291.667,-3.66667,-1103.93>, <290.333,-2.33333,-1103.93>, <290,-2,-1103.93>,
<292,-4,-1000.6>, <291.667,-3.66667,-1000.6>, <290.333,-2.33333,-1000.6>, <290,-2,-1000.6>,
<292,-4,-587.267>, <291.667,-3.66667,-587.267>, <290.333,-2.33333,-587.267>, <290,-2,-587.267>,
<292,-4,-483.934>, <291.667,-3.66667,-483.934>, <290.333,-2.33333,-483.934>, <290,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<258,2,-1103.93>, <258,2,-1000.6>, <258,2,-587.267>, <258,2,-483.934>,
<258,1.33333,-1103.93>, <258,1.33333,-1000.6>, <258,1.33333,-587.267>, <258,1.33333,-483.934>,
<258,-1.33333,-1103.93>, <258,-1.33333,-1000.6>, <258,-1.33333,-587.267>, <258,-1.33333,-483.934>,
<258,-2,-1103.93>, <258,-2,-1000.6>, <258,-2,-587.267>, <258,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<258,2,-1103.93>, <258.333,2.33333,-1103.93>, <259.667,3.66667,-1103.93>, <260,4,-1103.93>,
<258,2,-1000.6>, <258.333,2.33333,-1000.6>, <259.667,3.66667,-1000.6>, <260,4,-1000.6>,
<258,2,-587.267>, <258.333,2.33333,-587.267>, <259.667,3.66667,-587.267>, <260,4,-587.267>,
<258,2,-483.934>, <258.333,2.33333,-483.934>, <259.667,3.66667,-483.934>, <260,4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<260,4,-1103.93>, <261.333,4,-1103.93>, <266.667,4,-1103.93>, <268,4,-1103.93>,
<260,4,-1000.6>, <261.333,4,-1000.6>, <266.667,4,-1000.6>, <268,4,-1000.6>,
<260,4,-587.267>, <261.333,4,-587.267>, <266.667,4,-587.267>, <268,4,-587.267>,
<260,4,-483.934>, <261.333,4,-483.934>, <266.667,4,-483.934>, <268,4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<268,4,-1103.93>, <268.333,3.66667,-1103.93>, <269.667,2.33333,-1103.93>, <270,2,-1103.93>,
<268,4,-1000.6>, <268.333,3.66667,-1000.6>, <269.667,2.33333,-1000.6>, <270,2,-1000.6>,
<268,4,-587.267>, <268.333,3.66667,-587.267>, <269.667,2.33333,-587.267>, <270,2,-587.267>,
<268,4,-483.934>, <268.333,3.66667,-483.934>, <269.667,2.33333,-483.934>, <270,2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<270,2,-1103.93>, <270,1.33333,-1103.93>, <270,-1.33333,-1103.93>, <270,-2,-1103.93>,
<270,2,-1000.6>, <270,1.33333,-1000.6>, <270,-1.33333,-1000.6>, <270,-2,-1000.6>,
<270,2,-587.267>, <270,1.33333,-587.267>, <270,-1.33333,-587.267>, <270,-2,-587.267>,
<270,2,-483.934>, <270,1.33333,-483.934>, <270,-1.33333,-483.934>, <270,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<270,-2,-1103.93>, <269.667,-2.33333,-1103.93>, <268.333,-3.66667,-1103.93>, <268,-4,-1103.93>,
<270,-2,-1000.6>, <269.667,-2.33333,-1000.6>, <268.333,-3.66667,-1000.6>, <268,-4,-1000.6>,
<270,-2,-587.267>, <269.667,-2.33333,-587.267>, <268.333,-3.66667,-587.267>, <268,-4,-587.267>,
<270,-2,-483.934>, <269.667,-2.33333,-483.934>, <268.333,-3.66667,-483.934>, <268,-4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<268,-4,-1103.93>, <266.667,-4,-1103.93>, <261.333,-4,-1103.93>, <260,-4,-1103.93>,
<268,-4,-1000.6>, <266.667,-4,-1000.6>, <261.333,-4,-1000.6>, <260,-4,-1000.6>,
<268,-4,-587.267>, <266.667,-4,-587.267>, <261.333,-4,-587.267>, <260,-4,-587.267>,
<268,-4,-483.934>, <266.667,-4,-483.934>, <261.333,-4,-483.934>, <260,-4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<260,-4,-1103.93>, <259.667,-3.66667,-1103.93>, <258.333,-2.33333,-1103.93>, <258,-2,-1103.93>,
<260,-4,-1000.6>, <259.667,-3.66667,-1000.6>, <258.333,-2.33333,-1000.6>, <258,-2,-1000.6>,
<260,-4,-587.267>, <259.667,-3.66667,-587.267>, <258.333,-2.33333,-587.267>, <258,-2,-587.267>,
<260,-4,-483.934>, <259.667,-3.66667,-483.934>, <258.333,-2.33333,-483.934>, <258,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<306,2,-1103.93>, <306,2,-1000.6>, <306,2,-587.267>, <306,2,-483.934>,
<306,1.33333,-1103.93>, <306,1.33333,-1000.6>, <306,1.33333,-587.267>, <306,1.33333,-483.934>,
<306,-1.33333,-1103.93>, <306,-1.33333,-1000.6>, <306,-1.33333,-587.267>, <306,-1.33333,-483.934>,
<306,-2,-1103.93>, <306,-2,-1000.6>, <306,-2,-587.267>, <306,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<306,2,-1103.93>, <306.333,2.33333,-1103.93>, <307.667,3.66667,-1103.93>, <308,4,-1103.93>,
<306,2,-1000.6>, <306.333,2.33333,-1000.6>, <307.667,3.66667,-1000.6>, <308,4,-1000.6>,
<306,2,-587.267>, <306.333,2.33333,-587.267>, <307.667,3.66667,-587.267>, <308,4,-587.267>,
<306,2,-483.934>, <306.333,2.33333,-483.934>, <307.667,3.66667,-483.934>, <308,4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<308,4,-1103.93>, <309.333,4,-1103.93>, <314.667,4,-1103.93>, <316,4,-1103.93>,
<308,4,-1000.6>, <309.333,4,-1000.6>, <314.667,4,-1000.6>, <316,4,-1000.6>,
<308,4,-587.267>, <309.333,4,-587.267>, <314.667,4,-587.267>, <316,4,-587.267>,
<308,4,-483.934>, <309.333,4,-483.934>, <314.667,4,-483.934>, <316,4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<316,4,-1103.93>, <316.333,3.66667,-1103.93>, <317.667,2.33333,-1103.93>, <318,2,-1103.93>,
<316,4,-1000.6>, <316.333,3.66667,-1000.6>, <317.667,2.33333,-1000.6>, <318,2,-1000.6>,
<316,4,-587.267>, <316.333,3.66667,-587.267>, <317.667,2.33333,-587.267>, <318,2,-587.267>,
<316,4,-483.934>, <316.333,3.66667,-483.934>, <317.667,2.33333,-483.934>, <318,2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<318,2,-1103.93>, <318,1.33333,-1103.93>, <318,-1.33333,-1103.93>, <318,-2,-1103.93>,
<318,2,-1000.6>, <318,1.33333,-1000.6>, <318,-1.33333,-1000.6>, <318,-2,-1000.6>,
<318,2,-587.267>, <318,1.33333,-587.267>, <318,-1.33333,-587.267>, <318,-2,-587.267>,
<318,2,-483.934>, <318,1.33333,-483.934>, <318,-1.33333,-483.934>, <318,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<318,-2,-1103.93>, <317.667,-2.33333,-1103.93>, <316.333,-3.66667,-1103.93>, <316,-4,-1103.93>,
<318,-2,-1000.6>, <317.667,-2.33333,-1000.6>, <316.333,-3.66667,-1000.6>, <316,-4,-1000.6>,
<318,-2,-587.267>, <317.667,-2.33333,-587.267>, <316.333,-3.66667,-587.267>, <316,-4,-587.267>,
<318,-2,-483.934>, <317.667,-2.33333,-483.934>, <316.333,-3.66667,-483.934>, <316,-4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<316,-4,-1103.93>, <314.667,-4,-1103.93>, <309.333,-4,-1103.93>, <308,-4,-1103.93>,
<316,-4,-1000.6>, <314.667,-4,-1000.6>, <309.333,-4,-1000.6>, <308,-4,-1000.6>,
<316,-4,-587.267>, <314.667,-4,-587.267>, <309.333,-4,-587.267>, <308,-4,-587.267>,
<316,-4,-483.934>, <314.667,-4,-483.934>, <309.333,-4,-483.934>, <308,-4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<308,-4,-1103.93>, <307.667,-3.66667,-1103.93>, <306.333,-2.33333,-1103.93>, <306,-2,-1103.93>,
<308,-4,-1000.6>, <307.667,-3.66667,-1000.6>, <306.333,-2.33333,-1000.6>, <306,-2,-1000.6>,
<308,-4,-587.267>, <307.667,-3.66667,-587.267>, <306.333,-2.33333,-587.267>, <306,-2,-587.267>,
<308,-4,-483.934>, <307.667,-3.66667,-483.934>, <306.333,-2.33333,-483.934>, <306,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<242,2,-1103.93>, <242,2,-1000.6>, <242,2,-587.267>, <242,2,-483.934>,
<242,1.33333,-1103.93>, <242,1.33333,-1000.6>, <242,1.33333,-587.267>, <242,1.33333,-483.934>,
<242,-1.33333,-1103.93>, <242,-1.33333,-1000.6>, <242,-1.33333,-587.267>, <242,-1.33333,-483.934>,
<242,-2,-1103.93>, <242,-2,-1000.6>, <242,-2,-587.267>, <242,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<242,2,-1103.93>, <242.333,2.33333,-1103.93>, <243.667,3.66667,-1103.93>, <244,4,-1103.93>,
<242,2,-1000.6>, <242.333,2.33333,-1000.6>, <243.667,3.66667,-1000.6>, <244,4,-1000.6>,
<242,2,-587.267>, <242.333,2.33333,-587.267>, <243.667,3.66667,-587.267>, <244,4,-587.267>,
<242,2,-483.934>, <242.333,2.33333,-483.934>, <243.667,3.66667,-483.934>, <244,4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<244,4,-1103.93>, <245.333,4,-1103.93>, <250.667,4,-1103.93>, <252,4,-1103.93>,
<244,4,-1000.6>, <245.333,4,-1000.6>, <250.667,4,-1000.6>, <252,4,-1000.6>,
<244,4,-587.267>, <245.333,4,-587.267>, <250.667,4,-587.267>, <252,4,-587.267>,
<244,4,-483.934>, <245.333,4,-483.934>, <250.667,4,-483.934>, <252,4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<252,4,-1103.93>, <252.333,3.66667,-1103.93>, <253.667,2.33333,-1103.93>, <254,2,-1103.93>,
<252,4,-1000.6>, <252.333,3.66667,-1000.6>, <253.667,2.33333,-1000.6>, <254,2,-1000.6>,
<252,4,-587.267>, <252.333,3.66667,-587.267>, <253.667,2.33333,-587.267>, <254,2,-587.267>,
<252,4,-483.934>, <252.333,3.66667,-483.934>, <253.667,2.33333,-483.934>, <254,2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<254,2,-1103.93>, <254,1.33333,-1103.93>, <254,-1.33333,-1103.93>, <254,-2,-1103.93>,
<254,2,-1000.6>, <254,1.33333,-1000.6>, <254,-1.33333,-1000.6>, <254,-2,-1000.6>,
<254,2,-587.267>, <254,1.33333,-587.267>, <254,-1.33333,-587.267>, <254,-2,-587.267>,
<254,2,-483.934>, <254,1.33333,-483.934>, <254,-1.33333,-483.934>, <254,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<254,-2,-1103.93>, <253.667,-2.33333,-1103.93>, <252.333,-3.66667,-1103.93>, <252,-4,-1103.93>,
<254,-2,-1000.6>, <253.667,-2.33333,-1000.6>, <252.333,-3.66667,-1000.6>, <252,-4,-1000.6>,
<254,-2,-587.267>, <253.667,-2.33333,-587.267>, <252.333,-3.66667,-587.267>, <252,-4,-587.267>,
<254,-2,-483.934>, <253.667,-2.33333,-483.934>, <252.333,-3.66667,-483.934>, <252,-4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<252,-4,-1103.93>, <250.667,-4,-1103.93>, <245.333,-4,-1103.93>, <244,-4,-1103.93>,
<252,-4,-1000.6>, <250.667,-4,-1000.6>, <245.333,-4,-1000.6>, <244,-4,-1000.6>,
<252,-4,-587.267>, <250.667,-4,-587.267>, <245.333,-4,-587.267>, <244,-4,-587.267>,
<252,-4,-483.934>, <250.667,-4,-483.934>, <245.333,-4,-483.934>, <244,-4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<244,-4,-1103.93>, <243.667,-3.66667,-1103.93>, <242.333,-2.33333,-1103.93>, <242,-2,-1103.93>,
<244,-4,-1000.6>, <243.667,-3.66667,-1000.6>, <242.333,-2.33333,-1000.6>, <242,-2,-1000.6>,
<244,-4,-587.267>, <243.667,-3.66667,-587.267>, <242.333,-2.33333,-587.267>, <242,-2,-587.267>,
<244,-4,-483.934>, <243.667,-3.66667,-483.934>, <242.333,-2.33333,-483.934>, <242,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<274,2,-1103.93>, <274,2,-1000.6>, <274,2,-587.267>, <274,2,-483.934>,
<274,1.33333,-1103.93>, <274,1.33333,-1000.6>, <274,1.33333,-587.267>, <274,1.33333,-483.934>,
<274,-1.33333,-1103.93>, <274,-1.33333,-1000.6>, <274,-1.33333,-587.267>, <274,-1.33333,-483.934>,
<274,-2,-1103.93>, <274,-2,-1000.6>, <274,-2,-587.267>, <274,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<274,2,-1103.93>, <274.333,2.33333,-1103.93>, <275.667,3.66667,-1103.93>, <276,4,-1103.93>,
<274,2,-1000.6>, <274.333,2.33333,-1000.6>, <275.667,3.66667,-1000.6>, <276,4,-1000.6>,
<274,2,-587.267>, <274.333,2.33333,-587.267>, <275.667,3.66667,-587.267>, <276,4,-587.267>,
<274,2,-483.934>, <274.333,2.33333,-483.934>, <275.667,3.66667,-483.934>, <276,4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<276,4,-1103.93>, <277.333,4,-1103.93>, <282.667,4,-1103.93>, <284,4,-1103.93>,
<276,4,-1000.6>, <277.333,4,-1000.6>, <282.667,4,-1000.6>, <284,4,-1000.6>,
<276,4,-587.267>, <277.333,4,-587.267>, <282.667,4,-587.267>, <284,4,-587.267>,
<276,4,-483.934>, <277.333,4,-483.934>, <282.667,4,-483.934>, <284,4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<284,4,-1103.93>, <284.333,3.66667,-1103.93>, <285.667,2.33333,-1103.93>, <286,2,-1103.93>,
<284,4,-1000.6>, <284.333,3.66667,-1000.6>, <285.667,2.33333,-1000.6>, <286,2,-1000.6>,
<284,4,-587.267>, <284.333,3.66667,-587.267>, <285.667,2.33333,-587.267>, <286,2,-587.267>,
<284,4,-483.934>, <284.333,3.66667,-483.934>, <285.667,2.33333,-483.934>, <286,2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<286,2,-1103.93>, <286,1.33333,-1103.93>, <286,-1.33333,-1103.93>, <286,-2,-1103.93>,
<286,2,-1000.6>, <286,1.33333,-1000.6>, <286,-1.33333,-1000.6>, <286,-2,-1000.6>,
<286,2,-587.267>, <286,1.33333,-587.267>, <286,-1.33333,-587.267>, <286,-2,-587.267>,
<286,2,-483.934>, <286,1.33333,-483.934>, <286,-1.33333,-483.934>, <286,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<286,-2,-1103.93>, <285.667,-2.33333,-1103.93>, <284.333,-3.66667,-1103.93>, <284,-4,-1103.93>,
<286,-2,-1000.6>, <285.667,-2.33333,-1000.6>, <284.333,-3.66667,-1000.6>, <284,-4,-1000.6>,
<286,-2,-587.267>, <285.667,-2.33333,-587.267>, <284.333,-3.66667,-587.267>, <284,-4,-587.267>,
<286,-2,-483.934>, <285.667,-2.33333,-483.934>, <284.333,-3.66667,-483.934>, <284,-4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<284,-4,-1103.93>, <282.667,-4,-1103.93>, <277.333,-4,-1103.93>, <276,-4,-1103.93>,
<284,-4,-1000.6>, <282.667,-4,-1000.6>, <277.333,-4,-1000.6>, <276,-4,-1000.6>,
<284,-4,-587.267>, <282.667,-4,-587.267>, <277.333,-4,-587.267>, <276,-4,-587.267>,
<284,-4,-483.934>, <282.667,-4,-483.934>, <277.333,-4,-483.934>, <276,-4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<276,-4,-1103.93>, <275.667,-3.66667,-1103.93>, <274.333,-2.33333,-1103.93>, <274,-2,-1103.93>,
<276,-4,-1000.6>, <275.667,-3.66667,-1000.6>, <274.333,-2.33333,-1000.6>, <274,-2,-1000.6>,
<276,-4,-587.267>, <275.667,-3.66667,-587.267>, <274.333,-2.33333,-587.267>, <274,-2,-587.267>,
<276,-4,-483.934>, <275.667,-3.66667,-483.934>, <274.333,-2.33333,-483.934>, <274,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<194,2,-1103.93>, <194,2,-1000.6>, <194,2,-587.267>, <194,2,-483.934>,
<194,1.33333,-1103.93>, <194,1.33333,-1000.6>, <194,1.33333,-587.267>, <194,1.33333,-483.934>,
<194,-1.33333,-1103.93>, <194,-1.33333,-1000.6>, <194,-1.33333,-587.267>, <194,-1.33333,-483.934>,
<194,-2,-1103.93>, <194,-2,-1000.6>, <194,-2,-587.267>, <194,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<194,2,-1103.93>, <194.333,2.33333,-1103.93>, <195.667,3.66667,-1103.93>, <196,4,-1103.93>,
<194,2,-1000.6>, <194.333,2.33333,-1000.6>, <195.667,3.66667,-1000.6>, <196,4,-1000.6>,
<194,2,-587.267>, <194.333,2.33333,-587.267>, <195.667,3.66667,-587.267>, <196,4,-587.267>,
<194,2,-483.934>, <194.333,2.33333,-483.934>, <195.667,3.66667,-483.934>, <196,4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<196,4,-1103.93>, <197.333,4,-1103.93>, <202.667,4,-1103.93>, <204,4,-1103.93>,
<196,4,-1000.6>, <197.333,4,-1000.6>, <202.667,4,-1000.6>, <204,4,-1000.6>,
<196,4,-587.267>, <197.333,4,-587.267>, <202.667,4,-587.267>, <204,4,-587.267>,
<196,4,-483.934>, <197.333,4,-483.934>, <202.667,4,-483.934>, <204,4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<204,4,-1103.93>, <204.333,3.66667,-1103.93>, <205.667,2.33333,-1103.93>, <206,2,-1103.93>,
<204,4,-1000.6>, <204.333,3.66667,-1000.6>, <205.667,2.33333,-1000.6>, <206,2,-1000.6>,
<204,4,-587.267>, <204.333,3.66667,-587.267>, <205.667,2.33333,-587.267>, <206,2,-587.267>,
<204,4,-483.934>, <204.333,3.66667,-483.934>, <205.667,2.33333,-483.934>, <206,2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<206,2,-1103.93>, <206,1.33333,-1103.93>, <206,-1.33333,-1103.93>, <206,-2,-1103.93>,
<206,2,-1000.6>, <206,1.33333,-1000.6>, <206,-1.33333,-1000.6>, <206,-2,-1000.6>,
<206,2,-587.267>, <206,1.33333,-587.267>, <206,-1.33333,-587.267>, <206,-2,-587.267>,
<206,2,-483.934>, <206,1.33333,-483.934>, <206,-1.33333,-483.934>, <206,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<206,-2,-1103.93>, <205.667,-2.33333,-1103.93>, <204.333,-3.66667,-1103.93>, <204,-4,-1103.93>,
<206,-2,-1000.6>, <205.667,-2.33333,-1000.6>, <204.333,-3.66667,-1000.6>, <204,-4,-1000.6>,
<206,-2,-587.267>, <205.667,-2.33333,-587.267>, <204.333,-3.66667,-587.267>, <204,-4,-587.267>,
<206,-2,-483.934>, <205.667,-2.33333,-483.934>, <204.333,-3.66667,-483.934>, <204,-4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<204,-4,-1103.93>, <202.667,-4,-1103.93>, <197.333,-4,-1103.93>, <196,-4,-1103.93>,
<204,-4,-1000.6>, <202.667,-4,-1000.6>, <197.333,-4,-1000.6>, <196,-4,-1000.6>,
<204,-4,-587.267>, <202.667,-4,-587.267>, <197.333,-4,-587.267>, <196,-4,-587.267>,
<204,-4,-483.934>, <202.667,-4,-483.934>, <197.333,-4,-483.934>, <196,-4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<196,-4,-1103.93>, <195.667,-3.66667,-1103.93>, <194.333,-2.33333,-1103.93>, <194,-2,-1103.93>,
<196,-4,-1000.6>, <195.667,-3.66667,-1000.6>, <194.333,-2.33333,-1000.6>, <194,-2,-1000.6>,
<196,-4,-587.267>, <195.667,-3.66667,-587.267>, <194.333,-2.33333,-587.267>, <194,-2,-587.267>,
<196,-4,-483.934>, <195.667,-3.66667,-483.934>, <194.333,-2.33333,-483.934>, <194,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<162,2,-1103.93>, <162,2,-1000.6>, <162,2,-587.267>, <162,2,-483.934>,
<162,1.33333,-1103.93>, <162,1.33333,-1000.6>, <162,1.33333,-587.267>, <162,1.33333,-483.934>,
<162,-1.33333,-1103.93>, <162,-1.33333,-1000.6>, <162,-1.33333,-587.267>, <162,-1.33333,-483.934>,
<162,-2,-1103.93>, <162,-2,-1000.6>, <162,-2,-587.267>, <162,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<162,2,-1103.93>, <162.333,2.33333,-1103.93>, <163.667,3.66667,-1103.93>, <164,4,-1103.93>,
<162,2,-1000.6>, <162.333,2.33333,-1000.6>, <163.667,3.66667,-1000.6>, <164,4,-1000.6>,
<162,2,-587.267>, <162.333,2.33333,-587.267>, <163.667,3.66667,-587.267>, <164,4,-587.267>,
<162,2,-483.934>, <162.333,2.33333,-483.934>, <163.667,3.66667,-483.934>, <164,4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<164,4,-1103.93>, <165.333,4,-1103.93>, <170.667,4,-1103.93>, <172,4,-1103.93>,
<164,4,-1000.6>, <165.333,4,-1000.6>, <170.667,4,-1000.6>, <172,4,-1000.6>,
<164,4,-587.267>, <165.333,4,-587.267>, <170.667,4,-587.267>, <172,4,-587.267>,
<164,4,-483.934>, <165.333,4,-483.934>, <170.667,4,-483.934>, <172,4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<172,4,-1103.93>, <172.333,3.66667,-1103.93>, <173.667,2.33333,-1103.93>, <174,2,-1103.93>,
<172,4,-1000.6>, <172.333,3.66667,-1000.6>, <173.667,2.33333,-1000.6>, <174,2,-1000.6>,
<172,4,-587.267>, <172.333,3.66667,-587.267>, <173.667,2.33333,-587.267>, <174,2,-587.267>,
<172,4,-483.934>, <172.333,3.66667,-483.934>, <173.667,2.33333,-483.934>, <174,2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<174,2,-1103.93>, <174,1.33333,-1103.93>, <174,-1.33333,-1103.93>, <174,-2,-1103.93>,
<174,2,-1000.6>, <174,1.33333,-1000.6>, <174,-1.33333,-1000.6>, <174,-2,-1000.6>,
<174,2,-587.267>, <174,1.33333,-587.267>, <174,-1.33333,-587.267>, <174,-2,-587.267>,
<174,2,-483.934>, <174,1.33333,-483.934>, <174,-1.33333,-483.934>, <174,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<174,-2,-1103.93>, <173.667,-2.33333,-1103.93>, <172.333,-3.66667,-1103.93>, <172,-4,-1103.93>,
<174,-2,-1000.6>, <173.667,-2.33333,-1000.6>, <172.333,-3.66667,-1000.6>, <172,-4,-1000.6>,
<174,-2,-587.267>, <173.667,-2.33333,-587.267>, <172.333,-3.66667,-587.267>, <172,-4,-587.267>,
<174,-2,-483.934>, <173.667,-2.33333,-483.934>, <172.333,-3.66667,-483.934>, <172,-4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<172,-4,-1103.93>, <170.667,-4,-1103.93>, <165.333,-4,-1103.93>, <164,-4,-1103.93>,
<172,-4,-1000.6>, <170.667,-4,-1000.6>, <165.333,-4,-1000.6>, <164,-4,-1000.6>,
<172,-4,-587.267>, <170.667,-4,-587.267>, <165.333,-4,-587.267>, <164,-4,-587.267>,
<172,-4,-483.934>, <170.667,-4,-483.934>, <165.333,-4,-483.934>, <164,-4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<164,-4,-1103.93>, <163.667,-3.66667,-1103.93>, <162.333,-2.33333,-1103.93>, <162,-2,-1103.93>,
<164,-4,-1000.6>, <163.667,-3.66667,-1000.6>, <162.333,-2.33333,-1000.6>, <162,-2,-1000.6>,
<164,-4,-587.267>, <163.667,-3.66667,-587.267>, <162.333,-2.33333,-587.267>, <162,-2,-587.267>,
<164,-4,-483.934>, <163.667,-3.66667,-483.934>, <162.333,-2.33333,-483.934>, <162,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<226,2,-1103.93>, <226,2,-1000.6>, <226,2,-587.267>, <226,2,-483.934>,
<226,1.33333,-1103.93>, <226,1.33333,-1000.6>, <226,1.33333,-587.267>, <226,1.33333,-483.934>,
<226,-1.33333,-1103.93>, <226,-1.33333,-1000.6>, <226,-1.33333,-587.267>, <226,-1.33333,-483.934>,
<226,-2,-1103.93>, <226,-2,-1000.6>, <226,-2,-587.267>, <226,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<226,2,-1103.93>, <226.333,2.33333,-1103.93>, <227.667,3.66667,-1103.93>, <228,4,-1103.93>,
<226,2,-1000.6>, <226.333,2.33333,-1000.6>, <227.667,3.66667,-1000.6>, <228,4,-1000.6>,
<226,2,-587.267>, <226.333,2.33333,-587.267>, <227.667,3.66667,-587.267>, <228,4,-587.267>,
<226,2,-483.934>, <226.333,2.33333,-483.934>, <227.667,3.66667,-483.934>, <228,4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<228,4,-1103.93>, <229.333,4,-1103.93>, <234.667,4,-1103.93>, <236,4,-1103.93>,
<228,4,-1000.6>, <229.333,4,-1000.6>, <234.667,4,-1000.6>, <236,4,-1000.6>,
<228,4,-587.267>, <229.333,4,-587.267>, <234.667,4,-587.267>, <236,4,-587.267>,
<228,4,-483.934>, <229.333,4,-483.934>, <234.667,4,-483.934>, <236,4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<236,4,-1103.93>, <236.333,3.66667,-1103.93>, <237.667,2.33333,-1103.93>, <238,2,-1103.93>,
<236,4,-1000.6>, <236.333,3.66667,-1000.6>, <237.667,2.33333,-1000.6>, <238,2,-1000.6>,
<236,4,-587.267>, <236.333,3.66667,-587.267>, <237.667,2.33333,-587.267>, <238,2,-587.267>,
<236,4,-483.934>, <236.333,3.66667,-483.934>, <237.667,2.33333,-483.934>, <238,2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<238,2,-1103.93>, <238,1.33333,-1103.93>, <238,-1.33333,-1103.93>, <238,-2,-1103.93>,
<238,2,-1000.6>, <238,1.33333,-1000.6>, <238,-1.33333,-1000.6>, <238,-2,-1000.6>,
<238,2,-587.267>, <238,1.33333,-587.267>, <238,-1.33333,-587.267>, <238,-2,-587.267>,
<238,2,-483.934>, <238,1.33333,-483.934>, <238,-1.33333,-483.934>, <238,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<238,-2,-1103.93>, <237.667,-2.33333,-1103.93>, <236.333,-3.66667,-1103.93>, <236,-4,-1103.93>,
<238,-2,-1000.6>, <237.667,-2.33333,-1000.6>, <236.333,-3.66667,-1000.6>, <236,-4,-1000.6>,
<238,-2,-587.267>, <237.667,-2.33333,-587.267>, <236.333,-3.66667,-587.267>, <236,-4,-587.267>,
<238,-2,-483.934>, <237.667,-2.33333,-483.934>, <236.333,-3.66667,-483.934>, <236,-4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<236,-4,-1103.93>, <234.667,-4,-1103.93>, <229.333,-4,-1103.93>, <228,-4,-1103.93>,
<236,-4,-1000.6>, <234.667,-4,-1000.6>, <229.333,-4,-1000.6>, <228,-4,-1000.6>,
<236,-4,-587.267>, <234.667,-4,-587.267>, <229.333,-4,-587.267>, <228,-4,-587.267>,
<236,-4,-483.934>, <234.667,-4,-483.934>, <229.333,-4,-483.934>, <228,-4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<228,-4,-1103.93>, <227.667,-3.66667,-1103.93>, <226.333,-2.33333,-1103.93>, <226,-2,-1103.93>,
<228,-4,-1000.6>, <227.667,-3.66667,-1000.6>, <226.333,-2.33333,-1000.6>, <226,-2,-1000.6>,
<228,-4,-587.267>, <227.667,-3.66667,-587.267>, <226.333,-2.33333,-587.267>, <226,-2,-587.267>,
<228,-4,-483.934>, <227.667,-3.66667,-483.934>, <226.333,-2.33333,-483.934>, <226,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<178,2,-1103.93>, <178,2,-1000.6>, <178,2,-587.267>, <178,2,-483.934>,
<178,1.33333,-1103.93>, <178,1.33333,-1000.6>, <178,1.33333,-587.267>, <178,1.33333,-483.934>,
<178,-1.33333,-1103.93>, <178,-1.33333,-1000.6>, <178,-1.33333,-587.267>, <178,-1.33333,-483.934>,
<178,-2,-1103.93>, <178,-2,-1000.6>, <178,-2,-587.267>, <178,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<178,2,-1103.93>, <178.333,2.33333,-1103.93>, <179.667,3.66667,-1103.93>, <180,4,-1103.93>,
<178,2,-1000.6>, <178.333,2.33333,-1000.6>, <179.667,3.66667,-1000.6>, <180,4,-1000.6>,
<178,2,-587.267>, <178.333,2.33333,-587.267>, <179.667,3.66667,-587.267>, <180,4,-587.267>,
<178,2,-483.934>, <178.333,2.33333,-483.934>, <179.667,3.66667,-483.934>, <180,4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<180,4,-1103.93>, <181.333,4,-1103.93>, <186.667,4,-1103.93>, <188,4,-1103.93>,
<180,4,-1000.6>, <181.333,4,-1000.6>, <186.667,4,-1000.6>, <188,4,-1000.6>,
<180,4,-587.267>, <181.333,4,-587.267>, <186.667,4,-587.267>, <188,4,-587.267>,
<180,4,-483.934>, <181.333,4,-483.934>, <186.667,4,-483.934>, <188,4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<188,4,-1103.93>, <188.333,3.66667,-1103.93>, <189.667,2.33333,-1103.93>, <190,2,-1103.93>,
<188,4,-1000.6>, <188.333,3.66667,-1000.6>, <189.667,2.33333,-1000.6>, <190,2,-1000.6>,
<188,4,-587.267>, <188.333,3.66667,-587.267>, <189.667,2.33333,-587.267>, <190,2,-587.267>,
<188,4,-483.934>, <188.333,3.66667,-483.934>, <189.667,2.33333,-483.934>, <190,2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<190,2,-1103.93>, <190,1.33333,-1103.93>, <190,-1.33333,-1103.93>, <190,-2,-1103.93>,
<190,2,-1000.6>, <190,1.33333,-1000.6>, <190,-1.33333,-1000.6>, <190,-2,-1000.6>,
<190,2,-587.267>, <190,1.33333,-587.267>, <190,-1.33333,-587.267>, <190,-2,-587.267>,
<190,2,-483.934>, <190,1.33333,-483.934>, <190,-1.33333,-483.934>, <190,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<190,-2,-1103.93>, <189.667,-2.33333,-1103.93>, <188.333,-3.66667,-1103.93>, <188,-4,-1103.93>,
<190,-2,-1000.6>, <189.667,-2.33333,-1000.6>, <188.333,-3.66667,-1000.6>, <188,-4,-1000.6>,
<190,-2,-587.267>, <189.667,-2.33333,-587.267>, <188.333,-3.66667,-587.267>, <188,-4,-587.267>,
<190,-2,-483.934>, <189.667,-2.33333,-483.934>, <188.333,-3.66667,-483.934>, <188,-4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<188,-4,-1103.93>, <186.667,-4,-1103.93>, <181.333,-4,-1103.93>, <180,-4,-1103.93>,
<188,-4,-1000.6>, <186.667,-4,-1000.6>, <181.333,-4,-1000.6>, <180,-4,-1000.6>,
<188,-4,-587.267>, <186.667,-4,-587.267>, <181.333,-4,-587.267>, <180,-4,-587.267>,
<188,-4,-483.934>, <186.667,-4,-483.934>, <181.333,-4,-483.934>, <180,-4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<180,-4,-1103.93>, <179.667,-3.66667,-1103.93>, <178.333,-2.33333,-1103.93>, <178,-2,-1103.93>,
<180,-4,-1000.6>, <179.667,-3.66667,-1000.6>, <178.333,-2.33333,-1000.6>, <178,-2,-1000.6>,
<180,-4,-587.267>, <179.667,-3.66667,-587.267>, <178.333,-2.33333,-587.267>, <178,-2,-587.267>,
<180,-4,-483.934>, <179.667,-3.66667,-483.934>, <178.333,-2.33333,-483.934>, <178,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<210,2,-1103.93>, <210,2,-1000.6>, <210,2,-587.267>, <210,2,-483.934>,
<210,1.33333,-1103.93>, <210,1.33333,-1000.6>, <210,1.33333,-587.267>, <210,1.33333,-483.934>,
<210,-1.33333,-1103.93>, <210,-1.33333,-1000.6>, <210,-1.33333,-587.267>, <210,-1.33333,-483.934>,
<210,-2,-1103.93>, <210,-2,-1000.6>, <210,-2,-587.267>, <210,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<210,2,-1103.93>, <210.333,2.33333,-1103.93>, <211.667,3.66667,-1103.93>, <212,4,-1103.93>,
<210,2,-1000.6>, <210.333,2.33333,-1000.6>, <211.667,3.66667,-1000.6>, <212,4,-1000.6>,
<210,2,-587.267>, <210.333,2.33333,-587.267>, <211.667,3.66667,-587.267>, <212,4,-587.267>,
<210,2,-483.934>, <210.333,2.33333,-483.934>, <211.667,3.66667,-483.934>, <212,4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<212,4,-1103.93>, <213.333,4,-1103.93>, <218.667,4,-1103.93>, <220,4,-1103.93>,
<212,4,-1000.6>, <213.333,4,-1000.6>, <218.667,4,-1000.6>, <220,4,-1000.6>,
<212,4,-587.267>, <213.333,4,-587.267>, <218.667,4,-587.267>, <220,4,-587.267>,
<212,4,-483.934>, <213.333,4,-483.934>, <218.667,4,-483.934>, <220,4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<220,4,-1103.93>, <220.333,3.66667,-1103.93>, <221.667,2.33333,-1103.93>, <222,2,-1103.93>,
<220,4,-1000.6>, <220.333,3.66667,-1000.6>, <221.667,2.33333,-1000.6>, <222,2,-1000.6>,
<220,4,-587.267>, <220.333,3.66667,-587.267>, <221.667,2.33333,-587.267>, <222,2,-587.267>,
<220,4,-483.934>, <220.333,3.66667,-483.934>, <221.667,2.33333,-483.934>, <222,2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<222,2,-1103.93>, <222,1.33333,-1103.93>, <222,-1.33333,-1103.93>, <222,-2,-1103.93>,
<222,2,-1000.6>, <222,1.33333,-1000.6>, <222,-1.33333,-1000.6>, <222,-2,-1000.6>,
<222,2,-587.267>, <222,1.33333,-587.267>, <222,-1.33333,-587.267>, <222,-2,-587.267>,
<222,2,-483.934>, <222,1.33333,-483.934>, <222,-1.33333,-483.934>, <222,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<222,-2,-1103.93>, <221.667,-2.33333,-1103.93>, <220.333,-3.66667,-1103.93>, <220,-4,-1103.93>,
<222,-2,-1000.6>, <221.667,-2.33333,-1000.6>, <220.333,-3.66667,-1000.6>, <220,-4,-1000.6>,
<222,-2,-587.267>, <221.667,-2.33333,-587.267>, <220.333,-3.66667,-587.267>, <220,-4,-587.267>,
<222,-2,-483.934>, <221.667,-2.33333,-483.934>, <220.333,-3.66667,-483.934>, <220,-4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<220,-4,-1103.93>, <218.667,-4,-1103.93>, <213.333,-4,-1103.93>, <212,-4,-1103.93>,
<220,-4,-1000.6>, <218.667,-4,-1000.6>, <213.333,-4,-1000.6>, <212,-4,-1000.6>,
<220,-4,-587.267>, <218.667,-4,-587.267>, <213.333,-4,-587.267>, <212,-4,-587.267>,
<220,-4,-483.934>, <218.667,-4,-483.934>, <213.333,-4,-483.934>, <212,-4,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<212,-4,-1103.93>, <211.667,-3.66667,-1103.93>, <210.333,-2.33333,-1103.93>, <210,-2,-1103.93>,
<212,-4,-1000.6>, <211.667,-3.66667,-1000.6>, <210.333,-2.33333,-1000.6>, <210,-2,-1000.6>,
<212,-4,-587.267>, <211.667,-3.66667,-587.267>, <210.333,-2.33333,-587.267>, <210,-2,-587.267>,
<212,-4,-483.934>, <211.667,-3.66667,-483.934>, <210.333,-2.33333,-483.934>, <210,-2,-483.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<321.5,5,-1102.93>, <321.5,3.33333,-1102.93>, <321.5,-3.33333,-1102.93>, <321.5,-5,-1102.93>,
<294.333,5,-1102.93>, <294.333,3.33333,-1102.93>, <294.333,-3.33333,-1102.93>, <294.333,-5,-1102.93>,
<185.667,5,-1102.93>, <185.667,3.33333,-1102.93>, <185.667,-3.33333,-1102.93>, <185.667,-5,-1102.93>,
<158.5,5,-1102.93>, <158.5,3.33333,-1102.93>, <158.5,-3.33333,-1102.93>, <158.5,-5,-1102.93>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,5,-1192.93>, <158.5,5,-1177.93>, <158.5,5,-1117.93>, <158.5,5,-1102.93>,
<158.5,3.33333,-1192.93>, <158.5,3.33333,-1177.93>, <158.5,3.33333,-1117.93>, <158.5,3.33333,-1102.93>,
<158.5,-3.33333,-1192.93>, <158.5,-3.33333,-1177.93>, <158.5,-3.33333,-1117.93>, <158.5,-3.33333,-1102.93>,
<158.5,-5,-1192.93>, <158.5,-5,-1177.93>, <158.5,-5,-1117.93>, <158.5,-5,-1102.93>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,5,-1192.93>, <158.5,3.33333,-1192.93>, <158.5,-3.33333,-1192.93>, <158.5,-5,-1192.93>,
<185.667,5,-1192.93>, <185.667,3.33333,-1192.93>, <185.667,-3.33333,-1192.93>, <185.667,-5,-1192.93>,
<294.333,5,-1192.93>, <294.333,3.33333,-1192.93>, <294.333,-3.33333,-1192.93>, <294.333,-5,-1192.93>,
<321.5,5,-1192.93>, <321.5,3.33333,-1192.93>, <321.5,-3.33333,-1192.93>, <321.5,-5,-1192.93>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<321.5,5,-1192.93>, <321.5,3.33333,-1192.93>, <321.5,-3.33333,-1192.93>, <321.5,-5,-1192.93>,
<321.5,5,-1177.93>, <321.5,3.33333,-1177.93>, <321.5,-3.33333,-1177.93>, <321.5,-5,-1177.93>,
<321.5,5,-1117.93>, <321.5,3.33333,-1117.93>, <321.5,-3.33333,-1117.93>, <321.5,-5,-1117.93>,
<321.5,5,-1102.93>, <321.5,3.33333,-1102.93>, <321.5,-3.33333,-1102.93>, <321.5,-5,-1102.93>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<325,10,-1193.93>, <325,10,-1060.6>, <325,10,-527.267>, <325,10,-393.934>,
<325,6.66667,-1193.93>, <325,6.66667,-1060.6>, <325,6.66667,-527.267>, <325,6.66667,-393.934>,
<325,-6.66667,-1193.93>, <325,-6.66667,-1060.6>, <325,-6.66667,-527.267>, <325,-6.66667,-393.934>,
<325,-10,-1193.93>, <325,-10,-1060.6>, <325,-10,-527.267>, <325,-10,-393.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<325,10,-1193.93>, <325.833,10.8333,-1193.93>, <329.167,14.1667,-1193.93>, <330,15,-1193.93>,
<325,10,-1060.6>, <325.833,10.8333,-1060.6>, <329.167,14.1667,-1060.6>, <330,15,-1060.6>,
<325,10,-527.267>, <325.833,10.8333,-527.267>, <329.167,14.1667,-527.267>, <330,15,-527.267>,
<325,10,-393.934>, <325.833,10.8333,-393.934>, <329.167,14.1667,-393.934>, <330,15,-393.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<325,10,-1193.93>, <325,6.66667,-1193.93>, <325,-6.66667,-1193.93>, <325,-10,-1193.93>,
<325.833,10.8333,-1193.93>, <325.833,6.94444,-1193.93>, <325.833,-6.94444,-1193.93>, <325.833,-10.8333,-1193.93>,
<329.167,14.1667,-1193.93>, <329.167,9.72222,-1193.93>, <329.167,-9.72222,-1193.93>, <329.167,-14.1667,-1193.93>,
<330,15,-1193.93>, <330,10,-1193.93>, <330,-10,-1193.93>, <330,-15,-1193.93>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<330,15,-1193.93>, <330,10,-1193.93>, <330,-10,-1193.93>, <330,-15,-1193.93>,
<333.333,15,-1193.93>, <333.333,10,-1193.93>, <333.333,-10,-1193.93>, <333.333,-15,-1193.93>,
<346.667,15,-1193.93>, <346.667,10,-1193.93>, <346.667,-10,-1193.93>, <346.667,-15,-1193.93>,
<350,15,-1193.93>, <350,10,-1193.93>, <350,-10,-1193.93>, <350,-15,-1193.93>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<330,15,-1193.93>, <333.333,15,-1193.93>, <346.667,15,-1193.93>, <350,15,-1193.93>,
<330,15,-1060.6>, <333.333,15,-1060.6>, <346.667,15,-1060.6>, <350,15,-1060.6>,
<330,15,-527.267>, <333.333,15,-527.267>, <346.667,15,-527.267>, <350,15,-527.267>,
<330,15,-393.934>, <333.333,15,-393.934>, <346.667,15,-393.934>, <350,15,-393.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<350,15,-1193.93>, <350,10,-1193.93>, <350,-10,-1193.93>, <350,-15,-1193.93>,
<350.833,14.1667,-1193.93>, <350.833,9.72222,-1193.93>, <350.833,-9.72222,-1193.93>, <350.833,-14.1667,-1193.93>,
<354.167,10.8333,-1193.93>, <354.167,6.94444,-1193.93>, <354.167,-6.94444,-1193.93>, <354.167,-10.8333,-1193.93>,
<355,10,-1193.93>, <355,6.66667,-1193.93>, <355,-6.66667,-1193.93>, <355,-10,-1193.93>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<350,15,-1193.93>, <350.833,14.1667,-1193.93>, <354.167,10.8333,-1193.93>, <355,10,-1193.93>,
<350,15,-1060.6>, <350.833,14.1667,-1060.6>, <354.167,10.8333,-1060.6>, <355,10,-1060.6>,
<350,15,-527.267>, <350.833,14.1667,-527.267>, <354.167,10.8333,-527.267>, <355,10,-527.267>,
<350,15,-393.934>, <350.833,14.1667,-393.934>, <354.167,10.8333,-393.934>, <355,10,-393.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<355,10,-1193.93>, <355,6.66667,-1193.93>, <355,-6.66667,-1193.93>, <355,-10,-1193.93>,
<355,10,-1060.6>, <355,6.66667,-1060.6>, <355,-6.66667,-1060.6>, <355,-10,-1060.6>,
<355,10,-527.267>, <355,6.66667,-527.267>, <355,-6.66667,-527.267>, <355,-10,-527.267>,
<355,10,-393.934>, <355,6.66667,-393.934>, <355,-6.66667,-393.934>, <355,-10,-393.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<355,-10,-1193.93>, <354.167,-10.8333,-1193.93>, <350.833,-14.1667,-1193.93>, <350,-15,-1193.93>,
<355,-10,-1060.6>, <354.167,-10.8333,-1060.6>, <350.833,-14.1667,-1060.6>, <350,-15,-1060.6>,
<355,-10,-527.267>, <354.167,-10.8333,-527.267>, <350.833,-14.1667,-527.267>, <350,-15,-527.267>,
<355,-10,-393.934>, <354.167,-10.8333,-393.934>, <350.833,-14.1667,-393.934>, <350,-15,-393.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<350,-15,-1193.93>, <346.667,-15,-1193.93>, <333.333,-15,-1193.93>, <330,-15,-1193.93>,
<350,-15,-1060.6>, <346.667,-15,-1060.6>, <333.333,-15,-1060.6>, <330,-15,-1060.6>,
<350,-15,-527.267>, <346.667,-15,-527.267>, <333.333,-15,-527.267>, <330,-15,-527.267>,
<350,-15,-393.934>, <346.667,-15,-393.934>, <333.333,-15,-393.934>, <330,-15,-393.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<330,-15,-1193.93>, <329.167,-14.1667,-1193.93>, <325.833,-10.8333,-1193.93>, <325,-10,-1193.93>,
<330,-15,-1060.6>, <329.167,-14.1667,-1060.6>, <325.833,-10.8333,-1060.6>, <325,-10,-1060.6>,
<330,-15,-527.267>, <329.167,-14.1667,-527.267>, <325.833,-10.8333,-527.267>, <325,-10,-527.267>,
<330,-15,-393.934>, <329.167,-14.1667,-393.934>, <325.833,-10.8333,-393.934>, <325,-10,-393.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<130,-15,-393.934>, <130,-10,-393.934>, <130,10,-393.934>, <130,15,-393.934>,
<129.167,-14.1667,-393.934>, <129.167,-9.72222,-393.934>, <129.167,9.72222,-393.934>, <129.167,14.1667,-393.934>,
<125.833,-10.8333,-393.934>, <125.833,-6.94444,-393.934>, <125.833,6.94444,-393.934>, <125.833,10.8333,-393.934>,
<125,-10,-393.934>, <125,-6.66667,-393.934>, <125,6.66667,-393.934>, <125,10,-393.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<150,-15,-393.934>, <150,-10,-393.934>, <150,10,-393.934>, <150,15,-393.934>,
<146.667,-15,-393.934>, <146.667,-10,-393.934>, <146.667,10,-393.934>, <146.667,15,-393.934>,
<133.333,-15,-393.934>, <133.333,-10,-393.934>, <133.333,10,-393.934>, <133.333,15,-393.934>,
<130,-15,-393.934>, <130,-10,-393.934>, <130,10,-393.934>, <130,15,-393.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<155,10,-393.934>, <154.167,10.8333,-393.934>, <150.833,14.1667,-393.934>, <150,15,-393.934>,
<155,6.66667,-393.934>, <154.167,6.94444,-393.934>, <150.833,9.72222,-393.934>, <150,10,-393.934>,
<155,-6.66667,-393.934>, <154.167,-6.94444,-393.934>, <150.833,-9.72222,-393.934>, <150,-10,-393.934>,
<155,-10,-393.934>, <154.167,-10.8333,-393.934>, <150.833,-14.1667,-393.934>, <150,-15,-393.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<325,10,-393.934>, <325.833,10.8333,-393.934>, <329.167,14.1667,-393.934>, <330,15,-393.934>,
<325,6.66667,-393.934>, <325.833,6.94444,-393.934>, <329.167,9.72222,-393.934>, <330,10,-393.934>,
<325,-6.66667,-393.934>, <325.833,-6.94444,-393.934>, <329.167,-9.72222,-393.934>, <330,-10,-393.934>,
<325,-10,-393.934>, <325.833,-10.8333,-393.934>, <329.167,-14.1667,-393.934>, <330,-15,-393.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<350,-15,-393.934>, <346.667,-15,-393.934>, <333.333,-15,-393.934>, <330,-15,-393.934>,
<350,-10,-393.934>, <346.667,-10,-393.934>, <333.333,-10,-393.934>, <330,-10,-393.934>,
<350,10,-393.934>, <346.667,10,-393.934>, <333.333,10,-393.934>, <330,10,-393.934>,
<350,15,-393.934>, <346.667,15,-393.934>, <333.333,15,-393.934>, <330,15,-393.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<355,10,-393.934>, <355,6.66667,-393.934>, <355,-6.66667,-393.934>, <355,-10,-393.934>,
<354.167,10.8333,-393.934>, <354.167,6.94444,-393.934>, <354.167,-6.94444,-393.934>, <354.167,-10.8333,-393.934>,
<350.833,14.1667,-393.934>, <350.833,9.72222,-393.934>, <350.833,-9.72222,-393.934>, <350.833,-14.1667,-393.934>,
<350,15,-393.934>, <350,10,-393.934>, <350,-10,-393.934>, <350,-15,-393.934>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-350,14.5249,-1196.97>, <-350,9.5249,-1196.97>, <-350,-10.4751,-1196.97>, <-350,-15.4751,-1196.97>,
<-350.833,13.6916,-1196.97>, <-350.833,9.24712,-1196.97>, <-350.833,-10.1973,-1196.97>, <-350.833,-14.6418,-1196.97>,
<-354.167,10.3582,-1196.97>, <-354.167,6.46933,-1196.97>, <-354.167,-7.41955,-1196.97>, <-354.167,-11.3084,-1196.97>,
<-355,9.52488,-1196.97>, <-355,6.19155,-1196.97>, <-355,-7.14177,-1196.97>, <-355,-10.4751,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-350,14.5249,-1196.97>, <-350.833,13.6916,-1196.97>, <-354.167,10.3582,-1196.97>, <-355,9.52488,-1196.97>,
<-350,14.5249,-1063.64>, <-350.833,13.6916,-1063.64>, <-354.167,10.3582,-1063.64>, <-355,9.52488,-1063.64>,
<-350,14.5249,-530.301>, <-350.833,13.6916,-530.301>, <-354.167,10.3582,-530.301>, <-355,9.52488,-530.301>,
<-350,14.5249,-396.967>, <-350.833,13.6916,-396.967>, <-354.167,10.3582,-396.967>, <-355,9.52488,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-350,14.5249,-1196.97>, <-346.667,14.5249,-1196.97>, <-333.333,14.5249,-1196.97>, <-330,14.5249,-1196.97>,
<-350,9.5249,-1196.97>, <-346.667,9.5249,-1196.97>, <-333.333,9.5249,-1196.97>, <-330,9.5249,-1196.97>,
<-350,-10.4751,-1196.97>, <-346.667,-10.4751,-1196.97>, <-333.333,-10.4751,-1196.97>, <-330,-10.4751,-1196.97>,
<-350,-15.4751,-1196.97>, <-346.667,-15.4751,-1196.97>, <-333.333,-15.4751,-1196.97>, <-330,-15.4751,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-350,14.5249,-1196.97>, <-350,14.5249,-1063.64>, <-350,14.5249,-530.301>, <-350,14.5249,-396.967>,
<-346.667,14.5249,-1196.97>, <-346.667,14.5249,-1063.64>, <-346.667,14.5249,-530.301>, <-346.667,14.5249,-396.967>,
<-333.333,14.5249,-1196.97>, <-333.333,14.5249,-1063.64>, <-333.333,14.5249,-530.301>, <-333.333,14.5249,-396.967>,
<-330,14.5249,-1196.97>, <-330,14.5249,-1063.64>, <-330,14.5249,-530.301>, <-330,14.5249,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-330,14.5249,-1196.97>, <-329.167,13.6916,-1196.97>, <-325.833,10.3582,-1196.97>, <-325,9.52488,-1196.97>,
<-330,9.5249,-1196.97>, <-329.167,9.24712,-1196.97>, <-325.833,6.46933,-1196.97>, <-325,6.19155,-1196.97>,
<-330,-10.4751,-1196.97>, <-329.167,-10.1973,-1196.97>, <-325.833,-7.41955,-1196.97>, <-325,-7.14177,-1196.97>,
<-330,-15.4751,-1196.97>, <-329.167,-14.6418,-1196.97>, <-325.833,-11.3084,-1196.97>, <-325,-10.4751,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-330,14.5249,-1196.97>, <-330,14.5249,-1063.64>, <-330,14.5249,-530.301>, <-330,14.5249,-396.967>,
<-329.167,13.6916,-1196.97>, <-329.167,13.6916,-1063.64>, <-329.167,13.6916,-530.301>, <-329.167,13.6916,-396.967>,
<-325.833,10.3582,-1196.97>, <-325.833,10.3582,-1063.64>, <-325.833,10.3582,-530.301>, <-325.833,10.3582,-396.967>,
<-325,9.52488,-1196.97>, <-325,9.52488,-1063.64>, <-325,9.52488,-530.301>, <-325,9.52488,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-325,9.52488,-1196.97>, <-325,9.52488,-1063.64>, <-325,9.52488,-530.301>, <-325,9.52488,-396.967>,
<-325,6.19155,-1196.97>, <-325,6.19155,-1063.64>, <-325,6.19155,-530.301>, <-325,6.19155,-396.967>,
<-325,-7.14177,-1196.97>, <-325,-7.14177,-1063.64>, <-325,-7.14177,-530.301>, <-325,-7.14177,-396.967>,
<-325,-10.4751,-1196.97>, <-325,-10.4751,-1063.64>, <-325,-10.4751,-530.301>, <-325,-10.4751,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-325,-10.4751,-1196.97>, <-325,-10.4751,-1063.64>, <-325,-10.4751,-530.301>, <-325,-10.4751,-396.967>,
<-325.833,-11.3084,-1196.97>, <-325.833,-11.3084,-1063.64>, <-325.833,-11.3084,-530.301>, <-325.833,-11.3084,-396.967>,
<-329.167,-14.6418,-1196.97>, <-329.167,-14.6418,-1063.64>, <-329.167,-14.6418,-530.301>, <-329.167,-14.6418,-396.967>,
<-330,-15.4751,-1196.97>, <-330,-15.4751,-1063.64>, <-330,-15.4751,-530.301>, <-330,-15.4751,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-330,-15.4751,-1196.97>, <-330,-15.4751,-1063.64>, <-330,-15.4751,-530.301>, <-330,-15.4751,-396.967>,
<-333.333,-15.4751,-1196.97>, <-333.333,-15.4751,-1063.64>, <-333.333,-15.4751,-530.301>, <-333.333,-15.4751,-396.967>,
<-346.667,-15.4751,-1196.97>, <-346.667,-15.4751,-1063.64>, <-346.667,-15.4751,-530.301>, <-346.667,-15.4751,-396.967>,
<-350,-15.4751,-1196.97>, <-350,-15.4751,-1063.64>, <-350,-15.4751,-530.301>, <-350,-15.4751,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-350,-15.4751,-1196.97>, <-350,-15.4751,-1063.64>, <-350,-15.4751,-530.301>, <-350,-15.4751,-396.967>,
<-350.833,-14.6418,-1196.97>, <-350.833,-14.6418,-1063.64>, <-350.833,-14.6418,-530.301>, <-350.833,-14.6418,-396.967>,
<-354.167,-11.3084,-1196.97>, <-354.167,-11.3084,-1063.64>, <-354.167,-11.3084,-530.301>, <-354.167,-11.3084,-396.967>,
<-355,-10.4751,-1196.97>, <-355,-10.4751,-1063.64>, <-355,-10.4751,-530.301>, <-355,-10.4751,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-355,-10.4751,-1196.97>, <-355,-10.4751,-1063.64>, <-355,-10.4751,-530.301>, <-355,-10.4751,-396.967>,
<-355,-7.14177,-1196.97>, <-355,-7.14177,-1063.64>, <-355,-7.14177,-530.301>, <-355,-7.14177,-396.967>,
<-355,6.19155,-1196.97>, <-355,6.19155,-1063.64>, <-355,6.19155,-530.301>, <-355,6.19155,-396.967>,
<-355,9.52488,-1196.97>, <-355,9.52488,-1063.64>, <-355,9.52488,-530.301>, <-355,9.52488,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,4.52488,-487.967>, <-321.5,4.52488,-472.967>, <-321.5,4.52488,-412.967>, <-321.5,4.52488,-397.967>,
<-321.5,2.85821,-487.967>, <-321.5,2.85821,-472.967>, <-321.5,2.85821,-412.967>, <-321.5,2.85821,-397.967>,
<-321.5,-3.80845,-487.967>, <-321.5,-3.80845,-472.967>, <-321.5,-3.80845,-412.967>, <-321.5,-3.80845,-397.967>,
<-321.5,-5.47512,-487.967>, <-321.5,-5.47512,-472.967>, <-321.5,-5.47512,-412.967>, <-321.5,-5.47512,-397.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,4.52488,-487.967>, <-321.5,2.85821,-487.967>, <-321.5,-3.80845,-487.967>, <-321.5,-5.47512,-487.967>,
<-294.333,4.52488,-487.967>, <-294.333,2.85821,-487.967>, <-294.333,-3.80845,-487.967>, <-294.333,-5.47512,-487.967>,
<-185.667,4.52488,-487.967>, <-185.667,2.85821,-487.967>, <-185.667,-3.80845,-487.967>, <-185.667,-5.47512,-487.967>,
<-158.5,4.52488,-487.967>, <-158.5,2.85821,-487.967>, <-158.5,-3.80845,-487.967>, <-158.5,-5.47512,-487.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-158.5,4.52488,-487.967>, <-158.5,2.85821,-487.967>, <-158.5,-3.80845,-487.967>, <-158.5,-5.47512,-487.967>,
<-158.5,4.52488,-472.967>, <-158.5,2.85821,-472.967>, <-158.5,-3.80845,-472.967>, <-158.5,-5.47512,-472.967>,
<-158.5,4.52488,-412.967>, <-158.5,2.85821,-412.967>, <-158.5,-3.80845,-412.967>, <-158.5,-5.47512,-412.967>,
<-158.5,4.52488,-397.967>, <-158.5,2.85821,-397.967>, <-158.5,-3.80845,-397.967>, <-158.5,-5.47512,-397.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-158.5,4.52488,-397.967>, <-158.5,2.85821,-397.967>, <-158.5,-3.80845,-397.967>, <-158.5,-5.47512,-397.967>,
<-185.667,4.52488,-397.967>, <-185.667,2.85821,-397.967>, <-185.667,-3.80845,-397.967>, <-185.667,-5.47512,-397.967>,
<-294.333,4.52488,-397.967>, <-294.333,2.85821,-397.967>, <-294.333,-3.80845,-397.967>, <-294.333,-5.47512,-397.967>,
<-321.5,4.52488,-397.967>, <-321.5,2.85821,-397.967>, <-321.5,-3.80845,-397.967>, <-321.5,-5.47512,-397.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-190,1.52488,-1106.97>, <-190,0.858213,-1106.97>, <-190,-1.80845,-1106.97>, <-190,-2.47512,-1106.97>,
<-190,1.52488,-1003.64>, <-190,0.858213,-1003.64>, <-190,-1.80845,-1003.64>, <-190,-2.47512,-1003.64>,
<-190,1.52488,-590.301>, <-190,0.858213,-590.301>, <-190,-1.80845,-590.301>, <-190,-2.47512,-590.301>,
<-190,1.52488,-486.967>, <-190,0.858213,-486.967>, <-190,-1.80845,-486.967>, <-190,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-190,1.52488,-1106.97>, <-190,1.52488,-1003.64>, <-190,1.52488,-590.301>, <-190,1.52488,-486.967>,
<-189.667,1.85821,-1106.97>, <-189.667,1.85821,-1003.64>, <-189.667,1.85821,-590.301>, <-189.667,1.85821,-486.967>,
<-188.333,3.19155,-1106.97>, <-188.333,3.19155,-1003.64>, <-188.333,3.19155,-590.301>, <-188.333,3.19155,-486.967>,
<-188,3.52488,-1106.97>, <-188,3.52488,-1003.64>, <-188,3.52488,-590.301>, <-188,3.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-188,3.52488,-1106.97>, <-188,3.52488,-1003.64>, <-188,3.52488,-590.301>, <-188,3.52488,-486.967>,
<-186.667,3.52488,-1106.97>, <-186.667,3.52488,-1003.64>, <-186.667,3.52488,-590.301>, <-186.667,3.52488,-486.967>,
<-181.333,3.52488,-1106.97>, <-181.333,3.52488,-1003.64>, <-181.333,3.52488,-590.301>, <-181.333,3.52488,-486.967>,
<-180,3.52488,-1106.97>, <-180,3.52488,-1003.64>, <-180,3.52488,-590.301>, <-180,3.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-180,3.52488,-1106.97>, <-180,3.52488,-1003.64>, <-180,3.52488,-590.301>, <-180,3.52488,-486.967>,
<-179.667,3.19155,-1106.97>, <-179.667,3.19155,-1003.64>, <-179.667,3.19155,-590.301>, <-179.667,3.19155,-486.967>,
<-178.333,1.85821,-1106.97>, <-178.333,1.85821,-1003.64>, <-178.333,1.85821,-590.301>, <-178.333,1.85821,-486.967>,
<-178,1.52488,-1106.97>, <-178,1.52488,-1003.64>, <-178,1.52488,-590.301>, <-178,1.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-178,1.52488,-1106.97>, <-178,1.52488,-1003.64>, <-178,1.52488,-590.301>, <-178,1.52488,-486.967>,
<-178,0.858213,-1106.97>, <-178,0.858213,-1003.64>, <-178,0.858213,-590.301>, <-178,0.858213,-486.967>,
<-178,-1.80845,-1106.97>, <-178,-1.80845,-1003.64>, <-178,-1.80845,-590.301>, <-178,-1.80845,-486.967>,
<-178,-2.47512,-1106.97>, <-178,-2.47512,-1003.64>, <-178,-2.47512,-590.301>, <-178,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-178,-2.47512,-1106.97>, <-178,-2.47512,-1003.64>, <-178,-2.47512,-590.301>, <-178,-2.47512,-486.967>,
<-178.333,-2.80845,-1106.97>, <-178.333,-2.80845,-1003.64>, <-178.333,-2.80845,-590.301>, <-178.333,-2.80845,-486.967>,
<-179.667,-4.14179,-1106.97>, <-179.667,-4.14179,-1003.64>, <-179.667,-4.14179,-590.301>, <-179.667,-4.14179,-486.967>,
<-180,-4.47512,-1106.97>, <-180,-4.47512,-1003.64>, <-180,-4.47512,-590.301>, <-180,-4.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-180,-4.47512,-1106.97>, <-180,-4.47512,-1003.64>, <-180,-4.47512,-590.301>, <-180,-4.47512,-486.967>,
<-181.333,-4.47512,-1106.97>, <-181.333,-4.47512,-1003.64>, <-181.333,-4.47512,-590.301>, <-181.333,-4.47512,-486.967>,
<-186.667,-4.47512,-1106.97>, <-186.667,-4.47512,-1003.64>, <-186.667,-4.47512,-590.301>, <-186.667,-4.47512,-486.967>,
<-188,-4.47512,-1106.97>, <-188,-4.47512,-1003.64>, <-188,-4.47512,-590.301>, <-188,-4.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-188,-4.47512,-1106.97>, <-188,-4.47512,-1003.64>, <-188,-4.47512,-590.301>, <-188,-4.47512,-486.967>,
<-188.333,-4.14179,-1106.97>, <-188.333,-4.14179,-1003.64>, <-188.333,-4.14179,-590.301>, <-188.333,-4.14179,-486.967>,
<-189.667,-2.80845,-1106.97>, <-189.667,-2.80845,-1003.64>, <-189.667,-2.80845,-590.301>, <-189.667,-2.80845,-486.967>,
<-190,-2.47512,-1106.97>, <-190,-2.47512,-1003.64>, <-190,-2.47512,-590.301>, <-190,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-222,1.52488,-1106.97>, <-222,0.858213,-1106.97>, <-222,-1.80845,-1106.97>, <-222,-2.47512,-1106.97>,
<-222,1.52488,-1003.64>, <-222,0.858213,-1003.64>, <-222,-1.80845,-1003.64>, <-222,-2.47512,-1003.64>,
<-222,1.52488,-590.301>, <-222,0.858213,-590.301>, <-222,-1.80845,-590.301>, <-222,-2.47512,-590.301>,
<-222,1.52488,-486.967>, <-222,0.858213,-486.967>, <-222,-1.80845,-486.967>, <-222,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-222,1.52488,-1106.97>, <-222,1.52488,-1003.64>, <-222,1.52488,-590.301>, <-222,1.52488,-486.967>,
<-221.667,1.85821,-1106.97>, <-221.667,1.85821,-1003.64>, <-221.667,1.85821,-590.301>, <-221.667,1.85821,-486.967>,
<-220.333,3.19155,-1106.97>, <-220.333,3.19155,-1003.64>, <-220.333,3.19155,-590.301>, <-220.333,3.19155,-486.967>,
<-220,3.52488,-1106.97>, <-220,3.52488,-1003.64>, <-220,3.52488,-590.301>, <-220,3.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-220,3.52488,-1106.97>, <-220,3.52488,-1003.64>, <-220,3.52488,-590.301>, <-220,3.52488,-486.967>,
<-218.667,3.52488,-1106.97>, <-218.667,3.52488,-1003.64>, <-218.667,3.52488,-590.301>, <-218.667,3.52488,-486.967>,
<-213.333,3.52488,-1106.97>, <-213.333,3.52488,-1003.64>, <-213.333,3.52488,-590.301>, <-213.333,3.52488,-486.967>,
<-212,3.52488,-1106.97>, <-212,3.52488,-1003.64>, <-212,3.52488,-590.301>, <-212,3.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-212,3.52488,-1106.97>, <-212,3.52488,-1003.64>, <-212,3.52488,-590.301>, <-212,3.52488,-486.967>,
<-211.667,3.19155,-1106.97>, <-211.667,3.19155,-1003.64>, <-211.667,3.19155,-590.301>, <-211.667,3.19155,-486.967>,
<-210.333,1.85821,-1106.97>, <-210.333,1.85821,-1003.64>, <-210.333,1.85821,-590.301>, <-210.333,1.85821,-486.967>,
<-210,1.52488,-1106.97>, <-210,1.52488,-1003.64>, <-210,1.52488,-590.301>, <-210,1.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-210,1.52488,-1106.97>, <-210,1.52488,-1003.64>, <-210,1.52488,-590.301>, <-210,1.52488,-486.967>,
<-210,0.858213,-1106.97>, <-210,0.858213,-1003.64>, <-210,0.858213,-590.301>, <-210,0.858213,-486.967>,
<-210,-1.80845,-1106.97>, <-210,-1.80845,-1003.64>, <-210,-1.80845,-590.301>, <-210,-1.80845,-486.967>,
<-210,-2.47512,-1106.97>, <-210,-2.47512,-1003.64>, <-210,-2.47512,-590.301>, <-210,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-210,-2.47512,-1106.97>, <-210,-2.47512,-1003.64>, <-210,-2.47512,-590.301>, <-210,-2.47512,-486.967>,
<-210.333,-2.80845,-1106.97>, <-210.333,-2.80845,-1003.64>, <-210.333,-2.80845,-590.301>, <-210.333,-2.80845,-486.967>,
<-211.667,-4.14179,-1106.97>, <-211.667,-4.14179,-1003.64>, <-211.667,-4.14179,-590.301>, <-211.667,-4.14179,-486.967>,
<-212,-4.47512,-1106.97>, <-212,-4.47512,-1003.64>, <-212,-4.47512,-590.301>, <-212,-4.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-212,-4.47512,-1106.97>, <-212,-4.47512,-1003.64>, <-212,-4.47512,-590.301>, <-212,-4.47512,-486.967>,
<-213.333,-4.47512,-1106.97>, <-213.333,-4.47512,-1003.64>, <-213.333,-4.47512,-590.301>, <-213.333,-4.47512,-486.967>,
<-218.667,-4.47512,-1106.97>, <-218.667,-4.47512,-1003.64>, <-218.667,-4.47512,-590.301>, <-218.667,-4.47512,-486.967>,
<-220,-4.47512,-1106.97>, <-220,-4.47512,-1003.64>, <-220,-4.47512,-590.301>, <-220,-4.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-220,-4.47512,-1106.97>, <-220,-4.47512,-1003.64>, <-220,-4.47512,-590.301>, <-220,-4.47512,-486.967>,
<-220.333,-4.14179,-1106.97>, <-220.333,-4.14179,-1003.64>, <-220.333,-4.14179,-590.301>, <-220.333,-4.14179,-486.967>,
<-221.667,-2.80845,-1106.97>, <-221.667,-2.80845,-1003.64>, <-221.667,-2.80845,-590.301>, <-221.667,-2.80845,-486.967>,
<-222,-2.47512,-1106.97>, <-222,-2.47512,-1003.64>, <-222,-2.47512,-590.301>, <-222,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-174,1.52488,-1106.97>, <-174,0.858213,-1106.97>, <-174,-1.80845,-1106.97>, <-174,-2.47512,-1106.97>,
<-174,1.52488,-1003.64>, <-174,0.858213,-1003.64>, <-174,-1.80845,-1003.64>, <-174,-2.47512,-1003.64>,
<-174,1.52488,-590.301>, <-174,0.858213,-590.301>, <-174,-1.80845,-590.301>, <-174,-2.47512,-590.301>,
<-174,1.52488,-486.967>, <-174,0.858213,-486.967>, <-174,-1.80845,-486.967>, <-174,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-174,1.52488,-1106.97>, <-174,1.52488,-1003.64>, <-174,1.52488,-590.301>, <-174,1.52488,-486.967>,
<-173.667,1.85821,-1106.97>, <-173.667,1.85821,-1003.64>, <-173.667,1.85821,-590.301>, <-173.667,1.85821,-486.967>,
<-172.333,3.19155,-1106.97>, <-172.333,3.19155,-1003.64>, <-172.333,3.19155,-590.301>, <-172.333,3.19155,-486.967>,
<-172,3.52488,-1106.97>, <-172,3.52488,-1003.64>, <-172,3.52488,-590.301>, <-172,3.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-172,3.52488,-1106.97>, <-172,3.52488,-1003.64>, <-172,3.52488,-590.301>, <-172,3.52488,-486.967>,
<-170.667,3.52488,-1106.97>, <-170.667,3.52488,-1003.64>, <-170.667,3.52488,-590.301>, <-170.667,3.52488,-486.967>,
<-165.333,3.52488,-1106.97>, <-165.333,3.52488,-1003.64>, <-165.333,3.52488,-590.301>, <-165.333,3.52488,-486.967>,
<-164,3.52488,-1106.97>, <-164,3.52488,-1003.64>, <-164,3.52488,-590.301>, <-164,3.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-164,3.52488,-1106.97>, <-164,3.52488,-1003.64>, <-164,3.52488,-590.301>, <-164,3.52488,-486.967>,
<-163.667,3.19155,-1106.97>, <-163.667,3.19155,-1003.64>, <-163.667,3.19155,-590.301>, <-163.667,3.19155,-486.967>,
<-162.333,1.85821,-1106.97>, <-162.333,1.85821,-1003.64>, <-162.333,1.85821,-590.301>, <-162.333,1.85821,-486.967>,
<-162,1.52488,-1106.97>, <-162,1.52488,-1003.64>, <-162,1.52488,-590.301>, <-162,1.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-162,1.52488,-1106.97>, <-162,1.52488,-1003.64>, <-162,1.52488,-590.301>, <-162,1.52488,-486.967>,
<-162,0.858213,-1106.97>, <-162,0.858213,-1003.64>, <-162,0.858213,-590.301>, <-162,0.858213,-486.967>,
<-162,-1.80845,-1106.97>, <-162,-1.80845,-1003.64>, <-162,-1.80845,-590.301>, <-162,-1.80845,-486.967>,
<-162,-2.47512,-1106.97>, <-162,-2.47512,-1003.64>, <-162,-2.47512,-590.301>, <-162,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-162,-2.47512,-1106.97>, <-162,-2.47512,-1003.64>, <-162,-2.47512,-590.301>, <-162,-2.47512,-486.967>,
<-162.333,-2.80845,-1106.97>, <-162.333,-2.80845,-1003.64>, <-162.333,-2.80845,-590.301>, <-162.333,-2.80845,-486.967>,
<-163.667,-4.14179,-1106.97>, <-163.667,-4.14179,-1003.64>, <-163.667,-4.14179,-590.301>, <-163.667,-4.14179,-486.967>,
<-164,-4.47512,-1106.97>, <-164,-4.47512,-1003.64>, <-164,-4.47512,-590.301>, <-164,-4.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-164,-4.47512,-1106.97>, <-164,-4.47512,-1003.64>, <-164,-4.47512,-590.301>, <-164,-4.47512,-486.967>,
<-165.333,-4.47512,-1106.97>, <-165.333,-4.47512,-1003.64>, <-165.333,-4.47512,-590.301>, <-165.333,-4.47512,-486.967>,
<-170.667,-4.47512,-1106.97>, <-170.667,-4.47512,-1003.64>, <-170.667,-4.47512,-590.301>, <-170.667,-4.47512,-486.967>,
<-172,-4.47512,-1106.97>, <-172,-4.47512,-1003.64>, <-172,-4.47512,-590.301>, <-172,-4.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-172,-4.47512,-1106.97>, <-172,-4.47512,-1003.64>, <-172,-4.47512,-590.301>, <-172,-4.47512,-486.967>,
<-172.333,-4.14179,-1106.97>, <-172.333,-4.14179,-1003.64>, <-172.333,-4.14179,-590.301>, <-172.333,-4.14179,-486.967>,
<-173.667,-2.80845,-1106.97>, <-173.667,-2.80845,-1003.64>, <-173.667,-2.80845,-590.301>, <-173.667,-2.80845,-486.967>,
<-174,-2.47512,-1106.97>, <-174,-2.47512,-1003.64>, <-174,-2.47512,-590.301>, <-174,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-238,1.52488,-1106.97>, <-238,0.858213,-1106.97>, <-238,-1.80845,-1106.97>, <-238,-2.47512,-1106.97>,
<-238,1.52488,-1003.64>, <-238,0.858213,-1003.64>, <-238,-1.80845,-1003.64>, <-238,-2.47512,-1003.64>,
<-238,1.52488,-590.301>, <-238,0.858213,-590.301>, <-238,-1.80845,-590.301>, <-238,-2.47512,-590.301>,
<-238,1.52488,-486.967>, <-238,0.858213,-486.967>, <-238,-1.80845,-486.967>, <-238,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-238,1.52488,-1106.97>, <-238,1.52488,-1003.64>, <-238,1.52488,-590.301>, <-238,1.52488,-486.967>,
<-237.667,1.85821,-1106.97>, <-237.667,1.85821,-1003.64>, <-237.667,1.85821,-590.301>, <-237.667,1.85821,-486.967>,
<-236.333,3.19155,-1106.97>, <-236.333,3.19155,-1003.64>, <-236.333,3.19155,-590.301>, <-236.333,3.19155,-486.967>,
<-236,3.52488,-1106.97>, <-236,3.52488,-1003.64>, <-236,3.52488,-590.301>, <-236,3.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-236,3.52488,-1106.97>, <-236,3.52488,-1003.64>, <-236,3.52488,-590.301>, <-236,3.52488,-486.967>,
<-234.667,3.52488,-1106.97>, <-234.667,3.52488,-1003.64>, <-234.667,3.52488,-590.301>, <-234.667,3.52488,-486.967>,
<-229.333,3.52488,-1106.97>, <-229.333,3.52488,-1003.64>, <-229.333,3.52488,-590.301>, <-229.333,3.52488,-486.967>,
<-228,3.52488,-1106.97>, <-228,3.52488,-1003.64>, <-228,3.52488,-590.301>, <-228,3.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-228,3.52488,-1106.97>, <-228,3.52488,-1003.64>, <-228,3.52488,-590.301>, <-228,3.52488,-486.967>,
<-227.667,3.19155,-1106.97>, <-227.667,3.19155,-1003.64>, <-227.667,3.19155,-590.301>, <-227.667,3.19155,-486.967>,
<-226.333,1.85821,-1106.97>, <-226.333,1.85821,-1003.64>, <-226.333,1.85821,-590.301>, <-226.333,1.85821,-486.967>,
<-226,1.52488,-1106.97>, <-226,1.52488,-1003.64>, <-226,1.52488,-590.301>, <-226,1.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-226,1.52488,-1106.97>, <-226,1.52488,-1003.64>, <-226,1.52488,-590.301>, <-226,1.52488,-486.967>,
<-226,0.858213,-1106.97>, <-226,0.858213,-1003.64>, <-226,0.858213,-590.301>, <-226,0.858213,-486.967>,
<-226,-1.80845,-1106.97>, <-226,-1.80845,-1003.64>, <-226,-1.80845,-590.301>, <-226,-1.80845,-486.967>,
<-226,-2.47512,-1106.97>, <-226,-2.47512,-1003.64>, <-226,-2.47512,-590.301>, <-226,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-226,-2.47512,-1106.97>, <-226,-2.47512,-1003.64>, <-226,-2.47512,-590.301>, <-226,-2.47512,-486.967>,
<-226.333,-2.80845,-1106.97>, <-226.333,-2.80845,-1003.64>, <-226.333,-2.80845,-590.301>, <-226.333,-2.80845,-486.967>,
<-227.667,-4.14179,-1106.97>, <-227.667,-4.14179,-1003.64>, <-227.667,-4.14179,-590.301>, <-227.667,-4.14179,-486.967>,
<-228,-4.47512,-1106.97>, <-228,-4.47512,-1003.64>, <-228,-4.47512,-590.301>, <-228,-4.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-228,-4.47512,-1106.97>, <-228,-4.47512,-1003.64>, <-228,-4.47512,-590.301>, <-228,-4.47512,-486.967>,
<-229.333,-4.47512,-1106.97>, <-229.333,-4.47512,-1003.64>, <-229.333,-4.47512,-590.301>, <-229.333,-4.47512,-486.967>,
<-234.667,-4.47512,-1106.97>, <-234.667,-4.47512,-1003.64>, <-234.667,-4.47512,-590.301>, <-234.667,-4.47512,-486.967>,
<-236,-4.47512,-1106.97>, <-236,-4.47512,-1003.64>, <-236,-4.47512,-590.301>, <-236,-4.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-236,-4.47512,-1106.97>, <-236,-4.47512,-1003.64>, <-236,-4.47512,-590.301>, <-236,-4.47512,-486.967>,
<-236.333,-4.14179,-1106.97>, <-236.333,-4.14179,-1003.64>, <-236.333,-4.14179,-590.301>, <-236.333,-4.14179,-486.967>,
<-237.667,-2.80845,-1106.97>, <-237.667,-2.80845,-1003.64>, <-237.667,-2.80845,-590.301>, <-237.667,-2.80845,-486.967>,
<-238,-2.47512,-1106.97>, <-238,-2.47512,-1003.64>, <-238,-2.47512,-590.301>, <-238,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-206,1.52488,-1106.97>, <-206,0.858213,-1106.97>, <-206,-1.80845,-1106.97>, <-206,-2.47512,-1106.97>,
<-206,1.52488,-1003.64>, <-206,0.858213,-1003.64>, <-206,-1.80845,-1003.64>, <-206,-2.47512,-1003.64>,
<-206,1.52488,-590.301>, <-206,0.858213,-590.301>, <-206,-1.80845,-590.301>, <-206,-2.47512,-590.301>,
<-206,1.52488,-486.967>, <-206,0.858213,-486.967>, <-206,-1.80845,-486.967>, <-206,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-206,1.52488,-1106.97>, <-206,1.52488,-1003.64>, <-206,1.52488,-590.301>, <-206,1.52488,-486.967>,
<-205.667,1.85821,-1106.97>, <-205.667,1.85821,-1003.64>, <-205.667,1.85821,-590.301>, <-205.667,1.85821,-486.967>,
<-204.333,3.19155,-1106.97>, <-204.333,3.19155,-1003.64>, <-204.333,3.19155,-590.301>, <-204.333,3.19155,-486.967>,
<-204,3.52488,-1106.97>, <-204,3.52488,-1003.64>, <-204,3.52488,-590.301>, <-204,3.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-204,3.52488,-1106.97>, <-204,3.52488,-1003.64>, <-204,3.52488,-590.301>, <-204,3.52488,-486.967>,
<-202.667,3.52488,-1106.97>, <-202.667,3.52488,-1003.64>, <-202.667,3.52488,-590.301>, <-202.667,3.52488,-486.967>,
<-197.333,3.52488,-1106.97>, <-197.333,3.52488,-1003.64>, <-197.333,3.52488,-590.301>, <-197.333,3.52488,-486.967>,
<-196,3.52488,-1106.97>, <-196,3.52488,-1003.64>, <-196,3.52488,-590.301>, <-196,3.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-196,3.52488,-1106.97>, <-196,3.52488,-1003.64>, <-196,3.52488,-590.301>, <-196,3.52488,-486.967>,
<-195.667,3.19155,-1106.97>, <-195.667,3.19155,-1003.64>, <-195.667,3.19155,-590.301>, <-195.667,3.19155,-486.967>,
<-194.333,1.85821,-1106.97>, <-194.333,1.85821,-1003.64>, <-194.333,1.85821,-590.301>, <-194.333,1.85821,-486.967>,
<-194,1.52488,-1106.97>, <-194,1.52488,-1003.64>, <-194,1.52488,-590.301>, <-194,1.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-194,1.52488,-1106.97>, <-194,1.52488,-1003.64>, <-194,1.52488,-590.301>, <-194,1.52488,-486.967>,
<-194,0.858213,-1106.97>, <-194,0.858213,-1003.64>, <-194,0.858213,-590.301>, <-194,0.858213,-486.967>,
<-194,-1.80845,-1106.97>, <-194,-1.80845,-1003.64>, <-194,-1.80845,-590.301>, <-194,-1.80845,-486.967>,
<-194,-2.47512,-1106.97>, <-194,-2.47512,-1003.64>, <-194,-2.47512,-590.301>, <-194,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-194,-2.47512,-1106.97>, <-194,-2.47512,-1003.64>, <-194,-2.47512,-590.301>, <-194,-2.47512,-486.967>,
<-194.333,-2.80845,-1106.97>, <-194.333,-2.80845,-1003.64>, <-194.333,-2.80845,-590.301>, <-194.333,-2.80845,-486.967>,
<-195.667,-4.14179,-1106.97>, <-195.667,-4.14179,-1003.64>, <-195.667,-4.14179,-590.301>, <-195.667,-4.14179,-486.967>,
<-196,-4.47512,-1106.97>, <-196,-4.47512,-1003.64>, <-196,-4.47512,-590.301>, <-196,-4.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-196,-4.47512,-1106.97>, <-196,-4.47512,-1003.64>, <-196,-4.47512,-590.301>, <-196,-4.47512,-486.967>,
<-197.333,-4.47512,-1106.97>, <-197.333,-4.47512,-1003.64>, <-197.333,-4.47512,-590.301>, <-197.333,-4.47512,-486.967>,
<-202.667,-4.47512,-1106.97>, <-202.667,-4.47512,-1003.64>, <-202.667,-4.47512,-590.301>, <-202.667,-4.47512,-486.967>,
<-204,-4.47512,-1106.97>, <-204,-4.47512,-1003.64>, <-204,-4.47512,-590.301>, <-204,-4.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-204,-4.47512,-1106.97>, <-204,-4.47512,-1003.64>, <-204,-4.47512,-590.301>, <-204,-4.47512,-486.967>,
<-204.333,-4.14179,-1106.97>, <-204.333,-4.14179,-1003.64>, <-204.333,-4.14179,-590.301>, <-204.333,-4.14179,-486.967>,
<-205.667,-2.80845,-1106.97>, <-205.667,-2.80845,-1003.64>, <-205.667,-2.80845,-590.301>, <-205.667,-2.80845,-486.967>,
<-206,-2.47512,-1106.97>, <-206,-2.47512,-1003.64>, <-206,-2.47512,-590.301>, <-206,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-286,1.52488,-1106.97>, <-286,0.858213,-1106.97>, <-286,-1.80845,-1106.97>, <-286,-2.47512,-1106.97>,
<-286,1.52488,-1003.64>, <-286,0.858213,-1003.64>, <-286,-1.80845,-1003.64>, <-286,-2.47512,-1003.64>,
<-286,1.52488,-590.301>, <-286,0.858213,-590.301>, <-286,-1.80845,-590.301>, <-286,-2.47512,-590.301>,
<-286,1.52488,-486.967>, <-286,0.858213,-486.967>, <-286,-1.80845,-486.967>, <-286,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-286,1.52488,-1106.97>, <-286,1.52488,-1003.64>, <-286,1.52488,-590.301>, <-286,1.52488,-486.967>,
<-285.667,1.85821,-1106.97>, <-285.667,1.85821,-1003.64>, <-285.667,1.85821,-590.301>, <-285.667,1.85821,-486.967>,
<-284.333,3.19155,-1106.97>, <-284.333,3.19155,-1003.64>, <-284.333,3.19155,-590.301>, <-284.333,3.19155,-486.967>,
<-284,3.52488,-1106.97>, <-284,3.52488,-1003.64>, <-284,3.52488,-590.301>, <-284,3.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-284,3.52488,-1106.97>, <-284,3.52488,-1003.64>, <-284,3.52488,-590.301>, <-284,3.52488,-486.967>,
<-282.667,3.52488,-1106.97>, <-282.667,3.52488,-1003.64>, <-282.667,3.52488,-590.301>, <-282.667,3.52488,-486.967>,
<-277.333,3.52488,-1106.97>, <-277.333,3.52488,-1003.64>, <-277.333,3.52488,-590.301>, <-277.333,3.52488,-486.967>,
<-276,3.52488,-1106.97>, <-276,3.52488,-1003.64>, <-276,3.52488,-590.301>, <-276,3.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-276,3.52488,-1106.97>, <-276,3.52488,-1003.64>, <-276,3.52488,-590.301>, <-276,3.52488,-486.967>,
<-275.667,3.19155,-1106.97>, <-275.667,3.19155,-1003.64>, <-275.667,3.19155,-590.301>, <-275.667,3.19155,-486.967>,
<-274.333,1.85821,-1106.97>, <-274.333,1.85821,-1003.64>, <-274.333,1.85821,-590.301>, <-274.333,1.85821,-486.967>,
<-274,1.52488,-1106.97>, <-274,1.52488,-1003.64>, <-274,1.52488,-590.301>, <-274,1.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-274,1.52488,-1106.97>, <-274,1.52488,-1003.64>, <-274,1.52488,-590.301>, <-274,1.52488,-486.967>,
<-274,0.858213,-1106.97>, <-274,0.858213,-1003.64>, <-274,0.858213,-590.301>, <-274,0.858213,-486.967>,
<-274,-1.80845,-1106.97>, <-274,-1.80845,-1003.64>, <-274,-1.80845,-590.301>, <-274,-1.80845,-486.967>,
<-274,-2.47512,-1106.97>, <-274,-2.47512,-1003.64>, <-274,-2.47512,-590.301>, <-274,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-274,-2.47512,-1106.97>, <-274,-2.47512,-1003.64>, <-274,-2.47512,-590.301>, <-274,-2.47512,-486.967>,
<-274.333,-2.80845,-1106.97>, <-274.333,-2.80845,-1003.64>, <-274.333,-2.80845,-590.301>, <-274.333,-2.80845,-486.967>,
<-275.667,-4.14179,-1106.97>, <-275.667,-4.14179,-1003.64>, <-275.667,-4.14179,-590.301>, <-275.667,-4.14179,-486.967>,
<-276,-4.47512,-1106.97>, <-276,-4.47512,-1003.64>, <-276,-4.47512,-590.301>, <-276,-4.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-276,-4.47512,-1106.97>, <-276,-4.47512,-1003.64>, <-276,-4.47512,-590.301>, <-276,-4.47512,-486.967>,
<-277.333,-4.47512,-1106.97>, <-277.333,-4.47512,-1003.64>, <-277.333,-4.47512,-590.301>, <-277.333,-4.47512,-486.967>,
<-282.667,-4.47512,-1106.97>, <-282.667,-4.47512,-1003.64>, <-282.667,-4.47512,-590.301>, <-282.667,-4.47512,-486.967>,
<-284,-4.47512,-1106.97>, <-284,-4.47512,-1003.64>, <-284,-4.47512,-590.301>, <-284,-4.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-284,-4.47512,-1106.97>, <-284,-4.47512,-1003.64>, <-284,-4.47512,-590.301>, <-284,-4.47512,-486.967>,
<-284.333,-4.14179,-1106.97>, <-284.333,-4.14179,-1003.64>, <-284.333,-4.14179,-590.301>, <-284.333,-4.14179,-486.967>,
<-285.667,-2.80845,-1106.97>, <-285.667,-2.80845,-1003.64>, <-285.667,-2.80845,-590.301>, <-285.667,-2.80845,-486.967>,
<-286,-2.47512,-1106.97>, <-286,-2.47512,-1003.64>, <-286,-2.47512,-590.301>, <-286,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-318,1.52488,-1106.97>, <-318,0.858213,-1106.97>, <-318,-1.80845,-1106.97>, <-318,-2.47512,-1106.97>,
<-318,1.52488,-1003.64>, <-318,0.858213,-1003.64>, <-318,-1.80845,-1003.64>, <-318,-2.47512,-1003.64>,
<-318,1.52488,-590.301>, <-318,0.858213,-590.301>, <-318,-1.80845,-590.301>, <-318,-2.47512,-590.301>,
<-318,1.52488,-486.967>, <-318,0.858213,-486.967>, <-318,-1.80845,-486.967>, <-318,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-318,1.52488,-1106.97>, <-318,1.52488,-1003.64>, <-318,1.52488,-590.301>, <-318,1.52488,-486.967>,
<-317.667,1.85821,-1106.97>, <-317.667,1.85821,-1003.64>, <-317.667,1.85821,-590.301>, <-317.667,1.85821,-486.967>,
<-316.333,3.19155,-1106.97>, <-316.333,3.19155,-1003.64>, <-316.333,3.19155,-590.301>, <-316.333,3.19155,-486.967>,
<-316,3.52488,-1106.97>, <-316,3.52488,-1003.64>, <-316,3.52488,-590.301>, <-316,3.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-316,3.52488,-1106.97>, <-316,3.52488,-1003.64>, <-316,3.52488,-590.301>, <-316,3.52488,-486.967>,
<-314.667,3.52488,-1106.97>, <-314.667,3.52488,-1003.64>, <-314.667,3.52488,-590.301>, <-314.667,3.52488,-486.967>,
<-309.333,3.52488,-1106.97>, <-309.333,3.52488,-1003.64>, <-309.333,3.52488,-590.301>, <-309.333,3.52488,-486.967>,
<-308,3.52488,-1106.97>, <-308,3.52488,-1003.64>, <-308,3.52488,-590.301>, <-308,3.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-308,3.52488,-1106.97>, <-308,3.52488,-1003.64>, <-308,3.52488,-590.301>, <-308,3.52488,-486.967>,
<-307.667,3.19155,-1106.97>, <-307.667,3.19155,-1003.64>, <-307.667,3.19155,-590.301>, <-307.667,3.19155,-486.967>,
<-306.333,1.85821,-1106.97>, <-306.333,1.85821,-1003.64>, <-306.333,1.85821,-590.301>, <-306.333,1.85821,-486.967>,
<-306,1.52488,-1106.97>, <-306,1.52488,-1003.64>, <-306,1.52488,-590.301>, <-306,1.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-306,1.52488,-1106.97>, <-306,1.52488,-1003.64>, <-306,1.52488,-590.301>, <-306,1.52488,-486.967>,
<-306,0.858213,-1106.97>, <-306,0.858213,-1003.64>, <-306,0.858213,-590.301>, <-306,0.858213,-486.967>,
<-306,-1.80845,-1106.97>, <-306,-1.80845,-1003.64>, <-306,-1.80845,-590.301>, <-306,-1.80845,-486.967>,
<-306,-2.47512,-1106.97>, <-306,-2.47512,-1003.64>, <-306,-2.47512,-590.301>, <-306,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-306,-2.47512,-1106.97>, <-306,-2.47512,-1003.64>, <-306,-2.47512,-590.301>, <-306,-2.47512,-486.967>,
<-306.333,-2.80845,-1106.97>, <-306.333,-2.80845,-1003.64>, <-306.333,-2.80845,-590.301>, <-306.333,-2.80845,-486.967>,
<-307.667,-4.14179,-1106.97>, <-307.667,-4.14179,-1003.64>, <-307.667,-4.14179,-590.301>, <-307.667,-4.14179,-486.967>,
<-308,-4.47512,-1106.97>, <-308,-4.47512,-1003.64>, <-308,-4.47512,-590.301>, <-308,-4.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-308,-4.47512,-1106.97>, <-308,-4.47512,-1003.64>, <-308,-4.47512,-590.301>, <-308,-4.47512,-486.967>,
<-309.333,-4.47512,-1106.97>, <-309.333,-4.47512,-1003.64>, <-309.333,-4.47512,-590.301>, <-309.333,-4.47512,-486.967>,
<-314.667,-4.47512,-1106.97>, <-314.667,-4.47512,-1003.64>, <-314.667,-4.47512,-590.301>, <-314.667,-4.47512,-486.967>,
<-316,-4.47512,-1106.97>, <-316,-4.47512,-1003.64>, <-316,-4.47512,-590.301>, <-316,-4.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-316,-4.47512,-1106.97>, <-316,-4.47512,-1003.64>, <-316,-4.47512,-590.301>, <-316,-4.47512,-486.967>,
<-316.333,-4.14179,-1106.97>, <-316.333,-4.14179,-1003.64>, <-316.333,-4.14179,-590.301>, <-316.333,-4.14179,-486.967>,
<-317.667,-2.80845,-1106.97>, <-317.667,-2.80845,-1003.64>, <-317.667,-2.80845,-590.301>, <-317.667,-2.80845,-486.967>,
<-318,-2.47512,-1106.97>, <-318,-2.47512,-1003.64>, <-318,-2.47512,-590.301>, <-318,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-254,1.52488,-1106.97>, <-254,0.858213,-1106.97>, <-254,-1.80845,-1106.97>, <-254,-2.47512,-1106.97>,
<-254,1.52488,-1003.64>, <-254,0.858213,-1003.64>, <-254,-1.80845,-1003.64>, <-254,-2.47512,-1003.64>,
<-254,1.52488,-590.301>, <-254,0.858213,-590.301>, <-254,-1.80845,-590.301>, <-254,-2.47512,-590.301>,
<-254,1.52488,-486.967>, <-254,0.858213,-486.967>, <-254,-1.80845,-486.967>, <-254,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-254,1.52488,-1106.97>, <-254,1.52488,-1003.64>, <-254,1.52488,-590.301>, <-254,1.52488,-486.967>,
<-253.667,1.85821,-1106.97>, <-253.667,1.85821,-1003.64>, <-253.667,1.85821,-590.301>, <-253.667,1.85821,-486.967>,
<-252.333,3.19155,-1106.97>, <-252.333,3.19155,-1003.64>, <-252.333,3.19155,-590.301>, <-252.333,3.19155,-486.967>,
<-252,3.52488,-1106.97>, <-252,3.52488,-1003.64>, <-252,3.52488,-590.301>, <-252,3.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-252,3.52488,-1106.97>, <-252,3.52488,-1003.64>, <-252,3.52488,-590.301>, <-252,3.52488,-486.967>,
<-250.667,3.52488,-1106.97>, <-250.667,3.52488,-1003.64>, <-250.667,3.52488,-590.301>, <-250.667,3.52488,-486.967>,
<-245.333,3.52488,-1106.97>, <-245.333,3.52488,-1003.64>, <-245.333,3.52488,-590.301>, <-245.333,3.52488,-486.967>,
<-244,3.52488,-1106.97>, <-244,3.52488,-1003.64>, <-244,3.52488,-590.301>, <-244,3.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-244,3.52488,-1106.97>, <-244,3.52488,-1003.64>, <-244,3.52488,-590.301>, <-244,3.52488,-486.967>,
<-243.667,3.19155,-1106.97>, <-243.667,3.19155,-1003.64>, <-243.667,3.19155,-590.301>, <-243.667,3.19155,-486.967>,
<-242.333,1.85821,-1106.97>, <-242.333,1.85821,-1003.64>, <-242.333,1.85821,-590.301>, <-242.333,1.85821,-486.967>,
<-242,1.52488,-1106.97>, <-242,1.52488,-1003.64>, <-242,1.52488,-590.301>, <-242,1.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-242,1.52488,-1106.97>, <-242,1.52488,-1003.64>, <-242,1.52488,-590.301>, <-242,1.52488,-486.967>,
<-242,0.858213,-1106.97>, <-242,0.858213,-1003.64>, <-242,0.858213,-590.301>, <-242,0.858213,-486.967>,
<-242,-1.80845,-1106.97>, <-242,-1.80845,-1003.64>, <-242,-1.80845,-590.301>, <-242,-1.80845,-486.967>,
<-242,-2.47512,-1106.97>, <-242,-2.47512,-1003.64>, <-242,-2.47512,-590.301>, <-242,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-242,-2.47512,-1106.97>, <-242,-2.47512,-1003.64>, <-242,-2.47512,-590.301>, <-242,-2.47512,-486.967>,
<-242.333,-2.80845,-1106.97>, <-242.333,-2.80845,-1003.64>, <-242.333,-2.80845,-590.301>, <-242.333,-2.80845,-486.967>,
<-243.667,-4.14179,-1106.97>, <-243.667,-4.14179,-1003.64>, <-243.667,-4.14179,-590.301>, <-243.667,-4.14179,-486.967>,
<-244,-4.47512,-1106.97>, <-244,-4.47512,-1003.64>, <-244,-4.47512,-590.301>, <-244,-4.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-244,-4.47512,-1106.97>, <-244,-4.47512,-1003.64>, <-244,-4.47512,-590.301>, <-244,-4.47512,-486.967>,
<-245.333,-4.47512,-1106.97>, <-245.333,-4.47512,-1003.64>, <-245.333,-4.47512,-590.301>, <-245.333,-4.47512,-486.967>,
<-250.667,-4.47512,-1106.97>, <-250.667,-4.47512,-1003.64>, <-250.667,-4.47512,-590.301>, <-250.667,-4.47512,-486.967>,
<-252,-4.47512,-1106.97>, <-252,-4.47512,-1003.64>, <-252,-4.47512,-590.301>, <-252,-4.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-252,-4.47512,-1106.97>, <-252,-4.47512,-1003.64>, <-252,-4.47512,-590.301>, <-252,-4.47512,-486.967>,
<-252.333,-4.14179,-1106.97>, <-252.333,-4.14179,-1003.64>, <-252.333,-4.14179,-590.301>, <-252.333,-4.14179,-486.967>,
<-253.667,-2.80845,-1106.97>, <-253.667,-2.80845,-1003.64>, <-253.667,-2.80845,-590.301>, <-253.667,-2.80845,-486.967>,
<-254,-2.47512,-1106.97>, <-254,-2.47512,-1003.64>, <-254,-2.47512,-590.301>, <-254,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-302,1.52488,-1106.97>, <-302,0.858213,-1106.97>, <-302,-1.80845,-1106.97>, <-302,-2.47512,-1106.97>,
<-302,1.52488,-1003.64>, <-302,0.858213,-1003.64>, <-302,-1.80845,-1003.64>, <-302,-2.47512,-1003.64>,
<-302,1.52488,-590.301>, <-302,0.858213,-590.301>, <-302,-1.80845,-590.301>, <-302,-2.47512,-590.301>,
<-302,1.52488,-486.967>, <-302,0.858213,-486.967>, <-302,-1.80845,-486.967>, <-302,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-302,1.52488,-1106.97>, <-302,1.52488,-1003.64>, <-302,1.52488,-590.301>, <-302,1.52488,-486.967>,
<-301.667,1.85821,-1106.97>, <-301.667,1.85821,-1003.64>, <-301.667,1.85821,-590.301>, <-301.667,1.85821,-486.967>,
<-300.333,3.19155,-1106.97>, <-300.333,3.19155,-1003.64>, <-300.333,3.19155,-590.301>, <-300.333,3.19155,-486.967>,
<-300,3.52488,-1106.97>, <-300,3.52488,-1003.64>, <-300,3.52488,-590.301>, <-300,3.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-300,3.52488,-1106.97>, <-300,3.52488,-1003.64>, <-300,3.52488,-590.301>, <-300,3.52488,-486.967>,
<-298.667,3.52488,-1106.97>, <-298.667,3.52488,-1003.64>, <-298.667,3.52488,-590.301>, <-298.667,3.52488,-486.967>,
<-293.333,3.52488,-1106.97>, <-293.333,3.52488,-1003.64>, <-293.333,3.52488,-590.301>, <-293.333,3.52488,-486.967>,
<-292,3.52488,-1106.97>, <-292,3.52488,-1003.64>, <-292,3.52488,-590.301>, <-292,3.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-292,3.52488,-1106.97>, <-292,3.52488,-1003.64>, <-292,3.52488,-590.301>, <-292,3.52488,-486.967>,
<-291.667,3.19155,-1106.97>, <-291.667,3.19155,-1003.64>, <-291.667,3.19155,-590.301>, <-291.667,3.19155,-486.967>,
<-290.333,1.85821,-1106.97>, <-290.333,1.85821,-1003.64>, <-290.333,1.85821,-590.301>, <-290.333,1.85821,-486.967>,
<-290,1.52488,-1106.97>, <-290,1.52488,-1003.64>, <-290,1.52488,-590.301>, <-290,1.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-290,1.52488,-1106.97>, <-290,1.52488,-1003.64>, <-290,1.52488,-590.301>, <-290,1.52488,-486.967>,
<-290,0.858213,-1106.97>, <-290,0.858213,-1003.64>, <-290,0.858213,-590.301>, <-290,0.858213,-486.967>,
<-290,-1.80845,-1106.97>, <-290,-1.80845,-1003.64>, <-290,-1.80845,-590.301>, <-290,-1.80845,-486.967>,
<-290,-2.47512,-1106.97>, <-290,-2.47512,-1003.64>, <-290,-2.47512,-590.301>, <-290,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-290,-2.47512,-1106.97>, <-290,-2.47512,-1003.64>, <-290,-2.47512,-590.301>, <-290,-2.47512,-486.967>,
<-290.333,-2.80845,-1106.97>, <-290.333,-2.80845,-1003.64>, <-290.333,-2.80845,-590.301>, <-290.333,-2.80845,-486.967>,
<-291.667,-4.14179,-1106.97>, <-291.667,-4.14179,-1003.64>, <-291.667,-4.14179,-590.301>, <-291.667,-4.14179,-486.967>,
<-292,-4.47512,-1106.97>, <-292,-4.47512,-1003.64>, <-292,-4.47512,-590.301>, <-292,-4.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-292,-4.47512,-1106.97>, <-292,-4.47512,-1003.64>, <-292,-4.47512,-590.301>, <-292,-4.47512,-486.967>,
<-293.333,-4.47512,-1106.97>, <-293.333,-4.47512,-1003.64>, <-293.333,-4.47512,-590.301>, <-293.333,-4.47512,-486.967>,
<-298.667,-4.47512,-1106.97>, <-298.667,-4.47512,-1003.64>, <-298.667,-4.47512,-590.301>, <-298.667,-4.47512,-486.967>,
<-300,-4.47512,-1106.97>, <-300,-4.47512,-1003.64>, <-300,-4.47512,-590.301>, <-300,-4.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-300,-4.47512,-1106.97>, <-300,-4.47512,-1003.64>, <-300,-4.47512,-590.301>, <-300,-4.47512,-486.967>,
<-300.333,-4.14179,-1106.97>, <-300.333,-4.14179,-1003.64>, <-300.333,-4.14179,-590.301>, <-300.333,-4.14179,-486.967>,
<-301.667,-2.80845,-1106.97>, <-301.667,-2.80845,-1003.64>, <-301.667,-2.80845,-590.301>, <-301.667,-2.80845,-486.967>,
<-302,-2.47512,-1106.97>, <-302,-2.47512,-1003.64>, <-302,-2.47512,-590.301>, <-302,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-270,1.52488,-1106.97>, <-270,0.858213,-1106.97>, <-270,-1.80845,-1106.97>, <-270,-2.47512,-1106.97>,
<-270,1.52488,-1003.64>, <-270,0.858213,-1003.64>, <-270,-1.80845,-1003.64>, <-270,-2.47512,-1003.64>,
<-270,1.52488,-590.301>, <-270,0.858213,-590.301>, <-270,-1.80845,-590.301>, <-270,-2.47512,-590.301>,
<-270,1.52488,-486.967>, <-270,0.858213,-486.967>, <-270,-1.80845,-486.967>, <-270,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-270,1.52488,-1106.97>, <-270,1.52488,-1003.64>, <-270,1.52488,-590.301>, <-270,1.52488,-486.967>,
<-269.667,1.85821,-1106.97>, <-269.667,1.85821,-1003.64>, <-269.667,1.85821,-590.301>, <-269.667,1.85821,-486.967>,
<-268.333,3.19155,-1106.97>, <-268.333,3.19155,-1003.64>, <-268.333,3.19155,-590.301>, <-268.333,3.19155,-486.967>,
<-268,3.52488,-1106.97>, <-268,3.52488,-1003.64>, <-268,3.52488,-590.301>, <-268,3.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-268,3.52488,-1106.97>, <-268,3.52488,-1003.64>, <-268,3.52488,-590.301>, <-268,3.52488,-486.967>,
<-266.667,3.52488,-1106.97>, <-266.667,3.52488,-1003.64>, <-266.667,3.52488,-590.301>, <-266.667,3.52488,-486.967>,
<-261.333,3.52488,-1106.97>, <-261.333,3.52488,-1003.64>, <-261.333,3.52488,-590.301>, <-261.333,3.52488,-486.967>,
<-260,3.52488,-1106.97>, <-260,3.52488,-1003.64>, <-260,3.52488,-590.301>, <-260,3.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-260,3.52488,-1106.97>, <-260,3.52488,-1003.64>, <-260,3.52488,-590.301>, <-260,3.52488,-486.967>,
<-259.667,3.19155,-1106.97>, <-259.667,3.19155,-1003.64>, <-259.667,3.19155,-590.301>, <-259.667,3.19155,-486.967>,
<-258.333,1.85821,-1106.97>, <-258.333,1.85821,-1003.64>, <-258.333,1.85821,-590.301>, <-258.333,1.85821,-486.967>,
<-258,1.52488,-1106.97>, <-258,1.52488,-1003.64>, <-258,1.52488,-590.301>, <-258,1.52488,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-258,1.52488,-1106.97>, <-258,1.52488,-1003.64>, <-258,1.52488,-590.301>, <-258,1.52488,-486.967>,
<-258,0.858213,-1106.97>, <-258,0.858213,-1003.64>, <-258,0.858213,-590.301>, <-258,0.858213,-486.967>,
<-258,-1.80845,-1106.97>, <-258,-1.80845,-1003.64>, <-258,-1.80845,-590.301>, <-258,-1.80845,-486.967>,
<-258,-2.47512,-1106.97>, <-258,-2.47512,-1003.64>, <-258,-2.47512,-590.301>, <-258,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-258,-2.47512,-1106.97>, <-258,-2.47512,-1003.64>, <-258,-2.47512,-590.301>, <-258,-2.47512,-486.967>,
<-258.333,-2.80845,-1106.97>, <-258.333,-2.80845,-1003.64>, <-258.333,-2.80845,-590.301>, <-258.333,-2.80845,-486.967>,
<-259.667,-4.14179,-1106.97>, <-259.667,-4.14179,-1003.64>, <-259.667,-4.14179,-590.301>, <-259.667,-4.14179,-486.967>,
<-260,-4.47512,-1106.97>, <-260,-4.47512,-1003.64>, <-260,-4.47512,-590.301>, <-260,-4.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-260,-4.47512,-1106.97>, <-260,-4.47512,-1003.64>, <-260,-4.47512,-590.301>, <-260,-4.47512,-486.967>,
<-261.333,-4.47512,-1106.97>, <-261.333,-4.47512,-1003.64>, <-261.333,-4.47512,-590.301>, <-261.333,-4.47512,-486.967>,
<-266.667,-4.47512,-1106.97>, <-266.667,-4.47512,-1003.64>, <-266.667,-4.47512,-590.301>, <-266.667,-4.47512,-486.967>,
<-268,-4.47512,-1106.97>, <-268,-4.47512,-1003.64>, <-268,-4.47512,-590.301>, <-268,-4.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-268,-4.47512,-1106.97>, <-268,-4.47512,-1003.64>, <-268,-4.47512,-590.301>, <-268,-4.47512,-486.967>,
<-268.333,-4.14179,-1106.97>, <-268.333,-4.14179,-1003.64>, <-268.333,-4.14179,-590.301>, <-268.333,-4.14179,-486.967>,
<-269.667,-2.80845,-1106.97>, <-269.667,-2.80845,-1003.64>, <-269.667,-2.80845,-590.301>, <-269.667,-2.80845,-486.967>,
<-270,-2.47512,-1106.97>, <-270,-2.47512,-1003.64>, <-270,-2.47512,-590.301>, <-270,-2.47512,-486.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-158.5,4.52488,-1105.97>, <-158.5,2.85821,-1105.97>, <-158.5,-3.80845,-1105.97>, <-158.5,-5.47512,-1105.97>,
<-185.667,4.52488,-1105.97>, <-185.667,2.85821,-1105.97>, <-185.667,-3.80845,-1105.97>, <-185.667,-5.47512,-1105.97>,
<-294.333,4.52488,-1105.97>, <-294.333,2.85821,-1105.97>, <-294.333,-3.80845,-1105.97>, <-294.333,-5.47512,-1105.97>,
<-321.5,4.52488,-1105.97>, <-321.5,2.85821,-1105.97>, <-321.5,-3.80845,-1105.97>, <-321.5,-5.47512,-1105.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,4.52488,-1195.97>, <-321.5,4.52488,-1180.97>, <-321.5,4.52488,-1120.97>, <-321.5,4.52488,-1105.97>,
<-321.5,2.85821,-1195.97>, <-321.5,2.85821,-1180.97>, <-321.5,2.85821,-1120.97>, <-321.5,2.85821,-1105.97>,
<-321.5,-3.80845,-1195.97>, <-321.5,-3.80845,-1180.97>, <-321.5,-3.80845,-1120.97>, <-321.5,-3.80845,-1105.97>,
<-321.5,-5.47512,-1195.97>, <-321.5,-5.47512,-1180.97>, <-321.5,-5.47512,-1120.97>, <-321.5,-5.47512,-1105.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,4.52488,-1195.97>, <-321.5,2.85821,-1195.97>, <-321.5,-3.80845,-1195.97>, <-321.5,-5.47512,-1195.97>,
<-294.333,4.52488,-1195.97>, <-294.333,2.85821,-1195.97>, <-294.333,-3.80845,-1195.97>, <-294.333,-5.47512,-1195.97>,
<-185.667,4.52488,-1195.97>, <-185.667,2.85821,-1195.97>, <-185.667,-3.80845,-1195.97>, <-185.667,-5.47512,-1195.97>,
<-158.5,4.52488,-1195.97>, <-158.5,2.85821,-1195.97>, <-158.5,-3.80845,-1195.97>, <-158.5,-5.47512,-1195.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-158.5,4.52488,-1195.97>, <-158.5,2.85821,-1195.97>, <-158.5,-3.80845,-1195.97>, <-158.5,-5.47512,-1195.97>,
<-158.5,4.52488,-1180.97>, <-158.5,2.85821,-1180.97>, <-158.5,-3.80845,-1180.97>, <-158.5,-5.47512,-1180.97>,
<-158.5,4.52488,-1120.97>, <-158.5,2.85821,-1120.97>, <-158.5,-3.80845,-1120.97>, <-158.5,-5.47512,-1120.97>,
<-158.5,4.52488,-1105.97>, <-158.5,2.85821,-1105.97>, <-158.5,-3.80845,-1105.97>, <-158.5,-5.47512,-1105.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-155,9.52488,-1196.97>, <-155,6.19155,-1196.97>, <-155,-7.14177,-1196.97>, <-155,-10.4751,-1196.97>,
<-155,9.52488,-1063.64>, <-155,6.19155,-1063.64>, <-155,-7.14177,-1063.64>, <-155,-10.4751,-1063.64>,
<-155,9.52488,-530.301>, <-155,6.19155,-530.301>, <-155,-7.14177,-530.301>, <-155,-10.4751,-530.301>,
<-155,9.52488,-396.967>, <-155,6.19155,-396.967>, <-155,-7.14177,-396.967>, <-155,-10.4751,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-155,9.52488,-1196.97>, <-155,9.52488,-1063.64>, <-155,9.52488,-530.301>, <-155,9.52488,-396.967>,
<-154.167,10.3582,-1196.97>, <-154.167,10.3582,-1063.64>, <-154.167,10.3582,-530.301>, <-154.167,10.3582,-396.967>,
<-150.833,13.6916,-1196.97>, <-150.833,13.6916,-1063.64>, <-150.833,13.6916,-530.301>, <-150.833,13.6916,-396.967>,
<-150,14.5249,-1196.97>, <-150,14.5249,-1063.64>, <-150,14.5249,-530.301>, <-150,14.5249,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-155,9.52488,-1196.97>, <-154.167,10.3582,-1196.97>, <-150.833,13.6916,-1196.97>, <-150,14.5249,-1196.97>,
<-155,6.19155,-1196.97>, <-154.167,6.46933,-1196.97>, <-150.833,9.24712,-1196.97>, <-150,9.5249,-1196.97>,
<-155,-7.14177,-1196.97>, <-154.167,-7.41955,-1196.97>, <-150.833,-10.1973,-1196.97>, <-150,-10.4751,-1196.97>,
<-155,-10.4751,-1196.97>, <-154.167,-11.3084,-1196.97>, <-150.833,-14.6418,-1196.97>, <-150,-15.4751,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-150,14.5249,-1196.97>, <-146.667,14.5249,-1196.97>, <-133.333,14.5249,-1196.97>, <-130,14.5249,-1196.97>,
<-150,9.5249,-1196.97>, <-146.667,9.5249,-1196.97>, <-133.333,9.5249,-1196.97>, <-130,9.5249,-1196.97>,
<-150,-10.4751,-1196.97>, <-146.667,-10.4751,-1196.97>, <-133.333,-10.4751,-1196.97>, <-130,-10.4751,-1196.97>,
<-150,-15.4751,-1196.97>, <-146.667,-15.4751,-1196.97>, <-133.333,-15.4751,-1196.97>, <-130,-15.4751,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-150,14.5249,-1196.97>, <-150,14.5249,-1063.64>, <-150,14.5249,-530.301>, <-150,14.5249,-396.967>,
<-146.667,14.5249,-1196.97>, <-146.667,14.5249,-1063.64>, <-146.667,14.5249,-530.301>, <-146.667,14.5249,-396.967>,
<-133.333,14.5249,-1196.97>, <-133.333,14.5249,-1063.64>, <-133.333,14.5249,-530.301>, <-133.333,14.5249,-396.967>,
<-130,14.5249,-1196.97>, <-130,14.5249,-1063.64>, <-130,14.5249,-530.301>, <-130,14.5249,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-130,14.5249,-1196.97>, <-129.167,13.6916,-1196.97>, <-125.833,10.3582,-1196.97>, <-125,9.52488,-1196.97>,
<-130,9.5249,-1196.97>, <-129.167,9.24712,-1196.97>, <-125.833,6.46933,-1196.97>, <-125,6.19155,-1196.97>,
<-130,-10.4751,-1196.97>, <-129.167,-10.1973,-1196.97>, <-125.833,-7.41955,-1196.97>, <-125,-7.14177,-1196.97>,
<-130,-15.4751,-1196.97>, <-129.167,-14.6418,-1196.97>, <-125.833,-11.3084,-1196.97>, <-125,-10.4751,-1196.97>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-130,14.5249,-1196.97>, <-130,14.5249,-1063.64>, <-130,14.5249,-530.301>, <-130,14.5249,-396.967>,
<-129.167,13.6916,-1196.97>, <-129.167,13.6916,-1063.64>, <-129.167,13.6916,-530.301>, <-129.167,13.6916,-396.967>,
<-125.833,10.3582,-1196.97>, <-125.833,10.3582,-1063.64>, <-125.833,10.3582,-530.301>, <-125.833,10.3582,-396.967>,
<-125,9.52488,-1196.97>, <-125,9.52488,-1063.64>, <-125,9.52488,-530.301>, <-125,9.52488,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-125,9.52488,-1196.97>, <-125,9.52488,-1063.64>, <-125,9.52488,-530.301>, <-125,9.52488,-396.967>,
<-125,6.19155,-1196.97>, <-125,6.19155,-1063.64>, <-125,6.19155,-530.301>, <-125,6.19155,-396.967>,
<-125,-7.14177,-1196.97>, <-125,-7.14177,-1063.64>, <-125,-7.14177,-530.301>, <-125,-7.14177,-396.967>,
<-125,-10.4751,-1196.97>, <-125,-10.4751,-1063.64>, <-125,-10.4751,-530.301>, <-125,-10.4751,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-125,-10.4751,-1196.97>, <-125,-10.4751,-1063.64>, <-125,-10.4751,-530.301>, <-125,-10.4751,-396.967>,
<-125.833,-11.3084,-1196.97>, <-125.833,-11.3084,-1063.64>, <-125.833,-11.3084,-530.301>, <-125.833,-11.3084,-396.967>,
<-129.167,-14.6418,-1196.97>, <-129.167,-14.6418,-1063.64>, <-129.167,-14.6418,-530.301>, <-129.167,-14.6418,-396.967>,
<-130,-15.4751,-1196.97>, <-130,-15.4751,-1063.64>, <-130,-15.4751,-530.301>, <-130,-15.4751,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-130,-15.4751,-1196.97>, <-130,-15.4751,-1063.64>, <-130,-15.4751,-530.301>, <-130,-15.4751,-396.967>,
<-133.333,-15.4751,-1196.97>, <-133.333,-15.4751,-1063.64>, <-133.333,-15.4751,-530.301>, <-133.333,-15.4751,-396.967>,
<-146.667,-15.4751,-1196.97>, <-146.667,-15.4751,-1063.64>, <-146.667,-15.4751,-530.301>, <-146.667,-15.4751,-396.967>,
<-150,-15.4751,-1196.97>, <-150,-15.4751,-1063.64>, <-150,-15.4751,-530.301>, <-150,-15.4751,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-150,-15.4751,-1196.97>, <-150,-15.4751,-1063.64>, <-150,-15.4751,-530.301>, <-150,-15.4751,-396.967>,
<-150.833,-14.6418,-1196.97>, <-150.833,-14.6418,-1063.64>, <-150.833,-14.6418,-530.301>, <-150.833,-14.6418,-396.967>,
<-154.167,-11.3084,-1196.97>, <-154.167,-11.3084,-1063.64>, <-154.167,-11.3084,-530.301>, <-154.167,-11.3084,-396.967>,
<-155,-10.4751,-1196.97>, <-155,-10.4751,-1063.64>, <-155,-10.4751,-530.301>, <-155,-10.4751,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-350,-15.4751,-396.967>, <-350,-10.4751,-396.967>, <-350,9.5249,-396.967>, <-350,14.5249,-396.967>,
<-350.833,-14.6418,-396.967>, <-350.833,-10.1973,-396.967>, <-350.833,9.24712,-396.967>, <-350.833,13.6916,-396.967>,
<-354.167,-11.3084,-396.967>, <-354.167,-7.41955,-396.967>, <-354.167,6.46933,-396.967>, <-354.167,10.3582,-396.967>,
<-355,-10.4751,-396.967>, <-355,-7.14177,-396.967>, <-355,6.19155,-396.967>, <-355,9.52488,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-330,-15.4751,-396.967>, <-330,-10.4751,-396.967>, <-330,9.5249,-396.967>, <-330,14.5249,-396.967>,
<-333.333,-15.4751,-396.967>, <-333.333,-10.4751,-396.967>, <-333.333,9.5249,-396.967>, <-333.333,14.5249,-396.967>,
<-346.667,-15.4751,-396.967>, <-346.667,-10.4751,-396.967>, <-346.667,9.5249,-396.967>, <-346.667,14.5249,-396.967>,
<-350,-15.4751,-396.967>, <-350,-10.4751,-396.967>, <-350,9.5249,-396.967>, <-350,14.5249,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-325,9.52488,-396.967>, <-325.833,10.3582,-396.967>, <-329.167,13.6916,-396.967>, <-330,14.5249,-396.967>,
<-325,6.19155,-396.967>, <-325.833,6.46933,-396.967>, <-329.167,9.24712,-396.967>, <-330,9.5249,-396.967>,
<-325,-7.14177,-396.967>, <-325.833,-7.41955,-396.967>, <-329.167,-10.1973,-396.967>, <-330,-10.4751,-396.967>,
<-325,-10.4751,-396.967>, <-325.833,-11.3084,-396.967>, <-329.167,-14.6418,-396.967>, <-330,-15.4751,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-155,9.52488,-396.967>, <-155,6.19155,-396.967>, <-155,-7.14177,-396.967>, <-155,-10.4751,-396.967>,
<-154.167,10.3582,-396.967>, <-154.167,6.46933,-396.967>, <-154.167,-7.41955,-396.967>, <-154.167,-11.3084,-396.967>,
<-150.833,13.6916,-396.967>, <-150.833,9.24712,-396.967>, <-150.833,-10.1973,-396.967>, <-150.833,-14.6418,-396.967>,
<-150,14.5249,-396.967>, <-150,9.5249,-396.967>, <-150,-10.4751,-396.967>, <-150,-15.4751,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-130,-15.4751,-396.967>, <-130,-10.4751,-396.967>, <-130,9.5249,-396.967>, <-130,14.5249,-396.967>,
<-133.333,-15.4751,-396.967>, <-133.333,-10.4751,-396.967>, <-133.333,9.5249,-396.967>, <-133.333,14.5249,-396.967>,
<-146.667,-15.4751,-396.967>, <-146.667,-10.4751,-396.967>, <-146.667,9.5249,-396.967>, <-146.667,14.5249,-396.967>,
<-150,-15.4751,-396.967>, <-150,-10.4751,-396.967>, <-150,9.5249,-396.967>, <-150,14.5249,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-125,9.52488,-396.967>, <-125.833,10.3582,-396.967>, <-129.167,13.6916,-396.967>, <-130,14.5249,-396.967>,
<-125,6.19155,-396.967>, <-125.833,6.46933,-396.967>, <-129.167,9.24712,-396.967>, <-130,9.5249,-396.967>,
<-125,-7.14177,-396.967>, <-125.833,-7.41955,-396.967>, <-129.167,-10.1973,-396.967>, <-130,-10.4751,-396.967>,
<-125,-10.4751,-396.967>, <-125.833,-11.3084,-396.967>, <-129.167,-14.6418,-396.967>, <-130,-15.4751,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-90,15,1203.03>, <-90,15,1069.7>, <-90,15,536.366>, <-90,15,403.033>,
<-93.3333,15,1203.03>, <-93.3333,15,1069.7>, <-93.3333,15,536.366>, <-93.3333,15,403.033>,
<-106.667,15,1203.03>, <-106.667,15,1069.7>, <-106.667,15,536.366>, <-106.667,15,403.033>,
<-110,15,1203.03>, <-110,15,1069.7>, <-110,15,536.366>, <-110,15,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-90,15,1203.03>, <-89.1667,14.1667,1203.03>, <-85.8333,10.8333,1203.03>, <-85,10,1203.03>,
<-90,15,1069.7>, <-89.1667,14.1667,1069.7>, <-85.8333,10.8333,1069.7>, <-85,10,1069.7>,
<-90,15,536.366>, <-89.1667,14.1667,536.366>, <-85.8333,10.8333,536.366>, <-85,10,536.366>,
<-90,15,403.033>, <-89.1667,14.1667,403.033>, <-85.8333,10.8333,403.033>, <-85,10,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-90,15,1203.03>, <-90,10,1203.03>, <-90,-10,1203.03>, <-90,-15,1203.03>,
<-89.1667,14.1667,1203.03>, <-89.1667,9.72222,1203.03>, <-89.1667,-9.72222,1203.03>, <-89.1667,-14.1667,1203.03>,
<-85.8333,10.8333,1203.03>, <-85.8333,6.94444,1203.03>, <-85.8333,-6.94444,1203.03>, <-85.8333,-10.8333,1203.03>,
<-85,10,1203.03>, <-85,6.66667,1203.03>, <-85,-6.66667,1203.03>, <-85,-10,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-90,15,1203.03>, <-93.3333,15,1203.03>, <-106.667,15,1203.03>, <-110,15,1203.03>,
<-90,10,1203.03>, <-93.3333,10,1203.03>, <-106.667,10,1203.03>, <-110,10,1203.03>,
<-90,-10,1203.03>, <-93.3333,-10,1203.03>, <-106.667,-10,1203.03>, <-110,-10,1203.03>,
<-90,-15,1203.03>, <-93.3333,-15,1203.03>, <-106.667,-15,1203.03>, <-110,-15,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-85,-10,1203.03>, <-85.8333,-10.8333,1203.03>, <-89.1667,-14.1667,1203.03>, <-90,-15,1203.03>,
<-85,-10,1069.7>, <-85.8333,-10.8333,1069.7>, <-89.1667,-14.1667,1069.7>, <-90,-15,1069.7>,
<-85,-10,536.366>, <-85.8333,-10.8333,536.366>, <-89.1667,-14.1667,536.366>, <-90,-15,536.366>,
<-85,-10,403.033>, <-85.8333,-10.8333,403.033>, <-89.1667,-14.1667,403.033>, <-90,-15,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-90,-15,1203.03>, <-93.3333,-15,1203.03>, <-106.667,-15,1203.03>, <-110,-15,1203.03>,
<-90,-15,1069.7>, <-93.3333,-15,1069.7>, <-106.667,-15,1069.7>, <-110,-15,1069.7>,
<-90,-15,536.366>, <-93.3333,-15,536.366>, <-106.667,-15,536.366>, <-110,-15,536.366>,
<-90,-15,403.033>, <-93.3333,-15,403.033>, <-106.667,-15,403.033>, <-110,-15,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-110,15,403.033>, <-106.667,15,403.033>, <-93.3333,15,403.033>, <-90,15,403.033>,
<-110,10,403.033>, <-106.667,10,403.033>, <-93.3333,10,403.033>, <-90,10,403.033>,
<-110,-10,403.033>, <-106.667,-10,403.033>, <-93.3333,-10,403.033>, <-90,-10,403.033>,
<-110,-15,403.033>, <-106.667,-15,403.033>, <-93.3333,-15,403.033>, <-90,-15,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-90,15,403.033>, <-89.1667,14.1667,403.033>, <-85.8333,10.8333,403.033>, <-85,10,403.033>,
<-90,10,403.033>, <-89.1667,9.72222,403.033>, <-85.8333,6.94444,403.033>, <-85,6.66667,403.033>,
<-90,-10,403.033>, <-89.1667,-9.72222,403.033>, <-85.8333,-6.94444,403.033>, <-85,-6.66667,403.033>,
<-90,-15,403.033>, <-89.1667,-14.1667,403.033>, <-85.8333,-10.8333,403.033>, <-85,-10,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-110,15,1203.03>, <-110,15,1069.7>, <-110,15,536.366>, <-110,15,403.033>,
<-110.833,14.1667,1203.03>, <-110.833,14.1667,1069.7>, <-110.833,14.1667,536.366>, <-110.833,14.1667,403.033>,
<-114.167,10.8333,1203.03>, <-114.167,10.8333,1069.7>, <-114.167,10.8333,536.366>, <-114.167,10.8333,403.033>,
<-115,10,1203.03>, <-115,10,1069.7>, <-115,10,536.366>, <-115,10,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-110,15,1203.03>, <-110.833,14.1667,1203.03>, <-114.167,10.8333,1203.03>, <-115,10,1203.03>,
<-110,10,1203.03>, <-110.833,9.72222,1203.03>, <-114.167,6.94444,1203.03>, <-115,6.66667,1203.03>,
<-110,-10,1203.03>, <-110.833,-9.72222,1203.03>, <-114.167,-6.94444,1203.03>, <-115,-6.66667,1203.03>,
<-110,-15,1203.03>, <-110.833,-14.1667,1203.03>, <-114.167,-10.8333,1203.03>, <-115,-10,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-110,-15,1203.03>, <-110.833,-14.1667,1203.03>, <-114.167,-10.8333,1203.03>, <-115,-10,1203.03>,
<-110,-15,1069.7>, <-110.833,-14.1667,1069.7>, <-114.167,-10.8333,1069.7>, <-115,-10,1069.7>,
<-110,-15,536.366>, <-110.833,-14.1667,536.366>, <-114.167,-10.8333,536.366>, <-115,-10,536.366>,
<-110,-15,403.033>, <-110.833,-14.1667,403.033>, <-114.167,-10.8333,403.033>, <-115,-10,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-110,15,403.033>, <-110,10,403.033>, <-110,-10,403.033>, <-110,-15,403.033>,
<-110.833,14.1667,403.033>, <-110.833,9.72222,403.033>, <-110.833,-9.72222,403.033>, <-110.833,-14.1667,403.033>,
<-114.167,10.8333,403.033>, <-114.167,6.94444,403.033>, <-114.167,-6.94444,403.033>, <-114.167,-10.8333,403.033>,
<-115,10,403.033>, <-115,6.66667,403.033>, <-115,-6.66667,403.033>, <-115,-10,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<110,15,1203.03>, <110,15,1069.7>, <110,15,536.366>, <110,15,403.033>,
<106.667,15,1203.03>, <106.667,15,1069.7>, <106.667,15,536.366>, <106.667,15,403.033>,
<93.3333,15,1203.03>, <93.3333,15,1069.7>, <93.3333,15,536.366>, <93.3333,15,403.033>,
<90,15,1203.03>, <90,15,1069.7>, <90,15,536.366>, <90,15,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<110,15,1203.03>, <110.833,14.1667,1203.03>, <114.167,10.8333,1203.03>, <115,10,1203.03>,
<110,15,1069.7>, <110.833,14.1667,1069.7>, <114.167,10.8333,1069.7>, <115,10,1069.7>,
<110,15,536.366>, <110.833,14.1667,536.366>, <114.167,10.8333,536.366>, <115,10,536.366>,
<110,15,403.033>, <110.833,14.1667,403.033>, <114.167,10.8333,403.033>, <115,10,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<110,15,1203.03>, <110,10,1203.03>, <110,-10,1203.03>, <110,-15,1203.03>,
<110.833,14.1667,1203.03>, <110.833,9.72222,1203.03>, <110.833,-9.72222,1203.03>, <110.833,-14.1667,1203.03>,
<114.167,10.8333,1203.03>, <114.167,6.94444,1203.03>, <114.167,-6.94444,1203.03>, <114.167,-10.8333,1203.03>,
<115,10,1203.03>, <115,6.66667,1203.03>, <115,-6.66667,1203.03>, <115,-10,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<110,15,1203.03>, <106.667,15,1203.03>, <93.3333,15,1203.03>, <90,15,1203.03>,
<110,10,1203.03>, <106.667,10,1203.03>, <93.3333,10,1203.03>, <90,10,1203.03>,
<110,-10,1203.03>, <106.667,-10,1203.03>, <93.3333,-10,1203.03>, <90,-10,1203.03>,
<110,-15,1203.03>, <106.667,-15,1203.03>, <93.3333,-15,1203.03>, <90,-15,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<115,-10,1203.03>, <114.167,-10.8333,1203.03>, <110.833,-14.1667,1203.03>, <110,-15,1203.03>,
<115,-10,1069.7>, <114.167,-10.8333,1069.7>, <110.833,-14.1667,1069.7>, <110,-15,1069.7>,
<115,-10,536.366>, <114.167,-10.8333,536.366>, <110.833,-14.1667,536.366>, <110,-15,536.366>,
<115,-10,403.033>, <114.167,-10.8333,403.033>, <110.833,-14.1667,403.033>, <110,-15,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<110,-15,1203.03>, <106.667,-15,1203.03>, <93.3333,-15,1203.03>, <90,-15,1203.03>,
<110,-15,1069.7>, <106.667,-15,1069.7>, <93.3333,-15,1069.7>, <90,-15,1069.7>,
<110,-15,536.366>, <106.667,-15,536.366>, <93.3333,-15,536.366>, <90,-15,536.366>,
<110,-15,403.033>, <106.667,-15,403.033>, <93.3333,-15,403.033>, <90,-15,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<90,15,403.033>, <93.3333,15,403.033>, <106.667,15,403.033>, <110,15,403.033>,
<90,10,403.033>, <93.3333,10,403.033>, <106.667,10,403.033>, <110,10,403.033>,
<90,-10,403.033>, <93.3333,-10,403.033>, <106.667,-10,403.033>, <110,-10,403.033>,
<90,-15,403.033>, <93.3333,-15,403.033>, <106.667,-15,403.033>, <110,-15,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<110,15,403.033>, <110.833,14.1667,403.033>, <114.167,10.8333,403.033>, <115,10,403.033>,
<110,10,403.033>, <110.833,9.72222,403.033>, <114.167,6.94444,403.033>, <115,6.66667,403.033>,
<110,-10,403.033>, <110.833,-9.72222,403.033>, <114.167,-6.94444,403.033>, <115,-6.66667,403.033>,
<110,-15,403.033>, <110.833,-14.1667,403.033>, <114.167,-10.8333,403.033>, <115,-10,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<90,15,1203.03>, <90,15,1069.7>, <90,15,536.366>, <90,15,403.033>,
<89.1667,14.1667,1203.03>, <89.1667,14.1667,1069.7>, <89.1667,14.1667,536.366>, <89.1667,14.1667,403.033>,
<85.8333,10.8333,1203.03>, <85.8333,10.8333,1069.7>, <85.8333,10.8333,536.366>, <85.8333,10.8333,403.033>,
<85,10,1203.03>, <85,10,1069.7>, <85,10,536.366>, <85,10,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<90,15,1203.03>, <89.1667,14.1667,1203.03>, <85.8333,10.8333,1203.03>, <85,10,1203.03>,
<90,10,1203.03>, <89.1667,9.72222,1203.03>, <85.8333,6.94444,1203.03>, <85,6.66667,1203.03>,
<90,-10,1203.03>, <89.1667,-9.72222,1203.03>, <85.8333,-6.94444,1203.03>, <85,-6.66667,1203.03>,
<90,-15,1203.03>, <89.1667,-14.1667,1203.03>, <85.8333,-10.8333,1203.03>, <85,-10,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<90,-15,1203.03>, <89.1667,-14.1667,1203.03>, <85.8333,-10.8333,1203.03>, <85,-10,1203.03>,
<90,-15,1069.7>, <89.1667,-14.1667,1069.7>, <85.8333,-10.8333,1069.7>, <85,-10,1069.7>,
<90,-15,536.366>, <89.1667,-14.1667,536.366>, <85.8333,-10.8333,536.366>, <85,-10,536.366>,
<90,-15,403.033>, <89.1667,-14.1667,403.033>, <85.8333,-10.8333,403.033>, <85,-10,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<85,10,403.033>, <85.8333,10.8333,403.033>, <89.1667,14.1667,403.033>, <90,15,403.033>,
<85,6.66667,403.033>, <85.8333,6.94444,403.033>, <89.1667,9.72222,403.033>, <90,10,403.033>,
<85,-6.66667,403.033>, <85.8333,-6.94444,403.033>, <89.1667,-9.72222,403.033>, <90,-10,403.033>,
<85,-10,403.033>, <85.8333,-10.8333,403.033>, <89.1667,-14.1667,403.033>, <90,-15,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<85,10,1203.03>, <85,10,1069.7>, <85,10,536.366>, <85,10,403.033>,
<85,6.66667,1203.03>, <85,6.66667,1069.7>, <85,6.66667,536.366>, <85,6.66667,403.033>,
<85,-6.66667,1203.03>, <85,-6.66667,1069.7>, <85,-6.66667,536.366>, <85,-6.66667,403.033>,
<85,-10,1203.03>, <85,-10,1069.7>, <85,-10,536.366>, <85,-10,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<115,10,1203.03>, <115,6.66667,1203.03>, <115,-6.66667,1203.03>, <115,-10,1203.03>,
<115,10,1069.7>, <115,6.66667,1069.7>, <115,-6.66667,1069.7>, <115,-10,1069.7>,
<115,10,536.366>, <115,6.66667,536.366>, <115,-6.66667,536.366>, <115,-10,536.366>,
<115,10,403.033>, <115,6.66667,403.033>, <115,-6.66667,403.033>, <115,-10,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-115,-10,1203.03>, <-115,-6.66667,1203.03>, <-115,6.66667,1203.03>, <-115,10,1203.03>,
<-115,-10,1069.7>, <-115,-6.66667,1069.7>, <-115,6.66667,1069.7>, <-115,10,1069.7>,
<-115,-10,536.366>, <-115,-6.66667,536.366>, <-115,6.66667,536.366>, <-115,10,536.366>,
<-115,-10,403.033>, <-115,-6.66667,403.033>, <-115,6.66667,403.033>, <-115,10,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-85,10,1203.03>, <-85,6.66667,1203.03>, <-85,-6.66667,1203.03>, <-85,-10,1203.03>,
<-85,10,1069.7>, <-85,6.66667,1069.7>, <-85,-6.66667,1069.7>, <-85,-10,1069.7>,
<-85,10,536.366>, <-85,6.66667,536.366>, <-85,-6.66667,536.366>, <-85,-10,536.366>,
<-85,10,403.033>, <-85,6.66667,403.033>, <-85,-6.66667,403.033>, <-85,-10,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,5,494.033>, <-54.3333,5,494.033>, <54.3333,5,494.033>, <81.5,5,494.033>,
<-81.5,3.33333,494.033>, <-54.3333,3.33333,494.033>, <54.3333,3.33333,494.033>, <81.5,3.33333,494.033>,
<-81.5,-3.33333,494.033>, <-54.3333,-3.33333,494.033>, <54.3333,-3.33333,494.033>, <81.5,-3.33333,494.033>,
<-81.5,-5,494.033>, <-54.3333,-5,494.033>, <54.3333,-5,494.033>, <81.5,-5,494.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,5,494.033>, <-81.5,3.33333,494.033>, <-81.5,-3.33333,494.033>, <-81.5,-5,494.033>,
<-81.5,5,479.033>, <-81.5,3.33333,479.033>, <-81.5,-3.33333,479.033>, <-81.5,-5,479.033>,
<-81.5,5,419.033>, <-81.5,3.33333,419.033>, <-81.5,-3.33333,419.033>, <-81.5,-5,419.033>,
<-81.5,5,404.033>, <-81.5,3.33333,404.033>, <-81.5,-3.33333,404.033>, <-81.5,-5,404.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,-5,404.033>, <-54.3333,-5,404.033>, <54.3333,-5,404.033>, <81.5,-5,404.033>,
<-81.5,-3.33333,404.033>, <-54.3333,-3.33333,404.033>, <54.3333,-3.33333,404.033>, <81.5,-3.33333,404.033>,
<-81.5,3.33333,404.033>, <-54.3333,3.33333,404.033>, <54.3333,3.33333,404.033>, <81.5,3.33333,404.033>,
<-81.5,5,404.033>, <-54.3333,5,404.033>, <54.3333,5,404.033>, <81.5,5,404.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<81.5,-5,404.033>, <81.5,-5,419.033>, <81.5,-5,479.033>, <81.5,-5,494.033>,
<81.5,-3.33333,404.033>, <81.5,-3.33333,419.033>, <81.5,-3.33333,479.033>, <81.5,-3.33333,494.033>,
<81.5,3.33333,404.033>, <81.5,3.33333,419.033>, <81.5,3.33333,479.033>, <81.5,3.33333,494.033>,
<81.5,5,404.033>, <81.5,5,419.033>, <81.5,5,479.033>, <81.5,5,494.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,-5,1202.03>, <-54.3333,-5,1202.03>, <54.3333,-5,1202.03>, <81.5,-5,1202.03>,
<-81.5,-3.33333,1202.03>, <-54.3333,-3.33333,1202.03>, <54.3333,-3.33333,1202.03>, <81.5,-3.33333,1202.03>,
<-81.5,3.33333,1202.03>, <-54.3333,3.33333,1202.03>, <54.3333,3.33333,1202.03>, <81.5,3.33333,1202.03>,
<-81.5,5,1202.03>, <-54.3333,5,1202.03>, <54.3333,5,1202.03>, <81.5,5,1202.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,-5,1202.03>, <-81.5,-3.33333,1202.03>, <-81.5,3.33333,1202.03>, <-81.5,5,1202.03>,
<-81.5,-5,1187.03>, <-81.5,-3.33333,1187.03>, <-81.5,3.33333,1187.03>, <-81.5,5,1187.03>,
<-81.5,-5,1127.03>, <-81.5,-3.33333,1127.03>, <-81.5,3.33333,1127.03>, <-81.5,5,1127.03>,
<-81.5,-5,1112.03>, <-81.5,-3.33333,1112.03>, <-81.5,3.33333,1112.03>, <-81.5,5,1112.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,-5,1112.03>, <-81.5,-3.33333,1112.03>, <-81.5,3.33333,1112.03>, <-81.5,5,1112.03>,
<-54.3333,-5,1112.03>, <-54.3333,-3.33333,1112.03>, <-54.3333,3.33333,1112.03>, <-54.3333,5,1112.03>,
<54.3333,-5,1112.03>, <54.3333,-3.33333,1112.03>, <54.3333,3.33333,1112.03>, <54.3333,5,1112.03>,
<81.5,-5,1112.03>, <81.5,-3.33333,1112.03>, <81.5,3.33333,1112.03>, <81.5,5,1112.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<81.5,-5,1112.03>, <81.5,-3.33333,1112.03>, <81.5,3.33333,1112.03>, <81.5,5,1112.03>,
<81.5,-5,1127.03>, <81.5,-3.33333,1127.03>, <81.5,3.33333,1127.03>, <81.5,5,1127.03>,
<81.5,-5,1187.03>, <81.5,-3.33333,1187.03>, <81.5,3.33333,1187.03>, <81.5,5,1187.03>,
<81.5,-5,1202.03>, <81.5,-3.33333,1202.03>, <81.5,3.33333,1202.03>, <81.5,5,1202.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-28,-4,1113.03>, <-28.3333,-3.66667,1113.03>, <-29.6667,-2.33333,1113.03>, <-30,-2,1113.03>,
<-28,-4,1009.7>, <-28.3333,-3.66667,1009.7>, <-29.6667,-2.33333,1009.7>, <-30,-2,1009.7>,
<-28,-4,596.366>, <-28.3333,-3.66667,596.366>, <-29.6667,-2.33333,596.366>, <-30,-2,596.366>,
<-28,-4,493.033>, <-28.3333,-3.66667,493.033>, <-29.6667,-2.33333,493.033>, <-30,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-30,2,1113.03>, <-30,2,1009.7>, <-30,2,596.366>, <-30,2,493.033>,
<-30,1.33333,1113.03>, <-30,1.33333,1009.7>, <-30,1.33333,596.366>, <-30,1.33333,493.033>,
<-30,-1.33333,1113.03>, <-30,-1.33333,1009.7>, <-30,-1.33333,596.366>, <-30,-1.33333,493.033>,
<-30,-2,1113.03>, <-30,-2,1009.7>, <-30,-2,596.366>, <-30,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-20,-4,1113.03>, <-21.3333,-4,1113.03>, <-26.6667,-4,1113.03>, <-28,-4,1113.03>,
<-20,-4,1009.7>, <-21.3333,-4,1009.7>, <-26.6667,-4,1009.7>, <-28,-4,1009.7>,
<-20,-4,596.366>, <-21.3333,-4,596.366>, <-26.6667,-4,596.366>, <-28,-4,596.366>,
<-20,-4,493.033>, <-21.3333,-4,493.033>, <-26.6667,-4,493.033>, <-28,-4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-18,-2,1113.03>, <-18.3333,-2.33333,1113.03>, <-19.6667,-3.66667,1113.03>, <-20,-4,1113.03>,
<-18,-2,1009.7>, <-18.3333,-2.33333,1009.7>, <-19.6667,-3.66667,1009.7>, <-20,-4,1009.7>,
<-18,-2,596.366>, <-18.3333,-2.33333,596.366>, <-19.6667,-3.66667,596.366>, <-20,-4,596.366>,
<-18,-2,493.033>, <-18.3333,-2.33333,493.033>, <-19.6667,-3.66667,493.033>, <-20,-4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-18,2,1113.03>, <-18,1.33333,1113.03>, <-18,-1.33333,1113.03>, <-18,-2,1113.03>,
<-18,2,1009.7>, <-18,1.33333,1009.7>, <-18,-1.33333,1009.7>, <-18,-2,1009.7>,
<-18,2,596.366>, <-18,1.33333,596.366>, <-18,-1.33333,596.366>, <-18,-2,596.366>,
<-18,2,493.033>, <-18,1.33333,493.033>, <-18,-1.33333,493.033>, <-18,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-20,4,1113.03>, <-19.6667,3.66667,1113.03>, <-18.3333,2.33333,1113.03>, <-18,2,1113.03>,
<-20,4,1009.7>, <-19.6667,3.66667,1009.7>, <-18.3333,2.33333,1009.7>, <-18,2,1009.7>,
<-20,4,596.366>, <-19.6667,3.66667,596.366>, <-18.3333,2.33333,596.366>, <-18,2,596.366>,
<-20,4,493.033>, <-19.6667,3.66667,493.033>, <-18.3333,2.33333,493.033>, <-18,2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-28,4,1113.03>, <-26.6667,4,1113.03>, <-21.3333,4,1113.03>, <-20,4,1113.03>,
<-28,4,1009.7>, <-26.6667,4,1009.7>, <-21.3333,4,1009.7>, <-20,4,1009.7>,
<-28,4,596.366>, <-26.6667,4,596.366>, <-21.3333,4,596.366>, <-20,4,596.366>,
<-28,4,493.033>, <-26.6667,4,493.033>, <-21.3333,4,493.033>, <-20,4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-30,2,1113.03>, <-29.6667,2.33333,1113.03>, <-28.3333,3.66667,1113.03>, <-28,4,1113.03>,
<-30,2,1009.7>, <-29.6667,2.33333,1009.7>, <-28.3333,3.66667,1009.7>, <-28,4,1009.7>,
<-30,2,596.366>, <-29.6667,2.33333,596.366>, <-28.3333,3.66667,596.366>, <-28,4,596.366>,
<-30,2,493.033>, <-29.6667,2.33333,493.033>, <-28.3333,3.66667,493.033>, <-28,4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-60,-4,1113.03>, <-60.3333,-3.66667,1113.03>, <-61.6667,-2.33333,1113.03>, <-62,-2,1113.03>,
<-60,-4,1009.7>, <-60.3333,-3.66667,1009.7>, <-61.6667,-2.33333,1009.7>, <-62,-2,1009.7>,
<-60,-4,596.366>, <-60.3333,-3.66667,596.366>, <-61.6667,-2.33333,596.366>, <-62,-2,596.366>,
<-60,-4,493.033>, <-60.3333,-3.66667,493.033>, <-61.6667,-2.33333,493.033>, <-62,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-62,2,1113.03>, <-62,2,1009.7>, <-62,2,596.366>, <-62,2,493.033>,
<-62,1.33333,1113.03>, <-62,1.33333,1009.7>, <-62,1.33333,596.366>, <-62,1.33333,493.033>,
<-62,-1.33333,1113.03>, <-62,-1.33333,1009.7>, <-62,-1.33333,596.366>, <-62,-1.33333,493.033>,
<-62,-2,1113.03>, <-62,-2,1009.7>, <-62,-2,596.366>, <-62,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-52,-4,1113.03>, <-53.3333,-4,1113.03>, <-58.6667,-4,1113.03>, <-60,-4,1113.03>,
<-52,-4,1009.7>, <-53.3333,-4,1009.7>, <-58.6667,-4,1009.7>, <-60,-4,1009.7>,
<-52,-4,596.366>, <-53.3333,-4,596.366>, <-58.6667,-4,596.366>, <-60,-4,596.366>,
<-52,-4,493.033>, <-53.3333,-4,493.033>, <-58.6667,-4,493.033>, <-60,-4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-50,-2,1113.03>, <-50.3333,-2.33333,1113.03>, <-51.6667,-3.66667,1113.03>, <-52,-4,1113.03>,
<-50,-2,1009.7>, <-50.3333,-2.33333,1009.7>, <-51.6667,-3.66667,1009.7>, <-52,-4,1009.7>,
<-50,-2,596.366>, <-50.3333,-2.33333,596.366>, <-51.6667,-3.66667,596.366>, <-52,-4,596.366>,
<-50,-2,493.033>, <-50.3333,-2.33333,493.033>, <-51.6667,-3.66667,493.033>, <-52,-4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-50,2,1113.03>, <-50,1.33333,1113.03>, <-50,-1.33333,1113.03>, <-50,-2,1113.03>,
<-50,2,1009.7>, <-50,1.33333,1009.7>, <-50,-1.33333,1009.7>, <-50,-2,1009.7>,
<-50,2,596.366>, <-50,1.33333,596.366>, <-50,-1.33333,596.366>, <-50,-2,596.366>,
<-50,2,493.033>, <-50,1.33333,493.033>, <-50,-1.33333,493.033>, <-50,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-52,4,1113.03>, <-51.6667,3.66667,1113.03>, <-50.3333,2.33333,1113.03>, <-50,2,1113.03>,
<-52,4,1009.7>, <-51.6667,3.66667,1009.7>, <-50.3333,2.33333,1009.7>, <-50,2,1009.7>,
<-52,4,596.366>, <-51.6667,3.66667,596.366>, <-50.3333,2.33333,596.366>, <-50,2,596.366>,
<-52,4,493.033>, <-51.6667,3.66667,493.033>, <-50.3333,2.33333,493.033>, <-50,2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-60,4,1113.03>, <-58.6667,4,1113.03>, <-53.3333,4,1113.03>, <-52,4,1113.03>,
<-60,4,1009.7>, <-58.6667,4,1009.7>, <-53.3333,4,1009.7>, <-52,4,1009.7>,
<-60,4,596.366>, <-58.6667,4,596.366>, <-53.3333,4,596.366>, <-52,4,596.366>,
<-60,4,493.033>, <-58.6667,4,493.033>, <-53.3333,4,493.033>, <-52,4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-62,2,1113.03>, <-61.6667,2.33333,1113.03>, <-60.3333,3.66667,1113.03>, <-60,4,1113.03>,
<-62,2,1009.7>, <-61.6667,2.33333,1009.7>, <-60.3333,3.66667,1009.7>, <-60,4,1009.7>,
<-62,2,596.366>, <-61.6667,2.33333,596.366>, <-60.3333,3.66667,596.366>, <-60,4,596.366>,
<-62,2,493.033>, <-61.6667,2.33333,493.033>, <-60.3333,3.66667,493.033>, <-60,4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-12,-4,1113.03>, <-12.3333,-3.66667,1113.03>, <-13.6667,-2.33333,1113.03>, <-14,-2,1113.03>,
<-12,-4,1009.7>, <-12.3333,-3.66667,1009.7>, <-13.6667,-2.33333,1009.7>, <-14,-2,1009.7>,
<-12,-4,596.366>, <-12.3333,-3.66667,596.366>, <-13.6667,-2.33333,596.366>, <-14,-2,596.366>,
<-12,-4,493.033>, <-12.3333,-3.66667,493.033>, <-13.6667,-2.33333,493.033>, <-14,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-14,2,1113.03>, <-14,2,1009.7>, <-14,2,596.366>, <-14,2,493.033>,
<-14,1.33333,1113.03>, <-14,1.33333,1009.7>, <-14,1.33333,596.366>, <-14,1.33333,493.033>,
<-14,-1.33333,1113.03>, <-14,-1.33333,1009.7>, <-14,-1.33333,596.366>, <-14,-1.33333,493.033>,
<-14,-2,1113.03>, <-14,-2,1009.7>, <-14,-2,596.366>, <-14,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-4,-4,1113.03>, <-5.33333,-4,1113.03>, <-10.6667,-4,1113.03>, <-12,-4,1113.03>,
<-4,-4,1009.7>, <-5.33333,-4,1009.7>, <-10.6667,-4,1009.7>, <-12,-4,1009.7>,
<-4,-4,596.366>, <-5.33333,-4,596.366>, <-10.6667,-4,596.366>, <-12,-4,596.366>,
<-4,-4,493.033>, <-5.33333,-4,493.033>, <-10.6667,-4,493.033>, <-12,-4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-2,-2,1113.03>, <-2.33333,-2.33333,1113.03>, <-3.66667,-3.66667,1113.03>, <-4,-4,1113.03>,
<-2,-2,1009.7>, <-2.33333,-2.33333,1009.7>, <-3.66667,-3.66667,1009.7>, <-4,-4,1009.7>,
<-2,-2,596.366>, <-2.33333,-2.33333,596.366>, <-3.66667,-3.66667,596.366>, <-4,-4,596.366>,
<-2,-2,493.033>, <-2.33333,-2.33333,493.033>, <-3.66667,-3.66667,493.033>, <-4,-4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-2,2,1113.03>, <-2,1.33333,1113.03>, <-2,-1.33333,1113.03>, <-2,-2,1113.03>,
<-2,2,1009.7>, <-2,1.33333,1009.7>, <-2,-1.33333,1009.7>, <-2,-2,1009.7>,
<-2,2,596.366>, <-2,1.33333,596.366>, <-2,-1.33333,596.366>, <-2,-2,596.366>,
<-2,2,493.033>, <-2,1.33333,493.033>, <-2,-1.33333,493.033>, <-2,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-4,4,1113.03>, <-3.66667,3.66667,1113.03>, <-2.33333,2.33333,1113.03>, <-2,2,1113.03>,
<-4,4,1009.7>, <-3.66667,3.66667,1009.7>, <-2.33333,2.33333,1009.7>, <-2,2,1009.7>,
<-4,4,596.366>, <-3.66667,3.66667,596.366>, <-2.33333,2.33333,596.366>, <-2,2,596.366>,
<-4,4,493.033>, <-3.66667,3.66667,493.033>, <-2.33333,2.33333,493.033>, <-2,2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-12,4,1113.03>, <-10.6667,4,1113.03>, <-5.33333,4,1113.03>, <-4,4,1113.03>,
<-12,4,1009.7>, <-10.6667,4,1009.7>, <-5.33333,4,1009.7>, <-4,4,1009.7>,
<-12,4,596.366>, <-10.6667,4,596.366>, <-5.33333,4,596.366>, <-4,4,596.366>,
<-12,4,493.033>, <-10.6667,4,493.033>, <-5.33333,4,493.033>, <-4,4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-14,2,1113.03>, <-13.6667,2.33333,1113.03>, <-12.3333,3.66667,1113.03>, <-12,4,1113.03>,
<-14,2,1009.7>, <-13.6667,2.33333,1009.7>, <-12.3333,3.66667,1009.7>, <-12,4,1009.7>,
<-14,2,596.366>, <-13.6667,2.33333,596.366>, <-12.3333,3.66667,596.366>, <-12,4,596.366>,
<-14,2,493.033>, <-13.6667,2.33333,493.033>, <-12.3333,3.66667,493.033>, <-12,4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-76,-4,1113.03>, <-76.3333,-3.66667,1113.03>, <-77.6667,-2.33333,1113.03>, <-78,-2,1113.03>,
<-76,-4,1009.7>, <-76.3333,-3.66667,1009.7>, <-77.6667,-2.33333,1009.7>, <-78,-2,1009.7>,
<-76,-4,596.366>, <-76.3333,-3.66667,596.366>, <-77.6667,-2.33333,596.366>, <-78,-2,596.366>,
<-76,-4,493.033>, <-76.3333,-3.66667,493.033>, <-77.6667,-2.33333,493.033>, <-78,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-78,2,1113.03>, <-78,2,1009.7>, <-78,2,596.366>, <-78,2,493.033>,
<-78,1.33333,1113.03>, <-78,1.33333,1009.7>, <-78,1.33333,596.366>, <-78,1.33333,493.033>,
<-78,-1.33333,1113.03>, <-78,-1.33333,1009.7>, <-78,-1.33333,596.366>, <-78,-1.33333,493.033>,
<-78,-2,1113.03>, <-78,-2,1009.7>, <-78,-2,596.366>, <-78,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-68,-4,1113.03>, <-69.3333,-4,1113.03>, <-74.6667,-4,1113.03>, <-76,-4,1113.03>,
<-68,-4,1009.7>, <-69.3333,-4,1009.7>, <-74.6667,-4,1009.7>, <-76,-4,1009.7>,
<-68,-4,596.366>, <-69.3333,-4,596.366>, <-74.6667,-4,596.366>, <-76,-4,596.366>,
<-68,-4,493.033>, <-69.3333,-4,493.033>, <-74.6667,-4,493.033>, <-76,-4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-66,-2,1113.03>, <-66.3333,-2.33333,1113.03>, <-67.6667,-3.66667,1113.03>, <-68,-4,1113.03>,
<-66,-2,1009.7>, <-66.3333,-2.33333,1009.7>, <-67.6667,-3.66667,1009.7>, <-68,-4,1009.7>,
<-66,-2,596.366>, <-66.3333,-2.33333,596.366>, <-67.6667,-3.66667,596.366>, <-68,-4,596.366>,
<-66,-2,493.033>, <-66.3333,-2.33333,493.033>, <-67.6667,-3.66667,493.033>, <-68,-4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-66,2,1113.03>, <-66,1.33333,1113.03>, <-66,-1.33333,1113.03>, <-66,-2,1113.03>,
<-66,2,1009.7>, <-66,1.33333,1009.7>, <-66,-1.33333,1009.7>, <-66,-2,1009.7>,
<-66,2,596.366>, <-66,1.33333,596.366>, <-66,-1.33333,596.366>, <-66,-2,596.366>,
<-66,2,493.033>, <-66,1.33333,493.033>, <-66,-1.33333,493.033>, <-66,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-68,4,1113.03>, <-67.6667,3.66667,1113.03>, <-66.3333,2.33333,1113.03>, <-66,2,1113.03>,
<-68,4,1009.7>, <-67.6667,3.66667,1009.7>, <-66.3333,2.33333,1009.7>, <-66,2,1009.7>,
<-68,4,596.366>, <-67.6667,3.66667,596.366>, <-66.3333,2.33333,596.366>, <-66,2,596.366>,
<-68,4,493.033>, <-67.6667,3.66667,493.033>, <-66.3333,2.33333,493.033>, <-66,2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-76,4,1113.03>, <-74.6667,4,1113.03>, <-69.3333,4,1113.03>, <-68,4,1113.03>,
<-76,4,1009.7>, <-74.6667,4,1009.7>, <-69.3333,4,1009.7>, <-68,4,1009.7>,
<-76,4,596.366>, <-74.6667,4,596.366>, <-69.3333,4,596.366>, <-68,4,596.366>,
<-76,4,493.033>, <-74.6667,4,493.033>, <-69.3333,4,493.033>, <-68,4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-78,2,1113.03>, <-77.6667,2.33333,1113.03>, <-76.3333,3.66667,1113.03>, <-76,4,1113.03>,
<-78,2,1009.7>, <-77.6667,2.33333,1009.7>, <-76.3333,3.66667,1009.7>, <-76,4,1009.7>,
<-78,2,596.366>, <-77.6667,2.33333,596.366>, <-76.3333,3.66667,596.366>, <-76,4,596.366>,
<-78,2,493.033>, <-77.6667,2.33333,493.033>, <-76.3333,3.66667,493.033>, <-76,4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-44,-4,1113.03>, <-44.3333,-3.66667,1113.03>, <-45.6667,-2.33333,1113.03>, <-46,-2,1113.03>,
<-44,-4,1009.7>, <-44.3333,-3.66667,1009.7>, <-45.6667,-2.33333,1009.7>, <-46,-2,1009.7>,
<-44,-4,596.366>, <-44.3333,-3.66667,596.366>, <-45.6667,-2.33333,596.366>, <-46,-2,596.366>,
<-44,-4,493.033>, <-44.3333,-3.66667,493.033>, <-45.6667,-2.33333,493.033>, <-46,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-46,2,1113.03>, <-46,2,1009.7>, <-46,2,596.366>, <-46,2,493.033>,
<-46,1.33333,1113.03>, <-46,1.33333,1009.7>, <-46,1.33333,596.366>, <-46,1.33333,493.033>,
<-46,-1.33333,1113.03>, <-46,-1.33333,1009.7>, <-46,-1.33333,596.366>, <-46,-1.33333,493.033>,
<-46,-2,1113.03>, <-46,-2,1009.7>, <-46,-2,596.366>, <-46,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-36,-4,1113.03>, <-37.3333,-4,1113.03>, <-42.6667,-4,1113.03>, <-44,-4,1113.03>,
<-36,-4,1009.7>, <-37.3333,-4,1009.7>, <-42.6667,-4,1009.7>, <-44,-4,1009.7>,
<-36,-4,596.366>, <-37.3333,-4,596.366>, <-42.6667,-4,596.366>, <-44,-4,596.366>,
<-36,-4,493.033>, <-37.3333,-4,493.033>, <-42.6667,-4,493.033>, <-44,-4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-34,-2,1113.03>, <-34.3333,-2.33333,1113.03>, <-35.6667,-3.66667,1113.03>, <-36,-4,1113.03>,
<-34,-2,1009.7>, <-34.3333,-2.33333,1009.7>, <-35.6667,-3.66667,1009.7>, <-36,-4,1009.7>,
<-34,-2,596.366>, <-34.3333,-2.33333,596.366>, <-35.6667,-3.66667,596.366>, <-36,-4,596.366>,
<-34,-2,493.033>, <-34.3333,-2.33333,493.033>, <-35.6667,-3.66667,493.033>, <-36,-4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-34,2,1113.03>, <-34,1.33333,1113.03>, <-34,-1.33333,1113.03>, <-34,-2,1113.03>,
<-34,2,1009.7>, <-34,1.33333,1009.7>, <-34,-1.33333,1009.7>, <-34,-2,1009.7>,
<-34,2,596.366>, <-34,1.33333,596.366>, <-34,-1.33333,596.366>, <-34,-2,596.366>,
<-34,2,493.033>, <-34,1.33333,493.033>, <-34,-1.33333,493.033>, <-34,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-36,4,1113.03>, <-35.6667,3.66667,1113.03>, <-34.3333,2.33333,1113.03>, <-34,2,1113.03>,
<-36,4,1009.7>, <-35.6667,3.66667,1009.7>, <-34.3333,2.33333,1009.7>, <-34,2,1009.7>,
<-36,4,596.366>, <-35.6667,3.66667,596.366>, <-34.3333,2.33333,596.366>, <-34,2,596.366>,
<-36,4,493.033>, <-35.6667,3.66667,493.033>, <-34.3333,2.33333,493.033>, <-34,2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-44,4,1113.03>, <-42.6667,4,1113.03>, <-37.3333,4,1113.03>, <-36,4,1113.03>,
<-44,4,1009.7>, <-42.6667,4,1009.7>, <-37.3333,4,1009.7>, <-36,4,1009.7>,
<-44,4,596.366>, <-42.6667,4,596.366>, <-37.3333,4,596.366>, <-36,4,596.366>,
<-44,4,493.033>, <-42.6667,4,493.033>, <-37.3333,4,493.033>, <-36,4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-46,2,1113.03>, <-45.6667,2.33333,1113.03>, <-44.3333,3.66667,1113.03>, <-44,4,1113.03>,
<-46,2,1009.7>, <-45.6667,2.33333,1009.7>, <-44.3333,3.66667,1009.7>, <-44,4,1009.7>,
<-46,2,596.366>, <-45.6667,2.33333,596.366>, <-44.3333,3.66667,596.366>, <-44,4,596.366>,
<-46,2,493.033>, <-45.6667,2.33333,493.033>, <-44.3333,3.66667,493.033>, <-44,4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<36,-4,1113.03>, <36,-4,1009.7>, <36,-4,596.366>, <36,-4,493.033>,
<35.6667,-3.66667,1113.03>, <35.6667,-3.66667,1009.7>, <35.6667,-3.66667,596.366>, <35.6667,-3.66667,493.033>,
<34.3333,-2.33333,1113.03>, <34.3333,-2.33333,1009.7>, <34.3333,-2.33333,596.366>, <34.3333,-2.33333,493.033>,
<34,-2,1113.03>, <34,-2,1009.7>, <34,-2,596.366>, <34,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<34,2,1113.03>, <34,1.33333,1113.03>, <34,-1.33333,1113.03>, <34,-2,1113.03>,
<34,2,1009.7>, <34,1.33333,1009.7>, <34,-1.33333,1009.7>, <34,-2,1009.7>,
<34,2,596.366>, <34,1.33333,596.366>, <34,-1.33333,596.366>, <34,-2,596.366>,
<34,2,493.033>, <34,1.33333,493.033>, <34,-1.33333,493.033>, <34,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<44,-4,1113.03>, <44,-4,1009.7>, <44,-4,596.366>, <44,-4,493.033>,
<42.6667,-4,1113.03>, <42.6667,-4,1009.7>, <42.6667,-4,596.366>, <42.6667,-4,493.033>,
<37.3333,-4,1113.03>, <37.3333,-4,1009.7>, <37.3333,-4,596.366>, <37.3333,-4,493.033>,
<36,-4,1113.03>, <36,-4,1009.7>, <36,-4,596.366>, <36,-4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<46,-2,1113.03>, <46,-2,1009.7>, <46,-2,596.366>, <46,-2,493.033>,
<45.6667,-2.33333,1113.03>, <45.6667,-2.33333,1009.7>, <45.6667,-2.33333,596.366>, <45.6667,-2.33333,493.033>,
<44.3333,-3.66667,1113.03>, <44.3333,-3.66667,1009.7>, <44.3333,-3.66667,596.366>, <44.3333,-3.66667,493.033>,
<44,-4,1113.03>, <44,-4,1009.7>, <44,-4,596.366>, <44,-4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<46,2,1113.03>, <46,2,1009.7>, <46,2,596.366>, <46,2,493.033>,
<46,1.33333,1113.03>, <46,1.33333,1009.7>, <46,1.33333,596.366>, <46,1.33333,493.033>,
<46,-1.33333,1113.03>, <46,-1.33333,1009.7>, <46,-1.33333,596.366>, <46,-1.33333,493.033>,
<46,-2,1113.03>, <46,-2,1009.7>, <46,-2,596.366>, <46,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<44,4,1113.03>, <44,4,1009.7>, <44,4,596.366>, <44,4,493.033>,
<44.3333,3.66667,1113.03>, <44.3333,3.66667,1009.7>, <44.3333,3.66667,596.366>, <44.3333,3.66667,493.033>,
<45.6667,2.33333,1113.03>, <45.6667,2.33333,1009.7>, <45.6667,2.33333,596.366>, <45.6667,2.33333,493.033>,
<46,2,1113.03>, <46,2,1009.7>, <46,2,596.366>, <46,2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<36,4,1113.03>, <36,4,1009.7>, <36,4,596.366>, <36,4,493.033>,
<37.3333,4,1113.03>, <37.3333,4,1009.7>, <37.3333,4,596.366>, <37.3333,4,493.033>,
<42.6667,4,1113.03>, <42.6667,4,1009.7>, <42.6667,4,596.366>, <42.6667,4,493.033>,
<44,4,1113.03>, <44,4,1009.7>, <44,4,596.366>, <44,4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<34,2,1113.03>, <34,2,1009.7>, <34,2,596.366>, <34,2,493.033>,
<34.3333,2.33333,1113.03>, <34.3333,2.33333,1009.7>, <34.3333,2.33333,596.366>, <34.3333,2.33333,493.033>,
<35.6667,3.66667,1113.03>, <35.6667,3.66667,1009.7>, <35.6667,3.66667,596.366>, <35.6667,3.66667,493.033>,
<36,4,1113.03>, <36,4,1009.7>, <36,4,596.366>, <36,4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<4,-4,1113.03>, <3.66667,-3.66667,1113.03>, <2.33333,-2.33333,1113.03>, <2,-2,1113.03>,
<4,-4,1009.7>, <3.66667,-3.66667,1009.7>, <2.33333,-2.33333,1009.7>, <2,-2,1009.7>,
<4,-4,596.366>, <3.66667,-3.66667,596.366>, <2.33333,-2.33333,596.366>, <2,-2,596.366>,
<4,-4,493.033>, <3.66667,-3.66667,493.033>, <2.33333,-2.33333,493.033>, <2,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<2,2,1113.03>, <2,2,1009.7>, <2,2,596.366>, <2,2,493.033>,
<2,1.33333,1113.03>, <2,1.33333,1009.7>, <2,1.33333,596.366>, <2,1.33333,493.033>,
<2,-1.33333,1113.03>, <2,-1.33333,1009.7>, <2,-1.33333,596.366>, <2,-1.33333,493.033>,
<2,-2,1113.03>, <2,-2,1009.7>, <2,-2,596.366>, <2,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<12,-4,1113.03>, <10.6667,-4,1113.03>, <5.33333,-4,1113.03>, <4,-4,1113.03>,
<12,-4,1009.7>, <10.6667,-4,1009.7>, <5.33333,-4,1009.7>, <4,-4,1009.7>,
<12,-4,596.366>, <10.6667,-4,596.366>, <5.33333,-4,596.366>, <4,-4,596.366>,
<12,-4,493.033>, <10.6667,-4,493.033>, <5.33333,-4,493.033>, <4,-4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<14,-2,1113.03>, <13.6667,-2.33333,1113.03>, <12.3333,-3.66667,1113.03>, <12,-4,1113.03>,
<14,-2,1009.7>, <13.6667,-2.33333,1009.7>, <12.3333,-3.66667,1009.7>, <12,-4,1009.7>,
<14,-2,596.366>, <13.6667,-2.33333,596.366>, <12.3333,-3.66667,596.366>, <12,-4,596.366>,
<14,-2,493.033>, <13.6667,-2.33333,493.033>, <12.3333,-3.66667,493.033>, <12,-4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<14,2,1113.03>, <14,1.33333,1113.03>, <14,-1.33333,1113.03>, <14,-2,1113.03>,
<14,2,1009.7>, <14,1.33333,1009.7>, <14,-1.33333,1009.7>, <14,-2,1009.7>,
<14,2,596.366>, <14,1.33333,596.366>, <14,-1.33333,596.366>, <14,-2,596.366>,
<14,2,493.033>, <14,1.33333,493.033>, <14,-1.33333,493.033>, <14,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<12,4,1113.03>, <12.3333,3.66667,1113.03>, <13.6667,2.33333,1113.03>, <14,2,1113.03>,
<12,4,1009.7>, <12.3333,3.66667,1009.7>, <13.6667,2.33333,1009.7>, <14,2,1009.7>,
<12,4,596.366>, <12.3333,3.66667,596.366>, <13.6667,2.33333,596.366>, <14,2,596.366>,
<12,4,493.033>, <12.3333,3.66667,493.033>, <13.6667,2.33333,493.033>, <14,2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<4,4,1113.03>, <5.33333,4,1113.03>, <10.6667,4,1113.03>, <12,4,1113.03>,
<4,4,1009.7>, <5.33333,4,1009.7>, <10.6667,4,1009.7>, <12,4,1009.7>,
<4,4,596.366>, <5.33333,4,596.366>, <10.6667,4,596.366>, <12,4,596.366>,
<4,4,493.033>, <5.33333,4,493.033>, <10.6667,4,493.033>, <12,4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<2,2,1113.03>, <2.33333,2.33333,1113.03>, <3.66667,3.66667,1113.03>, <4,4,1113.03>,
<2,2,1009.7>, <2.33333,2.33333,1009.7>, <3.66667,3.66667,1009.7>, <4,4,1009.7>,
<2,2,596.366>, <2.33333,2.33333,596.366>, <3.66667,3.66667,596.366>, <4,4,596.366>,
<2,2,493.033>, <2.33333,2.33333,493.033>, <3.66667,3.66667,493.033>, <4,4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<68,-4,1113.03>, <68,-4,1009.7>, <68,-4,596.366>, <68,-4,493.033>,
<67.6667,-3.66667,1113.03>, <67.6667,-3.66667,1009.7>, <67.6667,-3.66667,596.366>, <67.6667,-3.66667,493.033>,
<66.3333,-2.33333,1113.03>, <66.3333,-2.33333,1009.7>, <66.3333,-2.33333,596.366>, <66.3333,-2.33333,493.033>,
<66,-2,1113.03>, <66,-2,1009.7>, <66,-2,596.366>, <66,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<66,2,1113.03>, <66,1.33333,1113.03>, <66,-1.33333,1113.03>, <66,-2,1113.03>,
<66,2,1009.7>, <66,1.33333,1009.7>, <66,-1.33333,1009.7>, <66,-2,1009.7>,
<66,2,596.366>, <66,1.33333,596.366>, <66,-1.33333,596.366>, <66,-2,596.366>,
<66,2,493.033>, <66,1.33333,493.033>, <66,-1.33333,493.033>, <66,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<76,-4,1113.03>, <76,-4,1009.7>, <76,-4,596.366>, <76,-4,493.033>,
<74.6667,-4,1113.03>, <74.6667,-4,1009.7>, <74.6667,-4,596.366>, <74.6667,-4,493.033>,
<69.3333,-4,1113.03>, <69.3333,-4,1009.7>, <69.3333,-4,596.366>, <69.3333,-4,493.033>,
<68,-4,1113.03>, <68,-4,1009.7>, <68,-4,596.366>, <68,-4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<78,-2,1113.03>, <78,-2,1009.7>, <78,-2,596.366>, <78,-2,493.033>,
<77.6667,-2.33333,1113.03>, <77.6667,-2.33333,1009.7>, <77.6667,-2.33333,596.366>, <77.6667,-2.33333,493.033>,
<76.3333,-3.66667,1113.03>, <76.3333,-3.66667,1009.7>, <76.3333,-3.66667,596.366>, <76.3333,-3.66667,493.033>,
<76,-4,1113.03>, <76,-4,1009.7>, <76,-4,596.366>, <76,-4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<78,2,1113.03>, <78,2,1009.7>, <78,2,596.366>, <78,2,493.033>,
<78,1.33333,1113.03>, <78,1.33333,1009.7>, <78,1.33333,596.366>, <78,1.33333,493.033>,
<78,-1.33333,1113.03>, <78,-1.33333,1009.7>, <78,-1.33333,596.366>, <78,-1.33333,493.033>,
<78,-2,1113.03>, <78,-2,1009.7>, <78,-2,596.366>, <78,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<76,4,1113.03>, <76,4,1009.7>, <76,4,596.366>, <76,4,493.033>,
<76.3333,3.66667,1113.03>, <76.3333,3.66667,1009.7>, <76.3333,3.66667,596.366>, <76.3333,3.66667,493.033>,
<77.6667,2.33333,1113.03>, <77.6667,2.33333,1009.7>, <77.6667,2.33333,596.366>, <77.6667,2.33333,493.033>,
<78,2,1113.03>, <78,2,1009.7>, <78,2,596.366>, <78,2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<68,4,1113.03>, <68,4,1009.7>, <68,4,596.366>, <68,4,493.033>,
<69.3333,4,1113.03>, <69.3333,4,1009.7>, <69.3333,4,596.366>, <69.3333,4,493.033>,
<74.6667,4,1113.03>, <74.6667,4,1009.7>, <74.6667,4,596.366>, <74.6667,4,493.033>,
<76,4,1113.03>, <76,4,1009.7>, <76,4,596.366>, <76,4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<66,2,1113.03>, <66,2,1009.7>, <66,2,596.366>, <66,2,493.033>,
<66.3333,2.33333,1113.03>, <66.3333,2.33333,1009.7>, <66.3333,2.33333,596.366>, <66.3333,2.33333,493.033>,
<67.6667,3.66667,1113.03>, <67.6667,3.66667,1009.7>, <67.6667,3.66667,596.366>, <67.6667,3.66667,493.033>,
<68,4,1113.03>, <68,4,1009.7>, <68,4,596.366>, <68,4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<20,-4,1113.03>, <20,-4,1009.7>, <20,-4,596.366>, <20,-4,493.033>,
<19.6667,-3.66667,1113.03>, <19.6667,-3.66667,1009.7>, <19.6667,-3.66667,596.366>, <19.6667,-3.66667,493.033>,
<18.3333,-2.33333,1113.03>, <18.3333,-2.33333,1009.7>, <18.3333,-2.33333,596.366>, <18.3333,-2.33333,493.033>,
<18,-2,1113.03>, <18,-2,1009.7>, <18,-2,596.366>, <18,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<18,2,1113.03>, <18,1.33333,1113.03>, <18,-1.33333,1113.03>, <18,-2,1113.03>,
<18,2,1009.7>, <18,1.33333,1009.7>, <18,-1.33333,1009.7>, <18,-2,1009.7>,
<18,2,596.366>, <18,1.33333,596.366>, <18,-1.33333,596.366>, <18,-2,596.366>,
<18,2,493.033>, <18,1.33333,493.033>, <18,-1.33333,493.033>, <18,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<28,-4,1113.03>, <28,-4,1009.7>, <28,-4,596.366>, <28,-4,493.033>,
<26.6667,-4,1113.03>, <26.6667,-4,1009.7>, <26.6667,-4,596.366>, <26.6667,-4,493.033>,
<21.3333,-4,1113.03>, <21.3333,-4,1009.7>, <21.3333,-4,596.366>, <21.3333,-4,493.033>,
<20,-4,1113.03>, <20,-4,1009.7>, <20,-4,596.366>, <20,-4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<30,-2,1113.03>, <30,-2,1009.7>, <30,-2,596.366>, <30,-2,493.033>,
<29.6667,-2.33333,1113.03>, <29.6667,-2.33333,1009.7>, <29.6667,-2.33333,596.366>, <29.6667,-2.33333,493.033>,
<28.3333,-3.66667,1113.03>, <28.3333,-3.66667,1009.7>, <28.3333,-3.66667,596.366>, <28.3333,-3.66667,493.033>,
<28,-4,1113.03>, <28,-4,1009.7>, <28,-4,596.366>, <28,-4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<30,2,1113.03>, <30,2,1009.7>, <30,2,596.366>, <30,2,493.033>,
<30,1.33333,1113.03>, <30,1.33333,1009.7>, <30,1.33333,596.366>, <30,1.33333,493.033>,
<30,-1.33333,1113.03>, <30,-1.33333,1009.7>, <30,-1.33333,596.366>, <30,-1.33333,493.033>,
<30,-2,1113.03>, <30,-2,1009.7>, <30,-2,596.366>, <30,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<28,4,1113.03>, <28,4,1009.7>, <28,4,596.366>, <28,4,493.033>,
<28.3333,3.66667,1113.03>, <28.3333,3.66667,1009.7>, <28.3333,3.66667,596.366>, <28.3333,3.66667,493.033>,
<29.6667,2.33333,1113.03>, <29.6667,2.33333,1009.7>, <29.6667,2.33333,596.366>, <29.6667,2.33333,493.033>,
<30,2,1113.03>, <30,2,1009.7>, <30,2,596.366>, <30,2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<20,4,1113.03>, <20,4,1009.7>, <20,4,596.366>, <20,4,493.033>,
<21.3333,4,1113.03>, <21.3333,4,1009.7>, <21.3333,4,596.366>, <21.3333,4,493.033>,
<26.6667,4,1113.03>, <26.6667,4,1009.7>, <26.6667,4,596.366>, <26.6667,4,493.033>,
<28,4,1113.03>, <28,4,1009.7>, <28,4,596.366>, <28,4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<18,2,1113.03>, <18,2,1009.7>, <18,2,596.366>, <18,2,493.033>,
<18.3333,2.33333,1113.03>, <18.3333,2.33333,1009.7>, <18.3333,2.33333,596.366>, <18.3333,2.33333,493.033>,
<19.6667,3.66667,1113.03>, <19.6667,3.66667,1009.7>, <19.6667,3.66667,596.366>, <19.6667,3.66667,493.033>,
<20,4,1113.03>, <20,4,1009.7>, <20,4,596.366>, <20,4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<52,-4,1113.03>, <52,-4,1009.7>, <52,-4,596.366>, <52,-4,493.033>,
<51.6667,-3.66667,1113.03>, <51.6667,-3.66667,1009.7>, <51.6667,-3.66667,596.366>, <51.6667,-3.66667,493.033>,
<50.3333,-2.33333,1113.03>, <50.3333,-2.33333,1009.7>, <50.3333,-2.33333,596.366>, <50.3333,-2.33333,493.033>,
<50,-2,1113.03>, <50,-2,1009.7>, <50,-2,596.366>, <50,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<50,2,1113.03>, <50,1.33333,1113.03>, <50,-1.33333,1113.03>, <50,-2,1113.03>,
<50,2,1009.7>, <50,1.33333,1009.7>, <50,-1.33333,1009.7>, <50,-2,1009.7>,
<50,2,596.366>, <50,1.33333,596.366>, <50,-1.33333,596.366>, <50,-2,596.366>,
<50,2,493.033>, <50,1.33333,493.033>, <50,-1.33333,493.033>, <50,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<60,-4,1113.03>, <60,-4,1009.7>, <60,-4,596.366>, <60,-4,493.033>,
<58.6667,-4,1113.03>, <58.6667,-4,1009.7>, <58.6667,-4,596.366>, <58.6667,-4,493.033>,
<53.3333,-4,1113.03>, <53.3333,-4,1009.7>, <53.3333,-4,596.366>, <53.3333,-4,493.033>,
<52,-4,1113.03>, <52,-4,1009.7>, <52,-4,596.366>, <52,-4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<62,-2,1113.03>, <62,-2,1009.7>, <62,-2,596.366>, <62,-2,493.033>,
<61.6667,-2.33333,1113.03>, <61.6667,-2.33333,1009.7>, <61.6667,-2.33333,596.366>, <61.6667,-2.33333,493.033>,
<60.3333,-3.66667,1113.03>, <60.3333,-3.66667,1009.7>, <60.3333,-3.66667,596.366>, <60.3333,-3.66667,493.033>,
<60,-4,1113.03>, <60,-4,1009.7>, <60,-4,596.366>, <60,-4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<62,2,1113.03>, <62,2,1009.7>, <62,2,596.366>, <62,2,493.033>,
<62,1.33333,1113.03>, <62,1.33333,1009.7>, <62,1.33333,596.366>, <62,1.33333,493.033>,
<62,-1.33333,1113.03>, <62,-1.33333,1009.7>, <62,-1.33333,596.366>, <62,-1.33333,493.033>,
<62,-2,1113.03>, <62,-2,1009.7>, <62,-2,596.366>, <62,-2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<60,4,1113.03>, <60,4,1009.7>, <60,4,596.366>, <60,4,493.033>,
<60.3333,3.66667,1113.03>, <60.3333,3.66667,1009.7>, <60.3333,3.66667,596.366>, <60.3333,3.66667,493.033>,
<61.6667,2.33333,1113.03>, <61.6667,2.33333,1009.7>, <61.6667,2.33333,596.366>, <61.6667,2.33333,493.033>,
<62,2,1113.03>, <62,2,1009.7>, <62,2,596.366>, <62,2,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<52,4,1113.03>, <52,4,1009.7>, <52,4,596.366>, <52,4,493.033>,
<53.3333,4,1113.03>, <53.3333,4,1009.7>, <53.3333,4,596.366>, <53.3333,4,493.033>,
<58.6667,4,1113.03>, <58.6667,4,1009.7>, <58.6667,4,596.366>, <58.6667,4,493.033>,
<60,4,1113.03>, <60,4,1009.7>, <60,4,596.366>, <60,4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<50,2,1113.03>, <50,2,1009.7>, <50,2,596.366>, <50,2,493.033>,
<50.3333,2.33333,1113.03>, <50.3333,2.33333,1009.7>, <50.3333,2.33333,596.366>, <50.3333,2.33333,493.033>,
<51.6667,3.66667,1113.03>, <51.6667,3.66667,1009.7>, <51.6667,3.66667,596.366>, <51.6667,3.66667,493.033>,
<52,4,1113.03>, <52,4,1009.7>, <52,4,596.366>, <52,4,493.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<130,15,406.066>, <129.167,14.1667,406.066>, <125.833,10.8333,406.066>, <125,10,406.066>,
<130,10,406.066>, <129.167,9.72222,406.066>, <125.833,6.94444,406.066>, <125,6.66667,406.066>,
<130,-10,406.066>, <129.167,-9.72222,406.066>, <125.833,-6.94444,406.066>, <125,-6.66667,406.066>,
<130,-15,406.066>, <129.167,-14.1667,406.066>, <125.833,-10.8333,406.066>, <125,-10,406.066>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<130,15,406.066>, <130,15,539.4>, <130,15,1072.74>, <130,15,1206.07>,
<129.167,14.1667,406.066>, <129.167,14.1667,539.4>, <129.167,14.1667,1072.74>, <129.167,14.1667,1206.07>,
<125.833,10.8333,406.066>, <125.833,10.8333,539.4>, <125.833,10.8333,1072.74>, <125.833,10.8333,1206.07>,
<125,10,406.066>, <125,10,539.4>, <125,10,1072.74>, <125,10,1206.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<130,15,406.066>, <130,10,406.066>, <130,-10,406.066>, <130,-15,406.066>,
<133.333,15,406.066>, <133.333,10,406.066>, <133.333,-10,406.066>, <133.333,-15,406.066>,
<146.667,15,406.066>, <146.667,10,406.066>, <146.667,-10,406.066>, <146.667,-15,406.066>,
<150,15,406.066>, <150,10,406.066>, <150,-10,406.066>, <150,-15,406.066>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<130,15,406.066>, <133.333,15,406.066>, <146.667,15,406.066>, <150,15,406.066>,
<130,15,539.4>, <133.333,15,539.4>, <146.667,15,539.4>, <150,15,539.4>,
<130,15,1072.74>, <133.333,15,1072.74>, <146.667,15,1072.74>, <150,15,1072.74>,
<130,15,1206.07>, <133.333,15,1206.07>, <146.667,15,1206.07>, <150,15,1206.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<150,15,406.066>, <150,10,406.066>, <150,-10,406.066>, <150,-15,406.066>,
<150.833,14.1667,406.066>, <150.833,9.72222,406.066>, <150.833,-9.72222,406.066>, <150.833,-14.1667,406.066>,
<154.167,10.8333,406.066>, <154.167,6.94444,406.066>, <154.167,-6.94444,406.066>, <154.167,-10.8333,406.066>,
<155,10,406.066>, <155,6.66667,406.066>, <155,-6.66667,406.066>, <155,-10,406.066>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<150,15,406.066>, <150.833,14.1667,406.066>, <154.167,10.8333,406.066>, <155,10,406.066>,
<150,15,539.4>, <150.833,14.1667,539.4>, <154.167,10.8333,539.4>, <155,10,539.4>,
<150,15,1072.74>, <150.833,14.1667,1072.74>, <154.167,10.8333,1072.74>, <155,10,1072.74>,
<150,15,1206.07>, <150.833,14.1667,1206.07>, <154.167,10.8333,1206.07>, <155,10,1206.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<155,10,406.066>, <155,6.66667,406.066>, <155,-6.66667,406.066>, <155,-10,406.066>,
<155,10,539.4>, <155,6.66667,539.4>, <155,-6.66667,539.4>, <155,-10,539.4>,
<155,10,1072.74>, <155,6.66667,1072.74>, <155,-6.66667,1072.74>, <155,-10,1072.74>,
<155,10,1206.07>, <155,6.66667,1206.07>, <155,-6.66667,1206.07>, <155,-10,1206.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<155,-10,406.066>, <154.167,-10.8333,406.066>, <150.833,-14.1667,406.066>, <150,-15,406.066>,
<155,-10,539.4>, <154.167,-10.8333,539.4>, <150.833,-14.1667,539.4>, <150,-15,539.4>,
<155,-10,1072.74>, <154.167,-10.8333,1072.74>, <150.833,-14.1667,1072.74>, <150,-15,1072.74>,
<155,-10,1206.07>, <154.167,-10.8333,1206.07>, <150.833,-14.1667,1206.07>, <150,-15,1206.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<150,-15,406.066>, <146.667,-15,406.066>, <133.333,-15,406.066>, <130,-15,406.066>,
<150,-15,539.4>, <146.667,-15,539.4>, <133.333,-15,539.4>, <130,-15,539.4>,
<150,-15,1072.74>, <146.667,-15,1072.74>, <133.333,-15,1072.74>, <130,-15,1072.74>,
<150,-15,1206.07>, <146.667,-15,1206.07>, <133.333,-15,1206.07>, <130,-15,1206.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<130,-15,406.066>, <129.167,-14.1667,406.066>, <125.833,-10.8333,406.066>, <125,-10,406.066>,
<130,-15,539.4>, <129.167,-14.1667,539.4>, <125.833,-10.8333,539.4>, <125,-10,539.4>,
<130,-15,1072.74>, <129.167,-14.1667,1072.74>, <125.833,-10.8333,1072.74>, <125,-10,1072.74>,
<130,-15,1206.07>, <129.167,-14.1667,1206.07>, <125.833,-10.8333,1206.07>, <125,-10,1206.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<125,-10,406.066>, <125,-6.66667,406.066>, <125,6.66667,406.066>, <125,10,406.066>,
<125,-10,539.4>, <125,-6.66667,539.4>, <125,6.66667,539.4>, <125,10,539.4>,
<125,-10,1072.74>, <125,-6.66667,1072.74>, <125,6.66667,1072.74>, <125,10,1072.74>,
<125,-10,1206.07>, <125,-6.66667,1206.07>, <125,6.66667,1206.07>, <125,10,1206.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,5,1115.07>, <158.5,5,1130.07>, <158.5,5,1190.07>, <158.5,5,1205.07>,
<158.5,3.33333,1115.07>, <158.5,3.33333,1130.07>, <158.5,3.33333,1190.07>, <158.5,3.33333,1205.07>,
<158.5,-3.33333,1115.07>, <158.5,-3.33333,1130.07>, <158.5,-3.33333,1190.07>, <158.5,-3.33333,1205.07>,
<158.5,-5,1115.07>, <158.5,-5,1130.07>, <158.5,-5,1190.07>, <158.5,-5,1205.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,5,1115.07>, <158.5,3.33333,1115.07>, <158.5,-3.33333,1115.07>, <158.5,-5,1115.07>,
<185.667,5,1115.07>, <185.667,3.33333,1115.07>, <185.667,-3.33333,1115.07>, <185.667,-5,1115.07>,
<294.333,5,1115.07>, <294.333,3.33333,1115.07>, <294.333,-3.33333,1115.07>, <294.333,-5,1115.07>,
<321.5,5,1115.07>, <321.5,3.33333,1115.07>, <321.5,-3.33333,1115.07>, <321.5,-5,1115.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<321.5,5,1115.07>, <321.5,3.33333,1115.07>, <321.5,-3.33333,1115.07>, <321.5,-5,1115.07>,
<321.5,5,1130.07>, <321.5,3.33333,1130.07>, <321.5,-3.33333,1130.07>, <321.5,-5,1130.07>,
<321.5,5,1190.07>, <321.5,3.33333,1190.07>, <321.5,-3.33333,1190.07>, <321.5,-5,1190.07>,
<321.5,5,1205.07>, <321.5,3.33333,1205.07>, <321.5,-3.33333,1205.07>, <321.5,-5,1205.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<321.5,5,1205.07>, <321.5,3.33333,1205.07>, <321.5,-3.33333,1205.07>, <321.5,-5,1205.07>,
<294.333,5,1205.07>, <294.333,3.33333,1205.07>, <294.333,-3.33333,1205.07>, <294.333,-5,1205.07>,
<185.667,5,1205.07>, <185.667,3.33333,1205.07>, <185.667,-3.33333,1205.07>, <185.667,-5,1205.07>,
<158.5,5,1205.07>, <158.5,3.33333,1205.07>, <158.5,-3.33333,1205.07>, <158.5,-5,1205.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<290,2,496.066>, <290,2,599.4>, <290,2,1012.74>, <290,2,1116.07>,
<290,1.33333,496.066>, <290,1.33333,599.4>, <290,1.33333,1012.74>, <290,1.33333,1116.07>,
<290,-1.33333,496.066>, <290,-1.33333,599.4>, <290,-1.33333,1012.74>, <290,-1.33333,1116.07>,
<290,-2,496.066>, <290,-2,599.4>, <290,-2,1012.74>, <290,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<290,2,496.066>, <290.333,2.33333,496.066>, <291.667,3.66667,496.066>, <292,4,496.066>,
<290,2,599.4>, <290.333,2.33333,599.4>, <291.667,3.66667,599.4>, <292,4,599.4>,
<290,2,1012.74>, <290.333,2.33333,1012.74>, <291.667,3.66667,1012.74>, <292,4,1012.74>,
<290,2,1116.07>, <290.333,2.33333,1116.07>, <291.667,3.66667,1116.07>, <292,4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<292,4,496.066>, <293.333,4,496.066>, <298.667,4,496.066>, <300,4,496.066>,
<292,4,599.4>, <293.333,4,599.4>, <298.667,4,599.4>, <300,4,599.4>,
<292,4,1012.74>, <293.333,4,1012.74>, <298.667,4,1012.74>, <300,4,1012.74>,
<292,4,1116.07>, <293.333,4,1116.07>, <298.667,4,1116.07>, <300,4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<300,4,496.066>, <300.333,3.66667,496.066>, <301.667,2.33333,496.066>, <302,2,496.066>,
<300,4,599.4>, <300.333,3.66667,599.4>, <301.667,2.33333,599.4>, <302,2,599.4>,
<300,4,1012.74>, <300.333,3.66667,1012.74>, <301.667,2.33333,1012.74>, <302,2,1012.74>,
<300,4,1116.07>, <300.333,3.66667,1116.07>, <301.667,2.33333,1116.07>, <302,2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<302,2,496.066>, <302,1.33333,496.066>, <302,-1.33333,496.066>, <302,-2,496.066>,
<302,2,599.4>, <302,1.33333,599.4>, <302,-1.33333,599.4>, <302,-2,599.4>,
<302,2,1012.74>, <302,1.33333,1012.74>, <302,-1.33333,1012.74>, <302,-2,1012.74>,
<302,2,1116.07>, <302,1.33333,1116.07>, <302,-1.33333,1116.07>, <302,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<302,-2,496.066>, <301.667,-2.33333,496.066>, <300.333,-3.66667,496.066>, <300,-4,496.066>,
<302,-2,599.4>, <301.667,-2.33333,599.4>, <300.333,-3.66667,599.4>, <300,-4,599.4>,
<302,-2,1012.74>, <301.667,-2.33333,1012.74>, <300.333,-3.66667,1012.74>, <300,-4,1012.74>,
<302,-2,1116.07>, <301.667,-2.33333,1116.07>, <300.333,-3.66667,1116.07>, <300,-4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<300,-4,496.066>, <298.667,-4,496.066>, <293.333,-4,496.066>, <292,-4,496.066>,
<300,-4,599.4>, <298.667,-4,599.4>, <293.333,-4,599.4>, <292,-4,599.4>,
<300,-4,1012.74>, <298.667,-4,1012.74>, <293.333,-4,1012.74>, <292,-4,1012.74>,
<300,-4,1116.07>, <298.667,-4,1116.07>, <293.333,-4,1116.07>, <292,-4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<292,-4,496.066>, <291.667,-3.66667,496.066>, <290.333,-2.33333,496.066>, <290,-2,496.066>,
<292,-4,599.4>, <291.667,-3.66667,599.4>, <290.333,-2.33333,599.4>, <290,-2,599.4>,
<292,-4,1012.74>, <291.667,-3.66667,1012.74>, <290.333,-2.33333,1012.74>, <290,-2,1012.74>,
<292,-4,1116.07>, <291.667,-3.66667,1116.07>, <290.333,-2.33333,1116.07>, <290,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<258,2,496.066>, <258,2,599.4>, <258,2,1012.74>, <258,2,1116.07>,
<258,1.33333,496.066>, <258,1.33333,599.4>, <258,1.33333,1012.74>, <258,1.33333,1116.07>,
<258,-1.33333,496.066>, <258,-1.33333,599.4>, <258,-1.33333,1012.74>, <258,-1.33333,1116.07>,
<258,-2,496.066>, <258,-2,599.4>, <258,-2,1012.74>, <258,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<258,2,496.066>, <258.333,2.33333,496.066>, <259.667,3.66667,496.066>, <260,4,496.066>,
<258,2,599.4>, <258.333,2.33333,599.4>, <259.667,3.66667,599.4>, <260,4,599.4>,
<258,2,1012.74>, <258.333,2.33333,1012.74>, <259.667,3.66667,1012.74>, <260,4,1012.74>,
<258,2,1116.07>, <258.333,2.33333,1116.07>, <259.667,3.66667,1116.07>, <260,4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<260,4,496.066>, <261.333,4,496.066>, <266.667,4,496.066>, <268,4,496.066>,
<260,4,599.4>, <261.333,4,599.4>, <266.667,4,599.4>, <268,4,599.4>,
<260,4,1012.74>, <261.333,4,1012.74>, <266.667,4,1012.74>, <268,4,1012.74>,
<260,4,1116.07>, <261.333,4,1116.07>, <266.667,4,1116.07>, <268,4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<268,4,496.066>, <268.333,3.66667,496.066>, <269.667,2.33333,496.066>, <270,2,496.066>,
<268,4,599.4>, <268.333,3.66667,599.4>, <269.667,2.33333,599.4>, <270,2,599.4>,
<268,4,1012.74>, <268.333,3.66667,1012.74>, <269.667,2.33333,1012.74>, <270,2,1012.74>,
<268,4,1116.07>, <268.333,3.66667,1116.07>, <269.667,2.33333,1116.07>, <270,2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<270,2,496.066>, <270,1.33333,496.066>, <270,-1.33333,496.066>, <270,-2,496.066>,
<270,2,599.4>, <270,1.33333,599.4>, <270,-1.33333,599.4>, <270,-2,599.4>,
<270,2,1012.74>, <270,1.33333,1012.74>, <270,-1.33333,1012.74>, <270,-2,1012.74>,
<270,2,1116.07>, <270,1.33333,1116.07>, <270,-1.33333,1116.07>, <270,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<270,-2,496.066>, <269.667,-2.33333,496.066>, <268.333,-3.66667,496.066>, <268,-4,496.066>,
<270,-2,599.4>, <269.667,-2.33333,599.4>, <268.333,-3.66667,599.4>, <268,-4,599.4>,
<270,-2,1012.74>, <269.667,-2.33333,1012.74>, <268.333,-3.66667,1012.74>, <268,-4,1012.74>,
<270,-2,1116.07>, <269.667,-2.33333,1116.07>, <268.333,-3.66667,1116.07>, <268,-4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<268,-4,496.066>, <266.667,-4,496.066>, <261.333,-4,496.066>, <260,-4,496.066>,
<268,-4,599.4>, <266.667,-4,599.4>, <261.333,-4,599.4>, <260,-4,599.4>,
<268,-4,1012.74>, <266.667,-4,1012.74>, <261.333,-4,1012.74>, <260,-4,1012.74>,
<268,-4,1116.07>, <266.667,-4,1116.07>, <261.333,-4,1116.07>, <260,-4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<260,-4,496.066>, <259.667,-3.66667,496.066>, <258.333,-2.33333,496.066>, <258,-2,496.066>,
<260,-4,599.4>, <259.667,-3.66667,599.4>, <258.333,-2.33333,599.4>, <258,-2,599.4>,
<260,-4,1012.74>, <259.667,-3.66667,1012.74>, <258.333,-2.33333,1012.74>, <258,-2,1012.74>,
<260,-4,1116.07>, <259.667,-3.66667,1116.07>, <258.333,-2.33333,1116.07>, <258,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<306,2,496.066>, <306,2,599.4>, <306,2,1012.74>, <306,2,1116.07>,
<306,1.33333,496.066>, <306,1.33333,599.4>, <306,1.33333,1012.74>, <306,1.33333,1116.07>,
<306,-1.33333,496.066>, <306,-1.33333,599.4>, <306,-1.33333,1012.74>, <306,-1.33333,1116.07>,
<306,-2,496.066>, <306,-2,599.4>, <306,-2,1012.74>, <306,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<306,2,496.066>, <306.333,2.33333,496.066>, <307.667,3.66667,496.066>, <308,4,496.066>,
<306,2,599.4>, <306.333,2.33333,599.4>, <307.667,3.66667,599.4>, <308,4,599.4>,
<306,2,1012.74>, <306.333,2.33333,1012.74>, <307.667,3.66667,1012.74>, <308,4,1012.74>,
<306,2,1116.07>, <306.333,2.33333,1116.07>, <307.667,3.66667,1116.07>, <308,4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<308,4,496.066>, <309.333,4,496.066>, <314.667,4,496.066>, <316,4,496.066>,
<308,4,599.4>, <309.333,4,599.4>, <314.667,4,599.4>, <316,4,599.4>,
<308,4,1012.74>, <309.333,4,1012.74>, <314.667,4,1012.74>, <316,4,1012.74>,
<308,4,1116.07>, <309.333,4,1116.07>, <314.667,4,1116.07>, <316,4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<316,4,496.066>, <316.333,3.66667,496.066>, <317.667,2.33333,496.066>, <318,2,496.066>,
<316,4,599.4>, <316.333,3.66667,599.4>, <317.667,2.33333,599.4>, <318,2,599.4>,
<316,4,1012.74>, <316.333,3.66667,1012.74>, <317.667,2.33333,1012.74>, <318,2,1012.74>,
<316,4,1116.07>, <316.333,3.66667,1116.07>, <317.667,2.33333,1116.07>, <318,2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<318,2,496.066>, <318,1.33333,496.066>, <318,-1.33333,496.066>, <318,-2,496.066>,
<318,2,599.4>, <318,1.33333,599.4>, <318,-1.33333,599.4>, <318,-2,599.4>,
<318,2,1012.74>, <318,1.33333,1012.74>, <318,-1.33333,1012.74>, <318,-2,1012.74>,
<318,2,1116.07>, <318,1.33333,1116.07>, <318,-1.33333,1116.07>, <318,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<318,-2,496.066>, <317.667,-2.33333,496.066>, <316.333,-3.66667,496.066>, <316,-4,496.066>,
<318,-2,599.4>, <317.667,-2.33333,599.4>, <316.333,-3.66667,599.4>, <316,-4,599.4>,
<318,-2,1012.74>, <317.667,-2.33333,1012.74>, <316.333,-3.66667,1012.74>, <316,-4,1012.74>,
<318,-2,1116.07>, <317.667,-2.33333,1116.07>, <316.333,-3.66667,1116.07>, <316,-4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<316,-4,496.066>, <314.667,-4,496.066>, <309.333,-4,496.066>, <308,-4,496.066>,
<316,-4,599.4>, <314.667,-4,599.4>, <309.333,-4,599.4>, <308,-4,599.4>,
<316,-4,1012.74>, <314.667,-4,1012.74>, <309.333,-4,1012.74>, <308,-4,1012.74>,
<316,-4,1116.07>, <314.667,-4,1116.07>, <309.333,-4,1116.07>, <308,-4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<308,-4,496.066>, <307.667,-3.66667,496.066>, <306.333,-2.33333,496.066>, <306,-2,496.066>,
<308,-4,599.4>, <307.667,-3.66667,599.4>, <306.333,-2.33333,599.4>, <306,-2,599.4>,
<308,-4,1012.74>, <307.667,-3.66667,1012.74>, <306.333,-2.33333,1012.74>, <306,-2,1012.74>,
<308,-4,1116.07>, <307.667,-3.66667,1116.07>, <306.333,-2.33333,1116.07>, <306,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<242,2,496.066>, <242,2,599.4>, <242,2,1012.74>, <242,2,1116.07>,
<242,1.33333,496.066>, <242,1.33333,599.4>, <242,1.33333,1012.74>, <242,1.33333,1116.07>,
<242,-1.33333,496.066>, <242,-1.33333,599.4>, <242,-1.33333,1012.74>, <242,-1.33333,1116.07>,
<242,-2,496.066>, <242,-2,599.4>, <242,-2,1012.74>, <242,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<242,2,496.066>, <242.333,2.33333,496.066>, <243.667,3.66667,496.066>, <244,4,496.066>,
<242,2,599.4>, <242.333,2.33333,599.4>, <243.667,3.66667,599.4>, <244,4,599.4>,
<242,2,1012.74>, <242.333,2.33333,1012.74>, <243.667,3.66667,1012.74>, <244,4,1012.74>,
<242,2,1116.07>, <242.333,2.33333,1116.07>, <243.667,3.66667,1116.07>, <244,4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<244,4,496.066>, <245.333,4,496.066>, <250.667,4,496.066>, <252,4,496.066>,
<244,4,599.4>, <245.333,4,599.4>, <250.667,4,599.4>, <252,4,599.4>,
<244,4,1012.74>, <245.333,4,1012.74>, <250.667,4,1012.74>, <252,4,1012.74>,
<244,4,1116.07>, <245.333,4,1116.07>, <250.667,4,1116.07>, <252,4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<252,4,496.066>, <252.333,3.66667,496.066>, <253.667,2.33333,496.066>, <254,2,496.066>,
<252,4,599.4>, <252.333,3.66667,599.4>, <253.667,2.33333,599.4>, <254,2,599.4>,
<252,4,1012.74>, <252.333,3.66667,1012.74>, <253.667,2.33333,1012.74>, <254,2,1012.74>,
<252,4,1116.07>, <252.333,3.66667,1116.07>, <253.667,2.33333,1116.07>, <254,2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<254,2,496.066>, <254,1.33333,496.066>, <254,-1.33333,496.066>, <254,-2,496.066>,
<254,2,599.4>, <254,1.33333,599.4>, <254,-1.33333,599.4>, <254,-2,599.4>,
<254,2,1012.74>, <254,1.33333,1012.74>, <254,-1.33333,1012.74>, <254,-2,1012.74>,
<254,2,1116.07>, <254,1.33333,1116.07>, <254,-1.33333,1116.07>, <254,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<254,-2,496.066>, <253.667,-2.33333,496.066>, <252.333,-3.66667,496.066>, <252,-4,496.066>,
<254,-2,599.4>, <253.667,-2.33333,599.4>, <252.333,-3.66667,599.4>, <252,-4,599.4>,
<254,-2,1012.74>, <253.667,-2.33333,1012.74>, <252.333,-3.66667,1012.74>, <252,-4,1012.74>,
<254,-2,1116.07>, <253.667,-2.33333,1116.07>, <252.333,-3.66667,1116.07>, <252,-4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<252,-4,496.066>, <250.667,-4,496.066>, <245.333,-4,496.066>, <244,-4,496.066>,
<252,-4,599.4>, <250.667,-4,599.4>, <245.333,-4,599.4>, <244,-4,599.4>,
<252,-4,1012.74>, <250.667,-4,1012.74>, <245.333,-4,1012.74>, <244,-4,1012.74>,
<252,-4,1116.07>, <250.667,-4,1116.07>, <245.333,-4,1116.07>, <244,-4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<244,-4,496.066>, <243.667,-3.66667,496.066>, <242.333,-2.33333,496.066>, <242,-2,496.066>,
<244,-4,599.4>, <243.667,-3.66667,599.4>, <242.333,-2.33333,599.4>, <242,-2,599.4>,
<244,-4,1012.74>, <243.667,-3.66667,1012.74>, <242.333,-2.33333,1012.74>, <242,-2,1012.74>,
<244,-4,1116.07>, <243.667,-3.66667,1116.07>, <242.333,-2.33333,1116.07>, <242,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<274,2,496.066>, <274,2,599.4>, <274,2,1012.74>, <274,2,1116.07>,
<274,1.33333,496.066>, <274,1.33333,599.4>, <274,1.33333,1012.74>, <274,1.33333,1116.07>,
<274,-1.33333,496.066>, <274,-1.33333,599.4>, <274,-1.33333,1012.74>, <274,-1.33333,1116.07>,
<274,-2,496.066>, <274,-2,599.4>, <274,-2,1012.74>, <274,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<274,2,496.066>, <274.333,2.33333,496.066>, <275.667,3.66667,496.066>, <276,4,496.066>,
<274,2,599.4>, <274.333,2.33333,599.4>, <275.667,3.66667,599.4>, <276,4,599.4>,
<274,2,1012.74>, <274.333,2.33333,1012.74>, <275.667,3.66667,1012.74>, <276,4,1012.74>,
<274,2,1116.07>, <274.333,2.33333,1116.07>, <275.667,3.66667,1116.07>, <276,4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<276,4,496.066>, <277.333,4,496.066>, <282.667,4,496.066>, <284,4,496.066>,
<276,4,599.4>, <277.333,4,599.4>, <282.667,4,599.4>, <284,4,599.4>,
<276,4,1012.74>, <277.333,4,1012.74>, <282.667,4,1012.74>, <284,4,1012.74>,
<276,4,1116.07>, <277.333,4,1116.07>, <282.667,4,1116.07>, <284,4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<284,4,496.066>, <284.333,3.66667,496.066>, <285.667,2.33333,496.066>, <286,2,496.066>,
<284,4,599.4>, <284.333,3.66667,599.4>, <285.667,2.33333,599.4>, <286,2,599.4>,
<284,4,1012.74>, <284.333,3.66667,1012.74>, <285.667,2.33333,1012.74>, <286,2,1012.74>,
<284,4,1116.07>, <284.333,3.66667,1116.07>, <285.667,2.33333,1116.07>, <286,2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<286,2,496.066>, <286,1.33333,496.066>, <286,-1.33333,496.066>, <286,-2,496.066>,
<286,2,599.4>, <286,1.33333,599.4>, <286,-1.33333,599.4>, <286,-2,599.4>,
<286,2,1012.74>, <286,1.33333,1012.74>, <286,-1.33333,1012.74>, <286,-2,1012.74>,
<286,2,1116.07>, <286,1.33333,1116.07>, <286,-1.33333,1116.07>, <286,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<286,-2,496.066>, <285.667,-2.33333,496.066>, <284.333,-3.66667,496.066>, <284,-4,496.066>,
<286,-2,599.4>, <285.667,-2.33333,599.4>, <284.333,-3.66667,599.4>, <284,-4,599.4>,
<286,-2,1012.74>, <285.667,-2.33333,1012.74>, <284.333,-3.66667,1012.74>, <284,-4,1012.74>,
<286,-2,1116.07>, <285.667,-2.33333,1116.07>, <284.333,-3.66667,1116.07>, <284,-4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<284,-4,496.066>, <282.667,-4,496.066>, <277.333,-4,496.066>, <276,-4,496.066>,
<284,-4,599.4>, <282.667,-4,599.4>, <277.333,-4,599.4>, <276,-4,599.4>,
<284,-4,1012.74>, <282.667,-4,1012.74>, <277.333,-4,1012.74>, <276,-4,1012.74>,
<284,-4,1116.07>, <282.667,-4,1116.07>, <277.333,-4,1116.07>, <276,-4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<276,-4,496.066>, <275.667,-3.66667,496.066>, <274.333,-2.33333,496.066>, <274,-2,496.066>,
<276,-4,599.4>, <275.667,-3.66667,599.4>, <274.333,-2.33333,599.4>, <274,-2,599.4>,
<276,-4,1012.74>, <275.667,-3.66667,1012.74>, <274.333,-2.33333,1012.74>, <274,-2,1012.74>,
<276,-4,1116.07>, <275.667,-3.66667,1116.07>, <274.333,-2.33333,1116.07>, <274,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<194,2,496.066>, <194,2,599.4>, <194,2,1012.74>, <194,2,1116.07>,
<194,1.33333,496.066>, <194,1.33333,599.4>, <194,1.33333,1012.74>, <194,1.33333,1116.07>,
<194,-1.33333,496.066>, <194,-1.33333,599.4>, <194,-1.33333,1012.74>, <194,-1.33333,1116.07>,
<194,-2,496.066>, <194,-2,599.4>, <194,-2,1012.74>, <194,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<194,2,496.066>, <194.333,2.33333,496.066>, <195.667,3.66667,496.066>, <196,4,496.066>,
<194,2,599.4>, <194.333,2.33333,599.4>, <195.667,3.66667,599.4>, <196,4,599.4>,
<194,2,1012.74>, <194.333,2.33333,1012.74>, <195.667,3.66667,1012.74>, <196,4,1012.74>,
<194,2,1116.07>, <194.333,2.33333,1116.07>, <195.667,3.66667,1116.07>, <196,4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<196,4,496.066>, <197.333,4,496.066>, <202.667,4,496.066>, <204,4,496.066>,
<196,4,599.4>, <197.333,4,599.4>, <202.667,4,599.4>, <204,4,599.4>,
<196,4,1012.74>, <197.333,4,1012.74>, <202.667,4,1012.74>, <204,4,1012.74>,
<196,4,1116.07>, <197.333,4,1116.07>, <202.667,4,1116.07>, <204,4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<204,4,496.066>, <204.333,3.66667,496.066>, <205.667,2.33333,496.066>, <206,2,496.066>,
<204,4,599.4>, <204.333,3.66667,599.4>, <205.667,2.33333,599.4>, <206,2,599.4>,
<204,4,1012.74>, <204.333,3.66667,1012.74>, <205.667,2.33333,1012.74>, <206,2,1012.74>,
<204,4,1116.07>, <204.333,3.66667,1116.07>, <205.667,2.33333,1116.07>, <206,2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<206,2,496.066>, <206,1.33333,496.066>, <206,-1.33333,496.066>, <206,-2,496.066>,
<206,2,599.4>, <206,1.33333,599.4>, <206,-1.33333,599.4>, <206,-2,599.4>,
<206,2,1012.74>, <206,1.33333,1012.74>, <206,-1.33333,1012.74>, <206,-2,1012.74>,
<206,2,1116.07>, <206,1.33333,1116.07>, <206,-1.33333,1116.07>, <206,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<206,-2,496.066>, <205.667,-2.33333,496.066>, <204.333,-3.66667,496.066>, <204,-4,496.066>,
<206,-2,599.4>, <205.667,-2.33333,599.4>, <204.333,-3.66667,599.4>, <204,-4,599.4>,
<206,-2,1012.74>, <205.667,-2.33333,1012.74>, <204.333,-3.66667,1012.74>, <204,-4,1012.74>,
<206,-2,1116.07>, <205.667,-2.33333,1116.07>, <204.333,-3.66667,1116.07>, <204,-4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<204,-4,496.066>, <202.667,-4,496.066>, <197.333,-4,496.066>, <196,-4,496.066>,
<204,-4,599.4>, <202.667,-4,599.4>, <197.333,-4,599.4>, <196,-4,599.4>,
<204,-4,1012.74>, <202.667,-4,1012.74>, <197.333,-4,1012.74>, <196,-4,1012.74>,
<204,-4,1116.07>, <202.667,-4,1116.07>, <197.333,-4,1116.07>, <196,-4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<196,-4,496.066>, <195.667,-3.66667,496.066>, <194.333,-2.33333,496.066>, <194,-2,496.066>,
<196,-4,599.4>, <195.667,-3.66667,599.4>, <194.333,-2.33333,599.4>, <194,-2,599.4>,
<196,-4,1012.74>, <195.667,-3.66667,1012.74>, <194.333,-2.33333,1012.74>, <194,-2,1012.74>,
<196,-4,1116.07>, <195.667,-3.66667,1116.07>, <194.333,-2.33333,1116.07>, <194,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<162,2,496.066>, <162,2,599.4>, <162,2,1012.74>, <162,2,1116.07>,
<162,1.33333,496.066>, <162,1.33333,599.4>, <162,1.33333,1012.74>, <162,1.33333,1116.07>,
<162,-1.33333,496.066>, <162,-1.33333,599.4>, <162,-1.33333,1012.74>, <162,-1.33333,1116.07>,
<162,-2,496.066>, <162,-2,599.4>, <162,-2,1012.74>, <162,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<162,2,496.066>, <162.333,2.33333,496.066>, <163.667,3.66667,496.066>, <164,4,496.066>,
<162,2,599.4>, <162.333,2.33333,599.4>, <163.667,3.66667,599.4>, <164,4,599.4>,
<162,2,1012.74>, <162.333,2.33333,1012.74>, <163.667,3.66667,1012.74>, <164,4,1012.74>,
<162,2,1116.07>, <162.333,2.33333,1116.07>, <163.667,3.66667,1116.07>, <164,4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<164,4,496.066>, <165.333,4,496.066>, <170.667,4,496.066>, <172,4,496.066>,
<164,4,599.4>, <165.333,4,599.4>, <170.667,4,599.4>, <172,4,599.4>,
<164,4,1012.74>, <165.333,4,1012.74>, <170.667,4,1012.74>, <172,4,1012.74>,
<164,4,1116.07>, <165.333,4,1116.07>, <170.667,4,1116.07>, <172,4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<172,4,496.066>, <172.333,3.66667,496.066>, <173.667,2.33333,496.066>, <174,2,496.066>,
<172,4,599.4>, <172.333,3.66667,599.4>, <173.667,2.33333,599.4>, <174,2,599.4>,
<172,4,1012.74>, <172.333,3.66667,1012.74>, <173.667,2.33333,1012.74>, <174,2,1012.74>,
<172,4,1116.07>, <172.333,3.66667,1116.07>, <173.667,2.33333,1116.07>, <174,2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<174,2,496.066>, <174,1.33333,496.066>, <174,-1.33333,496.066>, <174,-2,496.066>,
<174,2,599.4>, <174,1.33333,599.4>, <174,-1.33333,599.4>, <174,-2,599.4>,
<174,2,1012.74>, <174,1.33333,1012.74>, <174,-1.33333,1012.74>, <174,-2,1012.74>,
<174,2,1116.07>, <174,1.33333,1116.07>, <174,-1.33333,1116.07>, <174,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<174,-2,496.066>, <173.667,-2.33333,496.066>, <172.333,-3.66667,496.066>, <172,-4,496.066>,
<174,-2,599.4>, <173.667,-2.33333,599.4>, <172.333,-3.66667,599.4>, <172,-4,599.4>,
<174,-2,1012.74>, <173.667,-2.33333,1012.74>, <172.333,-3.66667,1012.74>, <172,-4,1012.74>,
<174,-2,1116.07>, <173.667,-2.33333,1116.07>, <172.333,-3.66667,1116.07>, <172,-4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<172,-4,496.066>, <170.667,-4,496.066>, <165.333,-4,496.066>, <164,-4,496.066>,
<172,-4,599.4>, <170.667,-4,599.4>, <165.333,-4,599.4>, <164,-4,599.4>,
<172,-4,1012.74>, <170.667,-4,1012.74>, <165.333,-4,1012.74>, <164,-4,1012.74>,
<172,-4,1116.07>, <170.667,-4,1116.07>, <165.333,-4,1116.07>, <164,-4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<164,-4,496.066>, <163.667,-3.66667,496.066>, <162.333,-2.33333,496.066>, <162,-2,496.066>,
<164,-4,599.4>, <163.667,-3.66667,599.4>, <162.333,-2.33333,599.4>, <162,-2,599.4>,
<164,-4,1012.74>, <163.667,-3.66667,1012.74>, <162.333,-2.33333,1012.74>, <162,-2,1012.74>,
<164,-4,1116.07>, <163.667,-3.66667,1116.07>, <162.333,-2.33333,1116.07>, <162,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<226,2,496.066>, <226,2,599.4>, <226,2,1012.74>, <226,2,1116.07>,
<226,1.33333,496.066>, <226,1.33333,599.4>, <226,1.33333,1012.74>, <226,1.33333,1116.07>,
<226,-1.33333,496.066>, <226,-1.33333,599.4>, <226,-1.33333,1012.74>, <226,-1.33333,1116.07>,
<226,-2,496.066>, <226,-2,599.4>, <226,-2,1012.74>, <226,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<226,2,496.066>, <226.333,2.33333,496.066>, <227.667,3.66667,496.066>, <228,4,496.066>,
<226,2,599.4>, <226.333,2.33333,599.4>, <227.667,3.66667,599.4>, <228,4,599.4>,
<226,2,1012.74>, <226.333,2.33333,1012.74>, <227.667,3.66667,1012.74>, <228,4,1012.74>,
<226,2,1116.07>, <226.333,2.33333,1116.07>, <227.667,3.66667,1116.07>, <228,4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<228,4,496.066>, <229.333,4,496.066>, <234.667,4,496.066>, <236,4,496.066>,
<228,4,599.4>, <229.333,4,599.4>, <234.667,4,599.4>, <236,4,599.4>,
<228,4,1012.74>, <229.333,4,1012.74>, <234.667,4,1012.74>, <236,4,1012.74>,
<228,4,1116.07>, <229.333,4,1116.07>, <234.667,4,1116.07>, <236,4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<236,4,496.066>, <236.333,3.66667,496.066>, <237.667,2.33333,496.066>, <238,2,496.066>,
<236,4,599.4>, <236.333,3.66667,599.4>, <237.667,2.33333,599.4>, <238,2,599.4>,
<236,4,1012.74>, <236.333,3.66667,1012.74>, <237.667,2.33333,1012.74>, <238,2,1012.74>,
<236,4,1116.07>, <236.333,3.66667,1116.07>, <237.667,2.33333,1116.07>, <238,2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<238,2,496.066>, <238,1.33333,496.066>, <238,-1.33333,496.066>, <238,-2,496.066>,
<238,2,599.4>, <238,1.33333,599.4>, <238,-1.33333,599.4>, <238,-2,599.4>,
<238,2,1012.74>, <238,1.33333,1012.74>, <238,-1.33333,1012.74>, <238,-2,1012.74>,
<238,2,1116.07>, <238,1.33333,1116.07>, <238,-1.33333,1116.07>, <238,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<238,-2,496.066>, <237.667,-2.33333,496.066>, <236.333,-3.66667,496.066>, <236,-4,496.066>,
<238,-2,599.4>, <237.667,-2.33333,599.4>, <236.333,-3.66667,599.4>, <236,-4,599.4>,
<238,-2,1012.74>, <237.667,-2.33333,1012.74>, <236.333,-3.66667,1012.74>, <236,-4,1012.74>,
<238,-2,1116.07>, <237.667,-2.33333,1116.07>, <236.333,-3.66667,1116.07>, <236,-4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<236,-4,496.066>, <234.667,-4,496.066>, <229.333,-4,496.066>, <228,-4,496.066>,
<236,-4,599.4>, <234.667,-4,599.4>, <229.333,-4,599.4>, <228,-4,599.4>,
<236,-4,1012.74>, <234.667,-4,1012.74>, <229.333,-4,1012.74>, <228,-4,1012.74>,
<236,-4,1116.07>, <234.667,-4,1116.07>, <229.333,-4,1116.07>, <228,-4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<228,-4,496.066>, <227.667,-3.66667,496.066>, <226.333,-2.33333,496.066>, <226,-2,496.066>,
<228,-4,599.4>, <227.667,-3.66667,599.4>, <226.333,-2.33333,599.4>, <226,-2,599.4>,
<228,-4,1012.74>, <227.667,-3.66667,1012.74>, <226.333,-2.33333,1012.74>, <226,-2,1012.74>,
<228,-4,1116.07>, <227.667,-3.66667,1116.07>, <226.333,-2.33333,1116.07>, <226,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<178,2,496.066>, <178,2,599.4>, <178,2,1012.74>, <178,2,1116.07>,
<178,1.33333,496.066>, <178,1.33333,599.4>, <178,1.33333,1012.74>, <178,1.33333,1116.07>,
<178,-1.33333,496.066>, <178,-1.33333,599.4>, <178,-1.33333,1012.74>, <178,-1.33333,1116.07>,
<178,-2,496.066>, <178,-2,599.4>, <178,-2,1012.74>, <178,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<178,2,496.066>, <178.333,2.33333,496.066>, <179.667,3.66667,496.066>, <180,4,496.066>,
<178,2,599.4>, <178.333,2.33333,599.4>, <179.667,3.66667,599.4>, <180,4,599.4>,
<178,2,1012.74>, <178.333,2.33333,1012.74>, <179.667,3.66667,1012.74>, <180,4,1012.74>,
<178,2,1116.07>, <178.333,2.33333,1116.07>, <179.667,3.66667,1116.07>, <180,4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<180,4,496.066>, <181.333,4,496.066>, <186.667,4,496.066>, <188,4,496.066>,
<180,4,599.4>, <181.333,4,599.4>, <186.667,4,599.4>, <188,4,599.4>,
<180,4,1012.74>, <181.333,4,1012.74>, <186.667,4,1012.74>, <188,4,1012.74>,
<180,4,1116.07>, <181.333,4,1116.07>, <186.667,4,1116.07>, <188,4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<188,4,496.066>, <188.333,3.66667,496.066>, <189.667,2.33333,496.066>, <190,2,496.066>,
<188,4,599.4>, <188.333,3.66667,599.4>, <189.667,2.33333,599.4>, <190,2,599.4>,
<188,4,1012.74>, <188.333,3.66667,1012.74>, <189.667,2.33333,1012.74>, <190,2,1012.74>,
<188,4,1116.07>, <188.333,3.66667,1116.07>, <189.667,2.33333,1116.07>, <190,2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<190,2,496.066>, <190,1.33333,496.066>, <190,-1.33333,496.066>, <190,-2,496.066>,
<190,2,599.4>, <190,1.33333,599.4>, <190,-1.33333,599.4>, <190,-2,599.4>,
<190,2,1012.74>, <190,1.33333,1012.74>, <190,-1.33333,1012.74>, <190,-2,1012.74>,
<190,2,1116.07>, <190,1.33333,1116.07>, <190,-1.33333,1116.07>, <190,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<190,-2,496.066>, <189.667,-2.33333,496.066>, <188.333,-3.66667,496.066>, <188,-4,496.066>,
<190,-2,599.4>, <189.667,-2.33333,599.4>, <188.333,-3.66667,599.4>, <188,-4,599.4>,
<190,-2,1012.74>, <189.667,-2.33333,1012.74>, <188.333,-3.66667,1012.74>, <188,-4,1012.74>,
<190,-2,1116.07>, <189.667,-2.33333,1116.07>, <188.333,-3.66667,1116.07>, <188,-4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<188,-4,496.066>, <186.667,-4,496.066>, <181.333,-4,496.066>, <180,-4,496.066>,
<188,-4,599.4>, <186.667,-4,599.4>, <181.333,-4,599.4>, <180,-4,599.4>,
<188,-4,1012.74>, <186.667,-4,1012.74>, <181.333,-4,1012.74>, <180,-4,1012.74>,
<188,-4,1116.07>, <186.667,-4,1116.07>, <181.333,-4,1116.07>, <180,-4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<180,-4,496.066>, <179.667,-3.66667,496.066>, <178.333,-2.33333,496.066>, <178,-2,496.066>,
<180,-4,599.4>, <179.667,-3.66667,599.4>, <178.333,-2.33333,599.4>, <178,-2,599.4>,
<180,-4,1012.74>, <179.667,-3.66667,1012.74>, <178.333,-2.33333,1012.74>, <178,-2,1012.74>,
<180,-4,1116.07>, <179.667,-3.66667,1116.07>, <178.333,-2.33333,1116.07>, <178,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<210,2,496.066>, <210,2,599.4>, <210,2,1012.74>, <210,2,1116.07>,
<210,1.33333,496.066>, <210,1.33333,599.4>, <210,1.33333,1012.74>, <210,1.33333,1116.07>,
<210,-1.33333,496.066>, <210,-1.33333,599.4>, <210,-1.33333,1012.74>, <210,-1.33333,1116.07>,
<210,-2,496.066>, <210,-2,599.4>, <210,-2,1012.74>, <210,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<210,2,496.066>, <210.333,2.33333,496.066>, <211.667,3.66667,496.066>, <212,4,496.066>,
<210,2,599.4>, <210.333,2.33333,599.4>, <211.667,3.66667,599.4>, <212,4,599.4>,
<210,2,1012.74>, <210.333,2.33333,1012.74>, <211.667,3.66667,1012.74>, <212,4,1012.74>,
<210,2,1116.07>, <210.333,2.33333,1116.07>, <211.667,3.66667,1116.07>, <212,4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<212,4,496.066>, <213.333,4,496.066>, <218.667,4,496.066>, <220,4,496.066>,
<212,4,599.4>, <213.333,4,599.4>, <218.667,4,599.4>, <220,4,599.4>,
<212,4,1012.74>, <213.333,4,1012.74>, <218.667,4,1012.74>, <220,4,1012.74>,
<212,4,1116.07>, <213.333,4,1116.07>, <218.667,4,1116.07>, <220,4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<220,4,496.066>, <220.333,3.66667,496.066>, <221.667,2.33333,496.066>, <222,2,496.066>,
<220,4,599.4>, <220.333,3.66667,599.4>, <221.667,2.33333,599.4>, <222,2,599.4>,
<220,4,1012.74>, <220.333,3.66667,1012.74>, <221.667,2.33333,1012.74>, <222,2,1012.74>,
<220,4,1116.07>, <220.333,3.66667,1116.07>, <221.667,2.33333,1116.07>, <222,2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<222,2,496.066>, <222,1.33333,496.066>, <222,-1.33333,496.066>, <222,-2,496.066>,
<222,2,599.4>, <222,1.33333,599.4>, <222,-1.33333,599.4>, <222,-2,599.4>,
<222,2,1012.74>, <222,1.33333,1012.74>, <222,-1.33333,1012.74>, <222,-2,1012.74>,
<222,2,1116.07>, <222,1.33333,1116.07>, <222,-1.33333,1116.07>, <222,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<222,-2,496.066>, <221.667,-2.33333,496.066>, <220.333,-3.66667,496.066>, <220,-4,496.066>,
<222,-2,599.4>, <221.667,-2.33333,599.4>, <220.333,-3.66667,599.4>, <220,-4,599.4>,
<222,-2,1012.74>, <221.667,-2.33333,1012.74>, <220.333,-3.66667,1012.74>, <220,-4,1012.74>,
<222,-2,1116.07>, <221.667,-2.33333,1116.07>, <220.333,-3.66667,1116.07>, <220,-4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<220,-4,496.066>, <218.667,-4,496.066>, <213.333,-4,496.066>, <212,-4,496.066>,
<220,-4,599.4>, <218.667,-4,599.4>, <213.333,-4,599.4>, <212,-4,599.4>,
<220,-4,1012.74>, <218.667,-4,1012.74>, <213.333,-4,1012.74>, <212,-4,1012.74>,
<220,-4,1116.07>, <218.667,-4,1116.07>, <213.333,-4,1116.07>, <212,-4,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<212,-4,496.066>, <211.667,-3.66667,496.066>, <210.333,-2.33333,496.066>, <210,-2,496.066>,
<212,-4,599.4>, <211.667,-3.66667,599.4>, <210.333,-2.33333,599.4>, <210,-2,599.4>,
<212,-4,1012.74>, <211.667,-3.66667,1012.74>, <210.333,-2.33333,1012.74>, <210,-2,1012.74>,
<212,-4,1116.07>, <211.667,-3.66667,1116.07>, <210.333,-2.33333,1116.07>, <210,-2,1116.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<321.5,5,497.066>, <321.5,3.33333,497.066>, <321.5,-3.33333,497.066>, <321.5,-5,497.066>,
<294.333,5,497.066>, <294.333,3.33333,497.066>, <294.333,-3.33333,497.066>, <294.333,-5,497.066>,
<185.667,5,497.066>, <185.667,3.33333,497.066>, <185.667,-3.33333,497.066>, <185.667,-5,497.066>,
<158.5,5,497.066>, <158.5,3.33333,497.066>, <158.5,-3.33333,497.066>, <158.5,-5,497.066>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,5,407.066>, <158.5,5,422.066>, <158.5,5,482.066>, <158.5,5,497.066>,
<158.5,3.33333,407.066>, <158.5,3.33333,422.066>, <158.5,3.33333,482.066>, <158.5,3.33333,497.066>,
<158.5,-3.33333,407.066>, <158.5,-3.33333,422.066>, <158.5,-3.33333,482.066>, <158.5,-3.33333,497.066>,
<158.5,-5,407.066>, <158.5,-5,422.066>, <158.5,-5,482.066>, <158.5,-5,497.066>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,5,407.066>, <158.5,3.33333,407.066>, <158.5,-3.33333,407.066>, <158.5,-5,407.066>,
<185.667,5,407.066>, <185.667,3.33333,407.066>, <185.667,-3.33333,407.066>, <185.667,-5,407.066>,
<294.333,5,407.066>, <294.333,3.33333,407.066>, <294.333,-3.33333,407.066>, <294.333,-5,407.066>,
<321.5,5,407.066>, <321.5,3.33333,407.066>, <321.5,-3.33333,407.066>, <321.5,-5,407.066>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<321.5,5,407.066>, <321.5,3.33333,407.066>, <321.5,-3.33333,407.066>, <321.5,-5,407.066>,
<321.5,5,422.066>, <321.5,3.33333,422.066>, <321.5,-3.33333,422.066>, <321.5,-5,422.066>,
<321.5,5,482.066>, <321.5,3.33333,482.066>, <321.5,-3.33333,482.066>, <321.5,-5,482.066>,
<321.5,5,497.066>, <321.5,3.33333,497.066>, <321.5,-3.33333,497.066>, <321.5,-5,497.066>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<325,10,406.066>, <325,10,539.4>, <325,10,1072.74>, <325,10,1206.07>,
<325,6.66667,406.066>, <325,6.66667,539.4>, <325,6.66667,1072.74>, <325,6.66667,1206.07>,
<325,-6.66667,406.066>, <325,-6.66667,539.4>, <325,-6.66667,1072.74>, <325,-6.66667,1206.07>,
<325,-10,406.066>, <325,-10,539.4>, <325,-10,1072.74>, <325,-10,1206.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<325,10,406.066>, <325.833,10.8333,406.066>, <329.167,14.1667,406.066>, <330,15,406.066>,
<325,10,539.4>, <325.833,10.8333,539.4>, <329.167,14.1667,539.4>, <330,15,539.4>,
<325,10,1072.74>, <325.833,10.8333,1072.74>, <329.167,14.1667,1072.74>, <330,15,1072.74>,
<325,10,1206.07>, <325.833,10.8333,1206.07>, <329.167,14.1667,1206.07>, <330,15,1206.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<325,10,406.066>, <325,6.66667,406.066>, <325,-6.66667,406.066>, <325,-10,406.066>,
<325.833,10.8333,406.066>, <325.833,6.94444,406.066>, <325.833,-6.94444,406.066>, <325.833,-10.8333,406.066>,
<329.167,14.1667,406.066>, <329.167,9.72222,406.066>, <329.167,-9.72222,406.066>, <329.167,-14.1667,406.066>,
<330,15,406.066>, <330,10,406.066>, <330,-10,406.066>, <330,-15,406.066>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<330,15,406.066>, <330,10,406.066>, <330,-10,406.066>, <330,-15,406.066>,
<333.333,15,406.066>, <333.333,10,406.066>, <333.333,-10,406.066>, <333.333,-15,406.066>,
<346.667,15,406.066>, <346.667,10,406.066>, <346.667,-10,406.066>, <346.667,-15,406.066>,
<350,15,406.066>, <350,10,406.066>, <350,-10,406.066>, <350,-15,406.066>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<330,15,406.066>, <333.333,15,406.066>, <346.667,15,406.066>, <350,15,406.066>,
<330,15,539.4>, <333.333,15,539.4>, <346.667,15,539.4>, <350,15,539.4>,
<330,15,1072.74>, <333.333,15,1072.74>, <346.667,15,1072.74>, <350,15,1072.74>,
<330,15,1206.07>, <333.333,15,1206.07>, <346.667,15,1206.07>, <350,15,1206.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<350,15,406.066>, <350,10,406.066>, <350,-10,406.066>, <350,-15,406.066>,
<350.833,14.1667,406.066>, <350.833,9.72222,406.066>, <350.833,-9.72222,406.066>, <350.833,-14.1667,406.066>,
<354.167,10.8333,406.066>, <354.167,6.94444,406.066>, <354.167,-6.94444,406.066>, <354.167,-10.8333,406.066>,
<355,10,406.066>, <355,6.66667,406.066>, <355,-6.66667,406.066>, <355,-10,406.066>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<350,15,406.066>, <350.833,14.1667,406.066>, <354.167,10.8333,406.066>, <355,10,406.066>,
<350,15,539.4>, <350.833,14.1667,539.4>, <354.167,10.8333,539.4>, <355,10,539.4>,
<350,15,1072.74>, <350.833,14.1667,1072.74>, <354.167,10.8333,1072.74>, <355,10,1072.74>,
<350,15,1206.07>, <350.833,14.1667,1206.07>, <354.167,10.8333,1206.07>, <355,10,1206.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<355,10,406.066>, <355,6.66667,406.066>, <355,-6.66667,406.066>, <355,-10,406.066>,
<355,10,539.4>, <355,6.66667,539.4>, <355,-6.66667,539.4>, <355,-10,539.4>,
<355,10,1072.74>, <355,6.66667,1072.74>, <355,-6.66667,1072.74>, <355,-10,1072.74>,
<355,10,1206.07>, <355,6.66667,1206.07>, <355,-6.66667,1206.07>, <355,-10,1206.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<355,-10,406.066>, <354.167,-10.8333,406.066>, <350.833,-14.1667,406.066>, <350,-15,406.066>,
<355,-10,539.4>, <354.167,-10.8333,539.4>, <350.833,-14.1667,539.4>, <350,-15,539.4>,
<355,-10,1072.74>, <354.167,-10.8333,1072.74>, <350.833,-14.1667,1072.74>, <350,-15,1072.74>,
<355,-10,1206.07>, <354.167,-10.8333,1206.07>, <350.833,-14.1667,1206.07>, <350,-15,1206.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<350,-15,406.066>, <346.667,-15,406.066>, <333.333,-15,406.066>, <330,-15,406.066>,
<350,-15,539.4>, <346.667,-15,539.4>, <333.333,-15,539.4>, <330,-15,539.4>,
<350,-15,1072.74>, <346.667,-15,1072.74>, <333.333,-15,1072.74>, <330,-15,1072.74>,
<350,-15,1206.07>, <346.667,-15,1206.07>, <333.333,-15,1206.07>, <330,-15,1206.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<330,-15,406.066>, <329.167,-14.1667,406.066>, <325.833,-10.8333,406.066>, <325,-10,406.066>,
<330,-15,539.4>, <329.167,-14.1667,539.4>, <325.833,-10.8333,539.4>, <325,-10,539.4>,
<330,-15,1072.74>, <329.167,-14.1667,1072.74>, <325.833,-10.8333,1072.74>, <325,-10,1072.74>,
<330,-15,1206.07>, <329.167,-14.1667,1206.07>, <325.833,-10.8333,1206.07>, <325,-10,1206.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<130,-15,1206.07>, <129.167,-14.1667,1206.07>, <125.833,-10.8333,1206.07>, <125,-10,1206.07>,
<130,-10,1206.07>, <129.167,-9.72222,1206.07>, <125.833,-6.94444,1206.07>, <125,-6.66667,1206.07>,
<130,10,1206.07>, <129.167,9.72222,1206.07>, <125.833,6.94444,1206.07>, <125,6.66667,1206.07>,
<130,15,1206.07>, <129.167,14.1667,1206.07>, <125.833,10.8333,1206.07>, <125,10,1206.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<150,-15,1206.07>, <146.667,-15,1206.07>, <133.333,-15,1206.07>, <130,-15,1206.07>,
<150,-10,1206.07>, <146.667,-10,1206.07>, <133.333,-10,1206.07>, <130,-10,1206.07>,
<150,10,1206.07>, <146.667,10,1206.07>, <133.333,10,1206.07>, <130,10,1206.07>,
<150,15,1206.07>, <146.667,15,1206.07>, <133.333,15,1206.07>, <130,15,1206.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<155,10,1206.07>, <155,6.66667,1206.07>, <155,-6.66667,1206.07>, <155,-10,1206.07>,
<154.167,10.8333,1206.07>, <154.167,6.94444,1206.07>, <154.167,-6.94444,1206.07>, <154.167,-10.8333,1206.07>,
<150.833,14.1667,1206.07>, <150.833,9.72222,1206.07>, <150.833,-9.72222,1206.07>, <150.833,-14.1667,1206.07>,
<150,15,1206.07>, <150,10,1206.07>, <150,-10,1206.07>, <150,-15,1206.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<325,10,1206.07>, <325.833,10.8333,1206.07>, <329.167,14.1667,1206.07>, <330,15,1206.07>,
<325,6.66667,1206.07>, <325.833,6.94444,1206.07>, <329.167,9.72222,1206.07>, <330,10,1206.07>,
<325,-6.66667,1206.07>, <325.833,-6.94444,1206.07>, <329.167,-9.72222,1206.07>, <330,-10,1206.07>,
<325,-10,1206.07>, <325.833,-10.8333,1206.07>, <329.167,-14.1667,1206.07>, <330,-15,1206.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<350,-15,1206.07>, <346.667,-15,1206.07>, <333.333,-15,1206.07>, <330,-15,1206.07>,
<350,-10,1206.07>, <346.667,-10,1206.07>, <333.333,-10,1206.07>, <330,-10,1206.07>,
<350,10,1206.07>, <346.667,10,1206.07>, <333.333,10,1206.07>, <330,10,1206.07>,
<350,15,1206.07>, <346.667,15,1206.07>, <333.333,15,1206.07>, <330,15,1206.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<355,10,1206.07>, <355,6.66667,1206.07>, <355,-6.66667,1206.07>, <355,-10,1206.07>,
<354.167,10.8333,1206.07>, <354.167,6.94444,1206.07>, <354.167,-6.94444,1206.07>, <354.167,-10.8333,1206.07>,
<350.833,14.1667,1206.07>, <350.833,9.72222,1206.07>, <350.833,-9.72222,1206.07>, <350.833,-14.1667,1206.07>,
<350,15,1206.07>, <350,10,1206.07>, <350,-10,1206.07>, <350,-15,1206.07>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-350,14.5249,403.033>, <-350.833,13.6916,403.033>, <-354.167,10.3582,403.033>, <-355,9.52488,403.033>,
<-350,9.5249,403.033>, <-350.833,9.24712,403.033>, <-354.167,6.46933,403.033>, <-355,6.19155,403.033>,
<-350,-10.4751,403.033>, <-350.833,-10.1973,403.033>, <-354.167,-7.41955,403.033>, <-355,-7.14177,403.033>,
<-350,-15.4751,403.033>, <-350.833,-14.6418,403.033>, <-354.167,-11.3084,403.033>, <-355,-10.4751,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-350,14.5249,403.033>, <-350,14.5249,536.366>, <-350,14.5249,1069.7>, <-350,14.5249,1203.03>,
<-350.833,13.6916,403.033>, <-350.833,13.6916,536.366>, <-350.833,13.6916,1069.7>, <-350.833,13.6916,1203.03>,
<-354.167,10.3582,403.033>, <-354.167,10.3582,536.366>, <-354.167,10.3582,1069.7>, <-354.167,10.3582,1203.03>,
<-355,9.52488,403.033>, <-355,9.52488,536.366>, <-355,9.52488,1069.7>, <-355,9.52488,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-350,14.5249,403.033>, <-350,9.5249,403.033>, <-350,-10.4751,403.033>, <-350,-15.4751,403.033>,
<-346.667,14.5249,403.033>, <-346.667,9.5249,403.033>, <-346.667,-10.4751,403.033>, <-346.667,-15.4751,403.033>,
<-333.333,14.5249,403.033>, <-333.333,9.5249,403.033>, <-333.333,-10.4751,403.033>, <-333.333,-15.4751,403.033>,
<-330,14.5249,403.033>, <-330,9.5249,403.033>, <-330,-10.4751,403.033>, <-330,-15.4751,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-350,14.5249,403.033>, <-346.667,14.5249,403.033>, <-333.333,14.5249,403.033>, <-330,14.5249,403.033>,
<-350,14.5249,536.366>, <-346.667,14.5249,536.366>, <-333.333,14.5249,536.366>, <-330,14.5249,536.366>,
<-350,14.5249,1069.7>, <-346.667,14.5249,1069.7>, <-333.333,14.5249,1069.7>, <-330,14.5249,1069.7>,
<-350,14.5249,1203.03>, <-346.667,14.5249,1203.03>, <-333.333,14.5249,1203.03>, <-330,14.5249,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-330,14.5249,403.033>, <-330,9.5249,403.033>, <-330,-10.4751,403.033>, <-330,-15.4751,403.033>,
<-329.167,13.6916,403.033>, <-329.167,9.24712,403.033>, <-329.167,-10.1973,403.033>, <-329.167,-14.6418,403.033>,
<-325.833,10.3582,403.033>, <-325.833,6.46933,403.033>, <-325.833,-7.41955,403.033>, <-325.833,-11.3084,403.033>,
<-325,9.52488,403.033>, <-325,6.19155,403.033>, <-325,-7.14177,403.033>, <-325,-10.4751,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-330,14.5249,403.033>, <-329.167,13.6916,403.033>, <-325.833,10.3582,403.033>, <-325,9.52488,403.033>,
<-330,14.5249,536.366>, <-329.167,13.6916,536.366>, <-325.833,10.3582,536.366>, <-325,9.52488,536.366>,
<-330,14.5249,1069.7>, <-329.167,13.6916,1069.7>, <-325.833,10.3582,1069.7>, <-325,9.52488,1069.7>,
<-330,14.5249,1203.03>, <-329.167,13.6916,1203.03>, <-325.833,10.3582,1203.03>, <-325,9.52488,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-325,9.52488,403.033>, <-325,6.19155,403.033>, <-325,-7.14177,403.033>, <-325,-10.4751,403.033>,
<-325,9.52488,536.366>, <-325,6.19155,536.366>, <-325,-7.14177,536.366>, <-325,-10.4751,536.366>,
<-325,9.52488,1069.7>, <-325,6.19155,1069.7>, <-325,-7.14177,1069.7>, <-325,-10.4751,1069.7>,
<-325,9.52488,1203.03>, <-325,6.19155,1203.03>, <-325,-7.14177,1203.03>, <-325,-10.4751,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-325,-10.4751,403.033>, <-325.833,-11.3084,403.033>, <-329.167,-14.6418,403.033>, <-330,-15.4751,403.033>,
<-325,-10.4751,536.366>, <-325.833,-11.3084,536.366>, <-329.167,-14.6418,536.366>, <-330,-15.4751,536.366>,
<-325,-10.4751,1069.7>, <-325.833,-11.3084,1069.7>, <-329.167,-14.6418,1069.7>, <-330,-15.4751,1069.7>,
<-325,-10.4751,1203.03>, <-325.833,-11.3084,1203.03>, <-329.167,-14.6418,1203.03>, <-330,-15.4751,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-330,-15.4751,403.033>, <-333.333,-15.4751,403.033>, <-346.667,-15.4751,403.033>, <-350,-15.4751,403.033>,
<-330,-15.4751,536.366>, <-333.333,-15.4751,536.366>, <-346.667,-15.4751,536.366>, <-350,-15.4751,536.366>,
<-330,-15.4751,1069.7>, <-333.333,-15.4751,1069.7>, <-346.667,-15.4751,1069.7>, <-350,-15.4751,1069.7>,
<-330,-15.4751,1203.03>, <-333.333,-15.4751,1203.03>, <-346.667,-15.4751,1203.03>, <-350,-15.4751,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-350,-15.4751,403.033>, <-350.833,-14.6418,403.033>, <-354.167,-11.3084,403.033>, <-355,-10.4751,403.033>,
<-350,-15.4751,536.366>, <-350.833,-14.6418,536.366>, <-354.167,-11.3084,536.366>, <-355,-10.4751,536.366>,
<-350,-15.4751,1069.7>, <-350.833,-14.6418,1069.7>, <-354.167,-11.3084,1069.7>, <-355,-10.4751,1069.7>,
<-350,-15.4751,1203.03>, <-350.833,-14.6418,1203.03>, <-354.167,-11.3084,1203.03>, <-355,-10.4751,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-355,-10.4751,403.033>, <-355,-7.14177,403.033>, <-355,6.19155,403.033>, <-355,9.52488,403.033>,
<-355,-10.4751,536.366>, <-355,-7.14177,536.366>, <-355,6.19155,536.366>, <-355,9.52488,536.366>,
<-355,-10.4751,1069.7>, <-355,-7.14177,1069.7>, <-355,6.19155,1069.7>, <-355,9.52488,1069.7>,
<-355,-10.4751,1203.03>, <-355,-7.14177,1203.03>, <-355,6.19155,1203.03>, <-355,9.52488,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,4.52488,1112.03>, <-321.5,4.52488,1127.03>, <-321.5,4.52488,1187.03>, <-321.5,4.52488,1202.03>,
<-321.5,2.85821,1112.03>, <-321.5,2.85821,1127.03>, <-321.5,2.85821,1187.03>, <-321.5,2.85821,1202.03>,
<-321.5,-3.80845,1112.03>, <-321.5,-3.80845,1127.03>, <-321.5,-3.80845,1187.03>, <-321.5,-3.80845,1202.03>,
<-321.5,-5.47512,1112.03>, <-321.5,-5.47512,1127.03>, <-321.5,-5.47512,1187.03>, <-321.5,-5.47512,1202.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,4.52488,1112.03>, <-321.5,2.85821,1112.03>, <-321.5,-3.80845,1112.03>, <-321.5,-5.47512,1112.03>,
<-294.333,4.52488,1112.03>, <-294.333,2.85821,1112.03>, <-294.333,-3.80845,1112.03>, <-294.333,-5.47512,1112.03>,
<-185.667,4.52488,1112.03>, <-185.667,2.85821,1112.03>, <-185.667,-3.80845,1112.03>, <-185.667,-5.47512,1112.03>,
<-158.5,4.52488,1112.03>, <-158.5,2.85821,1112.03>, <-158.5,-3.80845,1112.03>, <-158.5,-5.47512,1112.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-158.5,4.52488,1112.03>, <-158.5,2.85821,1112.03>, <-158.5,-3.80845,1112.03>, <-158.5,-5.47512,1112.03>,
<-158.5,4.52488,1127.03>, <-158.5,2.85821,1127.03>, <-158.5,-3.80845,1127.03>, <-158.5,-5.47512,1127.03>,
<-158.5,4.52488,1187.03>, <-158.5,2.85821,1187.03>, <-158.5,-3.80845,1187.03>, <-158.5,-5.47512,1187.03>,
<-158.5,4.52488,1202.03>, <-158.5,2.85821,1202.03>, <-158.5,-3.80845,1202.03>, <-158.5,-5.47512,1202.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-158.5,4.52488,1202.03>, <-158.5,2.85821,1202.03>, <-158.5,-3.80845,1202.03>, <-158.5,-5.47512,1202.03>,
<-185.667,4.52488,1202.03>, <-185.667,2.85821,1202.03>, <-185.667,-3.80845,1202.03>, <-185.667,-5.47512,1202.03>,
<-294.333,4.52488,1202.03>, <-294.333,2.85821,1202.03>, <-294.333,-3.80845,1202.03>, <-294.333,-5.47512,1202.03>,
<-321.5,4.52488,1202.03>, <-321.5,2.85821,1202.03>, <-321.5,-3.80845,1202.03>, <-321.5,-5.47512,1202.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-190,1.52488,493.033>, <-190,0.858213,493.033>, <-190,-1.80845,493.033>, <-190,-2.47512,493.033>,
<-190,1.52488,596.366>, <-190,0.858213,596.366>, <-190,-1.80845,596.366>, <-190,-2.47512,596.366>,
<-190,1.52488,1009.7>, <-190,0.858213,1009.7>, <-190,-1.80845,1009.7>, <-190,-2.47512,1009.7>,
<-190,1.52488,1113.03>, <-190,0.858213,1113.03>, <-190,-1.80845,1113.03>, <-190,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-190,1.52488,493.033>, <-190,1.52488,596.366>, <-190,1.52488,1009.7>, <-190,1.52488,1113.03>,
<-189.667,1.85821,493.033>, <-189.667,1.85821,596.366>, <-189.667,1.85821,1009.7>, <-189.667,1.85821,1113.03>,
<-188.333,3.19155,493.033>, <-188.333,3.19155,596.366>, <-188.333,3.19155,1009.7>, <-188.333,3.19155,1113.03>,
<-188,3.52488,493.033>, <-188,3.52488,596.366>, <-188,3.52488,1009.7>, <-188,3.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-188,3.52488,493.033>, <-188,3.52488,596.366>, <-188,3.52488,1009.7>, <-188,3.52488,1113.03>,
<-186.667,3.52488,493.033>, <-186.667,3.52488,596.366>, <-186.667,3.52488,1009.7>, <-186.667,3.52488,1113.03>,
<-181.333,3.52488,493.033>, <-181.333,3.52488,596.366>, <-181.333,3.52488,1009.7>, <-181.333,3.52488,1113.03>,
<-180,3.52488,493.033>, <-180,3.52488,596.366>, <-180,3.52488,1009.7>, <-180,3.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-180,3.52488,493.033>, <-180,3.52488,596.366>, <-180,3.52488,1009.7>, <-180,3.52488,1113.03>,
<-179.667,3.19155,493.033>, <-179.667,3.19155,596.366>, <-179.667,3.19155,1009.7>, <-179.667,3.19155,1113.03>,
<-178.333,1.85821,493.033>, <-178.333,1.85821,596.366>, <-178.333,1.85821,1009.7>, <-178.333,1.85821,1113.03>,
<-178,1.52488,493.033>, <-178,1.52488,596.366>, <-178,1.52488,1009.7>, <-178,1.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-178,1.52488,493.033>, <-178,1.52488,596.366>, <-178,1.52488,1009.7>, <-178,1.52488,1113.03>,
<-178,0.858213,493.033>, <-178,0.858213,596.366>, <-178,0.858213,1009.7>, <-178,0.858213,1113.03>,
<-178,-1.80845,493.033>, <-178,-1.80845,596.366>, <-178,-1.80845,1009.7>, <-178,-1.80845,1113.03>,
<-178,-2.47512,493.033>, <-178,-2.47512,596.366>, <-178,-2.47512,1009.7>, <-178,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-178,-2.47512,493.033>, <-178,-2.47512,596.366>, <-178,-2.47512,1009.7>, <-178,-2.47512,1113.03>,
<-178.333,-2.80845,493.033>, <-178.333,-2.80845,596.366>, <-178.333,-2.80845,1009.7>, <-178.333,-2.80845,1113.03>,
<-179.667,-4.14179,493.033>, <-179.667,-4.14179,596.366>, <-179.667,-4.14179,1009.7>, <-179.667,-4.14179,1113.03>,
<-180,-4.47512,493.033>, <-180,-4.47512,596.366>, <-180,-4.47512,1009.7>, <-180,-4.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-180,-4.47512,493.033>, <-180,-4.47512,596.366>, <-180,-4.47512,1009.7>, <-180,-4.47512,1113.03>,
<-181.333,-4.47512,493.033>, <-181.333,-4.47512,596.366>, <-181.333,-4.47512,1009.7>, <-181.333,-4.47512,1113.03>,
<-186.667,-4.47512,493.033>, <-186.667,-4.47512,596.366>, <-186.667,-4.47512,1009.7>, <-186.667,-4.47512,1113.03>,
<-188,-4.47512,493.033>, <-188,-4.47512,596.366>, <-188,-4.47512,1009.7>, <-188,-4.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-188,-4.47512,493.033>, <-188,-4.47512,596.366>, <-188,-4.47512,1009.7>, <-188,-4.47512,1113.03>,
<-188.333,-4.14179,493.033>, <-188.333,-4.14179,596.366>, <-188.333,-4.14179,1009.7>, <-188.333,-4.14179,1113.03>,
<-189.667,-2.80845,493.033>, <-189.667,-2.80845,596.366>, <-189.667,-2.80845,1009.7>, <-189.667,-2.80845,1113.03>,
<-190,-2.47512,493.033>, <-190,-2.47512,596.366>, <-190,-2.47512,1009.7>, <-190,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-222,1.52488,493.033>, <-222,0.858213,493.033>, <-222,-1.80845,493.033>, <-222,-2.47512,493.033>,
<-222,1.52488,596.366>, <-222,0.858213,596.366>, <-222,-1.80845,596.366>, <-222,-2.47512,596.366>,
<-222,1.52488,1009.7>, <-222,0.858213,1009.7>, <-222,-1.80845,1009.7>, <-222,-2.47512,1009.7>,
<-222,1.52488,1113.03>, <-222,0.858213,1113.03>, <-222,-1.80845,1113.03>, <-222,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-222,1.52488,493.033>, <-222,1.52488,596.366>, <-222,1.52488,1009.7>, <-222,1.52488,1113.03>,
<-221.667,1.85821,493.033>, <-221.667,1.85821,596.366>, <-221.667,1.85821,1009.7>, <-221.667,1.85821,1113.03>,
<-220.333,3.19155,493.033>, <-220.333,3.19155,596.366>, <-220.333,3.19155,1009.7>, <-220.333,3.19155,1113.03>,
<-220,3.52488,493.033>, <-220,3.52488,596.366>, <-220,3.52488,1009.7>, <-220,3.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-220,3.52488,493.033>, <-220,3.52488,596.366>, <-220,3.52488,1009.7>, <-220,3.52488,1113.03>,
<-218.667,3.52488,493.033>, <-218.667,3.52488,596.366>, <-218.667,3.52488,1009.7>, <-218.667,3.52488,1113.03>,
<-213.333,3.52488,493.033>, <-213.333,3.52488,596.366>, <-213.333,3.52488,1009.7>, <-213.333,3.52488,1113.03>,
<-212,3.52488,493.033>, <-212,3.52488,596.366>, <-212,3.52488,1009.7>, <-212,3.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-212,3.52488,493.033>, <-212,3.52488,596.366>, <-212,3.52488,1009.7>, <-212,3.52488,1113.03>,
<-211.667,3.19155,493.033>, <-211.667,3.19155,596.366>, <-211.667,3.19155,1009.7>, <-211.667,3.19155,1113.03>,
<-210.333,1.85821,493.033>, <-210.333,1.85821,596.366>, <-210.333,1.85821,1009.7>, <-210.333,1.85821,1113.03>,
<-210,1.52488,493.033>, <-210,1.52488,596.366>, <-210,1.52488,1009.7>, <-210,1.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-210,1.52488,493.033>, <-210,1.52488,596.366>, <-210,1.52488,1009.7>, <-210,1.52488,1113.03>,
<-210,0.858213,493.033>, <-210,0.858213,596.366>, <-210,0.858213,1009.7>, <-210,0.858213,1113.03>,
<-210,-1.80845,493.033>, <-210,-1.80845,596.366>, <-210,-1.80845,1009.7>, <-210,-1.80845,1113.03>,
<-210,-2.47512,493.033>, <-210,-2.47512,596.366>, <-210,-2.47512,1009.7>, <-210,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-210,-2.47512,493.033>, <-210,-2.47512,596.366>, <-210,-2.47512,1009.7>, <-210,-2.47512,1113.03>,
<-210.333,-2.80845,493.033>, <-210.333,-2.80845,596.366>, <-210.333,-2.80845,1009.7>, <-210.333,-2.80845,1113.03>,
<-211.667,-4.14179,493.033>, <-211.667,-4.14179,596.366>, <-211.667,-4.14179,1009.7>, <-211.667,-4.14179,1113.03>,
<-212,-4.47512,493.033>, <-212,-4.47512,596.366>, <-212,-4.47512,1009.7>, <-212,-4.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-212,-4.47512,493.033>, <-212,-4.47512,596.366>, <-212,-4.47512,1009.7>, <-212,-4.47512,1113.03>,
<-213.333,-4.47512,493.033>, <-213.333,-4.47512,596.366>, <-213.333,-4.47512,1009.7>, <-213.333,-4.47512,1113.03>,
<-218.667,-4.47512,493.033>, <-218.667,-4.47512,596.366>, <-218.667,-4.47512,1009.7>, <-218.667,-4.47512,1113.03>,
<-220,-4.47512,493.033>, <-220,-4.47512,596.366>, <-220,-4.47512,1009.7>, <-220,-4.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-220,-4.47512,493.033>, <-220,-4.47512,596.366>, <-220,-4.47512,1009.7>, <-220,-4.47512,1113.03>,
<-220.333,-4.14179,493.033>, <-220.333,-4.14179,596.366>, <-220.333,-4.14179,1009.7>, <-220.333,-4.14179,1113.03>,
<-221.667,-2.80845,493.033>, <-221.667,-2.80845,596.366>, <-221.667,-2.80845,1009.7>, <-221.667,-2.80845,1113.03>,
<-222,-2.47512,493.033>, <-222,-2.47512,596.366>, <-222,-2.47512,1009.7>, <-222,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-174,1.52488,493.033>, <-174,0.858213,493.033>, <-174,-1.80845,493.033>, <-174,-2.47512,493.033>,
<-174,1.52488,596.366>, <-174,0.858213,596.366>, <-174,-1.80845,596.366>, <-174,-2.47512,596.366>,
<-174,1.52488,1009.7>, <-174,0.858213,1009.7>, <-174,-1.80845,1009.7>, <-174,-2.47512,1009.7>,
<-174,1.52488,1113.03>, <-174,0.858213,1113.03>, <-174,-1.80845,1113.03>, <-174,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-174,1.52488,493.033>, <-174,1.52488,596.366>, <-174,1.52488,1009.7>, <-174,1.52488,1113.03>,
<-173.667,1.85821,493.033>, <-173.667,1.85821,596.366>, <-173.667,1.85821,1009.7>, <-173.667,1.85821,1113.03>,
<-172.333,3.19155,493.033>, <-172.333,3.19155,596.366>, <-172.333,3.19155,1009.7>, <-172.333,3.19155,1113.03>,
<-172,3.52488,493.033>, <-172,3.52488,596.366>, <-172,3.52488,1009.7>, <-172,3.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-172,3.52488,493.033>, <-172,3.52488,596.366>, <-172,3.52488,1009.7>, <-172,3.52488,1113.03>,
<-170.667,3.52488,493.033>, <-170.667,3.52488,596.366>, <-170.667,3.52488,1009.7>, <-170.667,3.52488,1113.03>,
<-165.333,3.52488,493.033>, <-165.333,3.52488,596.366>, <-165.333,3.52488,1009.7>, <-165.333,3.52488,1113.03>,
<-164,3.52488,493.033>, <-164,3.52488,596.366>, <-164,3.52488,1009.7>, <-164,3.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-164,3.52488,493.033>, <-164,3.52488,596.366>, <-164,3.52488,1009.7>, <-164,3.52488,1113.03>,
<-163.667,3.19155,493.033>, <-163.667,3.19155,596.366>, <-163.667,3.19155,1009.7>, <-163.667,3.19155,1113.03>,
<-162.333,1.85821,493.033>, <-162.333,1.85821,596.366>, <-162.333,1.85821,1009.7>, <-162.333,1.85821,1113.03>,
<-162,1.52488,493.033>, <-162,1.52488,596.366>, <-162,1.52488,1009.7>, <-162,1.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-162,1.52488,493.033>, <-162,1.52488,596.366>, <-162,1.52488,1009.7>, <-162,1.52488,1113.03>,
<-162,0.858213,493.033>, <-162,0.858213,596.366>, <-162,0.858213,1009.7>, <-162,0.858213,1113.03>,
<-162,-1.80845,493.033>, <-162,-1.80845,596.366>, <-162,-1.80845,1009.7>, <-162,-1.80845,1113.03>,
<-162,-2.47512,493.033>, <-162,-2.47512,596.366>, <-162,-2.47512,1009.7>, <-162,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-162,-2.47512,493.033>, <-162,-2.47512,596.366>, <-162,-2.47512,1009.7>, <-162,-2.47512,1113.03>,
<-162.333,-2.80845,493.033>, <-162.333,-2.80845,596.366>, <-162.333,-2.80845,1009.7>, <-162.333,-2.80845,1113.03>,
<-163.667,-4.14179,493.033>, <-163.667,-4.14179,596.366>, <-163.667,-4.14179,1009.7>, <-163.667,-4.14179,1113.03>,
<-164,-4.47512,493.033>, <-164,-4.47512,596.366>, <-164,-4.47512,1009.7>, <-164,-4.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-164,-4.47512,493.033>, <-164,-4.47512,596.366>, <-164,-4.47512,1009.7>, <-164,-4.47512,1113.03>,
<-165.333,-4.47512,493.033>, <-165.333,-4.47512,596.366>, <-165.333,-4.47512,1009.7>, <-165.333,-4.47512,1113.03>,
<-170.667,-4.47512,493.033>, <-170.667,-4.47512,596.366>, <-170.667,-4.47512,1009.7>, <-170.667,-4.47512,1113.03>,
<-172,-4.47512,493.033>, <-172,-4.47512,596.366>, <-172,-4.47512,1009.7>, <-172,-4.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-172,-4.47512,493.033>, <-172,-4.47512,596.366>, <-172,-4.47512,1009.7>, <-172,-4.47512,1113.03>,
<-172.333,-4.14179,493.033>, <-172.333,-4.14179,596.366>, <-172.333,-4.14179,1009.7>, <-172.333,-4.14179,1113.03>,
<-173.667,-2.80845,493.033>, <-173.667,-2.80845,596.366>, <-173.667,-2.80845,1009.7>, <-173.667,-2.80845,1113.03>,
<-174,-2.47512,493.033>, <-174,-2.47512,596.366>, <-174,-2.47512,1009.7>, <-174,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-238,1.52488,493.033>, <-238,0.858213,493.033>, <-238,-1.80845,493.033>, <-238,-2.47512,493.033>,
<-238,1.52488,596.366>, <-238,0.858213,596.366>, <-238,-1.80845,596.366>, <-238,-2.47512,596.366>,
<-238,1.52488,1009.7>, <-238,0.858213,1009.7>, <-238,-1.80845,1009.7>, <-238,-2.47512,1009.7>,
<-238,1.52488,1113.03>, <-238,0.858213,1113.03>, <-238,-1.80845,1113.03>, <-238,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-238,1.52488,493.033>, <-238,1.52488,596.366>, <-238,1.52488,1009.7>, <-238,1.52488,1113.03>,
<-237.667,1.85821,493.033>, <-237.667,1.85821,596.366>, <-237.667,1.85821,1009.7>, <-237.667,1.85821,1113.03>,
<-236.333,3.19155,493.033>, <-236.333,3.19155,596.366>, <-236.333,3.19155,1009.7>, <-236.333,3.19155,1113.03>,
<-236,3.52488,493.033>, <-236,3.52488,596.366>, <-236,3.52488,1009.7>, <-236,3.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-236,3.52488,493.033>, <-236,3.52488,596.366>, <-236,3.52488,1009.7>, <-236,3.52488,1113.03>,
<-234.667,3.52488,493.033>, <-234.667,3.52488,596.366>, <-234.667,3.52488,1009.7>, <-234.667,3.52488,1113.03>,
<-229.333,3.52488,493.033>, <-229.333,3.52488,596.366>, <-229.333,3.52488,1009.7>, <-229.333,3.52488,1113.03>,
<-228,3.52488,493.033>, <-228,3.52488,596.366>, <-228,3.52488,1009.7>, <-228,3.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-228,3.52488,493.033>, <-228,3.52488,596.366>, <-228,3.52488,1009.7>, <-228,3.52488,1113.03>,
<-227.667,3.19155,493.033>, <-227.667,3.19155,596.366>, <-227.667,3.19155,1009.7>, <-227.667,3.19155,1113.03>,
<-226.333,1.85821,493.033>, <-226.333,1.85821,596.366>, <-226.333,1.85821,1009.7>, <-226.333,1.85821,1113.03>,
<-226,1.52488,493.033>, <-226,1.52488,596.366>, <-226,1.52488,1009.7>, <-226,1.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-226,1.52488,493.033>, <-226,1.52488,596.366>, <-226,1.52488,1009.7>, <-226,1.52488,1113.03>,
<-226,0.858213,493.033>, <-226,0.858213,596.366>, <-226,0.858213,1009.7>, <-226,0.858213,1113.03>,
<-226,-1.80845,493.033>, <-226,-1.80845,596.366>, <-226,-1.80845,1009.7>, <-226,-1.80845,1113.03>,
<-226,-2.47512,493.033>, <-226,-2.47512,596.366>, <-226,-2.47512,1009.7>, <-226,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-226,-2.47512,493.033>, <-226,-2.47512,596.366>, <-226,-2.47512,1009.7>, <-226,-2.47512,1113.03>,
<-226.333,-2.80845,493.033>, <-226.333,-2.80845,596.366>, <-226.333,-2.80845,1009.7>, <-226.333,-2.80845,1113.03>,
<-227.667,-4.14179,493.033>, <-227.667,-4.14179,596.366>, <-227.667,-4.14179,1009.7>, <-227.667,-4.14179,1113.03>,
<-228,-4.47512,493.033>, <-228,-4.47512,596.366>, <-228,-4.47512,1009.7>, <-228,-4.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-228,-4.47512,493.033>, <-228,-4.47512,596.366>, <-228,-4.47512,1009.7>, <-228,-4.47512,1113.03>,
<-229.333,-4.47512,493.033>, <-229.333,-4.47512,596.366>, <-229.333,-4.47512,1009.7>, <-229.333,-4.47512,1113.03>,
<-234.667,-4.47512,493.033>, <-234.667,-4.47512,596.366>, <-234.667,-4.47512,1009.7>, <-234.667,-4.47512,1113.03>,
<-236,-4.47512,493.033>, <-236,-4.47512,596.366>, <-236,-4.47512,1009.7>, <-236,-4.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-236,-4.47512,493.033>, <-236,-4.47512,596.366>, <-236,-4.47512,1009.7>, <-236,-4.47512,1113.03>,
<-236.333,-4.14179,493.033>, <-236.333,-4.14179,596.366>, <-236.333,-4.14179,1009.7>, <-236.333,-4.14179,1113.03>,
<-237.667,-2.80845,493.033>, <-237.667,-2.80845,596.366>, <-237.667,-2.80845,1009.7>, <-237.667,-2.80845,1113.03>,
<-238,-2.47512,493.033>, <-238,-2.47512,596.366>, <-238,-2.47512,1009.7>, <-238,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-206,1.52488,493.033>, <-206,0.858213,493.033>, <-206,-1.80845,493.033>, <-206,-2.47512,493.033>,
<-206,1.52488,596.366>, <-206,0.858213,596.366>, <-206,-1.80845,596.366>, <-206,-2.47512,596.366>,
<-206,1.52488,1009.7>, <-206,0.858213,1009.7>, <-206,-1.80845,1009.7>, <-206,-2.47512,1009.7>,
<-206,1.52488,1113.03>, <-206,0.858213,1113.03>, <-206,-1.80845,1113.03>, <-206,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-206,1.52488,493.033>, <-206,1.52488,596.366>, <-206,1.52488,1009.7>, <-206,1.52488,1113.03>,
<-205.667,1.85821,493.033>, <-205.667,1.85821,596.366>, <-205.667,1.85821,1009.7>, <-205.667,1.85821,1113.03>,
<-204.333,3.19155,493.033>, <-204.333,3.19155,596.366>, <-204.333,3.19155,1009.7>, <-204.333,3.19155,1113.03>,
<-204,3.52488,493.033>, <-204,3.52488,596.366>, <-204,3.52488,1009.7>, <-204,3.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-204,3.52488,493.033>, <-204,3.52488,596.366>, <-204,3.52488,1009.7>, <-204,3.52488,1113.03>,
<-202.667,3.52488,493.033>, <-202.667,3.52488,596.366>, <-202.667,3.52488,1009.7>, <-202.667,3.52488,1113.03>,
<-197.333,3.52488,493.033>, <-197.333,3.52488,596.366>, <-197.333,3.52488,1009.7>, <-197.333,3.52488,1113.03>,
<-196,3.52488,493.033>, <-196,3.52488,596.366>, <-196,3.52488,1009.7>, <-196,3.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-196,3.52488,493.033>, <-196,3.52488,596.366>, <-196,3.52488,1009.7>, <-196,3.52488,1113.03>,
<-195.667,3.19155,493.033>, <-195.667,3.19155,596.366>, <-195.667,3.19155,1009.7>, <-195.667,3.19155,1113.03>,
<-194.333,1.85821,493.033>, <-194.333,1.85821,596.366>, <-194.333,1.85821,1009.7>, <-194.333,1.85821,1113.03>,
<-194,1.52488,493.033>, <-194,1.52488,596.366>, <-194,1.52488,1009.7>, <-194,1.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-194,1.52488,493.033>, <-194,1.52488,596.366>, <-194,1.52488,1009.7>, <-194,1.52488,1113.03>,
<-194,0.858213,493.033>, <-194,0.858213,596.366>, <-194,0.858213,1009.7>, <-194,0.858213,1113.03>,
<-194,-1.80845,493.033>, <-194,-1.80845,596.366>, <-194,-1.80845,1009.7>, <-194,-1.80845,1113.03>,
<-194,-2.47512,493.033>, <-194,-2.47512,596.366>, <-194,-2.47512,1009.7>, <-194,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-194,-2.47512,493.033>, <-194,-2.47512,596.366>, <-194,-2.47512,1009.7>, <-194,-2.47512,1113.03>,
<-194.333,-2.80845,493.033>, <-194.333,-2.80845,596.366>, <-194.333,-2.80845,1009.7>, <-194.333,-2.80845,1113.03>,
<-195.667,-4.14179,493.033>, <-195.667,-4.14179,596.366>, <-195.667,-4.14179,1009.7>, <-195.667,-4.14179,1113.03>,
<-196,-4.47512,493.033>, <-196,-4.47512,596.366>, <-196,-4.47512,1009.7>, <-196,-4.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-196,-4.47512,493.033>, <-196,-4.47512,596.366>, <-196,-4.47512,1009.7>, <-196,-4.47512,1113.03>,
<-197.333,-4.47512,493.033>, <-197.333,-4.47512,596.366>, <-197.333,-4.47512,1009.7>, <-197.333,-4.47512,1113.03>,
<-202.667,-4.47512,493.033>, <-202.667,-4.47512,596.366>, <-202.667,-4.47512,1009.7>, <-202.667,-4.47512,1113.03>,
<-204,-4.47512,493.033>, <-204,-4.47512,596.366>, <-204,-4.47512,1009.7>, <-204,-4.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-204,-4.47512,493.033>, <-204,-4.47512,596.366>, <-204,-4.47512,1009.7>, <-204,-4.47512,1113.03>,
<-204.333,-4.14179,493.033>, <-204.333,-4.14179,596.366>, <-204.333,-4.14179,1009.7>, <-204.333,-4.14179,1113.03>,
<-205.667,-2.80845,493.033>, <-205.667,-2.80845,596.366>, <-205.667,-2.80845,1009.7>, <-205.667,-2.80845,1113.03>,
<-206,-2.47512,493.033>, <-206,-2.47512,596.366>, <-206,-2.47512,1009.7>, <-206,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-286,1.52488,493.033>, <-286,0.858213,493.033>, <-286,-1.80845,493.033>, <-286,-2.47512,493.033>,
<-286,1.52488,596.366>, <-286,0.858213,596.366>, <-286,-1.80845,596.366>, <-286,-2.47512,596.366>,
<-286,1.52488,1009.7>, <-286,0.858213,1009.7>, <-286,-1.80845,1009.7>, <-286,-2.47512,1009.7>,
<-286,1.52488,1113.03>, <-286,0.858213,1113.03>, <-286,-1.80845,1113.03>, <-286,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-286,1.52488,493.033>, <-286,1.52488,596.366>, <-286,1.52488,1009.7>, <-286,1.52488,1113.03>,
<-285.667,1.85821,493.033>, <-285.667,1.85821,596.366>, <-285.667,1.85821,1009.7>, <-285.667,1.85821,1113.03>,
<-284.333,3.19155,493.033>, <-284.333,3.19155,596.366>, <-284.333,3.19155,1009.7>, <-284.333,3.19155,1113.03>,
<-284,3.52488,493.033>, <-284,3.52488,596.366>, <-284,3.52488,1009.7>, <-284,3.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-284,3.52488,493.033>, <-284,3.52488,596.366>, <-284,3.52488,1009.7>, <-284,3.52488,1113.03>,
<-282.667,3.52488,493.033>, <-282.667,3.52488,596.366>, <-282.667,3.52488,1009.7>, <-282.667,3.52488,1113.03>,
<-277.333,3.52488,493.033>, <-277.333,3.52488,596.366>, <-277.333,3.52488,1009.7>, <-277.333,3.52488,1113.03>,
<-276,3.52488,493.033>, <-276,3.52488,596.366>, <-276,3.52488,1009.7>, <-276,3.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-276,3.52488,493.033>, <-276,3.52488,596.366>, <-276,3.52488,1009.7>, <-276,3.52488,1113.03>,
<-275.667,3.19155,493.033>, <-275.667,3.19155,596.366>, <-275.667,3.19155,1009.7>, <-275.667,3.19155,1113.03>,
<-274.333,1.85821,493.033>, <-274.333,1.85821,596.366>, <-274.333,1.85821,1009.7>, <-274.333,1.85821,1113.03>,
<-274,1.52488,493.033>, <-274,1.52488,596.366>, <-274,1.52488,1009.7>, <-274,1.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-274,1.52488,493.033>, <-274,1.52488,596.366>, <-274,1.52488,1009.7>, <-274,1.52488,1113.03>,
<-274,0.858213,493.033>, <-274,0.858213,596.366>, <-274,0.858213,1009.7>, <-274,0.858213,1113.03>,
<-274,-1.80845,493.033>, <-274,-1.80845,596.366>, <-274,-1.80845,1009.7>, <-274,-1.80845,1113.03>,
<-274,-2.47512,493.033>, <-274,-2.47512,596.366>, <-274,-2.47512,1009.7>, <-274,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-274,-2.47512,493.033>, <-274,-2.47512,596.366>, <-274,-2.47512,1009.7>, <-274,-2.47512,1113.03>,
<-274.333,-2.80845,493.033>, <-274.333,-2.80845,596.366>, <-274.333,-2.80845,1009.7>, <-274.333,-2.80845,1113.03>,
<-275.667,-4.14179,493.033>, <-275.667,-4.14179,596.366>, <-275.667,-4.14179,1009.7>, <-275.667,-4.14179,1113.03>,
<-276,-4.47512,493.033>, <-276,-4.47512,596.366>, <-276,-4.47512,1009.7>, <-276,-4.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-276,-4.47512,493.033>, <-276,-4.47512,596.366>, <-276,-4.47512,1009.7>, <-276,-4.47512,1113.03>,
<-277.333,-4.47512,493.033>, <-277.333,-4.47512,596.366>, <-277.333,-4.47512,1009.7>, <-277.333,-4.47512,1113.03>,
<-282.667,-4.47512,493.033>, <-282.667,-4.47512,596.366>, <-282.667,-4.47512,1009.7>, <-282.667,-4.47512,1113.03>,
<-284,-4.47512,493.033>, <-284,-4.47512,596.366>, <-284,-4.47512,1009.7>, <-284,-4.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-284,-4.47512,493.033>, <-284,-4.47512,596.366>, <-284,-4.47512,1009.7>, <-284,-4.47512,1113.03>,
<-284.333,-4.14179,493.033>, <-284.333,-4.14179,596.366>, <-284.333,-4.14179,1009.7>, <-284.333,-4.14179,1113.03>,
<-285.667,-2.80845,493.033>, <-285.667,-2.80845,596.366>, <-285.667,-2.80845,1009.7>, <-285.667,-2.80845,1113.03>,
<-286,-2.47512,493.033>, <-286,-2.47512,596.366>, <-286,-2.47512,1009.7>, <-286,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-318,1.52488,493.033>, <-318,0.858213,493.033>, <-318,-1.80845,493.033>, <-318,-2.47512,493.033>,
<-318,1.52488,596.366>, <-318,0.858213,596.366>, <-318,-1.80845,596.366>, <-318,-2.47512,596.366>,
<-318,1.52488,1009.7>, <-318,0.858213,1009.7>, <-318,-1.80845,1009.7>, <-318,-2.47512,1009.7>,
<-318,1.52488,1113.03>, <-318,0.858213,1113.03>, <-318,-1.80845,1113.03>, <-318,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-318,1.52488,493.033>, <-318,1.52488,596.366>, <-318,1.52488,1009.7>, <-318,1.52488,1113.03>,
<-317.667,1.85821,493.033>, <-317.667,1.85821,596.366>, <-317.667,1.85821,1009.7>, <-317.667,1.85821,1113.03>,
<-316.333,3.19155,493.033>, <-316.333,3.19155,596.366>, <-316.333,3.19155,1009.7>, <-316.333,3.19155,1113.03>,
<-316,3.52488,493.033>, <-316,3.52488,596.366>, <-316,3.52488,1009.7>, <-316,3.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-316,3.52488,493.033>, <-316,3.52488,596.366>, <-316,3.52488,1009.7>, <-316,3.52488,1113.03>,
<-314.667,3.52488,493.033>, <-314.667,3.52488,596.366>, <-314.667,3.52488,1009.7>, <-314.667,3.52488,1113.03>,
<-309.333,3.52488,493.033>, <-309.333,3.52488,596.366>, <-309.333,3.52488,1009.7>, <-309.333,3.52488,1113.03>,
<-308,3.52488,493.033>, <-308,3.52488,596.366>, <-308,3.52488,1009.7>, <-308,3.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-308,3.52488,493.033>, <-308,3.52488,596.366>, <-308,3.52488,1009.7>, <-308,3.52488,1113.03>,
<-307.667,3.19155,493.033>, <-307.667,3.19155,596.366>, <-307.667,3.19155,1009.7>, <-307.667,3.19155,1113.03>,
<-306.333,1.85821,493.033>, <-306.333,1.85821,596.366>, <-306.333,1.85821,1009.7>, <-306.333,1.85821,1113.03>,
<-306,1.52488,493.033>, <-306,1.52488,596.366>, <-306,1.52488,1009.7>, <-306,1.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-306,1.52488,493.033>, <-306,1.52488,596.366>, <-306,1.52488,1009.7>, <-306,1.52488,1113.03>,
<-306,0.858213,493.033>, <-306,0.858213,596.366>, <-306,0.858213,1009.7>, <-306,0.858213,1113.03>,
<-306,-1.80845,493.033>, <-306,-1.80845,596.366>, <-306,-1.80845,1009.7>, <-306,-1.80845,1113.03>,
<-306,-2.47512,493.033>, <-306,-2.47512,596.366>, <-306,-2.47512,1009.7>, <-306,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-306,-2.47512,493.033>, <-306,-2.47512,596.366>, <-306,-2.47512,1009.7>, <-306,-2.47512,1113.03>,
<-306.333,-2.80845,493.033>, <-306.333,-2.80845,596.366>, <-306.333,-2.80845,1009.7>, <-306.333,-2.80845,1113.03>,
<-307.667,-4.14179,493.033>, <-307.667,-4.14179,596.366>, <-307.667,-4.14179,1009.7>, <-307.667,-4.14179,1113.03>,
<-308,-4.47512,493.033>, <-308,-4.47512,596.366>, <-308,-4.47512,1009.7>, <-308,-4.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-308,-4.47512,493.033>, <-308,-4.47512,596.366>, <-308,-4.47512,1009.7>, <-308,-4.47512,1113.03>,
<-309.333,-4.47512,493.033>, <-309.333,-4.47512,596.366>, <-309.333,-4.47512,1009.7>, <-309.333,-4.47512,1113.03>,
<-314.667,-4.47512,493.033>, <-314.667,-4.47512,596.366>, <-314.667,-4.47512,1009.7>, <-314.667,-4.47512,1113.03>,
<-316,-4.47512,493.033>, <-316,-4.47512,596.366>, <-316,-4.47512,1009.7>, <-316,-4.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-316,-4.47512,493.033>, <-316,-4.47512,596.366>, <-316,-4.47512,1009.7>, <-316,-4.47512,1113.03>,
<-316.333,-4.14179,493.033>, <-316.333,-4.14179,596.366>, <-316.333,-4.14179,1009.7>, <-316.333,-4.14179,1113.03>,
<-317.667,-2.80845,493.033>, <-317.667,-2.80845,596.366>, <-317.667,-2.80845,1009.7>, <-317.667,-2.80845,1113.03>,
<-318,-2.47512,493.033>, <-318,-2.47512,596.366>, <-318,-2.47512,1009.7>, <-318,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-254,1.52488,493.033>, <-254,0.858213,493.033>, <-254,-1.80845,493.033>, <-254,-2.47512,493.033>,
<-254,1.52488,596.366>, <-254,0.858213,596.366>, <-254,-1.80845,596.366>, <-254,-2.47512,596.366>,
<-254,1.52488,1009.7>, <-254,0.858213,1009.7>, <-254,-1.80845,1009.7>, <-254,-2.47512,1009.7>,
<-254,1.52488,1113.03>, <-254,0.858213,1113.03>, <-254,-1.80845,1113.03>, <-254,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-254,1.52488,493.033>, <-254,1.52488,596.366>, <-254,1.52488,1009.7>, <-254,1.52488,1113.03>,
<-253.667,1.85821,493.033>, <-253.667,1.85821,596.366>, <-253.667,1.85821,1009.7>, <-253.667,1.85821,1113.03>,
<-252.333,3.19155,493.033>, <-252.333,3.19155,596.366>, <-252.333,3.19155,1009.7>, <-252.333,3.19155,1113.03>,
<-252,3.52488,493.033>, <-252,3.52488,596.366>, <-252,3.52488,1009.7>, <-252,3.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-252,3.52488,493.033>, <-252,3.52488,596.366>, <-252,3.52488,1009.7>, <-252,3.52488,1113.03>,
<-250.667,3.52488,493.033>, <-250.667,3.52488,596.366>, <-250.667,3.52488,1009.7>, <-250.667,3.52488,1113.03>,
<-245.333,3.52488,493.033>, <-245.333,3.52488,596.366>, <-245.333,3.52488,1009.7>, <-245.333,3.52488,1113.03>,
<-244,3.52488,493.033>, <-244,3.52488,596.366>, <-244,3.52488,1009.7>, <-244,3.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-244,3.52488,493.033>, <-244,3.52488,596.366>, <-244,3.52488,1009.7>, <-244,3.52488,1113.03>,
<-243.667,3.19155,493.033>, <-243.667,3.19155,596.366>, <-243.667,3.19155,1009.7>, <-243.667,3.19155,1113.03>,
<-242.333,1.85821,493.033>, <-242.333,1.85821,596.366>, <-242.333,1.85821,1009.7>, <-242.333,1.85821,1113.03>,
<-242,1.52488,493.033>, <-242,1.52488,596.366>, <-242,1.52488,1009.7>, <-242,1.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-242,1.52488,493.033>, <-242,1.52488,596.366>, <-242,1.52488,1009.7>, <-242,1.52488,1113.03>,
<-242,0.858213,493.033>, <-242,0.858213,596.366>, <-242,0.858213,1009.7>, <-242,0.858213,1113.03>,
<-242,-1.80845,493.033>, <-242,-1.80845,596.366>, <-242,-1.80845,1009.7>, <-242,-1.80845,1113.03>,
<-242,-2.47512,493.033>, <-242,-2.47512,596.366>, <-242,-2.47512,1009.7>, <-242,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-242,-2.47512,493.033>, <-242,-2.47512,596.366>, <-242,-2.47512,1009.7>, <-242,-2.47512,1113.03>,
<-242.333,-2.80845,493.033>, <-242.333,-2.80845,596.366>, <-242.333,-2.80845,1009.7>, <-242.333,-2.80845,1113.03>,
<-243.667,-4.14179,493.033>, <-243.667,-4.14179,596.366>, <-243.667,-4.14179,1009.7>, <-243.667,-4.14179,1113.03>,
<-244,-4.47512,493.033>, <-244,-4.47512,596.366>, <-244,-4.47512,1009.7>, <-244,-4.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-244,-4.47512,493.033>, <-244,-4.47512,596.366>, <-244,-4.47512,1009.7>, <-244,-4.47512,1113.03>,
<-245.333,-4.47512,493.033>, <-245.333,-4.47512,596.366>, <-245.333,-4.47512,1009.7>, <-245.333,-4.47512,1113.03>,
<-250.667,-4.47512,493.033>, <-250.667,-4.47512,596.366>, <-250.667,-4.47512,1009.7>, <-250.667,-4.47512,1113.03>,
<-252,-4.47512,493.033>, <-252,-4.47512,596.366>, <-252,-4.47512,1009.7>, <-252,-4.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-252,-4.47512,493.033>, <-252,-4.47512,596.366>, <-252,-4.47512,1009.7>, <-252,-4.47512,1113.03>,
<-252.333,-4.14179,493.033>, <-252.333,-4.14179,596.366>, <-252.333,-4.14179,1009.7>, <-252.333,-4.14179,1113.03>,
<-253.667,-2.80845,493.033>, <-253.667,-2.80845,596.366>, <-253.667,-2.80845,1009.7>, <-253.667,-2.80845,1113.03>,
<-254,-2.47512,493.033>, <-254,-2.47512,596.366>, <-254,-2.47512,1009.7>, <-254,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-302,1.52488,493.033>, <-302,0.858213,493.033>, <-302,-1.80845,493.033>, <-302,-2.47512,493.033>,
<-302,1.52488,596.366>, <-302,0.858213,596.366>, <-302,-1.80845,596.366>, <-302,-2.47512,596.366>,
<-302,1.52488,1009.7>, <-302,0.858213,1009.7>, <-302,-1.80845,1009.7>, <-302,-2.47512,1009.7>,
<-302,1.52488,1113.03>, <-302,0.858213,1113.03>, <-302,-1.80845,1113.03>, <-302,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-302,1.52488,493.033>, <-302,1.52488,596.366>, <-302,1.52488,1009.7>, <-302,1.52488,1113.03>,
<-301.667,1.85821,493.033>, <-301.667,1.85821,596.366>, <-301.667,1.85821,1009.7>, <-301.667,1.85821,1113.03>,
<-300.333,3.19155,493.033>, <-300.333,3.19155,596.366>, <-300.333,3.19155,1009.7>, <-300.333,3.19155,1113.03>,
<-300,3.52488,493.033>, <-300,3.52488,596.366>, <-300,3.52488,1009.7>, <-300,3.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-300,3.52488,493.033>, <-300,3.52488,596.366>, <-300,3.52488,1009.7>, <-300,3.52488,1113.03>,
<-298.667,3.52488,493.033>, <-298.667,3.52488,596.366>, <-298.667,3.52488,1009.7>, <-298.667,3.52488,1113.03>,
<-293.333,3.52488,493.033>, <-293.333,3.52488,596.366>, <-293.333,3.52488,1009.7>, <-293.333,3.52488,1113.03>,
<-292,3.52488,493.033>, <-292,3.52488,596.366>, <-292,3.52488,1009.7>, <-292,3.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-292,3.52488,493.033>, <-292,3.52488,596.366>, <-292,3.52488,1009.7>, <-292,3.52488,1113.03>,
<-291.667,3.19155,493.033>, <-291.667,3.19155,596.366>, <-291.667,3.19155,1009.7>, <-291.667,3.19155,1113.03>,
<-290.333,1.85821,493.033>, <-290.333,1.85821,596.366>, <-290.333,1.85821,1009.7>, <-290.333,1.85821,1113.03>,
<-290,1.52488,493.033>, <-290,1.52488,596.366>, <-290,1.52488,1009.7>, <-290,1.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-290,1.52488,493.033>, <-290,1.52488,596.366>, <-290,1.52488,1009.7>, <-290,1.52488,1113.03>,
<-290,0.858213,493.033>, <-290,0.858213,596.366>, <-290,0.858213,1009.7>, <-290,0.858213,1113.03>,
<-290,-1.80845,493.033>, <-290,-1.80845,596.366>, <-290,-1.80845,1009.7>, <-290,-1.80845,1113.03>,
<-290,-2.47512,493.033>, <-290,-2.47512,596.366>, <-290,-2.47512,1009.7>, <-290,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-290,-2.47512,493.033>, <-290,-2.47512,596.366>, <-290,-2.47512,1009.7>, <-290,-2.47512,1113.03>,
<-290.333,-2.80845,493.033>, <-290.333,-2.80845,596.366>, <-290.333,-2.80845,1009.7>, <-290.333,-2.80845,1113.03>,
<-291.667,-4.14179,493.033>, <-291.667,-4.14179,596.366>, <-291.667,-4.14179,1009.7>, <-291.667,-4.14179,1113.03>,
<-292,-4.47512,493.033>, <-292,-4.47512,596.366>, <-292,-4.47512,1009.7>, <-292,-4.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-292,-4.47512,493.033>, <-292,-4.47512,596.366>, <-292,-4.47512,1009.7>, <-292,-4.47512,1113.03>,
<-293.333,-4.47512,493.033>, <-293.333,-4.47512,596.366>, <-293.333,-4.47512,1009.7>, <-293.333,-4.47512,1113.03>,
<-298.667,-4.47512,493.033>, <-298.667,-4.47512,596.366>, <-298.667,-4.47512,1009.7>, <-298.667,-4.47512,1113.03>,
<-300,-4.47512,493.033>, <-300,-4.47512,596.366>, <-300,-4.47512,1009.7>, <-300,-4.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-300,-4.47512,493.033>, <-300,-4.47512,596.366>, <-300,-4.47512,1009.7>, <-300,-4.47512,1113.03>,
<-300.333,-4.14179,493.033>, <-300.333,-4.14179,596.366>, <-300.333,-4.14179,1009.7>, <-300.333,-4.14179,1113.03>,
<-301.667,-2.80845,493.033>, <-301.667,-2.80845,596.366>, <-301.667,-2.80845,1009.7>, <-301.667,-2.80845,1113.03>,
<-302,-2.47512,493.033>, <-302,-2.47512,596.366>, <-302,-2.47512,1009.7>, <-302,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-270,1.52488,493.033>, <-270,0.858213,493.033>, <-270,-1.80845,493.033>, <-270,-2.47512,493.033>,
<-270,1.52488,596.366>, <-270,0.858213,596.366>, <-270,-1.80845,596.366>, <-270,-2.47512,596.366>,
<-270,1.52488,1009.7>, <-270,0.858213,1009.7>, <-270,-1.80845,1009.7>, <-270,-2.47512,1009.7>,
<-270,1.52488,1113.03>, <-270,0.858213,1113.03>, <-270,-1.80845,1113.03>, <-270,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-270,1.52488,493.033>, <-270,1.52488,596.366>, <-270,1.52488,1009.7>, <-270,1.52488,1113.03>,
<-269.667,1.85821,493.033>, <-269.667,1.85821,596.366>, <-269.667,1.85821,1009.7>, <-269.667,1.85821,1113.03>,
<-268.333,3.19155,493.033>, <-268.333,3.19155,596.366>, <-268.333,3.19155,1009.7>, <-268.333,3.19155,1113.03>,
<-268,3.52488,493.033>, <-268,3.52488,596.366>, <-268,3.52488,1009.7>, <-268,3.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-268,3.52488,493.033>, <-268,3.52488,596.366>, <-268,3.52488,1009.7>, <-268,3.52488,1113.03>,
<-266.667,3.52488,493.033>, <-266.667,3.52488,596.366>, <-266.667,3.52488,1009.7>, <-266.667,3.52488,1113.03>,
<-261.333,3.52488,493.033>, <-261.333,3.52488,596.366>, <-261.333,3.52488,1009.7>, <-261.333,3.52488,1113.03>,
<-260,3.52488,493.033>, <-260,3.52488,596.366>, <-260,3.52488,1009.7>, <-260,3.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-260,3.52488,493.033>, <-260,3.52488,596.366>, <-260,3.52488,1009.7>, <-260,3.52488,1113.03>,
<-259.667,3.19155,493.033>, <-259.667,3.19155,596.366>, <-259.667,3.19155,1009.7>, <-259.667,3.19155,1113.03>,
<-258.333,1.85821,493.033>, <-258.333,1.85821,596.366>, <-258.333,1.85821,1009.7>, <-258.333,1.85821,1113.03>,
<-258,1.52488,493.033>, <-258,1.52488,596.366>, <-258,1.52488,1009.7>, <-258,1.52488,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-258,1.52488,493.033>, <-258,1.52488,596.366>, <-258,1.52488,1009.7>, <-258,1.52488,1113.03>,
<-258,0.858213,493.033>, <-258,0.858213,596.366>, <-258,0.858213,1009.7>, <-258,0.858213,1113.03>,
<-258,-1.80845,493.033>, <-258,-1.80845,596.366>, <-258,-1.80845,1009.7>, <-258,-1.80845,1113.03>,
<-258,-2.47512,493.033>, <-258,-2.47512,596.366>, <-258,-2.47512,1009.7>, <-258,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-258,-2.47512,493.033>, <-258,-2.47512,596.366>, <-258,-2.47512,1009.7>, <-258,-2.47512,1113.03>,
<-258.333,-2.80845,493.033>, <-258.333,-2.80845,596.366>, <-258.333,-2.80845,1009.7>, <-258.333,-2.80845,1113.03>,
<-259.667,-4.14179,493.033>, <-259.667,-4.14179,596.366>, <-259.667,-4.14179,1009.7>, <-259.667,-4.14179,1113.03>,
<-260,-4.47512,493.033>, <-260,-4.47512,596.366>, <-260,-4.47512,1009.7>, <-260,-4.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-260,-4.47512,493.033>, <-260,-4.47512,596.366>, <-260,-4.47512,1009.7>, <-260,-4.47512,1113.03>,
<-261.333,-4.47512,493.033>, <-261.333,-4.47512,596.366>, <-261.333,-4.47512,1009.7>, <-261.333,-4.47512,1113.03>,
<-266.667,-4.47512,493.033>, <-266.667,-4.47512,596.366>, <-266.667,-4.47512,1009.7>, <-266.667,-4.47512,1113.03>,
<-268,-4.47512,493.033>, <-268,-4.47512,596.366>, <-268,-4.47512,1009.7>, <-268,-4.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-268,-4.47512,493.033>, <-268,-4.47512,596.366>, <-268,-4.47512,1009.7>, <-268,-4.47512,1113.03>,
<-268.333,-4.14179,493.033>, <-268.333,-4.14179,596.366>, <-268.333,-4.14179,1009.7>, <-268.333,-4.14179,1113.03>,
<-269.667,-2.80845,493.033>, <-269.667,-2.80845,596.366>, <-269.667,-2.80845,1009.7>, <-269.667,-2.80845,1113.03>,
<-270,-2.47512,493.033>, <-270,-2.47512,596.366>, <-270,-2.47512,1009.7>, <-270,-2.47512,1113.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-158.5,4.52488,494.033>, <-158.5,2.85821,494.033>, <-158.5,-3.80845,494.033>, <-158.5,-5.47512,494.033>,
<-185.667,4.52488,494.033>, <-185.667,2.85821,494.033>, <-185.667,-3.80845,494.033>, <-185.667,-5.47512,494.033>,
<-294.333,4.52488,494.033>, <-294.333,2.85821,494.033>, <-294.333,-3.80845,494.033>, <-294.333,-5.47512,494.033>,
<-321.5,4.52488,494.033>, <-321.5,2.85821,494.033>, <-321.5,-3.80845,494.033>, <-321.5,-5.47512,494.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,4.52488,404.033>, <-321.5,4.52488,419.033>, <-321.5,4.52488,479.033>, <-321.5,4.52488,494.033>,
<-321.5,2.85821,404.033>, <-321.5,2.85821,419.033>, <-321.5,2.85821,479.033>, <-321.5,2.85821,494.033>,
<-321.5,-3.80845,404.033>, <-321.5,-3.80845,419.033>, <-321.5,-3.80845,479.033>, <-321.5,-3.80845,494.033>,
<-321.5,-5.47512,404.033>, <-321.5,-5.47512,419.033>, <-321.5,-5.47512,479.033>, <-321.5,-5.47512,494.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,4.52488,404.033>, <-321.5,2.85821,404.033>, <-321.5,-3.80845,404.033>, <-321.5,-5.47512,404.033>,
<-294.333,4.52488,404.033>, <-294.333,2.85821,404.033>, <-294.333,-3.80845,404.033>, <-294.333,-5.47512,404.033>,
<-185.667,4.52488,404.033>, <-185.667,2.85821,404.033>, <-185.667,-3.80845,404.033>, <-185.667,-5.47512,404.033>,
<-158.5,4.52488,404.033>, <-158.5,2.85821,404.033>, <-158.5,-3.80845,404.033>, <-158.5,-5.47512,404.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-158.5,4.52488,404.033>, <-158.5,2.85821,404.033>, <-158.5,-3.80845,404.033>, <-158.5,-5.47512,404.033>,
<-158.5,4.52488,419.033>, <-158.5,2.85821,419.033>, <-158.5,-3.80845,419.033>, <-158.5,-5.47512,419.033>,
<-158.5,4.52488,479.033>, <-158.5,2.85821,479.033>, <-158.5,-3.80845,479.033>, <-158.5,-5.47512,479.033>,
<-158.5,4.52488,494.033>, <-158.5,2.85821,494.033>, <-158.5,-3.80845,494.033>, <-158.5,-5.47512,494.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-155,9.52488,403.033>, <-155,6.19155,403.033>, <-155,-7.14177,403.033>, <-155,-10.4751,403.033>,
<-155,9.52488,536.366>, <-155,6.19155,536.366>, <-155,-7.14177,536.366>, <-155,-10.4751,536.366>,
<-155,9.52488,1069.7>, <-155,6.19155,1069.7>, <-155,-7.14177,1069.7>, <-155,-10.4751,1069.7>,
<-155,9.52488,1203.03>, <-155,6.19155,1203.03>, <-155,-7.14177,1203.03>, <-155,-10.4751,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-155,9.52488,403.033>, <-155,9.52488,536.366>, <-155,9.52488,1069.7>, <-155,9.52488,1203.03>,
<-154.167,10.3582,403.033>, <-154.167,10.3582,536.366>, <-154.167,10.3582,1069.7>, <-154.167,10.3582,1203.03>,
<-150.833,13.6916,403.033>, <-150.833,13.6916,536.366>, <-150.833,13.6916,1069.7>, <-150.833,13.6916,1203.03>,
<-150,14.5249,403.033>, <-150,14.5249,536.366>, <-150,14.5249,1069.7>, <-150,14.5249,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-155,9.52488,403.033>, <-154.167,10.3582,403.033>, <-150.833,13.6916,403.033>, <-150,14.5249,403.033>,
<-155,6.19155,403.033>, <-154.167,6.46933,403.033>, <-150.833,9.24712,403.033>, <-150,9.5249,403.033>,
<-155,-7.14177,403.033>, <-154.167,-7.41955,403.033>, <-150.833,-10.1973,403.033>, <-150,-10.4751,403.033>,
<-155,-10.4751,403.033>, <-154.167,-11.3084,403.033>, <-150.833,-14.6418,403.033>, <-150,-15.4751,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-150,14.5249,403.033>, <-146.667,14.5249,403.033>, <-133.333,14.5249,403.033>, <-130,14.5249,403.033>,
<-150,9.5249,403.033>, <-146.667,9.5249,403.033>, <-133.333,9.5249,403.033>, <-130,9.5249,403.033>,
<-150,-10.4751,403.033>, <-146.667,-10.4751,403.033>, <-133.333,-10.4751,403.033>, <-130,-10.4751,403.033>,
<-150,-15.4751,403.033>, <-146.667,-15.4751,403.033>, <-133.333,-15.4751,403.033>, <-130,-15.4751,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-150,14.5249,403.033>, <-150,14.5249,536.366>, <-150,14.5249,1069.7>, <-150,14.5249,1203.03>,
<-146.667,14.5249,403.033>, <-146.667,14.5249,536.366>, <-146.667,14.5249,1069.7>, <-146.667,14.5249,1203.03>,
<-133.333,14.5249,403.033>, <-133.333,14.5249,536.366>, <-133.333,14.5249,1069.7>, <-133.333,14.5249,1203.03>,
<-130,14.5249,403.033>, <-130,14.5249,536.366>, <-130,14.5249,1069.7>, <-130,14.5249,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-130,14.5249,403.033>, <-129.167,13.6916,403.033>, <-125.833,10.3582,403.033>, <-125,9.52488,403.033>,
<-130,9.5249,403.033>, <-129.167,9.24712,403.033>, <-125.833,6.46933,403.033>, <-125,6.19155,403.033>,
<-130,-10.4751,403.033>, <-129.167,-10.1973,403.033>, <-125.833,-7.41955,403.033>, <-125,-7.14177,403.033>,
<-130,-15.4751,403.033>, <-129.167,-14.6418,403.033>, <-125.833,-11.3084,403.033>, <-125,-10.4751,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-130,14.5249,403.033>, <-130,14.5249,536.366>, <-130,14.5249,1069.7>, <-130,14.5249,1203.03>,
<-129.167,13.6916,403.033>, <-129.167,13.6916,536.366>, <-129.167,13.6916,1069.7>, <-129.167,13.6916,1203.03>,
<-125.833,10.3582,403.033>, <-125.833,10.3582,536.366>, <-125.833,10.3582,1069.7>, <-125.833,10.3582,1203.03>,
<-125,9.52488,403.033>, <-125,9.52488,536.366>, <-125,9.52488,1069.7>, <-125,9.52488,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-125,9.52488,403.033>, <-125,9.52488,536.366>, <-125,9.52488,1069.7>, <-125,9.52488,1203.03>,
<-125,6.19155,403.033>, <-125,6.19155,536.366>, <-125,6.19155,1069.7>, <-125,6.19155,1203.03>,
<-125,-7.14177,403.033>, <-125,-7.14177,536.366>, <-125,-7.14177,1069.7>, <-125,-7.14177,1203.03>,
<-125,-10.4751,403.033>, <-125,-10.4751,536.366>, <-125,-10.4751,1069.7>, <-125,-10.4751,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-125,-10.4751,403.033>, <-125,-10.4751,536.366>, <-125,-10.4751,1069.7>, <-125,-10.4751,1203.03>,
<-125.833,-11.3084,403.033>, <-125.833,-11.3084,536.366>, <-125.833,-11.3084,1069.7>, <-125.833,-11.3084,1203.03>,
<-129.167,-14.6418,403.033>, <-129.167,-14.6418,536.366>, <-129.167,-14.6418,1069.7>, <-129.167,-14.6418,1203.03>,
<-130,-15.4751,403.033>, <-130,-15.4751,536.366>, <-130,-15.4751,1069.7>, <-130,-15.4751,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-130,-15.4751,403.033>, <-130,-15.4751,536.366>, <-130,-15.4751,1069.7>, <-130,-15.4751,1203.03>,
<-133.333,-15.4751,403.033>, <-133.333,-15.4751,536.366>, <-133.333,-15.4751,1069.7>, <-133.333,-15.4751,1203.03>,
<-146.667,-15.4751,403.033>, <-146.667,-15.4751,536.366>, <-146.667,-15.4751,1069.7>, <-146.667,-15.4751,1203.03>,
<-150,-15.4751,403.033>, <-150,-15.4751,536.366>, <-150,-15.4751,1069.7>, <-150,-15.4751,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-150,-15.4751,403.033>, <-150,-15.4751,536.366>, <-150,-15.4751,1069.7>, <-150,-15.4751,1203.03>,
<-150.833,-14.6418,403.033>, <-150.833,-14.6418,536.366>, <-150.833,-14.6418,1069.7>, <-150.833,-14.6418,1203.03>,
<-154.167,-11.3084,403.033>, <-154.167,-11.3084,536.366>, <-154.167,-11.3084,1069.7>, <-154.167,-11.3084,1203.03>,
<-155,-10.4751,403.033>, <-155,-10.4751,536.366>, <-155,-10.4751,1069.7>, <-155,-10.4751,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-350,-15.4751,1203.03>, <-350.833,-14.6418,1203.03>, <-354.167,-11.3084,1203.03>, <-355,-10.4751,1203.03>,
<-350,-10.4751,1203.03>, <-350.833,-10.1973,1203.03>, <-354.167,-7.41955,1203.03>, <-355,-7.14177,1203.03>,
<-350,9.5249,1203.03>, <-350.833,9.24712,1203.03>, <-354.167,6.46933,1203.03>, <-355,6.19155,1203.03>,
<-350,14.5249,1203.03>, <-350.833,13.6916,1203.03>, <-354.167,10.3582,1203.03>, <-355,9.52488,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-330,-15.4751,1203.03>, <-333.333,-15.4751,1203.03>, <-346.667,-15.4751,1203.03>, <-350,-15.4751,1203.03>,
<-330,-10.4751,1203.03>, <-333.333,-10.4751,1203.03>, <-346.667,-10.4751,1203.03>, <-350,-10.4751,1203.03>,
<-330,9.5249,1203.03>, <-333.333,9.5249,1203.03>, <-346.667,9.5249,1203.03>, <-350,9.5249,1203.03>,
<-330,14.5249,1203.03>, <-333.333,14.5249,1203.03>, <-346.667,14.5249,1203.03>, <-350,14.5249,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-325,9.52488,1203.03>, <-325,6.19155,1203.03>, <-325,-7.14177,1203.03>, <-325,-10.4751,1203.03>,
<-325.833,10.3582,1203.03>, <-325.833,6.46933,1203.03>, <-325.833,-7.41955,1203.03>, <-325.833,-11.3084,1203.03>,
<-329.167,13.6916,1203.03>, <-329.167,9.24712,1203.03>, <-329.167,-10.1973,1203.03>, <-329.167,-14.6418,1203.03>,
<-330,14.5249,1203.03>, <-330,9.5249,1203.03>, <-330,-10.4751,1203.03>, <-330,-15.4751,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-155,9.52488,1203.03>, <-155,6.19155,1203.03>, <-155,-7.14177,1203.03>, <-155,-10.4751,1203.03>,
<-154.167,10.3582,1203.03>, <-154.167,6.46933,1203.03>, <-154.167,-7.41955,1203.03>, <-154.167,-11.3084,1203.03>,
<-150.833,13.6916,1203.03>, <-150.833,9.24712,1203.03>, <-150.833,-10.1973,1203.03>, <-150.833,-14.6418,1203.03>,
<-150,14.5249,1203.03>, <-150,9.5249,1203.03>, <-150,-10.4751,1203.03>, <-150,-15.4751,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-130,-15.4751,1203.03>, <-130,-10.4751,1203.03>, <-130,9.5249,1203.03>, <-130,14.5249,1203.03>,
<-133.333,-15.4751,1203.03>, <-133.333,-10.4751,1203.03>, <-133.333,9.5249,1203.03>, <-133.333,14.5249,1203.03>,
<-146.667,-15.4751,1203.03>, <-146.667,-10.4751,1203.03>, <-146.667,9.5249,1203.03>, <-146.667,14.5249,1203.03>,
<-150,-15.4751,1203.03>, <-150,-10.4751,1203.03>, <-150,9.5249,1203.03>, <-150,14.5249,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-125,9.52488,1203.03>, <-125.833,10.3582,1203.03>, <-129.167,13.6916,1203.03>, <-130,14.5249,1203.03>,
<-125,6.19155,1203.03>, <-125.833,6.46933,1203.03>, <-129.167,9.24712,1203.03>, <-130,9.5249,1203.03>,
<-125,-7.14177,1203.03>, <-125.833,-7.41955,1203.03>, <-129.167,-10.1973,1203.03>, <-130,-10.4751,1203.03>,
<-125,-10.4751,1203.03>, <-125.833,-11.3084,1203.03>, <-129.167,-14.6418,1203.03>, <-130,-15.4751,1203.03>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-330,14.5249,400>, <-330,14.5249,266.667>, <-330,14.5249,-266.667>, <-330,14.5249,-400>,
<-333.333,14.5249,400>, <-333.333,14.5249,266.667>, <-333.333,14.5249,-266.667>, <-333.333,14.5249,-400>,
<-346.667,14.5249,400>, <-346.667,14.5249,266.667>, <-346.667,14.5249,-266.667>, <-346.667,14.5249,-400>,
<-350,14.5249,400>, <-350,14.5249,266.667>, <-350,14.5249,-266.667>, <-350,14.5249,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-330,14.5249,400>, <-329.167,13.6916,400>, <-325.833,10.3582,400>, <-325,9.52488,400>,
<-330,14.5249,266.667>, <-329.167,13.6916,266.667>, <-325.833,10.3582,266.667>, <-325,9.52488,266.667>,
<-330,14.5249,-266.667>, <-329.167,13.6916,-266.667>, <-325.833,10.3582,-266.667>, <-325,9.52488,-266.667>,
<-330,14.5249,-400>, <-329.167,13.6916,-400>, <-325.833,10.3582,-400>, <-325,9.52488,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-330,14.5249,400>, <-330,9.5249,400>, <-330,-10.4751,400>, <-330,-15.4751,400>,
<-329.167,13.6916,400>, <-329.167,9.24712,400>, <-329.167,-10.1973,400>, <-329.167,-14.6418,400>,
<-325.833,10.3582,400>, <-325.833,6.46933,400>, <-325.833,-7.41955,400>, <-325.833,-11.3084,400>,
<-325,9.52488,400>, <-325,6.19155,400>, <-325,-7.14177,400>, <-325,-10.4751,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-330,14.5249,400>, <-333.333,14.5249,400>, <-346.667,14.5249,400>, <-350,14.5249,400>,
<-330,9.5249,400>, <-333.333,9.5249,400>, <-346.667,9.5249,400>, <-350,9.5249,400>,
<-330,-10.4751,400>, <-333.333,-10.4751,400>, <-346.667,-10.4751,400>, <-350,-10.4751,400>,
<-330,-15.4751,400>, <-333.333,-15.4751,400>, <-346.667,-15.4751,400>, <-350,-15.4751,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-325,-10.4751,400>, <-325.833,-11.3084,400>, <-329.167,-14.6418,400>, <-330,-15.4751,400>,
<-325,-10.4751,266.667>, <-325.833,-11.3084,266.667>, <-329.167,-14.6418,266.667>, <-330,-15.4751,266.667>,
<-325,-10.4751,-266.667>, <-325.833,-11.3084,-266.667>, <-329.167,-14.6418,-266.667>, <-330,-15.4751,-266.667>,
<-325,-10.4751,-400>, <-325.833,-11.3084,-400>, <-329.167,-14.6418,-400>, <-330,-15.4751,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-330,-15.4751,400>, <-333.333,-15.4751,400>, <-346.667,-15.4751,400>, <-350,-15.4751,400>,
<-330,-15.4751,266.667>, <-333.333,-15.4751,266.667>, <-346.667,-15.4751,266.667>, <-350,-15.4751,266.667>,
<-330,-15.4751,-266.667>, <-333.333,-15.4751,-266.667>, <-346.667,-15.4751,-266.667>, <-350,-15.4751,-266.667>,
<-330,-15.4751,-400>, <-333.333,-15.4751,-400>, <-346.667,-15.4751,-400>, <-350,-15.4751,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-350,14.5249,-400>, <-346.667,14.5249,-400>, <-333.333,14.5249,-400>, <-330,14.5249,-400>,
<-350,9.5249,-400>, <-346.667,9.5249,-400>, <-333.333,9.5249,-400>, <-330,9.5249,-400>,
<-350,-10.4751,-400>, <-346.667,-10.4751,-400>, <-333.333,-10.4751,-400>, <-330,-10.4751,-400>,
<-350,-15.4751,-400>, <-346.667,-15.4751,-400>, <-333.333,-15.4751,-400>, <-330,-15.4751,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-330,14.5249,-400>, <-329.167,13.6916,-400>, <-325.833,10.3582,-400>, <-325,9.52488,-400>,
<-330,9.5249,-400>, <-329.167,9.24712,-400>, <-325.833,6.46933,-400>, <-325,6.19155,-400>,
<-330,-10.4751,-400>, <-329.167,-10.1973,-400>, <-325.833,-7.41955,-400>, <-325,-7.14177,-400>,
<-330,-15.4751,-400>, <-329.167,-14.6418,-400>, <-325.833,-11.3084,-400>, <-325,-10.4751,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-350,14.5249,400>, <-350,14.5249,266.667>, <-350,14.5249,-266.667>, <-350,14.5249,-400>,
<-350.833,13.6916,400>, <-350.833,13.6916,266.667>, <-350.833,13.6916,-266.667>, <-350.833,13.6916,-400>,
<-354.167,10.3582,400>, <-354.167,10.3582,266.667>, <-354.167,10.3582,-266.667>, <-354.167,10.3582,-400>,
<-355,9.52488,400>, <-355,9.52488,266.667>, <-355,9.52488,-266.667>, <-355,9.52488,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-350,14.5249,400>, <-350.833,13.6916,400>, <-354.167,10.3582,400>, <-355,9.52488,400>,
<-350,9.5249,400>, <-350.833,9.24712,400>, <-354.167,6.46933,400>, <-355,6.19155,400>,
<-350,-10.4751,400>, <-350.833,-10.1973,400>, <-354.167,-7.41955,400>, <-355,-7.14177,400>,
<-350,-15.4751,400>, <-350.833,-14.6418,400>, <-354.167,-11.3084,400>, <-355,-10.4751,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-350,-15.4751,400>, <-350.833,-14.6418,400>, <-354.167,-11.3084,400>, <-355,-10.4751,400>,
<-350,-15.4751,266.667>, <-350.833,-14.6418,266.667>, <-354.167,-11.3084,266.667>, <-355,-10.4751,266.667>,
<-350,-15.4751,-266.667>, <-350.833,-14.6418,-266.667>, <-354.167,-11.3084,-266.667>, <-355,-10.4751,-266.667>,
<-350,-15.4751,-400>, <-350.833,-14.6418,-400>, <-354.167,-11.3084,-400>, <-355,-10.4751,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-350,14.5249,-400>, <-350,9.5249,-400>, <-350,-10.4751,-400>, <-350,-15.4751,-400>,
<-350.833,13.6916,-400>, <-350.833,9.24712,-400>, <-350.833,-10.1973,-400>, <-350.833,-14.6418,-400>,
<-354.167,10.3582,-400>, <-354.167,6.46933,-400>, <-354.167,-7.41955,-400>, <-354.167,-11.3084,-400>,
<-355,9.52488,-400>, <-355,6.19155,-400>, <-355,-7.14177,-400>, <-355,-10.4751,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-130,14.5249,400>, <-130,14.5249,266.667>, <-130,14.5249,-266.667>, <-130,14.5249,-400>,
<-133.333,14.5249,400>, <-133.333,14.5249,266.667>, <-133.333,14.5249,-266.667>, <-133.333,14.5249,-400>,
<-146.667,14.5249,400>, <-146.667,14.5249,266.667>, <-146.667,14.5249,-266.667>, <-146.667,14.5249,-400>,
<-150,14.5249,400>, <-150,14.5249,266.667>, <-150,14.5249,-266.667>, <-150,14.5249,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-130,14.5249,400>, <-129.167,13.6916,400>, <-125.833,10.3582,400>, <-125,9.52488,400>,
<-130,14.5249,266.667>, <-129.167,13.6916,266.667>, <-125.833,10.3582,266.667>, <-125,9.52488,266.667>,
<-130,14.5249,-266.667>, <-129.167,13.6916,-266.667>, <-125.833,10.3582,-266.667>, <-125,9.52488,-266.667>,
<-130,14.5249,-400>, <-129.167,13.6916,-400>, <-125.833,10.3582,-400>, <-125,9.52488,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-130,14.5249,400>, <-130,9.5249,400>, <-130,-10.4751,400>, <-130,-15.4751,400>,
<-129.167,13.6916,400>, <-129.167,9.24712,400>, <-129.167,-10.1973,400>, <-129.167,-14.6418,400>,
<-125.833,10.3582,400>, <-125.833,6.46933,400>, <-125.833,-7.41955,400>, <-125.833,-11.3084,400>,
<-125,9.52488,400>, <-125,6.19155,400>, <-125,-7.14177,400>, <-125,-10.4751,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-130,14.5249,400>, <-133.333,14.5249,400>, <-146.667,14.5249,400>, <-150,14.5249,400>,
<-130,9.5249,400>, <-133.333,9.5249,400>, <-146.667,9.5249,400>, <-150,9.5249,400>,
<-130,-10.4751,400>, <-133.333,-10.4751,400>, <-146.667,-10.4751,400>, <-150,-10.4751,400>,
<-130,-15.4751,400>, <-133.333,-15.4751,400>, <-146.667,-15.4751,400>, <-150,-15.4751,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-125,-10.4751,400>, <-125.833,-11.3084,400>, <-129.167,-14.6418,400>, <-130,-15.4751,400>,
<-125,-10.4751,266.667>, <-125.833,-11.3084,266.667>, <-129.167,-14.6418,266.667>, <-130,-15.4751,266.667>,
<-125,-10.4751,-266.667>, <-125.833,-11.3084,-266.667>, <-129.167,-14.6418,-266.667>, <-130,-15.4751,-266.667>,
<-125,-10.4751,-400>, <-125.833,-11.3084,-400>, <-129.167,-14.6418,-400>, <-130,-15.4751,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-130,-15.4751,400>, <-133.333,-15.4751,400>, <-146.667,-15.4751,400>, <-150,-15.4751,400>,
<-130,-15.4751,266.667>, <-133.333,-15.4751,266.667>, <-146.667,-15.4751,266.667>, <-150,-15.4751,266.667>,
<-130,-15.4751,-266.667>, <-133.333,-15.4751,-266.667>, <-146.667,-15.4751,-266.667>, <-150,-15.4751,-266.667>,
<-130,-15.4751,-400>, <-133.333,-15.4751,-400>, <-146.667,-15.4751,-400>, <-150,-15.4751,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-150,14.5249,-400>, <-146.667,14.5249,-400>, <-133.333,14.5249,-400>, <-130,14.5249,-400>,
<-150,9.5249,-400>, <-146.667,9.5249,-400>, <-133.333,9.5249,-400>, <-130,9.5249,-400>,
<-150,-10.4751,-400>, <-146.667,-10.4751,-400>, <-133.333,-10.4751,-400>, <-130,-10.4751,-400>,
<-150,-15.4751,-400>, <-146.667,-15.4751,-400>, <-133.333,-15.4751,-400>, <-130,-15.4751,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-130,14.5249,-400>, <-129.167,13.6916,-400>, <-125.833,10.3582,-400>, <-125,9.52488,-400>,
<-130,9.5249,-400>, <-129.167,9.24712,-400>, <-125.833,6.46933,-400>, <-125,6.19155,-400>,
<-130,-10.4751,-400>, <-129.167,-10.1973,-400>, <-125.833,-7.41955,-400>, <-125,-7.14177,-400>,
<-130,-15.4751,-400>, <-129.167,-14.6418,-400>, <-125.833,-11.3084,-400>, <-125,-10.4751,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-150,14.5249,400>, <-150,14.5249,266.667>, <-150,14.5249,-266.667>, <-150,14.5249,-400>,
<-150.833,13.6916,400>, <-150.833,13.6916,266.667>, <-150.833,13.6916,-266.667>, <-150.833,13.6916,-400>,
<-154.167,10.3582,400>, <-154.167,10.3582,266.667>, <-154.167,10.3582,-266.667>, <-154.167,10.3582,-400>,
<-155,9.52488,400>, <-155,9.52488,266.667>, <-155,9.52488,-266.667>, <-155,9.52488,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-150,14.5249,400>, <-150.833,13.6916,400>, <-154.167,10.3582,400>, <-155,9.52488,400>,
<-150,9.5249,400>, <-150.833,9.24712,400>, <-154.167,6.46933,400>, <-155,6.19155,400>,
<-150,-10.4751,400>, <-150.833,-10.1973,400>, <-154.167,-7.41955,400>, <-155,-7.14177,400>,
<-150,-15.4751,400>, <-150.833,-14.6418,400>, <-154.167,-11.3084,400>, <-155,-10.4751,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-150,-15.4751,400>, <-150.833,-14.6418,400>, <-154.167,-11.3084,400>, <-155,-10.4751,400>,
<-150,-15.4751,266.667>, <-150.833,-14.6418,266.667>, <-154.167,-11.3084,266.667>, <-155,-10.4751,266.667>,
<-150,-15.4751,-266.667>, <-150.833,-14.6418,-266.667>, <-154.167,-11.3084,-266.667>, <-155,-10.4751,-266.667>,
<-150,-15.4751,-400>, <-150.833,-14.6418,-400>, <-154.167,-11.3084,-400>, <-155,-10.4751,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-155,9.52488,-400>, <-154.167,10.3582,-400>, <-150.833,13.6916,-400>, <-150,14.5249,-400>,
<-155,6.19155,-400>, <-154.167,6.46933,-400>, <-150.833,9.24712,-400>, <-150,9.5249,-400>,
<-155,-7.14177,-400>, <-154.167,-7.41955,-400>, <-150.833,-10.1973,-400>, <-150,-10.4751,-400>,
<-155,-10.4751,-400>, <-154.167,-11.3084,-400>, <-150.833,-14.6418,-400>, <-150,-15.4751,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-155,9.52488,400>, <-155,9.52488,266.667>, <-155,9.52488,-266.667>, <-155,9.52488,-400>,
<-155,6.19155,400>, <-155,6.19155,266.667>, <-155,6.19155,-266.667>, <-155,6.19155,-400>,
<-155,-7.14177,400>, <-155,-7.14177,266.667>, <-155,-7.14177,-266.667>, <-155,-7.14177,-400>,
<-155,-10.4751,400>, <-155,-10.4751,266.667>, <-155,-10.4751,-266.667>, <-155,-10.4751,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-125,9.52488,400>, <-125,6.19155,400>, <-125,-7.14177,400>, <-125,-10.4751,400>,
<-125,9.52488,266.667>, <-125,6.19155,266.667>, <-125,-7.14177,266.667>, <-125,-10.4751,266.667>,
<-125,9.52488,-266.667>, <-125,6.19155,-266.667>, <-125,-7.14177,-266.667>, <-125,-10.4751,-266.667>,
<-125,9.52488,-400>, <-125,6.19155,-400>, <-125,-7.14177,-400>, <-125,-10.4751,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-355,-10.4751,400>, <-355,-7.14177,400>, <-355,6.19155,400>, <-355,9.52488,400>,
<-355,-10.4751,266.667>, <-355,-7.14177,266.667>, <-355,6.19155,266.667>, <-355,9.52488,266.667>,
<-355,-10.4751,-266.667>, <-355,-7.14177,-266.667>, <-355,6.19155,-266.667>, <-355,9.52488,-266.667>,
<-355,-10.4751,-400>, <-355,-7.14177,-400>, <-355,6.19155,-400>, <-355,9.52488,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-325,9.52488,400>, <-325,6.19155,400>, <-325,-7.14177,400>, <-325,-10.4751,400>,
<-325,9.52488,266.667>, <-325,6.19155,266.667>, <-325,-7.14177,266.667>, <-325,-10.4751,266.667>,
<-325,9.52488,-266.667>, <-325,6.19155,-266.667>, <-325,-7.14177,-266.667>, <-325,-10.4751,-266.667>,
<-325,9.52488,-400>, <-325,6.19155,-400>, <-325,-7.14177,-400>, <-325,-10.4751,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,4.52488,-309>, <-294.333,4.52488,-309>, <-185.667,4.52488,-309>, <-158.5,4.52488,-309>,
<-321.5,2.85821,-309>, <-294.333,2.85821,-309>, <-185.667,2.85821,-309>, <-158.5,2.85821,-309>,
<-321.5,-3.80845,-309>, <-294.333,-3.80845,-309>, <-185.667,-3.80845,-309>, <-158.5,-3.80845,-309>,
<-321.5,-5.47512,-309>, <-294.333,-5.47512,-309>, <-185.667,-5.47512,-309>, <-158.5,-5.47512,-309>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,4.52488,-309>, <-321.5,2.85821,-309>, <-321.5,-3.80845,-309>, <-321.5,-5.47512,-309>,
<-321.5,4.52488,-324>, <-321.5,2.85821,-324>, <-321.5,-3.80845,-324>, <-321.5,-5.47512,-324>,
<-321.5,4.52488,-384>, <-321.5,2.85821,-384>, <-321.5,-3.80845,-384>, <-321.5,-5.47512,-384>,
<-321.5,4.52488,-399>, <-321.5,2.85821,-399>, <-321.5,-3.80845,-399>, <-321.5,-5.47512,-399>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,-5.47512,-399>, <-294.333,-5.47512,-399>, <-185.667,-5.47512,-399>, <-158.5,-5.47512,-399>,
<-321.5,-3.80845,-399>, <-294.333,-3.80845,-399>, <-185.667,-3.80845,-399>, <-158.5,-3.80845,-399>,
<-321.5,2.85821,-399>, <-294.333,2.85821,-399>, <-185.667,2.85821,-399>, <-158.5,2.85821,-399>,
<-321.5,4.52488,-399>, <-294.333,4.52488,-399>, <-185.667,4.52488,-399>, <-158.5,4.52488,-399>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-158.5,-5.47512,-399>, <-158.5,-5.47512,-384>, <-158.5,-5.47512,-324>, <-158.5,-5.47512,-309>,
<-158.5,-3.80845,-399>, <-158.5,-3.80845,-384>, <-158.5,-3.80845,-324>, <-158.5,-3.80845,-309>,
<-158.5,2.85821,-399>, <-158.5,2.85821,-384>, <-158.5,2.85821,-324>, <-158.5,2.85821,-309>,
<-158.5,4.52488,-399>, <-158.5,4.52488,-384>, <-158.5,4.52488,-324>, <-158.5,4.52488,-309>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,-5.47512,399>, <-294.333,-5.47512,399>, <-185.667,-5.47512,399>, <-158.5,-5.47512,399>,
<-321.5,-3.80845,399>, <-294.333,-3.80845,399>, <-185.667,-3.80845,399>, <-158.5,-3.80845,399>,
<-321.5,2.85821,399>, <-294.333,2.85821,399>, <-185.667,2.85821,399>, <-158.5,2.85821,399>,
<-321.5,4.52488,399>, <-294.333,4.52488,399>, <-185.667,4.52488,399>, <-158.5,4.52488,399>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,-5.47512,399>, <-321.5,-3.80845,399>, <-321.5,2.85821,399>, <-321.5,4.52488,399>,
<-321.5,-5.47512,384>, <-321.5,-3.80845,384>, <-321.5,2.85821,384>, <-321.5,4.52488,384>,
<-321.5,-5.47512,324>, <-321.5,-3.80845,324>, <-321.5,2.85821,324>, <-321.5,4.52488,324>,
<-321.5,-5.47512,309>, <-321.5,-3.80845,309>, <-321.5,2.85821,309>, <-321.5,4.52488,309>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-321.5,-5.47512,309>, <-321.5,-3.80845,309>, <-321.5,2.85821,309>, <-321.5,4.52488,309>,
<-294.333,-5.47512,309>, <-294.333,-3.80845,309>, <-294.333,2.85821,309>, <-294.333,4.52488,309>,
<-185.667,-5.47512,309>, <-185.667,-3.80845,309>, <-185.667,2.85821,309>, <-185.667,4.52488,309>,
<-158.5,-5.47512,309>, <-158.5,-3.80845,309>, <-158.5,2.85821,309>, <-158.5,4.52488,309>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-158.5,-5.47512,309>, <-158.5,-3.80845,309>, <-158.5,2.85821,309>, <-158.5,4.52488,309>,
<-158.5,-5.47512,324>, <-158.5,-3.80845,324>, <-158.5,2.85821,324>, <-158.5,4.52488,324>,
<-158.5,-5.47512,384>, <-158.5,-3.80845,384>, <-158.5,2.85821,384>, <-158.5,4.52488,384>,
<-158.5,-5.47512,399>, <-158.5,-3.80845,399>, <-158.5,2.85821,399>, <-158.5,4.52488,399>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-268,-4.47512,310>, <-268.333,-4.14179,310>, <-269.667,-2.80845,310>, <-270,-2.47512,310>,
<-268,-4.47512,206.667>, <-268.333,-4.14179,206.667>, <-269.667,-2.80845,206.667>, <-270,-2.47512,206.667>,
<-268,-4.47512,-206.667>, <-268.333,-4.14179,-206.667>, <-269.667,-2.80845,-206.667>, <-270,-2.47512,-206.667>,
<-268,-4.47512,-310>, <-268.333,-4.14179,-310>, <-269.667,-2.80845,-310>, <-270,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-270,1.52488,310>, <-270,1.52488,206.667>, <-270,1.52488,-206.667>, <-270,1.52488,-310>,
<-270,0.858213,310>, <-270,0.858213,206.667>, <-270,0.858213,-206.667>, <-270,0.858213,-310>,
<-270,-1.80845,310>, <-270,-1.80845,206.667>, <-270,-1.80845,-206.667>, <-270,-1.80845,-310>,
<-270,-2.47512,310>, <-270,-2.47512,206.667>, <-270,-2.47512,-206.667>, <-270,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-260,-4.47512,310>, <-261.333,-4.47512,310>, <-266.667,-4.47512,310>, <-268,-4.47512,310>,
<-260,-4.47512,206.667>, <-261.333,-4.47512,206.667>, <-266.667,-4.47512,206.667>, <-268,-4.47512,206.667>,
<-260,-4.47512,-206.667>, <-261.333,-4.47512,-206.667>, <-266.667,-4.47512,-206.667>, <-268,-4.47512,-206.667>,
<-260,-4.47512,-310>, <-261.333,-4.47512,-310>, <-266.667,-4.47512,-310>, <-268,-4.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-258,-2.47512,310>, <-258.333,-2.80845,310>, <-259.667,-4.14179,310>, <-260,-4.47512,310>,
<-258,-2.47512,206.667>, <-258.333,-2.80845,206.667>, <-259.667,-4.14179,206.667>, <-260,-4.47512,206.667>,
<-258,-2.47512,-206.667>, <-258.333,-2.80845,-206.667>, <-259.667,-4.14179,-206.667>, <-260,-4.47512,-206.667>,
<-258,-2.47512,-310>, <-258.333,-2.80845,-310>, <-259.667,-4.14179,-310>, <-260,-4.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-258,1.52488,310>, <-258,0.858213,310>, <-258,-1.80845,310>, <-258,-2.47512,310>,
<-258,1.52488,206.667>, <-258,0.858213,206.667>, <-258,-1.80845,206.667>, <-258,-2.47512,206.667>,
<-258,1.52488,-206.667>, <-258,0.858213,-206.667>, <-258,-1.80845,-206.667>, <-258,-2.47512,-206.667>,
<-258,1.52488,-310>, <-258,0.858213,-310>, <-258,-1.80845,-310>, <-258,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-260,3.52488,310>, <-259.667,3.19155,310>, <-258.333,1.85821,310>, <-258,1.52488,310>,
<-260,3.52488,206.667>, <-259.667,3.19155,206.667>, <-258.333,1.85821,206.667>, <-258,1.52488,206.667>,
<-260,3.52488,-206.667>, <-259.667,3.19155,-206.667>, <-258.333,1.85821,-206.667>, <-258,1.52488,-206.667>,
<-260,3.52488,-310>, <-259.667,3.19155,-310>, <-258.333,1.85821,-310>, <-258,1.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-268,3.52488,310>, <-266.667,3.52488,310>, <-261.333,3.52488,310>, <-260,3.52488,310>,
<-268,3.52488,206.667>, <-266.667,3.52488,206.667>, <-261.333,3.52488,206.667>, <-260,3.52488,206.667>,
<-268,3.52488,-206.667>, <-266.667,3.52488,-206.667>, <-261.333,3.52488,-206.667>, <-260,3.52488,-206.667>,
<-268,3.52488,-310>, <-266.667,3.52488,-310>, <-261.333,3.52488,-310>, <-260,3.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-270,1.52488,310>, <-269.667,1.85821,310>, <-268.333,3.19155,310>, <-268,3.52488,310>,
<-270,1.52488,206.667>, <-269.667,1.85821,206.667>, <-268.333,3.19155,206.667>, <-268,3.52488,206.667>,
<-270,1.52488,-206.667>, <-269.667,1.85821,-206.667>, <-268.333,3.19155,-206.667>, <-268,3.52488,-206.667>,
<-270,1.52488,-310>, <-269.667,1.85821,-310>, <-268.333,3.19155,-310>, <-268,3.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-300,-4.47512,310>, <-300.333,-4.14179,310>, <-301.667,-2.80845,310>, <-302,-2.47512,310>,
<-300,-4.47512,206.667>, <-300.333,-4.14179,206.667>, <-301.667,-2.80845,206.667>, <-302,-2.47512,206.667>,
<-300,-4.47512,-206.667>, <-300.333,-4.14179,-206.667>, <-301.667,-2.80845,-206.667>, <-302,-2.47512,-206.667>,
<-300,-4.47512,-310>, <-300.333,-4.14179,-310>, <-301.667,-2.80845,-310>, <-302,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-302,1.52488,310>, <-302,1.52488,206.667>, <-302,1.52488,-206.667>, <-302,1.52488,-310>,
<-302,0.858213,310>, <-302,0.858213,206.667>, <-302,0.858213,-206.667>, <-302,0.858213,-310>,
<-302,-1.80845,310>, <-302,-1.80845,206.667>, <-302,-1.80845,-206.667>, <-302,-1.80845,-310>,
<-302,-2.47512,310>, <-302,-2.47512,206.667>, <-302,-2.47512,-206.667>, <-302,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-292,-4.47512,310>, <-293.333,-4.47512,310>, <-298.667,-4.47512,310>, <-300,-4.47512,310>,
<-292,-4.47512,206.667>, <-293.333,-4.47512,206.667>, <-298.667,-4.47512,206.667>, <-300,-4.47512,206.667>,
<-292,-4.47512,-206.667>, <-293.333,-4.47512,-206.667>, <-298.667,-4.47512,-206.667>, <-300,-4.47512,-206.667>,
<-292,-4.47512,-310>, <-293.333,-4.47512,-310>, <-298.667,-4.47512,-310>, <-300,-4.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-290,-2.47512,310>, <-290.333,-2.80845,310>, <-291.667,-4.14179,310>, <-292,-4.47512,310>,
<-290,-2.47512,206.667>, <-290.333,-2.80845,206.667>, <-291.667,-4.14179,206.667>, <-292,-4.47512,206.667>,
<-290,-2.47512,-206.667>, <-290.333,-2.80845,-206.667>, <-291.667,-4.14179,-206.667>, <-292,-4.47512,-206.667>,
<-290,-2.47512,-310>, <-290.333,-2.80845,-310>, <-291.667,-4.14179,-310>, <-292,-4.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-290,1.52488,310>, <-290,0.858213,310>, <-290,-1.80845,310>, <-290,-2.47512,310>,
<-290,1.52488,206.667>, <-290,0.858213,206.667>, <-290,-1.80845,206.667>, <-290,-2.47512,206.667>,
<-290,1.52488,-206.667>, <-290,0.858213,-206.667>, <-290,-1.80845,-206.667>, <-290,-2.47512,-206.667>,
<-290,1.52488,-310>, <-290,0.858213,-310>, <-290,-1.80845,-310>, <-290,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-292,3.52488,310>, <-291.667,3.19155,310>, <-290.333,1.85821,310>, <-290,1.52488,310>,
<-292,3.52488,206.667>, <-291.667,3.19155,206.667>, <-290.333,1.85821,206.667>, <-290,1.52488,206.667>,
<-292,3.52488,-206.667>, <-291.667,3.19155,-206.667>, <-290.333,1.85821,-206.667>, <-290,1.52488,-206.667>,
<-292,3.52488,-310>, <-291.667,3.19155,-310>, <-290.333,1.85821,-310>, <-290,1.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-300,3.52488,310>, <-298.667,3.52488,310>, <-293.333,3.52488,310>, <-292,3.52488,310>,
<-300,3.52488,206.667>, <-298.667,3.52488,206.667>, <-293.333,3.52488,206.667>, <-292,3.52488,206.667>,
<-300,3.52488,-206.667>, <-298.667,3.52488,-206.667>, <-293.333,3.52488,-206.667>, <-292,3.52488,-206.667>,
<-300,3.52488,-310>, <-298.667,3.52488,-310>, <-293.333,3.52488,-310>, <-292,3.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-302,1.52488,310>, <-301.667,1.85821,310>, <-300.333,3.19155,310>, <-300,3.52488,310>,
<-302,1.52488,206.667>, <-301.667,1.85821,206.667>, <-300.333,3.19155,206.667>, <-300,3.52488,206.667>,
<-302,1.52488,-206.667>, <-301.667,1.85821,-206.667>, <-300.333,3.19155,-206.667>, <-300,3.52488,-206.667>,
<-302,1.52488,-310>, <-301.667,1.85821,-310>, <-300.333,3.19155,-310>, <-300,3.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-252,-4.47512,310>, <-252.333,-4.14179,310>, <-253.667,-2.80845,310>, <-254,-2.47512,310>,
<-252,-4.47512,206.667>, <-252.333,-4.14179,206.667>, <-253.667,-2.80845,206.667>, <-254,-2.47512,206.667>,
<-252,-4.47512,-206.667>, <-252.333,-4.14179,-206.667>, <-253.667,-2.80845,-206.667>, <-254,-2.47512,-206.667>,
<-252,-4.47512,-310>, <-252.333,-4.14179,-310>, <-253.667,-2.80845,-310>, <-254,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-254,1.52488,310>, <-254,1.52488,206.667>, <-254,1.52488,-206.667>, <-254,1.52488,-310>,
<-254,0.858213,310>, <-254,0.858213,206.667>, <-254,0.858213,-206.667>, <-254,0.858213,-310>,
<-254,-1.80845,310>, <-254,-1.80845,206.667>, <-254,-1.80845,-206.667>, <-254,-1.80845,-310>,
<-254,-2.47512,310>, <-254,-2.47512,206.667>, <-254,-2.47512,-206.667>, <-254,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-244,-4.47512,310>, <-245.333,-4.47512,310>, <-250.667,-4.47512,310>, <-252,-4.47512,310>,
<-244,-4.47512,206.667>, <-245.333,-4.47512,206.667>, <-250.667,-4.47512,206.667>, <-252,-4.47512,206.667>,
<-244,-4.47512,-206.667>, <-245.333,-4.47512,-206.667>, <-250.667,-4.47512,-206.667>, <-252,-4.47512,-206.667>,
<-244,-4.47512,-310>, <-245.333,-4.47512,-310>, <-250.667,-4.47512,-310>, <-252,-4.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-242,-2.47512,310>, <-242.333,-2.80845,310>, <-243.667,-4.14179,310>, <-244,-4.47512,310>,
<-242,-2.47512,206.667>, <-242.333,-2.80845,206.667>, <-243.667,-4.14179,206.667>, <-244,-4.47512,206.667>,
<-242,-2.47512,-206.667>, <-242.333,-2.80845,-206.667>, <-243.667,-4.14179,-206.667>, <-244,-4.47512,-206.667>,
<-242,-2.47512,-310>, <-242.333,-2.80845,-310>, <-243.667,-4.14179,-310>, <-244,-4.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-242,1.52488,310>, <-242,0.858213,310>, <-242,-1.80845,310>, <-242,-2.47512,310>,
<-242,1.52488,206.667>, <-242,0.858213,206.667>, <-242,-1.80845,206.667>, <-242,-2.47512,206.667>,
<-242,1.52488,-206.667>, <-242,0.858213,-206.667>, <-242,-1.80845,-206.667>, <-242,-2.47512,-206.667>,
<-242,1.52488,-310>, <-242,0.858213,-310>, <-242,-1.80845,-310>, <-242,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-244,3.52488,310>, <-243.667,3.19155,310>, <-242.333,1.85821,310>, <-242,1.52488,310>,
<-244,3.52488,206.667>, <-243.667,3.19155,206.667>, <-242.333,1.85821,206.667>, <-242,1.52488,206.667>,
<-244,3.52488,-206.667>, <-243.667,3.19155,-206.667>, <-242.333,1.85821,-206.667>, <-242,1.52488,-206.667>,
<-244,3.52488,-310>, <-243.667,3.19155,-310>, <-242.333,1.85821,-310>, <-242,1.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-252,3.52488,310>, <-250.667,3.52488,310>, <-245.333,3.52488,310>, <-244,3.52488,310>,
<-252,3.52488,206.667>, <-250.667,3.52488,206.667>, <-245.333,3.52488,206.667>, <-244,3.52488,206.667>,
<-252,3.52488,-206.667>, <-250.667,3.52488,-206.667>, <-245.333,3.52488,-206.667>, <-244,3.52488,-206.667>,
<-252,3.52488,-310>, <-250.667,3.52488,-310>, <-245.333,3.52488,-310>, <-244,3.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-254,1.52488,310>, <-253.667,1.85821,310>, <-252.333,3.19155,310>, <-252,3.52488,310>,
<-254,1.52488,206.667>, <-253.667,1.85821,206.667>, <-252.333,3.19155,206.667>, <-252,3.52488,206.667>,
<-254,1.52488,-206.667>, <-253.667,1.85821,-206.667>, <-252.333,3.19155,-206.667>, <-252,3.52488,-206.667>,
<-254,1.52488,-310>, <-253.667,1.85821,-310>, <-252.333,3.19155,-310>, <-252,3.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-316,-4.47512,310>, <-316.333,-4.14179,310>, <-317.667,-2.80845,310>, <-318,-2.47512,310>,
<-316,-4.47512,206.667>, <-316.333,-4.14179,206.667>, <-317.667,-2.80845,206.667>, <-318,-2.47512,206.667>,
<-316,-4.47512,-206.667>, <-316.333,-4.14179,-206.667>, <-317.667,-2.80845,-206.667>, <-318,-2.47512,-206.667>,
<-316,-4.47512,-310>, <-316.333,-4.14179,-310>, <-317.667,-2.80845,-310>, <-318,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-318,1.52488,310>, <-318,1.52488,206.667>, <-318,1.52488,-206.667>, <-318,1.52488,-310>,
<-318,0.858213,310>, <-318,0.858213,206.667>, <-318,0.858213,-206.667>, <-318,0.858213,-310>,
<-318,-1.80845,310>, <-318,-1.80845,206.667>, <-318,-1.80845,-206.667>, <-318,-1.80845,-310>,
<-318,-2.47512,310>, <-318,-2.47512,206.667>, <-318,-2.47512,-206.667>, <-318,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-308,-4.47512,310>, <-309.333,-4.47512,310>, <-314.667,-4.47512,310>, <-316,-4.47512,310>,
<-308,-4.47512,206.667>, <-309.333,-4.47512,206.667>, <-314.667,-4.47512,206.667>, <-316,-4.47512,206.667>,
<-308,-4.47512,-206.667>, <-309.333,-4.47512,-206.667>, <-314.667,-4.47512,-206.667>, <-316,-4.47512,-206.667>,
<-308,-4.47512,-310>, <-309.333,-4.47512,-310>, <-314.667,-4.47512,-310>, <-316,-4.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-306,-2.47512,310>, <-306.333,-2.80845,310>, <-307.667,-4.14179,310>, <-308,-4.47512,310>,
<-306,-2.47512,206.667>, <-306.333,-2.80845,206.667>, <-307.667,-4.14179,206.667>, <-308,-4.47512,206.667>,
<-306,-2.47512,-206.667>, <-306.333,-2.80845,-206.667>, <-307.667,-4.14179,-206.667>, <-308,-4.47512,-206.667>,
<-306,-2.47512,-310>, <-306.333,-2.80845,-310>, <-307.667,-4.14179,-310>, <-308,-4.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-306,1.52488,310>, <-306,0.858213,310>, <-306,-1.80845,310>, <-306,-2.47512,310>,
<-306,1.52488,206.667>, <-306,0.858213,206.667>, <-306,-1.80845,206.667>, <-306,-2.47512,206.667>,
<-306,1.52488,-206.667>, <-306,0.858213,-206.667>, <-306,-1.80845,-206.667>, <-306,-2.47512,-206.667>,
<-306,1.52488,-310>, <-306,0.858213,-310>, <-306,-1.80845,-310>, <-306,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-308,3.52488,310>, <-307.667,3.19155,310>, <-306.333,1.85821,310>, <-306,1.52488,310>,
<-308,3.52488,206.667>, <-307.667,3.19155,206.667>, <-306.333,1.85821,206.667>, <-306,1.52488,206.667>,
<-308,3.52488,-206.667>, <-307.667,3.19155,-206.667>, <-306.333,1.85821,-206.667>, <-306,1.52488,-206.667>,
<-308,3.52488,-310>, <-307.667,3.19155,-310>, <-306.333,1.85821,-310>, <-306,1.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-316,3.52488,310>, <-314.667,3.52488,310>, <-309.333,3.52488,310>, <-308,3.52488,310>,
<-316,3.52488,206.667>, <-314.667,3.52488,206.667>, <-309.333,3.52488,206.667>, <-308,3.52488,206.667>,
<-316,3.52488,-206.667>, <-314.667,3.52488,-206.667>, <-309.333,3.52488,-206.667>, <-308,3.52488,-206.667>,
<-316,3.52488,-310>, <-314.667,3.52488,-310>, <-309.333,3.52488,-310>, <-308,3.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-318,1.52488,310>, <-317.667,1.85821,310>, <-316.333,3.19155,310>, <-316,3.52488,310>,
<-318,1.52488,206.667>, <-317.667,1.85821,206.667>, <-316.333,3.19155,206.667>, <-316,3.52488,206.667>,
<-318,1.52488,-206.667>, <-317.667,1.85821,-206.667>, <-316.333,3.19155,-206.667>, <-316,3.52488,-206.667>,
<-318,1.52488,-310>, <-317.667,1.85821,-310>, <-316.333,3.19155,-310>, <-316,3.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-284,-4.47512,310>, <-284.333,-4.14179,310>, <-285.667,-2.80845,310>, <-286,-2.47512,310>,
<-284,-4.47512,206.667>, <-284.333,-4.14179,206.667>, <-285.667,-2.80845,206.667>, <-286,-2.47512,206.667>,
<-284,-4.47512,-206.667>, <-284.333,-4.14179,-206.667>, <-285.667,-2.80845,-206.667>, <-286,-2.47512,-206.667>,
<-284,-4.47512,-310>, <-284.333,-4.14179,-310>, <-285.667,-2.80845,-310>, <-286,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-286,1.52488,310>, <-286,1.52488,206.667>, <-286,1.52488,-206.667>, <-286,1.52488,-310>,
<-286,0.858213,310>, <-286,0.858213,206.667>, <-286,0.858213,-206.667>, <-286,0.858213,-310>,
<-286,-1.80845,310>, <-286,-1.80845,206.667>, <-286,-1.80845,-206.667>, <-286,-1.80845,-310>,
<-286,-2.47512,310>, <-286,-2.47512,206.667>, <-286,-2.47512,-206.667>, <-286,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-276,-4.47512,310>, <-277.333,-4.47512,310>, <-282.667,-4.47512,310>, <-284,-4.47512,310>,
<-276,-4.47512,206.667>, <-277.333,-4.47512,206.667>, <-282.667,-4.47512,206.667>, <-284,-4.47512,206.667>,
<-276,-4.47512,-206.667>, <-277.333,-4.47512,-206.667>, <-282.667,-4.47512,-206.667>, <-284,-4.47512,-206.667>,
<-276,-4.47512,-310>, <-277.333,-4.47512,-310>, <-282.667,-4.47512,-310>, <-284,-4.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-274,-2.47512,310>, <-274.333,-2.80845,310>, <-275.667,-4.14179,310>, <-276,-4.47512,310>,
<-274,-2.47512,206.667>, <-274.333,-2.80845,206.667>, <-275.667,-4.14179,206.667>, <-276,-4.47512,206.667>,
<-274,-2.47512,-206.667>, <-274.333,-2.80845,-206.667>, <-275.667,-4.14179,-206.667>, <-276,-4.47512,-206.667>,
<-274,-2.47512,-310>, <-274.333,-2.80845,-310>, <-275.667,-4.14179,-310>, <-276,-4.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-274,1.52488,310>, <-274,0.858213,310>, <-274,-1.80845,310>, <-274,-2.47512,310>,
<-274,1.52488,206.667>, <-274,0.858213,206.667>, <-274,-1.80845,206.667>, <-274,-2.47512,206.667>,
<-274,1.52488,-206.667>, <-274,0.858213,-206.667>, <-274,-1.80845,-206.667>, <-274,-2.47512,-206.667>,
<-274,1.52488,-310>, <-274,0.858213,-310>, <-274,-1.80845,-310>, <-274,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-276,3.52488,310>, <-275.667,3.19155,310>, <-274.333,1.85821,310>, <-274,1.52488,310>,
<-276,3.52488,206.667>, <-275.667,3.19155,206.667>, <-274.333,1.85821,206.667>, <-274,1.52488,206.667>,
<-276,3.52488,-206.667>, <-275.667,3.19155,-206.667>, <-274.333,1.85821,-206.667>, <-274,1.52488,-206.667>,
<-276,3.52488,-310>, <-275.667,3.19155,-310>, <-274.333,1.85821,-310>, <-274,1.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-284,3.52488,310>, <-282.667,3.52488,310>, <-277.333,3.52488,310>, <-276,3.52488,310>,
<-284,3.52488,206.667>, <-282.667,3.52488,206.667>, <-277.333,3.52488,206.667>, <-276,3.52488,206.667>,
<-284,3.52488,-206.667>, <-282.667,3.52488,-206.667>, <-277.333,3.52488,-206.667>, <-276,3.52488,-206.667>,
<-284,3.52488,-310>, <-282.667,3.52488,-310>, <-277.333,3.52488,-310>, <-276,3.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-286,1.52488,310>, <-285.667,1.85821,310>, <-284.333,3.19155,310>, <-284,3.52488,310>,
<-286,1.52488,206.667>, <-285.667,1.85821,206.667>, <-284.333,3.19155,206.667>, <-284,3.52488,206.667>,
<-286,1.52488,-206.667>, <-285.667,1.85821,-206.667>, <-284.333,3.19155,-206.667>, <-284,3.52488,-206.667>,
<-286,1.52488,-310>, <-285.667,1.85821,-310>, <-284.333,3.19155,-310>, <-284,3.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-204,-4.47512,310>, <-204.333,-4.14179,310>, <-205.667,-2.80845,310>, <-206,-2.47512,310>,
<-204,-4.47512,206.667>, <-204.333,-4.14179,206.667>, <-205.667,-2.80845,206.667>, <-206,-2.47512,206.667>,
<-204,-4.47512,-206.667>, <-204.333,-4.14179,-206.667>, <-205.667,-2.80845,-206.667>, <-206,-2.47512,-206.667>,
<-204,-4.47512,-310>, <-204.333,-4.14179,-310>, <-205.667,-2.80845,-310>, <-206,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-206,1.52488,310>, <-206,1.52488,206.667>, <-206,1.52488,-206.667>, <-206,1.52488,-310>,
<-206,0.858213,310>, <-206,0.858213,206.667>, <-206,0.858213,-206.667>, <-206,0.858213,-310>,
<-206,-1.80845,310>, <-206,-1.80845,206.667>, <-206,-1.80845,-206.667>, <-206,-1.80845,-310>,
<-206,-2.47512,310>, <-206,-2.47512,206.667>, <-206,-2.47512,-206.667>, <-206,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-196,-4.47512,310>, <-197.333,-4.47512,310>, <-202.667,-4.47512,310>, <-204,-4.47512,310>,
<-196,-4.47512,206.667>, <-197.333,-4.47512,206.667>, <-202.667,-4.47512,206.667>, <-204,-4.47512,206.667>,
<-196,-4.47512,-206.667>, <-197.333,-4.47512,-206.667>, <-202.667,-4.47512,-206.667>, <-204,-4.47512,-206.667>,
<-196,-4.47512,-310>, <-197.333,-4.47512,-310>, <-202.667,-4.47512,-310>, <-204,-4.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-194,-2.47512,310>, <-194.333,-2.80845,310>, <-195.667,-4.14179,310>, <-196,-4.47512,310>,
<-194,-2.47512,206.667>, <-194.333,-2.80845,206.667>, <-195.667,-4.14179,206.667>, <-196,-4.47512,206.667>,
<-194,-2.47512,-206.667>, <-194.333,-2.80845,-206.667>, <-195.667,-4.14179,-206.667>, <-196,-4.47512,-206.667>,
<-194,-2.47512,-310>, <-194.333,-2.80845,-310>, <-195.667,-4.14179,-310>, <-196,-4.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-194,1.52488,310>, <-194,0.858213,310>, <-194,-1.80845,310>, <-194,-2.47512,310>,
<-194,1.52488,206.667>, <-194,0.858213,206.667>, <-194,-1.80845,206.667>, <-194,-2.47512,206.667>,
<-194,1.52488,-206.667>, <-194,0.858213,-206.667>, <-194,-1.80845,-206.667>, <-194,-2.47512,-206.667>,
<-194,1.52488,-310>, <-194,0.858213,-310>, <-194,-1.80845,-310>, <-194,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-196,3.52488,310>, <-195.667,3.19155,310>, <-194.333,1.85821,310>, <-194,1.52488,310>,
<-196,3.52488,206.667>, <-195.667,3.19155,206.667>, <-194.333,1.85821,206.667>, <-194,1.52488,206.667>,
<-196,3.52488,-206.667>, <-195.667,3.19155,-206.667>, <-194.333,1.85821,-206.667>, <-194,1.52488,-206.667>,
<-196,3.52488,-310>, <-195.667,3.19155,-310>, <-194.333,1.85821,-310>, <-194,1.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-204,3.52488,310>, <-202.667,3.52488,310>, <-197.333,3.52488,310>, <-196,3.52488,310>,
<-204,3.52488,206.667>, <-202.667,3.52488,206.667>, <-197.333,3.52488,206.667>, <-196,3.52488,206.667>,
<-204,3.52488,-206.667>, <-202.667,3.52488,-206.667>, <-197.333,3.52488,-206.667>, <-196,3.52488,-206.667>,
<-204,3.52488,-310>, <-202.667,3.52488,-310>, <-197.333,3.52488,-310>, <-196,3.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-206,1.52488,310>, <-205.667,1.85821,310>, <-204.333,3.19155,310>, <-204,3.52488,310>,
<-206,1.52488,206.667>, <-205.667,1.85821,206.667>, <-204.333,3.19155,206.667>, <-204,3.52488,206.667>,
<-206,1.52488,-206.667>, <-205.667,1.85821,-206.667>, <-204.333,3.19155,-206.667>, <-204,3.52488,-206.667>,
<-206,1.52488,-310>, <-205.667,1.85821,-310>, <-204.333,3.19155,-310>, <-204,3.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-236,-4.47512,310>, <-236.333,-4.14179,310>, <-237.667,-2.80845,310>, <-238,-2.47512,310>,
<-236,-4.47512,206.667>, <-236.333,-4.14179,206.667>, <-237.667,-2.80845,206.667>, <-238,-2.47512,206.667>,
<-236,-4.47512,-206.667>, <-236.333,-4.14179,-206.667>, <-237.667,-2.80845,-206.667>, <-238,-2.47512,-206.667>,
<-236,-4.47512,-310>, <-236.333,-4.14179,-310>, <-237.667,-2.80845,-310>, <-238,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-238,1.52488,310>, <-238,1.52488,206.667>, <-238,1.52488,-206.667>, <-238,1.52488,-310>,
<-238,0.858213,310>, <-238,0.858213,206.667>, <-238,0.858213,-206.667>, <-238,0.858213,-310>,
<-238,-1.80845,310>, <-238,-1.80845,206.667>, <-238,-1.80845,-206.667>, <-238,-1.80845,-310>,
<-238,-2.47512,310>, <-238,-2.47512,206.667>, <-238,-2.47512,-206.667>, <-238,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-228,-4.47512,310>, <-229.333,-4.47512,310>, <-234.667,-4.47512,310>, <-236,-4.47512,310>,
<-228,-4.47512,206.667>, <-229.333,-4.47512,206.667>, <-234.667,-4.47512,206.667>, <-236,-4.47512,206.667>,
<-228,-4.47512,-206.667>, <-229.333,-4.47512,-206.667>, <-234.667,-4.47512,-206.667>, <-236,-4.47512,-206.667>,
<-228,-4.47512,-310>, <-229.333,-4.47512,-310>, <-234.667,-4.47512,-310>, <-236,-4.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-226,-2.47512,310>, <-226.333,-2.80845,310>, <-227.667,-4.14179,310>, <-228,-4.47512,310>,
<-226,-2.47512,206.667>, <-226.333,-2.80845,206.667>, <-227.667,-4.14179,206.667>, <-228,-4.47512,206.667>,
<-226,-2.47512,-206.667>, <-226.333,-2.80845,-206.667>, <-227.667,-4.14179,-206.667>, <-228,-4.47512,-206.667>,
<-226,-2.47512,-310>, <-226.333,-2.80845,-310>, <-227.667,-4.14179,-310>, <-228,-4.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-226,1.52488,310>, <-226,0.858213,310>, <-226,-1.80845,310>, <-226,-2.47512,310>,
<-226,1.52488,206.667>, <-226,0.858213,206.667>, <-226,-1.80845,206.667>, <-226,-2.47512,206.667>,
<-226,1.52488,-206.667>, <-226,0.858213,-206.667>, <-226,-1.80845,-206.667>, <-226,-2.47512,-206.667>,
<-226,1.52488,-310>, <-226,0.858213,-310>, <-226,-1.80845,-310>, <-226,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-228,3.52488,310>, <-227.667,3.19155,310>, <-226.333,1.85821,310>, <-226,1.52488,310>,
<-228,3.52488,206.667>, <-227.667,3.19155,206.667>, <-226.333,1.85821,206.667>, <-226,1.52488,206.667>,
<-228,3.52488,-206.667>, <-227.667,3.19155,-206.667>, <-226.333,1.85821,-206.667>, <-226,1.52488,-206.667>,
<-228,3.52488,-310>, <-227.667,3.19155,-310>, <-226.333,1.85821,-310>, <-226,1.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-236,3.52488,310>, <-234.667,3.52488,310>, <-229.333,3.52488,310>, <-228,3.52488,310>,
<-236,3.52488,206.667>, <-234.667,3.52488,206.667>, <-229.333,3.52488,206.667>, <-228,3.52488,206.667>,
<-236,3.52488,-206.667>, <-234.667,3.52488,-206.667>, <-229.333,3.52488,-206.667>, <-228,3.52488,-206.667>,
<-236,3.52488,-310>, <-234.667,3.52488,-310>, <-229.333,3.52488,-310>, <-228,3.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-238,1.52488,310>, <-237.667,1.85821,310>, <-236.333,3.19155,310>, <-236,3.52488,310>,
<-238,1.52488,206.667>, <-237.667,1.85821,206.667>, <-236.333,3.19155,206.667>, <-236,3.52488,206.667>,
<-238,1.52488,-206.667>, <-237.667,1.85821,-206.667>, <-236.333,3.19155,-206.667>, <-236,3.52488,-206.667>,
<-238,1.52488,-310>, <-237.667,1.85821,-310>, <-236.333,3.19155,-310>, <-236,3.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-172,-4.47512,310>, <-172.333,-4.14179,310>, <-173.667,-2.80845,310>, <-174,-2.47512,310>,
<-172,-4.47512,206.667>, <-172.333,-4.14179,206.667>, <-173.667,-2.80845,206.667>, <-174,-2.47512,206.667>,
<-172,-4.47512,-206.667>, <-172.333,-4.14179,-206.667>, <-173.667,-2.80845,-206.667>, <-174,-2.47512,-206.667>,
<-172,-4.47512,-310>, <-172.333,-4.14179,-310>, <-173.667,-2.80845,-310>, <-174,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-174,1.52488,310>, <-174,1.52488,206.667>, <-174,1.52488,-206.667>, <-174,1.52488,-310>,
<-174,0.858213,310>, <-174,0.858213,206.667>, <-174,0.858213,-206.667>, <-174,0.858213,-310>,
<-174,-1.80845,310>, <-174,-1.80845,206.667>, <-174,-1.80845,-206.667>, <-174,-1.80845,-310>,
<-174,-2.47512,310>, <-174,-2.47512,206.667>, <-174,-2.47512,-206.667>, <-174,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-164,-4.47512,310>, <-165.333,-4.47512,310>, <-170.667,-4.47512,310>, <-172,-4.47512,310>,
<-164,-4.47512,206.667>, <-165.333,-4.47512,206.667>, <-170.667,-4.47512,206.667>, <-172,-4.47512,206.667>,
<-164,-4.47512,-206.667>, <-165.333,-4.47512,-206.667>, <-170.667,-4.47512,-206.667>, <-172,-4.47512,-206.667>,
<-164,-4.47512,-310>, <-165.333,-4.47512,-310>, <-170.667,-4.47512,-310>, <-172,-4.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-162,-2.47512,310>, <-162.333,-2.80845,310>, <-163.667,-4.14179,310>, <-164,-4.47512,310>,
<-162,-2.47512,206.667>, <-162.333,-2.80845,206.667>, <-163.667,-4.14179,206.667>, <-164,-4.47512,206.667>,
<-162,-2.47512,-206.667>, <-162.333,-2.80845,-206.667>, <-163.667,-4.14179,-206.667>, <-164,-4.47512,-206.667>,
<-162,-2.47512,-310>, <-162.333,-2.80845,-310>, <-163.667,-4.14179,-310>, <-164,-4.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-162,1.52488,310>, <-162,0.858213,310>, <-162,-1.80845,310>, <-162,-2.47512,310>,
<-162,1.52488,206.667>, <-162,0.858213,206.667>, <-162,-1.80845,206.667>, <-162,-2.47512,206.667>,
<-162,1.52488,-206.667>, <-162,0.858213,-206.667>, <-162,-1.80845,-206.667>, <-162,-2.47512,-206.667>,
<-162,1.52488,-310>, <-162,0.858213,-310>, <-162,-1.80845,-310>, <-162,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-164,3.52488,310>, <-163.667,3.19155,310>, <-162.333,1.85821,310>, <-162,1.52488,310>,
<-164,3.52488,206.667>, <-163.667,3.19155,206.667>, <-162.333,1.85821,206.667>, <-162,1.52488,206.667>,
<-164,3.52488,-206.667>, <-163.667,3.19155,-206.667>, <-162.333,1.85821,-206.667>, <-162,1.52488,-206.667>,
<-164,3.52488,-310>, <-163.667,3.19155,-310>, <-162.333,1.85821,-310>, <-162,1.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-172,3.52488,310>, <-170.667,3.52488,310>, <-165.333,3.52488,310>, <-164,3.52488,310>,
<-172,3.52488,206.667>, <-170.667,3.52488,206.667>, <-165.333,3.52488,206.667>, <-164,3.52488,206.667>,
<-172,3.52488,-206.667>, <-170.667,3.52488,-206.667>, <-165.333,3.52488,-206.667>, <-164,3.52488,-206.667>,
<-172,3.52488,-310>, <-170.667,3.52488,-310>, <-165.333,3.52488,-310>, <-164,3.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-174,1.52488,310>, <-173.667,1.85821,310>, <-172.333,3.19155,310>, <-172,3.52488,310>,
<-174,1.52488,206.667>, <-173.667,1.85821,206.667>, <-172.333,3.19155,206.667>, <-172,3.52488,206.667>,
<-174,1.52488,-206.667>, <-173.667,1.85821,-206.667>, <-172.333,3.19155,-206.667>, <-172,3.52488,-206.667>,
<-174,1.52488,-310>, <-173.667,1.85821,-310>, <-172.333,3.19155,-310>, <-172,3.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-220,-4.47512,310>, <-220.333,-4.14179,310>, <-221.667,-2.80845,310>, <-222,-2.47512,310>,
<-220,-4.47512,206.667>, <-220.333,-4.14179,206.667>, <-221.667,-2.80845,206.667>, <-222,-2.47512,206.667>,
<-220,-4.47512,-206.667>, <-220.333,-4.14179,-206.667>, <-221.667,-2.80845,-206.667>, <-222,-2.47512,-206.667>,
<-220,-4.47512,-310>, <-220.333,-4.14179,-310>, <-221.667,-2.80845,-310>, <-222,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-222,1.52488,310>, <-222,1.52488,206.667>, <-222,1.52488,-206.667>, <-222,1.52488,-310>,
<-222,0.858213,310>, <-222,0.858213,206.667>, <-222,0.858213,-206.667>, <-222,0.858213,-310>,
<-222,-1.80845,310>, <-222,-1.80845,206.667>, <-222,-1.80845,-206.667>, <-222,-1.80845,-310>,
<-222,-2.47512,310>, <-222,-2.47512,206.667>, <-222,-2.47512,-206.667>, <-222,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-212,-4.47512,310>, <-213.333,-4.47512,310>, <-218.667,-4.47512,310>, <-220,-4.47512,310>,
<-212,-4.47512,206.667>, <-213.333,-4.47512,206.667>, <-218.667,-4.47512,206.667>, <-220,-4.47512,206.667>,
<-212,-4.47512,-206.667>, <-213.333,-4.47512,-206.667>, <-218.667,-4.47512,-206.667>, <-220,-4.47512,-206.667>,
<-212,-4.47512,-310>, <-213.333,-4.47512,-310>, <-218.667,-4.47512,-310>, <-220,-4.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-210,-2.47512,310>, <-210.333,-2.80845,310>, <-211.667,-4.14179,310>, <-212,-4.47512,310>,
<-210,-2.47512,206.667>, <-210.333,-2.80845,206.667>, <-211.667,-4.14179,206.667>, <-212,-4.47512,206.667>,
<-210,-2.47512,-206.667>, <-210.333,-2.80845,-206.667>, <-211.667,-4.14179,-206.667>, <-212,-4.47512,-206.667>,
<-210,-2.47512,-310>, <-210.333,-2.80845,-310>, <-211.667,-4.14179,-310>, <-212,-4.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-210,1.52488,310>, <-210,0.858213,310>, <-210,-1.80845,310>, <-210,-2.47512,310>,
<-210,1.52488,206.667>, <-210,0.858213,206.667>, <-210,-1.80845,206.667>, <-210,-2.47512,206.667>,
<-210,1.52488,-206.667>, <-210,0.858213,-206.667>, <-210,-1.80845,-206.667>, <-210,-2.47512,-206.667>,
<-210,1.52488,-310>, <-210,0.858213,-310>, <-210,-1.80845,-310>, <-210,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-212,3.52488,310>, <-211.667,3.19155,310>, <-210.333,1.85821,310>, <-210,1.52488,310>,
<-212,3.52488,206.667>, <-211.667,3.19155,206.667>, <-210.333,1.85821,206.667>, <-210,1.52488,206.667>,
<-212,3.52488,-206.667>, <-211.667,3.19155,-206.667>, <-210.333,1.85821,-206.667>, <-210,1.52488,-206.667>,
<-212,3.52488,-310>, <-211.667,3.19155,-310>, <-210.333,1.85821,-310>, <-210,1.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-220,3.52488,310>, <-218.667,3.52488,310>, <-213.333,3.52488,310>, <-212,3.52488,310>,
<-220,3.52488,206.667>, <-218.667,3.52488,206.667>, <-213.333,3.52488,206.667>, <-212,3.52488,206.667>,
<-220,3.52488,-206.667>, <-218.667,3.52488,-206.667>, <-213.333,3.52488,-206.667>, <-212,3.52488,-206.667>,
<-220,3.52488,-310>, <-218.667,3.52488,-310>, <-213.333,3.52488,-310>, <-212,3.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-222,1.52488,310>, <-221.667,1.85821,310>, <-220.333,3.19155,310>, <-220,3.52488,310>,
<-222,1.52488,206.667>, <-221.667,1.85821,206.667>, <-220.333,3.19155,206.667>, <-220,3.52488,206.667>,
<-222,1.52488,-206.667>, <-221.667,1.85821,-206.667>, <-220.333,3.19155,-206.667>, <-220,3.52488,-206.667>,
<-222,1.52488,-310>, <-221.667,1.85821,-310>, <-220.333,3.19155,-310>, <-220,3.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-188,-4.47512,310>, <-188.333,-4.14179,310>, <-189.667,-2.80845,310>, <-190,-2.47512,310>,
<-188,-4.47512,206.667>, <-188.333,-4.14179,206.667>, <-189.667,-2.80845,206.667>, <-190,-2.47512,206.667>,
<-188,-4.47512,-206.667>, <-188.333,-4.14179,-206.667>, <-189.667,-2.80845,-206.667>, <-190,-2.47512,-206.667>,
<-188,-4.47512,-310>, <-188.333,-4.14179,-310>, <-189.667,-2.80845,-310>, <-190,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-190,1.52488,310>, <-190,1.52488,206.667>, <-190,1.52488,-206.667>, <-190,1.52488,-310>,
<-190,0.858213,310>, <-190,0.858213,206.667>, <-190,0.858213,-206.667>, <-190,0.858213,-310>,
<-190,-1.80845,310>, <-190,-1.80845,206.667>, <-190,-1.80845,-206.667>, <-190,-1.80845,-310>,
<-190,-2.47512,310>, <-190,-2.47512,206.667>, <-190,-2.47512,-206.667>, <-190,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-180,-4.47512,310>, <-181.333,-4.47512,310>, <-186.667,-4.47512,310>, <-188,-4.47512,310>,
<-180,-4.47512,206.667>, <-181.333,-4.47512,206.667>, <-186.667,-4.47512,206.667>, <-188,-4.47512,206.667>,
<-180,-4.47512,-206.667>, <-181.333,-4.47512,-206.667>, <-186.667,-4.47512,-206.667>, <-188,-4.47512,-206.667>,
<-180,-4.47512,-310>, <-181.333,-4.47512,-310>, <-186.667,-4.47512,-310>, <-188,-4.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-178,-2.47512,310>, <-178.333,-2.80845,310>, <-179.667,-4.14179,310>, <-180,-4.47512,310>,
<-178,-2.47512,206.667>, <-178.333,-2.80845,206.667>, <-179.667,-4.14179,206.667>, <-180,-4.47512,206.667>,
<-178,-2.47512,-206.667>, <-178.333,-2.80845,-206.667>, <-179.667,-4.14179,-206.667>, <-180,-4.47512,-206.667>,
<-178,-2.47512,-310>, <-178.333,-2.80845,-310>, <-179.667,-4.14179,-310>, <-180,-4.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-178,1.52488,310>, <-178,0.858213,310>, <-178,-1.80845,310>, <-178,-2.47512,310>,
<-178,1.52488,206.667>, <-178,0.858213,206.667>, <-178,-1.80845,206.667>, <-178,-2.47512,206.667>,
<-178,1.52488,-206.667>, <-178,0.858213,-206.667>, <-178,-1.80845,-206.667>, <-178,-2.47512,-206.667>,
<-178,1.52488,-310>, <-178,0.858213,-310>, <-178,-1.80845,-310>, <-178,-2.47512,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-180,3.52488,310>, <-179.667,3.19155,310>, <-178.333,1.85821,310>, <-178,1.52488,310>,
<-180,3.52488,206.667>, <-179.667,3.19155,206.667>, <-178.333,1.85821,206.667>, <-178,1.52488,206.667>,
<-180,3.52488,-206.667>, <-179.667,3.19155,-206.667>, <-178.333,1.85821,-206.667>, <-178,1.52488,-206.667>,
<-180,3.52488,-310>, <-179.667,3.19155,-310>, <-178.333,1.85821,-310>, <-178,1.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-188,3.52488,310>, <-186.667,3.52488,310>, <-181.333,3.52488,310>, <-180,3.52488,310>,
<-188,3.52488,206.667>, <-186.667,3.52488,206.667>, <-181.333,3.52488,206.667>, <-180,3.52488,206.667>,
<-188,3.52488,-206.667>, <-186.667,3.52488,-206.667>, <-181.333,3.52488,-206.667>, <-180,3.52488,-206.667>,
<-188,3.52488,-310>, <-186.667,3.52488,-310>, <-181.333,3.52488,-310>, <-180,3.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-190,1.52488,310>, <-189.667,1.85821,310>, <-188.333,3.19155,310>, <-188,3.52488,310>,
<-190,1.52488,206.667>, <-189.667,1.85821,206.667>, <-188.333,3.19155,206.667>, <-188,3.52488,206.667>,
<-190,1.52488,-206.667>, <-189.667,1.85821,-206.667>, <-188.333,3.19155,-206.667>, <-188,3.52488,-206.667>,
<-190,1.52488,-310>, <-189.667,1.85821,-310>, <-188.333,3.19155,-310>, <-188,3.52488,-310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<150,15,403.033>, <150,15,269.7>, <150,15,-263.634>, <150,15,-396.967>,
<146.667,15,403.033>, <146.667,15,269.7>, <146.667,15,-263.634>, <146.667,15,-396.967>,
<133.333,15,403.033>, <133.333,15,269.7>, <133.333,15,-263.634>, <133.333,15,-396.967>,
<130,15,403.033>, <130,15,269.7>, <130,15,-263.634>, <130,15,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<150,15,403.033>, <150.833,14.1667,403.033>, <154.167,10.8333,403.033>, <155,10,403.033>,
<150,15,269.7>, <150.833,14.1667,269.7>, <154.167,10.8333,269.7>, <155,10,269.7>,
<150,15,-263.634>, <150.833,14.1667,-263.634>, <154.167,10.8333,-263.634>, <155,10,-263.634>,
<150,15,-396.967>, <150.833,14.1667,-396.967>, <154.167,10.8333,-396.967>, <155,10,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<150,15,403.033>, <150,10,403.033>, <150,-10,403.033>, <150,-15,403.033>,
<150.833,14.1667,403.033>, <150.833,9.72222,403.033>, <150.833,-9.72222,403.033>, <150.833,-14.1667,403.033>,
<154.167,10.8333,403.033>, <154.167,6.94444,403.033>, <154.167,-6.94444,403.033>, <154.167,-10.8333,403.033>,
<155,10,403.033>, <155,6.66667,403.033>, <155,-6.66667,403.033>, <155,-10,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<150,15,403.033>, <146.667,15,403.033>, <133.333,15,403.033>, <130,15,403.033>,
<150,10,403.033>, <146.667,10,403.033>, <133.333,10,403.033>, <130,10,403.033>,
<150,-10,403.033>, <146.667,-10,403.033>, <133.333,-10,403.033>, <130,-10,403.033>,
<150,-15,403.033>, <146.667,-15,403.033>, <133.333,-15,403.033>, <130,-15,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<155,-10,403.033>, <154.167,-10.8333,403.033>, <150.833,-14.1667,403.033>, <150,-15,403.033>,
<155,-10,269.7>, <154.167,-10.8333,269.7>, <150.833,-14.1667,269.7>, <150,-15,269.7>,
<155,-10,-263.634>, <154.167,-10.8333,-263.634>, <150.833,-14.1667,-263.634>, <150,-15,-263.634>,
<155,-10,-396.967>, <154.167,-10.8333,-396.967>, <150.833,-14.1667,-396.967>, <150,-15,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<150,-15,403.033>, <146.667,-15,403.033>, <133.333,-15,403.033>, <130,-15,403.033>,
<150,-15,269.7>, <146.667,-15,269.7>, <133.333,-15,269.7>, <130,-15,269.7>,
<150,-15,-263.634>, <146.667,-15,-263.634>, <133.333,-15,-263.634>, <130,-15,-263.634>,
<150,-15,-396.967>, <146.667,-15,-396.967>, <133.333,-15,-396.967>, <130,-15,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<130,15,-396.967>, <133.333,15,-396.967>, <146.667,15,-396.967>, <150,15,-396.967>,
<130,10,-396.967>, <133.333,10,-396.967>, <146.667,10,-396.967>, <150,10,-396.967>,
<130,-10,-396.967>, <133.333,-10,-396.967>, <146.667,-10,-396.967>, <150,-10,-396.967>,
<130,-15,-396.967>, <133.333,-15,-396.967>, <146.667,-15,-396.967>, <150,-15,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<150,15,-396.967>, <150.833,14.1667,-396.967>, <154.167,10.8333,-396.967>, <155,10,-396.967>,
<150,10,-396.967>, <150.833,9.72222,-396.967>, <154.167,6.94444,-396.967>, <155,6.66667,-396.967>,
<150,-10,-396.967>, <150.833,-9.72222,-396.967>, <154.167,-6.94444,-396.967>, <155,-6.66667,-396.967>,
<150,-15,-396.967>, <150.833,-14.1667,-396.967>, <154.167,-10.8333,-396.967>, <155,-10,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<130,15,403.033>, <130,15,269.7>, <130,15,-263.634>, <130,15,-396.967>,
<129.167,14.1667,403.033>, <129.167,14.1667,269.7>, <129.167,14.1667,-263.634>, <129.167,14.1667,-396.967>,
<125.833,10.8333,403.033>, <125.833,10.8333,269.7>, <125.833,10.8333,-263.634>, <125.833,10.8333,-396.967>,
<125,10,403.033>, <125,10,269.7>, <125,10,-263.634>, <125,10,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<130,15,403.033>, <129.167,14.1667,403.033>, <125.833,10.8333,403.033>, <125,10,403.033>,
<130,10,403.033>, <129.167,9.72222,403.033>, <125.833,6.94444,403.033>, <125,6.66667,403.033>,
<130,-10,403.033>, <129.167,-9.72222,403.033>, <125.833,-6.94444,403.033>, <125,-6.66667,403.033>,
<130,-15,403.033>, <129.167,-14.1667,403.033>, <125.833,-10.8333,403.033>, <125,-10,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<130,-15,403.033>, <129.167,-14.1667,403.033>, <125.833,-10.8333,403.033>, <125,-10,403.033>,
<130,-15,269.7>, <129.167,-14.1667,269.7>, <125.833,-10.8333,269.7>, <125,-10,269.7>,
<130,-15,-263.634>, <129.167,-14.1667,-263.634>, <125.833,-10.8333,-263.634>, <125,-10,-263.634>,
<130,-15,-396.967>, <129.167,-14.1667,-396.967>, <125.833,-10.8333,-396.967>, <125,-10,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<130,15,-396.967>, <130,10,-396.967>, <130,-10,-396.967>, <130,-15,-396.967>,
<129.167,14.1667,-396.967>, <129.167,9.72222,-396.967>, <129.167,-9.72222,-396.967>, <129.167,-14.1667,-396.967>,
<125.833,10.8333,-396.967>, <125.833,6.94444,-396.967>, <125.833,-6.94444,-396.967>, <125.833,-10.8333,-396.967>,
<125,10,-396.967>, <125,6.66667,-396.967>, <125,-6.66667,-396.967>, <125,-10,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<350,15,403.033>, <350,15,269.7>, <350,15,-263.634>, <350,15,-396.967>,
<346.667,15,403.033>, <346.667,15,269.7>, <346.667,15,-263.634>, <346.667,15,-396.967>,
<333.333,15,403.033>, <333.333,15,269.7>, <333.333,15,-263.634>, <333.333,15,-396.967>,
<330,15,403.033>, <330,15,269.7>, <330,15,-263.634>, <330,15,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<350,15,403.033>, <350.833,14.1667,403.033>, <354.167,10.8333,403.033>, <355,10,403.033>,
<350,15,269.7>, <350.833,14.1667,269.7>, <354.167,10.8333,269.7>, <355,10,269.7>,
<350,15,-263.634>, <350.833,14.1667,-263.634>, <354.167,10.8333,-263.634>, <355,10,-263.634>,
<350,15,-396.967>, <350.833,14.1667,-396.967>, <354.167,10.8333,-396.967>, <355,10,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<350,15,403.033>, <350,10,403.033>, <350,-10,403.033>, <350,-15,403.033>,
<350.833,14.1667,403.033>, <350.833,9.72222,403.033>, <350.833,-9.72222,403.033>, <350.833,-14.1667,403.033>,
<354.167,10.8333,403.033>, <354.167,6.94444,403.033>, <354.167,-6.94444,403.033>, <354.167,-10.8333,403.033>,
<355,10,403.033>, <355,6.66667,403.033>, <355,-6.66667,403.033>, <355,-10,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<350,15,403.033>, <346.667,15,403.033>, <333.333,15,403.033>, <330,15,403.033>,
<350,10,403.033>, <346.667,10,403.033>, <333.333,10,403.033>, <330,10,403.033>,
<350,-10,403.033>, <346.667,-10,403.033>, <333.333,-10,403.033>, <330,-10,403.033>,
<350,-15,403.033>, <346.667,-15,403.033>, <333.333,-15,403.033>, <330,-15,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<355,-10,403.033>, <354.167,-10.8333,403.033>, <350.833,-14.1667,403.033>, <350,-15,403.033>,
<355,-10,269.7>, <354.167,-10.8333,269.7>, <350.833,-14.1667,269.7>, <350,-15,269.7>,
<355,-10,-263.634>, <354.167,-10.8333,-263.634>, <350.833,-14.1667,-263.634>, <350,-15,-263.634>,
<355,-10,-396.967>, <354.167,-10.8333,-396.967>, <350.833,-14.1667,-396.967>, <350,-15,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<350,-15,403.033>, <346.667,-15,403.033>, <333.333,-15,403.033>, <330,-15,403.033>,
<350,-15,269.7>, <346.667,-15,269.7>, <333.333,-15,269.7>, <330,-15,269.7>,
<350,-15,-263.634>, <346.667,-15,-263.634>, <333.333,-15,-263.634>, <330,-15,-263.634>,
<350,-15,-396.967>, <346.667,-15,-396.967>, <333.333,-15,-396.967>, <330,-15,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<330,15,-396.967>, <333.333,15,-396.967>, <346.667,15,-396.967>, <350,15,-396.967>,
<330,10,-396.967>, <333.333,10,-396.967>, <346.667,10,-396.967>, <350,10,-396.967>,
<330,-10,-396.967>, <333.333,-10,-396.967>, <346.667,-10,-396.967>, <350,-10,-396.967>,
<330,-15,-396.967>, <333.333,-15,-396.967>, <346.667,-15,-396.967>, <350,-15,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<350,15,-396.967>, <350.833,14.1667,-396.967>, <354.167,10.8333,-396.967>, <355,10,-396.967>,
<350,10,-396.967>, <350.833,9.72222,-396.967>, <354.167,6.94444,-396.967>, <355,6.66667,-396.967>,
<350,-10,-396.967>, <350.833,-9.72222,-396.967>, <354.167,-6.94444,-396.967>, <355,-6.66667,-396.967>,
<350,-15,-396.967>, <350.833,-14.1667,-396.967>, <354.167,-10.8333,-396.967>, <355,-10,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<330,15,403.033>, <330,15,269.7>, <330,15,-263.634>, <330,15,-396.967>,
<329.167,14.1667,403.033>, <329.167,14.1667,269.7>, <329.167,14.1667,-263.634>, <329.167,14.1667,-396.967>,
<325.833,10.8333,403.033>, <325.833,10.8333,269.7>, <325.833,10.8333,-263.634>, <325.833,10.8333,-396.967>,
<325,10,403.033>, <325,10,269.7>, <325,10,-263.634>, <325,10,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<330,15,403.033>, <329.167,14.1667,403.033>, <325.833,10.8333,403.033>, <325,10,403.033>,
<330,10,403.033>, <329.167,9.72222,403.033>, <325.833,6.94444,403.033>, <325,6.66667,403.033>,
<330,-10,403.033>, <329.167,-9.72222,403.033>, <325.833,-6.94444,403.033>, <325,-6.66667,403.033>,
<330,-15,403.033>, <329.167,-14.1667,403.033>, <325.833,-10.8333,403.033>, <325,-10,403.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<330,-15,403.033>, <329.167,-14.1667,403.033>, <325.833,-10.8333,403.033>, <325,-10,403.033>,
<330,-15,269.7>, <329.167,-14.1667,269.7>, <325.833,-10.8333,269.7>, <325,-10,269.7>,
<330,-15,-263.634>, <329.167,-14.1667,-263.634>, <325.833,-10.8333,-263.634>, <325,-10,-263.634>,
<330,-15,-396.967>, <329.167,-14.1667,-396.967>, <325.833,-10.8333,-396.967>, <325,-10,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<325,10,-396.967>, <325.833,10.8333,-396.967>, <329.167,14.1667,-396.967>, <330,15,-396.967>,
<325,6.66667,-396.967>, <325.833,6.94444,-396.967>, <329.167,9.72222,-396.967>, <330,10,-396.967>,
<325,-6.66667,-396.967>, <325.833,-6.94444,-396.967>, <329.167,-9.72222,-396.967>, <330,-10,-396.967>,
<325,-10,-396.967>, <325.833,-10.8333,-396.967>, <329.167,-14.1667,-396.967>, <330,-15,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<325,10,403.033>, <325,10,269.7>, <325,10,-263.634>, <325,10,-396.967>,
<325,6.66667,403.033>, <325,6.66667,269.7>, <325,6.66667,-263.634>, <325,6.66667,-396.967>,
<325,-6.66667,403.033>, <325,-6.66667,269.7>, <325,-6.66667,-263.634>, <325,-6.66667,-396.967>,
<325,-10,403.033>, <325,-10,269.7>, <325,-10,-263.634>, <325,-10,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<355,10,403.033>, <355,6.66667,403.033>, <355,-6.66667,403.033>, <355,-10,403.033>,
<355,10,269.7>, <355,6.66667,269.7>, <355,-6.66667,269.7>, <355,-10,269.7>,
<355,10,-263.634>, <355,6.66667,-263.634>, <355,-6.66667,-263.634>, <355,-10,-263.634>,
<355,10,-396.967>, <355,6.66667,-396.967>, <355,-6.66667,-396.967>, <355,-10,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<125,-10,403.033>, <125,-6.66667,403.033>, <125,6.66667,403.033>, <125,10,403.033>,
<125,-10,269.7>, <125,-6.66667,269.7>, <125,6.66667,269.7>, <125,10,269.7>,
<125,-10,-263.634>, <125,-6.66667,-263.634>, <125,6.66667,-263.634>, <125,10,-263.634>,
<125,-10,-396.967>, <125,-6.66667,-396.967>, <125,6.66667,-396.967>, <125,10,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<155,10,403.033>, <155,6.66667,403.033>, <155,-6.66667,403.033>, <155,-10,403.033>,
<155,10,269.7>, <155,6.66667,269.7>, <155,-6.66667,269.7>, <155,-10,269.7>,
<155,10,-263.634>, <155,6.66667,-263.634>, <155,-6.66667,-263.634>, <155,-10,-263.634>,
<155,10,-396.967>, <155,6.66667,-396.967>, <155,-6.66667,-396.967>, <155,-10,-396.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,5,-305.967>, <185.667,5,-305.967>, <294.333,5,-305.967>, <321.5,5,-305.967>,
<158.5,3.33333,-305.967>, <185.667,3.33333,-305.967>, <294.333,3.33333,-305.967>, <321.5,3.33333,-305.967>,
<158.5,-3.33333,-305.967>, <185.667,-3.33333,-305.967>, <294.333,-3.33333,-305.967>, <321.5,-3.33333,-305.967>,
<158.5,-5,-305.967>, <185.667,-5,-305.967>, <294.333,-5,-305.967>, <321.5,-5,-305.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,5,-305.967>, <158.5,3.33333,-305.967>, <158.5,-3.33333,-305.967>, <158.5,-5,-305.967>,
<158.5,5,-320.967>, <158.5,3.33333,-320.967>, <158.5,-3.33333,-320.967>, <158.5,-5,-320.967>,
<158.5,5,-380.967>, <158.5,3.33333,-380.967>, <158.5,-3.33333,-380.967>, <158.5,-5,-380.967>,
<158.5,5,-395.967>, <158.5,3.33333,-395.967>, <158.5,-3.33333,-395.967>, <158.5,-5,-395.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,-5,-395.967>, <185.667,-5,-395.967>, <294.333,-5,-395.967>, <321.5,-5,-395.967>,
<158.5,-3.33333,-395.967>, <185.667,-3.33333,-395.967>, <294.333,-3.33333,-395.967>, <321.5,-3.33333,-395.967>,
<158.5,3.33333,-395.967>, <185.667,3.33333,-395.967>, <294.333,3.33333,-395.967>, <321.5,3.33333,-395.967>,
<158.5,5,-395.967>, <185.667,5,-395.967>, <294.333,5,-395.967>, <321.5,5,-395.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<321.5,-5,-395.967>, <321.5,-5,-380.967>, <321.5,-5,-320.967>, <321.5,-5,-305.967>,
<321.5,-3.33333,-395.967>, <321.5,-3.33333,-380.967>, <321.5,-3.33333,-320.967>, <321.5,-3.33333,-305.967>,
<321.5,3.33333,-395.967>, <321.5,3.33333,-380.967>, <321.5,3.33333,-320.967>, <321.5,3.33333,-305.967>,
<321.5,5,-395.967>, <321.5,5,-380.967>, <321.5,5,-320.967>, <321.5,5,-305.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,-5,402.033>, <185.667,-5,402.033>, <294.333,-5,402.033>, <321.5,-5,402.033>,
<158.5,-3.33333,402.033>, <185.667,-3.33333,402.033>, <294.333,-3.33333,402.033>, <321.5,-3.33333,402.033>,
<158.5,3.33333,402.033>, <185.667,3.33333,402.033>, <294.333,3.33333,402.033>, <321.5,3.33333,402.033>,
<158.5,5,402.033>, <185.667,5,402.033>, <294.333,5,402.033>, <321.5,5,402.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,-5,402.033>, <158.5,-3.33333,402.033>, <158.5,3.33333,402.033>, <158.5,5,402.033>,
<158.5,-5,387.033>, <158.5,-3.33333,387.033>, <158.5,3.33333,387.033>, <158.5,5,387.033>,
<158.5,-5,327.033>, <158.5,-3.33333,327.033>, <158.5,3.33333,327.033>, <158.5,5,327.033>,
<158.5,-5,312.033>, <158.5,-3.33333,312.033>, <158.5,3.33333,312.033>, <158.5,5,312.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<158.5,-5,312.033>, <158.5,-3.33333,312.033>, <158.5,3.33333,312.033>, <158.5,5,312.033>,
<185.667,-5,312.033>, <185.667,-3.33333,312.033>, <185.667,3.33333,312.033>, <185.667,5,312.033>,
<294.333,-5,312.033>, <294.333,-3.33333,312.033>, <294.333,3.33333,312.033>, <294.333,5,312.033>,
<321.5,-5,312.033>, <321.5,-3.33333,312.033>, <321.5,3.33333,312.033>, <321.5,5,312.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<321.5,-5,312.033>, <321.5,-3.33333,312.033>, <321.5,3.33333,312.033>, <321.5,5,312.033>,
<321.5,-5,327.033>, <321.5,-3.33333,327.033>, <321.5,3.33333,327.033>, <321.5,5,327.033>,
<321.5,-5,387.033>, <321.5,-3.33333,387.033>, <321.5,3.33333,387.033>, <321.5,5,387.033>,
<321.5,-5,402.033>, <321.5,-3.33333,402.033>, <321.5,3.33333,402.033>, <321.5,5,402.033>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<212,-4,313.033>, <212,-4,209.7>, <212,-4,-203.634>, <212,-4,-306.967>,
<211.667,-3.66667,313.033>, <211.667,-3.66667,209.7>, <211.667,-3.66667,-203.634>, <211.667,-3.66667,-306.967>,
<210.333,-2.33333,313.033>, <210.333,-2.33333,209.7>, <210.333,-2.33333,-203.634>, <210.333,-2.33333,-306.967>,
<210,-2,313.033>, <210,-2,209.7>, <210,-2,-203.634>, <210,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<210,2,313.033>, <210,1.33333,313.033>, <210,-1.33333,313.033>, <210,-2,313.033>,
<210,2,209.7>, <210,1.33333,209.7>, <210,-1.33333,209.7>, <210,-2,209.7>,
<210,2,-203.634>, <210,1.33333,-203.634>, <210,-1.33333,-203.634>, <210,-2,-203.634>,
<210,2,-306.967>, <210,1.33333,-306.967>, <210,-1.33333,-306.967>, <210,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<220,-4,313.033>, <220,-4,209.7>, <220,-4,-203.634>, <220,-4,-306.967>,
<218.667,-4,313.033>, <218.667,-4,209.7>, <218.667,-4,-203.634>, <218.667,-4,-306.967>,
<213.333,-4,313.033>, <213.333,-4,209.7>, <213.333,-4,-203.634>, <213.333,-4,-306.967>,
<212,-4,313.033>, <212,-4,209.7>, <212,-4,-203.634>, <212,-4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<222,-2,313.033>, <222,-2,209.7>, <222,-2,-203.634>, <222,-2,-306.967>,
<221.667,-2.33333,313.033>, <221.667,-2.33333,209.7>, <221.667,-2.33333,-203.634>, <221.667,-2.33333,-306.967>,
<220.333,-3.66667,313.033>, <220.333,-3.66667,209.7>, <220.333,-3.66667,-203.634>, <220.333,-3.66667,-306.967>,
<220,-4,313.033>, <220,-4,209.7>, <220,-4,-203.634>, <220,-4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<222,2,313.033>, <222,2,209.7>, <222,2,-203.634>, <222,2,-306.967>,
<222,1.33333,313.033>, <222,1.33333,209.7>, <222,1.33333,-203.634>, <222,1.33333,-306.967>,
<222,-1.33333,313.033>, <222,-1.33333,209.7>, <222,-1.33333,-203.634>, <222,-1.33333,-306.967>,
<222,-2,313.033>, <222,-2,209.7>, <222,-2,-203.634>, <222,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<220,4,313.033>, <220,4,209.7>, <220,4,-203.634>, <220,4,-306.967>,
<220.333,3.66667,313.033>, <220.333,3.66667,209.7>, <220.333,3.66667,-203.634>, <220.333,3.66667,-306.967>,
<221.667,2.33333,313.033>, <221.667,2.33333,209.7>, <221.667,2.33333,-203.634>, <221.667,2.33333,-306.967>,
<222,2,313.033>, <222,2,209.7>, <222,2,-203.634>, <222,2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<212,4,313.033>, <212,4,209.7>, <212,4,-203.634>, <212,4,-306.967>,
<213.333,4,313.033>, <213.333,4,209.7>, <213.333,4,-203.634>, <213.333,4,-306.967>,
<218.667,4,313.033>, <218.667,4,209.7>, <218.667,4,-203.634>, <218.667,4,-306.967>,
<220,4,313.033>, <220,4,209.7>, <220,4,-203.634>, <220,4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<210,2,313.033>, <210,2,209.7>, <210,2,-203.634>, <210,2,-306.967>,
<210.333,2.33333,313.033>, <210.333,2.33333,209.7>, <210.333,2.33333,-203.634>, <210.333,2.33333,-306.967>,
<211.667,3.66667,313.033>, <211.667,3.66667,209.7>, <211.667,3.66667,-203.634>, <211.667,3.66667,-306.967>,
<212,4,313.033>, <212,4,209.7>, <212,4,-203.634>, <212,4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<180,-4,313.033>, <180,-4,209.7>, <180,-4,-203.634>, <180,-4,-306.967>,
<179.667,-3.66667,313.033>, <179.667,-3.66667,209.7>, <179.667,-3.66667,-203.634>, <179.667,-3.66667,-306.967>,
<178.333,-2.33333,313.033>, <178.333,-2.33333,209.7>, <178.333,-2.33333,-203.634>, <178.333,-2.33333,-306.967>,
<178,-2,313.033>, <178,-2,209.7>, <178,-2,-203.634>, <178,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<178,2,313.033>, <178,1.33333,313.033>, <178,-1.33333,313.033>, <178,-2,313.033>,
<178,2,209.7>, <178,1.33333,209.7>, <178,-1.33333,209.7>, <178,-2,209.7>,
<178,2,-203.634>, <178,1.33333,-203.634>, <178,-1.33333,-203.634>, <178,-2,-203.634>,
<178,2,-306.967>, <178,1.33333,-306.967>, <178,-1.33333,-306.967>, <178,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<188,-4,313.033>, <188,-4,209.7>, <188,-4,-203.634>, <188,-4,-306.967>,
<186.667,-4,313.033>, <186.667,-4,209.7>, <186.667,-4,-203.634>, <186.667,-4,-306.967>,
<181.333,-4,313.033>, <181.333,-4,209.7>, <181.333,-4,-203.634>, <181.333,-4,-306.967>,
<180,-4,313.033>, <180,-4,209.7>, <180,-4,-203.634>, <180,-4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<190,-2,313.033>, <190,-2,209.7>, <190,-2,-203.634>, <190,-2,-306.967>,
<189.667,-2.33333,313.033>, <189.667,-2.33333,209.7>, <189.667,-2.33333,-203.634>, <189.667,-2.33333,-306.967>,
<188.333,-3.66667,313.033>, <188.333,-3.66667,209.7>, <188.333,-3.66667,-203.634>, <188.333,-3.66667,-306.967>,
<188,-4,313.033>, <188,-4,209.7>, <188,-4,-203.634>, <188,-4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<190,2,313.033>, <190,2,209.7>, <190,2,-203.634>, <190,2,-306.967>,
<190,1.33333,313.033>, <190,1.33333,209.7>, <190,1.33333,-203.634>, <190,1.33333,-306.967>,
<190,-1.33333,313.033>, <190,-1.33333,209.7>, <190,-1.33333,-203.634>, <190,-1.33333,-306.967>,
<190,-2,313.033>, <190,-2,209.7>, <190,-2,-203.634>, <190,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<188,4,313.033>, <188,4,209.7>, <188,4,-203.634>, <188,4,-306.967>,
<188.333,3.66667,313.033>, <188.333,3.66667,209.7>, <188.333,3.66667,-203.634>, <188.333,3.66667,-306.967>,
<189.667,2.33333,313.033>, <189.667,2.33333,209.7>, <189.667,2.33333,-203.634>, <189.667,2.33333,-306.967>,
<190,2,313.033>, <190,2,209.7>, <190,2,-203.634>, <190,2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<180,4,313.033>, <180,4,209.7>, <180,4,-203.634>, <180,4,-306.967>,
<181.333,4,313.033>, <181.333,4,209.7>, <181.333,4,-203.634>, <181.333,4,-306.967>,
<186.667,4,313.033>, <186.667,4,209.7>, <186.667,4,-203.634>, <186.667,4,-306.967>,
<188,4,313.033>, <188,4,209.7>, <188,4,-203.634>, <188,4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<178,2,313.033>, <178,2,209.7>, <178,2,-203.634>, <178,2,-306.967>,
<178.333,2.33333,313.033>, <178.333,2.33333,209.7>, <178.333,2.33333,-203.634>, <178.333,2.33333,-306.967>,
<179.667,3.66667,313.033>, <179.667,3.66667,209.7>, <179.667,3.66667,-203.634>, <179.667,3.66667,-306.967>,
<180,4,313.033>, <180,4,209.7>, <180,4,-203.634>, <180,4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<228,-4,313.033>, <228,-4,209.7>, <228,-4,-203.634>, <228,-4,-306.967>,
<227.667,-3.66667,313.033>, <227.667,-3.66667,209.7>, <227.667,-3.66667,-203.634>, <227.667,-3.66667,-306.967>,
<226.333,-2.33333,313.033>, <226.333,-2.33333,209.7>, <226.333,-2.33333,-203.634>, <226.333,-2.33333,-306.967>,
<226,-2,313.033>, <226,-2,209.7>, <226,-2,-203.634>, <226,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<226,2,313.033>, <226,1.33333,313.033>, <226,-1.33333,313.033>, <226,-2,313.033>,
<226,2,209.7>, <226,1.33333,209.7>, <226,-1.33333,209.7>, <226,-2,209.7>,
<226,2,-203.634>, <226,1.33333,-203.634>, <226,-1.33333,-203.634>, <226,-2,-203.634>,
<226,2,-306.967>, <226,1.33333,-306.967>, <226,-1.33333,-306.967>, <226,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<236,-4,313.033>, <236,-4,209.7>, <236,-4,-203.634>, <236,-4,-306.967>,
<234.667,-4,313.033>, <234.667,-4,209.7>, <234.667,-4,-203.634>, <234.667,-4,-306.967>,
<229.333,-4,313.033>, <229.333,-4,209.7>, <229.333,-4,-203.634>, <229.333,-4,-306.967>,
<228,-4,313.033>, <228,-4,209.7>, <228,-4,-203.634>, <228,-4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<238,-2,313.033>, <238,-2,209.7>, <238,-2,-203.634>, <238,-2,-306.967>,
<237.667,-2.33333,313.033>, <237.667,-2.33333,209.7>, <237.667,-2.33333,-203.634>, <237.667,-2.33333,-306.967>,
<236.333,-3.66667,313.033>, <236.333,-3.66667,209.7>, <236.333,-3.66667,-203.634>, <236.333,-3.66667,-306.967>,
<236,-4,313.033>, <236,-4,209.7>, <236,-4,-203.634>, <236,-4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<238,2,313.033>, <238,2,209.7>, <238,2,-203.634>, <238,2,-306.967>,
<238,1.33333,313.033>, <238,1.33333,209.7>, <238,1.33333,-203.634>, <238,1.33333,-306.967>,
<238,-1.33333,313.033>, <238,-1.33333,209.7>, <238,-1.33333,-203.634>, <238,-1.33333,-306.967>,
<238,-2,313.033>, <238,-2,209.7>, <238,-2,-203.634>, <238,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<236,4,313.033>, <236,4,209.7>, <236,4,-203.634>, <236,4,-306.967>,
<236.333,3.66667,313.033>, <236.333,3.66667,209.7>, <236.333,3.66667,-203.634>, <236.333,3.66667,-306.967>,
<237.667,2.33333,313.033>, <237.667,2.33333,209.7>, <237.667,2.33333,-203.634>, <237.667,2.33333,-306.967>,
<238,2,313.033>, <238,2,209.7>, <238,2,-203.634>, <238,2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<228,4,313.033>, <228,4,209.7>, <228,4,-203.634>, <228,4,-306.967>,
<229.333,4,313.033>, <229.333,4,209.7>, <229.333,4,-203.634>, <229.333,4,-306.967>,
<234.667,4,313.033>, <234.667,4,209.7>, <234.667,4,-203.634>, <234.667,4,-306.967>,
<236,4,313.033>, <236,4,209.7>, <236,4,-203.634>, <236,4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<226,2,313.033>, <226,2,209.7>, <226,2,-203.634>, <226,2,-306.967>,
<226.333,2.33333,313.033>, <226.333,2.33333,209.7>, <226.333,2.33333,-203.634>, <226.333,2.33333,-306.967>,
<227.667,3.66667,313.033>, <227.667,3.66667,209.7>, <227.667,3.66667,-203.634>, <227.667,3.66667,-306.967>,
<228,4,313.033>, <228,4,209.7>, <228,4,-203.634>, <228,4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<164,-4,313.033>, <164,-4,209.7>, <164,-4,-203.634>, <164,-4,-306.967>,
<163.667,-3.66667,313.033>, <163.667,-3.66667,209.7>, <163.667,-3.66667,-203.634>, <163.667,-3.66667,-306.967>,
<162.333,-2.33333,313.033>, <162.333,-2.33333,209.7>, <162.333,-2.33333,-203.634>, <162.333,-2.33333,-306.967>,
<162,-2,313.033>, <162,-2,209.7>, <162,-2,-203.634>, <162,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<162,2,313.033>, <162,1.33333,313.033>, <162,-1.33333,313.033>, <162,-2,313.033>,
<162,2,209.7>, <162,1.33333,209.7>, <162,-1.33333,209.7>, <162,-2,209.7>,
<162,2,-203.634>, <162,1.33333,-203.634>, <162,-1.33333,-203.634>, <162,-2,-203.634>,
<162,2,-306.967>, <162,1.33333,-306.967>, <162,-1.33333,-306.967>, <162,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<172,-4,313.033>, <172,-4,209.7>, <172,-4,-203.634>, <172,-4,-306.967>,
<170.667,-4,313.033>, <170.667,-4,209.7>, <170.667,-4,-203.634>, <170.667,-4,-306.967>,
<165.333,-4,313.033>, <165.333,-4,209.7>, <165.333,-4,-203.634>, <165.333,-4,-306.967>,
<164,-4,313.033>, <164,-4,209.7>, <164,-4,-203.634>, <164,-4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<174,-2,313.033>, <174,-2,209.7>, <174,-2,-203.634>, <174,-2,-306.967>,
<173.667,-2.33333,313.033>, <173.667,-2.33333,209.7>, <173.667,-2.33333,-203.634>, <173.667,-2.33333,-306.967>,
<172.333,-3.66667,313.033>, <172.333,-3.66667,209.7>, <172.333,-3.66667,-203.634>, <172.333,-3.66667,-306.967>,
<172,-4,313.033>, <172,-4,209.7>, <172,-4,-203.634>, <172,-4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<174,2,313.033>, <174,2,209.7>, <174,2,-203.634>, <174,2,-306.967>,
<174,1.33333,313.033>, <174,1.33333,209.7>, <174,1.33333,-203.634>, <174,1.33333,-306.967>,
<174,-1.33333,313.033>, <174,-1.33333,209.7>, <174,-1.33333,-203.634>, <174,-1.33333,-306.967>,
<174,-2,313.033>, <174,-2,209.7>, <174,-2,-203.634>, <174,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<172,4,313.033>, <172,4,209.7>, <172,4,-203.634>, <172,4,-306.967>,
<172.333,3.66667,313.033>, <172.333,3.66667,209.7>, <172.333,3.66667,-203.634>, <172.333,3.66667,-306.967>,
<173.667,2.33333,313.033>, <173.667,2.33333,209.7>, <173.667,2.33333,-203.634>, <173.667,2.33333,-306.967>,
<174,2,313.033>, <174,2,209.7>, <174,2,-203.634>, <174,2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<164,4,313.033>, <164,4,209.7>, <164,4,-203.634>, <164,4,-306.967>,
<165.333,4,313.033>, <165.333,4,209.7>, <165.333,4,-203.634>, <165.333,4,-306.967>,
<170.667,4,313.033>, <170.667,4,209.7>, <170.667,4,-203.634>, <170.667,4,-306.967>,
<172,4,313.033>, <172,4,209.7>, <172,4,-203.634>, <172,4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<162,2,313.033>, <162,2,209.7>, <162,2,-203.634>, <162,2,-306.967>,
<162.333,2.33333,313.033>, <162.333,2.33333,209.7>, <162.333,2.33333,-203.634>, <162.333,2.33333,-306.967>,
<163.667,3.66667,313.033>, <163.667,3.66667,209.7>, <163.667,3.66667,-203.634>, <163.667,3.66667,-306.967>,
<164,4,313.033>, <164,4,209.7>, <164,4,-203.634>, <164,4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<196,-4,313.033>, <196,-4,209.7>, <196,-4,-203.634>, <196,-4,-306.967>,
<195.667,-3.66667,313.033>, <195.667,-3.66667,209.7>, <195.667,-3.66667,-203.634>, <195.667,-3.66667,-306.967>,
<194.333,-2.33333,313.033>, <194.333,-2.33333,209.7>, <194.333,-2.33333,-203.634>, <194.333,-2.33333,-306.967>,
<194,-2,313.033>, <194,-2,209.7>, <194,-2,-203.634>, <194,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<194,2,313.033>, <194,1.33333,313.033>, <194,-1.33333,313.033>, <194,-2,313.033>,
<194,2,209.7>, <194,1.33333,209.7>, <194,-1.33333,209.7>, <194,-2,209.7>,
<194,2,-203.634>, <194,1.33333,-203.634>, <194,-1.33333,-203.634>, <194,-2,-203.634>,
<194,2,-306.967>, <194,1.33333,-306.967>, <194,-1.33333,-306.967>, <194,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<204,-4,313.033>, <204,-4,209.7>, <204,-4,-203.634>, <204,-4,-306.967>,
<202.667,-4,313.033>, <202.667,-4,209.7>, <202.667,-4,-203.634>, <202.667,-4,-306.967>,
<197.333,-4,313.033>, <197.333,-4,209.7>, <197.333,-4,-203.634>, <197.333,-4,-306.967>,
<196,-4,313.033>, <196,-4,209.7>, <196,-4,-203.634>, <196,-4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<206,-2,313.033>, <206,-2,209.7>, <206,-2,-203.634>, <206,-2,-306.967>,
<205.667,-2.33333,313.033>, <205.667,-2.33333,209.7>, <205.667,-2.33333,-203.634>, <205.667,-2.33333,-306.967>,
<204.333,-3.66667,313.033>, <204.333,-3.66667,209.7>, <204.333,-3.66667,-203.634>, <204.333,-3.66667,-306.967>,
<204,-4,313.033>, <204,-4,209.7>, <204,-4,-203.634>, <204,-4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<206,2,313.033>, <206,2,209.7>, <206,2,-203.634>, <206,2,-306.967>,
<206,1.33333,313.033>, <206,1.33333,209.7>, <206,1.33333,-203.634>, <206,1.33333,-306.967>,
<206,-1.33333,313.033>, <206,-1.33333,209.7>, <206,-1.33333,-203.634>, <206,-1.33333,-306.967>,
<206,-2,313.033>, <206,-2,209.7>, <206,-2,-203.634>, <206,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<204,4,313.033>, <204,4,209.7>, <204,4,-203.634>, <204,4,-306.967>,
<204.333,3.66667,313.033>, <204.333,3.66667,209.7>, <204.333,3.66667,-203.634>, <204.333,3.66667,-306.967>,
<205.667,2.33333,313.033>, <205.667,2.33333,209.7>, <205.667,2.33333,-203.634>, <205.667,2.33333,-306.967>,
<206,2,313.033>, <206,2,209.7>, <206,2,-203.634>, <206,2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<196,4,313.033>, <196,4,209.7>, <196,4,-203.634>, <196,4,-306.967>,
<197.333,4,313.033>, <197.333,4,209.7>, <197.333,4,-203.634>, <197.333,4,-306.967>,
<202.667,4,313.033>, <202.667,4,209.7>, <202.667,4,-203.634>, <202.667,4,-306.967>,
<204,4,313.033>, <204,4,209.7>, <204,4,-203.634>, <204,4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<194,2,313.033>, <194,2,209.7>, <194,2,-203.634>, <194,2,-306.967>,
<194.333,2.33333,313.033>, <194.333,2.33333,209.7>, <194.333,2.33333,-203.634>, <194.333,2.33333,-306.967>,
<195.667,3.66667,313.033>, <195.667,3.66667,209.7>, <195.667,3.66667,-203.634>, <195.667,3.66667,-306.967>,
<196,4,313.033>, <196,4,209.7>, <196,4,-203.634>, <196,4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<276,-4,313.033>, <276,-4,209.7>, <276,-4,-203.634>, <276,-4,-306.967>,
<275.667,-3.66667,313.033>, <275.667,-3.66667,209.7>, <275.667,-3.66667,-203.634>, <275.667,-3.66667,-306.967>,
<274.333,-2.33333,313.033>, <274.333,-2.33333,209.7>, <274.333,-2.33333,-203.634>, <274.333,-2.33333,-306.967>,
<274,-2,313.033>, <274,-2,209.7>, <274,-2,-203.634>, <274,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<274,2,313.033>, <274,1.33333,313.033>, <274,-1.33333,313.033>, <274,-2,313.033>,
<274,2,209.7>, <274,1.33333,209.7>, <274,-1.33333,209.7>, <274,-2,209.7>,
<274,2,-203.634>, <274,1.33333,-203.634>, <274,-1.33333,-203.634>, <274,-2,-203.634>,
<274,2,-306.967>, <274,1.33333,-306.967>, <274,-1.33333,-306.967>, <274,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<284,-4,313.033>, <284,-4,209.7>, <284,-4,-203.634>, <284,-4,-306.967>,
<282.667,-4,313.033>, <282.667,-4,209.7>, <282.667,-4,-203.634>, <282.667,-4,-306.967>,
<277.333,-4,313.033>, <277.333,-4,209.7>, <277.333,-4,-203.634>, <277.333,-4,-306.967>,
<276,-4,313.033>, <276,-4,209.7>, <276,-4,-203.634>, <276,-4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<286,-2,313.033>, <286,-2,209.7>, <286,-2,-203.634>, <286,-2,-306.967>,
<285.667,-2.33333,313.033>, <285.667,-2.33333,209.7>, <285.667,-2.33333,-203.634>, <285.667,-2.33333,-306.967>,
<284.333,-3.66667,313.033>, <284.333,-3.66667,209.7>, <284.333,-3.66667,-203.634>, <284.333,-3.66667,-306.967>,
<284,-4,313.033>, <284,-4,209.7>, <284,-4,-203.634>, <284,-4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<286,2,313.033>, <286,2,209.7>, <286,2,-203.634>, <286,2,-306.967>,
<286,1.33333,313.033>, <286,1.33333,209.7>, <286,1.33333,-203.634>, <286,1.33333,-306.967>,
<286,-1.33333,313.033>, <286,-1.33333,209.7>, <286,-1.33333,-203.634>, <286,-1.33333,-306.967>,
<286,-2,313.033>, <286,-2,209.7>, <286,-2,-203.634>, <286,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<284,4,313.033>, <284,4,209.7>, <284,4,-203.634>, <284,4,-306.967>,
<284.333,3.66667,313.033>, <284.333,3.66667,209.7>, <284.333,3.66667,-203.634>, <284.333,3.66667,-306.967>,
<285.667,2.33333,313.033>, <285.667,2.33333,209.7>, <285.667,2.33333,-203.634>, <285.667,2.33333,-306.967>,
<286,2,313.033>, <286,2,209.7>, <286,2,-203.634>, <286,2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<276,4,313.033>, <276,4,209.7>, <276,4,-203.634>, <276,4,-306.967>,
<277.333,4,313.033>, <277.333,4,209.7>, <277.333,4,-203.634>, <277.333,4,-306.967>,
<282.667,4,313.033>, <282.667,4,209.7>, <282.667,4,-203.634>, <282.667,4,-306.967>,
<284,4,313.033>, <284,4,209.7>, <284,4,-203.634>, <284,4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<274,2,313.033>, <274,2,209.7>, <274,2,-203.634>, <274,2,-306.967>,
<274.333,2.33333,313.033>, <274.333,2.33333,209.7>, <274.333,2.33333,-203.634>, <274.333,2.33333,-306.967>,
<275.667,3.66667,313.033>, <275.667,3.66667,209.7>, <275.667,3.66667,-203.634>, <275.667,3.66667,-306.967>,
<276,4,313.033>, <276,4,209.7>, <276,4,-203.634>, <276,4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<244,-4,313.033>, <244,-4,209.7>, <244,-4,-203.634>, <244,-4,-306.967>,
<243.667,-3.66667,313.033>, <243.667,-3.66667,209.7>, <243.667,-3.66667,-203.634>, <243.667,-3.66667,-306.967>,
<242.333,-2.33333,313.033>, <242.333,-2.33333,209.7>, <242.333,-2.33333,-203.634>, <242.333,-2.33333,-306.967>,
<242,-2,313.033>, <242,-2,209.7>, <242,-2,-203.634>, <242,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<242,2,313.033>, <242,1.33333,313.033>, <242,-1.33333,313.033>, <242,-2,313.033>,
<242,2,209.7>, <242,1.33333,209.7>, <242,-1.33333,209.7>, <242,-2,209.7>,
<242,2,-203.634>, <242,1.33333,-203.634>, <242,-1.33333,-203.634>, <242,-2,-203.634>,
<242,2,-306.967>, <242,1.33333,-306.967>, <242,-1.33333,-306.967>, <242,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<252,-4,313.033>, <252,-4,209.7>, <252,-4,-203.634>, <252,-4,-306.967>,
<250.667,-4,313.033>, <250.667,-4,209.7>, <250.667,-4,-203.634>, <250.667,-4,-306.967>,
<245.333,-4,313.033>, <245.333,-4,209.7>, <245.333,-4,-203.634>, <245.333,-4,-306.967>,
<244,-4,313.033>, <244,-4,209.7>, <244,-4,-203.634>, <244,-4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<254,-2,313.033>, <254,-2,209.7>, <254,-2,-203.634>, <254,-2,-306.967>,
<253.667,-2.33333,313.033>, <253.667,-2.33333,209.7>, <253.667,-2.33333,-203.634>, <253.667,-2.33333,-306.967>,
<252.333,-3.66667,313.033>, <252.333,-3.66667,209.7>, <252.333,-3.66667,-203.634>, <252.333,-3.66667,-306.967>,
<252,-4,313.033>, <252,-4,209.7>, <252,-4,-203.634>, <252,-4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<254,2,313.033>, <254,2,209.7>, <254,2,-203.634>, <254,2,-306.967>,
<254,1.33333,313.033>, <254,1.33333,209.7>, <254,1.33333,-203.634>, <254,1.33333,-306.967>,
<254,-1.33333,313.033>, <254,-1.33333,209.7>, <254,-1.33333,-203.634>, <254,-1.33333,-306.967>,
<254,-2,313.033>, <254,-2,209.7>, <254,-2,-203.634>, <254,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<252,4,313.033>, <252,4,209.7>, <252,4,-203.634>, <252,4,-306.967>,
<252.333,3.66667,313.033>, <252.333,3.66667,209.7>, <252.333,3.66667,-203.634>, <252.333,3.66667,-306.967>,
<253.667,2.33333,313.033>, <253.667,2.33333,209.7>, <253.667,2.33333,-203.634>, <253.667,2.33333,-306.967>,
<254,2,313.033>, <254,2,209.7>, <254,2,-203.634>, <254,2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<244,4,313.033>, <244,4,209.7>, <244,4,-203.634>, <244,4,-306.967>,
<245.333,4,313.033>, <245.333,4,209.7>, <245.333,4,-203.634>, <245.333,4,-306.967>,
<250.667,4,313.033>, <250.667,4,209.7>, <250.667,4,-203.634>, <250.667,4,-306.967>,
<252,4,313.033>, <252,4,209.7>, <252,4,-203.634>, <252,4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<242,2,313.033>, <242,2,209.7>, <242,2,-203.634>, <242,2,-306.967>,
<242.333,2.33333,313.033>, <242.333,2.33333,209.7>, <242.333,2.33333,-203.634>, <242.333,2.33333,-306.967>,
<243.667,3.66667,313.033>, <243.667,3.66667,209.7>, <243.667,3.66667,-203.634>, <243.667,3.66667,-306.967>,
<244,4,313.033>, <244,4,209.7>, <244,4,-203.634>, <244,4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<308,-4,313.033>, <308,-4,209.7>, <308,-4,-203.634>, <308,-4,-306.967>,
<307.667,-3.66667,313.033>, <307.667,-3.66667,209.7>, <307.667,-3.66667,-203.634>, <307.667,-3.66667,-306.967>,
<306.333,-2.33333,313.033>, <306.333,-2.33333,209.7>, <306.333,-2.33333,-203.634>, <306.333,-2.33333,-306.967>,
<306,-2,313.033>, <306,-2,209.7>, <306,-2,-203.634>, <306,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<306,2,313.033>, <306,1.33333,313.033>, <306,-1.33333,313.033>, <306,-2,313.033>,
<306,2,209.7>, <306,1.33333,209.7>, <306,-1.33333,209.7>, <306,-2,209.7>,
<306,2,-203.634>, <306,1.33333,-203.634>, <306,-1.33333,-203.634>, <306,-2,-203.634>,
<306,2,-306.967>, <306,1.33333,-306.967>, <306,-1.33333,-306.967>, <306,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<316,-4,313.033>, <316,-4,209.7>, <316,-4,-203.634>, <316,-4,-306.967>,
<314.667,-4,313.033>, <314.667,-4,209.7>, <314.667,-4,-203.634>, <314.667,-4,-306.967>,
<309.333,-4,313.033>, <309.333,-4,209.7>, <309.333,-4,-203.634>, <309.333,-4,-306.967>,
<308,-4,313.033>, <308,-4,209.7>, <308,-4,-203.634>, <308,-4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<318,-2,313.033>, <318,-2,209.7>, <318,-2,-203.634>, <318,-2,-306.967>,
<317.667,-2.33333,313.033>, <317.667,-2.33333,209.7>, <317.667,-2.33333,-203.634>, <317.667,-2.33333,-306.967>,
<316.333,-3.66667,313.033>, <316.333,-3.66667,209.7>, <316.333,-3.66667,-203.634>, <316.333,-3.66667,-306.967>,
<316,-4,313.033>, <316,-4,209.7>, <316,-4,-203.634>, <316,-4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<318,2,313.033>, <318,2,209.7>, <318,2,-203.634>, <318,2,-306.967>,
<318,1.33333,313.033>, <318,1.33333,209.7>, <318,1.33333,-203.634>, <318,1.33333,-306.967>,
<318,-1.33333,313.033>, <318,-1.33333,209.7>, <318,-1.33333,-203.634>, <318,-1.33333,-306.967>,
<318,-2,313.033>, <318,-2,209.7>, <318,-2,-203.634>, <318,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<316,4,313.033>, <316,4,209.7>, <316,4,-203.634>, <316,4,-306.967>,
<316.333,3.66667,313.033>, <316.333,3.66667,209.7>, <316.333,3.66667,-203.634>, <316.333,3.66667,-306.967>,
<317.667,2.33333,313.033>, <317.667,2.33333,209.7>, <317.667,2.33333,-203.634>, <317.667,2.33333,-306.967>,
<318,2,313.033>, <318,2,209.7>, <318,2,-203.634>, <318,2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<308,4,313.033>, <308,4,209.7>, <308,4,-203.634>, <308,4,-306.967>,
<309.333,4,313.033>, <309.333,4,209.7>, <309.333,4,-203.634>, <309.333,4,-306.967>,
<314.667,4,313.033>, <314.667,4,209.7>, <314.667,4,-203.634>, <314.667,4,-306.967>,
<316,4,313.033>, <316,4,209.7>, <316,4,-203.634>, <316,4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<306,2,313.033>, <306,2,209.7>, <306,2,-203.634>, <306,2,-306.967>,
<306.333,2.33333,313.033>, <306.333,2.33333,209.7>, <306.333,2.33333,-203.634>, <306.333,2.33333,-306.967>,
<307.667,3.66667,313.033>, <307.667,3.66667,209.7>, <307.667,3.66667,-203.634>, <307.667,3.66667,-306.967>,
<308,4,313.033>, <308,4,209.7>, <308,4,-203.634>, <308,4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<260,-4,313.033>, <260,-4,209.7>, <260,-4,-203.634>, <260,-4,-306.967>,
<259.667,-3.66667,313.033>, <259.667,-3.66667,209.7>, <259.667,-3.66667,-203.634>, <259.667,-3.66667,-306.967>,
<258.333,-2.33333,313.033>, <258.333,-2.33333,209.7>, <258.333,-2.33333,-203.634>, <258.333,-2.33333,-306.967>,
<258,-2,313.033>, <258,-2,209.7>, <258,-2,-203.634>, <258,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<258,2,313.033>, <258,1.33333,313.033>, <258,-1.33333,313.033>, <258,-2,313.033>,
<258,2,209.7>, <258,1.33333,209.7>, <258,-1.33333,209.7>, <258,-2,209.7>,
<258,2,-203.634>, <258,1.33333,-203.634>, <258,-1.33333,-203.634>, <258,-2,-203.634>,
<258,2,-306.967>, <258,1.33333,-306.967>, <258,-1.33333,-306.967>, <258,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<268,-4,313.033>, <268,-4,209.7>, <268,-4,-203.634>, <268,-4,-306.967>,
<266.667,-4,313.033>, <266.667,-4,209.7>, <266.667,-4,-203.634>, <266.667,-4,-306.967>,
<261.333,-4,313.033>, <261.333,-4,209.7>, <261.333,-4,-203.634>, <261.333,-4,-306.967>,
<260,-4,313.033>, <260,-4,209.7>, <260,-4,-203.634>, <260,-4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<270,-2,313.033>, <270,-2,209.7>, <270,-2,-203.634>, <270,-2,-306.967>,
<269.667,-2.33333,313.033>, <269.667,-2.33333,209.7>, <269.667,-2.33333,-203.634>, <269.667,-2.33333,-306.967>,
<268.333,-3.66667,313.033>, <268.333,-3.66667,209.7>, <268.333,-3.66667,-203.634>, <268.333,-3.66667,-306.967>,
<268,-4,313.033>, <268,-4,209.7>, <268,-4,-203.634>, <268,-4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<270,2,313.033>, <270,2,209.7>, <270,2,-203.634>, <270,2,-306.967>,
<270,1.33333,313.033>, <270,1.33333,209.7>, <270,1.33333,-203.634>, <270,1.33333,-306.967>,
<270,-1.33333,313.033>, <270,-1.33333,209.7>, <270,-1.33333,-203.634>, <270,-1.33333,-306.967>,
<270,-2,313.033>, <270,-2,209.7>, <270,-2,-203.634>, <270,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<268,4,313.033>, <268,4,209.7>, <268,4,-203.634>, <268,4,-306.967>,
<268.333,3.66667,313.033>, <268.333,3.66667,209.7>, <268.333,3.66667,-203.634>, <268.333,3.66667,-306.967>,
<269.667,2.33333,313.033>, <269.667,2.33333,209.7>, <269.667,2.33333,-203.634>, <269.667,2.33333,-306.967>,
<270,2,313.033>, <270,2,209.7>, <270,2,-203.634>, <270,2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<260,4,313.033>, <260,4,209.7>, <260,4,-203.634>, <260,4,-306.967>,
<261.333,4,313.033>, <261.333,4,209.7>, <261.333,4,-203.634>, <261.333,4,-306.967>,
<266.667,4,313.033>, <266.667,4,209.7>, <266.667,4,-203.634>, <266.667,4,-306.967>,
<268,4,313.033>, <268,4,209.7>, <268,4,-203.634>, <268,4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<258,2,313.033>, <258,2,209.7>, <258,2,-203.634>, <258,2,-306.967>,
<258.333,2.33333,313.033>, <258.333,2.33333,209.7>, <258.333,2.33333,-203.634>, <258.333,2.33333,-306.967>,
<259.667,3.66667,313.033>, <259.667,3.66667,209.7>, <259.667,3.66667,-203.634>, <259.667,3.66667,-306.967>,
<260,4,313.033>, <260,4,209.7>, <260,4,-203.634>, <260,4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<292,-4,313.033>, <292,-4,209.7>, <292,-4,-203.634>, <292,-4,-306.967>,
<291.667,-3.66667,313.033>, <291.667,-3.66667,209.7>, <291.667,-3.66667,-203.634>, <291.667,-3.66667,-306.967>,
<290.333,-2.33333,313.033>, <290.333,-2.33333,209.7>, <290.333,-2.33333,-203.634>, <290.333,-2.33333,-306.967>,
<290,-2,313.033>, <290,-2,209.7>, <290,-2,-203.634>, <290,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<290,2,313.033>, <290,1.33333,313.033>, <290,-1.33333,313.033>, <290,-2,313.033>,
<290,2,209.7>, <290,1.33333,209.7>, <290,-1.33333,209.7>, <290,-2,209.7>,
<290,2,-203.634>, <290,1.33333,-203.634>, <290,-1.33333,-203.634>, <290,-2,-203.634>,
<290,2,-306.967>, <290,1.33333,-306.967>, <290,-1.33333,-306.967>, <290,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<300,-4,313.033>, <300,-4,209.7>, <300,-4,-203.634>, <300,-4,-306.967>,
<298.667,-4,313.033>, <298.667,-4,209.7>, <298.667,-4,-203.634>, <298.667,-4,-306.967>,
<293.333,-4,313.033>, <293.333,-4,209.7>, <293.333,-4,-203.634>, <293.333,-4,-306.967>,
<292,-4,313.033>, <292,-4,209.7>, <292,-4,-203.634>, <292,-4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<302,-2,313.033>, <302,-2,209.7>, <302,-2,-203.634>, <302,-2,-306.967>,
<301.667,-2.33333,313.033>, <301.667,-2.33333,209.7>, <301.667,-2.33333,-203.634>, <301.667,-2.33333,-306.967>,
<300.333,-3.66667,313.033>, <300.333,-3.66667,209.7>, <300.333,-3.66667,-203.634>, <300.333,-3.66667,-306.967>,
<300,-4,313.033>, <300,-4,209.7>, <300,-4,-203.634>, <300,-4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<302,2,313.033>, <302,2,209.7>, <302,2,-203.634>, <302,2,-306.967>,
<302,1.33333,313.033>, <302,1.33333,209.7>, <302,1.33333,-203.634>, <302,1.33333,-306.967>,
<302,-1.33333,313.033>, <302,-1.33333,209.7>, <302,-1.33333,-203.634>, <302,-1.33333,-306.967>,
<302,-2,313.033>, <302,-2,209.7>, <302,-2,-203.634>, <302,-2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<300,4,313.033>, <300,4,209.7>, <300,4,-203.634>, <300,4,-306.967>,
<300.333,3.66667,313.033>, <300.333,3.66667,209.7>, <300.333,3.66667,-203.634>, <300.333,3.66667,-306.967>,
<301.667,2.33333,313.033>, <301.667,2.33333,209.7>, <301.667,2.33333,-203.634>, <301.667,2.33333,-306.967>,
<302,2,313.033>, <302,2,209.7>, <302,2,-203.634>, <302,2,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<292,4,313.033>, <292,4,209.7>, <292,4,-203.634>, <292,4,-306.967>,
<293.333,4,313.033>, <293.333,4,209.7>, <293.333,4,-203.634>, <293.333,4,-306.967>,
<298.667,4,313.033>, <298.667,4,209.7>, <298.667,4,-203.634>, <298.667,4,-306.967>,
<300,4,313.033>, <300,4,209.7>, <300,4,-203.634>, <300,4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<290,2,313.033>, <290,2,209.7>, <290,2,-203.634>, <290,2,-306.967>,
<290.333,2.33333,313.033>, <290.333,2.33333,209.7>, <290.333,2.33333,-203.634>, <290.333,2.33333,-306.967>,
<291.667,3.66667,313.033>, <291.667,3.66667,209.7>, <291.667,3.66667,-203.634>, <291.667,3.66667,-306.967>,
<292,4,313.033>, <292,4,209.7>, <292,4,-203.634>, <292,4,-306.967>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-110,15,-400>, <-110,10,-400>, <-110,-10,-400>, <-110,-15,-400>,
<-110.833,14.1667,-400>, <-110.833,9.72222,-400>, <-110.833,-9.72222,-400>, <-110.833,-14.1667,-400>,
<-114.167,10.8333,-400>, <-114.167,6.94444,-400>, <-114.167,-6.94444,-400>, <-114.167,-10.8333,-400>,
<-115,10,-400>, <-115,6.66667,-400>, <-115,-6.66667,-400>, <-115,-10,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-110,15,-400>, <-110.833,14.1667,-400>, <-114.167,10.8333,-400>, <-115,10,-400>,
<-110,15,-266.667>, <-110.833,14.1667,-266.667>, <-114.167,10.8333,-266.667>, <-115,10,-266.667>,
<-110,15,266.667>, <-110.833,14.1667,266.667>, <-114.167,10.8333,266.667>, <-115,10,266.667>,
<-110,15,400>, <-110.833,14.1667,400>, <-114.167,10.8333,400>, <-115,10,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-110,15,-400>, <-106.667,15,-400>, <-93.3333,15,-400>, <-90,15,-400>,
<-110,10,-400>, <-106.667,10,-400>, <-93.3333,10,-400>, <-90,10,-400>,
<-110,-10,-400>, <-106.667,-10,-400>, <-93.3333,-10,-400>, <-90,-10,-400>,
<-110,-15,-400>, <-106.667,-15,-400>, <-93.3333,-15,-400>, <-90,-15,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-110,15,-400>, <-110,15,-266.667>, <-110,15,266.667>, <-110,15,400>,
<-106.667,15,-400>, <-106.667,15,-266.667>, <-106.667,15,266.667>, <-106.667,15,400>,
<-93.3333,15,-400>, <-93.3333,15,-266.667>, <-93.3333,15,266.667>, <-93.3333,15,400>,
<-90,15,-400>, <-90,15,-266.667>, <-90,15,266.667>, <-90,15,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-90,15,-400>, <-89.1667,14.1667,-400>, <-85.8333,10.8333,-400>, <-85,10,-400>,
<-90,10,-400>, <-89.1667,9.72222,-400>, <-85.8333,6.94444,-400>, <-85,6.66667,-400>,
<-90,-10,-400>, <-89.1667,-9.72222,-400>, <-85.8333,-6.94444,-400>, <-85,-6.66667,-400>,
<-90,-15,-400>, <-89.1667,-14.1667,-400>, <-85.8333,-10.8333,-400>, <-85,-10,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-90,15,-400>, <-90,15,-266.667>, <-90,15,266.667>, <-90,15,400>,
<-89.1667,14.1667,-400>, <-89.1667,14.1667,-266.667>, <-89.1667,14.1667,266.667>, <-89.1667,14.1667,400>,
<-85.8333,10.8333,-400>, <-85.8333,10.8333,-266.667>, <-85.8333,10.8333,266.667>, <-85.8333,10.8333,400>,
<-85,10,-400>, <-85,10,-266.667>, <-85,10,266.667>, <-85,10,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-85,10,-400>, <-85,10,-266.667>, <-85,10,266.667>, <-85,10,400>,
<-85,6.66667,-400>, <-85,6.66667,-266.667>, <-85,6.66667,266.667>, <-85,6.66667,400>,
<-85,-6.66667,-400>, <-85,-6.66667,-266.667>, <-85,-6.66667,266.667>, <-85,-6.66667,400>,
<-85,-10,-400>, <-85,-10,-266.667>, <-85,-10,266.667>, <-85,-10,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-85,-10,-400>, <-85,-10,-266.667>, <-85,-10,266.667>, <-85,-10,400>,
<-85.8333,-10.8333,-400>, <-85.8333,-10.8333,-266.667>, <-85.8333,-10.8333,266.667>, <-85.8333,-10.8333,400>,
<-89.1667,-14.1667,-400>, <-89.1667,-14.1667,-266.667>, <-89.1667,-14.1667,266.667>, <-89.1667,-14.1667,400>,
<-90,-15,-400>, <-90,-15,-266.667>, <-90,-15,266.667>, <-90,-15,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-90,-15,-400>, <-90,-15,-266.667>, <-90,-15,266.667>, <-90,-15,400>,
<-93.3333,-15,-400>, <-93.3333,-15,-266.667>, <-93.3333,-15,266.667>, <-93.3333,-15,400>,
<-106.667,-15,-400>, <-106.667,-15,-266.667>, <-106.667,-15,266.667>, <-106.667,-15,400>,
<-110,-15,-400>, <-110,-15,-266.667>, <-110,-15,266.667>, <-110,-15,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-110,-15,-400>, <-110,-15,-266.667>, <-110,-15,266.667>, <-110,-15,400>,
<-110.833,-14.1667,-400>, <-110.833,-14.1667,-266.667>, <-110.833,-14.1667,266.667>, <-110.833,-14.1667,400>,
<-114.167,-10.8333,-400>, <-114.167,-10.8333,-266.667>, <-114.167,-10.8333,266.667>, <-114.167,-10.8333,400>,
<-115,-10,-400>, <-115,-10,-266.667>, <-115,-10,266.667>, <-115,-10,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-115,-10,-400>, <-115,-10,-266.667>, <-115,-10,266.667>, <-115,-10,400>,
<-115,-6.66667,-400>, <-115,-6.66667,-266.667>, <-115,-6.66667,266.667>, <-115,-6.66667,400>,
<-115,6.66667,-400>, <-115,6.66667,-266.667>, <-115,6.66667,266.667>, <-115,6.66667,400>,
<-115,10,-400>, <-115,10,-266.667>, <-115,10,266.667>, <-115,10,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,5,309>, <-81.5,3.33333,309>, <-81.5,-3.33333,309>, <-81.5,-5,309>,
<-81.5,5,324>, <-81.5,3.33333,324>, <-81.5,-3.33333,324>, <-81.5,-5,324>,
<-81.5,5,384>, <-81.5,3.33333,384>, <-81.5,-3.33333,384>, <-81.5,-5,384>,
<-81.5,5,399>, <-81.5,3.33333,399>, <-81.5,-3.33333,399>, <-81.5,-5,399>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,5,309>, <-54.3333,5,309>, <54.3333,5,309>, <81.5,5,309>,
<-81.5,3.33333,309>, <-54.3333,3.33333,309>, <54.3333,3.33333,309>, <81.5,3.33333,309>,
<-81.5,-3.33333,309>, <-54.3333,-3.33333,309>, <54.3333,-3.33333,309>, <81.5,-3.33333,309>,
<-81.5,-5,309>, <-54.3333,-5,309>, <54.3333,-5,309>, <81.5,-5,309>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<81.5,5,309>, <81.5,5,324>, <81.5,5,384>, <81.5,5,399>,
<81.5,3.33333,309>, <81.5,3.33333,324>, <81.5,3.33333,384>, <81.5,3.33333,399>,
<81.5,-3.33333,309>, <81.5,-3.33333,324>, <81.5,-3.33333,384>, <81.5,-3.33333,399>,
<81.5,-5,309>, <81.5,-5,324>, <81.5,-5,384>, <81.5,-5,399>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<81.5,5,399>, <54.3333,5,399>, <-54.3333,5,399>, <-81.5,5,399>,
<81.5,3.33333,399>, <54.3333,3.33333,399>, <-54.3333,3.33333,399>, <-81.5,3.33333,399>,
<81.5,-3.33333,399>, <54.3333,-3.33333,399>, <-54.3333,-3.33333,399>, <-81.5,-3.33333,399>,
<81.5,-5,399>, <54.3333,-5,399>, <-54.3333,-5,399>, <-81.5,-5,399>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<50,2,-310>, <50,2,-206.667>, <50,2,206.667>, <50,2,310>,
<50,1.33333,-310>, <50,1.33333,-206.667>, <50,1.33333,206.667>, <50,1.33333,310>,
<50,-1.33333,-310>, <50,-1.33333,-206.667>, <50,-1.33333,206.667>, <50,-1.33333,310>,
<50,-2,-310>, <50,-2,-206.667>, <50,-2,206.667>, <50,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<50,2,-310>, <50.3333,2.33333,-310>, <51.6667,3.66667,-310>, <52,4,-310>,
<50,2,-206.667>, <50.3333,2.33333,-206.667>, <51.6667,3.66667,-206.667>, <52,4,-206.667>,
<50,2,206.667>, <50.3333,2.33333,206.667>, <51.6667,3.66667,206.667>, <52,4,206.667>,
<50,2,310>, <50.3333,2.33333,310>, <51.6667,3.66667,310>, <52,4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<52,4,-310>, <53.3333,4,-310>, <58.6667,4,-310>, <60,4,-310>,
<52,4,-206.667>, <53.3333,4,-206.667>, <58.6667,4,-206.667>, <60,4,-206.667>,
<52,4,206.667>, <53.3333,4,206.667>, <58.6667,4,206.667>, <60,4,206.667>,
<52,4,310>, <53.3333,4,310>, <58.6667,4,310>, <60,4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<60,4,-310>, <60.3333,3.66667,-310>, <61.6667,2.33333,-310>, <62,2,-310>,
<60,4,-206.667>, <60.3333,3.66667,-206.667>, <61.6667,2.33333,-206.667>, <62,2,-206.667>,
<60,4,206.667>, <60.3333,3.66667,206.667>, <61.6667,2.33333,206.667>, <62,2,206.667>,
<60,4,310>, <60.3333,3.66667,310>, <61.6667,2.33333,310>, <62,2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<62,2,-310>, <62,1.33333,-310>, <62,-1.33333,-310>, <62,-2,-310>,
<62,2,-206.667>, <62,1.33333,-206.667>, <62,-1.33333,-206.667>, <62,-2,-206.667>,
<62,2,206.667>, <62,1.33333,206.667>, <62,-1.33333,206.667>, <62,-2,206.667>,
<62,2,310>, <62,1.33333,310>, <62,-1.33333,310>, <62,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<62,-2,-310>, <61.6667,-2.33333,-310>, <60.3333,-3.66667,-310>, <60,-4,-310>,
<62,-2,-206.667>, <61.6667,-2.33333,-206.667>, <60.3333,-3.66667,-206.667>, <60,-4,-206.667>,
<62,-2,206.667>, <61.6667,-2.33333,206.667>, <60.3333,-3.66667,206.667>, <60,-4,206.667>,
<62,-2,310>, <61.6667,-2.33333,310>, <60.3333,-3.66667,310>, <60,-4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<60,-4,-310>, <58.6667,-4,-310>, <53.3333,-4,-310>, <52,-4,-310>,
<60,-4,-206.667>, <58.6667,-4,-206.667>, <53.3333,-4,-206.667>, <52,-4,-206.667>,
<60,-4,206.667>, <58.6667,-4,206.667>, <53.3333,-4,206.667>, <52,-4,206.667>,
<60,-4,310>, <58.6667,-4,310>, <53.3333,-4,310>, <52,-4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<52,-4,-310>, <51.6667,-3.66667,-310>, <50.3333,-2.33333,-310>, <50,-2,-310>,
<52,-4,-206.667>, <51.6667,-3.66667,-206.667>, <50.3333,-2.33333,-206.667>, <50,-2,-206.667>,
<52,-4,206.667>, <51.6667,-3.66667,206.667>, <50.3333,-2.33333,206.667>, <50,-2,206.667>,
<52,-4,310>, <51.6667,-3.66667,310>, <50.3333,-2.33333,310>, <50,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<18,2,-310>, <18,2,-206.667>, <18,2,206.667>, <18,2,310>,
<18,1.33333,-310>, <18,1.33333,-206.667>, <18,1.33333,206.667>, <18,1.33333,310>,
<18,-1.33333,-310>, <18,-1.33333,-206.667>, <18,-1.33333,206.667>, <18,-1.33333,310>,
<18,-2,-310>, <18,-2,-206.667>, <18,-2,206.667>, <18,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<18,2,-310>, <18.3333,2.33333,-310>, <19.6667,3.66667,-310>, <20,4,-310>,
<18,2,-206.667>, <18.3333,2.33333,-206.667>, <19.6667,3.66667,-206.667>, <20,4,-206.667>,
<18,2,206.667>, <18.3333,2.33333,206.667>, <19.6667,3.66667,206.667>, <20,4,206.667>,
<18,2,310>, <18.3333,2.33333,310>, <19.6667,3.66667,310>, <20,4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<20,4,-310>, <21.3333,4,-310>, <26.6667,4,-310>, <28,4,-310>,
<20,4,-206.667>, <21.3333,4,-206.667>, <26.6667,4,-206.667>, <28,4,-206.667>,
<20,4,206.667>, <21.3333,4,206.667>, <26.6667,4,206.667>, <28,4,206.667>,
<20,4,310>, <21.3333,4,310>, <26.6667,4,310>, <28,4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<28,4,-310>, <28.3333,3.66667,-310>, <29.6667,2.33333,-310>, <30,2,-310>,
<28,4,-206.667>, <28.3333,3.66667,-206.667>, <29.6667,2.33333,-206.667>, <30,2,-206.667>,
<28,4,206.667>, <28.3333,3.66667,206.667>, <29.6667,2.33333,206.667>, <30,2,206.667>,
<28,4,310>, <28.3333,3.66667,310>, <29.6667,2.33333,310>, <30,2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<30,2,-310>, <30,1.33333,-310>, <30,-1.33333,-310>, <30,-2,-310>,
<30,2,-206.667>, <30,1.33333,-206.667>, <30,-1.33333,-206.667>, <30,-2,-206.667>,
<30,2,206.667>, <30,1.33333,206.667>, <30,-1.33333,206.667>, <30,-2,206.667>,
<30,2,310>, <30,1.33333,310>, <30,-1.33333,310>, <30,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<30,-2,-310>, <29.6667,-2.33333,-310>, <28.3333,-3.66667,-310>, <28,-4,-310>,
<30,-2,-206.667>, <29.6667,-2.33333,-206.667>, <28.3333,-3.66667,-206.667>, <28,-4,-206.667>,
<30,-2,206.667>, <29.6667,-2.33333,206.667>, <28.3333,-3.66667,206.667>, <28,-4,206.667>,
<30,-2,310>, <29.6667,-2.33333,310>, <28.3333,-3.66667,310>, <28,-4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<28,-4,-310>, <26.6667,-4,-310>, <21.3333,-4,-310>, <20,-4,-310>,
<28,-4,-206.667>, <26.6667,-4,-206.667>, <21.3333,-4,-206.667>, <20,-4,-206.667>,
<28,-4,206.667>, <26.6667,-4,206.667>, <21.3333,-4,206.667>, <20,-4,206.667>,
<28,-4,310>, <26.6667,-4,310>, <21.3333,-4,310>, <20,-4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<20,-4,-310>, <19.6667,-3.66667,-310>, <18.3333,-2.33333,-310>, <18,-2,-310>,
<20,-4,-206.667>, <19.6667,-3.66667,-206.667>, <18.3333,-2.33333,-206.667>, <18,-2,-206.667>,
<20,-4,206.667>, <19.6667,-3.66667,206.667>, <18.3333,-2.33333,206.667>, <18,-2,206.667>,
<20,-4,310>, <19.6667,-3.66667,310>, <18.3333,-2.33333,310>, <18,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<66,2,-310>, <66,2,-206.667>, <66,2,206.667>, <66,2,310>,
<66,1.33333,-310>, <66,1.33333,-206.667>, <66,1.33333,206.667>, <66,1.33333,310>,
<66,-1.33333,-310>, <66,-1.33333,-206.667>, <66,-1.33333,206.667>, <66,-1.33333,310>,
<66,-2,-310>, <66,-2,-206.667>, <66,-2,206.667>, <66,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<66,2,-310>, <66.3333,2.33333,-310>, <67.6667,3.66667,-310>, <68,4,-310>,
<66,2,-206.667>, <66.3333,2.33333,-206.667>, <67.6667,3.66667,-206.667>, <68,4,-206.667>,
<66,2,206.667>, <66.3333,2.33333,206.667>, <67.6667,3.66667,206.667>, <68,4,206.667>,
<66,2,310>, <66.3333,2.33333,310>, <67.6667,3.66667,310>, <68,4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<68,4,-310>, <69.3333,4,-310>, <74.6667,4,-310>, <76,4,-310>,
<68,4,-206.667>, <69.3333,4,-206.667>, <74.6667,4,-206.667>, <76,4,-206.667>,
<68,4,206.667>, <69.3333,4,206.667>, <74.6667,4,206.667>, <76,4,206.667>,
<68,4,310>, <69.3333,4,310>, <74.6667,4,310>, <76,4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<76,4,-310>, <76.3333,3.66667,-310>, <77.6667,2.33333,-310>, <78,2,-310>,
<76,4,-206.667>, <76.3333,3.66667,-206.667>, <77.6667,2.33333,-206.667>, <78,2,-206.667>,
<76,4,206.667>, <76.3333,3.66667,206.667>, <77.6667,2.33333,206.667>, <78,2,206.667>,
<76,4,310>, <76.3333,3.66667,310>, <77.6667,2.33333,310>, <78,2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<78,2,-310>, <78,1.33333,-310>, <78,-1.33333,-310>, <78,-2,-310>,
<78,2,-206.667>, <78,1.33333,-206.667>, <78,-1.33333,-206.667>, <78,-2,-206.667>,
<78,2,206.667>, <78,1.33333,206.667>, <78,-1.33333,206.667>, <78,-2,206.667>,
<78,2,310>, <78,1.33333,310>, <78,-1.33333,310>, <78,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<78,-2,-310>, <77.6667,-2.33333,-310>, <76.3333,-3.66667,-310>, <76,-4,-310>,
<78,-2,-206.667>, <77.6667,-2.33333,-206.667>, <76.3333,-3.66667,-206.667>, <76,-4,-206.667>,
<78,-2,206.667>, <77.6667,-2.33333,206.667>, <76.3333,-3.66667,206.667>, <76,-4,206.667>,
<78,-2,310>, <77.6667,-2.33333,310>, <76.3333,-3.66667,310>, <76,-4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<76,-4,-310>, <74.6667,-4,-310>, <69.3333,-4,-310>, <68,-4,-310>,
<76,-4,-206.667>, <74.6667,-4,-206.667>, <69.3333,-4,-206.667>, <68,-4,-206.667>,
<76,-4,206.667>, <74.6667,-4,206.667>, <69.3333,-4,206.667>, <68,-4,206.667>,
<76,-4,310>, <74.6667,-4,310>, <69.3333,-4,310>, <68,-4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<68,-4,-310>, <67.6667,-3.66667,-310>, <66.3333,-2.33333,-310>, <66,-2,-310>,
<68,-4,-206.667>, <67.6667,-3.66667,-206.667>, <66.3333,-2.33333,-206.667>, <66,-2,-206.667>,
<68,-4,206.667>, <67.6667,-3.66667,206.667>, <66.3333,-2.33333,206.667>, <66,-2,206.667>,
<68,-4,310>, <67.6667,-3.66667,310>, <66.3333,-2.33333,310>, <66,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<2,2,-310>, <2,2,-206.667>, <2,2,206.667>, <2,2,310>,
<2,1.33333,-310>, <2,1.33333,-206.667>, <2,1.33333,206.667>, <2,1.33333,310>,
<2,-1.33333,-310>, <2,-1.33333,-206.667>, <2,-1.33333,206.667>, <2,-1.33333,310>,
<2,-2,-310>, <2,-2,-206.667>, <2,-2,206.667>, <2,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<2,2,-310>, <2.33333,2.33333,-310>, <3.66667,3.66667,-310>, <4,4,-310>,
<2,2,-206.667>, <2.33333,2.33333,-206.667>, <3.66667,3.66667,-206.667>, <4,4,-206.667>,
<2,2,206.667>, <2.33333,2.33333,206.667>, <3.66667,3.66667,206.667>, <4,4,206.667>,
<2,2,310>, <2.33333,2.33333,310>, <3.66667,3.66667,310>, <4,4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<4,4,-310>, <5.33333,4,-310>, <10.6667,4,-310>, <12,4,-310>,
<4,4,-206.667>, <5.33333,4,-206.667>, <10.6667,4,-206.667>, <12,4,-206.667>,
<4,4,206.667>, <5.33333,4,206.667>, <10.6667,4,206.667>, <12,4,206.667>,
<4,4,310>, <5.33333,4,310>, <10.6667,4,310>, <12,4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<12,4,-310>, <12.3333,3.66667,-310>, <13.6667,2.33333,-310>, <14,2,-310>,
<12,4,-206.667>, <12.3333,3.66667,-206.667>, <13.6667,2.33333,-206.667>, <14,2,-206.667>,
<12,4,206.667>, <12.3333,3.66667,206.667>, <13.6667,2.33333,206.667>, <14,2,206.667>,
<12,4,310>, <12.3333,3.66667,310>, <13.6667,2.33333,310>, <14,2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<14,2,-310>, <14,1.33333,-310>, <14,-1.33333,-310>, <14,-2,-310>,
<14,2,-206.667>, <14,1.33333,-206.667>, <14,-1.33333,-206.667>, <14,-2,-206.667>,
<14,2,206.667>, <14,1.33333,206.667>, <14,-1.33333,206.667>, <14,-2,206.667>,
<14,2,310>, <14,1.33333,310>, <14,-1.33333,310>, <14,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<14,-2,-310>, <13.6667,-2.33333,-310>, <12.3333,-3.66667,-310>, <12,-4,-310>,
<14,-2,-206.667>, <13.6667,-2.33333,-206.667>, <12.3333,-3.66667,-206.667>, <12,-4,-206.667>,
<14,-2,206.667>, <13.6667,-2.33333,206.667>, <12.3333,-3.66667,206.667>, <12,-4,206.667>,
<14,-2,310>, <13.6667,-2.33333,310>, <12.3333,-3.66667,310>, <12,-4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<12,-4,-310>, <10.6667,-4,-310>, <5.33333,-4,-310>, <4,-4,-310>,
<12,-4,-206.667>, <10.6667,-4,-206.667>, <5.33333,-4,-206.667>, <4,-4,-206.667>,
<12,-4,206.667>, <10.6667,-4,206.667>, <5.33333,-4,206.667>, <4,-4,206.667>,
<12,-4,310>, <10.6667,-4,310>, <5.33333,-4,310>, <4,-4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<4,-4,-310>, <3.66667,-3.66667,-310>, <2.33333,-2.33333,-310>, <2,-2,-310>,
<4,-4,-206.667>, <3.66667,-3.66667,-206.667>, <2.33333,-2.33333,-206.667>, <2,-2,-206.667>,
<4,-4,206.667>, <3.66667,-3.66667,206.667>, <2.33333,-2.33333,206.667>, <2,-2,206.667>,
<4,-4,310>, <3.66667,-3.66667,310>, <2.33333,-2.33333,310>, <2,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<34,2,-310>, <34,2,-206.667>, <34,2,206.667>, <34,2,310>,
<34,1.33333,-310>, <34,1.33333,-206.667>, <34,1.33333,206.667>, <34,1.33333,310>,
<34,-1.33333,-310>, <34,-1.33333,-206.667>, <34,-1.33333,206.667>, <34,-1.33333,310>,
<34,-2,-310>, <34,-2,-206.667>, <34,-2,206.667>, <34,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<34,2,-310>, <34.3333,2.33333,-310>, <35.6667,3.66667,-310>, <36,4,-310>,
<34,2,-206.667>, <34.3333,2.33333,-206.667>, <35.6667,3.66667,-206.667>, <36,4,-206.667>,
<34,2,206.667>, <34.3333,2.33333,206.667>, <35.6667,3.66667,206.667>, <36,4,206.667>,
<34,2,310>, <34.3333,2.33333,310>, <35.6667,3.66667,310>, <36,4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<36,4,-310>, <37.3333,4,-310>, <42.6667,4,-310>, <44,4,-310>,
<36,4,-206.667>, <37.3333,4,-206.667>, <42.6667,4,-206.667>, <44,4,-206.667>,
<36,4,206.667>, <37.3333,4,206.667>, <42.6667,4,206.667>, <44,4,206.667>,
<36,4,310>, <37.3333,4,310>, <42.6667,4,310>, <44,4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<44,4,-310>, <44.3333,3.66667,-310>, <45.6667,2.33333,-310>, <46,2,-310>,
<44,4,-206.667>, <44.3333,3.66667,-206.667>, <45.6667,2.33333,-206.667>, <46,2,-206.667>,
<44,4,206.667>, <44.3333,3.66667,206.667>, <45.6667,2.33333,206.667>, <46,2,206.667>,
<44,4,310>, <44.3333,3.66667,310>, <45.6667,2.33333,310>, <46,2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<46,2,-310>, <46,1.33333,-310>, <46,-1.33333,-310>, <46,-2,-310>,
<46,2,-206.667>, <46,1.33333,-206.667>, <46,-1.33333,-206.667>, <46,-2,-206.667>,
<46,2,206.667>, <46,1.33333,206.667>, <46,-1.33333,206.667>, <46,-2,206.667>,
<46,2,310>, <46,1.33333,310>, <46,-1.33333,310>, <46,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<46,-2,-310>, <45.6667,-2.33333,-310>, <44.3333,-3.66667,-310>, <44,-4,-310>,
<46,-2,-206.667>, <45.6667,-2.33333,-206.667>, <44.3333,-3.66667,-206.667>, <44,-4,-206.667>,
<46,-2,206.667>, <45.6667,-2.33333,206.667>, <44.3333,-3.66667,206.667>, <44,-4,206.667>,
<46,-2,310>, <45.6667,-2.33333,310>, <44.3333,-3.66667,310>, <44,-4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<44,-4,-310>, <42.6667,-4,-310>, <37.3333,-4,-310>, <36,-4,-310>,
<44,-4,-206.667>, <42.6667,-4,-206.667>, <37.3333,-4,-206.667>, <36,-4,-206.667>,
<44,-4,206.667>, <42.6667,-4,206.667>, <37.3333,-4,206.667>, <36,-4,206.667>,
<44,-4,310>, <42.6667,-4,310>, <37.3333,-4,310>, <36,-4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<36,-4,-310>, <35.6667,-3.66667,-310>, <34.3333,-2.33333,-310>, <34,-2,-310>,
<36,-4,-206.667>, <35.6667,-3.66667,-206.667>, <34.3333,-2.33333,-206.667>, <34,-2,-206.667>,
<36,-4,206.667>, <35.6667,-3.66667,206.667>, <34.3333,-2.33333,206.667>, <34,-2,206.667>,
<36,-4,310>, <35.6667,-3.66667,310>, <34.3333,-2.33333,310>, <34,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-46,2,-310>, <-46,1.33333,-310>, <-46,-1.33333,-310>, <-46,-2,-310>,
<-46,2,-206.667>, <-46,1.33333,-206.667>, <-46,-1.33333,-206.667>, <-46,-2,-206.667>,
<-46,2,206.667>, <-46,1.33333,206.667>, <-46,-1.33333,206.667>, <-46,-2,206.667>,
<-46,2,310>, <-46,1.33333,310>, <-46,-1.33333,310>, <-46,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-46,2,-310>, <-46,2,-206.667>, <-46,2,206.667>, <-46,2,310>,
<-45.6667,2.33333,-310>, <-45.6667,2.33333,-206.667>, <-45.6667,2.33333,206.667>, <-45.6667,2.33333,310>,
<-44.3333,3.66667,-310>, <-44.3333,3.66667,-206.667>, <-44.3333,3.66667,206.667>, <-44.3333,3.66667,310>,
<-44,4,-310>, <-44,4,-206.667>, <-44,4,206.667>, <-44,4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-44,4,-310>, <-44,4,-206.667>, <-44,4,206.667>, <-44,4,310>,
<-42.6667,4,-310>, <-42.6667,4,-206.667>, <-42.6667,4,206.667>, <-42.6667,4,310>,
<-37.3333,4,-310>, <-37.3333,4,-206.667>, <-37.3333,4,206.667>, <-37.3333,4,310>,
<-36,4,-310>, <-36,4,-206.667>, <-36,4,206.667>, <-36,4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-36,4,-310>, <-36,4,-206.667>, <-36,4,206.667>, <-36,4,310>,
<-35.6667,3.66667,-310>, <-35.6667,3.66667,-206.667>, <-35.6667,3.66667,206.667>, <-35.6667,3.66667,310>,
<-34.3333,2.33333,-310>, <-34.3333,2.33333,-206.667>, <-34.3333,2.33333,206.667>, <-34.3333,2.33333,310>,
<-34,2,-310>, <-34,2,-206.667>, <-34,2,206.667>, <-34,2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-34,2,-310>, <-34,2,-206.667>, <-34,2,206.667>, <-34,2,310>,
<-34,1.33333,-310>, <-34,1.33333,-206.667>, <-34,1.33333,206.667>, <-34,1.33333,310>,
<-34,-1.33333,-310>, <-34,-1.33333,-206.667>, <-34,-1.33333,206.667>, <-34,-1.33333,310>,
<-34,-2,-310>, <-34,-2,-206.667>, <-34,-2,206.667>, <-34,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-34,-2,-310>, <-34,-2,-206.667>, <-34,-2,206.667>, <-34,-2,310>,
<-34.3333,-2.33333,-310>, <-34.3333,-2.33333,-206.667>, <-34.3333,-2.33333,206.667>, <-34.3333,-2.33333,310>,
<-35.6667,-3.66667,-310>, <-35.6667,-3.66667,-206.667>, <-35.6667,-3.66667,206.667>, <-35.6667,-3.66667,310>,
<-36,-4,-310>, <-36,-4,-206.667>, <-36,-4,206.667>, <-36,-4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-36,-4,-310>, <-36,-4,-206.667>, <-36,-4,206.667>, <-36,-4,310>,
<-37.3333,-4,-310>, <-37.3333,-4,-206.667>, <-37.3333,-4,206.667>, <-37.3333,-4,310>,
<-42.6667,-4,-310>, <-42.6667,-4,-206.667>, <-42.6667,-4,206.667>, <-42.6667,-4,310>,
<-44,-4,-310>, <-44,-4,-206.667>, <-44,-4,206.667>, <-44,-4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-44,-4,-310>, <-44,-4,-206.667>, <-44,-4,206.667>, <-44,-4,310>,
<-44.3333,-3.66667,-310>, <-44.3333,-3.66667,-206.667>, <-44.3333,-3.66667,206.667>, <-44.3333,-3.66667,310>,
<-45.6667,-2.33333,-310>, <-45.6667,-2.33333,-206.667>, <-45.6667,-2.33333,206.667>, <-45.6667,-2.33333,310>,
<-46,-2,-310>, <-46,-2,-206.667>, <-46,-2,206.667>, <-46,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-78,2,-310>, <-78,1.33333,-310>, <-78,-1.33333,-310>, <-78,-2,-310>,
<-78,2,-206.667>, <-78,1.33333,-206.667>, <-78,-1.33333,-206.667>, <-78,-2,-206.667>,
<-78,2,206.667>, <-78,1.33333,206.667>, <-78,-1.33333,206.667>, <-78,-2,206.667>,
<-78,2,310>, <-78,1.33333,310>, <-78,-1.33333,310>, <-78,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-78,2,-310>, <-78,2,-206.667>, <-78,2,206.667>, <-78,2,310>,
<-77.6667,2.33333,-310>, <-77.6667,2.33333,-206.667>, <-77.6667,2.33333,206.667>, <-77.6667,2.33333,310>,
<-76.3333,3.66667,-310>, <-76.3333,3.66667,-206.667>, <-76.3333,3.66667,206.667>, <-76.3333,3.66667,310>,
<-76,4,-310>, <-76,4,-206.667>, <-76,4,206.667>, <-76,4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-76,4,-310>, <-76,4,-206.667>, <-76,4,206.667>, <-76,4,310>,
<-74.6667,4,-310>, <-74.6667,4,-206.667>, <-74.6667,4,206.667>, <-74.6667,4,310>,
<-69.3333,4,-310>, <-69.3333,4,-206.667>, <-69.3333,4,206.667>, <-69.3333,4,310>,
<-68,4,-310>, <-68,4,-206.667>, <-68,4,206.667>, <-68,4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-68,4,-310>, <-68,4,-206.667>, <-68,4,206.667>, <-68,4,310>,
<-67.6667,3.66667,-310>, <-67.6667,3.66667,-206.667>, <-67.6667,3.66667,206.667>, <-67.6667,3.66667,310>,
<-66.3333,2.33333,-310>, <-66.3333,2.33333,-206.667>, <-66.3333,2.33333,206.667>, <-66.3333,2.33333,310>,
<-66,2,-310>, <-66,2,-206.667>, <-66,2,206.667>, <-66,2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-66,2,-310>, <-66,2,-206.667>, <-66,2,206.667>, <-66,2,310>,
<-66,1.33333,-310>, <-66,1.33333,-206.667>, <-66,1.33333,206.667>, <-66,1.33333,310>,
<-66,-1.33333,-310>, <-66,-1.33333,-206.667>, <-66,-1.33333,206.667>, <-66,-1.33333,310>,
<-66,-2,-310>, <-66,-2,-206.667>, <-66,-2,206.667>, <-66,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-66,-2,-310>, <-66,-2,-206.667>, <-66,-2,206.667>, <-66,-2,310>,
<-66.3333,-2.33333,-310>, <-66.3333,-2.33333,-206.667>, <-66.3333,-2.33333,206.667>, <-66.3333,-2.33333,310>,
<-67.6667,-3.66667,-310>, <-67.6667,-3.66667,-206.667>, <-67.6667,-3.66667,206.667>, <-67.6667,-3.66667,310>,
<-68,-4,-310>, <-68,-4,-206.667>, <-68,-4,206.667>, <-68,-4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-68,-4,-310>, <-68,-4,-206.667>, <-68,-4,206.667>, <-68,-4,310>,
<-69.3333,-4,-310>, <-69.3333,-4,-206.667>, <-69.3333,-4,206.667>, <-69.3333,-4,310>,
<-74.6667,-4,-310>, <-74.6667,-4,-206.667>, <-74.6667,-4,206.667>, <-74.6667,-4,310>,
<-76,-4,-310>, <-76,-4,-206.667>, <-76,-4,206.667>, <-76,-4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-76,-4,-310>, <-76,-4,-206.667>, <-76,-4,206.667>, <-76,-4,310>,
<-76.3333,-3.66667,-310>, <-76.3333,-3.66667,-206.667>, <-76.3333,-3.66667,206.667>, <-76.3333,-3.66667,310>,
<-77.6667,-2.33333,-310>, <-77.6667,-2.33333,-206.667>, <-77.6667,-2.33333,206.667>, <-77.6667,-2.33333,310>,
<-78,-2,-310>, <-78,-2,-206.667>, <-78,-2,206.667>, <-78,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-14,2,-310>, <-14,1.33333,-310>, <-14,-1.33333,-310>, <-14,-2,-310>,
<-14,2,-206.667>, <-14,1.33333,-206.667>, <-14,-1.33333,-206.667>, <-14,-2,-206.667>,
<-14,2,206.667>, <-14,1.33333,206.667>, <-14,-1.33333,206.667>, <-14,-2,206.667>,
<-14,2,310>, <-14,1.33333,310>, <-14,-1.33333,310>, <-14,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-14,2,-310>, <-14,2,-206.667>, <-14,2,206.667>, <-14,2,310>,
<-13.6667,2.33333,-310>, <-13.6667,2.33333,-206.667>, <-13.6667,2.33333,206.667>, <-13.6667,2.33333,310>,
<-12.3333,3.66667,-310>, <-12.3333,3.66667,-206.667>, <-12.3333,3.66667,206.667>, <-12.3333,3.66667,310>,
<-12,4,-310>, <-12,4,-206.667>, <-12,4,206.667>, <-12,4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-12,4,-310>, <-12,4,-206.667>, <-12,4,206.667>, <-12,4,310>,
<-10.6667,4,-310>, <-10.6667,4,-206.667>, <-10.6667,4,206.667>, <-10.6667,4,310>,
<-5.33333,4,-310>, <-5.33333,4,-206.667>, <-5.33333,4,206.667>, <-5.33333,4,310>,
<-4,4,-310>, <-4,4,-206.667>, <-4,4,206.667>, <-4,4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-4,4,-310>, <-4,4,-206.667>, <-4,4,206.667>, <-4,4,310>,
<-3.66667,3.66667,-310>, <-3.66667,3.66667,-206.667>, <-3.66667,3.66667,206.667>, <-3.66667,3.66667,310>,
<-2.33333,2.33333,-310>, <-2.33333,2.33333,-206.667>, <-2.33333,2.33333,206.667>, <-2.33333,2.33333,310>,
<-2,2,-310>, <-2,2,-206.667>, <-2,2,206.667>, <-2,2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-2,2,-310>, <-2,2,-206.667>, <-2,2,206.667>, <-2,2,310>,
<-2,1.33333,-310>, <-2,1.33333,-206.667>, <-2,1.33333,206.667>, <-2,1.33333,310>,
<-2,-1.33333,-310>, <-2,-1.33333,-206.667>, <-2,-1.33333,206.667>, <-2,-1.33333,310>,
<-2,-2,-310>, <-2,-2,-206.667>, <-2,-2,206.667>, <-2,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-2,-2,-310>, <-2,-2,-206.667>, <-2,-2,206.667>, <-2,-2,310>,
<-2.33333,-2.33333,-310>, <-2.33333,-2.33333,-206.667>, <-2.33333,-2.33333,206.667>, <-2.33333,-2.33333,310>,
<-3.66667,-3.66667,-310>, <-3.66667,-3.66667,-206.667>, <-3.66667,-3.66667,206.667>, <-3.66667,-3.66667,310>,
<-4,-4,-310>, <-4,-4,-206.667>, <-4,-4,206.667>, <-4,-4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-4,-4,-310>, <-4,-4,-206.667>, <-4,-4,206.667>, <-4,-4,310>,
<-5.33333,-4,-310>, <-5.33333,-4,-206.667>, <-5.33333,-4,206.667>, <-5.33333,-4,310>,
<-10.6667,-4,-310>, <-10.6667,-4,-206.667>, <-10.6667,-4,206.667>, <-10.6667,-4,310>,
<-12,-4,-310>, <-12,-4,-206.667>, <-12,-4,206.667>, <-12,-4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-12,-4,-310>, <-12,-4,-206.667>, <-12,-4,206.667>, <-12,-4,310>,
<-12.3333,-3.66667,-310>, <-12.3333,-3.66667,-206.667>, <-12.3333,-3.66667,206.667>, <-12.3333,-3.66667,310>,
<-13.6667,-2.33333,-310>, <-13.6667,-2.33333,-206.667>, <-13.6667,-2.33333,206.667>, <-13.6667,-2.33333,310>,
<-14,-2,-310>, <-14,-2,-206.667>, <-14,-2,206.667>, <-14,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-62,2,-310>, <-62,1.33333,-310>, <-62,-1.33333,-310>, <-62,-2,-310>,
<-62,2,-206.667>, <-62,1.33333,-206.667>, <-62,-1.33333,-206.667>, <-62,-2,-206.667>,
<-62,2,206.667>, <-62,1.33333,206.667>, <-62,-1.33333,206.667>, <-62,-2,206.667>,
<-62,2,310>, <-62,1.33333,310>, <-62,-1.33333,310>, <-62,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-62,2,-310>, <-62,2,-206.667>, <-62,2,206.667>, <-62,2,310>,
<-61.6667,2.33333,-310>, <-61.6667,2.33333,-206.667>, <-61.6667,2.33333,206.667>, <-61.6667,2.33333,310>,
<-60.3333,3.66667,-310>, <-60.3333,3.66667,-206.667>, <-60.3333,3.66667,206.667>, <-60.3333,3.66667,310>,
<-60,4,-310>, <-60,4,-206.667>, <-60,4,206.667>, <-60,4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-60,4,-310>, <-60,4,-206.667>, <-60,4,206.667>, <-60,4,310>,
<-58.6667,4,-310>, <-58.6667,4,-206.667>, <-58.6667,4,206.667>, <-58.6667,4,310>,
<-53.3333,4,-310>, <-53.3333,4,-206.667>, <-53.3333,4,206.667>, <-53.3333,4,310>,
<-52,4,-310>, <-52,4,-206.667>, <-52,4,206.667>, <-52,4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-52,4,-310>, <-52,4,-206.667>, <-52,4,206.667>, <-52,4,310>,
<-51.6667,3.66667,-310>, <-51.6667,3.66667,-206.667>, <-51.6667,3.66667,206.667>, <-51.6667,3.66667,310>,
<-50.3333,2.33333,-310>, <-50.3333,2.33333,-206.667>, <-50.3333,2.33333,206.667>, <-50.3333,2.33333,310>,
<-50,2,-310>, <-50,2,-206.667>, <-50,2,206.667>, <-50,2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-50,2,-310>, <-50,2,-206.667>, <-50,2,206.667>, <-50,2,310>,
<-50,1.33333,-310>, <-50,1.33333,-206.667>, <-50,1.33333,206.667>, <-50,1.33333,310>,
<-50,-1.33333,-310>, <-50,-1.33333,-206.667>, <-50,-1.33333,206.667>, <-50,-1.33333,310>,
<-50,-2,-310>, <-50,-2,-206.667>, <-50,-2,206.667>, <-50,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-50,-2,-310>, <-50,-2,-206.667>, <-50,-2,206.667>, <-50,-2,310>,
<-50.3333,-2.33333,-310>, <-50.3333,-2.33333,-206.667>, <-50.3333,-2.33333,206.667>, <-50.3333,-2.33333,310>,
<-51.6667,-3.66667,-310>, <-51.6667,-3.66667,-206.667>, <-51.6667,-3.66667,206.667>, <-51.6667,-3.66667,310>,
<-52,-4,-310>, <-52,-4,-206.667>, <-52,-4,206.667>, <-52,-4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-52,-4,-310>, <-52,-4,-206.667>, <-52,-4,206.667>, <-52,-4,310>,
<-53.3333,-4,-310>, <-53.3333,-4,-206.667>, <-53.3333,-4,206.667>, <-53.3333,-4,310>,
<-58.6667,-4,-310>, <-58.6667,-4,-206.667>, <-58.6667,-4,206.667>, <-58.6667,-4,310>,
<-60,-4,-310>, <-60,-4,-206.667>, <-60,-4,206.667>, <-60,-4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-60,-4,-310>, <-60,-4,-206.667>, <-60,-4,206.667>, <-60,-4,310>,
<-60.3333,-3.66667,-310>, <-60.3333,-3.66667,-206.667>, <-60.3333,-3.66667,206.667>, <-60.3333,-3.66667,310>,
<-61.6667,-2.33333,-310>, <-61.6667,-2.33333,-206.667>, <-61.6667,-2.33333,206.667>, <-61.6667,-2.33333,310>,
<-62,-2,-310>, <-62,-2,-206.667>, <-62,-2,206.667>, <-62,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-30,2,-310>, <-30,1.33333,-310>, <-30,-1.33333,-310>, <-30,-2,-310>,
<-30,2,-206.667>, <-30,1.33333,-206.667>, <-30,-1.33333,-206.667>, <-30,-2,-206.667>,
<-30,2,206.667>, <-30,1.33333,206.667>, <-30,-1.33333,206.667>, <-30,-2,206.667>,
<-30,2,310>, <-30,1.33333,310>, <-30,-1.33333,310>, <-30,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-30,2,-310>, <-30,2,-206.667>, <-30,2,206.667>, <-30,2,310>,
<-29.6667,2.33333,-310>, <-29.6667,2.33333,-206.667>, <-29.6667,2.33333,206.667>, <-29.6667,2.33333,310>,
<-28.3333,3.66667,-310>, <-28.3333,3.66667,-206.667>, <-28.3333,3.66667,206.667>, <-28.3333,3.66667,310>,
<-28,4,-310>, <-28,4,-206.667>, <-28,4,206.667>, <-28,4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-28,4,-310>, <-28,4,-206.667>, <-28,4,206.667>, <-28,4,310>,
<-26.6667,4,-310>, <-26.6667,4,-206.667>, <-26.6667,4,206.667>, <-26.6667,4,310>,
<-21.3333,4,-310>, <-21.3333,4,-206.667>, <-21.3333,4,206.667>, <-21.3333,4,310>,
<-20,4,-310>, <-20,4,-206.667>, <-20,4,206.667>, <-20,4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-20,4,-310>, <-20,4,-206.667>, <-20,4,206.667>, <-20,4,310>,
<-19.6667,3.66667,-310>, <-19.6667,3.66667,-206.667>, <-19.6667,3.66667,206.667>, <-19.6667,3.66667,310>,
<-18.3333,2.33333,-310>, <-18.3333,2.33333,-206.667>, <-18.3333,2.33333,206.667>, <-18.3333,2.33333,310>,
<-18,2,-310>, <-18,2,-206.667>, <-18,2,206.667>, <-18,2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-18,2,-310>, <-18,2,-206.667>, <-18,2,206.667>, <-18,2,310>,
<-18,1.33333,-310>, <-18,1.33333,-206.667>, <-18,1.33333,206.667>, <-18,1.33333,310>,
<-18,-1.33333,-310>, <-18,-1.33333,-206.667>, <-18,-1.33333,206.667>, <-18,-1.33333,310>,
<-18,-2,-310>, <-18,-2,-206.667>, <-18,-2,206.667>, <-18,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-18,-2,-310>, <-18,-2,-206.667>, <-18,-2,206.667>, <-18,-2,310>,
<-18.3333,-2.33333,-310>, <-18.3333,-2.33333,-206.667>, <-18.3333,-2.33333,206.667>, <-18.3333,-2.33333,310>,
<-19.6667,-3.66667,-310>, <-19.6667,-3.66667,-206.667>, <-19.6667,-3.66667,206.667>, <-19.6667,-3.66667,310>,
<-20,-4,-310>, <-20,-4,-206.667>, <-20,-4,206.667>, <-20,-4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-20,-4,-310>, <-20,-4,-206.667>, <-20,-4,206.667>, <-20,-4,310>,
<-21.3333,-4,-310>, <-21.3333,-4,-206.667>, <-21.3333,-4,206.667>, <-21.3333,-4,310>,
<-26.6667,-4,-310>, <-26.6667,-4,-206.667>, <-26.6667,-4,206.667>, <-26.6667,-4,310>,
<-28,-4,-310>, <-28,-4,-206.667>, <-28,-4,206.667>, <-28,-4,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-28,-4,-310>, <-28,-4,-206.667>, <-28,-4,206.667>, <-28,-4,310>,
<-28.3333,-3.66667,-310>, <-28.3333,-3.66667,-206.667>, <-28.3333,-3.66667,206.667>, <-28.3333,-3.66667,310>,
<-29.6667,-2.33333,-310>, <-29.6667,-2.33333,-206.667>, <-29.6667,-2.33333,206.667>, <-29.6667,-2.33333,310>,
<-30,-2,-310>, <-30,-2,-206.667>, <-30,-2,206.667>, <-30,-2,310>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<81.5,5,-309>, <81.5,3.33333,-309>, <81.5,-3.33333,-309>, <81.5,-5,-309>,
<54.3333,5,-309>, <54.3333,3.33333,-309>, <54.3333,-3.33333,-309>, <54.3333,-5,-309>,
<-54.3333,5,-309>, <-54.3333,3.33333,-309>, <-54.3333,-3.33333,-309>, <-54.3333,-5,-309>,
<-81.5,5,-309>, <-81.5,3.33333,-309>, <-81.5,-3.33333,-309>, <-81.5,-5,-309>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,5,-399>, <-81.5,5,-384>, <-81.5,5,-324>, <-81.5,5,-309>,
<-81.5,3.33333,-399>, <-81.5,3.33333,-384>, <-81.5,3.33333,-324>, <-81.5,3.33333,-309>,
<-81.5,-3.33333,-399>, <-81.5,-3.33333,-384>, <-81.5,-3.33333,-324>, <-81.5,-3.33333,-309>,
<-81.5,-5,-399>, <-81.5,-5,-384>, <-81.5,-5,-324>, <-81.5,-5,-309>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-81.5,5,-399>, <-81.5,3.33333,-399>, <-81.5,-3.33333,-399>, <-81.5,-5,-399>,
<-54.3333,5,-399>, <-54.3333,3.33333,-399>, <-54.3333,-3.33333,-399>, <-54.3333,-5,-399>,
<54.3333,5,-399>, <54.3333,3.33333,-399>, <54.3333,-3.33333,-399>, <54.3333,-5,-399>,
<81.5,5,-399>, <81.5,3.33333,-399>, <81.5,-3.33333,-399>, <81.5,-5,-399>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<81.5,5,-399>, <81.5,3.33333,-399>, <81.5,-3.33333,-399>, <81.5,-5,-399>,
<81.5,5,-384>, <81.5,3.33333,-384>, <81.5,-3.33333,-384>, <81.5,-5,-384>,
<81.5,5,-324>, <81.5,3.33333,-324>, <81.5,-3.33333,-324>, <81.5,-5,-324>,
<81.5,5,-309>, <81.5,3.33333,-309>, <81.5,-3.33333,-309>, <81.5,-5,-309>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<85,10,-400>, <85,10,-266.667>, <85,10,266.667>, <85,10,400>,
<85,6.66667,-400>, <85,6.66667,-266.667>, <85,6.66667,266.667>, <85,6.66667,400>,
<85,-6.66667,-400>, <85,-6.66667,-266.667>, <85,-6.66667,266.667>, <85,-6.66667,400>,
<85,-10,-400>, <85,-10,-266.667>, <85,-10,266.667>, <85,-10,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<85,10,-400>, <85.8333,10.8333,-400>, <89.1667,14.1667,-400>, <90,15,-400>,
<85,10,-266.667>, <85.8333,10.8333,-266.667>, <89.1667,14.1667,-266.667>, <90,15,-266.667>,
<85,10,266.667>, <85.8333,10.8333,266.667>, <89.1667,14.1667,266.667>, <90,15,266.667>,
<85,10,400>, <85.8333,10.8333,400>, <89.1667,14.1667,400>, <90,15,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<85,10,-400>, <85,6.66667,-400>, <85,-6.66667,-400>, <85,-10,-400>,
<85.8333,10.8333,-400>, <85.8333,6.94444,-400>, <85.8333,-6.94444,-400>, <85.8333,-10.8333,-400>,
<89.1667,14.1667,-400>, <89.1667,9.72222,-400>, <89.1667,-9.72222,-400>, <89.1667,-14.1667,-400>,
<90,15,-400>, <90,10,-400>, <90,-10,-400>, <90,-15,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<90,15,-400>, <90,10,-400>, <90,-10,-400>, <90,-15,-400>,
<93.3333,15,-400>, <93.3333,10,-400>, <93.3333,-10,-400>, <93.3333,-15,-400>,
<106.667,15,-400>, <106.667,10,-400>, <106.667,-10,-400>, <106.667,-15,-400>,
<110,15,-400>, <110,10,-400>, <110,-10,-400>, <110,-15,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<90,15,-400>, <93.3333,15,-400>, <106.667,15,-400>, <110,15,-400>,
<90,15,-266.667>, <93.3333,15,-266.667>, <106.667,15,-266.667>, <110,15,-266.667>,
<90,15,266.667>, <93.3333,15,266.667>, <106.667,15,266.667>, <110,15,266.667>,
<90,15,400>, <93.3333,15,400>, <106.667,15,400>, <110,15,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<110,15,-400>, <110,10,-400>, <110,-10,-400>, <110,-15,-400>,
<110.833,14.1667,-400>, <110.833,9.72222,-400>, <110.833,-9.72222,-400>, <110.833,-14.1667,-400>,
<114.167,10.8333,-400>, <114.167,6.94444,-400>, <114.167,-6.94444,-400>, <114.167,-10.8333,-400>,
<115,10,-400>, <115,6.66667,-400>, <115,-6.66667,-400>, <115,-10,-400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<110,15,-400>, <110.833,14.1667,-400>, <114.167,10.8333,-400>, <115,10,-400>,
<110,15,-266.667>, <110.833,14.1667,-266.667>, <114.167,10.8333,-266.667>, <115,10,-266.667>,
<110,15,266.667>, <110.833,14.1667,266.667>, <114.167,10.8333,266.667>, <115,10,266.667>,
<110,15,400>, <110.833,14.1667,400>, <114.167,10.8333,400>, <115,10,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<115,10,-400>, <115,6.66667,-400>, <115,-6.66667,-400>, <115,-10,-400>,
<115,10,-266.667>, <115,6.66667,-266.667>, <115,-6.66667,-266.667>, <115,-10,-266.667>,
<115,10,266.667>, <115,6.66667,266.667>, <115,-6.66667,266.667>, <115,-10,266.667>,
<115,10,400>, <115,6.66667,400>, <115,-6.66667,400>, <115,-10,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<115,-10,-400>, <114.167,-10.8333,-400>, <110.833,-14.1667,-400>, <110,-15,-400>,
<115,-10,-266.667>, <114.167,-10.8333,-266.667>, <110.833,-14.1667,-266.667>, <110,-15,-266.667>,
<115,-10,266.667>, <114.167,-10.8333,266.667>, <110.833,-14.1667,266.667>, <110,-15,266.667>,
<115,-10,400>, <114.167,-10.8333,400>, <110.833,-14.1667,400>, <110,-15,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<110,-15,-400>, <106.667,-15,-400>, <93.3333,-15,-400>, <90,-15,-400>,
<110,-15,-266.667>, <106.667,-15,-266.667>, <93.3333,-15,-266.667>, <90,-15,-266.667>,
<110,-15,266.667>, <106.667,-15,266.667>, <93.3333,-15,266.667>, <90,-15,266.667>,
<110,-15,400>, <106.667,-15,400>, <93.3333,-15,400>, <90,-15,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<90,-15,-400>, <89.1667,-14.1667,-400>, <85.8333,-10.8333,-400>, <85,-10,-400>,
<90,-15,-266.667>, <89.1667,-14.1667,-266.667>, <85.8333,-10.8333,-266.667>, <85,-10,-266.667>,
<90,-15,266.667>, <89.1667,-14.1667,266.667>, <85.8333,-10.8333,266.667>, <85,-10,266.667>,
<90,-15,400>, <89.1667,-14.1667,400>, <85.8333,-10.8333,400>, <85,-10,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-110,-15,400>, <-110,-10,400>, <-110,10,400>, <-110,15,400>,
<-110.833,-14.1667,400>, <-110.833,-9.72222,400>, <-110.833,9.72222,400>, <-110.833,14.1667,400>,
<-114.167,-10.8333,400>, <-114.167,-6.94444,400>, <-114.167,6.94444,400>, <-114.167,10.8333,400>,
<-115,-10,400>, <-115,-6.66667,400>, <-115,6.66667,400>, <-115,10,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-90,-15,400>, <-90,-10,400>, <-90,10,400>, <-90,15,400>,
<-93.3333,-15,400>, <-93.3333,-10,400>, <-93.3333,10,400>, <-93.3333,15,400>,
<-106.667,-15,400>, <-106.667,-10,400>, <-106.667,10,400>, <-106.667,15,400>,
<-110,-15,400>, <-110,-10,400>, <-110,10,400>, <-110,15,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<-85,10,400>, <-85.8333,10.8333,400>, <-89.1667,14.1667,400>, <-90,15,400>,
<-85,6.66667,400>, <-85.8333,6.94444,400>, <-89.1667,9.72222,400>, <-90,10,400>,
<-85,-6.66667,400>, <-85.8333,-6.94444,400>, <-89.1667,-9.72222,400>, <-90,-10,400>,
<-85,-10,400>, <-85.8333,-10.8333,400>, <-89.1667,-14.1667,400>, <-90,-15,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<85,10,400>, <85.8333,10.8333,400>, <89.1667,14.1667,400>, <90,15,400>,
<85,6.66667,400>, <85.8333,6.94444,400>, <89.1667,9.72222,400>, <90,10,400>,
<85,-6.66667,400>, <85.8333,-6.94444,400>, <89.1667,-9.72222,400>, <90,-10,400>,
<85,-10,400>, <85.8333,-10.8333,400>, <89.1667,-14.1667,400>, <90,-15,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<110,-15,400>, <106.667,-15,400>, <93.3333,-15,400>, <90,-15,400>,
<110,-10,400>, <106.667,-10,400>, <93.3333,-10,400>, <90,-10,400>,
<110,10,400>, <106.667,10,400>, <93.3333,10,400>, <90,10,400>,
<110,15,400>, <106.667,15,400>, <93.3333,15,400>, <90,15,400>
 
}
bicubic_patch {
type 0
flatness 0.01
u_steps 3
v_steps 3
<115,10,400>, <115,6.66667,400>, <115,-6.66667,400>, <115,-10,400>,
<114.167,10.8333,400>, <114.167,6.94444,400>, <114.167,-6.94444,400>, <114.167,-10.8333,400>,
<110.833,14.1667,400>, <110.833,9.72222,400>, <110.833,-9.72222,400>, <110.833,-14.1667,400>,
<110,15,400>, <110,10,400>, <110,-10,400>, <110,-15,400>
 
}
//material { Attribute0 }
texture { Attribute0 }
}

