/*******************************************************
 Persistence of Vision Ray Tracer Scene Description File
 File Name : cutglass.pov
 Version   : 3.1
 Desciption: A Cut Glass Bowl  
 Date      : July 1999 
 Author    : Peter Houston
 Email     : houston.graphics@iname.com
 WWW       : http://welcome.to/HoustonGraphics

Note: This is an attempt to recreate a scene that I did a 
      while ago but lost the source :(
      Due to the fact that it is a merged CSG with a LOT of
      differences and has a glass texture this does take a LONG
      time to render.               
      54h 40m @ 800x600 0.3AA - Pentium 200 w/80Mb Ram
      I would like to try this using photons but I havn't had
      much success with the UV-Patch, not to mention 
      the render time increase....:|
      
********************************************************/

#version 3.1;

#include "colors.inc"
#include "stones.inc"
#include "metals.inc"

global_settings {
    assumed_gamma 2.2
    max_trace_level 20
}

// ----------------------------------------
camera {
    location  <0.0, 15, -30.0>
    direction 1.5*z
    right     4/3*x
    look_at   <0, 3.0,  0.0>
}

// spherical.png is a POV-Scene of a room viewed with a spherical camera, this is
// to add interesting reflections on the bowl.
sky_sphere {
    pigment {
        image_map {
            png "spherical.png" 
            map_type 1 
            interpolate 2 
            once
        }
    }
}

light_source {
    <-30, 50, -75>
    color rgb <.97,.92,.92>
}

light_source {
    < 30, 50, -75>
    color rgb <.97,.92,.92>
    shadowless
}

#declare ASA=0.00001; // A Small Amount - this is used to add to CSGs so that faces are not coincident
  
#declare Backdrop=
    union {
        difference{
            box {<-1,0,0><1,-2,2>}
            cylinder {<-1-ASA,0,0><1+ASA,0,0>.5}
        }
        box {<-1,0,.5><1,2,2>}
        box {<-1,0,.5><1,2,2> scale <1,-1,1> rotate x*90 scale <1,1,5>}
        translate <0,.5,-.5>
        scale <3,1,1>
    }    

object {Backdrop   
    texture{T_Grnt7  scale <2, 3, 2> rotate <0, 0, 40>}
    texture{T_Grnt0a scale <2, 3, 2> rotate <0, 0,-30>}
    scale 20          
    translate z*20
}    

// ----------------------------------------

#declare TheGlass=
    material {
        texture { 
            pigment { 
                color rgbf <0.8, 0.9, 0.85, 0.85>
            }
            finish {
                ambient 0.1
                diffuse 0.1
                reflection .25
                specular .9
                roughness 0.002
            }       
        }         
        interior {
            ior 1.5
        }
    }                        
    
//#declare TheGlass=material{texture{T_Chrome_3C}}  // Metal Texture for Reflection Test.

/* This macro creates a torus with a sharp internal cutting edge, then scaled and rotated.
   MajorD = Major Diameter of Torus.
   MinorD = Minor Diameter of Torus.
   Scale  = Scale Vector.
   Rotate = Rotation in Degrees about the z-axis.
*/

#macro CuttingRing(MajorD,MinorD,Scale,Rotate)
        difference {
                torus {MajorD,MinorD}
                cone {<0,0-ASA,0>MajorD-MinorD,<0,MinorD+ASA,0>5}
                cone {<0,0+ASA,0>MajorD-MinorD,<0,-MinorD-ASA,0>5}
                scale Scale
                rotate z*Rotate
        }                                    
#end

// Big Star CSG Effector
#declare BigStar=
    union{
        CuttingRing(5.2,.23,<1.1,1,1>,45)
        CuttingRing(5.2,.23,<1.1,1,1>,-45)
        CuttingRing(5.2,.25,<1.1,1,1>,90)
        CuttingRing(5.2,.25,<1.1,1,1>,0)
    }
// Small Star CSG Effector        
#declare SmallStar=
union{
    CuttingRing(5.21,.225,<1.1,1,1>,90)
    CuttingRing(5.21,.225,<1.1,1,1>,-45)
    CuttingRing(5.21,.225,<1.1,1,1>,0)
    rotate z*45
}
// Small Cross CSG Effector
#declare SmallCross=
    union{
        CuttingRing(5.21,.225,<1.1,1,1>,90)
        CuttingRing(5.21,.225,<1.1,1,1>,0)
        rotate z*45
    }                              

// Hatching CSG Effector
#declare Hatching=
    union {
        object {CuttingRing(5.2,.21,<1.1,1,1>,90) rotate y*5}
        object {CuttingRing(5.2,.21,<1.1,1,1>,90) rotate y*0}
        object {CuttingRing(5.2,.21,<1.1,1,1>,90) rotate y*-5}
        object {CuttingRing(5.2,.21,<1.1,1,1>,0) rotate x*5}
        object {CuttingRing(5.2,.21,<1.1,1,1>,0) rotate x*0}
        object {CuttingRing(5.2,.21,<1.1,1,1>,0) rotate x*-5}
        rotate z*45
    }

// Base Edge Chamfer Effector
#declare BaseChamfer=
    difference {
        cylinder {<0,0,0><0,3,0>3}
        cone {<0,0,0>3,<0,3,0>0}        
        scale 1.1
    }                                    

// Base Pattern CSG Effector
#declare BaseCutter=
    #declare Base_Loop=0;
    union {
        #while (Base_Loop<360)
            box {<0,0,0>,<1,1,4> rotate z*45 rotate x*3.75 rotate y*Base_Loop}       
            #declare Base_Loop=Base_Loop+20;
        #end
    }

merge {
// The Bowl
    difference {
        sphere{0,5}                  // Main Bowl Shape
        sphere{0,4.5}                // Hollow it out
        cone  {<0,3,0>,1 <0,5.5,0>5} // Remove the top

// Chamfer edges for specular highlighting
        cylinder {<0,0,0><0,6,0>2.4 }
        cylinder {<0,4.05,0><0,6,0>6 }
        
// Rotate a cone to ripple edge of bowl                    
        #declare Edge_Loop=0;
        union{
            #while (Edge_Loop<360)
                cone {<0,1,0>0,<0,0,6>1   rotate y*Edge_Loop translate y*4}
                #declare Edge_Loop=Edge_Loop+10;
            #end
        }        
        
// Cutout the Stars equispaced around the sphere remember 
// they effect both sides of the sphere
        object {BigStar}
        object {BigStar rotate y*45}
        object {BigStar rotate y*-45}
        object {BigStar rotate y*90}
        
// Do the same with the Hatching
        object {Hatching rotate x* 20 rotate y* 22.5}
        object {Hatching rotate x*-20 rotate y* 22.5}
        object {Hatching rotate x* 20 rotate y*-22.5}
        object {Hatching rotate x*-20 rotate y*-22.5}        
        object {Hatching rotate x* 20 rotate y* 67.5}
        object {Hatching rotate x*-20 rotate y* 67.5}
        object {Hatching rotate x* 20 rotate y*-67.5}
        object {Hatching rotate x*-20 rotate y*-67.5}        

// And the Small Stars
        object {SmallStar rotate x* 40 rotate y* 22.5}
        object {SmallStar rotate x*-40 rotate y* 22.5}
        object {SmallStar rotate x* 40 rotate y*-22.5}
        object {SmallStar rotate x*-40 rotate y*-22.5}
        object {SmallStar rotate x* 40 rotate y* 67.5}
        object {SmallStar rotate x*-40 rotate y* 67.5}
        object {SmallStar rotate x* 40 rotate y*-67.5}
        object {SmallStar rotate x*-40 rotate y*-67.5}

// And the Small Cross
        object {SmallCross rotate x* 20}
        object {SmallCross rotate x* 20 rotate y*45}
        object {SmallCross rotate x* 20 rotate y*-45}
        object {SmallCross rotate x* 20 rotate y*90}
        object {SmallCross rotate x*-20}
        object {SmallCross rotate x*-20 rotate y*45}
        object {SmallCross rotate x*-20 rotate y*-45}
        object {SmallCross rotate x*-20 rotate y*90}
    }        

// The Base
    difference {
        merge {
            cylinder {<0,0+ASA,0><0,-.5,0>3}
            cone {<0,0,0>3,<0,.25,0>0}
        }        

// Chamfer the edge for highlights
        object {BaseChamfer translate <0,-.35,0>}
        cone {<0,-.5,0>3,<0,0,0>0}

// Cut pattern on base
        object {BaseCutter translate <0,.18,0>}
        translate y*-5
        scale <1.25,1,1.25>
    }        

//    bounded_by {cylinder {<0,5.1,0><0,-5.6,0>5.1}}
    material {TheGlass}
    translate <0,5.5,0>
} 

// EOF