//Generates random "Worm"
//NumSegm       number of segments
//Len           length of worm
//RadStart      worm start radius
//PStart        start point
//DirStart      initial direction
//Wind          directional force applied to worm (vector)
//BendExp       1 => Wind bends the worm uniformly; >1 => bends more towards end
//Random        randomness in X,Y and Z directions (vector)
//Seed          random number seed
//OutF          1 => generate output file (works with fur macro, otherwise leave 0)

#macro Worm(NumSegm,Len,RadStart,PStart,DirStart,Wind,BendExp,Random,Seed,OutF)
        #local CurSegm = 0;
        #local LenSegm = Len/NumSegm;
        #local PointStart = <1,1,1>*PStart;
        #local PointEnd = PointStart+vnormalize(DirStart)*LenSegm;
        #local VDir=vnormalize(vnormalize(PointEnd-PointStart)+Interpolate(CurSegm+1,0,NumSegm,0,Wind,BendExp));
        #local RadConst = RadStart;
        union{
        #if(OutF!=0)
        #write(OFile,"union{\n")
        #end
        #while (CurSegm < NumSegm)
                #local RadEnd=(NumSegm-CurSegm-1)/NumSegm*RadConst;
                #local PointEnd=PointStart+vrotate(LenSegm*VDir,v_rand_ext(0,Random,Seed));
                cone {PointStart, RadStart, PointEnd, RadEnd}
                #if(OutF!=0)
                #write(OFile,"cone{",PointStart,",",RadStart,",",PointEnd,",",RadEnd,"}\n")
                #end
                #local CurSegm=CurSegm+1;
                #local VDir=vnormalize(vnormalize(PointEnd-PointStart)+Interpolate(CurSegm+1,0,NumSegm,0,Wind,BendExp));
                #local PointStart=PointEnd;
                #local RadStart=RadEnd;
        #end
        bounded_by{sphere{PStart,Len}}}
        #if(OutF!=0)
        #write(OFile,"bounded_by{sphere{",PStart,",",Len,"}}}\n")
        #end
#end
