//NB! Turn off warning stream! (-gw)

#include "grotesque.inc"

#declare CPos=<0,3,-5>;
#declare LPos=<10,10,-20>;
camera{location CPos look_at 0}
light_source{LPos color 1
             //area_light vnormalize(vcross(LPos,y))*3,
                        //vnormalize(vcross(LPos,x))*3,
                        //3,3
                        //adaptive 1 jitter
                        }

#declare S=seed(1221213);

//The whole point of it all:
//Overcome the 256 entry limit in the spline function.

#declare SplineSegm=300; //Number of spline entries
#declare NumSpheres=3000; //Number of blob components
#declare A=array[NumSpheres]
#declare Dist=1; //Approximate radius of the spiny bundle

#declare NumG=SplineSegm;
#declare P=<0,0,0>;
#declare AC=0;
#declare CG=0;
#declare C=0;
#while(CG<=SplineSegm)
    #if(NumG<256)
        #declare NumL=NumG;
    #else
        #declare NumL=255;
    #end
    #debug "New spline\n"
    #declare Sp=spline{
        cubic_spline
        #declare C=0;
        #while(C<=NumL)
            C,P
            #declare P=P+v_rand_ext(0,1,S);
            //Apply a pseudo-gravity to keep the bundle together
            #if(vlength(P)>Dist)
                #declare P=P-(P-vnormalize(P)*Dist)/2;
            #end
            #declare C=C+1;
            #declare CG=CG+1;
        #end
        }
    
    #declare C=0;
    #while(C<=NumL&AC<NumSpheres)
        #declare A[AC]=<0,0,0>+Sp(C);
        #declare C=C+SplineSegm/NumSpheres;
        #declare AC=AC+1;
    #end
    
    #declare NumG=NumG-NumL;
#end

#declare Size=dimension_size(A,1)-1;
#declare ElemA=array[Size]

//Declare for tracing spine positions
#declare Blob=
blob{threshold .75
#declare C=0;
#while(C<Size)
    #declare ElemSize=rand_ext(.15,.05,S);
    sphere{A[C],ElemSize,1}
    #declare ElemA[C]=ElemSize;
    #declare C=C+1;
#end
}

//Create spines
#include "fur.inc"

union{Fur(Blob,25,3,
          1,.1,.2,.015,
          0,0,
          .1,0,
          1234,
          1,"furinc.inc")
          
//If furinc.inc has been generated AND
//you're using the same blob, include "furinc.inc"
//and comment out the fur macro

//#include "furinc.inc"

      pigment{bozo color_map{[.2 hsl(0,.5,.6)][.3 hsl(.07,.3,1)]} scale .01}
      finish{specular .2 roughness .03 brilliance 2 metallic}}

//Create the actual blob
blob{threshold .75

//The scquiggly, spiny part
#declare C=0;
#while(C<Size)
    sphere{A[C],ElemA[C],1}
    #declare C=C+1;
#end

//A quick hack to create the "stem"
#declare NumSp=1000; //Number of components in stem
#declare RadI=2.5; //Initial radius
#declare RadF=.1; //Final radius
#declare PosI=2.7*y; //Start position
#declare PosF=0; //end position

#declare RotL=0;
#declare C=0;
#while(C<NumSp)
    #declare Rad=Interpolate(C,0,NumSp,RadI,RadF,.2);
    #declare PosY=Interpolate(C,0,NumSp,PosI,PosF,2);
    sphere{vrotate(Rad*z,RotL*y)+PosY+v_rand_ext(0,.05,S),.15,1}
    #declare C=C+1;
    #declare RotL=RotL+Interpolate(C,0,NumSp,1,30,1);
#end

//Fleshy texture
#declare TexScale=.3;
pigment{crackle
        pigment_map{
        [.02 hsl(.9,.4,.7)]
        [.07 bozo
             color_map{[.3 hsl(.05,.4,.9)][1 hsl(.05,.6,.7)]}
             turbulence .2
             scale .2
             scale 1/TexScale]}
        scale TexScale
        turbulence .3}
normal{average
       normal_map{
       [1 crackle .7 slope_map{[0,<1,0>][.07,<0,0>]} scale TexScale turbulence .3]
       [1 crackle 1.5 slope_map{[0,<1,0>][.4,<1,-.05>][.6,<.8,-.3>][1,<-1,-2>]} scale .1 turbulence 0]
       [1 granite .3 scale .1]}}
finish{specular .4 roughness .04}
}
