//"hslft" lets you specify colours with the
//hue-saturation-lightness colour model.
//You can also use "hsl", "hslf" and "hslt" as shortcuts,
//just like "rgb", "rgbf" and "rgbt";
//H - hue; circular spectrum running red-green-blue-red
//S - saturation, i.e. the amount of colour in relation to gray
//L - lightness of the colour
//F,T - filter and transmit of the colour
#macro hslft(H,S,L,F,T)
    //Construct rgb from hue
    #if(H<1/3) #local R=min(2-H*6,1); #end
    #if(H>2/3) #local R=min((H-2/3)*6,1); #end
    #if(H>=1/3&H<=2/3) #local R=0; #end

    #if(H<=1/3) #local G=min(H*6,1); #end
    #if(H>1/3&H<2/3) #local G=min(2-(H-1/3)*6,1); #end
    #if(H>=2/3) #local G=0; #end

    #if(H>1/3&H<=2/3) #local B=min((H-1/3)*6,1); #end
    #if(H>2/3) #local B=min(2-(H-2/3)*6,1); #end
    #if(H<=1/3) #local B=0; #end
    
    //Incorporate saturation and lightness
    #local RGB=((1-S)+S*<R,G,B>)*L;
    rgbft<RGB.x,RGB.y,RGB.z,F,T>
#end
#macro hsl(H,S,L) hslft(H,S,L,0,0) #end
#macro hslf(H,S,L,F) hslft(H,S,L,F,0) #end
#macro hslt(H,S,L,T) hslft(H,S,L,0,T) #end

//Interpolation
//GC - global current
//GS - global start
//GE - global end
//TS - target start
//TE - target end
//EXP - interpolation exponent (linear, cubic etc.)

#macro Interpolate(GC,GS,GE,TS,TE,EXP)
        (TS+(TE-TS)*pow((GC-GS)/(GE-GS),EXP))
#end

//Create random number of given mean and maximum deviation
//M - mean value
//D - maximum deviation
//Seed - (declared) random number seed identifier
#macro rand_ext(M,D,Seed)
        (M+(rand(Seed)-.5)*2*D)
#end

//Give a random vector of given mean and max deviation
//M - mean (vector/float)
//D - max deviation (vector/float)
//Seed - (declared) random number seed identifier
#macro v_rand_ext(M,D,Seed)
        #local MV=M+<0,0,0>;
        #local DV=D+<0,0,0>;
        (<rand_ext(MV.x,DV.x,Seed),rand_ext(MV.y,DV.y,Seed),rand_ext(MV.z,DV.z,Seed)>)
#end
