// Persistence of Vision Ray Tracer Scene Description File
// File: GlassChess.pov
// Vers: 3.1
// Desc: Three glass chesspieces.
// Date: 1999-06-22
// Auth: ingo
//

#version 3.1;
#include "chesspiece1.inc"
 
global_settings {
   assumed_gamma 1.0
   max_trace_level 15
}

light_source {
   < 500, 50,-5>
   rgb 1
}

camera {
   location  < 5.5, 1,-7.0>
   look_at   < 0.0, 1, 0.0>
   angle 60
}
 
// Textures and materials
#declare Glass = texture {
   pigment {rgbf < 0.98, 1.0, 0.98, 1> }
   finish {
      specular 1
      roughness 0.001
      ambient 0
      diffuse 0
      reflection_type 1            // needs the SuperPatch!
      reflection_min 0.05          //
      reflection_max 0.2           //
      reflection_falloff 2         //
      //reflection 0.125
   }   
}

#declare PieceTex = texture {
   pigment {rgbt < 0.9, 0.9, 0.6, 0.6>}
   finish {reflection 0.3}
}

#declare SkyGlass = material {
   texture {
      pigment {rgbt < 0.95, 0.95, 1, 1> }
      finish {
         diffuse 0.2
         ambient 0.05
         specular 1.5
         roughness 0.01
         brilliance 0.01
         reflection_type 1         // needs the SuperPatch!
         reflection_min 0.01       //                      
         reflection_max 0.1        //                      
         reflection_falloff 3      //                      
         //reflection 0.055
      }
      normal {                     // from a water by Jon S. Brandt.
          bozo
          normal_map {
              [ 0.30 waves   translate -0.5 scale <1, 0.05, 1>*100000 frequency 100000]
              [ 0.70 ripples translate -0.5 scale <1, 0.70, 1>*100000 frequency 100000]
              [ 0.85 ripples translate -0.5 scale <1, 0.60, 1>*100000 frequency 100000]
              [ 1.00 ripples translate -0.5 scale 100000 frequency 100000]
          }
          scale 0.6
      }
   }
   interior {ior 1.33}
}

// start sky
sky_sphere {
   pigment {
      gradient y
      color_map { 
         [0.0 color rgb < 0.3, 0.05, 0.15>] 
         [1.0 color rgb 1] 
      }
      translate < 0,-0.1, 0>
   }
}

sphere { 
   0, 5000 
   scale < 1, 0.3, 0.6>
   hollow
   pigment {
      bozo
      turbulence 0.1
      color_map {
         [ 0.0 color rgbt 1]
         [ 0.4 color rgbt 0.8]
         [ 1.0 color rgb 1]
      }
      scale < 250, 500, 250>
   }
   finish {
      ambient 0.7 
      diffuse 0
   }
   rotate < 5, 0, 0>
}

sphere { 
   0, 4000 
   scale < 1, 0.1, 0.6>
   hollow
   pigment{
      bozo
      turbulence 0.1
      color_map {
         [ 0.0 color rgbt 1 ]
         [ 0.3 color rgbt 0.8 ]
         [ 1.0 color rgb 1 ]
      }
      scale < 250, 500, 250>
   }
   finish {
      ambient 0.4 
      diffuse 0
   }
   rotate < 5, 0, 0>
}

box {
   <-10, 3.5,-7>, < 10, 3.51, 7>
   no_shadow
   material {SkyGlass}
}
// end sky

// chessboard
height_field {
   tga
   "board.tga"
   smooth 
   translate <-0.5, 0.0,-0.5>
   scale < 12,-0.5, 12>
   rotate < 0, 270, 0>
   texture {Glass}
   interior {ior 1.2} 
}

union {
   difference {
      box {<-7,-0.25,-7>, < 7,-0.001, 7>}
      box {<-6,-0.30,-6>, < 6, 0, 6>}
      pigment {rgb < 0, 0, 0.5>}
   }
   box {
      <-6,-0.2,-6>, < 6,-0.501, 6> 
      texture {
         pigment {
            checker color rgb 1 color rgb < 0, 0, 1> 
            scale 1.5
            translate < 1.5, 0, 0>
         }
      }
   }
   no_shadow
} 
// end chessboard

      
// The pieces
difference {
   superellipsoid {
      < 0.05, 0.05> 
      translate < 0, 1, 0> 
      scale < 0.5, 0.9, 0.5>
      pigment {rgbf 0.9}
      texture {Glass}
      interior {
         ior 1.5
         fade_distance 2
         fade_power 2
      }
   }
   object {
      Paard 
      rotate < 0,-90, 0>
      texture{PieceTex}
   }
   no_shadow
   rotate < 0, 68, 0>
   translate < 2.2*1.5, 0, -3.5*1.5>
}

difference {
   superellipsoid {
      < 0.05, 0.05> 
      translate < 0, 1, 0> 
      scale < 0.5, 0.9, 0.5>
      texture {Glass}
      interior {
         ior 1.5      
         fade_distance 2
         fade_power 2
      }
   }
   object {
      Loper
      texture{PieceTex}
   }
   no_shadow
   translate < 1.5*1.5, 0,-1.5>
}

difference {
   superellipsoid {
      < 0.05, 0.05> 
      translate < 0, 1, 0> 
      scale < 0.5, 0.75, 0.5>
      texture {Glass}
      interior {
         ior 1.5
         fade_distance 2
         fade_power 2
      }
   }
   object {
      Toren
      texture{PieceTex}
   }
   no_shadow
   translate < 3.5*1.5, 0,-3.5*1.5>
}
// end pieces
