// Persistence of Vision Ray Tracer Scene Description File
// File: ChessPieces.pov
// Vers: 3.1
// Desc: Shows all chesspieces in chesspiece1.inc
// Date: 1999-06-19
// Auth: ingo
//

#version 3.1;

global_settings {assumed_gamma 1.0}

#include "chesspiece1.inc"

light_source {
   <500, 500,-500>
   rgb 1
}

camera {
   location  <0.0, 0.9, -12.0>
   look_at   <0.0, 1.0,  0.0>
   angle 30 
}

sky_sphere {
   pigment {
      gradient y
      color_map { [0.0 color rgb <0,0,0.6>] [1.0 color rgb 1] }
   }
}
/*
plane { 
   y, 0
   texture {
      pigment {
         checker color rgb 1 color rgb <0, 0, 1>
         translate <0,0,0.5>
    }
  }
}
*/

object {Koning translate <-2.5,0,0> pigment {rgb 1}}
object {Dame   translate <-1.5,0,0> pigment {rgb 1}}
object {Loper  rotate <0,20,0> translate <-0.5,0,0> pigment {rgb 1}}
object {Paard  rotate <0,45,0> translate < 0.5,0,0> pigment {rgb 1}}
object {Toren  translate < 1.5,0,0> pigment {rgb 1}}
object {Pion   translate < 2.5,0,0> pigment {rgb 1}}

/*
// needs SuperPatch
#declare Min=min_extent(Pion);
#declare Max=max_extent(Pion);
#debug concat("\n MinX=";str(Min.x,5,5))
#debug concat("\n MinY=";str(Min.y,5,5))
#debug concat("\n MaxY=";str(Max.y,5,5))
*/