// ----------------------------------------
// POV-Ray 3.1
// ----------------------------------------
// Cloudscape 3
// ----------------------------------------
// Large landscape with big fluffy clouds
// Gilles Tran - May 1999
// ----------------------------------------
#version 3.1;
#include "colors.inc"
#declare PdV=<0,2,-300>;
#declare PdA=<-5,100,100>;
camera{location  PdV  direction 1*z  right 4*x/3 up y sky <0,1,0> look_at   PdA}
light_source{PdV color White 0.2 shadowless media_interaction off}
light_source{<100,2000,-4000> color White*2} // very bright light
#declare Bleu=rgb<0.6,0.8,1>*1.3;                    
#declare i=0.5;
#local DensityClouds=density {
        wrinkles turbulence 0.5
        color_map{
                [0.0 Black]
                [i Black]
                [i+0.1 White*0.3]
                [1.0 White]
        }
}
            
#declare CloudsWhite=0.03; // > : more white   < : more transparent
#declare CloudsDark=0.3; //   > : more opaque  < : more transparent
#local MediaClouds=media {     
        scattering {3, CloudsWhite extinction CloudsDark}
//        intervals 3 samples 20, 50 confidence 0.9999 variance 1/10  // final takes forever
//        intervals 3 samples 10, 20 confidence 0.9999 variance 1/10  // long test
        intervals 3 samples 1, 5 confidence 0.9999 variance 1/10  // test
        density {DensityClouds}
    }                                                  
#declare Clouds=box{<-1,-0.013,-1>, <1,0.023,1> texture{pigment{Clear} finish{ambient 0 diffuse 0}}
        interior{
                media{MediaClouds scale 0.2 translate -x*0.2}
                }
        hollow 
        }



object{Clouds scale 4500 rotate y*90 translate <0,400,-800>}  
sky_sphere{pigment{gradient y color_map{[0 color Bleu][1 color Bleu*0.2]}}}
// the fog controls the color of the clouds's undersides
fog{fog_type 1 color rgbt <0.6,0.8,1,0.5> distance 1000} 
