// ----------------------------------------
// POV-Ray 3.1
// ----------------------------------------
// Cloudscape 1
// ----------------------------------------
// Large landscape with big clouds rushing in
// Gilles Tran - May 1999                                                                   
// ----------------------------------------
#version 3.1;
#include "colors.inc"
#declare PdV=<0,2,-300>;
#declare PdA=<-5,100,100>;
camera{location  PdV  direction 1*z  right 4*x/3 up y sky <0,1,0> look_at   PdA}
light_source{PdV color White 0.2 shadowless media_interaction off}
light_source{<-100,700,-1300> color White*2.4} // very bright light
#declare Bleu=rgb<0.6,0.8,1>;                    

#local DensityClouds=density {
        leopard
        turbulence 1.6 lambda 4 octaves 2
        color_map{
                [0.0 Black]
                [0.2 White*0.5]
                [1.0 White*1]
      }
}
            
#declare CloudsWhite=0.05; // > : more white   < : more transparent
#declare CloudsDark=0.2; //   > : mode opaque  < : more transparent
#local MediaClouds=media {     
        scattering {3, CloudsWhite extinction CloudsDark}
//        intervals 3 samples 20, 50 confidence 0.9999 variance 1/10  // final takes forever
        intervals 3 samples 10, 20 confidence 0.9999 variance 1/10  // long test
//        intervals 3 samples 1, 5 confidence 0.9999 variance 1/10  // test
        density {DensityClouds}
    }                                                  
#declare Clouds=box{<-1,0,-1>,<1,0.02,0.3> texture{pigment{Clear} finish{ambient 0 diffuse 0}}
        interior{media{MediaClouds scale 0.05 rotate z*30}}
        hollow 
}


// the clouds are scaled more on the z axis than on the x axis to give more dynamism
object{Clouds scale 2100*<3,2,8> translate <0,400,1200>}  

sky_sphere{pigment{gradient y color_map{[0 color Bleu][1 color Bleu*0.2]}}}
// the fog controls the color of the clouds's undersides
fog{fog_type 1 color rgbt <0.7,0.8,1,0.3> distance 1000} 
