// =======================================================================
// Persistence Of Vision raytracer version 3.1 Superpatch by Ron L. Parker
// =======================================================================
// Crackle keyword examples
// Examples by Gilles Tran, May 1999
// =======================================================================

#version 3

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <0.0, 0.5, -10.0>
  direction 1*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}

sphere{
  -x*2-y*2,2
  texture {
    pigment {
      crackle
      turbulence 0.4
      solid
      color_map{[0 color <1,0,0>][0.25 color <1,1,0>][0.5 color Black][0.75 color <0,0,1>][1 color <0,1,0>]}
    }
    finish{phong 1}
    scale 0.3
  }
}

sphere{
  x*2-y*2,2
  texture {
    pigment {
      crackle
      form <1,0,0>
      color_map{[0 color <1,0,0>][0.25 color <1,1,0>][0.5 color Black][0.75 color <0,0,1>][1 color <0,1,0>]}
    }
    finish{phong 1}
    scale 0.3
  }
}
sphere{
  x*2+y*2,2
  texture {
    pigment {
      crackle
      metric 3
      color_map{[0 color <1,0,0>][0.25 color <1,1,0>][0.5 color Black][0.75 color <0,0,1>][1 color <0,1,0>]}
    }
    finish{phong 1}
    scale 0.5
  }
}

sphere{
  -x*2+y*2,2
  texture {
    pigment {
      crackle
      offset 1
      color_map{[0 color <1,0,0>][0.25 color <1,1,0>][0.5 color Black][0.75 color <0,0,1>][1 color <0,1,0>]}
    }
    finish{phong 1}
    scale 0.5
  }
}
