// =======================================================================
// Persistence Of Vision raytracer version 3.1 isosurface patch by R.Suzuki.
// =======================================================================
// Iso_space.pov contains various isosurfacic functions that fill a space
// Examples by Gilles Tran, May 1999
// =======================================================================

#declare PdV=<10, 51, -100>
camera {
   location PdV
   direction <0, 0,  1>
   look_at <0,0,0>
}
light_source {<150, 400, -120> color 0.5}
light_source {<350, 200, -220> color 1}
light_source {PdV color 0.3}

#declare ComYw =   texture{
        pigment {color red 1.0 green 0.8 blue 0.5}
        finish {phong 0.6}
     }


#declare aC=20
#declare Space1=isosurface{
     function {exp(cos(x*x/5))+exp(cos(y*y/5))+exp(cos(z*z/5))-7.1}
     bounded_by{ box {-aC,aC}}
     sign -1
     threshold   0
     texture {ComYw}
     no_shadow
  }
#declare Space2=isosurface{
     function {sqrt(cos(x)*sin(x*x)+cos(y)*sin(y*y)+cos(z)*sin(z*z))-1}
     bounded_by{ box {-aC,aC}}
     sign -1
     threshold   0
     texture {ComYw}
     no_shadow
  }
#declare Space3=isosurface{
     function {sqrt(cos(x)*sin(x*x)+cos(y)*sin(y*y)+cos(z)*sin(z*z))-1 + noise3d(x*12,y*12,z*12)*0.01-0.2}
     bounded_by{ box {-aC,aC}}
     sign -1
     threshold   0
     texture {ComYw}
     no_shadow
  }

object{Space1 scale 5 rotate y*40}
//object{Space2 scale 5 rotate y*40}
//object{Space3 scale 5 rotate y*40}

//fog{distance 200 color <1,1,1>}
