// =======================================================================
// Persistence Of Vision raytracer version 3.1 isosurface patch by R.Suzuki.
// =======================================================================
// Iso_plane_1.pov contains various isosurfacic functions that create a plane surface
// Examples by Gilles Tran, May 1999
// =======================================================================

camera {
//   location <0, 30, -45>
   location <0, 80, -120>
   direction <0, 0,  1>
   look_at <0,0,0>
}

light_source {<150, 400, -120> color 1}
light_source {<-350, 200, 120> color 1}
#declare ComYw =   texture{
        pigment {color red 1.0 green 0.8 blue 0.5}
        finish {phong 0.6}
     }
#declare RoughPlane=
  isosurface
  {
     function  y + noise3d(x/10,0,z/10) + noise3d(x*3,0,z*3)*0.1
     bounded_by{ box {<-20,-10,-20>,<20,10,20>}}
     sign 1
     threshold    5
     texture {ComYw}
     no_shadow
  }

#declare EggBox=
  isosurface
  {
     function  y+cos(z)+cos(x)+cos(z)
     bounded_by{ box {<-20,-10,-20>,<20,10,20>}}
     sign 1
     threshold    5
     texture {ComYw}
     no_shadow
  }

#declare CorrugatedIron=
  isosurface
  {
     function  y+cos(x)*cos(z)*sin(y)
     bounded_by{ box {<-20,-10,-20>,<20,10,20>}}
     sign 1
     threshold    0.1
     texture {ComYw}
     no_shadow
  }
#declare CorrugatedIron2=
  isosurface
  {
     function  y+cos(x)*cos(z+sin(x))*sin(y)
     bounded_by{ box {<-20,-10,-20>,<20,10,20>}}
     sign 1
     threshold    0.10 // 10
     texture {ComYw}
     no_shadow
  }
#declare CheckerBoard=
  isosurface
  {
     function  y+cos(x)*cos(z)*sin(y)
     bounded_by{ box {<-20,-10,-20>,<20,10,20>}}
     sign 1
     threshold    10
     texture {ComYw}
     no_shadow
  }
#declare Scales=
  isosurface
  {
     function  y+cos(x+sin(y))*cos(z+sin(y))*sin(y)
     bounded_by{ box {<-20,-10,-20>,<20,10,20>}}
     sign 1
     threshold    5
     texture {ComYw}
     no_shadow
  }
#declare SmallBridges=
  isosurface
  {
     function  y+sin(y+sin(x))*sin(y+sin(x))+cos(y+sin(z))*cos(y+sin(z))
     bounded_by{ box {<-20,-10,-20>,<20,10,20>}}
     sign 1
     threshold    6
     texture {ComYw}
     no_shadow
  }
#declare Eyes=
  isosurface
  {
     function  y+sin(exp(cos(x))*exp(cos(z)))*cos(exp(cos(x))*exp(cos(z)))
     bounded_by{ box {<-20,-10,-20>,<20,10,20>}}
     sign 1
     threshold   0.01
     texture {ComYw}
     no_shadow
  }
#declare DropInWater=
  isosurface
  {
     function  y - cos(sqrt(x*x+z*z)) + (10/(x*x+z*z+1))
     bounded_by{ box {<-60,-10,-60>,<60,20,60>}}
     sign 1
     threshold   0
     texture {ComYw}
     no_shadow
  }
#declare CircleAndEyes=
  isosurface
  {
     function  y - cos(sqrt(x*x +z*z))+sin(exp(cos(x))*exp(cos(z)))*cos(exp(cos(x))*exp(cos(z)))
     bounded_by{ box {<-60,-10,-60>,<60,10,60>}}
     sign 1
     threshold   0
     texture {ComYw}
     no_shadow
  }
#declare CheeseGrinder=
  isosurface
  {
     function  y - 1/sqr(exp(sqr(cos(x/5)*sin(z/5))))
     bounded_by{ box {<-60,0.4,-60>,<60,10,60>}}
     sign 1
     threshold   0
     texture {ComYw}
     no_shadow
  }
#declare SandCitadel=
  isosurface
  {
     function  y - exp(sin(sqrt(x*(x-10)+z*(z-10))))+ cos((x*(x-3)+z*(z-3))/30)
     bounded_by{ box {<-80,-1,-80>,<80,10,80>}}
     sign 1
     threshold   0
     texture {ComYw}
     no_shadow
  }
#declare AlienNoise=
  isosurface
  {
     function  y + noise3d(cos(x/2),y,cos(z/2))
     bounded_by{ box {<-80,-1,-80>,<80,10,80>}}
     sign 1
     threshold   0
     texture {ComYw}
     no_shadow
  }
#declare MeltedChocolate=
  isosurface
  {
     function  y + noise3d(x*0.3+sin((x+sqrt(z+2))/2),y,z*0.4+sin((z+sqrt(x-3))/2))
     bounded_by{ box {<-80,-1,-80>,<80,10,80>}}
     sign 1
     threshold   0
     texture {ComYw}
     no_shadow
  }

object{RoughPlane scale 5 rotate y*40}
//object{EggBox scale 5 rotate y*40}
//object{CorrugatedIron scale 5 rotate y*40}
//object{CorrugatedIron2 scale 5 rotate y*40}
//object{Scales scale 5 rotate y*40}
//object{SmallBridges scale 5 rotate y*40}
//object{CircleAndEyes scale 5 rotate y*40}
//object{Eyes scale 5 rotate y*40}
//object{CheckerBoard scale 5 rotate y*40}
//object{DropInWater scale 5 rotate y*40}
//object{CheeseGrinder scale 5 rotate y*40}
//object{SandCitadel scale 5 rotate y*40}
//object{AlienNoise scale 5 rotate y*40}
//object{MeltedChocolate scale 5 rotate y*40}
background {color red 0.184314 green 0.309804 blue 0.309804}

