// =======================================================================
// Persistence Of Vision raytracer version 3.1 isosurface patch by R.Suzuki.
// =======================================================================
// Iso_land.pov contains various isosurfacic functions that create complicated terrains
// Examples by Gilles Tran, May 1999
// =======================================================================
camera {
   location <0, 180, -500>
   direction <0, 0,  1>
   look_at <0,0,-300>
}

light_source {<150, 400, -820> color 1}
light_source {<-350, 200, -820> color 1}
#declare ComYw =   texture{
        pigment {color red 1.0 green 0.8 blue 0.5}
        finish {phong 0.6}
     }
#declare Land1=isosurface  {
     function  y  - cos(sqrt(abs((3*y+30)*(x-y+30) +(y+30)*(z-y+30)))) + cos(sqrt(abs(((x+y-10)*(x-y-10) +(z+x-10)*(z+y-10)))))  - cos(sqrt((x-300)*(x-300) +(z-10)*(z+10)))*1
     bounded_by{ box {<-1400,-20,-1400>,<1400,40,1400>}}
     sign 1
     threshold   22
     texture{ComYw}
  }
#declare Land2=isosurface {
     function (y + cos(x+sin(y+cos(x*z)))*cos(z+sin(y+sin(x*z))*max(abs(sin(y)),abs(cos(y)))))*5 + noise3d(x*5,y*1,z*5)*0.03 + noise3d(x*12,y*12,z*12)*0.1-0.125
     bounded_by{ box {<-200,-10,-100>,<200,10,100>}}
     sign 1
     threshold  5
     rotate y*-16
     texture{ComYw}
     scale <50,15,50>
    }



object{Land1 scale 4}
//object{Land2}
background {color red 0.184314 green 0.309804 blue 0.309804}

