// =======================================================================
// Persistence Of Vision raytracer version 3.1 Superpatch by Ron L. Parker
// =======================================================================
// Pattern keyword examples
// Examples by Gilles Tran, May 1999
// =======================================================================
#version 3

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <0.0, 3, -10.0>
  direction 1*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}


light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}

#declare Wall=height_field {
  pattern 200,200 {
    crackle
//      form <1,-0.3,0> // pebbles
//      form <1,0.3,0>  // ???
//      form <.43,-0.3,1> // ravines
//      form <.43,0.13,1.2> // holes
//      form <-0.2,-0.3,1.2> // stegosaurus
//      form <0.5,1.07,-0.2> // impacts
      form <-0.1,1.07,-0.2> // ???
      turbulence 0.14
      color_map{[0 color <0.4,0,0>][0.25 color <0.3,1,0>][0.25 color<0.1,0,0>][0.5 color <0,0,1>][1 color <0.4,0,0>]}
    scale <0.1,0.2,0.1>
  }
  texture {
    pigment {
    gradient y
      turbulence 0.14
      color_map{[0 color Tan*0.5][0.3 color Tan*1.4][1 color Tan*2]}
    }
  }
/*  
  texture {
    pigment {
    crackle
      form <1,-0.3,0>
      color_map{[0 color Tan*1.5][0.25 color Tan][0.45 color ForestGreen][0.5 color Tan][1 color ForestGreen]}
    scale 0.1
    }
  }
*/  
  translate <-0.5,0,-0.5>
  scale <6,1,6>
  rotate -x*80
  scale <1,1,0.4>
}         
object{Wall}

