// =======================================================================
// Persistence Of Vision raytracer version 3.1 isosurface patch by R.Suzuki.
// =======================================================================
// iso_egg.pov creates a broken egg with a rough surface
// Examples by Gilles Tran, May 1999
// =======================================================================
#include "colors.inc"
#declare PdV=<0,30,-45>;
camera { location PdV direction<0,0,3> look_at 0}

#declare SolCol=rgb<0.95,0.91,0.78>;
#declare LumCol=SolCol;
light_source {<-200, 200, -150> color LumCol*1.9}
light_source {<200, 50, 60> color LumCol*1 shadowless}
light_source {PdV color LumCol*0.2 shadowless}


//==============================================
// Egg
//==============================================
#declare EggHole=prism {
  conic_sweep // or conic_sweep for tapering to a point
  linear_spline // linear_spline | quadratic_spline | cubic_spline
  0,        // height 1
   8,        // height 2
  21,          // number of points
<-2.2 ,0>,<-3.1,  2.05>,<-2.1,1.9>,<-1.85,3.12>,<-1.12, 3.25>,<0.2,  4.5>,<-0.12,  3.17>,< 2.32, 3.22>,<1.07, 2.471>,
<3.01,  1.21>,<1.51,0.22>,<3.11,-0.875>,<1.29,-1.23>,<2.11,-1.54>,<0.81,-1.32>,<-0.412,-3.12>,<-1.21,-2.05>,<-0.899,-4.21>,<-2.05,-2.61>,<-4.33,-2.12>,<-2.2 ,0>
scale <0.25,1,0.25>
}
#declare EggCol=SolCol*0.8+<0.2,0.0,0.0>;
#declare EggTxt=texture{
     pigment {EggCol*1.1}
     finish {specular 0.1 roughness 0.1 ambient 0.01}
}
#declare EggPig0=pigment {EggCol*0.1}
#declare EggPig1=pigment {EggCol*0.3}
#declare EggPig2=pigment {
         spotted
         color_map{
         [0 EggCol*2]
         [0.3 EggCol*1.5]
         [1 EggCol*0.2]
         }
         scale 0.02
}
#declare EggPig3=pigment {EggCol*3}

#declare EggTxt=texture{
         pigment{
         gradient y
         pigment_map{
         [0 EggPig3]
         [0.5 EggPig2]
         [0.95 EggPig1]
         [1 EggPig0]
         }
         }
     finish {specular 0.1 roughness 0.1 ambient 0.01}
     scale 15
     translate -y*22.5
}
//#declare Egg=sphere{0,7.5 scale <0.65,0.98,0.65> texture{EggTxt}} 

#declare Egg=isosurface {
     function{ sqrt(x*x +y*y*0.5 +z*z) -5 + noise3d(x*3,y*3,z*3)*0.04 + noise3d(x*12,y*12,z*12)*0.01 -0.125}
     bounded_by{ box {-7,7}}
     eval
     threshold  0
     method 2
     scale 1
}
#declare EggInt=sphere{0,7 scale <0.65,0.98,0.65> texture{EggTxt}}

#declare EggBroken=
difference{
           object{Egg}
           object{EggHole}
           object{EggInt}
           texture{EggTxt}
}

object{EggBroken}
background{Yellow}
