#declare GravConst = 6.670e-11;
#declare  AU=1.495e11;         // 1AU in [m]
#declare _AU=1/AU;
#declare  YR = 3.156e7;        // 1 year in [s]
#declare _YR = 1/YR;
#declare  ME = 5.975e24;       // mass of the earth in [kg]
#declare _ME = 1/ME;
#declare  RE = 6.378e6;        // radius of the earth in [m]
#declare _RE = 1/RE;


#declare TimeInterval = YR; // (in seconds)

#declare dTime = TimeInterval * .01; //clock_delta;

#fopen File "data.txt" read
#read  (File, NumObj)

#declare Mass   = array[NumObj] // object mass, in [kg]
#declare Radius = array[NumObj] // object diameter, not used yet
#declare Color  = array[NumObj] // object color in RGB
#declare OldPos = array[NumObj] // position vector in [m]
#declare OldVel = array[NumObj] // velocity vector in [m/s]
#declare NewPos = array[NumObj] // position vector in [m]
#declare NewVel = array[NumObj] // velocity vector in [m/s]
#declare dVel   = array[NumObj]
#declare dPos   = array[NumObj]

#declare OldPos[0] = <0,0,0>;
#declare OldVel[0] = <0,0,0>;
#declare NewPos[0] = <0,0,0>;
#declare NewVel[0] = <0,0,0>;
#declare Mass[0]   = 0;
#declare Color[0]  = <0,0,0>;
#declare Radius[0] = 0;


#declare i=0;
#while ( i < NumObj )
  #read (File, Mass[i])
  #declare Mass[i] = Mass[i] * ME;
  #read (File, Radius[i])
  #declare Radius[i] = Radius[i] * RE;
  #read (File, Color[i])
  #read (File, OldPos[i])
  #declare OldPos[i] = OldPos[i] * AU;
  #read (File, OldVel[i])
  #declare OldVel[i] = OldVel[i] * _YR * AU;  
  #declare i=i+1;
#end

#fclose File


#declare i=0;
#while (i < NumObj )
  #declare j=0;
  #declare Force = <0,0,0>;
  
  #while (j < NumObj)
    #if (!(i=j))
      #declare r = vlength(OldPos[i]-OldPos[j]);
      #declare Force = Force + Mass[i]*Mass[j]*GravConst*(OldPos[j]-OldPos[i])/( r * r * r);
    #end
    #declare j=j+1;
  #end

                                                                                     
  #declare Acceleration = Force / Mass[i];

  #declare dVel[i]   = Acceleration * dTime;
  #declare NewVel[i] = OldVel[i] + dVel[i];
  
  #declare dPos[i]   = (OldVel[i] + NewVel[i])/2 *dTime + Acceleration * dTime*dTime / 2;  
  #declare NewPos[i] = OldPos[i] + dPos[i];
  
  #debug concat("dVel     : <",str(dVel[i].x,0,10),",",str(dVel[i].y,0,10),",",str(dVel[i].z,0,10),">\n")
  #debug concat("Velocity : <",str(OldVel[i].x,0,10),",",str(OldVel[i].y,0,10),",",str(OldVel[i].z,0,10),">\n")
  #debug "\n"


  
  #declare i=i+1;
#end

#fopen File "data.txt" write

#write (File, concat (str(NumObj,0,0),",\n"))

#declare i=0;
#while (i<NumObj)
  #write (File, concat (str(Mass[i] * _ME,6,3),","))
  #write (File, concat (str(Radius[i] * _RE,4,3),","))
  #write (File, concat ("<",str(Color[i].x,1,2),",",str(Color[i].y,1,2),",",str(Color[i].z,1,2),">,"))
  #write (File, concat ("<",str(_AU*NewPos[i].x,3,10),",",str(_AU*NewPos[i].y,3,10),",",str(_AU*NewPos[i].z,3,10),">,"))
  #write (File, concat ("<",str(_AU*YR*NewVel[i].x,3,10),",",str(_AU*YR*NewVel[i].y,3,10),",",str(_AU*YR*NewVel[i].z,3,10),">,\n"))
  #declare i=i+1;
#end

#fclose File

#declare i=0;
#while (i<NumObj)
  sphere 
  { 
    NewPos[i]/100000000*2, 
    Radius[0]/2000000
    texture { pigment { color rgb Color[i] } finish { ambient 1 } }
  }
  #declare i=i+1;
#end

camera { location -800000/4*z angle 30 right x look_at 0 }