#declare GravConst = 6.670e;
#declare AU=150000000000;
#declare _AU=1/AU;

#declare TimeInterval = 365*24*60*60; // (in seconds)

#declare Time = TimeInterval * clock_delta;

#fopen File "data.txt" read
#read  (File, NumObj)

#declare Mass   = array[NumObj] // object mass, in [kg]
#declare Radius = array[NumObj] // object diameter, not used yet
#declare Color  = array[NumObj] // object color in RGB
#declare OldPos = array[NumObj] // position vector in [m]
#declare OldVel = array[NumObj] // velocity vector in [m/s]
#declare NewPos = array[NumObj] // position vector in [m]
#declare NewVel = array[NumObj] // velocity vector in [m]

#declare OldPos[0] = <0,0,0>;
#declare OldVel[0] = <0,0,0>;
#declare NewPos[0] = <0,0,0>;
#declare NewVel[0] = <0,0,0>;
#declare Mass[0]   = 0;
#declare Color[0]  = <0,0,0>;
#declare Radius[0] = 0;


#declare i=0;
#while ( i < NumObj )
  #read (File, Mass[i])
  #read (File, Radius[i])
  #read (File, Color[i])
  #read (File, OldPos[i])
  #declare OldPos[i]=OldPos[i]*AU;
  #read (File, OldVel[i])
  #declare i=i+1;
#end

#fclose File

#declare i=0;
#while (i < NumObj )
  #declare j=0;
  #declare Force = <0,0,0>;
  #while (j < NumObj)
    #if (!(i=j))
      #declare Force = 
      Force + vnormalize(OldPos[j]-OldPos[i])*Mass[i]*Mass[j]*GravConst/( vlength(OldPos[i]-OldPos[j])*vlength(OldPos[i]-OldPos[j]));
    #end
    #declare j=j+1;
  #end
  
  #declare Acceleration = Force / Mass[i];
  #declare NewVel[i] = OldVel[i] + Acceleration*Time;
  #declare NewPos[i] = OldPos[i] + OldVel[i]*Time + 0.5*Acceleration*Time*Time;
  
  #declare i=i+1;
#end

#fopen File "data.txt" write

#write (File, concat (str(NumObj,0,0),",\n"))

#declare i=0;
#while (i<NumObj)
  #write (File, concat (str(Mass[i],0,0),","))
  #write (File, concat (str(Radius[i],0,8),","))
  #write (File, concat ("<",str(Color[i].x,0,2),",",str(Color[i].y,0,2),",",str(Color[i].z,0,2),">,"))
  #write (File, concat ("<",str(_AU*NewPos[i].x,0,10),",",str(_AU*NewPos[i].y,0,10),",",str(_AU*NewPos[i].z,0,10),">,"))
  #write (File, concat ("<",str(NewVel[i].x,0,10),",",str(NewVel[i].y,0,10),",",str(NewVel[i].z,0,10),">,\n"))
  #declare i=i+1;
#end

#fclose File

#declare i=0;
#while (i<NumObj)
  sphere 
  { 
    NewPos[i]/1000000, 
    Radius[0]/200000
    texture { pigment { color rgb Color[i] } finish { ambient 1 } }
  }
  #declare i=i+1;
#end

camera { location -800000*z angle 30 right x look_at 0 }