
#include "colors.inc"
global_settings { max_trace_level 7 }

#declare shinybubble = finish {
		specular 1 
          roughness .0001 
		phong 1
    		phong_size 200
		reflection .2 
		irid {
                   0.30
                   thickness .55
        	}
         }
#declare Bubble=texture {               
			pigment { color White transmit .97 }
		     finish{shinybubble}			
         }

//** required for p_surfa.inc
#declare uusteps = 40;	//**
#declare vvsteps = 40;	//**
#declare vvmin   = -6;	//**
#declare vvmax   =  6;	//**
#declare uumin   = -6;	//**
#declare uumax   =  6;	//**

#macro oneZV(uu,vv)
<
	uu - 1/3*uu*uu*uu + uu*vv*vv,
	-vv - uu*uu*vv + 1/3*vv*vv*vv,
	uu*uu - vv*vv
>

#end
#macro xyz(uu,vv)	//**
     oneZV(uu,vv)
#end

#declare use_smooth_triangles=1;//**

#include "p_surfa.inc"

object{
    
	object{
		p_surface
		texture{Bubble}
		rotate <90,0,0>
		clipped_by{sphere{<0,0,0>,12}}
		bounded_by{sphere{<0,0,0>,12.1}}
	}
	scale .8	
}

camera
{ 
  location  < 16, 9,-16>
  look_at   < 0, 0, 0>
} 

light_source { <40, 20, -20> color rgb 1 }

sky_sphere{
  
    pigment {
        bozo
        color_map {
            [ 0.00 rgb < 0.000, 0.000, 0.000 > ]
            [ 0.35 rgb < 0.1, 0.1, 0.25 > ]
            [ 0.65 rgb < 0.400, 0.350, 0.420 > ]
            [ 1.00 rgb < 0.15, 0.150, 0.150 > ]
        }
        
        turbulence < 0.400, 0.600, 0.200 >
    }
   

}
       