/*-----------------------------------------------
    p_surfa.inc 
-----------------------------------------------*/
#if (version<3.1)
	#error "This file requires features of POV-Ray version 3.1 (or later?)"
#end

#macro reflect_thru(vec,line_axis)
	#switch(line_axis)
		#case(X)
			#local vec.z=-vec.z;
			#local vec.y=-vec.y;
		#break
		#case(Y)
			#local vec.x=-vec.x;
			#local vec.z=-vec.z;
		#break
		#case(Z)
			#local vec.x=-vec.x;
			#local vec.y=-vec.y;
		#break
		#case(XY)
          	#local vec.z=-vec.z;
		#break
		#case(XZ)
			#local vec.y=-vec.y;
		#break
		#case(YZ)
			#local vec.x=-vec.x;
		#break

	#end
	vec
#end

// the following requires that a vector valued macro 
// named 'xyz' and variables uusteps, vvsteps, uumin, 
// uumax, vvmin, and vvmax have been previously defined.
// If an additional macro 'mytexture1(integer,integer)'
// been defined, it will be used to texture individual
// triangles.

// To speed up triangle and normals calculations,
// we will compute the surface points and store
// them in xyz_array
#local xyz_array=array[uusteps+3][vvsteps+3]

// If we want smooth triangles, we will pre-compute
// and store the normals too.
#if(use_smooth_triangles)
   #local normal_array=array[uusteps+3][vvsteps+3]
#end

// uu,vv lattice interval sizes
#local duu= (uumax-uumin)/uusteps;//u-increment per step
#local dvv= (vvmax-vvmin)/vvsteps;//v-increment per step

#debug "Calculating surface points"
#local vv= vvmin-dvv;  
#local vvcount = 0;
#while (vvcount<vvsteps+3) // vv loop
        #local uucount = 0;
        #local uu = uumin-duu;
        #while (uucount<uusteps+3) // uu loop
		#local xyz_array[uucount][vvcount]=xyz(uu,vv);
		#local uucount=uucount+1;
		#local uu = uu+duu;
	   #end  //end uu loop  		
	
	#local vvcount = vvcount + 1;
	#local vv = vv+dvv;
#end	//end vv loop

#if(use_smooth_triangles)
  #debug "\nCalculating normals"
  #local vv= vvmin;  
  #local vvcount = 1;

  #while (vvcount<=vvsteps+1) // vv loop

 		#local uucount=1;
  		#local uu = uumin;
  		#while (uucount<=uusteps+1) // uu loop			
			#local p1=xyz_array[uucount][vvcount];
			#local p2=xyz_array[uucount+1][vvcount];
			#local p4=xyz_array[uucount][vvcount+1];
			#local p1a=xyz_array[uucount-1][vvcount];
			#local p1b=xyz_array[uucount][vvcount-1];
/*  
             p4
             | 
             | 
             | 
    p1a-----p1------p2
             |
             |         
/|\          |       
 v          p1b     
  u->    
*/
			// Calculate normal:
			#local n1=vcross(p1-p1b,p1-p1a);
			#local n2=vcross(p1-p2,p1-p1b);
			#local n3=vcross(p1-p4,p1-p2);
			#local n4=vcross(p1-p1a,p1-p4);
			#local normal_array[uucount][vvcount]=n1+n2+n3+n4;

			#local uucount=uucount+1;
			#local uu = uu+duu;
		#end  //end uu loop  		
		
		#local vvcount = vvcount + 1;
		#local vv = vv+dvv;
  #end	//end vv loop
#end //end if(use_smooth_triangles)


#debug "\nMaking the triangles"
#local vv= vvmin;  
#local vvcount = 1;
#declare p_surface =
mesh{
	#while (vvcount<=vvsteps) // vv loop
		//#debug concat(str(vvcount,0,0)," / ",str(vvsteps,0,0),"\r")
                        
 		#local uucount=1;
  		#local uu = uumin;
  		#while (uucount<=uusteps) // uu loop			
                        
			//get triangle vertices p1,p2,p3,p4
			#local p1=xyz_array[uucount][vvcount];
			#local p2=xyz_array[uucount+1][vvcount];
			#local p3=xyz_array[uucount+1][vvcount+1];
			#local p4=xyz_array[uucount][vvcount+1];
/*
            p4a     p3b
             .       .
             .       .
    p4b.... p4------p3.... p3a
             | tr2.  |
             |  .    |
             |.  tr1 |
    p1a.... p1------p2.... p2b
             .       .  
/|\          .       .
 v          p1b     p2a   
  u->
    
*/             
               #ifdef(mytexture1)
                    #local T1=mytexture1(uucount,vvcount)
               #end
            
			#if(use_smooth_triangles)
				// get normals:
                    #local n1=normal_array[uucount][vvcount];
				#local n2=normal_array[uucount+1][vvcount];
				#local n3=normal_array[uucount+1][vvcount+1];
				#local n4=normal_array[uucount][vvcount+1];
				//make smooth triangles
                    
				smooth_triangle  {
					p1, n1,
					p2, n2,
					p3, n3
                         #ifdef(T1)
                            texture{T1}
					#end
				}

				smooth_triangle  {
					p1, n1,
					p3, n3,
					p4, n4
                         #ifdef(T1)
                            texture{T1}
					#end
				}
			#else // 'flat' triangles
				
				triangle  {
					p1,p2,p3
                         #ifdef(mytexture1)
                             texture{T1}
					#end
				}
				triangle  {
					p1,p3,p4
					#ifdef(mytexture1)
                             texture{T1}
					#end
				}               
			#end
			#local uucount=uucount+1;
			#local uu = uu+duu;
		#end  //end uu loop  		
		
		#local vvcount = vvcount + 1;
		#local vv = vv+dvv;
	#end	//end vv loop
}
