// Persistence of Vision Ray Tracer Scene Description File
// File: BVPovNow.pov
// Vers: 3.1
// Desc: 
// Date: 4/21/1999 
// Auth: Bryan Valencia

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

                     
plane{z,10 hollow pigment {color White} finish {ambient .75}}
plane{y,-1 hollow pigment {color White} finish {ambient .75}}
  
difference{
  cylinder{ -90*x,  90*x,  1}
  union{
    cylinder{ -9*x,  9*x,  .9}
    sphere{<0,0,0>,1 scale <2.3,.8,1> translate z*-1}
  }
  
  texture{
    pigment{color Gray50}    
    normal{marble .1 turbulence 3.2321 scale <100,1,1>}
  }  
}


text{ttf "crystal.ttf", "POV-Ray 3", 
  .5,              // the extrusion depth
  0               // inter-character spacing

  translate x*-2.25 +y*-.45
  texture {Glass2}
  //texture{Blue_Sky}
}
      
text{ttf "crystal.ttf", "now", 
  .5,              // the extrusion depth
  0               // inter-character spacing
  texture {
    pigment {color Red}
    finish{Shiny}
  }              
  translate <.5,-1,-2>
}

cone{<0,0,0>,.2,<0,1,0>,0 texture {White_Marble} translate <-1.5,-1,-2>}
sphere{<0,.25,0>,.25 texture{Polished_Chrome} translate <-1,-1,-2.25>}
box{<-.25,0,-.25><.25,.5,.25> texture{DMFWood1 rotate <4,19,34>} rotate <0,60,0> translate <-.5,-1,-2>}



light_source{ 
  0*x 
  color White
  spotlight               
  translate <-10, 10, -40>
  point_at <0, 0, 0>      
  radius 15                
  tightness 50            
  falloff 28               
}
/*
light_source{ 
  0*x 
  color Yellow
  spotlight               
  translate <10, 10, -40> 
  point_at <0, 0, 0>      
  radius 5                
  tightness 50            
  falloff 8               
}
light_source{ 
  0*x 
  color Blue
  spotlight               
  translate <0, -10, -40> 
  point_at <0, 0, 0>      
  radius 5                
  tightness 50            
  falloff 8
}
*/
light_source{ 
  0*x 
  color rgb<.8,1,.8>
  translate <2.2, 0, 0> 
}

light_source{ 
  0*x 
  color rgb<.8,1,.8>
  translate <-2.2, 0, 0> 
}

camera{ location  <0, 0 ,-5>  look_at  <0,-1,0> }
