//terr_gen.pov
//by Abe Madey   April 12, 1999
//
//This file generates the foregound terrain as a triangle mesh.

// ******
#ifndef (UseAsINC)  //Can be run as a stand alone scene for tests and debugging.
camera{
  location <.5, 1, -1>
  look_at <.5, 0, .5>
  angle 70
}

light_source {<100, 200, -100> color rgb 1}
plane {y, 0 pigment{checker color rgb 1, color rgb 0}}
plane {-z, -5 pigment{color rgb .8}}
#end      
// ******
//Fills a 1D array with a number of random values definded by "freq"
//and interpolating (linear) inbetween.
#macro SFillRand (Array, freq, Rseed) 
#local dim=dimension_size(Array, 1);
#local p=0; 
#local a=rand(Rseed); #local b=rand(Rseed);
#local i=0;
#while (i<dim)
  #if(div(i/freq,1)>p) #local p=p+1; #local a=b; #local b=rand(Rseed); #end    
  #local increment=mod(i/freq,1);
  #declare Array[i]=a+increment*(b-a);
  #local i=i+1;
#end
#end

//This is my adaptation of Perlin Noise (or how I understand it).
//"Size" is actually the number of grid points - the actual mesh appears just like a HF except 
//for vertical scaling (done by vScale). "base_freq" is the grid point distance between
//the largest features - looking at the code should explain it.  
//NOTE: I have commented out a fourth level of perturbation, because I was happy with three. Be aware
//that un-commenting it will change the whole terrain due to the way the randomization is implemented 
//ie. only one seed value.
#macro PerlinHF(Size, base_freq, vScale, seedval) 
#declare pHF=array[Size][Size] 
#local Rseed =seed(seedval);  
#local freq1=base_freq; #local freq2=base_freq/2.2; #local freq3=freq2/2.2; #local freq4=freq3/2.2;      
#declare A1=array[Size] #declare A2=array[Size] #declare A3=array[Size] //#declare A4=array[Size]             
#declare B1=array[Size] #declare B2=array[Size] #declare B3=array[Size] //#declare B4=array[Size]

SFillRand(A1, freq1, Rseed) SFillRand(A2, freq2, Rseed) SFillRand(A3, freq3, Rseed) //SFillRand(A4, freq3, Rseed)
SFillRand(B1, freq1, Rseed) SFillRand(B2, freq2, Rseed) SFillRand(B3, freq3, Rseed) //SFillRand(B4, freq3, Rseed)
#local p1=0; #local p2=0; #local p3=0; //#local p4=0;

//Now finish the rest of the array
#local Z=0;
#while (Z<Size)
  #local Zinc1=mod(Z/freq1,1); #local Zinc2=mod(Z/freq2,1); #local Zinc3=mod(Z/freq3,1); #local Zinc4=mod(Z/freq4,1);
  #if (div(Z/freq1,1)>=p1)  #local p1=p1+1; #declare A1=B1 SFillRand(B1, freq1, Rseed) #end
  #if (div(Z/freq2,1)>=p2)  #local p2=p2+1; #declare A2=B2 SFillRand(B2, freq2, Rseed) #end
  #if (div(Z/freq3,1)>=p3)  #local p3=p3+1; #declare A3=B3 SFillRand(B3, freq3, Rseed) #end
  //#if (div(Z/freq4,1)>=p4)  #local p4=p4+1; #declare A4=B4 SFillRand(B4, freq4, Rseed) #end   
    
  #local X=0; 
  #while (X<Size)
    #local H=A1[X]+Zinc1*(B1[X]-A1[X]); 
    #local H=H+.5*A2[X]+Zinc2*(B2[X]-A2[X]);
    #local H=H+.25*A3[X]+Zinc3*(B3[X]-A3[X]);
    //#local H=H+.03*A4[X]+Zinc4*(B4[X]-A4[X]);  
    #declare pHF[Z][X]=<X/Size, vScale*H/1.75/*1.78*/, Z/Size>;
    #local X=X+1;
  #end
  #local Z=Z+1;
#end
#undef A1 #undef A2 #undef A3 /*#undef A4*/ #undef B1 #undef B2 #undef B3 //#undef B4
#end

//Used this for debugging 
#macro PrintArray(A)
#local Rows=dimension_size(A, 1); #local Cols=dimension_size(A, 2);   
#local p=6; #local d=5;
#local i=0;
#while (i<Rows)
  #local j=0;
  #while (j<Cols)  
    #debug concat("<",str(A[i][j].x,p,d),",",str(A[i][j].y,p,d),",",str(A[i][j].z,p,d),"> ")
    #local j=j+1;
  #end  
  #debug "\n"
  #local i=i+1;
#end  
#debug "\n"
#end 

 
#macro InitArray(Array, Val)
#local i=0;
#while (i<dimension_size(Array, 1))
  #local j=0;
  #while(j<dimension_size(Array, 2))
    #declare Array[i][j]=Val;
    #local j=j+1;
  #end
  #local i=i+1;
#end
#end
         
         
//Calculate normals for triangles at grid points.         
#macro SmoothArray(inA)
#local dim=dimension_size(inA, 1);
#declare NArray=array[dim][dim]
InitArray(NArray, <0, 0, 0>)
#local i=0;
#while (i<dim-1)
  #local j=0;
  #while (j<dim-1)
  //triangle A
    #declare NArray[i][j]=NArray[i][j]+vcross(inA[i][j+1]-inA[i][j], inA[i+1][j+1]-inA[i][j]); //1
    #declare NArray[i][j+1]=NArray[i][j+1]+vcross(inA[i+1][j+1]-inA[i][j+1], inA[i][j]-inA[i][j+1]);  //2
    #declare NArray[i+1][j+1]=NArray[i+1][j+1]+vcross(inA[i][j]-inA[i+1][j+1],inA[i][j+1]-inA[i+1][j+1]);//3
  //triangle B 
    #declare NArray[i][j]=NArray[i][j]+vcross(inA[i+1][j+1]-inA[i][j], inA[i+1][j]-inA[i][j]);//a
    #declare NArray[i+1][j+1]=NArray[i+1][j+1]+vcross(inA[i+1][j]-inA[i+1][j+1], inA[i][j+1]-inA[i+1][j+1]);//b
    #declare NArray[i+1][j]=NArray[i+1][j]+vcross(inA[i][j]-inA[i+1][j], inA[i+1][j+1]-inA[i+1][j]); //c
    #local j=j+1;
  #end
  #local i=i+1;
#end
#end

//for normalizing the normals (is it necessary?)
#macro NormArray(inA)
#local dim=dimension_size(inA, 1);
#local i=0;
#while (i<dim)
  #local j=0;
  #while (j<dim)
    #declare inA[i][j]=vnormalize(inA[i][j]);
    #local j=j+1;
  #end
  #local i=i+1;
#end 
#end  

//write the triangles
#macro Array2Triangles(Pnts, Norm)
#local dim = dimension_size(Pnts, 1);
#local i=0;
#while (i<dim-1)
  #local j=0;
  #while (j<dim-1)
  //triangle A
    smooth_triangle {Pnts[i][j], Norm[i][j],
                     Pnts[i][j+1], Norm [i][j+1],
                     Pnts[i+1][j+1], Norm [i+1][j+1]
                     }
  //triangle B 
    smooth_triangle {Pnts[i][j], Norm[i][j],
                     Pnts[i+1][j+1], Norm [i+1][j+1],
                     Pnts[i+1][j], Norm [i+1][j]
                     }
    #local j=j+1;
  #end
  #local i=i+1;
#end
#end    
     



//This is an attempt to interpolate not just between grid points, but to do so on the triangle surfaces. 
//It is used for the placement of grass bunches. This actually returns a 3D vector.
//Note: triangulated square has diagonal from lower left to upper right (or min. X and Z to max X and Z).
#macro TInterp_LLUR(Array, posX, posZ) 
#local dim=dimension_size(Array, 1)-1;     
#local X=div(posX*dim, 1);
#local Z=div(posZ*dim, 1);  
#local Xinc=mod(posX*dim,1);
#local Zinc=mod(posZ*dim,1);
#if (Xinc>=Zinc)
#local result=((Array[Z][X]+(Array[Z+1][X+1]-Array[Z][X])*Xinc)*Zinc+ (Array[Z][X]+(Array[Z][X+1]-Array[Z][X])*Xinc))*(1-Zinc);  
#else
#local result=((Array[Z][X]+(Array[Z+1][X+1]-Array[Z][X])*Xinc)*(1-Zinc)+ (Array[Z+1][X]+(Array[Z+1][X+1]-Array[Z+1][X])*Xinc))*Zinc;
#end  
result
#end