#ifndef (UseAsINC) 
// ******
camera{
  location <.5, 1, -1>
  look_at <.5, 0, .5>
  angle 70
}

light_source {<100, 200, -100> color rgb 1}
plane {y, 0 pigment{checker color rgb 1, color rgb 0}}
plane {-z, -5 pigment{color rgb .8}}
// ******
#end      

#macro SFillRand (Array, freq, Rseed) //Fills a 1D array with random values interpolating between values
#local dim=dimension_size(Array, 1);
#local p=0; 
#local a=rand(Rseed); #local b=rand(Rseed);
#local i=0;
#while (i<dim)
  #if(div(i/freq,1)>p) #local p=p+1; #local a=b; #local b=rand(Rseed); #end    
  #local increment=mod(i/freq,1);
  #declare Array[i]=a+increment*(b-a);
  #local i=i+1;
#end
#end



#macro PerlinHF(Size, base_freq, vScale, seedval)  //where period is number of elements per lowest freq oscillation eg. 10
#declare pHF=array[Size][Size] 
#local Rseed =seed(seedval);  
#local freq1=base_freq; #local freq2=base_freq/2.2; #local freq3=freq2/2.2; #local freq4=freq3/2.2;      
#declare A1=array[Size] #declare A2=array[Size] #declare A3=array[Size] #declare A4=array[Size]             
#declare B1=array[Size] #declare B2=array[Size] #declare B3=array[Size] #declare B4=array[Size]

SFillRand(A1, freq1, Rseed) SFillRand(A2, freq2, Rseed) SFillRand(A3, freq3, Rseed) SFillRand(A4, freq3, Rseed)
SFillRand(B1, freq1, Rseed) SFillRand(B2, freq2, Rseed) SFillRand(B3, freq3, Rseed) SFillRand(B4, freq3, Rseed)
#local p1=0; #local p2=0; #local p3=0; #local p4=0;

//Now finish the rest of the array
#local Z=0;
#while (Z<Size)
  #local Zinc1=mod(Z/freq1,1); #local Zinc2=mod(Z/freq2,1); #local Zinc3=mod(Z/freq3,1); #local Zinc4=mod(Z/freq4,1);
  #if (div(Z/freq1,1)>=p1)  #local p1=p1+1; #declare A1=B1 SFillRand(B1, freq1, Rseed) #end
  #if (div(Z/freq2,1)>=p2)  #local p2=p2+1; #declare A2=B2 SFillRand(B2, freq2, Rseed) #end
  #if (div(Z/freq3,1)>=p3)  #local p3=p3+1; #declare A3=B3 SFillRand(B3, freq3, Rseed) #end
  #if (div(Z/freq4,1)>=p4)  #local p4=p4+1; #declare A4=B4 SFillRand(B4, freq4, Rseed) #end   
    
  #local X=0; 
  #while (X<Size)
    #local H=A1[X]+Zinc1*(B1[X]-A1[X]); 
    #local H=H+.5*A2[X]+Zinc2*(B2[X]-A2[X]);
    #local H=H+.25*A3[X]+Zinc3*(B3[X]-A3[X]);
    #local H=H+.03*A4[X]+Zinc4*(B4[X]-A4[X]);  
    #declare pHF[Z][X]=<X/Size, vScale*H/1.78, Z/Size>;
    #local X=X+1;
  #end
  #local Z=Z+1;
#end
#undef A1 #undef A2 #undef A3 #undef A4 #undef B1 #undef B2 #undef B3 #undef B4
#end

#macro TInterp_LLUR(Array, posX, posZ) //where triangulated square has diagonal from lower left to upper right
#local dim=dimension_size(Array, 1)-1;     
#local X=div(posX*dim, 1);
#local Z=div(posZ*dim, 1);  
#local Xinc=mod(posX*dim,1);
#local Zinc=mod(posZ*dim,1);
#if (Xinc>=Zinc)
#local result=((Array[Z][X]+(Array[Z+1][X+1]-Array[Z][X])*Xinc)*Zinc+ (Array[Z][X]+(Array[Z][X+1]-Array[Z][X])*Xinc))*(1-Zinc);  
#else
#local result=((Array[Z][X]+(Array[Z+1][X+1]-Array[Z][X])*Xinc)*(1-Zinc)+ (Array[Z+1][X]+(Array[Z+1][X+1]-Array[Z+1][X])*Xinc))*Zinc;
#end  
result
#end