//mountain.pov
//by Abe Madey  April 12, 1999
//
//This sets up the background mountain. Make sure you run HFgen.pov and SlopeGen.pov (in that order) first.
//
#ifndef(UseAsINC) 
#include "colors.inc"
camera {
  location <0, .01, -.5>
  //location <.5, 5, 5>
  direction z
  look_at <0, .1, .5>
  angle 50
}

light_source {<100, 100, -100> color rgb 1}
plane {y, -0.01 pigment{checker color rgb 1, color rgb 0}}
#end  

// **********************************
//     HF TEXTURING
// **********************************
//This is really a bit of a hack job in some places. When I finally got it to look OK I left it at that.
//It could really use some clear thinking editing!

#declare step_wave = slope_map{[.44 <0, 0>][.45 <1, 0>][.55 <1, 1>][.56 <0, 1>]} 
#declare r=.6;
#macro wavetype() slope_map{step_wave} ramp_wave #end 
#macro pattern() granite turbulence .05 lambda 3 omega 1.1 octaves 4 #end

//Normal Texture for Mountains - trying to get features on several scales
//could use some more work 
#declare rnorm =
  normal{
    average
    normal_map{
      [pattern()  bump_size r*.5 wavetype() scale 1]  
      [pattern() bump_size r*.7 wavetype() scale .5]
      [pattern() bump_size r*.9 wavetype() scale .25]
      [pattern() bump_size r wavetype() scale .12]
    } 
    scale 1
    translate 10
  }



#declare LowGrassColor =  color MediumForestGreen;
#declare BareColor =  color rgb <0.624,0.604,0.529>; 
#declare HiGrassPigment = pigment{granite color_map{[.3 BareColor][.3 rgb <0.463,0.557,0.259>]}scale .005}
//This takes alot of fiddling
#declare R_lim = .01; //"pure" bare rock limit
#declare G_lim = .5;  //"pure" grass limit


#declare bareNorm =   //not used
normal{granite bump_size 2 scale .06 sine_wave }


#declare GrassTex=
texture{
  pigment {
    gradient z       //for altitude dependence
    pigment_map{
    [.1 color LowGrassColor]
    [.35  HiGrassPigment]
    [.4  HiGrassPigment]
    [.43 color BareColor]
    [.6 color BareColor]
    [.67 color rgb 1]}
    scale .1 scale 10 warp {turbulence .1 lambda 3 omega 1.1 octaves 5}scale 1/10 //muddle the transition a bit
  } 
  normal{rnorm}  
}
#declare BareTex=texture{pigment{BareColor} normal {rnorm scale 1}}

//The aim here was to get a gradual transition between grass and rock instead of the usual
//"cake icing" effect achieved with image map based slope dependent textures. Sort of works.
#declare SlopeTex =
texture {
  material_map {
    png "SlopeGen.png" interpolate 4
    #declare i = 0;
    #while (i<256)
      #declare index = i/255;
      texture{
      #if (index<R_lim) 
               BareTex
               #else
                   #if ((index>=R_lim)  & (index<G_lim))
                     #declare index2 = (index-R_lim)*1/(G_lim-R_lim);
                     granite 
                     texture_map{[index2 GrassTex scale 200][index2 BareTex scale 200]}
                     scale .005
                   #else GrassTex #end
               #end  
      }
      #declare i = i+1;
    #end  
  }
  rotate x*90  translate <-.5, 0, -.5> //scale <2, 1, 2>  
}

   
#declare mountain =
height_field{
  png "HFgen.png" smooth
  //pigment{color rgb 1}
  translate <-.5, 0, -.5>
  water_level .05 //to trim off the surrounding flat "plane"
} 
 
#ifndef(UseAsINC) 
object {
  mountain
  scale<1, .1, 1>   
  texture{SlopeTex}
}                     
#end
