#include "macs.inc"
#include "AMacros.inc"

// **************************
//     TEST CAMERA & LIGHTS         
// **************************
#ifndef (UseAsINC) 
#include "colors.inc"
camera {
  location <0, 1, -5>
  direction z
  look_at y*.5
  angle 25
}

light_source {<100, 100, -100> color rgb 1}
plane {y, 0 pigment{checker color rgb 1, color rgb 0}}
plane {-z, -5 pigment{color rgb .8}}
#end 
// **************************

//How to explain the grass growing process...? In rough outline: make the basic grid for one blade and
//apply curvature etc to it, then assemble the blades into bunches, then plant these bunches.
  
   
//This macro makes one blade of grass. It is constructed as follows on the XY plane looking in the +Z dir.:
//
//             x         x = grid point (or triangle vertex)
//           / | \               
//          /  |  \
//          x_ x _x  -
//          | /  /|   |_ Segment (this bade has four)
//          |/ |/ |   |
//          x_ x _x  -
//          | /| /|
//          |/ |/ |
//          x_ x _x
//          | /| /|
//          |/ |/ |
//          x_ x _x   
// 
//Additionally, this blade has a "V" cross section in an attempt to model in more realism. However, the
//way in which the triangle normals are implemented later on kind of kills the effect (becomes more of
//a cup shaped cross section. Ideally, the triangle edges in the center should _not_ share normals as they
//presently do. Frankly, for the way it is used now, this model is bigtime overkill, but then I started
//this project with the grass, so go figure!          
//I hope this may help clarify some of the following convoluted code (goodness knows I need the 
//clarifiction myself!)
//"H2W" is the height to width ratio, "Curvature" is the amount of curl in the blade, "Twist" I never
//got around to implementing. Note: the values in the last row of the array are all the same, since this
//is the tip of the blade.         
#macro NewMakeBlade(Segments, H2W, Curvature, Twist)
RandArray(10, 10, Curvature)  
#local Rows = Segments+1;
#local Cols = 3;
#local CurveStep=Curvature/Segments;
#local Xsectn=.5*<1, 0, -.5>*H2W;  //Z displacement of the center of the "V" cross section
#declare GrsP_A = array[Rows][Cols] 
#declare GrsN_A = array[Rows][Cols]  
#local zero=<0, 0, 0>;    
#local seglen=0; #local p1=<0, 0, 0>;  #local p2=Xsectn;
#local i=0; 
#while (i<Rows-1)     
  #declare GrsP_A[i][0]=p2; #declare GrsP_A[i][1]=p1; #declare GrsP_A[i][2]=p2*<-1, 1, 1>;
  #declare GrsN_A[i][0]=zero;  #declare GrsN_A[i][1]=zero;  #declare GrsN_A[i][2]=zero;
  #local i=i+1;
  #local R=(.5-Srand(i, 10))*20; 
  //Spacing of segments and width too are decreased towards the tip for a smoother transition to the tip.
  #local seglen=sqrt(i/Segments)-sqrt((i-1)/Segments); 
  //Center points and only one edge are operated on; the other edge is created later as a mirror.    
  #local p1=p1+vaxis_rotate(y*seglen, x, (CurveStep+R)*i);
  #local p2=p1+vaxis_rotate(Xsectn*<1,1,(1-(i/Segments))>, x, CurveStep*i)*(1-(i/Segments)); 
  #end 
#declare GrsP_A[i][0]=p1;  #declare GrsP_A[i][1]=p1;  #declare GrsP_A[i][2]=p1;
#declare GrsN_A[i][0]=zero;  #declare GrsN_A[i][1]=zero;  #declare GrsN_A[i][2]=zero;
#end

//This macro calculates the normals for the triangle mesh
#macro CalcNormal (Array)
#local ArrayROW = dimension_size(Array, 1); #local ArrayCOL = dimension_size(Array, 2); 
//#local P = array [ArrayROW][ArrayCOL] 
#local P = Array  
#local i = 0;
#while (i<ArrayROW-2)
  #local j = 0;
  #while (j<ArrayCOL-1)
    // first ("left") triangle in square - I think
    #declare GrsN_A[i][j] = GrsN_A[i][j] + vcross(P[i+1][j]-P[i][j], P[i][j+1]-P[i][j]); //Pt A
    #declare GrsN_A[i][j+1] = GrsN_A[i][j+1] + vcross(P[i][j]-P[i][j+1], P[i+1][j]-P[i][j+1]); //Pt B
    #declare GrsN_A[i+1][j] = GrsN_A[i+1][j] + vcross(P[i][j+1]-P[i+1][j], P[i][j]-P[i+1][j]); //Pt C
    // second ("right") triangle in square - I think
    #declare GrsN_A[i+1][j+1] = GrsN_A[i+1][j+1] + vcross(P[i][j+1]-P[i+1][j+1], P[i+1][j]-P[i+1][j+1]); //Pt 1
    #declare GrsN_A[i+1][j] = GrsN_A[i+1][j] + vcross(P[i+1][j+1]-P[i+1][j], P[i][j+1]-P[i+1][j]); //Pt 3
    #declare GrsN_A[i][j+1] = GrsN_A[i][j+1] + vcross(P[i+1][j]-P[i][j+1], P[i+1][j+1]-P[i][j+1]); //Pt 2
    #local j = j+1;
  #end
  #local i = i+1;
#end
#local j=0;
#while (j<ArrayCOL-1)
  //avoiding a 0 length normal due to all pts equal in top row
  #declare GrsN_A[i+1][j+1] = GrsN_A[i+1][j+1] + vcross(P[i][j]-P[i+1][j+1], P[i][j+1]-P[i+1][j+1]); //Pt 2
  #declare GrsN_A[i+1][j] = GrsN_A[i+1][j] + vcross(P[i][j]-P[i+1][j+1], P[i][j+1]-P[i+1][j+1]); //Pt 3
  #local j=j+1;         
#end                                 
#local i = 0;  

// Normalize the normals - does it matter?
#while (i<ArrayROW)
  #local j = 0;
  #while (j<ArrayCOL)
    #declare GrsN_A[i][j] = vnormalize (GrsN_A[i][j]);
    #local j = j+1;
  #end
  #local i = i+1;
#end
#end  

//This is a custom job to take care of four operations in one loop
#macro Adjust(Array, Scal, Rot1, Trans, Rot2)   
#local Rows=dimension_size(Array, 1); #local Cols=dimension_size(Array, 2);
#local i=0;
#while (i<Rows)
  #local j=0;
  #while (j<Cols)   
    #declare Array[i][j]=Array[i][j]*Scal;
    #declare Array[i][j]=vaxis_rotate(Array[i][j], x, Rot1); 
    #declare Array[i][j]=Array[i][j]+Trans;
    #declare Array[i][j]=vaxis_rotate(Array[i][j], y, Rot2);
    #local j=j+1;
  #end
  #local i=i+1;
#end
#end   

//Not used
#macro Rot(Array1, Array2, RotAmt, axis)
#local Rows=dimension_size(Array1, 1); #local Cols=dimension_size(Array1, 2);
#local i=0;
#while (i<Rows)
  #local j=0;
  #while (j<Cols)
    #declare Array1[i][j]=vaxis_rotate(Array1[i][j], axis, RotAmt);
    #declare Array2[i][j]=vaxis_rotate(Array2[i][j], axis, RotAmt);
    #local j=j+1;
  #end
  #local i=i+1;
#end
#end    

//Not used
#macro Tran(Array1, Array2, TransAmt)
#local Rows=dimension_size(Array1, 1); #local Cols=dimension_size(Array1, 2);
#local i=0;
#while (i<Rows)
  #local j=0;
  #while (j<Cols)
    #declare Array1[i][j]=Array1[i][j]+TransAmt;
    #declare Array2[i][j]=Array2[i][j]+TransAmt;
    #local j=j+1;
  #end
  #local i=i+1;
#end
#end

//Not used
#macro Scale(Array1, ScaleAmt)
#local Rows=dimension_size(Array1, 1); #local Cols=dimension_size(Array1, 2);
#local i=0;
#while (i<Rows)
  #local j=0;
  #while (j<Cols)
    #declare Array1[i][j]=Array1[i][j]*ScaleAmt;
    //#declare Array2[i][j]=Array2[i][j]*ScaleAmt;
    #local j=j+1;
  #end
  #local i=i+1;
#end
#end    

//for debugging
#macro PrintArray(A)
#local Rows=dimension_size(A, 1); #local Cols=dimension_size(A, 2);   
#local p=6; #local d=5;
#local i=0;
#while (i<Rows)
  #local j=0;
  #while (j<Cols)  
    #debug concat("<",str(A[i][j].x,p,d),",",str(A[i][j].y,p,d),",",str(A[i][j].z,p,d),"> ")
    #local j=j+1;
  #end  
  #debug "\n"
  #local i=i+1;
#end  
#debug "\n"
#end

//Making the triangles from the grid points
#macro MakeTriangles(P, N)
#local Rows=dimension_size(P, 1); #local Cols=dimension_size(P, 2);
#local i=0;
#while (i<Rows-2)
  #local j=0;
  #while (j<Cols-1)
    smooth_triangle {//"right" triangle
      P[i][j], N[i][j], P[i+1][j], N[i+1][j], P[i][j+1], N[i][j+1]
    }
    smooth_triangle {//"left" triangle
      P[i+1][j+1], N[i+1][j+1], P[i][j+1], N[i][j+1], P[i+1][j], N[i+1][j] 
    }
    #local j=j+1;
  #end
  #local i=i+1;
#end
#local j=0;
#while (j<Cols-1)
  smooth_triangle {// tip
    P[Rows-2][j], N[Rows-2][j], P[Rows-1][j], N[Rows-1][j], P[Rows-2][j+1],N[Rows-2][j+1]
  }
  #local j=j+1;
#end 
#end


#macro Init_1D_Array(Array, Value)
#local Rows=dimension_size(Array, 1)
#local i=0;
#while(i<Rows)
  #declare Array[i]=Value;
  #local i=i+1;
#end
#end

//This was used to make an individual blade - abandoned in favor on a slightly arrangement below
//where the whole bunch, not each blade, is a mesh object. 
#macro MakeBlades(Nseg)
#declare blade_scale = 1;//.03;
#local nBlades=30;
#declare G=array[nBlades]
#local n=0; 
#local #local S=seed(6); 
#while(n<nBlades)
  #declare G[n] =
  mesh{  
    NewMakeBlade(Nseg, .05, 30+150*rand(S), 1)
    CalcNormal (GrsP_A)
    MakeTriangles(GrsP_A, GrsN_A)
    pigment{color green 1}
  }
  #local n=n+1;
#end
#end
   
//MakeBlades() //uncomment to use - intended for testing

//Making the whole bunch in one mesh. 
#macro MakeBunch(NumberOfBlades,  blade_scale, seedval)
#local n=0; 
#local S1=seed(seedval);  
#local nBlades=NumberOfBlades;
mesh {  
        #local n=0; 
        #local Nseg = 10;
        #while(n<nBlades)
            NewMakeBlade(Nseg, .05, 30+150*rand(S1), 1)
            Adjust(GrsP_A, blade_scale, 40*rand(S1), z*0.03*rand(S1)*blade_scale, 360*rand(S1))
            CalcNormal (GrsP_A)
            MakeTriangles(GrsP_A, GrsN_A)
            
        #local n=n+1;
        #end 
pigment{color MediumForestGreen}
finish{specular .15 roughness .3} //most long flat bladed grasses have some specular highlights.        
}
#end  

//MakeBunch(15, 10) //uncomment to use - intended for testing


//Put the bunches in an array from which they will later be randomly chosen for placement on terrain.
#macro MakeBunchArray(nBlades, N, grass_scale, s)
#local S=seed(s);
#declare BunchArray=array[N]
#local i=0;
#while (i<N)   
  #declare BunchArray[i]=MakeBunch(nBlades, grass_scale, rand(S))
  #local i=i+1;
  #debug concat("Bunch #", str(i,2,0), " done. \n")
#end
#debug "Finished making BunchArray \n"
#end 

//MakeBunchArray(5, 2, <1, 1, 1>, 3)    //again for testing
//object{BunchArray[1]}




