//SlopeGen.pov
//by Abe Madey   April 12, 1999
//
//Use this file to generate the image for the slope dependent texture map. Run HFgen.pov first.
//Suggested command line options: +w400 +h400 +FN
//

camera {
  location y*2 
  direction -y 
  orthographic
  up z
  right x
}

light_source {y*1000000 color rgb 2}
global_settings { hf_gray_16 on }


//The gradient pigment used here was intended to supply some altitude dependence for the texture map.
//However, in retrospect, it is probably better to use a plain white pigment and take care of
//the altitude dependence later in the actual HF texture. 
//Also had the idea of using a normal to rough it up a bit, but decided against it.

height_field {
  png "c:\graphics\images\HFgen.png" smooth 
  translate <-.5, 0, -.5> scale 1.000000000001 
  pigment {
    //color rgb 1  
    gradient y 
    color_map{[0 rgb 1][1 rgb 1]}
    }  
  //normal{granite bump_size .01 scale .05 scale 8 warp {turbulence .1 lambda 2.4 omega 2.8 octaves 4} scale 1/8}
  finish {ambient 0 diffuse 1}
}
