//Afternoon.pov
//By Abe Madey   April 12, 1999
//necessary files: mountain.pov, grass.pov, terr_gen.pov, HFgen.png(from HFgen.pov) 
//and Slopegen.png (from SlopeGen.pov) 
//NOTE:Before running this scene it is necessary to run HFgen.pov and SlopeGen.pov (in that order)
//for their images. Remember also to put these images in the working directory or at least in some 
//library path.
//
//Comments: This POV scene is an excercise in "pure" POV. Generally these types of scenes
//(object placement on terrain, fancy textures, etc.) are done with the help of some external
//progam (often platform specific). Now with POV3.1's greater programming ability, I had the itch 
//to try and do it all within POV. 
//This scene is by no means perfected and needs to be cleaned up in alot of corners. 
//
//This file (with its associated files) is only moderately cleaned up. I have intentionally left in
//some unused macros, and "commented out" lines. The may still be of use if you decide to play with this.
//In regards to using this scene yourself - feel free to mess with it! 
//I only as for appropriate credit should you render and display it un- (or mostly un-) altered form.

                                                                                               
// ****************************
#declare UseAsINC=off; 
#include "Colors.inc"
#include "grass.pov"
#include "terr_gen.pov" 
#include "mountain.pov"   
object {
  mountain
  scale<1, .1, 1>   
  texture{SlopeTex}
  scale 4
  rotate -y*10
  translate <.7, .10, 1.6>
}          

//Do the forground terrain
PerlinHF(20, 20, .3, 3)  
SmoothArray(pHF)  
NormArray(NArray)  
mesh{
  Array2Triangles(pHF, NArray) 
  texture {pigment {color Bronze2} normal{granite sine_wave bump_size .1 scale .01}}
}
#debug "Finished generating terrain \n"

//Just a test to see if objects were placed correctly on the surface
//#declare posit=<.5, 0, .5>;
//#declare posit = TInterp_LLUR(pHF, posit.x, posit.z);
//sphere{0, .05 pigment{color green 1} translate posit+y*.05}   

#declare GrassSwitch=on;  //Turn grass on or off
#if(GrassSwitch)
// SET GRASS PARAMETERS HERE (these are the origional settings, but by no means set in stone!
#local blade_scale =<.027, .023, .027>;
#local blade_segments = 10;  
#local blades_per_bunch = 15;
#local Nbunches = 5;      //number of different bunches; these will be copied to cover the terrain
#local bunch_copies=25000;//number of copies
#local seedval=3;
// 
#declare ss1=seed(8); 
MakeBunchArray(blades_per_bunch, Nbunches, blade_scale, seedval)  //this can take a while
#local i=0;
//start planting grass!
#while (i<bunch_copies)
  #local rX=rand(ss1); #local rZ=rand(ss1);
  #local posit =<.5, 0, .1>+<(.6-rX)*.6, 0, rZ*.9>; //use posit=<rX, 0, rZ> to cover the whole terrain mesh
  #local height=TInterp_LLUR(pHF, posit.x, posit.z);
  #local posit=<height.x, height.y, height.z>;
  object{BunchArray[floor(rand(ss1)*Nbunches)] rotate <.01, 1, .01>*360*rand(ss1) scale 1-rand(ss1)*.1 translate posit}
  #local i=i+1;
#end 
#end 

// Atmosphere stuff
#macro atmos_media_params ()           
 intervals 8  //Set to 3 or 5 for preview; 10 or 12 for final rendering
 samples 1, 40
 variance 1/256
 confidence .999  
#end


#macro cloud_media_params ()
 intervals 12 //Set to 5 or so for preview; 13 or 17 for final rendering
 samples 1, 40
 variance 1/256
 confidence .999  
#end


#declare atmos=on; //switching this off will use a simple sky globe instead
#if(atmos)

//Blue Haze/Sky 
//Note: quality wise it makes a big difference if the media is contained or not.
//I set this up in the following manner:
//  a. tune the media so the haze looks good in front of the mountain.
//  b. tune the vertical scaling of the container so the sky is right overhead.
//  c. tune the horizontal scaling of the container so the horizon looks OK - this gets tricky which
//     is why I tried a little absorption media too.
difference {
  sphere{<0, 0, 0>, 40 hollow scale <1, 2/40, 1>}
  sphere{<0, 0, 0>, 1 hollow} //did this to get the media out of the grass in hopes of improving speed.
  pigment{color rgbf 1} 
  interior{
    media{
      atmos_media_params()
      scattering {4 rgb<.18, .18, .36>*.3 extinction .3}
    }
    media{absorption rgb .08}
  }
}  


//This is the density description for the clouds - need work.
#declare cloud_density  =
density {
  planar scale .3
  translate y*1.4
  density_map {
    #declare i = 0;
    #while (i<.65) //this is to try and round off the tops of the clouds 
    [i/.65 granite scale 15 translate -z*0 color_map{[.35+i rgb 0][.35+i rgb 1]}]
    #declare i = i+.01;
  #end 
  }
} 

//Cloud container - move this up and down (scaling clouds last) until the dark parts of the clouds
//have the appropriate amount of blue haze color. 
box{
  <-30, 1.4, 0>, <30, 1.7, 50>
  hollow
  pigment{color rgbf 1}
  interior{
    media{ 
      cloud_media_params()
      scattering{1 rgb 4 extinction 1.5} //This scattering/extinction ratio is tough to get right for clouds
      density{cloud_density}
    }
  }
}
#else 

sky_sphere {
    pigment {
      gradient y
      color_map {
        [ 0.5  color CornflowerBlue ]
        [ 1.0  color MidnightBlue ]
      }
      scale 2
      translate -1
    }
  }
#end     

// ********************************
//             LIGHTS
// ********************************
//Extra lighting to "punch through" media. Again a parameter that needs fiddling to get it right.
light_source {<100, 100, 50> color rgb 1.5} 
light_source {<101, 101, 50.5> color rgb 1.0 media_interaction off} 
light_source {y*100000 color CornflowerBlue media_interaction off}
//plane {y, 0 pigment{checker color rgb 1, color rgb 0}}   // Test plane from devlopment phase

// ********************************
//             CAMERA
// ********************************
camera {
  #local posit =<.5, 0, .1>;
  #local height=TInterp_LLUR(pHF, posit.x, posit.z); //Set the camera above the forground terrain.
  #local posit=<posit.x, height.y+.07, posit.z>;
  location <0, 0, 0>
  direction z
  rotate -x*5  rotate y*5
  translate posit
  angle 30
}