camera{location <0,100,-400> look_at <0,0,0>}
                            
//licht

light_source{<1000,500,-500> color rgb <1,1,1>*.8}

light_source{<1000,500,-500> color rgb <1,1,1>*.7 shadowless}
light_source{<-1000,500,500> color rgb <1,1,1>*.5 shadowless}
light_source{<-1000,500,-500> color rgb <1,1,1>*.3 shadowless}

light_source{<1000,500,-500> color rgb <1,.9,.2> shadowless}
light_source{<-1000,2500,500> color rgb <.2,.4,1> shadowless}

//pov-ray-tekst

#warning concat("pov lezen"+"\n")

#include "pov.inc"  

#warning concat("pov maken"+"\n")

#declare ss=7;

blob{threshold.7
#declare tt=0;
#while (tt<pcount)                                     
  #declare cs=sin(px[tt]*pi*.5/size_hor);    
  #declare cc=cos(px[tt]*pi*.5/size_hor);    
  #declare p1=<-cent_hor*cc*1.2,py[tt]*(1-cs/5)+size_ver*cs*.75,size_hor*cs*.5>;     
  #declare p2=p1*1.02;
  cylinder{p1,p2,ss,gg[tt]/100}
  #declare tt=tt+1;
#end               
translate<cent_hor/2,-cent_ver/2,0>
pigment{rgb<.9,.6,.1>}
normal{bumps .2 turbulence .2 scale 20}
finish{reflection .25 specular 1 metallic} 
}

//now!-tekst

#declare rr=seed(777);

#declare ss=2;

#warning concat("now lezen"+"\n")

#include "now.inc"  

#warning concat("now maken"+"\n")

blob{threshold.7
#declare tt=0;
#while (tt<pcount) 
  #if (gg[tt]=255)             
    #if (rand(rr)>.25)
      sphere{<(px[tt]-cent_hor)*1.4,py[tt],0>,ss,2*rand(rr)}
    #end
  #else
    sphere{<(px[tt]-cent_hor)*1.4,py[tt],0>,ss,-1-2*rand(rr)}
  #end
  #declare tt=tt+1;
#end       
translate<cent_hor/4,-cent_ver/2,cent_hor/4>
scale<1,1,5>
pigment{rgb<.8,.4,1>}
}

//grondvlak

plane{y,0 hollow on
  pigment{
  checker
    color rgb .75
    color rgb 0
    scale 80
  }
  rotate y*60
  translate y*-cent_ver/2}

difference{

cylinder{<0,-cent_hor,cent_ver><size_hor+cent_hor,cent_hor*2,cent_ver>,size_ver/5
pigment{rgb<.4,.5,.4>}
finish{phong .7 phong_size 70 reflection .25 specular 1}
}

//buis met 3-tekst

text
{ttf "c:\windows\fonts\impact.ttf","3", 20, 0
rotate z*45    
scale 56
translate <cent_hor+cent_ver/4,0,0>
pigment{rgb 3}

} 
scale 2 
translate <cent_ver/2-cent_hor/4,cent_ver/2,cent_hor>
}                                                                 

//reflectie-vla (achter camera)

plane{z,0 
  pigment{
    granite 
    color_map{
      [0 rgb 1]
      [.1 rgb<0,0,1>]
      [.2 rgb<0,0,.1>]
      [1 rgb 0]
      } 
    scale 10000
  } 
  translate z*-1000
}

//mist

fog
{
  fog_type   2
  distance   250
  color      rgb <1,1,.9>
  fog_offset 0.1
  fog_alt    10
  turbulence 0.8
}

//lucht

#include "colors.inc"

sphere { <0, 0, 0>, 5000 hollow
   pigment { gradient <0,1,0>
             color_map {
                [ 0.0 color rgb<.6,.9,1>]
                [ 0.3 color rgb<.5,.7,.9> ]
                [ 1.0 color rgb<.3,.5,.7>]
             }
             scale 5000
   }
   finish {
      ambient 0.7
      diffuse 0 
   }
}

sphere { <0, 0, 0>, 4900 scale <1,0.075,1> hollow
  pigment{
    granite
    turbulence 0.1
    color_map {
       [ 0.0 color Clear ]
       [ 0.3 color Clear ]
       [ 1.0 color White ]
    }
    scale<2500,10000,2500>
  }
  finish {ambient 0.7 diffuse 0}
  rotate y*70
}

//eof        

