//LightSabre
//Kenyon Banks



#include "colors.inc"


//######################ENVIRONMENT

global_settings { assumed_gamma 2.2 }

light_source { <-60, 10, -40> rgb 0.6 shadowless}
light_source { <40, 340, -400> rgb 1.0 }


camera { location <0, 34, 0> look_at <0, 0, 0>}

union{
plane { z, 58 hollow}
plane { y, -1 hollow}
pigment { color Black }
finish {
ambient 0.67
    brilliance 4
    diffuse 0.53
    metallic
    specular 0.80
    roughness 1/200
    reflection 0.25
    }
}

//######################DECLARATIONS FOR TEXTURES

#declare Metal_finish=finish {
    ambient 0.67
    brilliance 4
    diffuse 0.7
    metallic
    specular 0.80
    roughness 1/80
    reflection 0.2
}

#declare Metal_1= texture {
pigment { color rgb <0.70, 0.55, 0.45>}
finish {Metal_finish}
}

#declare Metal_2= texture {
pigment { color rgb 0.735 }
finish { Metal_finish }
}

#declare Metal_3= texture {
pigment { color rgb 0.535 }
finish { Metal_finish }
}

#declare Lens_Glass=
finish {
    ambient 0.4
    diffuse 0.1
    reflection .25
    specular 1
    roughness 0.001
}

#declare Media = media {
  emission .7	//1.25
  intervals 5
  samples 2, 20
  confidence 0.9999
  variance 1/1000
  density {
    cylindrical
    turbulence 0.05
    color_map {                
      [0.0 color rgbt <0, 0, 0, 1>]   
      [0.2 color rgbt <0, 0, 0, 1>]
      [1.0 color rgbt <0.216078, 0.85, 0.216078, 0.8>]
    } 
  }
 }

#declare sub_Media = media {
  emission 1.25 //1.95
  intervals 5
  samples 1, 2
  confidence 0.9999
  variance 1/1000
  density {
  	cylindrical
    sine_wave 
    turbulence 0.1
    color_map {
      [0.0 color rgb <0, 0, 0>]
      //[0.3 color rgb <0.75, 1, 0.75>] 
      [1.0 color rgb <1, 1, 1>*2]
    } 
  }
 }

//######################DECLARATIONS FOR OBJECTS

#declare Lens_Core=
union {
  lathe {
    cubic_spline

    16,
  
    <2, -1>,       //1
    <2, -3>,       //2
    <4, -3>,       //3
    <5.8, -1>,     //4
    <5.95, -0.5>,  //5
    <5.87, 0.1>,   //6
    <5.8, 1>,      //7
    <5.7, 1.5>,    //8
    <5.2, 2.0>,    //9
    <4.9, 1.9>,    //10
    <3.0, 0.1>,    //11
    <3.35, -0.65>, //12
    <3.0, -1>,     //13
    <2.0, -1>,     //14
    <2, -3>,       //15
    <2, -3>        //16
    texture { Metal_1 }
  }
  
lathe {
  cubic_spline
  7,
  <0.0, -1>,       //1
  <3.0, -1>,       //2
  <3.35, -0.65>,   //3
  <3.0, 0.1>,      //4
  <0.0, 0.9>,      //5
  <0.0, -1>,       //6
  <3.0, -1>        //7
  pigment { color rgb <0.85, 1, 0.85> transmit 0.8}
  finish { Lens_Glass }
  
  }

union {
superellipsoid { <0.9, 0.9> scale <1.35, 1, 0.5> pigment {color Green transmit 0.5}finish {Lens_Glass } rotate x*35 translate <0, 1, 4> hollow }
superellipsoid { <0.9, 0.9> scale <1.35, 1, 0.5> pigment {color Green transmit 0.5}finish {Lens_Glass } rotate x*35 translate <0, 1, 4> rotate y*45 hollow }
superellipsoid { <0.9, 0.9> scale <1.35, 1, 0.5> pigment {color Green transmit 0.5}finish {Lens_Glass } rotate x*35 translate <0, 1, 4> rotate y*90  hollow }
superellipsoid { <0.9, 0.9> scale <1.35, 1, 0.5> pigment {color Green transmit 0.5}finish {Lens_Glass } rotate x*35 translate <0, 1, 4> rotate y*135  hollow }
superellipsoid { <0.9, 0.9> scale <1.35, 1, 0.5> pigment {color Green transmit 0.5}finish {Lens_Glass } rotate x*35 translate <0, 1, 4> rotate y*180  hollow }
superellipsoid { <0.9, 0.9> scale <1.35, 1, 0.5> pigment {color Green transmit 0.5}finish {Lens_Glass } rotate x*35 translate <0, 1, 4> rotate y*225  hollow }
superellipsoid { <0.9, 0.9> scale <1.35, 1, 0.5> pigment {color Green transmit 0.5}finish {Lens_Glass } rotate x*35 translate <0, 1, 4> rotate y*270  hollow }
superellipsoid { <0.9, 0.9> scale <1.35, 1, 0.5> pigment {color Green transmit 0.5}finish {Lens_Glass } rotate x*35 translate <0, 1, 4> rotate y*315  hollow }

superellipsoid {<0.9, 0.9>scale<0.8,0.8,1.3>pigment{rgbf<1,1,1,1>}finish{ambient 0.8}interior {media{Media}}rotate x*35 translate<0, 1, 3.8>hollow}
superellipsoid { <0.9, 0.9>scale<0.8,0.8,1.3>pigment{rgbf<1,1,1,1>}finish{ambient 0.8}interior {media{Media}}rotate x*35 translate <0, 1, 4> rotate y*45 hollow}
superellipsoid { <0.9, 0.9>scale<0.8,0.8,1.3>pigment{rgbf<1,1,1,1>}finish{ambient 0.8}interior {media{Media}}rotate x*35 translate <0, 1, 4> rotate y*90 hollow}
superellipsoid { <0.9, 0.9>scale<0.8,0.8,1.3>pigment{rgbf<1,1,1,1>}finish{ambient 0.8}interior {media{Media}}rotate x*35 translate <0, 1, 4> rotate y*135 hollow}
superellipsoid { <0.9, 0.9>scale<0.8,0.8,1.3>pigment{rgbf<1,1,1,1>}finish{ambient 0.8}interior {media{Media}}rotate x*35 translate <0, 1, 4> rotate y*180 hollow}
superellipsoid { <0.9, 0.9>scale<0.8,0.8,1.3>pigment{rgbf<1,1,1,1>}finish{ambient 0.8}interior {media{Media}}rotate x*35 translate <0, 1, 4> rotate y*225 hollow}
superellipsoid { <0.9, 0.9>scale<0.8,0.8,1.3>pigment{rgbf<1,1,1,1>}finish{ambient 0.8}interior {media{Media}}rotate x*35 translate <0, 1, 4> rotate y*270 hollow}
superellipsoid { <0.9, 0.9>scale<0.8,0.8,1.3>pigment{rgbf<1,1,1,1>}finish{ambient 0.8}interior {media{Media}}rotate x*35 translate <0, 1, 4> rotate y*315 hollow} 
}
}

#declare scythe=
difference{
sphere { 0, 1    scale <2, 4, 0.11>}
union {
sphere { 0, 1  scale <1, 1.3, 1> translate <1.6, 1.8, 0>} 
box {<0, 0, -0.3>, <-3, 6, 0.3> } 
sphere {0, 1  scale <1, 2.7,1> rotate z*-22 translate <1.3, -1.8, 0>}
}
scale <2, 2, 5>
texture { Metal_1 }
}

#declare scythe_A=
union {
object { scythe translate <5.9, 0, 0>}
object { scythe translate <5.9, 0, 0> rotate y*90}
object { scythe translate <5.9, 0, 0> rotate y*180}
object { scythe translate <5.9, 0, 0> rotate y*270}
}

#declare handle_rings=
union{
torus { 3.85, 0.5 texture { Metal_2 } translate <0, -3.3, 0>}
torus { 4, 0.45 texture { Metal_2 } translate <0, -3.5, 0>}
torus { 4.3, 0.15 texture { Metal_2} translate <0, -3.7, 0>}
cylinder { <0, -3.3, 0>, <0, -50, 0> 3.85 texture {Metal_1}}
}

 #declare Grip_Line=
union {
superellipsoid { <0.3, 1.0>scale <0.8, 0.8, 1>  }
superellipsoid { <0.3, 1.0>scale <0.8, 0.8, 1> translate y*-1  }
superellipsoid { <0.3, 1.0>scale <0.8, 0.8, 1> translate y*-2  }
superellipsoid { <0.3, 1.0>scale <0.8, 0.8, 1> translate y*-3  }
superellipsoid { <0.3, 1.0>scale <0.8, 0.8, 1> translate y*-4  }
superellipsoid { <0.3, 1.0>scale <0.8, 0.8, 1> translate y*-5  }
superellipsoid { <0.3, 1.0>scale <0.8, 0.8, 1> translate y*-6  }
superellipsoid { <0.3, 1.0>scale <0.8, 0.8, 1> translate y*-7  }
superellipsoid { <0.3, 1.0>scale <0.8, 0.8, 1> translate y*-8  }
superellipsoid { <0.3, 1.0>scale <0.8, 0.8, 1> translate y*-9  }
superellipsoid { <0.3, 1.0>scale <0.8, 0.8, 1> translate y*-10 }
superellipsoid { <0.3, 1.0>scale <0.8, 0.8, 1> translate y*-11 }
superellipsoid { <0.3, 1.0>scale <0.8, 0.8, 1> translate y*-12 }
superellipsoid { <0.3, 1.0>scale <0.8, 0.8, 1> translate y*-13 }
superellipsoid { <0.3, 1.0>scale <0.8, 0.8, 1> translate y*-14 }
superellipsoid { <0.3, 1.0>scale <0.8, 0.8, 1> translate y*-15 }
superellipsoid { <0.3, 1.0>scale <0.8, 0.8, 1> translate y*-16 }
superellipsoid { <0.3, 1.0>scale <0.8, 0.8, 1> translate y*-17 }
superellipsoid { <0.3, 1.0>scale <0.8, 0.8, 1> translate y*-18 }
superellipsoid { <0.3, 1.0>scale <0.8, 0.8, 1> translate y*-19 }
texture { Metal_3 }
translate <0,-22,-3.068>
} 

#declare Grip_Line_A=
union{
object {Grip_Line }
object {Grip_Line rotate y*9}
object {Grip_Line rotate y*18}
object {Grip_Line rotate y*27}
object {Grip_Line rotate y*36}
object {Grip_Line rotate y*45}
object {Grip_Line rotate y*54}
object {Grip_Line rotate y*63}
object {Grip_Line rotate y*72}
object {Grip_Line rotate y*81}
}

#declare sabre_light_aura=
merge {
 cone { <0, 0.5, 0> 3, < 0, 160, 0> .6
 pigment { color rgb <0.85, 1, 0.85> transmit 0.8}
 }
 sphere { <0, 160, 0> .6
 pigment { color rgb <0.85, 1, 0.85> transmit 0.8}
 }
 hollow
 }

#declare Sabre_Blade=
 union {  
 
 merge {
 cone { <0, 0.25, 0> .4, < 0, 33.75, 0> .3
 hollow
 }
 sphere { <0, 33.75, 0> .3
 hollow
 }
 pigment { rgbf <1, 1, 1, 1>}
 finish  { ambient 0.8 }
 interior {media {sub_Media} }
 }
 
 merge {
 cone { <0, 0.0, 0> 1.25, < 0, 34, 0> .9
 hollow
 }
 sphere { <0, 34, 0> .9
 hollow
 }
 pigment { rgbt <1, 1, 1, 1>}
 finish  { ambient 0.3 }
 interior {media {Media} }
 }
 scale <1.9, 1, 1.9>  //<1.5, 1, 1.5>
 }
 
//######################SCENE

union {
object { scythe_A rotate y*33 scale 0.2 } 
object { handle_rings scale 0.2}
object { Grip_Line_A scale 0.2}
object { Grip_Line_A scale 0.2 rotate y*90 }
object { Grip_Line_A scale 0.2 rotate y*180 }
object { Grip_Line_A  scale 0.2 rotate y*270 } 
object { Sabre_Blade } 
object { Lens_Core scale 0.2}

rotate x*90
translate <0, 0, -12>
rotate y*45
 }