// Test for GBSurf macros.

camera {
        location <0, 10, -15>
        look_at  <0, 0,  0>
}

light_source {   // Light1
  <-986.689, 1003.370, -1011.881>
  color rgb <1.000, 1.000, 1.000>
}

#include "GBGenMac.inc"
#include "GBSurf.inc"

#declare SurfText =
texture {
        pigment {
                colour rgb <0.9,0.7,0>
                }
        finish {
                ambient 0.3
                diffuse 0.65
                phong 0.3
                phong_size 20
                }
        }

#declare ContPoint = array[5]
        { <-5,2,5>, <0,1,5>, <10,-2,5>, <-5,-1,-10>, <5,-5,-5> }
// Control points specifiy X,Z poition and Y height at that position.
        
#declare ContSize = array[5]
        { 10, 10, 10, 3, 10 }
// Control sizes specify the radius of influence of the corresponding control point.

// Draw a surface at <0,0,0>, size is 10 by 10 units, made up of 50 by 50 grid.
// Use function 1 and texture SurfText.

DrawSurf(<0,0,0>,<10,1,10>,<50,1,50>,1,SurfText)

