// GeneralMAcros.inc - General purpose macros

// DebugNum(N)
#macro DebugNum(Name,N)
        #debug concat(Name," ",str(N,0,4),"\n")
#end
        
// DebugVect(N)
#macro DebugVect(Name,N)
        #debug concat(Name," <",str(N.x,0,4),",",str(N.y,0,4),",",str(N.z,0,4),">\n")
#end
        

// Interp - Interpolates between two values or vectors
//   T:  Control value - Assumed to be between 0 - 1
//   P1: Initial value (may be float, vector or color)
//   P2: Final value (may be float, vector or color)
//   Result is a value between P1 and P2 in the same proportion
//    as T is between 0 and 1.
#macro Interp(T,P1,P2)
   (((1.0-T)*P1)+(T*P2))
#end

// Limit - Creates a sub-range of a value
//   T: Input value - Assumed to be between 0 - 1
//   L0: Lower limit
//   L1: Upper limit
//   Result is interpolated between 0 - 1 in the proportion of T between L0 - L1. 0 below L0, 1 above L1
#macro Limit(T,L0,L1)
        (T<L0?0:T>L1?1:(T-L0)/(L1-L0))
#end

// Loop - Causes a value to repeat
//   T: Input value - Assumed to be between 0 - 1
//   N: Number of times to loop value
//   Return value varies from 0 - 1 N times as T varies from 0 - 1
#macro Loop(T,N)
        (mod(T*N,1.0))
#end

// Bounce - Good for ball animations
// T: Input value - Assumed to be between 0 - 1
// Returns 0 - 1 for T = 0 - 0.5, 1 - 0 for T = 0.5 - 1
#macro Bounce(T)
        (1-abs((T*2)-1))
#end

// Sine - Makes the value start and end slowly
// T: Input value - Assumed to be between 0 - 1
// Returns sin function between 0 - 1 with wavelength of 1.
#macro Sine(T)
        ((cos(pi*T)*-0.5)+0.5)
#end

// Offset - Shifts the value
// T: Input value - Assumed to be between 0 - 1
// O: Offset
// Returns T+O, values greater than 1 are wrapped around to 0
#macro Offset(T,O)
        (mod(T+O,1.0))
#end

