
  // An example scene file that show reflective caustics using the unnoficial
  // Nathan Kopp Photon Tracing Patch of the Persistence of Vision Raytracer
  // version 3.1d 

  // File created by Ken Tyler tylereng@pacbell.net created 03-22-1999
  // You are free to do with this as you wish.

  /****  This file requires the accompaning include file sphere.inc ***/

  // The Disco Ball Finish and texture
  #declare SF  = finish{metallic 1 ambient .1 diffuse .2 reflection 1 
                 brilliance 3 specular .7 roughness .001}
 
  #declare Tex = texture{pigment{rgb<.91,.92,.98>}finish{SF}}


  //  This is used to sheild the light sources so they don't flood out the
  //  scene. It is just an open tube with a solid cap on one end to keep
  //  the light from coming out both ends. If you make this diameter to
  //  large you will over shoot the Disco Ball and flood out the walls
  //  with bright light. You might overcome this by increasing the diameter
  //  of the sphere but you will be hitting fewer facets by each spot light
  //  resulting in fewer individual reflections from the surfae of the sphere.
   

  #declare Pinhole =
  union{
  cylinder{<0,.85,0>,<0, 1,0>,0.0060 pigment{rgb 1}}
  cylinder{<0,-.1,0>,<0,.9,0>,0.0059 open pigment{rgb 1}}
  photons{ignore_photons}}


  //  A set of multicolored micro spotlights 
  //  white, red, yellow, green, blue
  //  They are arranged in clusters but spread apart a small amount
  //  so as to give more coverage of the Disco balls surface.
  //  The set up as it is places the lights at x,z *0 and is positioned
  //  in the positive Y direction. This allows you to rotate around the
  //  origin giving uniform distances between each light source and the
  //  surface of the sphere.

  #declare Set =
  union       {
  object      {Pinhole translate<   0,  8.8,    0>}
  object      {Pinhole translate<-.30,  8.8,  .30>}
  object      {Pinhole translate<-.30,  8.8, -.30>}
  object      {Pinhole translate< .30,  8.8, -.30>}
  object      {Pinhole translate< .30,  8.8,  .30>}

  light_source{ <   0, 9.0,   0>rgb<1.8,1.8,1.8>
       photons{reflection on refraction off     }}
  light_source{ <-.30, 9.0, .30>rgb<1.8,  0,  0>
       photons{reflection on refraction off     }}
  light_source{ <-.30, 9.0,-.30>rgb<  0,1.8,  0>
       photons{reflection on refraction off     }}
  light_source{ < .30, 9.0,-.30>rgb<  0,  0,1.8>
       photons{reflection on refraction off     }}
  light_source{ < .30, 9.0, .30>rgb<1.8,1.8,  0>
       photons{reflection on refraction off     }}}


  // Position each set of lights around the globe  

  object{Set scale<1,1,1>translate<0,0,0>rotate   0* x}
  object{Set scale<1,1,1>translate<0,0,0>rotate  90* z}
  object{Set scale<1,1,1>translate<0,0,0>rotate  85*-z}
  object{Set scale<1,1,1>translate<0,0,0>rotate  90* x}
  object{Set scale<1,1,1>translate<0,0,0>rotate  85*-x}
  object{Set scale<1,1,1>translate<0,0,0>rotate 135* x}

  // Make a seperate set to rotate *y for more coverage
 
  union { 
  object{Set scale<1,1,1>translate<0,0,0>rotate 125*-z}
  object{Set scale<1,1,1>translate<0,0,0>rotate  90* z}
  object{Set scale<1,1,1>translate<0,0,0>rotate  95*-z}
  object{Set scale<1,1,1>translate<0,0,0>rotate  90* x}
  object{Set scale<1,1,1>translate<0,0,0>rotate  95* x}rotate 22.5*y}


  // The global settings for the photon process and camera location

  global_settings{photons{gather 20,100 radius .2 2,.2  jitter .4 autostop 6}}

  camera{location<-24,0,0>look_at<0,0,0>}



  // The globe object is in the file sphere.inc. It is a mesh object that
  // is in the shape of a 1/4 sphere. To make a sphere requires four pieces
  // The object named in sphere.inc is "Quarter"

  #include "sphere.inc"

  // Make a hemisphere shape
  #declare Half =   union {
                   object { Quarter              }
                   object { Quarter rotate 180*y }}

  // Make a full sphere shape
  #declare Sphere = union {
                   object { Half              }
                   object { Half rotate 180*z }}


  // Declare the Disco Ball object

  #declare DiscoBall = object { Sphere hollow }


  // The final Disco Ball object with the parmeters for the photon
  // density and surface reaction properties described 
  object { 
    DiscoBall
      scale 1.75
        texture { Tex 
                      }
      photons { density .02 reflection on refraction off }
  }


  // A simple box object for the light to bounce off of

  #declare Ft = finish { ambient .1 diffuse 1 reflection .01 }

  box { <-26,-16,-26>,<26,16,26>
   pigment { rgb 1 }
     finish { Ft }
       hollow photons { reflection on }
  }



  // A Bonus hemisphere creating Macro script. You may or may
  // not find it useful for this process. It depends on your needs.
  // It does make a nicely faceted half sphere object.

   /*
    Macro Parameters <=> macro Dome(BoxSize, Radius, F, T) 

    <x,y,z> = Scale box you wish to use for each face. Keep "x" box
              scale 1/10 of other two dmensions for best results
    Radius  = radius of dome you wish to create
          F = filter amount for color map
          T = transmit amount for color map

       There are limitations with this macro due mostly to using a 3D box
    as a shape to describe a curved surface. There are going to be corners
    sticking out in odd places and gaps formed between the pieces where
    the box thickness or height or width is greater than the curvature
    of the area they are forming.
       There is also a problem with the first row of bozes at the equator.
    These need to be centered for in the y direction for the formula to
    properly form the first 90 degree arc. If the box used were translated
    so that the bottom edge was at y*0 then you would have one box to many
    at the top. The reason this is a limition is because you can't make a
    perfectly spherical shape. You  would think that you could make a
    sphere by taking two halfs of the object, invert one, then combine the
    two objects together to make a perfectly spherical shape. Unfortunatly
    if you try you will find youself with the first row on each half over
    lapping each other by 50%.
    */



  /*
  #macro Dome(BoxSize,Radius)
   union {
    #local ZCount  = int(Radius*pi* 2/BoxSize.z);
    #local VCount  = int(Radius*pi*.5/BoxSize.y);
      #local  ZRot=0;
      #while (ZRot<VCount)
         #local  YRot =0; 
         #while (YRot<=ZCount)
          #local ZAngle=ZRot*90/VCount;
           box {<-.55,-.56,-.56>,<.55,.56,.56>
             scale BoxSize                      // Scale Box Object
             translate -x*Radius                // Translate away from origin
             scale <1, 1, cos(radians(ZAngle))> // Scale each box smaller
             rotate -z*ZAngle                   // Rotate up and right
             rotate y*YRot*360/ZCount           // Rotate 360 to form dome
            } // end box
       #local YRot = YRot+1;
       #end // end YRot
     #local ZRot = ZRot+1;
     #end // end ZRot
    }    // end union
  #end  // end macro
      */

