/*

    Custom Solids v1.0 - include file
    Copyright (C) 1998 Spider
    
    Here's the deal, use it at your own risk... (I don't know if your hdd will fry or not)
    
    I can't give any support on this file, if there are questions I may asnwer them, but I'm not sure.
	If you find bugs, mail me (spider@bahnhof.se) and I'll look at it. Can't promise anything.
    If you use it in a scene, mail me, I want to know...
    If you use it in a image for a competition, an image for sale, an image on the net, give me my credits.
    If you expand this, notify me and give me a look at it...
    This is a result of much work from my part, so please, give me something in return(CREDITS!)
    
    C ya around ....
*/

/*
   Solid(Array) macro 
   Does : Creates a solid form, between the corners specified in the array
   Usage : declare an array of vectors, then call this macro from inside a object{} statement.
        Note : There must be more than 3 point in the array for this to work. (The reason should be obvious)
        #declare Solidpoints = array[5] {point1, point2, point3, point4, point5}
        object {
          Solid(Solidpoints)
          pigment { colour rgb 1 }
        }
*/
/* 
   Corner(Array, radii, Merge) macro
   Does : Create a sphere with the radius radii at each of the points in the array
        : If Merge = true, it merges the objects, if Merge= false, it makes a union.
   Usage : declare an array of vectors, then call this macro from inside a object{} statement.
        #declare Cornerpoints = array[5] {point1, point2, point3, point4, point5}
        object {
          Corner(Cornerpoints, 0.4)
          pigment { colour rgb 1 }
        }
*/
/* 
   Wire(Array, radii, Merge) macro
   Does : Creates a wireframe beteween the points in the array, where the thickness of each wire is radii
        : If Merge = true, it merges the objects, if Merge= false, it makes a union.
   Usage : declare an array of vectors, then call this macro from inside a object{} statement.
        #declare Wirepoints = array[5] {point1, point2, point3, point4, point5}
        object {
          Wire(Wirepoints, 0.4)
          pigment { colour rgb 1 }
        }
*/


#macro Solid(Array) //Ivoke this macro to get a custom Solid from the array
  #local n = dimension_size(Array,1)-1; //Used internally to get the highest number accessible in the array
  intersection {
    #local c1 = 0; //start at zero
    #while (c1<n) //make sure there is at least one more object
      #local c2 = c1+1;
      #while (c2<=n)  //Last vector ?
        #local c3 = c2+1;
        #while (c3<=n)
          #local norm = vcross(Array[c2]-Array[c1], Array[c3]-Array[c1]); //The normal to the points
          #local l=false;
          #local r=false;
          #local pos = 0;
          #while (pos<=n)
            #if ( (pos!=c1) & (pos!=c2) & (pos!=c3)) //not one of the used vectors
              #if (vdot(Array[pos]-Array[c1],norm)>0) //positive or negative normal ?
                #local l=true; 
              #else
                #local r=true; 
              #end //end 
            #end//End (array pos in vector)
            #local pos = pos +1;
          #end //While(array_pos<=_array_nmb)
          #if (l=false)
            plane {norm,0 translate Array[c1]}
          #end
          #if (r=false)
            plane {-norm,0 translate Array[c1]}
          #end
          #local c3=c3+1;
        #end
        #local c2=c2+1;
      #end   
      #local c1=c1+1;
    #end  //Main loop
  }
#end //Macro Solid(Array)

#macro Wire(Array, radii, Merge)
  #local n = dimension_size(Array,1)-1; //Used internally to get the highest number accessible in the array
  #if (Merge=true)
    merge{
  #else
    union{
  #end
    #local c1=0;
    #while(c1<n)
      #local c2=n;
      #while (c1<c2)
        cylinder{ Array[c1], Array[c2], radii }
        #local c2=c2-1;
      #end
      #local c1=c1+1;
    #end
  }
#end

#macro Corner(Array, radii, Merge)
  #local n = dimension_size(Array,1)-1; //Used internally to get the highest number accessible in the array
  #if (Merge=true)
    merge{
  #else
    union{
  #end
    #local c1=0;
    #while(c1<=n)
      sphere{ Array[c1], radii }
      #local c1=c1+1;
    #end
  }
#end
