/*

    Custom Solids v1.0 - include file
    Copyright (C) 1998 Spider
    
    Here's the deal, use it at your own risk... (I don't know if your hdd will fry or not)
    
    I can't give any support on this file, if there are questions I may asnwer them, but I'm not sure.
	If you find bugs, mail me (spider@bahnhof.se) and I'll look at it. Can't promise anything.
    If you use it in a scene, mail me, I want to know...
    If you use it in a image for a competition, an image for sale, an image on the net, give me my credits.
    
    This is a result of much work from my part, so please, give me something in return(CREDITS!)
    
    C ya around ....
*/
/* 
   Corner(Array, radii, Merge) macro
   Does : Create a sphere with the radius radii at each of the points in the array
        : If Merge = true, it merges the objects, if Merge= false, it makes a union.
   Usage : declare an array of vectors, then call this macro from inside a object{} statement.
        #declare Cornerpoints = array[5] {point1, point2, point3, point4, point5}
        object {
          Corner(Cornerpoints, 0.4)
          pigment { colour rgb 1 }
        }
*/


#version 3.1;
#include "colors.inc"
#include "solidate.inc"
#include "consts.inc"
#declare Rad_Quality = Radiosity_Final;
#include "RAD_DEF.INC"  // Some common radiosity settings

global_settings { 
  assumed_gamma 2.2 
  max_trace_level 20
}


camera {
   location <0, 0, -60>
   direction <0, 0,  2.85>
   right x*1.33
   look_at 0
}

light_source {<150, 50, -200> color Gray15}
light_source {<150, 50, -200> color Gray50}
light_source {<150, 75, -100> color Gray50}

plane { z, 5
    hollow on
    pigment {
      checker 
      color rgb <1, 1, 1>
      color rgb <0.5, 0.5, 0.5>
      scale <100000, 1, 1>
    }
    finish { ambient 0.45 }
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0, 1  color Gray50 color White]
    }
    rotate x*30
  }
}

#declare Pyramid_4 = array[5] { <0, 0, 0>, <1, 0, 0>, <1, 0, 1>, <0, 0, 1>, <0.5, 1, 0.5> } //4 sided pyramid. (4+bottom....)
#declare Pyramid_3 = array[4] { <0, 0, 0>, <1, 0, 0>, <0.5, 0, 1>, <0.5, 1, 0> } //3 sided pyramid. (3+bottom....)
#declare Box = array[8] {       <0,0,0>,<1,0,0>,<0,0,1>,<1,0,1>, 
                                <0,1,0>,<1,1,0>,<0,1,1>,<1,1,1>  }   //Box from <0,0,0> to <1,1,1>
#declare Box_quirk = array[8] {<0,0,0>,<1,0,0>,<0,0,1>,<1,0,1>, 
                               <0.25,1,0.25>,<0.75,1,.25>,<.25,1,.75>,<.75,1,.75>  } //Now this is an all diff matter :-)
#declare Thing = array[12] { <0.25, 0.00, 0.25>,<0.75, 0.00, 0.25>,<0.25, 0.00, 0.75>,<0.75, 0.00, 0.75>,
                             <0.00, 0.50, 0.00>,<1.00, 0.50 ,0.00>,<0.00, 0.50, 1.00>,<1.00, 0.50, 1.00>, 
                             <0.25, 1.00, 0.25>,<0.75, 1.00, 0.25>,<0.25, 1.00, 0.75>,<0.75, 1.00, 0.75> }
#declare Part1 = array[8] { <0.00, 1.00, 0.00>,<1.00, 1.00 ,0.00>,<0.00, 1.00, 1.00>,<1.00, 1.00, 1.00>, //Top
                            <0.25, 0.50, 0.25>,<0.75, 0.50, 0.25>,<0.25, 0.50, 0.75>,<0.75, 0.50, 0.75>}
#declare Part2 = array[8] { <0.25, 0.50, 0.25>,<0.75, 0.50, 0.25>,<0.25, 0.50, 0.75>,<0.75, 0.50, 0.75>, //Bottom
                            <0.00, 0.00, 0.00>,<1.00, 0.00 ,0.00>,<0.00, 0.00, 1.00>,<1.00, 0.00, 1.00>}
#declare NoPart =
merge {
  object { Corner(Part1, 0.07, false) }
  object { Corner(Part2, 0.07, false) }
}

#declare Row1 =  14;
#declare Row2 =   7;
#declare Row3 =   0;
#declare Row4 =  -7;
#declare Row5 = -14;

union {
  object {
    NoPart     
    pigment { 
      Red
      filter 0
    } 
    scale 4 
    rotate 45 
    translate <-7.0, 4, 0> 
  }
  object { 
    Corner(Box, 0.07, false)       
    pigment { 
      Green
      filter 0 
    } 
    scale 4 
    rotate 45 
    translate <+0.0, 4, 0> 
  }
  object { 
    Corner(Pyramid_4, 0.07, false) 
    pigment { 
      Blue
      filter 0
    } 
    scale 4 
    rotate 45 
    translate <+7.0, 4, 0> 
  }
  object { 
    Corner(Pyramid_3, 0.07, false) 
    pigment { 
      Yellow
      filter 0 
    } 
    scale 4 
    rotate 45 
    translate <-7.0, -4, 0> 
  }
  object { 
    Corner(Box_quirk, 0.07, false) 
    pigment { 
      Cyan
      filter 0 
    } 
    scale 4 
    rotate 45 
    translate <+0.0, -4, 0> 
  }
  object { 
    Corner(Thing, 0.07, false)
    pigment { 
      Magenta
      filter 0
    } 
    scale 4 
    rotate 45 
    translate <+7.0, -4, 0> 
  }
  translate <-1,0,0>
}
