#include "LSCUPPERLEG.inc"
#include "LSCLOWERLEG.inc"
#include "LSCFOOT.inc"


#if ( LSCWS = off )
#declare mclock = .5;
#end 

#declare clock_repeat = LSCSPD;
#declare aclock = mod(clock * clock_repeat, 1);
#if ( LSCWS = on )
#declare mclockO2 = cos(aclock * 2 * pi);
#declare mclockW2 = cos((mclock -.25) * 2 * pi) * .5 + .5;
#else
#declare mclockO2 = .5;
#declare mclockW2 = .5;
#end

#declare LEGS =
union {
union {
object {
LSCULEG
}
union {
object {
LSCLLEG
}
object {
LSCFOOT
rotate 90*x
scale <1,1,1>
#if ( LSCWS = on )
#declare clock_type = "W"
#declare clock_repeat = LSCSPD;
#include "ClockMod.inc"
#declare mclock = 1 - mclock;
rotate <7.5*mclock,0,0>
#end
#if ( LSCWS = on )
#declare clock_type = "O"
#declare clock_repeat = LSCSPD;
#include "ClockMod.inc"
#declare mclock = 1 - mclock;
#end
rotate -<(20*mclock)+70,0,0>
#if ( LSCWS = on )
#declare clock_type = "W"
#declare clock_repeat = LSCSPD;
#include "ClockMod.inc"
#declare mclock = 1 - mclock;
#end
rotate -<(45*mclock)+15,0,0>
translate <14-8,49.5-22,.5>
}
#if ( LSCWS = on )
#declare clock_type = "O"
#declare clock_repeat = LSCSPD;
#include "ClockMod.inc"
#declare mclock = 1 - mclock;
#end
rotate <(20*mclock)+70,0,0>
translate <8,22,0>
}
#if ( LSCWS = on )
#declare clock_type = "W"
#declare clock_repeat = LSCSPD;
#include "ClockMod.inc"
#declare mclock = 1 - mclock;
#end
rotate <90,0,0>
rotate <(45*mclock)+15,0,0>
scale .75
translate <1,10,4>
scale <1,1,1>
}

union {
object {
LSCULEG
}
union {
object {
LSCLLEG
}
object {
LSCFOOT
rotate 90*x
scale <1,1,1>
#if ( LSCWS = on )
rotate <7.5*mclockW2,0,0>
#end
rotate -<(20*mclockO2)+70,0,0>
rotate -<(45*mclockO2)+15,0,0>
translate <14-8,49.5-22,.5>
}
rotate <(20*mclockO2)+70,0,0>
translate <8,22,0>
}
rotate <90,0,0>
rotate <(45*mclockW2)+15,0,0>
scale .75
translate <1,10,4>
scale <-1,1,1>
}
}