#include "LSCDECLARES.inc"

#declare clock_repeat = LSCSPD ;
#declare LSCATT = -LSCTT;

#if ( LSCWS = off )
#declare mclock = .5;
#end 

#declare clock_repeat = LSCSPD;
#declare aclock = mod(clock * clock_repeat, 1);
#if ( LSCWS = on )
#declare mclockO2 = cos(aclock * 2 * pi);
#declare mclockW2 = cos((aclock -.25) * 2 * pi) * .5 + .5;
//Walking Wave
#declare mclockWalk = cos((aclock -.25) * 2 * pi) * .5 + .5;
#else
#declare mclockO2 = .5;
#declare mclockW2 = .5;   
#declare mclockWalk = .5;
#end

#declare LSC =
union {
#include "LSCCOCKPIT.inc"
union {
union {COCKPIT}
#if (LSCTOPGUN = 1)
#include "AUTOCANNON.inc"
union {AutoCannon scale <1.5,1.5,1.5> translate <0,18,5>}  
#end
#if (LSCTOPGUN = 2)
#include "FBC.inc"
union {FussionBoltCannon translate <0,18,5>} 
#end
#if (LSCBOTGUN = 1)
#include "AUTOCANNON.inc"
union {AutoCannon scale <1.5,-1.5,1.5> translate <0,3.5,-1>}  
#end
#if (LSCBOTGUN = 2)
#include "FBC.inc"
union {FussionBoltCannon scale <1,-1,1> translate <0,3.5,-1>} 
#end
#if (LSCWS = on)
rotate <-15*mclockWalk,0,0>
#end
}
#include "LSCLEGS2.inc"
union {LEGS}
texture {A_Tex}
#if (LSCWS = on)
translate <0,10*mclockWalk,0>
#declare clock_type = "W"
#declare clock_repeat = LSCSPD;
#include "ClockMod.inc"
translate <0,10*mclock,0>
translate -2*y
#end
hollow on
translate (27.75*.75)*y
}